/* -*- c++ -*- */
#ifndef _eventtestbox_h_
#define _eventtestbox_h_
#include <vdk/vdk.h>

/* Widget for monitoring events
   This widget consists of three elements: A pane receiving the events,
   an array of indicators, showing what event occured and an array of
   checkbuttons to specify what events looking for.
 */
class EventTestBox : public VDKBox
{
 private:
     VDKRgb _bp_color;
     VDKRgb _br_color;
     VDKRgb _kp_color;
     VDKRgb _kr_color;
     VDKRgb _mk_color;
     VDKRgb _mp_color;
     VDKRgb _rp_color;
     VDKRgb _cl_color;

     VDKCanvas* _event_area;
     VDKEntry* _any_entry;

     VDKCheckButton* _mk_btn;
     VDKCheckButton* _mp_btn;
     VDKCheckButton* _any_btn;
     VDKCheckButton* _kp_btn;
     VDKCheckButton* _kr_btn;
     VDKCheckButton* _bp_btn;
     VDKCheckButton* _br_btn;
     VDKCheckButton* _rp_btn;
     VDKCheckButton* _cl_btn;

     VDKCustomButton* _clear_btn;
     VDKCustomButton* _setup_btn; 

     Connection _kp_con;
     Connection _kr_con;
     Connection _bp_con;
     Connection _br_con;
     Connection _mk_con;
     Connection _mp_con;
     Connection _any_con;
     Connection _rp_con;
     Connection _cl2_con;
     Connection _cl3_con;

     bool _any_flag;
     bool _bp_flag;
     bool _br_flag;
     bool _kp_flag;
     bool _kr_flag;
     bool _mk_flag;
     bool _mp_flag;
     bool _rp_flag;
     bool _cl_flag;

     void any_handler(VDKObject*, const GdkEvent*);
     void mk_handler(VDKObject*, const VDKMouseEvent&);
     void mp_handler(VDKObject*, const VDKMouseEvent&);
     void kp_handler(VDKObject*, const VDKKeyEvent&);
     void kr_handler(VDKObject*, const VDKKeyEvent&);
     void bp_handler(VDKObject*, const VDKMouseEvent&);
     void br_handler(VDKObject*, const VDKMouseEvent&);
     void rp_handler(VDKObject*, const VDKPaintEvent&);
     void cl2_handler(VDKObject*, const VDKMouseEvent&);
     void cl3_handler(VDKObject*, const VDKMouseEvent&);

     void any_connect(bool mode);
     void kp_connect(bool mode);
     void kr_connect(bool mode);
     void bp_connect(bool mode);
     void br_connect(bool mode);
     void mp_connect(bool mode);
     void mk_connect(bool mode);
     void rp_connect(bool mode);
     void cl_connect(bool mode);

     VDKObject* _cw;
 public:
     EventTestBox(VDKForm*);
     void Setup();
     VDKSignal1<void, const char*> OnMesg;
};

// class MouseSetupDlg : public VDKForm
// {
// };
#endif /* _eventtestbox_h_ */


