/*
* Copyright (c) 2010, University of Szeged
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
* - Redistributions in binary form must reproduce the above
* copyright notice, this list of conditions and the following
* disclaimer in the documentation and/or other materials provided
* with the distribution.
* - Neither the name of University of Szeged nor the names of its
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
* COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
* Author: Krisztian Veress
*         veresskrisztian@gmail.com
*/

#if defined(TOSSIM) && ! defined(MHZ)
  #define MHZ 8
#endif

configuration CodeProfileC {
  provides {
    interface StdControl;
    interface CodeProfile;
  }
}

implementation {

  #if defined(CONTROLLER_ATM128)
    components new AlarmMicro32C() as Alarm;
  
  #elif defined(CONTROLLER_MSP430)
    components Msp430CounterMicroC as Counter16;
    components new AlarmMicro16C() as Alarm16;
    
    components new TransformCounterC(TMicro,uint32_t,TMicro,uint16_t,0,uint32_t) as TCounter;
    TCounter.CounterFrom -> Counter16;
    
    components new TransformAlarmC(TMicro,uint32_t,TMicro,uint16_t,0) as Alarm;
    Alarm.AlarmFrom -> Alarm16;
    Alarm.Counter -> TCounter;

  #endif

  components CodeProfileP;
  CodeProfileP.Alarm -> Alarm;
  
  StdControl = CodeProfileP;
  CodeProfile = CodeProfileP;
}
