; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP32
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -mattr=+fp64,+mips32r2 -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP64

define float @float_in_fpr(float %a, float %b) {
; MIPS32-LABEL: float_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    mov.s $f0, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  ret float %b
}

define double @double_in_fpr(double %a, double %b) {
; MIPS32-LABEL: double_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    mov.d $f0, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  ret double %b
}

define float @float_in_gpr(i32 %a, float %b) {
; MIPS32-LABEL: float_in_gpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    mtc1 $5, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  ret float %b
}

define double @double_in_gpr(i32 %a, double %b) {
; FP32-LABEL: double_in_gpr:
; FP32:       # %bb.0: # %entry
; FP32-NEXT:    mtc1 $6, $f0
; FP32-NEXT:    mtc1 $7, $f1
; FP32-NEXT:    jr $ra
; FP32-NEXT:    nop
;
; FP64-LABEL: double_in_gpr:
; FP64:       # %bb.0: # %entry
; FP64-NEXT:    mtc1 $6, $f0
; FP64-NEXT:    mthc1 $7, $f0
; FP64-NEXT:    jr $ra
; FP64-NEXT:    nop
entry:
  ret double %b
}

define float @call_float_in_fpr(float %a, float %b) {
; MIPS32-LABEL: call_float_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal float_in_fpr
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %call = call float @float_in_fpr(float %a, float %b)
  ret float %call
}

define double @call_double_in_fpr(double %a, double %b) {
; MIPS32-LABEL: call_double_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal double_in_fpr
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %call = call double @double_in_fpr(double %a, double %b)
  ret double %call
}

define float @call_float_in_gpr(i32 %a, float %b) {
; MIPS32-LABEL: call_float_in_gpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal float_in_gpr
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %call = call float @float_in_gpr(i32 %a, float %b)
  ret float %call
}


define double @call_double_in_gpr(i32 %a, double %b) {
; MIPS32-LABEL: call_double_in_gpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal double_in_gpr
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %call = call double @double_in_gpr(i32 %a, double %b)
  ret double %call
}
