/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LISTCMD_H
#define _SC_LISTCMD_H

// sc
#include "ScCmd.h"
#include "svn/DirEntryTypes.h"
class ListParam;
class CmdResultCallback;

/**
 * Command for listing a repository.
 */
class ListCmd : public ScCmd
{
public:
  /**
   * Construct a ListCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  ListCmd( ListParam* param, CmdResultCallback* cb );
  ~ListCmd();

  void run();

private:
  // in
  ListParam*         _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_LISTCMD_H
