/* ====================================================================
 * Copyright (c) 2006-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHCANVASVIEW_H
#define _SC_LOGGRAPHCANVASVIEW_H

// sc
class LogGraphCanvasItem;
class ActionStorage;

// qt
#include <Qt3Support/Q3Canvas>
class QMenu;


class LogGraphCanvasView : public Q3CanvasView
{
  typedef Q3CanvasView super;
  Q_OBJECT;

public:
  LogGraphCanvasView( QWidget* parent = 0 );
  virtual ~LogGraphCanvasView();

  bool event( QEvent* e );
  void mousePressEvent( QMouseEvent* e );
  void mouseMoveEvent( QMouseEvent* e );
  void contextMenuEvent( QContextMenuEvent* e );
  void keyPressEvent( QKeyEvent* e );
  void keyReleaseEvent( QKeyEvent* e );

  const LogGraphCanvasItem* getSelection1() const;
  const LogGraphCanvasItem* getSelection2() const;

  const QString& getRoot() const;
  void setRoot( QString& root );

public slots:
    void diffTrigger();

signals:
  void diffRequested();
  void selectionChanged(bool);

private:
  void addSelection( LogGraphCanvasItem* item );
  void clearSelection();
  QString getTooltip( const QPoint& pos );

private:
  ActionStorage*      _actions;
  QMenu*              _popup;
  bool                _shiftDown;
  QString             _root;

  LogGraphCanvasItem* _sel1;
  LogGraphCanvasItem* _sel2;
};

#endif // _SC_LOGGRAPHCANVASVIEW_H
