/*
 * Decompiled with CFR 0.152.
 */
package adql.parser.feature;

import adql.db.FunctionDef;
import java.util.Objects;

public final class LanguageFeature {
    public final String id;
    public final String type;
    public final String form;
    public final FunctionDef udfDefinition;
    public final boolean optional;
    public String description;
    public static final String IVOID_TAP_REGEXT = "ivo://ivoa.net/std/TAPRegExt";
    public static final String TYPE_UDF = "ivo://ivoa.net/std/TAPRegExt#features-udf";
    public static final String TYPE_ADQL_GEO = "ivo://ivoa.net/std/TAPRegExt#features-adqlgeo";
    public static final String TYPE_ADQL_STRING = "ivo://ivoa.net/std/TAPRegExt#features-adql-string";
    public static final String TYPE_ADQL_SETS = "ivo://ivoa.net/std/TAPRegExt#features-adql-sets";
    public static final String TYPE_ADQL_COMMON_TABLE = "ivo://ivoa.net/std/TAPRegExt#features-adql-common-table";
    public static final String TYPE_ADQL_TYPE = "ivo://ivoa.net/std/TAPRegExt#features-adql-type";
    public static final String TYPE_ADQL_CONDITIONAL = "ivo://ivoa.net/std/TAPRegExt#features-adql-conditional";
    public static final String TYPE_ADQL_UNIT = "ivo://ivoa.net/std/TAPRegExt#features-adql-unit";
    public static final String TYPE_ADQL_BITWISE = "ivo://ivoa.net/std/TAPRegExt#features-adql-bitwise";
    public static final String TYPE_ADQL_OFFSET = "ivo://ivoa.net/std/TAPRegExt#features-adql-offset";

    public LanguageFeature(String type, String form) throws NullPointerException {
        this(type, form, false, null);
    }

    public LanguageFeature(String type, String form, boolean optional) throws NullPointerException {
        this(type, form, optional, null);
    }

    public LanguageFeature(String type, String form, boolean optional, String description) throws NullPointerException {
        this(type, form, null, optional, description);
    }

    public LanguageFeature(FunctionDef udfDef) throws NullPointerException {
        this(udfDef, null);
    }

    public LanguageFeature(FunctionDef udfDef, String description) throws NullPointerException {
        this(TYPE_UDF, udfDef.toString(), udfDef, true, (String)(description == null ? udfDef.description : (description.trim().isEmpty() ? null : description)));
    }

    private LanguageFeature(String type, String form, FunctionDef udfDef, boolean optional, String description) throws NullPointerException {
        String string = this.type = type == null || type.trim().isEmpty() ? null : type.trim();
        if (form == null || form.trim().isEmpty()) {
            throw new NullPointerException("Missing form/name of the language feature to create!");
        }
        this.form = form.trim();
        if (TYPE_UDF.equals(this.type) && udfDef == null) {
            throw new NullPointerException("Missing UDF definition! To declare a UDF feature, you MUST use the constructor LanguageFeature(FunctionDef, ...) with a non-NULL FunctionDef instance.");
        }
        this.udfDefinition = udfDef;
        this.id = (this.type == null ? "" : this.type) + "!" + this.form;
        this.optional = optional;
        this.description = description == null || description.trim().isEmpty() ? null : description.trim();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LanguageFeature) {
            if (TYPE_UDF.equals(this.type) && this.type.equals(((LanguageFeature)obj).type)) {
                FunctionDef udfDefinition2 = ((LanguageFeature)obj).udfDefinition;
                return this.udfDefinition.name.equalsIgnoreCase(udfDefinition2.name) && this.udfDefinition.nbParams == udfDefinition2.nbParams;
            }
            if (this.id.equals(((LanguageFeature)obj).id)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.udfDefinition != null) {
            return Objects.hash(this.type, this.udfDefinition.name.toLowerCase(), this.udfDefinition.nbParams);
        }
        return Objects.hash(this.type, this.form, -1);
    }

    public String toString() {
        return this.id;
    }
}

