-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK_IO;
--# inherit CommandLineData,
--#         ExaminerConstants,
--#         SPARK_IO,
--#         SystemErrors;
package Statistics
--# own TableUsage : Table_Usage_Array;
--# initializes TableUsage;
is
   type Table_Type is (RelationTable,
                       VCGHeap,
                       StringTable,
                       SymbolTable,
                       SyntaxTree,
                       RecordFields,
                       RecordErrors);

   procedure SetTableUsage (Table : in Table_Type;
                            Size  : in Natural);
   --# global in out TableUsage;
   --# derives TableUsage from *,
   --#                         Size,
   --#                         Table;

   procedure WriteOutput (File : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in     TableUsage;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                File,
   --#                                TableUsage;

end Statistics;
