2.2 Paramètres des synthés

# Paramètres des synthés : Amp and Pan

De la même manière qu'il vous permet de contrôler chaque note ou chaque 
échantillon à jouer, Sonic Pi fournit un large éventail de paramètres pour 
confectionner ou contrôler les sons. Nous couvrirons beaucoup d'entre eux 
dans ce tutoriel et il y a une documentation exhaustive pour chacun d'eux 
dans le système d'aide. Toutefois pour l'instant, nous allons introduire 
deux des plus utiles : *amplitude* et *pan*. Regardons en premier ce que 
les paramètres sont réellement.


## Paramètres

Sonic Pi supporte la notion de paramètres pour ses synthés. Les paramètres
sont des informations de contrôle que vous passez à `play` et qui modifient
et contrôlent les aspects du son que vous entendez. Chaque synthé a son propre
jeu de paramètres pour ajuster finement ses sons. Cependant, il y a un
ensemble commun de paramètres partagés par beaucoup de sons comme `amp:` et
les paramètres d'enveloppe (couverts dans une autre section).

Les paramètres ont deux parties principales, leur nom (le nom du contrôle)
et leur valeur (la valeur que vous voulez affecter au contrôle). Par exemple,
vous pourriez avoir un paramètre appelé `cheese:` et vouloir lui affecter
la valeur `1`.

Les paramètres sont passés aux appels à `play` en utilisant une virgule `,`
et ensuite le nom du paramètre comme `amp:` (n'oubliez pas les deux-points
`:`) et ensuite un espace et la valeur du paramètre. Par exemple :

```
play 50, cheese: 1
```

(Notez que `cheese:` n'est pas un paramètre valide, il est juste utilisé
pour l'exemple).

Vous pouvez passer plusieurs paramètres en les séparant par une virgule :

```
play 50, cheese: 1, beans: 0.5
```

L'ordre des paramètres n'est pas imposé, ainsi, ce qui suit est identique :

```
play 50, beans: 0.5, cheese: 1
```

Les paramètres qui ne sont pas reconnus par le synthé sont simplement ignorés
(comme `cheese` et `beans` qui sont clairement des noms de paramètres ridicules !)

Si vous utilisez accidentellement 2 fois le même paramètre avec des valeurs
différentes, la dernière gagne. Par exemple, `beans:` aura ici la valeur 2
plutôt que 0.5 :

```
play 50, beans: 0.5, cheese: 3, eggs: 0.1, beans: 2
```

Beaucoup de choses dans Sonic Pi acceptent des paramètres, aussi passez
un peu de temps à apprendre comment les utiliser et vous serez au point !
Jouons avec notre premier paramètre : `amp:`.

## Amplitude

L'amplitude est la représentation informatique du volume d'un son. Une
*amplitude élevée produit un son fort* et une *amplitude basse produit
un son faible*. A la manière dont Sonic Pi utilise des nombres pour
représenter les durées et les notes, des nombres sont aussi utilisés pour
représenter l'amplitude. Une amplitude 0 est le silence (vous n'entendez
rien) tandis qu'une amplitude de 1 désigne le volume normal. Vous pouvez
monter l'amplitude à 2, 10, 100. Toutefois, vous devez noter que lorsque
l'amplitude globale de tous les sons devient trop élevée, Sonic Pi
utilise ce qui est appelé un compresseur pour l'aplatir, de manière
à s'assurer que le volume ne soit pas trop fort pour vos oreilles.
Cela peut fréquemment rendre le son distordu et étrange. Aussi essayez
d'utiliser des amplitudes basses, c'est-à-dire dans l'intervalle 0 à 0.5
pour éviter la compression.


## Amp-ez le

Pour changer l'amplitude d'un son, vous pouvez utiliser le paramètre
`amp:`. Par exemple, pour jouer à moitié amplitude, passez 0.5 :

```
play 60, amp: 0.5
```

Pour jouer à double amplitude, passez 2 :

```
play 60, amp: 2
```

Le paramètre `amp:` ne modifie que l'appel au `play` auquel il est associé.
Aussi, dans l'exemple suivant, le premier appel à play est à moitié
volume et le second revient à la valeur par défaut (1) :

```
play 60, amp: 0.5
sleep 0.5
play 65
```

Bien entendu, vous pouvez utiliser différentes valeurs de `amp:` pour
chaque appel à play :

```
play 50, amp: 0.1
sleep 0.25
play 55, amp: 0.2
sleep 0.25
play 57, amp: 0.4
sleep 0.25
play 62, amp: 1
```

## Balance stéréo

Un autre paramètre agréable à utiliser est `pan:` qui contrôle la
balance du son en stéréo. Balancer un son vers la gauche signifie que
votre oreille va l'entendre sortir du haut-parleur de gauche, et le
balancer vers la droite que vous l'entendrez sortir par le haut-parleur
de droite. Pour nos valeurs, nous utilisons -1 pour représenter
complètement à gauche, 0 pour représenter le centre et 1 pour représenter
complètement à droite dans le champ stéréo. Bien entendu, vous êtes libre
d'utiliser toute valeur entre -1 et 1 pour contrôler le positionnement
précis de votre son.


Jouons un beep à destination du haut-parleur de gauche :

```
play 60, pan: -1
```

Maintenant, jouons-le à destination du haut-parleur de droite :

```
play 60, pan: 1
```

Finalement, jouons-le à destination du centre des deux (la position
par défaut) :

```
play 60, pan: 0
```

Maintenant, allez et prenez plaisir à changer l'amplitude et la balance
de vos sons !
