
/*
 * slmon
 *
 * Copyright (C) 2000, 2001, 2002 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 * $Date: 2004/06/20 15:56:48 $
 * $Revision: 1.2 $
 *
 */

#include "rc.h"
#include "stat.h"

int slmon_getconf(const struct slmon_conf conf[], const char *key)
{
    size_t i = 0;
    while (conf[i].name != NULL && conf[i].val != 0) {
	if (!strcmp(key, conf[i].name))
	    return conf[i].val;
	i++;
    }
    return 0;
}

char *slmon_strip(char *string)
{
    int i = 0, j;
    char *result, *tmp;

    while (isspace(string[i]))
	i++;
    tmp = string + i;
    if (!(j = strlen(tmp)))
	return NULL;

    while (isspace(tmp[j - 1]))
	j--;

    result = calloc(j + 1, 1);
    strncpy(result, tmp, j);

    return result;
}

char *slmon_split(char *str, char sep, int *pos)
{
    int i = 0, j = 0, len;
    char *tmp, *key;

    len = strlen(str);
    tmp = calloc(len, 1);

    while (i < len && str[i] != sep) {
	tmp[j++] = str[i];
	i++;
    }

    i++;

    if (i >= len) {
	free(tmp);
	return NULL;
    }

    j = 0;

    while (isspace(str[i++]));

    key = slmon_strip(tmp);
    free(tmp);
    *pos = i - 1;

    return key;
}

int slmon_conf_parse(FILE * f)
{
    char line[1024];
    char *tmp, *key, c;
    int pos, len1;

    while (fgets(line, 1024, f)) {
	tmp = slmon_strip(line);
	if (tmp) {
	    if (tmp[0] != '#') {
		if ((key = slmon_split(tmp, '=', &pos)) == NULL)
		    continue;
		c = slmon_getconf(rc_conf, key);
		switch (c) {
		case 'd':
		    switch (tolower(tmp[pos])) {
		    case 'm':
			mode = MODE_M;
			break;
		    case 'p':
			mode = MODE_P;
			break;
		    case 'n':
			mode = MODE_N;
			break;
		    case 'h':
			mode = MODE_H;
			break;
		    }
		    break;
		case 'm':
		    switch (tolower(tmp[pos])) {
		    case 'b':
			conf.mem = 0;
			break;
		    case 'k':
			conf.mem = 1;
			break;
		    case 'm':
			conf.mem = 2;
			break;
		    case 'g':
			conf.mem = 3;
			break;
		    }
		    break;
		case 'f':
		    switch (tolower(tmp[pos])) {
		    case 'k':
			conf.fs = 0;
			break;
		    case 'm':
			conf.fs = 1;
			break;
		    case 'g':
			conf.fs = 2;
			break;
		    }
		    break;
		case 'n':
		    switch (tolower(tmp[pos])) {
		    case 'b':
			conf.net = 0;
			break;
		    case 'k':
			conf.net = 1;
			break;
		    case 'm':
			conf.net = 2;
			break;
		    case 'g':
			conf.net = 3;
			break;
		    }
		    break;
		case 'v':
		    len1 = strlen(tmp + pos);
		    conf.iface = (struct slmon_net *) slmon_net_append(conf.iface, tmp + pos);
		    break;
		case 't':
		    update_time = (unsigned long) (atof(tmp + pos) * 1000000.0);
		    update_time -= (unsigned long) 10000;
		}
		free(key);
	    }
	    free(tmp);
	}
	bzero(line, 1024);
    }
    return 0;
}

int slmon_read_conf(void)
{
    FILE *f;
    char *home, dotrc[1024] = { 0 };

    home = getenv("HOME");
    strcpy(dotrc, home);
    strcat(dotrc, "/.slmonrc");
    free(home);

    if ((f = fopen("/etc/slmonrc", "r")) != NULL) {
	slmon_conf_parse(f);
	fclose(f);
    } else if ((f = fopen("/usr/local/etc/slmonrc", "r")) != NULL) {
	slmon_conf_parse(f);
	fclose(f);
    }

    if ((f = fopen(dotrc, "r"))) {
	slmon_conf_parse(f);
	fclose(f);
    }
    return 0;
}

//int slmon_write_conf(struct slmon_conf conf[])
