#ifndef INCLUDED_MAMMO_
#define INCLUDED_MAMMO_

#include "../enums/enums.h"
#include "../modbase/modbase.h"
#include "../agegroupvsd/agegroupvsd.h"

//Mammo:
//    costs:          64   
//
//    systematicError:  0.1   
//
//    Dose:           
//      #            mean   spread    dist
//      bi-rad: a     3       1       Normal
//      bi-rad: b     3       1       Normal
//      bi-rad: c     3       1       Normal
//      bi-rad: d     3       1       Normal
//
//     M: 
//      #            proportion   spread      dist    
//      bi-rad: a      .061        .021       Normal
//      bi-rad: b      .163        .045       Normal
//      bi-rad: c      .400        .106       Normal
//      bi-rad: d      .826        .088       Normal
//
//     Beta:
//      #         mean    spread      dist
//      nr: 1     -4.38    .002       Normal
//      nr: 2       .49    .0005      Normal
//      nr: 3     -1.34    .0074      Normal
//      nr: 4     -7.18    .0340      Normal
//
//    Specificity:
//      #           range      proporion   spread  dist
//      ageGroup:   0 - 40     .961        .005    Normal
//      ageGroup:  40 - *      .965        .005    Normal


class Tumor;

class Mammo: public ModBase
{
    Tumor const &d_tumor;

    double d_sysErr;

    StringVect d_base;

    VSDvect d_dose;
    VSDvect d_m;
    VSDvect d_beta;

    AgeGroupVSDvect d_specVect;

    public:
        Mammo(Tumor const &tumor);
        ~Mammo() override;

    private:
        void setSystematicError();

        void setBeta();
        void setM();

        VSDvect const *vDose() const override;              // 1
        double vDose(uint16_t) const override;              // 2
        void vInsert(std::ostream &out) const override;
        double vSensitivity(size_t idx) const override;
        double vSpecificity(double age) const override;
        void vVary(std::ostream &out) override;

};

//Modalities:
//
//  Mammo:
//      costs:          64   
//
//      #      bi-rad:  a       b       c       d             
//      dose:           3       3       3       3  
//      m:             .136    .136    .136    .136
//
//      #             ageGroup
//      specificity:  0 - 40:  .961     40 - *: .965
//
//      #       1       2       3        4    
//      beta:  -4.38    .49     -1.34    -7.18
//
//      systematicError:  0.1



#endif
