/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef HDB_MPC_H
#define HDB_MPC_H

namespace HDB {

#define		TILE_TELEPORT1					"anim_t32_teleporter1"
#define		TILE_TOUCHPLATE_OFF				"t32_touchplateoff"
#define		TILE_TOUCHPLATE_ON				"t32_touchplateon"
#define		TILE_SKY_STARS					"t32_sky_stars"
#define		TILE_HOLDER1					"anim_t32_holder_empty1"
#define		TILE_HOLDERFULL					"t32_holder_full"
#define		TILE_SWITCH1					"anim_t32_switch_off01"
#define		TILE_1SWITCH1					"anim_t32_1switch_off01"
#define		TILE_DOOR_N						"t32_door_n_1"
#define		TILE_DOOR_P						"t32_door_p_1"
#define		TILE_DOOR_S						"t32_door_s_1"
#define		TILE_ASKCOMP1					"anim_t32_askcomp1"
#define		TILE_BRIDGE_U					"t32_bridgeup1"
#define		TILE_SWITCH_ON					"t32_switch_on"
#define		TILE_1SWITCH_ON					"t32_1switch_on"
#define		TILE_BRIDGE_R					"t32_bridgeright1"
#define		TILE_BRIDGE_D					"t32_bridgedown1"
#define		TILE_BRIDGE_L					"t32_bridgeleft1"
#define		TILE_FLOORSHOCK					"t32_floorshock3"
#define		TILE_BEDR_CLOSED				"t32_bedr_r"
#define		TILE_BEDL_CLOSED				"t32_bedl_l"
#define		TILE_BEDR_OPEN					"t32_bedr_open"
#define		TILE_BEDL_OPEN					"t32_bedl_open"
#define		TILE_FERRET						"anim_t32_ferret1"
#define		TILE_DOOR_NV					"t32_door_nv_1"
#define		TILE_DOOR_PV					"t32_door_pv_1"
#define		TILE_DOOR_SV					"t32_door_sv_1"
#define		TILE_MAILSORT					"anim_t32_mailsort1"
#define		TILE_INBOX						"t32_deco_inbox"
#define		TILE_DOOR2_N					"t32_door2_n_1"
#define		TILE_DOOR2_P					"t32_door2_p_1"
#define		TILE_DOOR2_S					"t32_door2_s_1"
#define		TILE_DOOR2_NV					"t32_door2_nv_1"
#define		TILE_DOOR2_PV					"t32_door2_pv_1"
#define		TILE_DOOR2_SV					"t32_door2_sv_1"
#define		TILE_2DOOR_N					"t32_e2_door_n_1"
#define		TILE_2DOOR_P					"t32_e2_door_p_1"
#define		TILE_2DOOR_S					"t32_e2_door_s_1"
#define		TILE_2DOOR_NV					"t32_e2_door_nv_1"
#define		TILE_2DOOR_PV					"t32_e2_door_pv_1"
#define		TILE_2DOOR_SV					"t32_e2_door_sv_1"
#define		TILE_3DOOR_N					"t32_e3_door_n_1"
#define		TILE_3DOOR_P					"t32_e3_door_p_1"
#define		TILE_3DOOR_S					"t32_e3_door_s_1"
#define		TILE_3DOOR_NV					"t32_e3_door_nv_1"
#define		TILE_3DOOR_PV					"t32_e3_door_pv_1"
#define		TILE_3DOOR_SV					"t32_e3_door_sv_1"
#define		TILE_MEMOS						"t32_memos"
#define		TILE_PACKAGE					"t32_package"
#define		TILE_TYRANIUM					"t32_tyranium"
#define		TILE_FOUR_TOOLS					"t32_four_tools"
#define		TILE_GRATING_LR					"t32_mgrate_mid"
#define		TILE_GRATING_UD					"t32_mgrate_tbmid"
#define		TILE_BTUNNEL_BLOCK_B			"t32_btunnel_block_b"
#define		TILE_BTUNNEL_BLOCK_L			"t32_btunnel_block_l"
#define		TILE_BTUNNEL_BLOCK_R			"t32_btunnel_block_r"
#define		TILE_BTUNNEL_BLOCK_T			"t32_btunnel_block_t"
#define		TILE_BTUNNEL_DONE_B				"t32_btunnel_done_b"
#define		TILE_BTUNNEL_DONE_L				"t32_btunnel_done_l"
#define		TILE_BTUNNEL_DONE_R				"t32_btunnel_done_r"
#define		TILE_BTUNNEL_DONE_T				"t32_btunnel_done_t"
#define		TILE_A							"t32_alpha_a"
#define		TILE_B							"t32_alpha_b"
#define		TILE_C							"t32_alpha_c"
#define		TILE_D							"t32_alpha_d"
#define		TILE_E							"t32_alpha_e"
#define		TILE_F							"t32_alpha_f"
#define		TILE_G							"t32_alpha_g"
#define		TILE_H							"t32_alpha_h"
#define		TILE_I							"t32_alpha_i"
#define		TILE_J							"t32_alpha_j"
#define		TILE_K							"t32_alpha_k"
#define		TILE_L							"t32_alpha_l"
#define		TILE_M							"t32_alpha_m"
#define		TILE_N							"t32_alpha_n"
#define		TILE_O							"t32_alpha_o"
#define		TILE_P							"t32_alpha_p"
#define		TILE_Q							"t32_alpha_q"
#define		TILE_R							"t32_alpha_r"
#define		TILE_S							"t32_alpha_s"
#define		TILE_T							"t32_alpha_t"
#define		TILE_U							"t32_alpha_u"
#define		TILE_V							"t32_alpha_v"
#define		TILE_W							"t32_alpha_w"
#define		TILE_X							"t32_alpha_x"
#define		TILE_Y							"t32_alpha_y"
#define		TILE_Z							"t32_alpha_z"
#define		TILE_SKY_STARS_DOWN_SLOW		"t32_sky_stars_down_slow"
#define		TILE_SKY_STARS_UP_SLOW			"t32_sky_stars_up_slow"
#define		TILE_SKY_STARS_RIGHT_SLOW		"t32_sky_stars_right_slow"
#define		TILE_SKY_STARS_LEFT_SLOW		"t32_sky_stars_left_slow"
#define		TILE_SKY_STARS_STATIONARY		"t32_sky_stars_stationary"
#define		TILE_CHAIR						"t32_brownchair_u"
#define		TILE_PIZZA						"t32_deco_pizza"
#define		TILE_CABOPEN_T					"t32_opencabinet_t"
#define		TILE_CABOPEN_B					"t32_opencabinet_b"
#define		TILE_BLOCKPOLE					"t32_blockpole_1"
#define		TILE_SKY_CLOUDS					"t32_sky_clouds"
#define		TILE_TEMPLE_TOUCHPLATE_OFF		"t32_temple_touchplate_off"
#define		TILE_TEMPLE_TOUCHPLATE_ON		"t32_temple_touchplate_on"
#define		TILE_KC_HOLDER_WHITE_OFF		"anim_t32_kcholder_white_off1"
#define		TILE_KC_HOLDER_WHITE_ON			"t32_kcholder_white_on"
#define		TILE_KC_HOLDER_BLUE_OFF			"anim_t32_kcholder_blue_off1"
#define		TILE_KC_HOLDER_BLUE_ON			"t32_kcholder_blue_on"
#define		TILE_KC_HOLDER_RED_OFF			"anim_t32_kcholder_red_off1"
#define		TILE_KC_HOLDER_RED_ON			"t32_kcholder_red_on"
#define		TILE_KC_HOLDER_GREEN_OFF		"anim_t32_kcholder_green_off1"
#define		TILE_KC_HOLDER_GREEN_ON			"t32_kcholder_green_on"
#define		TILE_KC_HOLDER_PURPLE_OFF		"anim_t32_kcholder_purple_off1"
#define		TILE_KC_HOLDER_PURPLE_ON		"t32_kcholder_purple_on"
#define		TILE_KC_HOLDER_BLACK_OFF		"anim_t32_kcholder_black_off1"
#define		TILE_KC_HOLDER_BLACK_ON			"t32_kcholder_black_on"
#define		TILE_SHIP_HANDSWITCH_OFF		"anim_t32_ship_handswitch_off1"
#define		TILE_SHIP_HANDSWITCH_ON			"t32_ship_handswitch_on"
#define		TILE_BLOCKING_VINES				"t32_blocking_vines"
#define		TILE_WASTEBASKET				"t32_deco_wastebasket"
#define		TILE_SNOWDOOR_B					"t32_snow_temple_opendoor_b"
#define		TILE_PHAR_CARPET				"t32_phar_carpet_tb"
#define		TILE_HEADSTATUE					"t32_phar_headstatue1"
#define		TILE_ROUTER_HOLDER				"t32_router_holder"
#define		TILE_WEAPON_EQUIPPED			"t32_weapon_equipped"
#define		FORCEFIELD_LR					"anim_t32_forcefield_lr_"
#define		FORCEFIELD_UD					"anim_t32_forcefield_ud_"
#define		FORCESPLASH_TOP					"anim_t32_ff_splash_top"
#define		FORCESPLASH_BTM					"anim_t32_ff_splash_btm"
#define		FORCESPLASH_LEFT				"anim_t32_ff_splash_left"
#define		FORCESPLASH_RIGHT				"anim_t32_ff_splash_right_"
#define		DEMIGOD_FLOAT_T					"anim_t32_demigod_floats_t01"
#define		DEMIGOD_FLOAT_B					"anim_t32_demigod_floats_t01"
#define		TILE_FFTONGUE_UD_MIDDLE			"t32_tongue_ud_middle"
#define		TILE_FFTONGUE_UD_WIGGLE_L		"t32_tongue_ud_wiggle_left"
#define		TILE_FFTONGUE_UD_WIGGLE_M		"t32_tongue_ud_wiggle_mid"
#define		TILE_FFTONGUE_UD_WIGGLE_R		"t32_tongue_ud_wiggle_right"
#define		TILE_FFTONGUE_LR_MIDDLE			"t32_tongue_lr_middle"
#define		TILE_FFTONGUE_R_WIGGLE_U		"t32_tongue_right_wiggle_up"
#define		TILE_FFTONGUE_R_WIGGLE_M		"t32_tongue_right_wiggle_mid"
#define		TILE_FFTONGUE_R_WIGGLE_D		"t32_tongue_right_wiggle_down"
#define		TILE_FFTONGUE_L_WIGGLE_U		"t32_tongue_left_wiggle_up"
#define		TILE_FFTONGUE_L_WIGGLE_M		"t32_tongue_left_wiggle_mid"
#define		TILE_FFTONGUE_L_WIGGLE_D		"t32_tongue_left_wiggle_down"
#define		TILE_CONDUCTOR					"t32_conductor"
#define		GEM_WHITE						"t32_gem_white"
#define		GEM_RED_GFX						"t32_gem_red"
#define		GEM_BLUE_GFX					"t32_gem_blue"
#define		GEM_GREEN_GFX					"t32_gem_green"
#define		TILE_HEAD_SCIENTIST				"t32_head_scientist"
#define		TILE_HEAD_SPACEDUDE				"t32_head_spacedude"
#define		TILE_HEAD_WORKER				"t32_head_worker"
#define		TILE_HEAD_ACCOUNTANT			"t32_head_accountant"
#define		TILE_HEAD_DOLLY					"t32_head_dolly"
#define		TILE_HEAD_SARGE					"t32_head_sarge"
#define		TILE_SLOT_GOOD1					"t32_slot_good1"
#define		TILE_SLOT_GOOD2					"t32_slot_good2"
#define		TILE_SLOT_GOOD3					"t32_slot_good3"
#define		TILE_SLOT_GOOD4					"t32_slot_good4"
#define		TILE_SLOT_GOOD5					"t32_slot_good5"
#define		TILE_SLOT_GOOD6					"t32_slot_good6"
#define		TILE_SLOT_BAD					"t32_slot_bad"
#define		GROUP_ENT_GUY					"ent_guy_"
#define		GROUP_ENT_GUY_WALKDOWN			"ent_guy_walkdown"
#define		GROUP_ENT_GUY_WALKUP			"ent_guy_walkup"
#define		GROUP_ENT_GUY_WALKRIGHT			"ent_guy_walkright"
#define		GROUP_ENT_GUY_WALKLEFT			"ent_guy_walkleft"
#define		GROUP_ENT_GUY_DIE				"ent_guy_die"
#define		GROUP_ENT_GUY_BLINK				"ent_guy_blink"
#define		GROUP_ENT_GUY_STANDDOWN			"ent_guy_standdown"
#define		GROUP_ENT_GUY_STANDUP			"ent_guy_standup"
#define		GROUP_ENT_GUY_STANDRIGHT		"ent_guy_standright"
#define		GROUP_ENT_GUY_STANDLEFT			"ent_guy_standleft"
#define		GROUP_ENT_GUY_GOODJOB			"ent_guy_goodjob"
#define		TILE_GUYSLEEPING				"t32_guysleep"
#define		GROUP_ENT_GUY_PLUMMET			"ent_guy_plummet"
#define		GROUP_ENT_GUY_HORRIBLE1			"ent_guy_horrible1"
#define		GROUP_ENT_GUY_HORRIBLE2			"ent_guy_horrible2"
#define		GROUP_ENT_GUY_HORRIBLE3			"ent_guy_horrible3"
#define		GROUP_ENT_GUY_HORRIBLE4			"ent_guy_horrible4"
#define		GROUP_ENT_GUY_PUSHDOWN			"ent_guy_pushdown"
#define		GROUP_ENT_GUY_PUSHUP			"ent_guy_pushup"
#define		GROUP_ENT_GUY_PUSHRIGHT			"ent_guy_pushright"
#define		GROUP_ENT_GUY_PUSHLEFT			"ent_guy_pushleft"
#define		GROUP_ENT_GUY_STUNDOWN			"ent_guy_stundown"
#define		GROUP_ENT_GUY_STUNUP			"ent_guy_stunup"
#define		GROUP_ENT_GUY_STUNRIGHT			"ent_guy_stunright"
#define		GROUP_ENT_GUY_STUNLEFT			"ent_guy_stunleft"
#define		GROUP_ENT_GUY_GETDOWN			"ent_guy_getdown"
#define		GROUP_ENT_GUY_GETUP				"ent_guy_getup"
#define		GROUP_ENT_GUY_GETRIGHT			"ent_guy_getright"
#define		GROUP_ENT_GUY_GETLEFT			"ent_guy_getleft"
#define		GROUP_ENT_GUY_SLINGDOWN			"ent_guy_slingdown"
#define		GROUP_ENT_GUY_SLINGUP			"ent_guy_slingup"
#define		GROUP_ENT_GUY_SLINGRIGHT		"ent_guy_slingright"
#define		GROUP_ENT_GUY_SLINGLEFT			"ent_guy_slingleft"
#define		CLUBLEFT1						"clubleft1"
#define		CLUBLEFT2						"clubleft2"
#define		CLUBLEFT3						"clubleft3"
#define		CLUBRIGHT1						"clubright1"
#define		CLUBRIGHT2						"clubright2"
#define		CLUBRIGHT3						"clubright3"
#define		CLUBDOWN1						"clubdown1"
#define		CLUBDOWN2						"clubdown2"
#define		CLUBDOWN3						"clubdown3"
#define		CLUBUP1							"clubup1"
#define		CLUBUP2							"clubup2"
#define		CLUBUP3							"clubup3"
#define		TILE_ENV_WHITE					"ent_envelope_white_sit01"
#define		GROUP_ENT_ENVELOPE_WHITE        "ent_envelope_white_"
#define		GROUP_ENT_ENVELOPE_WHITE_SIT    "ent_envelope_white_sit"
#define		GROUP_ENT_ENVELOPE_BLUE         "ent_envelope_blue_"
#define		GROUP_ENT_ENVELOPE_BLUE_SIT     "ent_envelope_blue_sit"
#define		GROUP_ENT_ENVELOPE_RED          "ent_envelope_red_"
#define		GROUP_ENT_ENVELOPE_RED_SIT      "ent_envelope_red_sit"
#define		GROUP_ENT_ENVELOPE_GREEN        "ent_envelope_green_"
#define		GROUP_ENT_ENVELOPE_GREEN_SIT    "ent_envelope_green_sit"
#define		GROUP_ENT_SCIENTIST             "ent_scientist_"
#define		GROUP_ENT_SCIENTIST_WALKDOWN    "ent_scientist_walkdown"
#define		GROUP_ENT_SCIENTIST_WALKUP      "ent_scientist_walkup"
#define		GROUP_ENT_SCIENTIST_WALKRIGHT   "ent_scientist_walkright"
#define		GROUP_ENT_SCIENTIST_WALKLEFT    "ent_scientist_walkleft"
#define		GROUP_ENT_SCIENTIST_DIE         "ent_scientist_die"
#define		GROUP_ENT_SCIENTIST_STANDDOWN   "ent_scientist_standdown"
#define		GROUP_ENT_SCIENTIST_STANDUP     "ent_scientist_standup"
#define		GROUP_ENT_SCIENTIST_STANDRIGHT  "ent_scientist_standright"
#define		GROUP_ENT_SCIENTIST_STANDLEFT   "ent_scientist_standleft"
#define		GROUP_ENT_SCIENTIST_BLINK       "ent_scientist_blink"
#define		GROUP_ENT_SCIENTIST_WIN         "ent_scientist_win"
#define		GROUP_ENT_SERGEANT              "ent_sergeant_"
#define		GROUP_ENT_SERGEANT_WALKDOWN     "ent_sergeant_walkdown"
#define		GROUP_ENT_SERGEANT_WALKUP       "ent_sergeant_walkup"
#define		GROUP_ENT_SERGEANT_WALKRIGHT    "ent_sergeant_walkright"
#define		GROUP_ENT_SERGEANT_WALKLEFT     "ent_sergeant_walkleft"
#define		GROUP_ENT_SERGEANT_STANDDOWN    "ent_sergeant_standdown"
#define		GROUP_ENT_SERGEANT_STANDUP      "ent_sergeant_standup"
#define		GROUP_ENT_SERGEANT_STANDRIGHT   "ent_sergeant_standright"
#define		GROUP_ENT_SERGEANT_STANDLEFT    "ent_sergeant_standleft"
#define		GROUP_ENT_SERGEANT_BLINK        "ent_sergeant_blink"
#define		GROUP_ENT_SERGEANT_YELL         "ent_sergeant_yell"
#define		GROUP_ENT_WORKER                "ent_worker_"
#define		GROUP_ENT_WORKER_WALKDOWN       "ent_worker_walkdown"
#define		GROUP_ENT_WORKER_WALKUP         "ent_worker_walkup"
#define		GROUP_ENT_WORKER_WALKRIGHT      "ent_worker_walkright"
#define		GROUP_ENT_WORKER_WALKLEFT       "ent_worker_walkleft"
#define		GROUP_ENT_WORKER_DIE            "ent_worker_die"
#define		GROUP_ENT_WORKER_STANDDOWN      "ent_worker_standdown"
#define		GROUP_ENT_WORKER_STANDUP        "ent_worker_standup"
#define		GROUP_ENT_WORKER_STANDRIGHT     "ent_worker_standright"
#define		GROUP_ENT_WORKER_STANDLEFT      "ent_worker_standleft"
#define		GROUP_ENT_WORKER_BLINK          "ent_worker_blink"
#define		GROUP_ENT_DEAD_WORKER           "ent_dead_worker_"
#define		GROUP_ENT_DEAD_WORKER_SIT       "ent_dead_worker_sit"
#define		GROUP_ENT_SPACEDUDE             "ent_spacedude_"
#define		GROUP_ENT_SPACEDUDE_WALKDOWN    "ent_spacedude_walkdown"
#define		GROUP_ENT_SPACEDUDE_WALKUP      "ent_spacedude_walkup"
#define		GROUP_ENT_SPACEDUDE_WALKRIGHT   "ent_spacedude_walkright"
#define		GROUP_ENT_SPACEDUDE_WALKLEFT    "ent_spacedude_walkleft"
#define		GROUP_ENT_DOLLY                 "ent_dolly_"
#define		GROUP_ENT_DOLLY_WALKDOWN        "ent_dolly_walkdown"
#define		GROUP_ENT_DOLLY_WALKUP          "ent_dolly_walkup"
#define		GROUP_ENT_DOLLY_WALKRIGHT       "ent_dolly_walkright"
#define		GROUP_ENT_DOLLY_WALKLEFT        "ent_dolly_walkleft"
#define		GROUP_ENT_DOLLY_USERIGHT        "ent_dolly_useright"
#define		GROUP_ENT_DOLLY_KISSRIGHT       "ent_dolly_kissright"
#define		GROUP_ENT_DOLLY_KISSLEFT        "ent_dolly_kissleft"
#define		GROUP_ENT_DOLLY_ANGRY           "ent_dolly_angry"
#define		GROUP_ENT_DOLLY_LAUGH           "ent_dolly_laugh"
#define		GROUP_ENT_DOLLY_PANIC           "ent_dolly_panic"
#define		GROUP_ENT_CELL                  "ent_cell_"
#define		GROUP_ENT_CELL_SIT              "ent_cell_sit"
#define		GROUP_ENT_CRATE                 "ent_crate_"
#define		GROUP_ENT_CRATE_SIT             "ent_crate_sit"
#define		GROUP_ENT_CRATE_FLOAT           "ent_crate_float"
#define		GROUP_ENT_BARREL_LIGHT          "ent_barrel_light_"
#define		GROUP_ENT_BARREL_LIGHT_SIT      "ent_barrel_light_sit"
#define		GROUP_ENT_BARREL_LIGHT_FLOAT    "ent_barrel_light_float"
#define		GROUP_ENT_BARREL_LIGHT_MELT     "ent_barrel_light_melt"
#define		GROUP_ENT_BARREL_HEAVY          "ent_barrel_heavy_"
#define		GROUP_ENT_BARREL_HEAVY_SIT      "ent_barrel_heavy_sit"
#define		GROUP_ENT_BARREL_HEAVY_FLOAT    "ent_barrel_heavy_float"
#define		GROUP_ENT_BARREL_HEAVY_MELT     "ent_barrel_heavy_melt"
#define		GROUP_ENT_BARREL_EXPLODE        "ent_barrel_explode_"
#define		GROUP_ENT_BARREL_EXPLODE_SIT    "ent_barrel_explode_sit"
#define		GROUP_ENT_TRANSCEIVER           "ent_transceiver_"
#define		GROUP_ENT_TRANSCEIVER_SIT       "ent_transceiver_sit"
#define		GROUP_ENT_GOO_CUP               "ent_goo_cup_"
#define		GROUP_ENT_GOO_CUP_SIT           "ent_goo_cup_sit"
#define		GROUP_ENT_CLUB                  "ent_club_"
#define		GROUP_ENT_CLUB_SIT              "ent_club_sit"
#define		GROUP_ENT_ROBOSTUNNER           "ent_robostunner_"
#define		GROUP_ENT_ROBOSTUNNER_SIT       "ent_robostunner_sit"
#define		GROUP_ENT_SLUGSLINGER           "ent_slugslinger_"
#define		GROUP_ENT_SLUGSLINGER_SIT       "ent_slugslinger_sit"
#define		GEM_WHITE_GFX					"ent_gem_white_sit01"
#define		GROUP_ENT_GEM_WHITE             "ent_gem_white_"
#define		GROUP_ENT_GEM_WHITE_SIT         "ent_gem_white_sit"
#define		GROUP_ENT_GEM_BLUE              "ent_gem_blue_"
#define		GROUP_ENT_GEM_BLUE_SIT          "ent_gem_blue_sit"
#define		GROUP_ENT_GEM_RED               "ent_gem_red_"
#define		GROUP_ENT_GEM_RED_SIT           "ent_gem_red_sit"
#define		GROUP_ENT_GEM_GREEN             "ent_gem_green_"
#define		GROUP_ENT_GEM_GREEN_SIT         "ent_gem_green_sit"
#define		GROUP_ENT_TEACUP                "ent_teacup_"
#define		GROUP_ENT_TEACUP_SIT            "ent_teacup_sit"
#define		GROUP_ENT_COOKIE                "ent_cookie_"
#define		GROUP_ENT_COOKIE_SIT            "ent_cookie_sit"
#define		GROUP_ENT_BURGER                "ent_burger_"
#define		GROUP_ENT_BURGER_SIT            "ent_burger_sit"
#define		GROUP_ENT_PDA                   "ent_pda_"
#define		GROUP_ENT_PDA_SIT               "ent_pda_sit"
#define		GROUP_ENT_BOOK                  "ent_book_"
#define		GROUP_ENT_BOOK_SIT              "ent_book_sit"
#define		GROUP_ENT_CLIPBOARD             "ent_clipboard_"
#define		GROUP_ENT_CLIPBOARD_SIT         "ent_clipboard_sit"
#define		GROUP_ENT_NOTE                  "ent_note_"
#define		GROUP_ENT_NOTE_SIT              "ent_note_sit"
#define		GROUP_ENT_KEYCARD_WHITE         "ent_keycard_white_"
#define		GROUP_ENT_KEYCARD_WHITE_SIT     "ent_keycard_white_sit"
#define		GROUP_ENT_KEYCARD_BLUE          "ent_keycard_blue_"
#define		GROUP_ENT_KEYCARD_BLUE_SIT      "ent_keycard_blue_sit"
#define		GROUP_ENT_KEYCARD_RED           "ent_keycard_red_"
#define		GROUP_ENT_KEYCARD_RED_SIT       "ent_keycard_red_sit"
#define		GROUP_ENT_KEYCARD_GREEN         "ent_keycard_green_"
#define		GROUP_ENT_KEYCARD_GREEN_SIT     "ent_keycard_green_sit"
#define		GROUP_ENT_KEYCARD_PURPLE        "ent_keycard_purple_"
#define		GROUP_ENT_KEYCARD_PURPLE_SIT    "ent_keycard_purple_sit"
#define		GROUP_ENT_KEYCARD_BLACK         "ent_keycard_black_"
#define		GROUP_ENT_KEYCARD_BLACK_SIT     "ent_keycard_black_sit"
#define		GROUP_ENT_MAGIC_EGG             "ent_magic_egg_"
#define		GROUP_ENT_MAGIC_EGG_SIT         "ent_magic_egg_sit"
#define		GROUP_ENT_ICE_BLOCK             "ent_ice_block_"
#define		GROUP_ENT_ICE_BLOCK_SIT         "ent_ice_block_sit"
#define		GROUP_ENT_CABKEY                "ent_cabkey_"
#define		GROUP_ENT_CABKEY_SIT            "ent_cabkey_sit"
#define		GROUP_ENT_DOLLY_TOOL1           "ent_dolly_tool1_"
#define		GROUP_ENT_DOLLY_TOOL1_SIT       "ent_dolly_tool1_sit"
#define		GROUP_ENT_DOLLY_TOOL2           "ent_dolly_tool2_"
#define		GROUP_ENT_DOLLY_TOOL2_SIT       "ent_dolly_tool2_sit"
#define		GROUP_ENT_DOLLY_TOOL3           "ent_dolly_tool3_"
#define		GROUP_ENT_DOLLY_TOOL3_SIT       "ent_dolly_tool3_sit"
#define		GROUP_ENT_DOLLY_TOOL4           "ent_dolly_tool4_"
#define		GROUP_ENT_DOLLY_TOOL4_SIT       "ent_dolly_tool4_sit"
#define		GROUP_ENT_SEED                  "ent_seed_"
#define		GROUP_ENT_SEED_SIT              "ent_seed_sit"
#define		GROUP_ENT_SODA                  "ent_soda_"
#define		GROUP_ENT_SODA_SIT              "ent_soda_sit"
#define		GROUP_ENT_SLICER                "ent_slicer_"
#define		GROUP_ENT_SLICER_SIT            "ent_slicer_sit"
#define		GROUP_ENT_ROUTER                "ent_router_"
#define		GROUP_ENT_ROUTER_SIT            "ent_router_sit"
#define		GROUP_ENT_FROGSTATUE            "ent_frogstatue_"
#define		GROUP_ENT_FROGSTATUE_SIT        "ent_frogstatue_sit"
#define		GROUP_ENT_PACKAGE               "ent_package_"
#define		GROUP_ENT_PACKAGE_SIT           "ent_package_sit"
#define		GROUP_ENT_PUSHBOT               "ent_pushbot_"
#define		GROUP_ENT_PUSHBOT_WALKDOWN      "ent_pushbot_walkdown"
#define		GROUP_ENT_PUSHBOT_WALKUP        "ent_pushbot_walkup"
#define		GROUP_ENT_PUSHBOT_WALKRIGHT     "ent_pushbot_walkright"
#define		GROUP_ENT_PUSHBOT_WALKLEFT      "ent_pushbot_walkleft"
#define		GROUP_ENT_OMNIBOT               "ent_omnibot_"
#define		GROUP_ENT_OMNIBOT_WALKDOWN      "ent_omnibot_walkdown"
#define		GROUP_ENT_OMNIBOT_WALKUP        "ent_omnibot_walkup"
#define		GROUP_ENT_OMNIBOT_WALKRIGHT     "ent_omnibot_walkright"
#define		GROUP_ENT_OMNIBOT_WALKLEFT      "ent_omnibot_walkleft"
#define		GROUP_ENT_OMNIBOT_MISSILE       "ent_omnibot_missile"
#define		GROUP_ENT_RIGHTBOT              "ent_rightbot_"
#define		GROUP_ENT_RIGHTBOT_WALKDOWN     "ent_rightbot_walkdown"
#define		GROUP_ENT_RIGHTBOT_WALKUP       "ent_rightbot_walkup"
#define		GROUP_ENT_RIGHTBOT_WALKRIGHT    "ent_rightbot_walkright"
#define		GROUP_ENT_RIGHTBOT_WALKLEFT     "ent_rightbot_walkleft"
#define		GROUP_ENT_MAINTBOT              "ent_maintbot_"
#define		GROUP_ENT_MAINTBOT_WALKDOWN     "ent_maintbot_walkdown"
#define		GROUP_ENT_MAINTBOT_WALKUP       "ent_maintbot_walkup"
#define		GROUP_ENT_MAINTBOT_WALKRIGHT    "ent_maintbot_walkright"
#define		GROUP_ENT_MAINTBOT_WALKLEFT     "ent_maintbot_walkleft"
#define		GROUP_ENT_MAINTBOT_USEDOWN      "ent_maintbot_usedown"
#define		GROUP_ENT_MAINTBOT_USEUP        "ent_maintbot_useup"
#define		GROUP_ENT_MAINTBOT_USERIGHT     "ent_maintbot_useright"
#define		GROUP_ENT_MAINTBOT_USELEFT      "ent_maintbot_useleft"
#define		GROUP_ENT_MAINTBOT_STANDDOWN    "ent_maintbot_standdown"
#define		GROUP_ENT_MAINTBOT_STANDUP      "ent_maintbot_standup"
#define		GROUP_ENT_MAINTBOT_STANDRIGHT   "ent_maintbot_standright"
#define		GROUP_ENT_MAINTBOT_STANDLEFT    "ent_maintbot_standleft"
#define		GROUP_ENT_RAILRIDER             "ent_railrider_"
#define		GROUP_ENT_RAILRIDER_STANDDOWN   "ent_railrider_standdown"
#define		GROUP_ENT_RAILRIDER_STANDUP     "ent_railrider_standup"
#define		GROUP_ENT_RAILRIDER_WALKDOWN    "ent_railrider_walkdown"
#define		GROUP_ENT_RAILRIDER_WALKUP      "ent_railrider_walkup"
#define		GROUP_ENT_RAILRIDER_WALKRIGHT   "ent_railrider_walkright"
#define		GROUP_ENT_RAILRIDER_WALKLEFT    "ent_railrider_walkleft"
#define		GROUP_ENT_SHOCKBOT              "ent_shockbot_"
#define		GROUP_ENT_SHOCKBOT_WALK         "ent_shockbot_walk"
#define		GROUP_ENT_LASER                 "ent_laser_"
#define		GROUP_ENT_LASER_UP              "ent_laser_up"
#define		GROUP_ENT_LASER_DOWN            "ent_laser_down"
#define		GROUP_ENT_LASER_LEFT            "ent_laser_left"
#define		GROUP_ENT_LASER_RIGHT           "ent_laser_right"
#define		GROUP_ENT_FOUR_LASER            "ent_four_laser_"
#define		GROUP_ENT_FOUR_LASER_UP         "ent_four_laser_up"
#define		GROUP_ENT_FOUR_LASER_DOWN       "ent_four_laser_down"
#define		GROUP_ENT_FOUR_LASER_LEFT       "ent_four_laser_left"
#define		GROUP_ENT_FOUR_LASER_RIGHT      "ent_four_laser_right"
#define		GROUP_ENT_GREENBEAMLR           "ent_greenbeamlr_"
#define		GROUP_ENT_GREENBEAMLR_ANIM      "ent_greenbeamlr_anim"
#define		GROUP_ENT_GREENBEAMUD           "ent_greenbeamud_"
#define		GROUP_ENT_GREENBEAMUD_ANIM      "ent_greenbeamud_anim"
#define		GROUP_ENT_DEFLECTORBL           "ent_deflectorbl_"
#define		GROUP_ENT_DEFLECTORBL_SIT       "ent_deflectorbl_sit"
#define		GROUP_ENT_DEFLECTORBR           "ent_deflectorbr_"
#define		GROUP_ENT_DEFLECTORBR_SIT       "ent_deflectorbr_sit"
#define		GROUP_ENT_DEFLECTORTR           "ent_deflectortr_"
#define		GROUP_ENT_DEFLECTORTR_SIT       "ent_deflectortr_sit"
#define		GROUP_ENT_DEFLECTORTL           "ent_deflectortl_"
#define		GROUP_ENT_DEFLECTORTL_SIT       "ent_deflectortl_sit"
#define		GROUP_ENT_REDBEAMLR             "ent_redbeamlr_"
#define		GROUP_ENT_REDBEAMLR_ANIM        "ent_redbeamlr_anim"
#define		GROUP_ENT_REDBEAMUD             "ent_redbeamud_"
#define		GROUP_ENT_REDBEAMUD_ANIM        "ent_redbeamud_anim"
#define		GROUP_ENT_TURNBOT               "ent_turnbot_"
#define		GROUP_ENT_TURNBOT_WALKDOWN      "ent_turnbot_walkdown"
#define		GROUP_ENT_TURNBOT_WALKUP        "ent_turnbot_walkup"
#define		GROUP_ENT_TURNBOT_WALKRIGHT     "ent_turnbot_walkright"
#define		GROUP_ENT_TURNBOT_WALKLEFT      "ent_turnbot_walkleft"
#define		GROUP_ENT_VORTEXIAN             "ent_vortexian_"
#define		GROUP_ENT_VORTEXIAN_STANDDOWN   "ent_vortexian_standdown"
#define		GROUP_ENT_CHICKEN               "ent_chicken_"
#define		GROUP_ENT_CHICKEN_WALKDOWN      "ent_chicken_walkdown"
#define		GROUP_ENT_CHICKEN_WALKUP        "ent_chicken_walkup"
#define		GROUP_ENT_CHICKEN_WALKRIGHT     "ent_chicken_walkright"
#define		GROUP_ENT_CHICKEN_WALKLEFT      "ent_chicken_walkleft"
#define		GROUP_ENT_CHICKEN_STANDDOWN     "ent_chicken_standdown"
#define		GROUP_ENT_CHICKEN_STANDUP       "ent_chicken_standup"
#define		GROUP_ENT_CHICKEN_STANDRIGHT    "ent_chicken_standright"
#define		GROUP_ENT_CHICKEN_STANDLEFT     "ent_chicken_standleft"
#define		GROUP_ENT_CHICKEN_DIE           "ent_chicken_die"
#define		GROUP_ENT_DEADEYE               "ent_deadeye_"
#define		GROUP_ENT_DEADEYE_WALKDOWN      "ent_deadeye_walkdown"
#define		GROUP_ENT_DEADEYE_WALKUP        "ent_deadeye_walkup"
#define		GROUP_ENT_DEADEYE_WALKRIGHT     "ent_deadeye_walkright"
#define		GROUP_ENT_DEADEYE_WALKLEFT      "ent_deadeye_walkleft"
#define		GROUP_ENT_ICEPUFF               "ent_icepuff_"
#define		GROUP_ENT_ICEPUFF_PEEK          "ent_icepuff_peek"
#define		GROUP_ENT_ICEPUFF_APPEAR        "ent_icepuff_appear"
#define		GROUP_ENT_ICEPUFF_THROWDOWN     "ent_icepuff_throwdown"
#define		GROUP_ENT_ICEPUFF_THROWRIGHT    "ent_icepuff_throwright"
#define		GROUP_ENT_ICEPUFF_THROWLEFT     "ent_icepuff_throwleft"
#define		GROUP_ENT_ICEPUFF_DISAPPEAR     "ent_icepuff_disappear"
#define		GROUP_ENT_ACCOUNTANT            "ent_accountant_"
#define		GROUP_ENT_ACCOUNTANT_STANDDOWN  "ent_accountant_standdown"
#define		GROUP_ENT_ACCOUNTANT_STANDUP    "ent_accountant_standup"
#define		GROUP_ENT_ACCOUNTANT_STANDRIGHT "ent_accountant_standright"
#define		GROUP_ENT_ACCOUNTANT_STANDLEFT  "ent_accountant_standleft"
#define		GROUP_ENT_ACCOUNTANT_TALKDOWN   "ent_accountant_talkdown"
#define		GROUP_ENT_ACCOUNTANT_TALKUP     "ent_accountant_talkup"
#define		GROUP_ENT_ACCOUNTANT_TALKRIGHT  "ent_accountant_talkright"
#define		GROUP_ENT_ACCOUNTANT_TALKLEFT   "ent_accountant_talkleft"
#define		GROUP_ENT_MEERKAT               "ent_meerkat_"
#define		GROUP_ENT_MEERKAT_DIRTMOVE      "ent_meerkat_dirtmove"
#define		GROUP_ENT_MEERKAT_APPEAR        "ent_meerkat_appear"
#define		GROUP_ENT_MEERKAT_BITE          "ent_meerkat_bite"
#define		GROUP_ENT_MEERKAT_DISAPPEAR     "ent_meerkat_disappear"
#define		GROUP_ENT_MEERKAT_LOOK          "ent_meerkat_look"
#define		GROUP_ENT_GOODFAIRY             "ent_goodfairy_"
#define		GROUP_ENT_GOODFAIRY_WALKDOWN    "ent_goodfairy_walkdown"
#define		GROUP_ENT_GOODFAIRY_WALKUP      "ent_goodfairy_walkup"
#define		GROUP_ENT_GOODFAIRY_WALKRIGHT   "ent_goodfairy_walkright"
#define		GROUP_ENT_GOODFAIRY_WALKLEFT    "ent_goodfairy_walkleft"
#define		GROUP_ENT_BADFAIRY              "ent_badfairy_"
#define		GROUP_ENT_BADFAIRY_WALKDOWN     "ent_badfairy_walkdown"
#define		GROUP_ENT_BADFAIRY_WALKUP       "ent_badfairy_walkup"
#define		GROUP_ENT_BADFAIRY_WALKRIGHT    "ent_badfairy_walkright"
#define		GROUP_ENT_BADFAIRY_WALKLEFT     "ent_badfairy_walkleft"
#define		GROUP_ENT_GATEPUDDLE            "ent_gatepuddle_"
#define		GROUP_ENT_GATEPUDDLE_STANDDOWN  "ent_gatepuddle_standdown"
#define		GROUP_ENT_BUZZFLY               "ent_buzzfly_"
#define		GROUP_ENT_BUZZFLY_WALKDOWN      "ent_buzzfly_walkdown"
#define		GROUP_ENT_BUZZFLY_WALKUP        "ent_buzzfly_walkup"
#define		GROUP_ENT_BUZZFLY_WALKRIGHT     "ent_buzzfly_walkright"
#define		GROUP_ENT_BUZZFLY_WALKLEFT      "ent_buzzfly_walkleft"
#define		GROUP_ENT_FATFROG               "ent_fatfrog_"
#define		GROUP_ENT_FATFROG_STANDDOWN     "ent_fatfrog_standdown"
#define		GROUP_ENT_FATFROG_LICKDOWN      "ent_fatfrog_lickdown"
#define		GROUP_ENT_FATFROG_STANDRIGHT    "ent_fatfrog_standright"
#define		GROUP_ENT_FATFROG_STANDLEFT     "ent_fatfrog_standleft"
#define		GROUP_ENT_FATFROG_LICKRIGHT     "ent_fatfrog_lickright"
#define		GROUP_ENT_FATFROG_LICKLEFT      "ent_fatfrog_lickleft"
#define		GROUP_ENT_MONKEYSTONE           "ent_monkeystone_"
#define		GROUP_ENT_MONKEYSTONE_SIT       "ent_monkeystone_sit"
#define		GEM_FLASH						"get_gem_flash_sit"
#define		GROUP_GET_GEM_FLASH             "get_gem_flash_"
#define		GROUP_GET_GEM_FLASH_SIT         "get_gem_flash_sit"
#define		TELEPORT_FLASH					"teleporter_flash_sit"
#define		GROUP_TELEPORTER_FLASH          "teleporter_flash_"
#define		GROUP_TELEPORTER_FLASH_SIT      "teleporter_flash_sit"
#define		WATER_SPLASH					"water_splash_sit"
#define		GROUP_WATER_SPLASH              "water_splash_"
#define		GROUP_WATER_SPLASH_SIT          "water_splash_sit"
#define		SLIME_SPLASH					"slime_splash_sit"
#define		GROUP_SLIME_SPLASH              "slime_splash_"
#define		GROUP_SLIME_SPLASH_SIT          "slime_splash_sit"
#define		STEAM_PUFF						"steam_puff_sit"
#define		GROUP_STEAM_PUFF                "steam_puff_"
#define		GROUP_STEAM_PUFF_SIT            "steam_puff_sit"
#define		STUNNED_STARS					"starstun_sit"
#define		GROUP_STARSTUN                  "starstun_"
#define		GROUP_STARSTUN_SIT              "starstun_sit"
#define		SHOCK_SPARK						"shock_spark_sit"
#define		GROUP_SHOCK_SPARK               "shock_spark_"
#define		GROUP_SHOCK_SPARK_SIT           "shock_spark_sit"
#define		EXPLOSION_BOOM					"explosion_boom_sit"
#define		GROUP_EXPLOSION_BOOM            "explosion_boom_"
#define		GROUP_EXPLOSION_BOOM_SIT        "explosion_boom_sit"
#define		INVENTORY_NORMAL				"inventory_normal"
#define		INVENTORY_SELECT				"inventory_select"
#define		MINI_MSTONE						"mini_mstone"
#define		TITLESCREEN						"titlescreen"
#define		MENU_NEWGAME					"menu_newgame"
#define		MENU_LOADGAME					"menu_loadgame"
#define		MENU_OPTIONS					"menu_options"
#define		MENU_QUIT						"menu_quit"
#define		MENU_RESUME						"menu_resume"
#define		STAR_1							"star_1"
#define		STAR_2							"star_2"
#define		STAR_3							"star_3"
#define		MENU_ROCKETSHIP1				"menu_rocketship1"
#define		MENU_ROCKETSHIP2				"menu_rocketship2"
#define		MENU_EXHAUST1					"menu_exhaust1"
#define		MENU_EXHAUST2					"menu_exhaust2"
#define		TITLELOGO						"titlelogo"
#define		CTRL_ASSIGN						"ctrl_assign"
#define		CTRL_ARROWUP					"ctrl_arrowup"
#define		CTRL_ARROWDN					"ctrl_arrowdn"
#define		CTRL_ARROWLEFT					"ctrl_arrowleft"
#define		CTRL_ARROWRIGHT					"ctrl_arrowright"
#define		MENU_CONTROLS					"menu_controls"
#define		MENU_BACK						"menu_back"
#define		MENU_WARP						"menu_warp"
#define		SCREEN_DARKEN					"screen_darken"
#define		WARP_PLAQUE						"warp_plaque"
#define		PAUSE_PLAQUE					"pause_plaque"
#define		MONKEYLOGOSCREEN				"monkeylogoscreen"
#define		MONKEYLOGO_OOHOOH				"monkeylogo_oohooh"
#define		MONKEYLOGO_SMILE				"monkeylogo_smile"
#define		PIC_DEMOSCREEN					"pic_demoscreen"
#define		PIC_DEMOSCREEN2					"pic_demoscreen2"
#define		PIC_DEMO						"pic_demo"
#define		PIC_DEMO_BUY					"pic_demo_buy"
#define		BACKSCROLL_PLANET1				"backscroll_planet1"
#define		BACKSCROLL_PLANET2				"backscroll_planet2"
#define		BACKSCROLL_PLANET3				"backscroll_planet3"
#define		BACKSCROLL_PLANET4				"backscroll_planet4"
#define		BACKSCROLL_PLANET5				"backscroll_planet5"
#define		BACKSCROLL_GALAXY1				"backscroll_galaxy1"
#define		BACKSCROLL_GALAXY2				"backscroll_galaxy2"
#define		MENU_BACK_TOPLEFT				"menu_back_topleft"
#define		MENU_BACK_TOP					"menu_back_top"
#define		MENU_BACK_TOPRIGHT				"menu_back_topright"
#define		MENU_BACK_LEFT					"menu_back_left"
#define		MENU_BACK_MIDDLE				"menu_back_middle"
#define		MENU_BACK_RIGHT					"menu_back_right"
#define		MENU_BACK_BTMLEFT				"menu_back_btmleft"
#define		MENU_BACK_BOTTOM				"menu_back_bottom"
#define		MENU_BACK_BTMRIGHT				"menu_back_btmright"
#define		MENU_TITLE_LEFT					"menu_title_left"
#define		MENU_TITLE_MID					"menu_title_mid"
#define		MENU_TITLE_RIGHT				"menu_title_right"
#define		G_MENU_BACK_TOPLEFT				"g_menu_back_topleft"
#define		G_MENU_BACK_TOP					"g_menu_back_top"
#define		G_MENU_BACK_TOPRIGHT			"g_menu_back_topright"
#define		G_MENU_BACK_LEFT				"g_menu_back_left"
#define		G_MENU_BACK_MIDDLE				"g_menu_back_middle"
#define		G_MENU_BACK_RIGHT				"g_menu_back_right"
#define		G_MENU_BACK_BTMLEFT				"g_menu_back_btmleft"
#define		G_MENU_BACK_BOTTOM				"g_menu_back_bottom"
#define		G_MENU_BACK_BTMRIGHT			"g_menu_back_btmright"
#define		G_MENU_TITLE_LEFT				"g_menu_title_left"
#define		G_MENU_TITLE_MID				"g_menu_title_mid"
#define		G_MENU_TITLE_RIGHT				"g_menu_title_right"
#define		G_CHECK_EMPTY					"g_check_empty"
#define		G_CHECK_ON						"g_check_on"
#define		G_CHECK_OFF						"g_check_off"
#define		G_CHECK_LEFT					"g_check_left"
#define		G_CHECK_RIGHT					"g_check_right"
#define		MENU_HAND_POINTRIGHT			"menu_hand_pointright"
#define		MENU_ARROW_DELIVERTO			"menu_arrow_deliverto"
#define		MENU_SLIDER_LEFT				"menu_slider_left"
#define		MENU_HAND_POINTER				"menu_hand_pointer"
#define		MENU_SLIDER_MID					"menu_slider_mid"
#define		MENU_SLIDER_RIGHT				"menu_slider_right"
#define		MENU_SLIDER_KNOB				"menu_slider_knob"
#define		MENU_DELIVERY_INDENTATION		"menu_delivery_indentation"
#define		MENU_TITLE_DELIVERIES			"menu_title_deliveries"
#define		MENU_TITLE_RESOURCES			"menu_title_resources"
#define		MENU_RESTART					"menu_restart"
#define		MODE_PUZZLE						"mode_puzzle"
#define		MODE_ACTION						"mode_action"
#define		GAMEFILE_SLOT					"gamefile_slot"
#define		MENU_REGISTRATION				"menu_registration"
#define		SECRETSTAR_RED1					"secretstar_red1"
#define		SECRETSTAR_RED2					"secretstar_red2"
#define		SECRETSTAR_GREEN1				"secretstar_green1"
#define		SECRETSTAR_GREEN2				"secretstar_green2"
#define		SECRETSTAR_BLUE1				"secretstar_blue1"
#define		SECRETSTAR_BLUE2				"secretstar_blue2"
#define		CINE_INTROSHIP					"cine_introship"
#define		CINE_LITTLE_MBOT				"cine_little_mbot"
#define		CINE_CLOCK						"cine_clock"
#define		GAME_TRY						"game_try"
#define		GAME_AGAIN						"game_again"
#define		GAME_TA_LEVELRESTART			"game_ta_levelrestart"
#define		PIC_LOADBAR		"pic_loadbar"
#define		PIC_LOADSTAR		"pic_loadstar"
#define		MENU_LOAD		"menu_load"
#define		MENU_SAVE		"menu_save"
#define		MENU_BACKSPACE		"menu_backspace"
#define		MENU_VERSION_NUMBER		"menu_version_number"
#define		CLOUDY_SKIES		"cloudy_skies"
#define		TITLE_EPISODE1		"title_episode1"
#define		TITLE_EPISODE2		"title_episode2"
#define		TITLE_EPISODE3		"title_episode3"
#define		PANIC_POINTER1		"panic_pointer1"
#define		PANIC_POINTER2		"panic_pointer2"
#define		PANIC_NUM0		"panic_num0"
#define		PANIC_NUM1		"panic_num1"
#define		PANIC_NUM2		"panic_num2"
#define		PANIC_NUM3		"panic_num3"
#define		PANIC_NUM4		"panic_num4"
#define		PANIC_NUM5		"panic_num5"
#define		PANIC_NUM6		"panic_num6"
#define		PANIC_NUM7		"panic_num7"
#define		PANIC_NUM8		"panic_num8"
#define		PANIC_NUM9		"panic_num9"
#define		PANIC_PANIC		"panic_panic"
#define		PANIC_ZONE		"panic_zone"
#define		PIC_RANK1		"pic_rank1"
#define		PIC_RANK2		"pic_rank2"
#define		PIC_RANK3		"pic_rank3"
#define		PIC_RANK4		"pic_rank4"
#define		PIC_RANK5		"pic_rank5"
#define		DRAGON_ASLEEP		"dragon_asleep"
#define		DRAGON_FLAP1		"dragon_flap1"
#define		DRAGON_FLAP2		"dragon_flap2"
#define		DRAGON_BREATHE_START		"dragon_breathe_start"
#define		DRAGON_BREATHING_1		"dragon_breathing_1"
#define		DRAGON_BREATHING_2		"dragon_breathing_2"
#define		ICEPUFF_SNOWBALL_DOWN		"icepuff_snowball_down"
#define		ICEPUFF_SNOWBALL_RIGHT		"icepuff_snowball_right"
#define		ICEPUFF_SNOWBALL_LEFT		"icepuff_snowball_left"
#define		SLUG_SHOT1		"slug_shot1"
#define		SLUG_SHOT2		"slug_shot2"
#define		SLUG_SHOT3		"slug_shot3"
#define		SLUG_SHOT4		"slug_shot4"
#define		PIC_ENV_WHITE		"pic_env_white"
#define		PIC_FROG_STATUE		"pic_frog_statue"
#define		PIC_JENKINS		"pic_jenkins"
#define		PIC_TEAM_BRIAN		"pic_team_brian"
#define		PIC_TEAM_STEVIE		"pic_team_stevie"
#define		PIC_TEAM_JOSH		"pic_team_josh"
#define		PIC_TEAM_TOM		"pic_team_tom"
#define		PIC_TEAM_JOHN		"pic_team_john"
#define		PIC_TEAM_LUCAS		"pic_team_lucas"
#define		PIC_QUITSCREEN		"pic_quitscreen"
#define		PIC_CONTROLSSCREEN		"pic_controlsscreen"
#define		PIC_MOUSE_CURSOR1		"pic_mouse_cursor1"
#define		PIC_MOUSE_CURSOR2		"pic_mouse_cursor2"
#define		PIC_MOUSE_CURSOR3		"pic_mouse_cursor3"
#define		PIC_MOUSE_CURSOR4		"pic_mouse_cursor4"
#define		PIC_MOUSE_CURSOR5		"pic_mouse_cursor5"
#define		PIC_MOUSE_CURSOR6		"pic_mouse_cursor6"
#define		PIC_MOUSE_CURSOR7		"pic_mouse_cursor7"
#define		PIC_MOUSE_CURSOR8		"pic_mouse_cursor8"
#define		PIC_STAR256		"pic_star256"
#define		PIC_STAR192		"pic_star192"
#define		PIC_STAR128		"pic_star128"
#define		PIC_STAR64		"pic_star64"
#define		PIC_SNOWFLAKE		"pic_snowflake"
#define		PIC_INFOBAR		"pic_infobar"
#define		PIC_LOADSCREEN		"pic_loadscreen"

#define		PIC_HANDANGO	"pic_handango"
#define		DEMOTITLESCREEN	"demotitlescreen"

#define		BUZZFLY_AMBIENT_WAV		"BUZZFLY_AMBIENT_WAV"
#define		CHICKEN_AMBIENT_WAV		"CHICKEN_AMBIENT_WAV"
#define		CHICKEN_BAGAWK_WAV		"CHICKEN_BAGAWK_WAV"
#define		CHICKEN_DEATH_WAV		"CHICKEN_DEATH_WAV"
#define		FERRET_SQUEAK_WAV		"FERRET_SQUEAK_WAV"
#define		MBOT_HMMM_WAV		"MBOT_HMMM_WAV"
#define		MBOT_HMMM2_WAV		"MBOT_HMMM2_WAV"
#define		MBOT_HYEAH_WAV		"MBOT_HYEAH_WAV"
#define		MBOT_YEAH_WAV		"MBOT_YEAH_WAV"
#define		MBOT_DEATH_WAV		"MBOT_DEATH_WAV"
#define		MBOT_WHISTLE1_WAV		"MBOT_WHISTLE1_WAV"
#define		MBOT_WHISTLE2_WAV		"MBOT_WHISTLE2_WAV"
#define		MBOT_WHISTLE3_WAV		"MBOT_WHISTLE3_WAV"
#define		DEADEYE_AMBIENT01_WAV		"DEADEYE_AMBIENT01_WAV"
#define		DEADEYE_AMBIENT02_WAV		"DEADEYE_AMBIENT02_WAV"
#define		DEADEYE_GROWL01_WAV		"DEADEYE_GROWL01_WAV"
#define		DEADEYE_GROWL02_WAV		"DEADEYE_GROWL02_WAV"
#define		FROG_LICK_WAV		"FROG_LICK_WAV"
#define		FROG_RIBBIT1_WAV		"FROG_RIBBIT1_WAV"
#define		FROG_RIBBIT2_WAV		"FROG_RIBBIT2_WAV"
#define		FATFROG_STUNNED_WAV		"FATFROG_STUNNED_WAV"
#define		RIGHTBOT_TURN_WAV		"RIGHTBOT_TURN_WAV"
#define		RIGHTBOT_STUNNED_WAV		"RIGHTBOT_STUNNED_WAV"
#define		OMNIBOT_AMBIENT_WAV		"OMNIBOT_AMBIENT_WAV"
#define		OMNIBOT_FIRE_WAV		"OMNIBOT_FIRE_WAV"
#define		OMNIBOT_STUNNED_WAV		"OMNIBOT_STUNNED_WAV"
#define		FOURFIRE_TURN_WAV		"FOURFIRE_TURN_WAV"
#define		FOUR_FIRE_WAV		"FOUR_FIRE_WAV"
#define		SHOCKBOT_AMBIENT_WAV		"SHOCKBOT_AMBIENT_WAV"
#define		SHOCKBOT_SHOCK_WAV		"SHOCKBOT_SHOCK_WAV"
#define		RAILRIDER_ONTRACK_WAV		"RAILRIDER_ONTRACK_WAV"
#define		RAILRIDER_EXIT_WAV		"RAILRIDER_EXIT_WAV"
#define		RAILRIDER_TASTE_WAV		"RAILRIDER_TASTE_WAV"
#define		BUZZFLY_STUNNED_WAV		"BUZZFLY_STUNNED_WAV"
#define		BUZZFLY_STING_WAV		"BUZZFLY_STING_WAV"
#define		ROBOT_STUNNED_WAV		"ROBOT_STUNNED_WAV"
#define		FART_WAV		"FART_WAV"
#define		FART2_WAV		"FART2_WAV"
#define		PUSHBOT_STRAIN_WAV		"PUSHBOT_STRAIN_WAV"
#define		PUSHBOT_STUNNED_WAV		"PUSHBOT_STUNNED_WAV"
#define		MEERKAT_BITE_WAV		"MEERKAT_BITE_WAV"
#define		MEERKAT_WARNING_WAV		"MEERKAT_WARNING_WAV"
#define		MEERKAT_APPEAR_WAV		"MEERKAT_APPEAR_WAV"
#define		MEERKAT_STUNNED_WAV		"MEERKAT_STUNNED_WAV"
#define		TURNBOT_TURN_WAV		"TURNBOT_TURN_WAV"
#define		TURNBOT_STUNNED_WAV		"TURNBOT_STUNNED_WAV"
#define		DRAGON_WAKE_WAV		"DRAGON_WAKE_WAV"
#define		DRAGON_FALL_ASLEEP_WAV		"DRAGON_FALL_ASLEEP_WAV"
#define		DRAGON_BREATHE_FIRE_WAV		"DRAGON_BREATHE_FIRE_WAV"
#define		GOOD_FAERIE_AMBIENT_WAV		"GOOD_FAERIE_AMBIENT_WAV"
#define		GOOD_FAERIE_SPELL_WAV		"GOOD_FAERIE_SPELL_WAV"
#define		GOOD_FAERIE_STUNNED_WAV		"GOOD_FAERIE_STUNNED_WAV"
#define		BAD_FAERIE_AMBIENT_WAV		"BAD_FAERIE_AMBIENT_WAV"
#define		BAD_FAERIE_SPELL_WAV		"BAD_FAERIE_SPELL_WAV"
#define		BAD_FAERIE_STUNNED_WAV		"BAD_FAERIE_STUNNED_WAV"
#define		ICEPUFF_APPEAR_WAV		"ICEPUFF_APPEAR_WAV"
#define		ICEPUFF_WARNING_WAV		"ICEPUFF_WARNING_WAV"
#define		ICEPUFF_THROW_WAV		"ICEPUFF_THROW_WAV"
#define		ICEPUFF_STUNNED_WAV		"ICEPUFF_STUNNED_WAV"
#define		DEMIGOD_AMBIENT_WAV		"DEMIGOD_AMBIENT_WAV"
#define		DEMIGOD_HOLYSPEECH_WAV		"DEMIGOD_HOLYSPEECH_WAV"
#define		DEMIGOD_UNHAPPY_WAV		"DEMIGOD_UNHAPPY_WAV"
#define		GATEPUDDLE_AMBIENT_WAV		"GATEPUDDLE_AMBIENT_WAV"
#define		GATEPUDDLE_DISSIPATE_WAV		"GATEPUDDLE_DISSIPATE_WAV"
#define		GATEPUDDLE_SPAWN_WAV		"GATEPUDDLE_SPAWN_WAV"
#define		MANNY_CRASH_WAV		"MANNY_CRASH_WAV"
#define		FOOTSTEPS_WAV		"FOOTSTEPS_WAV"
#define		STEPS_ICE_WAV		"STEPS_ICE_WAV"
#define		GUY_DROWN_WAV		"GUY_DROWN_WAV"
#define		GUY_FRIED_WAV		"GUY_FRIED_WAV"
#define		GUY_GRABBED_WAV		"GUY_GRABBED_WAV"
#define		GUY_DYING_WAV		"GUY_DYING_WAV"
#define		GUY_UHUH_WAV		"GUY_UHUH_WAV"
#define		GUY_PLUMMET_WAV		"GUY_PLUMMET_WAV"
#define		GET_STUNNER_WAV		"GET_STUNNER_WAV"
#define		GET_THING_WAV		"GET_THING_WAV"
#define		GET_CLUB_WAV		"GET_CLUB_WAV"
#define		GET_SLUG_WAV		"GET_SLUG_WAV"
#define		GET_MONKEYSTONE_WAV		"GET_MONKEYSTONE_WAV"
#define		GET_GEM_WAV		"GET_GEM_WAV"
#define		GET_GOO_WAV		"GET_GOO_WAV"
#define		CLUB_MISS_WAV		"CLUB_MISS_WAV"
#define		CLUB_HIT_METAL_WAV		"CLUB_HIT_METAL_WAV"
#define		CLUB_HIT_FLESH_WAV		"CLUB_HIT_FLESH_WAV"
#define		STUNNER_BUZZ_WAV		"STUNNER_BUZZ_WAV"
#define		STUNNER_ZAP_WAV		"STUNNER_ZAP_WAV"
#define		SLUG_FIRE_WAV		"SLUG_FIRE_WAV"
#define		SLUG_HIT_WAV		"SLUG_HIT_WAV"
#define		GEM_THROW_WAV		"GEM_THROW_WAV"
#define		MONKEYSTONE_SECRET_STAR_WAV		"MONKEYSTONE_SECRET_STAR_WAV"
#define		CRATE_SLIDE_WAV		"CRATE_SLIDE_WAV"
#define		HEAVY_SLIDE_WAV		"HEAVY_SLIDE_WAV"
#define		LIGHT_SLIDE_WAV		"LIGHT_SLIDE_WAV"
#define		BARREL_EXPLODE_WAV		"BARREL_EXPLODE_WAV"
#define		BARREL_MELTING_WAV		"BARREL_MELTING_WAV"
#define		GUY_NOPUSH_SIZZLE_WAV		"GUY_NOPUSH_SIZZLE_WAV"
#define		SPLASH_WAV		"SPLASH_WAV"
#define		TELEPORT3_WAV		"TELEPORT3_WAV"
#define		FALL_DOWN_HOLE_WAV		"FALL_DOWN_HOLE_WAV"
#define		SLIME_BURN_WAV		"SLIME_BURN_WAV"
#define		PLASMAFLOOR_SLIDE_WAV		"PLASMAFLOOR_SLIDE_WAV"
#define		LASERD_PUSH_WAV		"LASERD_PUSH_WAV"
#define		MENU_ACCEPT_WAV		"MENU_ACCEPT_WAV"
#define		MENU_BACKOUT_WAV		"MENU_BACKOUT_WAV"
#define		MENU_SLIDER_WAV		"MENU_SLIDER_WAV"
#define		POP_WAV		"POP_WAV"
#define		BURP_WAV		"BURP_WAV"
#define		TELEPORT3_WAV		"TELEPORT3_WAV"
#define		DIALOG_OPEN_WAV		"DIALOG_OPEN_WAV"
#define		DIALOG_CLOSE_WAV		"DIALOG_CLOSE_WAV"
#define		FUTUREBEEP2_WAV		"FUTUREBEEP2_WAV"
#define		INV_SELECT_WAV		"INV_SELECT_WAV"
#define		MOVE_SELECTION_WAV		"MOVE_SELECTION_WAV"
#define		CELLHOLDER_USE_REJECT_WAV		"CELLHOLDER_USE_REJECT_WAV"
#define		DOOR_OPEN_CLOSE_WAV		"DOOR_OPEN_CLOSE_WAV"
#define		SWITCH_USE_WAV		"SWITCH_USE_WAV"
#define		AIRLOCK_CLOSE_WAV		"AIRLOCK_CLOSE_WAV"
#define		TOUCHPLATE_CLICK_WAV		"TOUCHPLATE_CLICK_WAV"
#define		INSERT_CELL_WAV		"INSERT_CELL_WAV"
#define		CABINET_OPEN_WAV		"CABINET_OPEN_WAV"
#define		CABINET_CLOSE_WAV		"CABINET_CLOSE_WAV"
#define		BRIDGE_EXTEND_WAV		"BRIDGE_EXTEND_WAV"
#define		BRIDGE_START_WAV		"BRIDGE_START_WAV"
#define		BRIDGE_END_WAV		"BRIDGE_END_WAV"
#define		COMPUTERPROCESS_WAV		"COMPUTERPROCESS_WAV"
#define		MAILSORTER_HAPPY_WAV		"MAILSORTER_HAPPY_WAV"
#define		MAILSORTER_UNHAPPY_WAV		"MAILSORTER_UNHAPPY_WAV"
#define		NOTICE_WAV		"NOTICE_WAV"
#define		MAINTBOT_WHOOSH1_WAV		"MAINTBOT_WHOOSH1_WAV"
#define		MAINTBOT_WHOOSH2_WAV		"MAINTBOT_WHOOSH2_WAV"
#define		SHIP_MOVING_INTRO_WAV		"SHIP_MOVING_INTRO_WAV"
#define		LASER_LOOP_WAV		"LASER_LOOP_WAV"
#define		INFOCOMP_WAV		"INFOCOMP_WAV"
#define		SLOT_SPIN_WAV		"SLOT_SPIN_WAV"
#define		SLOT_STOP_WAV		"SLOT_STOP_WAV"
#define		SLOT_WIN_WAV		"SLOT_WIN_WAV"
#define		CLOCK_BONK_WAV		"CLOCK_BONK_WAV"
#define		PASSCODE_CORRECT_WAV		"PASSCODE_CORRECT_WAV"
#define		SLOTMACHINE_SPINS_WAV		"SLOTMACHINE_SPINS_WAV"
#define		SLOTMACHINE_STOP_WAV		"SLOTMACHINE_STOP_WAV"
#define		SLOTMACHINE_WIN_WAV		"SLOTMACHINE_WIN_WAV"
#define		PANIC_WAV		"PANIC_WAV"
#define		PANIC_TIMER_WAV		"PANIC_TIMER_WAV"
#define		PANIC_DEATH_WAV		"PANIC_DEATH_WAV"
#define		QUEST_COMPLETE_WAV		"QUEST_COMPLETE_WAV"
#define		QUEST_FAILED_WAV		"QUEST_FAILED_WAV"
#define		TRY_AGAIN_WAV		"TRY_AGAIN_WAV"
#define		MONKEY_OOHOOH_WAV		"MONKEY_OOHOOH_WAV"
#define		MONKEY_WIN_WAV		"MONKEY_WIN_WAV"
#define		BYE_WAV		"BYE_WAV"
#define		HDB_WAV		"HDB_WAV"
#define		VORTEXIAN_SAVE_WAV		"VORTEXIAN_SAVE_WAV"
#define		UNLOCKED_ITEM_WAV		"UNLOCKED_ITEM_WAV"
#define		BEEPBEEPBEEP_WAV		"BEEPBEEPBEEP_WAV"
#define		MACHINE_AMBIENT1_WAV		"MACHINE_AMBIENT1_WAV"
#define		M00_AIRLOCK_01_MP3		"M00_AIRLOCK_01_MP3"
#define		M00_ARNIE_01_MP3		"M00_ARNIE_01_MP3"
#define		M00_BRAD_01_MP3		"M00_BRAD_01_MP3"
#define		M00_BRAD_02_MP3		"M00_BRAD_02_MP3"
#define		M00_BRAD_03_MP3		"M00_BRAD_03_MP3"
#define		M00_BUSTER_01_MP3		"M00_BUSTER_01_MP3"
#define		M00_BUSTER_02_MP3		"M00_BUSTER_02_MP3"
#define		M00_BUSTER_03_MP3		"M00_BUSTER_03_MP3"
#define		M00_BUSTER_04_MP3		"M00_BUSTER_04_MP3"
#define		M00_BUSTER_05_MP3		"M00_BUSTER_05_MP3"
#define		M00_BUSTER_06_MP3		"M00_BUSTER_06_MP3"
#define		M00_BUSTER_07_MP3		"M00_BUSTER_07_MP3"
#define		M00_BUSTER_08_MP3		"M00_BUSTER_08_MP3"
#define		M00_BUSTER_09_MP3		"M00_BUSTER_09_MP3"
#define		M00_BUSTER_10_MP3		"M00_BUSTER_10_MP3"
#define		M00_BUSTER_11_MP3		"M00_BUSTER_11_MP3"
#define		M00_BUSTER_12_MP3		"M00_BUSTER_12_MP3"
#define		M00_BUSTER_13A_MP3		"M00_BUSTER_13A_MP3"
#define		M00_BUSTER_13B_MP3		"M00_BUSTER_13B_MP3"
#define		M00_BUSTER_14_MP3		"M00_BUSTER_14_MP3"
#define		M00_BUSTER_15_MP3		"M00_BUSTER_15_MP3"
#define		M00_BUSTER_16_MP3		"M00_BUSTER_16_MP3"
#define		M00_BUSTER_17_MP3		"M00_BUSTER_17_MP3"
#define		M00_BUSTER_18_MP3		"M00_BUSTER_18_MP3"
#define		M00_BUSTER_19_MP3		"M00_BUSTER_19_MP3"
#define		M00_CHICKEN_01_MP3		"M00_CHICKEN_01_MP3"
#define		M00_CHUTEGUARD_01_MP3		"M00_CHUTEGUARD_01_MP3"
#define		M00_CHUTEGUARD_02_MP3		"M00_CHUTEGUARD_02_MP3"
#define		M00_CHUTEGUARD_03_MP3		"M00_CHUTEGUARD_03_MP3"
#define		M00_CHUTEGUARD_04_MP3		"M00_CHUTEGUARD_04_MP3"
#define		M00_CHUTEGUARD_05_MP3		"M00_CHUTEGUARD_05_MP3"
#define		M00_COOPER_01_MP3		"M00_COOPER_01_MP3"
#define		M00_COOPER_02_MP3		"M00_COOPER_02_MP3"
#define		M00_COOPER_03_MP3		"M00_COOPER_03_MP3"
#define		M00_COOPER_04_MP3		"M00_COOPER_04_MP3"
#define		M00_COOPER_05_MP3		"M00_COOPER_05_MP3"
#define		M00_DINERS_01_MP3		"M00_DINERS_01_MP3"
#define		M00_DINERS_02_MP3		"M00_DINERS_02_MP3"
#define		M00_DINERS_03_MP3		"M00_DINERS_03_MP3"
#define		M00_DINERS_04_MP3		"M00_DINERS_04_MP3"
#define		M00_DINERS_05_MP3		"M00_DINERS_05_MP3"
#define		M00_DINERS_06_MP3		"M00_DINERS_06_MP3"
#define		M00_DOLLY_01_MP3		"M00_DOLLY_01_MP3"
#define		M00_DOLLY_02_MP3		"M00_DOLLY_02_MP3"
#define		M00_DOLLY_03_MP3		"M00_DOLLY_03_MP3"
#define		M00_DOLLY_04_MP3		"M00_DOLLY_04_MP3"
#define		M00_DOLLY_05_MP3		"M00_DOLLY_05_MP3"
#define		M00_DOLLY_06_MP3		"M00_DOLLY_06_MP3"
#define		M00_DOLLY_07_MP3		"M00_DOLLY_07_MP3"
#define		M00_DOLLY_08_MP3		"M00_DOLLY_08_MP3"
#define		M00_DOLLY_09_MP3		"M00_DOLLY_09_MP3"
#define		M00_DOREK_01_MP3		"M00_DOREK_01_MP3"
#define		M00_DOREK_02_MP3		"M00_DOREK_02_MP3"
#define		M00_DOREK_03_MP3		"M00_DOREK_03_MP3"
#define		M00_DOREK_04_MP3		"M00_DOREK_04_MP3"
#define		M00_ENGCOMPUTER_01_MP3		"M00_ENGCOMPUTER_01_MP3"
#define		M00_ENGCOMPUTER_02_MP3		"M00_ENGCOMPUTER_02_MP3"
#define		M00_FARBLE_01_MP3		"M00_FARBLE_01_MP3"
#define		M00_FARBLE_02_MP3		"M00_FARBLE_02_MP3"
#define		M00_FARBLE_03_MP3		"M00_FARBLE_03_MP3"
#define		M00_FARBLE_04_MP3		"M00_FARBLE_04_MP3"
#define		M00_FARBLE_05_MP3		"M00_FARBLE_05_MP3"
#define		M00_FARBLE_06_MP3		"M00_FARBLE_06_MP3"
#define		M00_FARBLE_07_MP3		"M00_FARBLE_07_MP3"
#define		M00_FARBLE_08_MP3		"M00_FARBLE_08_MP3"
#define		M00_GRUNETT_01_MP3		"M00_GRUNETT_01_MP3"
#define		M00_GRUNETT_02_MP3		"M00_GRUNETT_02_MP3"
#define		M00_GRUNETT_03_MP3		"M00_GRUNETT_03_MP3"
#define		M00_GRUNETT_04_MP3		"M00_GRUNETT_04_MP3"
#define		M00_GUY_01_MP3		"M00_GUY_01_MP3"
#define		M00_GUY_02_MP3		"M00_GUY_02_MP3"
#define		M00_GUY_03_MP3		"M00_GUY_03_MP3"
#define		M00_GUY_04_MP3		"M00_GUY_04_MP3"
#define		M00_GUY_05_MP3		"M00_GUY_05_MP3"
#define		M00_GUY_06_MP3		"M00_GUY_06_MP3"
#define		M00_GUY_07_MP3		"M00_GUY_07_MP3"
#define		M00_GUY_08_MP3		"M00_GUY_08_MP3"
#define		M00_GUY_09_MP3		"M00_GUY_09_MP3"
#define		M00_GUY_10A_MP3		"M00_GUY_10A_MP3"
#define		M00_GUY_10B_MP3		"M00_GUY_10B_MP3"
#define		M00_GUY_11_MP3		"M00_GUY_11_MP3"
#define		M00_GUY_12_MP3		"M00_GUY_12_MP3"
#define		M00_GUY_13_MP3		"M00_GUY_13_MP3"
#define		M00_GUY_14_MP3		"M00_GUY_14_MP3"
#define		M00_GUY_15_MP3		"M00_GUY_15_MP3"
#define		M00_GUY_16_MP3		"M00_GUY_16_MP3"
#define		M00_GUY_17_MP3		"M00_GUY_17_MP3"
#define		M00_GUY_18_MP3		"M00_GUY_18_MP3"
#define		M00_HUMBERT_01_MP3		"M00_HUMBERT_01_MP3"
#define		M00_HUMBERT_02_MP3		"M00_HUMBERT_02_MP3"
#define		M00_ILLIAC_01_MP3		"M00_ILLIAC_01_MP3"
#define		M00_INFOCOMP_01_MP3		"M00_INFOCOMP_01_MP3"
#define		M00_JAQUES_01_MP3		"M00_JAQUES_01_MP3"
#define		M00_JAQUES_03_MP3		"M00_JAQUES_03_MP3"
#define		M00_JAQUES_04_MP3		"M00_JAQUES_04_MP3"
#define		M00_JAQUES_05_MP3		"M00_JAQUES_05_MP3"
#define		M00_LUMBAR_01_MP3		"M00_LUMBAR_01_MP3"
#define		M00_MAILSORTER_01_MP3		"M00_MAILSORTER_01_MP3"
#define		M00_MAILSORTER_02_MP3		"M00_MAILSORTER_02_MP3"
#define		M00_MAILSORTER_03_MP3		"M00_MAILSORTER_03_MP3"
#define		M00_MAILSORTER_04_MP3		"M00_MAILSORTER_04_MP3"
#define		M00_MAILSORTER_05_MP3		"M00_MAILSORTER_05_MP3"
#define		M00_MAILSORTER_06_MP3		"M00_MAILSORTER_06_MP3"
#define		M00_MAILSORTER_07_MP3		"M00_MAILSORTER_07_MP3"
#define		M00_MAILSORTER_08_MP3		"M00_MAILSORTER_08_MP3"
#define		M00_MAILSORTER_09_MP3		"M00_MAILSORTER_09_MP3"
#define		M00_MAILSORTER_10_MP3		"M00_MAILSORTER_10_MP3"
#define		M00_MAILSORTER_11_MP3		"M00_MAILSORTER_11_MP3"
#define		M00_MAILSORTER_12_MP3		"M00_MAILSORTER_12_MP3"
#define		M00_MAILSORTER_13_MP3		"M00_MAILSORTER_13_MP3"
#define		M00_MAILSORTER_14_MP3		"M00_MAILSORTER_14_MP3"
#define		M00_MAILSORTER_15_MP3		"M00_MAILSORTER_15_MP3"
#define		M00_MANNY_01_MP3		"M00_MANNY_01_MP3"
#define		M00_MANNY_02_MP3		"M00_MANNY_02_MP3"
#define		M00_MANNY_03_MP3		"M00_MANNY_03_MP3"
#define		M00_MANNY_04_MP3		"M00_MANNY_04_MP3"
#define		M00_MANNY_05_MP3		"M00_MANNY_05_MP3"
#define		M00_MANNY_06_MP3		"M00_MANNY_06_MP3"
#define		M00_MANNY_07_MP3		"M00_MANNY_07_MP3"
#define		M00_MANNY_08_MP3		"M00_MANNY_08_MP3"
#define		M00_MANNY_09_MP3		"M00_MANNY_09_MP3"
#define		M00_MANNY_10_MP3		"M00_MANNY_10_MP3"
#define		M00_MANNY_11_MP3		"M00_MANNY_11_MP3"
#define		M00_MANNY_12_MP3		"M00_MANNY_12_MP3"
#define		M00_MANNY_13_MP3		"M00_MANNY_13_MP3"
#define		M00_MANNY_14_MP3		"M00_MANNY_14_MP3"
#define		M00_MANNY_15_MP3		"M00_MANNY_15_MP3"
#define		M00_MANNY_16_MP3		"M00_MANNY_16_MP3"
#define		M00_MANNY_17_MP3		"M00_MANNY_17_MP3"
#define		M00_MANNY_18_MP3		"M00_MANNY_18_MP3"
#define		M00_NOTEBRICK_01_MP3		"M00_NOTEBRICK_01_MP3"
#define		M00_PILOTS_01_MP3		"M00_PILOTS_01_MP3"
#define		M00_PILOTS_02_MP3		"M00_PILOTS_02_MP3"
#define		M00_POLONEY_01_MP3		"M00_POLONEY_01_MP3"
#define		M00_POLONEY_02_MP3		"M00_POLONEY_02_MP3"
#define		M00_POLONEY_03_MP3		"M00_POLONEY_03_MP3"
#define		M00_POLONEY_04_MP3		"M00_POLONEY_04_MP3"
#define		M00_POLONEY_05_MP3		"M00_POLONEY_05_MP3"
#define		M00_POLONEY_06_MP3		"M00_POLONEY_06_MP3"
#define		M00_SARGE_01_MP3		"M00_SARGE_01_MP3"
#define		M00_SARGE_02_MP3		"M00_SARGE_02_MP3"
#define		M00_SARGE_03_MP3		"M00_SARGE_03_MP3"
#define		M00_SARGE_04_MP3		"M00_SARGE_04_MP3"
#define		M00_SARGE_05_MP3		"M00_SARGE_05_MP3"
#define		M00_SARGE_06_MP3		"M00_SARGE_06_MP3"
#define		M00_SARGE_07_MP3		"M00_SARGE_07_MP3"
#define		M00_SARGE_08_MP3		"M00_SARGE_08_MP3"
#define		M00_SARGE_09_MP3		"M00_SARGE_09_MP3"
#define		M00_SARGE_10_MP3		"M00_SARGE_10_MP3"
#define		M00_SARGE_11_MP3		"M00_SARGE_11_MP3"
#define		M00_SARGE_12_MP3		"M00_SARGE_12_MP3"
#define		M00_SARGE_13_MP3		"M00_SARGE_13_MP3"
#define		M00_SARGE_14_MP3		"M00_SARGE_14_MP3"
#define		M00_SARGE_15_MP3		"M00_SARGE_15_MP3"
#define		M00_SARGE_16_MP3		"M00_SARGE_16_MP3"
#define		M01_ALABASTER_01_MP3		"M01_ALABASTER_01_MP3"
#define		M01_ALABASTER_02_MP3		"M01_ALABASTER_02_MP3"
#define		M01_ALABASTER_03_MP3		"M01_ALABASTER_03_MP3"
#define		M01_ALABASTER_04_MP3		"M01_ALABASTER_04_MP3"
#define		M01_ALABASTER_05_MP3		"M01_ALABASTER_05_MP3"
#define		M01_ALABASTER_06_MP3		"M01_ALABASTER_06_MP3"
#define		M01_BRAKER_01_MP3		"M01_BRAKER_01_MP3"
#define		M01_BRAKER_02_MP3		"M01_BRAKER_02_MP3"
#define		M01_BRAKER_03_MP3		"M01_BRAKER_03_MP3"
#define		M01_BRAKER_04_MP3		"M01_BRAKER_04_MP3"
#define		M01_CHISTE_01_MP3		"M01_CHISTE_01_MP3"
#define		M01_CHISTE_02_MP3		"M01_CHISTE_02_MP3"
#define		M01_CHISTE_03_MP3		"M01_CHISTE_03_MP3"
#define		M01_CHISTE_04_MP3		"M01_CHISTE_04_MP3"
#define		M01_CHISTE_05_MP3		"M01_CHISTE_05_MP3"
#define		M01_CHISTE_06_MP3		"M01_CHISTE_06_MP3"
#define		M01_CHISTE_07_MP3		"M01_CHISTE_07_MP3"
#define		M01_CHISTE_08_MP3		"M01_CHISTE_08_MP3"
#define		M01_CHISTE_09_MP3		"M01_CHISTE_09_MP3"
#define		M01_CHISTE_10_MP3		"M01_CHISTE_10_MP3"
#define		M01_CHISTE_11_MP3		"M01_CHISTE_11_MP3"
#define		M01_CHISTE_12_MP3		"M01_CHISTE_12_MP3"
#define		M01_CHISTE_13_MP3		"M01_CHISTE_13_MP3"
#define		M01_CHISTE_14_MP3		"M01_CHISTE_14_MP3"
#define		M01_COVERT_01_MP3		"M01_COVERT_01_MP3"
#define		M01_COVERT_02_MP3		"M01_COVERT_02_MP3"
#define		M01_COVERT_03_MP3		"M01_COVERT_03_MP3"
#define		M01_COVERT_04_MP3		"M01_COVERT_04_MP3"
#define		M01_COVERT_05_MP3		"M01_COVERT_05_MP3"
#define		M01_COVERT_06_MP3		"M01_COVERT_06_MP3"
#define		M01_COVERT_07_MP3		"M01_COVERT_07_MP3"
#define		M01_COVERT_08_MP3		"M01_COVERT_08_MP3"
#define		M01_COVERT_09_MP3		"M01_COVERT_09_MP3"
#define		M01_COVERT_10_MP3		"M01_COVERT_10_MP3"
#define		M01_COVERT_11_MP3		"M01_COVERT_11_MP3"
#define		M01_COVERT_12_MP3		"M01_COVERT_12_MP3"
#define		M01_COVERT_13_MP3		"M01_COVERT_13_MP3"
#define		M01_DAGEAUBE_01_MP3		"M01_DAGEAUBE_01_MP3"
#define		M01_DAGEAUBE_02_MP3		"M01_DAGEAUBE_02_MP3"
#define		M01_DAGEAUBE_03_MP3		"M01_DAGEAUBE_03_MP3"
#define		M01_DAGEAUBE_04_MP3		"M01_DAGEAUBE_04_MP3"
#define		M01_DAGEAUBE_05_MP3		"M01_DAGEAUBE_05_MP3"
#define		M01_EMC2_01_MP3		"M01_EMC2_01_MP3"
#define		M01_EMC2_02_MP3		"M01_EMC2_02_MP3"
#define		M01_GIZZARD_01_MP3		"M01_GIZZARD_01_MP3"
#define		M01_GIZZARD_02_MP3		"M01_GIZZARD_02_MP3"
#define		M01_GUY_01_MP3		"M01_GUY_01_MP3"
#define		M01_GUY_02_MP3		"M01_GUY_02_MP3"
#define		M01_GUY_03_MP3		"M01_GUY_03_MP3"
#define		M01_GUY_04_MP3		"M01_GUY_04_MP3"
#define		M01_GUY_05_MP3		"M01_GUY_05_MP3"
#define		M01_HIDROW_01_MP3		"M01_HIDROW_01_MP3"
#define		M01_HIDROW_02_MP3		"M01_HIDROW_02_MP3"
#define		M01_HIDROW_03_MP3		"M01_HIDROW_03_MP3"
#define		M01_KEBOTTLE_01_MP3		"M01_KEBOTTLE_01_MP3"
#define		M01_KEBOTTLE_02_MP3		"M01_KEBOTTLE_02_MP3"
#define		M01_KEBOTTLE_03_MP3		"M01_KEBOTTLE_03_MP3"
#define		M01_KEBOTTLE_04_MP3		"M01_KEBOTTLE_04_MP3"
#define		M01_KEBOTTLE_05_MP3		"M01_KEBOTTLE_05_MP3"
#define		M01_KEBOTTLE_06_MP3		"M01_KEBOTTLE_06_MP3"
#define		M01_KEBOTTLE_07_MP3		"M01_KEBOTTLE_07_MP3"
#define		M01_PONTE_01_MP3		"M01_PONTE_01_MP3"
#define		M01_PONTE_02_MP3		"M01_PONTE_02_MP3"
#define		M01_PONTE_03_MP3		"M01_PONTE_03_MP3"
#define		M01_PONTE_04_MP3		"M01_PONTE_04_MP3"
#define		M01_PONTE_05_MP3		"M01_PONTE_05_MP3"
#define		M01_PONTE_06_MP3		"M01_PONTE_06_MP3"
#define		M01_PONTE_07_MP3		"M01_PONTE_07_MP3"
#define		M01_PONTE_08_MP3		"M01_PONTE_08_MP3"
#define		M01_PONTE_09_MP3		"M01_PONTE_09_MP3"
#define		M01_PONTE_10_MP3		"M01_PONTE_10_MP3"
#define		M01_POPOPOLIS_01_MP3		"M01_POPOPOLIS_01_MP3"
#define		M01_POPOPOLIS_02_MP3		"M01_POPOPOLIS_02_MP3"
#define		M01_POPOPOLIS_03_MP3		"M01_POPOPOLIS_03_MP3"
#define		M01_POPOPOLIS_04_MP3		"M01_POPOPOLIS_04_MP3"
#define		M01_POPOPOLIS_05_MP3		"M01_POPOPOLIS_05_MP3"
#define		M01_POPOPOLIS_06_MP3		"M01_POPOPOLIS_06_MP3"
#define		M01_POPOPOLIS_07_MP3		"M01_POPOPOLIS_07_MP3"
#define		M01_POPOPOLIS_08_MP3		"M01_POPOPOLIS_08_MP3"
#define		M01_POPOPOLIS_09_MP3		"M01_POPOPOLIS_09_MP3"
#define		M01_POPOPOLIS_10_MP3		"M01_POPOPOLIS_10_MP3"
#define		M01_POPOPOLIS_11_MP3		"M01_POPOPOLIS_11_MP3"
#define		M01_POPOPOLIS_12_MP3		"M01_POPOPOLIS_12_MP3"
#define		M01_POPOPOLIS_13_MP3		"M01_POPOPOLIS_13_MP3"
#define		M01_POPOPOLIS_14_MP3		"M01_POPOPOLIS_14_MP3"
#define		M01_POPOPOLIS_15_MP3		"M01_POPOPOLIS_15_MP3"
#define		M01_POPOPOLIS_16_MP3		"M01_POPOPOLIS_16_MP3"
#define		M01_POPOPOLIS_17_MP3		"M01_POPOPOLIS_17_MP3"
#define		M01_POPOPOLIS_18_MP3		"M01_POPOPOLIS_18_MP3"
#define		M01_POPOPOLIS_19_MP3		"M01_POPOPOLIS_19_MP3"
#define		M01_POPOPOLIS_20_MP3		"M01_POPOPOLIS_20_MP3"
#define		M01_POPOPOLIS_21_MP3		"M01_POPOPOLIS_21_MP3"
#define		M01_POPOPOLIS_22_MP3		"M01_POPOPOLIS_22_MP3"
#define		M01_POPOPOLIS_23_MP3		"M01_POPOPOLIS_23_MP3"
#define		M01_POPOPOLIS_24_MP3		"M01_POPOPOLIS_24_MP3"
#define		M01_POPOPOLIS_25_MP3		"M01_POPOPOLIS_25_MP3"
#define		M01_POPOPOLIS_26_MP3		"M01_POPOPOLIS_26_MP3"
#define		M01_POPOPOLIS_27_MP3		"M01_POPOPOLIS_27_MP3"
#define		M01_POPOPOLIS_28_MP3		"M01_POPOPOLIS_28_MP3"
#define		M01_POPOPOLIS_29_MP3		"M01_POPOPOLIS_29_MP3"
#define		M01_POPOPOLIS_30_MP3		"M01_POPOPOLIS_30_MP3"
#define		M01_POPOPOLIS_31_MP3		"M01_POPOPOLIS_31_MP3"
#define		M01_POPOPOLIS_32_MP3		"M01_POPOPOLIS_32_MP3"
#define		M01_POPOPOLIS_33_MP3		"M01_POPOPOLIS_33_MP3"
#define		M01_POPOPOLIS_34_MP3		"M01_POPOPOLIS_34_MP3"
#define		M01_POPOPOLIS_35_MP3		"M01_POPOPOLIS_35_MP3"
#define		M01_POPOPOLIS_36_MP3		"M01_POPOPOLIS_36_MP3"
#define		M01_POPOPOLIS_37_MP3		"M01_POPOPOLIS_37_MP3"
#define		M01_SARGE_01_MP3		"M01_SARGE_01_MP3"
#define		M01_SARGE_02_MP3		"M01_SARGE_02_MP3"
#define		M01_SARGE_03_MP3		"M01_SARGE_03_MP3"
#define		M01_SARGE_04_MP3		"M01_SARGE_04_MP3"
#define		M01_SOBREDELLE_01_MP3		"M01_SOBREDELLE_01_MP3"
#define		M01_SOBREDELLE_02_MP3		"M01_SOBREDELLE_02_MP3"
#define		M01_SOBREDELLE_03_MP3		"M01_SOBREDELLE_03_MP3"
#define		M01_WAYNE_01_MP3		"M01_WAYNE_01_MP3"
#define		M01_WAYNE_02_MP3		"M01_WAYNE_02_MP3"
#define		M01_ZIQUOZ_01_MP3		"M01_ZIQUOZ_01_MP3"
#define		M01_ZIQUOZ_02_MP3		"M01_ZIQUOZ_02_MP3"
#define		M01_ZIQUOZ_03_MP3		"M01_ZIQUOZ_03_MP3"
#define		M02_AGUSTO_01_MP3		"M02_AGUSTO_01_MP3"
#define		M02_AGUSTO_02_MP3		"M02_AGUSTO_02_MP3"
#define		M02_ALBONDIGAS_01_MP3		"M02_ALBONDIGAS_01_MP3"
#define		M02_ALBONDIGAS_02_MP3		"M02_ALBONDIGAS_02_MP3"
#define		M02_BUMPER_01_MP3		"M02_BUMPER_01_MP3"
#define		M02_BUMPER_02_MP3		"M02_BUMPER_02_MP3"
#define		M02_BUMPER_03_MP3		"M02_BUMPER_03_MP3"
#define		M02_BUMPER_04_MP3		"M02_BUMPER_04_MP3"
#define		M02_BUMPER_05_MP3		"M02_BUMPER_05_MP3"
#define		M02_BUMPER_06_MP3		"M02_BUMPER_06_MP3"
#define		M02_BUMPER_07_MP3		"M02_BUMPER_07_MP3"
#define		M02_DELGADO_01_MP3		"M02_DELGADO_01_MP3"
#define		M02_FEBRARO_01_MP3		"M02_FEBRARO_01_MP3"
#define		M02_GUY_01_MP3		"M02_GUY_01_MP3"
#define		M02_GUY_02_MP3		"M02_GUY_02_MP3"
#define		M03_ACROPHO_01_MP3		"M03_ACROPHO_01_MP3"
#define		M03_ACROPHO_02_MP3		"M03_ACROPHO_02_MP3"
#define		M03_ACROPHO_03_MP3		"M03_ACROPHO_03_MP3"
#define		M03_ACROPHO_04_MP3		"M03_ACROPHO_04_MP3"
#define		M03_ENERO_01_MP3		"M03_ENERO_01_MP3"
#define		M03_ENERO_02_MP3		"M03_ENERO_02_MP3"
#define		M03_ENERO_03_MP3		"M03_ENERO_03_MP3"
#define		M03_ENERO_04_MP3		"M03_ENERO_04_MP3"
#define		M03_ENERO_05_MP3		"M03_ENERO_05_MP3"
#define		M03_GAIA_01_MP3		"M03_GAIA_01_MP3"
#define		M03_GAIA_02_MP3		"M03_GAIA_02_MP3"
#define		M03_GAIA_03_MP3		"M03_GAIA_03_MP3"
#define		M03_GAIA_04_MP3		"M03_GAIA_04_MP3"
#define		M03_GAIA_05_MP3		"M03_GAIA_05_MP3"
#define		M03_GAIA_06_MP3		"M03_GAIA_06_MP3"
#define		M03_LAGO_01_MP3		"M03_LAGO_01_MP3"
#define		M03_LAGO_02_MP3		"M03_LAGO_02_MP3"
#define		M03_LAGO_04_MP3		"M03_LAGO_04_MP3"
#define		M03_LAGO_05_MP3		"M03_LAGO_05_MP3"
#define		M03_LAGO_06_MP3		"M03_LAGO_06_MP3"
#define		M03_LAGO_07_MP3		"M03_LAGO_07_MP3"
#define		M04_BONIFACE_01_MP3		"M04_BONIFACE_01_MP3"
#define		M04_BONIFACE_02_MP3		"M04_BONIFACE_02_MP3"
#define		M04_BONIFACE_03_MP3		"M04_BONIFACE_03_MP3"
#define		M04_BONIFACE_04_MP3		"M04_BONIFACE_04_MP3"
#define		M04_BONIFACE_05_MP3		"M04_BONIFACE_05_MP3"
#define		M04_BONIFACE_06_MP3		"M04_BONIFACE_06_MP3"
#define		M04_BONIFACE_07_MP3		"M04_BONIFACE_07_MP3"
#define		M04_JULIO_01_MP3		"M04_JULIO_01_MP3"
#define		M04_JULIO_02_MP3		"M04_JULIO_02_MP3"
#define		M04_JULIO_04_MP3		"M04_JULIO_04_MP3"
#define		M04_MARZO_01_MP3		"M04_MARZO_01_MP3"
#define		M04_OCTUBRE_01_MP3		"M04_OCTUBRE_01_MP3"
#define		M04_OCTUBRE_02_MP3		"M04_OCTUBRE_02_MP3"
#define		M04_OCTUBRE_03_MP3		"M04_OCTUBRE_03_MP3"
#define		M05_ABRIL_01_MP3		"M05_ABRIL_01_MP3"
#define		M05_ABRIL_02_MP3		"M05_ABRIL_02_MP3"
#define		M05_ABRIL_03_MP3		"M05_ABRIL_03_MP3"
#define		M05_ABRIL_04_MP3		"M05_ABRIL_04_MP3"
#define		M05_ABRIL_05_MP3		"M05_ABRIL_05_MP3"
#define		M05_EVERLOO_01_MP3		"M05_EVERLOO_01_MP3"
#define		M05_EVERLOO_02_MP3		"M05_EVERLOO_02_MP3"
#define		M05_EVERLOO_03_MP3		"M05_EVERLOO_03_MP3"
#define		M05_EVERLOO_04_MP3		"M05_EVERLOO_04_MP3"
#define		M05_GELIGELLA_01_MP3		"M05_GELIGELLA_01_MP3"
#define		M05_GELIGELLA_02_MP3		"M05_GELIGELLA_02_MP3"
#define		M05_RAILRIDER_01_MP3		"M05_RAILRIDER_01_MP3"
#define		M05_RAILRIDER_02_MP3		"M05_RAILRIDER_02_MP3"
#define		M05_RAILRIDER_03_MP3		"M05_RAILRIDER_03_MP3"
#define		M05_RAILRIDER_04_MP3		"M05_RAILRIDER_04_MP3"
#define		M06_AZUL_01_MP3		"M06_AZUL_01_MP3"
#define		M06_AZUL_02_MP3		"M06_AZUL_02_MP3"
#define		M06_AZUL_03_MP3		"M06_AZUL_03_MP3"
#define		M06_AZUL_04_MP3		"M06_AZUL_04_MP3"
#define		M06_AZUL_05_MP3		"M06_AZUL_05_MP3"
#define		M06_AZUL_06_MP3		"M06_AZUL_06_MP3"
#define		M06_AZUL_07_MP3		"M06_AZUL_07_MP3"
#define		M06_AZUL_08_MP3		"M06_AZUL_08_MP3"
#define		M06_GUY_01_MP3		"M06_GUY_01_MP3"
#define		M06_GUY_02_MP3		"M06_GUY_02_MP3"
#define		M06_GUY_03_MP3		"M06_GUY_03_MP3"
#define		M06_GUY_04_MP3		"M06_GUY_04_MP3"
#define		M06_HANSON_01_MP3		"M06_HANSON_01_MP3"
#define		M06_HANSON_03_MP3		"M06_HANSON_03_MP3"
#define		M06_HANSON_04_MP3		"M06_HANSON_04_MP3"
#define		M06_HANSON_05_MP3		"M06_HANSON_05_MP3"
#define		M06_HANSON_06_MP3		"M06_HANSON_06_MP3"
#define		M06_HANSON_07_MP3		"M06_HANSON_07_MP3"
#define		M06_HANSON_08_MP3		"M06_HANSON_08_MP3"
#define		M06_HANSON_09_MP3		"M06_HANSON_09_MP3"
#define		M06_HANSON_10_MP3		"M06_HANSON_10_MP3"
#define		M06_HANSON_11_MP3		"M06_HANSON_11_MP3"
#define		M06_HANSON_12_MP3		"M06_HANSON_12_MP3"
#define		M06_JUNIO_01_MP3		"M06_JUNIO_01_MP3"
#define		M06_JUNIO_02_MP3		"M06_JUNIO_02_MP3"
#define		M06_JUNIO_03_MP3		"M06_JUNIO_03_MP3"
#define		M06_JUNIO_04_MP3		"M06_JUNIO_04_MP3"
#define		M06_JUNIO_05_MP3		"M06_JUNIO_05_MP3"
#define		M06_JUNIO_06_MP3		"M06_JUNIO_06_MP3"
#define		M06_JUNIO_07_MP3		"M06_JUNIO_07_MP3"
#define		M06_JUNIO_08_MP3		"M06_JUNIO_08_MP3"
#define		M06_JUNIO_09_MP3		"M06_JUNIO_09_MP3"
#define		M06_NARANJA_01_MP3		"M06_NARANJA_01_MP3"
#define		M06_NARANJA_02_MP3		"M06_NARANJA_02_MP3"
#define		M06_NARANJA_03_MP3		"M06_NARANJA_03_MP3"
#define		M06_NARANJA_04_MP3		"M06_NARANJA_04_MP3"
#define		M06_NARANJA_05_MP3		"M06_NARANJA_05_MP3"
#define		M06_SEPTEMBRE_01_MP3		"M06_SEPTEMBRE_01_MP3"
#define		M06_SEPTEMBRE_02_MP3		"M06_SEPTEMBRE_02_MP3"
#define		M06_SEPTEMBRE_03_MP3		"M06_SEPTEMBRE_03_MP3"
#define		M06_SEPTEMBRE_04_MP3		"M06_SEPTEMBRE_04_MP3"
#define		M06_SEPTEMBRE_05_MP3		"M06_SEPTEMBRE_05_MP3"
#define		M06_SEPTEMBRE_06_MP3		"M06_SEPTEMBRE_06_MP3"
#define		M06_SEPTEMBRE_07_MP3		"M06_SEPTEMBRE_07_MP3"
#define		M06_SEPTEMBRE_08_MP3		"M06_SEPTEMBRE_08_MP3"
#define		M06_SEPTEMBRE_09_MP3		"M06_SEPTEMBRE_09_MP3"
#define		M06_WORKER_01_MP3		"M06_WORKER_01_MP3"
#define		M06_WORKER_02_MP3		"M06_WORKER_02_MP3"
#define		M06_WORKER_03_MP3		"M06_WORKER_03_MP3"
#define		M06_WORKER_04_MP3		"M06_WORKER_04_MP3"
#define		M07_CERCO_01_MP3		"M07_CERCO_01_MP3"
#define		M07_CERCO_02_MP3		"M07_CERCO_02_MP3"
#define		M07_COMPUTER_01_MP3		"M07_COMPUTER_01_MP3"
#define		M07_MAYO_01_MP3		"M07_MAYO_01_MP3"
#define		M07_MAYO_02_MP3		"M07_MAYO_02_MP3"
#define		M07_NOVIEMBRE_01_MP3		"M07_NOVIEMBRE_01_MP3"
#define		M07_NOVIEMBRE_02_MP3		"M07_NOVIEMBRE_02_MP3"
#define		M07_NOVIEMBRE_03_MP3		"M07_NOVIEMBRE_03_MP3"
#define		M07_PANITO_01_MP3		"M07_PANITO_01_MP3"
#define		M07_PANITO_02_MP3		"M07_PANITO_02_MP3"
#define		M07_PANITO_03_MP3		"M07_PANITO_03_MP3"
#define		M07_PANITO_04_MP3		"M07_PANITO_04_MP3"
#define		M07_PANITO_05_MP3		"M07_PANITO_05_MP3"
#define		M08_COOKIE_01_MP3		"M08_COOKIE_01_MP3"
#define		M08_COOKIE_02_MP3		"M08_COOKIE_02_MP3"
#define		M08_DICIEMBRE_01_MP3		"M08_DICIEMBRE_01_MP3"
#define		M08_GUY_01_MP3		"M08_GUY_01_MP3"
#define		M08_GUY_02_MP3		"M08_GUY_02_MP3"
#define		M08_GUY_03_MP3		"M08_GUY_03_MP3"
#define		M08_MACHINA_01_MP3		"M08_MACHINA_01_MP3"
#define		M08_MACHINA_02_MP3		"M08_MACHINA_02_MP3"
#define		M08_MACHINA_03_MP3		"M08_MACHINA_03_MP3"
#define		M08_MACHINA_04_MP3		"M08_MACHINA_04_MP3"
#define		M08_MACHINA_05_MP3		"M08_MACHINA_05_MP3"
#define		M08_MACHINA_06_MP3		"M08_MACHINA_06_MP3"
#define		M08_MACHINA_07_MP3		"M08_MACHINA_07_MP3"
#define		M08_MACHINA_08_MP3		"M08_MACHINA_08_MP3"
#define		M08_MACHINA_09_MP3		"M08_MACHINA_09_MP3"
#define		M08_MESA_01_MP3		"M08_MESA_01_MP3"
#define		M08_MESA_02_MP3		"M08_MESA_02_MP3"
#define		M08_MESA_03_MP3		"M08_MESA_03_MP3"
#define		M08_MESA_04_MP3		"M08_MESA_04_MP3"
#define		M08_SHAKIR_01_MP3		"M08_SHAKIR_01_MP3"
#define		M08_SHAKIR_02_MP3		"M08_SHAKIR_02_MP3"
#define		M08_SHAKIR_03_MP3		"M08_SHAKIR_03_MP3"
#define		M09_VIOLETA_01_MP3		"M09_VIOLETA_01_MP3"
#define		M09_VIOLETA_02_MP3		"M09_VIOLETA_02_MP3"
#define		M09_VIOLETA_03_MP3		"M09_VIOLETA_03_MP3"
#define		M09_VIOLETA_04_MP3		"M09_VIOLETA_04_MP3"
#define		M10_CHICKEN_01_MP3		"M10_CHICKEN_01_MP3"
#define		M10_COOPER_01_MP3		"M10_COOPER_01_MP3"
#define		M10_COOPER_02_MP3		"M10_COOPER_02_MP3"
#define		M10_COOPER_03_MP3		"M10_COOPER_03_MP3"
#define		M10_COOPER_04_MP3		"M10_COOPER_04_MP3"
#define		M10_COOPER_05_MP3		"M10_COOPER_05_MP3"
#define		M10_COOPER_06_MP3		"M10_COOPER_06_MP3"
#define		M10_COOPER_07_MP3		"M10_COOPER_07_MP3"
#define		M10_COOPER_08_MP3		"M10_COOPER_08_MP3"
#define		M10_COOPER_09_MP3		"M10_COOPER_09_MP3"
#define		M10_DOLLY_01_MP3		"M10_DOLLY_01_MP3"
#define		M10_DOLLY_02_MP3		"M10_DOLLY_02_MP3"
#define		M10_DOLLY_03_MP3		"M10_DOLLY_03_MP3"
#define		M10_DOLLY_04_MP3		"M10_DOLLY_04_MP3"
#define		M10_DOLLY_05_MP3		"M10_DOLLY_05_MP3"
#define		M10_DOLLY_06_MP3		"M10_DOLLY_06_MP3"
#define		M10_DOLLY_07_MP3		"M10_DOLLY_07_MP3"
#define		M10_DOLLY_08_MP3		"M10_DOLLY_08_MP3"
#define		M10_DOLLY_09_MP3		"M10_DOLLY_09_MP3"
#define		M10_DOLLY_10_MP3		"M10_DOLLY_10_MP3"
#define		M10_ENGCOMPUTER_01_MP3		"M10_ENGCOMPUTER_01_MP3"
#define		M10_FARBLE_01_MP3		"M10_FARBLE_01_MP3"
#define		M10_FARBLE_02_MP3		"M10_FARBLE_02_MP3"
#define		M10_FARBLE_03_MP3		"M10_FARBLE_03_MP3"
#define		M10_FARBLE_04_MP3		"M10_FARBLE_04_MP3"
#define		M10_FARBLE_05_MP3		"M10_FARBLE_05_MP3"
#define		M10_FARBLE_06_MP3		"M10_FARBLE_06_MP3"
#define		M10_GRUNETT_01_MP3		"M10_GRUNETT_01_MP3"
#define		M10_GRUNETT_02_MP3		"M10_GRUNETT_02_MP3"
#define		M10_GRUNETT_03_MP3		"M10_GRUNETT_03_MP3"
#define		M10_GRUNETT_04_MP3		"M10_GRUNETT_04_MP3"
#define		M10_GRUNETT_05_MP3		"M10_GRUNETT_05_MP3"
#define		M10_GRUNETT_06_MP3		"M10_GRUNETT_06_MP3"
#define		M10_GUY_01_MP3		"M10_GUY_01_MP3"
#define		M10_GUY_02_MP3		"M10_GUY_02_MP3"
#define		M10_GUY_03_MP3		"M10_GUY_03_MP3"
#define		M10_GUY_04_MP3		"M10_GUY_04_MP3"
#define		M10_GUY_05_MP3		"M10_GUY_05_MP3"
#define		M10_GUY_06_MP3		"M10_GUY_06_MP3"
#define		M10_GUY_07_MP3		"M10_GUY_07_MP3"
#define		M10_GUY_08_MP3		"M10_GUY_08_MP3"
#define		M10_INFOCOMP_01_MP3		"M10_INFOCOMP_01_MP3"
#define		M10_NOTEBRICK_01_MP3		"M10_NOTEBRICK_01_MP3"
#define		M10_PILOTS_01_MP3		"M10_PILOTS_01_MP3"
#define		M10_PILOTS_02_MP3		"M10_PILOTS_02_MP3"
#define		M10_PILOTS_03_MP3		"M10_PILOTS_03_MP3"
#define		M10_PILOTS_04_MP3		"M10_PILOTS_04_MP3"
#define		M10_PILOTS_05_MP3		"M10_PILOTS_05_MP3"
#define		M10_SARGE_01_MP3		"M10_SARGE_01_MP3"
#define		M10_SARGE_02_MP3		"M10_SARGE_02_MP3"
#define		M10_SARGE_03_MP3		"M10_SARGE_03_MP3"
#define		M10_SARGE_04_MP3		"M10_SARGE_04_MP3"
#define		M10_SARGE_05_MP3		"M10_SARGE_05_MP3"
#define		M11_ANCHOVY_01_MP3		"M11_ANCHOVY_01_MP3"
#define		M11_ANCHOVY_02_MP3		"M11_ANCHOVY_02_MP3"
#define		M11_ANCHOVY_03_MP3		"M11_ANCHOVY_03_MP3"
#define		M11_ANCHOVY_04_MP3		"M11_ANCHOVY_04_MP3"
#define		M11_ANCHOVY_05_MP3		"M11_ANCHOVY_05_MP3"
#define		M11_ARBIVALL_01_MP3		"M11_ARBIVALL_01_MP3"
#define		M11_ARBIVALL_02_MP3		"M11_ARBIVALL_02_MP3"
#define		M11_ARBIVALL_03_MP3		"M11_ARBIVALL_03_MP3"
#define		M11_ARBIVALL_04_MP3		"M11_ARBIVALL_04_MP3"
#define		M11_ARBIVALL_05_MP3		"M11_ARBIVALL_05_MP3"
#define		M11_ARBIVALL_06_MP3		"M11_ARBIVALL_06_MP3"
#define		M11_ARBIVALL_07_MP3		"M11_ARBIVALL_07_MP3"
#define		M11_ARNIE_01_MP3		"M11_ARNIE_01_MP3"
#define		M11_BELINDA_01_MP3		"M11_BELINDA_01_MP3"
#define		M11_BLOCK_01_MP3		"M11_BLOCK_01_MP3"
#define		M11_BLOCK_02_MP3		"M11_BLOCK_02_MP3"
#define		M11_BLOCK_03_MP3		"M11_BLOCK_03_MP3"
#define		M11_BRAD_01_MP3		"M11_BRAD_01_MP3"
#define		M11_BRAD_02_MP3		"M11_BRAD_02_MP3"
#define		M11_BRAD_03_MP3		"M11_BRAD_03_MP3"
#define		M11_BUSTER_01_MP3		"M11_BUSTER_01_MP3"
#define		M11_BUSTER_02_MP3		"M11_BUSTER_02_MP3"
#define		M11_BUSTER_03_MP3		"M11_BUSTER_03_MP3"
#define		M11_DINERS_01_MP3		"M11_DINERS_01_MP3"
#define		M11_DINERS_02_MP3		"M11_DINERS_02_MP3"
#define		M11_DOPPLER_01_MP3		"M11_DOPPLER_01_MP3"
#define		M11_DOPPLER_02_MP3		"M11_DOPPLER_02_MP3"
#define		M11_DOPPLER_03_MP3		"M11_DOPPLER_03_MP3"
#define		M11_DOPPLER_04_MP3		"M11_DOPPLER_04_MP3"
#define		M11_DOPPLER_05_MP3		"M11_DOPPLER_05_MP3"
#define		M11_DOREK_01_MP3		"M11_DOREK_01_MP3"
#define		M11_DOREK_02_MP3		"M11_DOREK_02_MP3"
#define		M11_DOREK_03_MP3		"M11_DOREK_03_MP3"
#define		M11_DOZER_01_MP3		"M11_DOZER_01_MP3"
#define		M11_DOZER_02_MP3		"M11_DOZER_02_MP3"
#define		M11_DOZER_03_MP3		"M11_DOZER_03_MP3"
#define		M11_DOZER_04_MP3		"M11_DOZER_04_MP3"
#define		M11_GNAPPE_01_MP3		"M11_GNAPPE_01_MP3"
#define		M11_GNAPPE_02_MP3		"M11_GNAPPE_02_MP3"
#define		M11_GNAPPE_03_MP3		"M11_GNAPPE_03_MP3"
#define		M11_GNAPPE_04_MP3		"M11_GNAPPE_04_MP3"
#define		M11_GNAPPE_05_MP3		"M11_GNAPPE_05_MP3"
#define		M11_GNODIMY_01_MP3		"M11_GNODIMY_01_MP3"
#define		M11_GNODIMY_02_MP3		"M11_GNODIMY_02_MP3"
#define		M11_GNODIMY_03_MP3		"M11_GNODIMY_03_MP3"
#define		M11_GNODIMY_04_MP3		"M11_GNODIMY_04_MP3"
#define		M11_GUY_01_MP3		"M11_GUY_01_MP3"
#define		M11_GUY_02_MP3		"M11_GUY_02_MP3"
#define		M11_GUY_03_MP3		"M11_GUY_03_MP3"
#define		M11_GUY_04_MP3		"M11_GUY_04_MP3"
#define		M11_GUY_05_MP3		"M11_GUY_05_MP3"
#define		M11_GUY_06_MP3		"M11_GUY_06_MP3"
#define		M11_GUY_07_MP3		"M11_GUY_07_MP3"
#define		M11_GUY_08_MP3		"M11_GUY_08_MP3"
#define		M11_GUY_09_MP3		"M11_GUY_09_MP3"
#define		M11_GUY_10_MP3		"M11_GUY_10_MP3"
#define		M11_GUY_11_MP3		"M11_GUY_11_MP3"
#define		M11_GUY_12_MP3		"M11_GUY_12_MP3"
#define		M11_GUY_13_MP3		"M11_GUY_13_MP3"
#define		M11_GUY_15_MP3		"M11_GUY_15_MP3"
#define		M11_GUY_16_MP3		"M11_GUY_16_MP3"
#define		M11_GUY_17_MP3		"M11_GUY_17_MP3"
#define		M11_HAMBRE_01_MP3		"M11_HAMBRE_01_MP3"
#define		M11_HAMBRE_02_MP3		"M11_HAMBRE_02_MP3"
#define		M11_HAMBRE_03_MP3		"M11_HAMBRE_03_MP3"
#define		M11_HAMBRE_04_MP3		"M11_HAMBRE_04_MP3"
#define		M11_HAMBRE_05_MP3		"M11_HAMBRE_05_MP3"
#define		M11_HUMBERT_01_MP3		"M11_HUMBERT_01_MP3"
#define		M11_ILLIAC_01_MP3		"M11_ILLIAC_01_MP3"
#define		M11_JAQUES_01_MP3		"M11_JAQUES_01_MP3"
#define		M11_JAQUES_02_MP3		"M11_JAQUES_02_MP3"
#define		M11_JAQUES_03_MP3		"M11_JAQUES_03_MP3"
#define		M11_JAQUES_04_MP3		"M11_JAQUES_04_MP3"
#define		M11_LUMBAR_01_MP3		"M11_LUMBAR_01_MP3"
#define		M11_MAN_IN_STALL_01_MP3		"M11_MAN_IN_STALL_01_MP3"
#define		M11_MAN_IN_STALL_02_MP3		"M11_MAN_IN_STALL_02_MP3"
#define		M11_MAN_IN_STALL_03_MP3		"M11_MAN_IN_STALL_03_MP3"
#define		M11_MAN_IN_STALL_04_MP3		"M11_MAN_IN_STALL_04_MP3"
#define		M11_MAN_IN_STALL_05_MP3		"M11_MAN_IN_STALL_05_MP3"
#define		M11_MANNY_01_MP3		"M11_MANNY_01_MP3"
#define		M11_MUMPS_01_MP3		"M11_MUMPS_01_MP3"
#define		M11_MUMPS_02_MP3		"M11_MUMPS_02_MP3"
#define		M11_MUMPS_03_MP3		"M11_MUMPS_03_MP3"
#define		M11_MUMPS_04_MP3		"M11_MUMPS_04_MP3"
#define		M11_MUMPS_05_MP3		"M11_MUMPS_05_MP3"
#define		M11_MUMPS_06_MP3		"M11_MUMPS_06_MP3"
#define		M11_MUMPS_07_MP3		"M11_MUMPS_07_MP3"
#define		M11_MUMPS_08_MP3		"M11_MUMPS_08_MP3"
#define		M11_MUMPS_09_MP3		"M11_MUMPS_09_MP3"
#define		M11_MUMPS_10_MP3		"M11_MUMPS_10_MP3"
#define		M11_MUMPS_11_MP3		"M11_MUMPS_11_MP3"
#define		M11_MUMPS_12_MP3		"M11_MUMPS_12_MP3"
#define		M11_MUMPS_13_MP3		"M11_MUMPS_13_MP3"
#define		M11_MUMPS_14_MP3		"M11_MUMPS_14_MP3"
#define		M11_MUMPS_15_MP3		"M11_MUMPS_15_MP3"
#define		M11_MUMPS_16_MP3		"M11_MUMPS_16_MP3"
#define		M11_MUMPS_17_MP3		"M11_MUMPS_17_MP3"
#define		M11_MUMPS_18_MP3		"M11_MUMPS_18_MP3"
#define		M11_MUMPS_19_MP3		"M11_MUMPS_19_MP3"
#define		M11_MUMPS_20_MP3		"M11_MUMPS_20_MP3"
#define		M11_MUMPS_22_MP3		"M11_MUMPS_22_MP3"
#define		M11_MUMPS_23_MP3		"M11_MUMPS_23_MP3"
#define		M11_MUMPS_24_MP3		"M11_MUMPS_24_MP3"
#define		M11_MUMPS_25_MP3		"M11_MUMPS_25_MP3"
#define		M11_MUMPS_26_MP3		"M11_MUMPS_26_MP3"
#define		M11_PEDIMENT_01_MP3		"M11_PEDIMENT_01_MP3"
#define		M11_PEDIMENT_02_MP3		"M11_PEDIMENT_02_MP3"
#define		M11_PEDIMENT_03_MP3		"M11_PEDIMENT_03_MP3"
#define		M11_PEDIMENT_04_MP3		"M11_PEDIMENT_04_MP3"
#define		M11_PEDIMENT_05_MP3		"M11_PEDIMENT_05_MP3"
#define		M11_PEDIMENT_06_MP3		"M11_PEDIMENT_06_MP3"
#define		M11_PEDIMENT_07_MP3		"M11_PEDIMENT_07_MP3"
#define		M11_PEDIMENT_08_MP3		"M11_PEDIMENT_08_MP3"
#define		M11_POLONEY_01_MP3		"M11_POLONEY_01_MP3"
#define		M11_POLONEY_02_MP3		"M11_POLONEY_02_MP3"
#define		M11_POLONEY_03_MP3		"M11_POLONEY_03_MP3"
#define		M11_SAUSAGE_01_MP3		"M11_SAUSAGE_01_MP3"
#define		M11_SAUSAGE_02_MP3		"M11_SAUSAGE_02_MP3"
#define		M11_SAUSAGE_03_MP3		"M11_SAUSAGE_03_MP3"
#define		M11_SAUSAGE_04_MP3		"M11_SAUSAGE_04_MP3"
#define		M11_SAUSAGE_05_MP3		"M11_SAUSAGE_05_MP3"
#define		M11_SAUSAGE_06_MP3		"M11_SAUSAGE_06_MP3"
#define		M11_SAUSAGE_07_MP3		"M11_SAUSAGE_07_MP3"
#define		M11_SAUSAGE_08_MP3		"M11_SAUSAGE_08_MP3"
#define		M11_SAUSAGE_09_MP3		"M11_SAUSAGE_09_MP3"
#define		M11_SAUSAGE_10_MP3		"M11_SAUSAGE_10_MP3"
#define		M12_ABLE_01_MP3		"M12_ABLE_01_MP3"
#define		M12_ABLE_02_MP3		"M12_ABLE_02_MP3"
#define		M12_ABLE_03_MP3		"M12_ABLE_03_MP3"
#define		M12_BUSY_01_MP3		"M12_BUSY_01_MP3"
#define		M12_BUSY_02_MP3		"M12_BUSY_02_MP3"
#define		M12_BUSY_03_MP3		"M12_BUSY_03_MP3"
#define		M12_BUSY_04_MP3		"M12_BUSY_04_MP3"
#define		M12_BUSY_05_MP3		"M12_BUSY_05_MP3"
#define		M12_BUSY_06_MP3		"M12_BUSY_06_MP3"
#define		M12_BUSY_07_MP3		"M12_BUSY_07_MP3"
#define		M12_BUSY_08_MP3		"M12_BUSY_08_MP3"
#define		M12_CHARLIE_01_MP3		"M12_CHARLIE_01_MP3"
#define		M12_CHARLIE_02_MP3		"M12_CHARLIE_02_MP3"
#define		M12_CONUNDRUM_01_MP3		"M12_CONUNDRUM_01_MP3"
#define		M12_CONUNDRUM_02_MP3		"M12_CONUNDRUM_02_MP3"
#define		M12_CONUNDRUM_03_MP3		"M12_CONUNDRUM_03_MP3"
#define		M12_CONUNDRUM_04_MP3		"M12_CONUNDRUM_04_MP3"
#define		M12_CONUNDRUM_05_MP3		"M12_CONUNDRUM_05_MP3"
#define		M12_FOXTROT_01_MP3		"M12_FOXTROT_01_MP3"
#define		M12_FOXTROT_02_MP3		"M12_FOXTROT_02_MP3"
#define		M12_GUY_01_MP3		"M12_GUY_01_MP3"
#define		M12_GUY_02_MP3		"M12_GUY_02_MP3"
#define		M12_GUY_03_MP3		"M12_GUY_03_MP3"
#define		M12_HAUTE_01_MP3		"M12_HAUTE_01_MP3"
#define		M12_HAUTE_02_MP3		"M12_HAUTE_02_MP3"
#define		M12_HAUTE_03_MP3		"M12_HAUTE_03_MP3"
#define		M12_HAUTE_04_MP3		"M12_HAUTE_04_MP3"
#define		M12_HAUTE_05_MP3		"M12_HAUTE_05_MP3"
#define		M12_HAUTE_06_MP3		"M12_HAUTE_06_MP3"
#define		M12_HOVER_01_MP3		"M12_HOVER_01_MP3"
#define		M12_HOVER_02_MP3		"M12_HOVER_02_MP3"
#define		M12_RUBE_01_MP3		"M12_RUBE_01_MP3"
#define		M12_RUBE_02_MP3		"M12_RUBE_02_MP3"
#define		M12_RUBE_03_MP3		"M12_RUBE_03_MP3"
#define		M12_RUBE_04_MP3		"M12_RUBE_04_MP3"
#define		M12_RUBE_05_MP3		"M12_RUBE_05_MP3"
#define		M12_RUBE_06_MP3		"M12_RUBE_06_MP3"
#define		M12_RUBE_07_MP3		"M12_RUBE_07_MP3"
#define		M12_RUBE_08_MP3		"M12_RUBE_08_MP3"
#define		M12_RUBE_09_MP3		"M12_RUBE_09_MP3"
#define		M12_RUBE_10_MP3		"M12_RUBE_10_MP3"
#define		M12_TEKT_01_MP3		"M12_TEKT_01_MP3"
#define		M12_TEKT_02_MP3		"M12_TEKT_02_MP3"
#define		M12_TEKT_03_MP3		"M12_TEKT_03_MP3"
#define		M12_TEKT_04_MP3		"M12_TEKT_04_MP3"
#define		M12_TEKT_05_MP3		"M12_TEKT_05_MP3"
#define		M12_TEKT_06_MP3		"M12_TEKT_06_MP3"
#define		M12_TEKT_07_MP3		"M12_TEKT_07_MP3"
#define		M13_ANIBLE_01_MP3		"M13_ANIBLE_01_MP3"
#define		M13_ANIBLE_02_MP3		"M13_ANIBLE_02_MP3"
#define		M13_FLOWER_01_MP3		"M13_FLOWER_01_MP3"
#define		M13_FLOWER_02_MP3		"M13_FLOWER_02_MP3"
#define		M13_FOOCHANE_01_MP3		"M13_FOOCHANE_01_MP3"
#define		M13_FOOCHANE_02_MP3		"M13_FOOCHANE_02_MP3"
#define		M13_FOOCHANE_03_MP3		"M13_FOOCHANE_03_MP3"
#define		M13_FOOCHANE_04_MP3		"M13_FOOCHANE_04_MP3"
#define		M13_GHULABUL_01_MP3		"M13_GHULABUL_01_MP3"
#define		M13_GHULABUL_02_MP3		"M13_GHULABUL_02_MP3"
#define		M13_GHULABUL_03_MP3		"M13_GHULABUL_03_MP3"
#define		M13_GHULABUL_04_MP3		"M13_GHULABUL_04_MP3"
#define		M13_GHULABUL_05_MP3		"M13_GHULABUL_05_MP3"
#define		M13_GHULABUL_06_MP3		"M13_GHULABUL_06_MP3"
#define		M13_GHULABUL_07_MP3		"M13_GHULABUL_07_MP3"
#define		M13_GUY_01_MP3		"M13_GUY_01_MP3"
#define		M13_GUY_02_MP3		"M13_GUY_02_MP3"
#define		M13_HAVENGIN_01_MP3		"M13_HAVENGIN_01_MP3"
#define		M13_MELO_01_MP3		"M13_MELO_01_MP3"
#define		M13_MELO_02_MP3		"M13_MELO_02_MP3"
#define		M13_MELO_03_MP3		"M13_MELO_03_MP3"
#define		M13_MITAKO_01_MP3		"M13_MITAKO_01_MP3"
#define		M13_MITAKO_02_MP3		"M13_MITAKO_02_MP3"
#define		M13_MITAKO_03_MP3		"M13_MITAKO_03_MP3"
#define		M13_SPOONIE_01_MP3		"M13_SPOONIE_01_MP3"
#define		M13_SPOONIE_02_MP3		"M13_SPOONIE_02_MP3"
#define		M13_SPOONIE_03_MP3		"M13_SPOONIE_03_MP3"
#define		M13_SPOONIE_04_MP3		"M13_SPOONIE_04_MP3"
#define		M13_SPOONIE_05_MP3		"M13_SPOONIE_05_MP3"
#define		M13_ZYGOTE_01_MP3		"M13_ZYGOTE_01_MP3"
#define		M13_ZYGOTE_02_MP3		"M13_ZYGOTE_02_MP3"
#define		M13_ZYGOTE_03_MP3		"M13_ZYGOTE_03_MP3"
#define		M13_ZYGOTE_04_MP3		"M13_ZYGOTE_04_MP3"
#define		M13_ZYGOTE_05_MP3		"M13_ZYGOTE_05_MP3"
#define		M14_LAMORTE_01_MP3		"M14_LAMORTE_01_MP3"
#define		M14_LAMORTE_02_MP3		"M14_LAMORTE_02_MP3"
#define		M15_COPROITE_01_MP3		"M15_COPROITE_01_MP3"
#define		M15_COPROITE_02_MP3		"M15_COPROITE_02_MP3"
#define		M15_COPROITE_03_MP3		"M15_COPROITE_03_MP3"
#define		M15_COPROITE_04_MP3		"M15_COPROITE_04_MP3"
#define		M15_COPROITE_05_MP3		"M15_COPROITE_05_MP3"
#define		M15_COPROITE_06_MP3		"M15_COPROITE_06_MP3"
#define		M15_COPROITE_07_MP3		"M15_COPROITE_07_MP3"
#define		M15_COPROITE_08_MP3		"M15_COPROITE_08_MP3"
#define		M15_COPROITE_09_MP3		"M15_COPROITE_09_MP3"
#define		M15_COPROITE_10_MP3		"M15_COPROITE_10_MP3"
#define		M15_COPROITE_11_MP3		"M15_COPROITE_11_MP3"
#define		M15_COPROITE_12_MP3		"M15_COPROITE_12_MP3"
#define		M15_COPROITE_13_MP3		"M15_COPROITE_13_MP3"
#define		M15_COPROITE_14_MP3		"M15_COPROITE_14_MP3"
#define		M15_COPROITE_15_MP3		"M15_COPROITE_15_MP3"
#define		M15_COPROITE_16_MP3		"M15_COPROITE_16_MP3"
#define		M15_COPROITE_17_MP3		"M15_COPROITE_17_MP3"
#define		M15_COPROITE_18_MP3		"M15_COPROITE_18_MP3"
#define		M15_GUY_01_MP3		"M15_GUY_01_MP3"
#define		M15_GUY_02_MP3		"M15_GUY_02_MP3"
#define		M15_REED_01_MP3		"M15_REED_01_MP3"
#define		M15_REED_02_MP3		"M15_REED_02_MP3"
#define		M15_REED_03_MP3		"M15_REED_03_MP3"
#define		M16_DYING_01_MP3		"M16_DYING_01_MP3"
#define		M16_DYING_02_MP3		"M16_DYING_02_MP3"
#define		M16_GUY_01_MP3		"M16_GUY_01_MP3"
#define		M16_GUY_02_MP3		"M16_GUY_02_MP3"
#define		M16_GUY_03_MP3		"M16_GUY_03_MP3"
#define		M17_ANDERSON_01_MP3		"M17_ANDERSON_01_MP3"
#define		M17_BARBER_01_MP3		"M17_BARBER_01_MP3"
#define		M17_CAMPBELL_01_MP3		"M17_CAMPBELL_01_MP3"
#define		M17_DEVONSHIRE_01_MP3		"M17_DEVONSHIRE_01_MP3"
#define		M17_EGGER_01_MP3		"M17_EGGER_01_MP3"
#define		M17_EMERALD_01_MP3		"M17_EMERALD_01_MP3"
#define		M17_FLINGBESTER_01_MP3		"M17_FLINGBESTER_01_MP3"
#define		M17_GERSHWIN_01_MP3		"M17_GERSHWIN_01_MP3"
#define		M17_GUY_01_MP3		"M17_GUY_01_MP3"
#define		M17_GUY_02_MP3		"M17_GUY_02_MP3"
#define		M17_GUY_03_MP3		"M17_GUY_03_MP3"
#define		M17_GUY_04_MP3		"M17_GUY_04_MP3"
#define		M17_HEPHASTUS_01_MP3		"M17_HEPHASTUS_01_MP3"
#define		M17_INIWA_01_MP3		"M17_INIWA_01_MP3"
#define		M17_INIWA_02_MP3		"M17_INIWA_02_MP3"
#define		M17_INIWA_03_MP3		"M17_INIWA_03_MP3"
#define		M17_KEYCODE_01_MP3		"M17_KEYCODE_01_MP3"
#define		M17_KEYCODE_02_MP3		"M17_KEYCODE_02_MP3"
#define		M17_KEYCODE_03_MP3		"M17_KEYCODE_03_MP3"
#define		M17_KEYCODE_04_MP3		"M17_KEYCODE_04_MP3"
#define		M17_TOERIG_01_MP3		"M17_TOERIG_01_MP3"
#define		M17_TOERIG_02_MP3		"M17_TOERIG_02_MP3"
#define		M17_WARNER_01_MP3		"M17_WARNER_01_MP3"
#define		M17_WARNER_02_MP3		"M17_WARNER_02_MP3"
#define		M17_WARNER_03_MP3		"M17_WARNER_03_MP3"
#define		M17_WARNER_04_MP3		"M17_WARNER_04_MP3"
#define		M17_YORP_01_MP3		"M17_YORP_01_MP3"
#define		M17_YORP_02_MP3		"M17_YORP_02_MP3"
#define		M18_DERECHA_01_MP3		"M18_DERECHA_01_MP3"
#define		M18_GUY_01_MP3		"M18_GUY_01_MP3"
#define		M18_IZQUIERDA_01_MP3		"M18_IZQUIERDA_01_MP3"
#define		M18_IZQUIERDA_02_MP3		"M18_IZQUIERDA_02_MP3"
#define		M18_IZQUIERDA_03_MP3		"M18_IZQUIERDA_03_MP3"
#define		M18_IZQUIERDA_04_MP3		"M18_IZQUIERDA_04_MP3"
#define		M18_IZQUIERDA_05_MP3		"M18_IZQUIERDA_05_MP3"
#define		M18_IZQUIERDA_06_MP3		"M18_IZQUIERDA_06_MP3"
#define		M19_CAVEAT_01_MP3		"M19_CAVEAT_01_MP3"
#define		M19_CAVEAT_02_MP3		"M19_CAVEAT_02_MP3"
#define		M19_ENDER_01_MP3		"M19_ENDER_01_MP3"
#define		M19_ENDER_02_MP3		"M19_ENDER_02_MP3"
#define		M19_FRUSTRATO_01_MP3		"M19_FRUSTRATO_01_MP3"
#define		M19_FRUSTRATO_02_MP3		"M19_FRUSTRATO_02_MP3"
#define		M19_FRUSTRATO_03_MP3		"M19_FRUSTRATO_03_MP3"
#define		M19_FRUSTRATO_04_MP3		"M19_FRUSTRATO_04_MP3"
#define		M19_FRUSTRATO_05_MP3		"M19_FRUSTRATO_05_MP3"
#define		M19_FRUSTRATO_06_MP3		"M19_FRUSTRATO_06_MP3"
#define		M19_FRUSTRATO_07_MP3		"M19_FRUSTRATO_07_MP3"
#define		M19_FRUSTRATO_08_MP3		"M19_FRUSTRATO_08_MP3"
#define		M19_FRUSTRATO_09_MP3		"M19_FRUSTRATO_09_MP3"
#define		M19_FRUSTRATO_10_MP3		"M19_FRUSTRATO_10_MP3"
#define		M19_GUY_01_MP3		"M19_GUY_01_MP3"
#define		M19_GUY_02_MP3		"M19_GUY_02_MP3"
#define		M19_GUY_03_MP3		"M19_GUY_03_MP3"
#define		M19_INTER_01_MP3		"M19_INTER_01_MP3"
#define		M19_INTER_02_MP3		"M19_INTER_02_MP3"
#define		M19_LONE_01_MP3		"M19_LONE_01_MP3"
#define		M19_LONE_02_MP3		"M19_LONE_02_MP3"
#define		M19_LONE_03_MP3		"M19_LONE_03_MP3"
#define		M19_PHILLIPS_01_MP3		"M19_PHILLIPS_01_MP3"
#define		M19_PHILLIPS_02_MP3		"M19_PHILLIPS_02_MP3"
#define		M19_PHILLIPS_03_MP3		"M19_PHILLIPS_03_MP3"
#define		M19_PHILLIPS_04_MP3		"M19_PHILLIPS_04_MP3"
#define		M19_PHILLIPS_05_MP3		"M19_PHILLIPS_05_MP3"
#define		M19_RAILRIDER_01_MP3		"M19_RAILRIDER_01_MP3"
#define		M19_RAILRIDER_02_MP3		"M19_RAILRIDER_02_MP3"
#define		M19_RAILRIDER_03_MP3		"M19_RAILRIDER_03_MP3"
#define		M19_RAILRIDER_04_MP3		"M19_RAILRIDER_04_MP3"
#define		M19_REDRUM_01_MP3		"M19_REDRUM_01_MP3"
#define		M19_REDRUM_02_MP3		"M19_REDRUM_02_MP3"
#define		M19_REDRUM_03_MP3		"M19_REDRUM_03_MP3"
#define		M19_REDRUM_04_MP3		"M19_REDRUM_04_MP3"
#define		M19_REDRUM_05_MP3		"M19_REDRUM_05_MP3"
#define		M19_REDRUM_06_MP3		"M19_REDRUM_06_MP3"
#define		M19_STANDARD_01_MP3		"M19_STANDARD_01_MP3"
#define		M19_STANDARD_02_MP3		"M19_STANDARD_02_MP3"
#define		M20_ARNIE_01_MP3		"M20_ARNIE_01_MP3"
#define		M20_ARNIE_02_MP3		"M20_ARNIE_02_MP3"
#define		M20_BRAD_01_MP3		"M20_BRAD_01_MP3"
#define		M20_BRAD_02_MP3		"M20_BRAD_02_MP3"
#define		M20_BUSTER_01_MP3		"M20_BUSTER_01_MP3"
#define		M20_BUSTER_02_MP3		"M20_BUSTER_02_MP3"
#define		M20_BUSTER_03_MP3		"M20_BUSTER_03_MP3"
#define		M20_COOPER_01_MP3		"M20_COOPER_01_MP3"
#define		M20_COOPER_02_MP3		"M20_COOPER_02_MP3"
#define		M20_DINERS_01_MP3		"M20_DINERS_01_MP3"
#define		M20_DINERS_02_MP3		"M20_DINERS_02_MP3"
#define		M20_DOLLY_01_MP3		"M20_DOLLY_01_MP3"
#define		M20_DOREK_01_MP3		"M20_DOREK_01_MP3"
#define		M20_DOREK_02_MP3		"M20_DOREK_02_MP3"
#define		M20_DOREK_03_MP3		"M20_DOREK_03_MP3"
#define		M20_FARBLE_01_MP3		"M20_FARBLE_01_MP3"
#define		M20_FARBLE_02_MP3		"M20_FARBLE_02_MP3"
#define		M20_GRUNETT_01_MP3		"M20_GRUNETT_01_MP3"
#define		M20_GRUNETT_02_MP3		"M20_GRUNETT_02_MP3"
#define		M20_GUY_01_MP3		"M20_GUY_01_MP3"
#define		M20_GUY_02_MP3		"M20_GUY_02_MP3"
#define		M20_GUY_03_MP3		"M20_GUY_03_MP3"
#define		M20_GUY_04_MP3		"M20_GUY_04_MP3"
#define		M20_GUY_05_MP3		"M20_GUY_05_MP3"
#define		M20_GUY_06_MP3		"M20_GUY_06_MP3"
#define		M20_HUMBERT_01_MP3		"M20_HUMBERT_01_MP3"
#define		M20_ILLIAC_01_MP3		"M20_ILLIAC_01_MP3"
#define		M20_JAQUES_01_MP3		"M20_JAQUES_01_MP3"
#define		M20_JAQUES_02_MP3		"M20_JAQUES_02_MP3"
#define		M20_LUMBAR_01_MP3		"M20_LUMBAR_01_MP3"
#define		M20_MANNY_01_MP3		"M20_MANNY_01_MP3"
#define		M20_POLONEY_01_MP3		"M20_POLONEY_01_MP3"
#define		M20_POLONEY_02_MP3		"M20_POLONEY_02_MP3"
#define		M20_SARGE_01_MP3		"M20_SARGE_01_MP3"
#define		M20_SARGE_02_MP3		"M20_SARGE_02_MP3"
#define		M20_SARGE_03_MP3		"M20_SARGE_03_MP3"
#define		M20_SARGE_04_MP3		"M20_SARGE_04_MP3"
#define		M20_SARGE_05_MP3		"M20_SARGE_05_MP3"
#define		M21_ANTIMA_01_MP3		"M21_ANTIMA_01_MP3"
#define		M21_ANTIMA_02_MP3		"M21_ANTIMA_02_MP3"
#define		M21_ANTIMA_03_MP3		"M21_ANTIMA_03_MP3"
#define		M21_ANTIMA_04_MP3		"M21_ANTIMA_04_MP3"
#define		M21_ANTIMA_05_MP3		"M21_ANTIMA_05_MP3"
#define		M21_ANTIMA_06_MP3		"M21_ANTIMA_06_MP3"
#define		M21_ANTIMA_07_MP3		"M21_ANTIMA_07_MP3"
#define		M21_BRAN_ONOMI_01_MP3		"M21_BRAN_ONOMI_01_MP3"
#define		M21_BRAN_ONOMI_02_MP3		"M21_BRAN_ONOMI_02_MP3"
#define		M21_BRAN_ONOMI_03_MP3		"M21_BRAN_ONOMI_03_MP3"
#define		M21_CONTENNE_01_MP3		"M21_CONTENNE_01_MP3"
#define		M21_CONTENNE_02_MP3		"M21_CONTENNE_02_MP3"
#define		M21_CONTENNE_03_MP3		"M21_CONTENNE_03_MP3"
#define		M21_CONTENNE_04_MP3		"M21_CONTENNE_04_MP3"
#define		M21_CONTENNE_05_MP3		"M21_CONTENNE_05_MP3"
#define		M21_CONTENNE_06_MP3		"M21_CONTENNE_06_MP3"
#define		M21_CONTENNE_07_MP3		"M21_CONTENNE_07_MP3"
#define		M21_COUHOUSE_01_MP3		"M21_COUHOUSE_01_MP3"
#define		M21_COUHOUSE_02_MP3		"M21_COUHOUSE_02_MP3"
#define		M21_COUHOUSE_03_MP3		"M21_COUHOUSE_03_MP3"
#define		M21_DEBENSHIRE_01_MP3		"M21_DEBENSHIRE_01_MP3"
#define		M21_DEBENSHIRE_02_MP3		"M21_DEBENSHIRE_02_MP3"
#define		M21_DEBENSHIRE_03_MP3		"M21_DEBENSHIRE_03_MP3"
#define		M21_DEBENSHIRE_04_MP3		"M21_DEBENSHIRE_04_MP3"
#define		M21_FEMURIA_01_MP3		"M21_FEMURIA_01_MP3"
#define		M21_FEMURIA_02_MP3		"M21_FEMURIA_02_MP3"
#define		M21_FEMURIA_03_MP3		"M21_FEMURIA_03_MP3"
#define		M21_FEMURIA_04_MP3		"M21_FEMURIA_04_MP3"
#define		M21_FEMURIA_05_MP3		"M21_FEMURIA_05_MP3"
#define		M21_GLARATTE_01_MP3		"M21_GLARATTE_01_MP3"
#define		M21_GLARATTE_02_MP3		"M21_GLARATTE_02_MP3"
#define		M21_GLARATTE_03_MP3		"M21_GLARATTE_03_MP3"
#define		M21_GLARATTE_04_MP3		"M21_GLARATTE_04_MP3"
#define		M21_GUY_01_MP3		"M21_GUY_01_MP3"
#define		M21_GUY_02_MP3		"M21_GUY_02_MP3"
#define		M21_GUY_03_MP3		"M21_GUY_03_MP3"
#define		M21_GUY_04_MP3		"M21_GUY_04_MP3"
#define		M21_GUY_05_MP3		"M21_GUY_05_MP3"
#define		M21_GUY_06_MP3		"M21_GUY_06_MP3"
#define		M21_GUY_07_MP3		"M21_GUY_07_MP3"
#define		M21_GUY_08_MP3		"M21_GUY_08_MP3"
#define		M21_GUY_09_MP3		"M21_GUY_09_MP3"
#define		M21_HYPERBOLE_01_MP3		"M21_HYPERBOLE_01_MP3"
#define		M21_KREN_KREN_01_MP3		"M21_KREN_KREN_01_MP3"
#define		M21_KREN_KREN_02_MP3		"M21_KREN_KREN_02_MP3"
#define		M21_KREN_KREN_03_MP3		"M21_KREN_KREN_03_MP3"
#define		M21_KREN_KREN_04_MP3		"M21_KREN_KREN_04_MP3"
#define		M21_KREN_KREN_05_MP3		"M21_KREN_KREN_05_MP3"
#define		M21_LITOTE_01_MP3		"M21_LITOTE_01_MP3"
#define		M21_PERIOUS_01_MP3		"M21_PERIOUS_01_MP3"
#define		M21_PERIOUS_02_MP3		"M21_PERIOUS_02_MP3"
#define		M21_PERIOUS_03_MP3		"M21_PERIOUS_03_MP3"
#define		M21_PHAEDRUS_01_MP3		"M21_PHAEDRUS_01_MP3"
#define		M21_PHAEDRUS_02_MP3		"M21_PHAEDRUS_02_MP3"
#define		M21_PHAEDRUS_04_MP3		"M21_PHAEDRUS_04_MP3"
#define		M21_PHAEDRUS_05_MP3		"M21_PHAEDRUS_05_MP3"
#define		M21_PHAEDRUS_06_MP3		"M21_PHAEDRUS_06_MP3"
#define		M21_PHAEDRUS_07_MP3		"M21_PHAEDRUS_07_MP3"
#define		M21_PHAEDRUS_08_MP3		"M21_PHAEDRUS_08_MP3"
#define		M21_PHAEDRUS_09_MP3		"M21_PHAEDRUS_09_MP3"
#define		M21_PHAEDRUS_10_MP3		"M21_PHAEDRUS_10_MP3"
#define		M21_PHAEDRUS_11_MP3		"M21_PHAEDRUS_11_MP3"
#define		M21_PHAEDRUS_12_MP3		"M21_PHAEDRUS_12_MP3"
#define		M21_PHAEDRUS_13_MP3		"M21_PHAEDRUS_13_MP3"
#define		M21_PHAEDRUS_14_MP3		"M21_PHAEDRUS_14_MP3"
#define		M21_PHAEDRUS_15_MP3		"M21_PHAEDRUS_15_MP3"
#define		M21_PHAEDRUS_16_MP3		"M21_PHAEDRUS_16_MP3"
#define		M21_PHAEDRUS_17_MP3		"M21_PHAEDRUS_17_MP3"
#define		M21_PHAEDRUS_18_MP3		"M21_PHAEDRUS_18_MP3"
#define		M21_PHAEDRUS_19_MP3		"M21_PHAEDRUS_19_MP3"
#define		M21_PHAEDRUS_20_MP3		"M21_PHAEDRUS_20_MP3"
#define		M21_PHAEDRUS_21_MP3		"M21_PHAEDRUS_21_MP3"
#define		M21_PHAEDRUS_22_MP3		"M21_PHAEDRUS_22_MP3"
#define		M21_PHAEDRUS_23_MP3		"M21_PHAEDRUS_23_MP3"
#define		M21_PHAEDRUS_24_MP3		"M21_PHAEDRUS_24_MP3"
#define		M21_PHAEDRUS_25_MP3		"M21_PHAEDRUS_25_MP3"
#define		M21_PHAEDRUS_26_MP3		"M21_PHAEDRUS_26_MP3"
#define		M21_PHIPOLOSSI_01_MP3		"M21_PHIPOLOSSI_01_MP3"
#define		M21_PHIPOLOSSI_02_MP3		"M21_PHIPOLOSSI_02_MP3"
#define		M21_PHIPOLOSSI_03_MP3		"M21_PHIPOLOSSI_03_MP3"
#define		M21_PHIPOLOSSI_04_MP3		"M21_PHIPOLOSSI_04_MP3"
#define		M21_PHIPOLOSSI_05_MP3		"M21_PHIPOLOSSI_05_MP3"
#define		M21_PHIPOLOSSI_06_MP3		"M21_PHIPOLOSSI_06_MP3"
#define		M21_PLODDER_01_MP3		"M21_PLODDER_01_MP3"
#define		M21_PLODDER_02_MP3		"M21_PLODDER_02_MP3"
#define		M21_PLODDER_03_MP3		"M21_PLODDER_03_MP3"
#define		M21_PLODDER_04_MP3		"M21_PLODDER_04_MP3"
#define		M21_SARGE_01_MP3		"M21_SARGE_01_MP3"
#define		M21_SARGE_02_MP3		"M21_SARGE_02_MP3"
#define		M21_SARGE_03_MP3		"M21_SARGE_03_MP3"
#define		M21_SARGE_04_MP3		"M21_SARGE_04_MP3"
#define		M21_SARGE_05_MP3		"M21_SARGE_05_MP3"
#define		M21_SARGE_06_MP3		"M21_SARGE_06_MP3"
#define		M21_SARGE_07_MP3		"M21_SARGE_07_MP3"
#define		M21_SARGE_08_MP3		"M21_SARGE_08_MP3"
#define		M21_SATIRE_01_MP3		"M21_SATIRE_01_MP3"
#define		M21_SATIRE_02_MP3		"M21_SATIRE_02_MP3"
#define		M21_SHELLEY_01_MP3		"M21_SHELLEY_01_MP3"
#define		M21_SHELLEY_02_MP3		"M21_SHELLEY_02_MP3"
#define		M21_SHELLEY_03_MP3		"M21_SHELLEY_03_MP3"
#define		M21_SHELLEY_04_MP3		"M21_SHELLEY_04_MP3"
#define		M21_SHELLEY_05_MP3		"M21_SHELLEY_05_MP3"
#define		M21_VERILITH_01_MP3		"M21_VERILITH_01_MP3"
#define		M21_VERILITH_02_MP3		"M21_VERILITH_02_MP3"
#define		M21_VERILITH_03_MP3		"M21_VERILITH_03_MP3"
#define		M21_VERILITH_04_MP3		"M21_VERILITH_04_MP3"
#define		M21_VERILITH_05_MP3		"M21_VERILITH_05_MP3"
#define		M22_GUY_01_MP3		"M22_GUY_01_MP3"
#define		M22_OSCURO_01_MP3		"M22_OSCURO_01_MP3"
#define		M22_OSCURO_02_MP3		"M22_OSCURO_02_MP3"
#define		M22_VERILITH_01_MP3		"M22_VERILITH_01_MP3"
#define		M22_VERILITH_02_MP3		"M22_VERILITH_02_MP3"
#define		M22_VERILITH_03_MP3		"M22_VERILITH_03_MP3"
#define		M22_VERILITH_04_MP3		"M22_VERILITH_04_MP3"
#define		M23_GUY_01_MP3		"M23_GUY_01_MP3"
#define		M23_GUY_02_MP3		"M23_GUY_02_MP3"
#define		M23_GUY_03_MP3		"M23_GUY_03_MP3"
#define		M23_INSANITO_01_MP3		"M23_INSANITO_01_MP3"
#define		M23_INSANITO_02_MP3		"M23_INSANITO_02_MP3"
#define		M23_INSANITO_03_MP3		"M23_INSANITO_03_MP3"
#define		M23_INSANITO_04_MP3		"M23_INSANITO_04_MP3"
#define		M23_INSANITO_05_MP3		"M23_INSANITO_05_MP3"
#define		M23_VERILITH_01_MP3		"M23_VERILITH_01_MP3"
#define		M24_GUY_01_MP3		"M24_GUY_01_MP3"
#define		M24_GUY_02_MP3		"M24_GUY_02_MP3"
#define		M24_GUY_03_MP3		"M24_GUY_03_MP3"
#define		M24_MANAGOTA_01_MP3		"M24_MANAGOTA_01_MP3"
#define		M24_MANAGOTA_02_MP3		"M24_MANAGOTA_02_MP3"
#define		M24_MANAGOTA_03_MP3		"M24_MANAGOTA_03_MP3"
#define		M24_MANAGOTA_04_MP3		"M24_MANAGOTA_04_MP3"
#define		M25_BBOW_01_MP3		"M25_BBOW_01_MP3"
#define		M25_BBOW_02_MP3		"M25_BBOW_02_MP3"
#define		M25_BBOW_03_MP3		"M25_BBOW_03_MP3"
#define		M25_BBOW_04_MP3		"M25_BBOW_04_MP3"
#define		M25_GUY_01_MP3		"M25_GUY_01_MP3"
#define		M25_GUY_02_MP3		"M25_GUY_02_MP3"
#define		M25_VERILITH_01_MP3		"M25_VERILITH_01_MP3"
#define		M26_GUY_01_MP3		"M26_GUY_01_MP3"
#define		M26_GUY_02_MP3		"M26_GUY_02_MP3"
#define		M26_GUY_03_MP3		"M26_GUY_03_MP3"
#define		M26_GUY_04_MP3		"M26_GUY_04_MP3"
#define		M26_GUY_05_MP3		"M26_GUY_05_MP3"
#define		M26_FDOE_01_MP3		"M26_FDOE_01_MP3"
#define		M26_FDOE_02_MP3		"M26_FDOE_02_MP3"
#define		M26_FDOE_03_MP3		"M26_FDOE_03_MP3"
#define		M26_FDOE_04_MP3		"M26_FDOE_04_MP3"
#define		M27_AYONN_01_MP3		"M27_AYONN_01_MP3"
#define		M27_AYONN_02_MP3		"M27_AYONN_02_MP3"
#define		M27_AYONN_03_MP3		"M27_AYONN_03_MP3"
#define		M27_AYONN_04_MP3		"M27_AYONN_04_MP3"
#define		M27_BALE_01_MP3		"M27_BALE_01_MP3"
#define		M27_BALE_02_MP3		"M27_BALE_02_MP3"
#define		M27_BALE_03_MP3		"M27_BALE_03_MP3"
#define		M27_GUY_01_MP3		"M27_GUY_01_MP3"
#define		M27_GUY_02_MP3		"M27_GUY_02_MP3"
#define		M27_GUY_03_MP3		"M27_GUY_03_MP3"
#define		M27_ONABILDEN_01_MP3		"M27_ONABILDEN_01_MP3"
#define		M27_ONABILDEN_02_MP3		"M27_ONABILDEN_02_MP3"
#define		M27_ONABILDEN_03_MP3		"M27_ONABILDEN_03_MP3"
#define		M27_ONABILDEN_04_MP3		"M27_ONABILDEN_04_MP3"
#define		M28_FINN_01_MP3		"M28_FINN_01_MP3"
#define		M28_FINN_02_MP3		"M28_FINN_02_MP3"
#define		M28_FINN_03_MP3		"M28_FINN_03_MP3"
#define		M28_GUY_01_MP3		"M28_GUY_01_MP3"
#define		M28_GUY_02_MP3		"M28_GUY_02_MP3"
#define		M28_GUY_03_MP3		"M28_GUY_03_MP3"
#define		M29_ALERE_01_MP3		"M29_ALERE_01_MP3"
#define		M29_ALERE_02_MP3		"M29_ALERE_02_MP3"
#define		M29_ALERE_03_MP3		"M29_ALERE_03_MP3"
#define		M29_AOLOS_01_MP3		"M29_AOLOS_01_MP3"
#define		M29_AOLOS_02_MP3		"M29_AOLOS_02_MP3"
#define		M29_AOLOS_03_MP3		"M29_AOLOS_03_MP3"
#define		M29_AOLOS_04_MP3		"M29_AOLOS_04_MP3"
#define		M29_AOLOS_05_MP3		"M29_AOLOS_05_MP3"
#define		M29_GUY_01_MP3		"M29_GUY_01_MP3"
#define		M29_GUY_02_MP3		"M29_GUY_02_MP3"
#define		M29_GUY_03_MP3		"M29_GUY_03_MP3"
#define		M29_GUY_04_MP3		"M29_GUY_04_MP3"
#define		M29_GUY_05_MP3		"M29_GUY_05_MP3"
#define		M29_GUY_06_MP3		"M29_GUY_06_MP3"
#define		M29_GUY_07_MP3		"M29_GUY_07_MP3"
#define		M29_GUY_08_MP3		"M29_GUY_08_MP3"
#define		M29_GUY_09_MP3		"M29_GUY_09_MP3"
#define		M29_GUY_10_MP3		"M29_GUY_10_MP3"
#define		M29_GUY_11_MP3		"M29_GUY_11_MP3"
#define		M29_GUY_12_MP3		"M29_GUY_12_MP3"
#define		M29_GUY_13_MP3		"M29_GUY_13_MP3"
#define		M29_GUY_14_MP3		"M29_GUY_14_MP3"
#define		M29_GUY_15_MP3		"M29_GUY_15_MP3"
#define		M29_KORENAAR_01_MP3		"M29_KORENAAR_01_MP3"
#define		M29_KORENAAR_02_MP3		"M29_KORENAAR_02_MP3"
#define		M29_KORENAAR_03_MP3		"M29_KORENAAR_03_MP3"
#define		M29_KORENAAR_04_MP3		"M29_KORENAAR_04_MP3"
#define		M29_KORENAAR_05_MP3		"M29_KORENAAR_05_MP3"
#define		M29_PHARIBOS_01_MP3		"M29_PHARIBOS_01_MP3"
#define		M29_PHARIBOS_02_MP3		"M29_PHARIBOS_02_MP3"
#define		M29_VELEGAL_01_MP3		"M29_VELEGAL_01_MP3"
#define		M29_VELEGAL_02_MP3		"M29_VELEGAL_02_MP3"
#define		M30_AOLOS_01_MP3		"M30_AOLOS_01_MP3"
#define		M30_AOLOS_02_MP3		"M30_AOLOS_02_MP3"
#define		M30_AOLOS_03_MP3		"M30_AOLOS_03_MP3"
#define		M30_AOLOS_04_MP3		"M30_AOLOS_04_MP3"
#define		M30_AOLOS_05_MP3		"M30_AOLOS_05_MP3"
#define		M30_AOLOS_06_MP3		"M30_AOLOS_06_MP3"
#define		M30_AOLOS_07_MP3		"M30_AOLOS_07_MP3"
#define		M30_AOLOS_08_MP3		"M30_AOLOS_08_MP3"
#define		M30_AOLOS_09_MP3		"M30_AOLOS_09_MP3"
#define		M30_AOLOS_11_MP3		"M30_AOLOS_11_MP3"
#define		M30_AOLOS_12_MP3		"M30_AOLOS_12_MP3"
#define		M30_AOLOS_13_MP3		"M30_AOLOS_13_MP3"
#define		M30_AOLOS_14_MP3		"M30_AOLOS_14_MP3"
#define		M30_AOLOS_15_MP3		"M30_AOLOS_15_MP3"
#define		M30_AOLOS_16_MP3		"M30_AOLOS_16_MP3"
#define		M30_AOLOS_17_MP3		"M30_AOLOS_17_MP3"
#define		M30_AOLOS_18_MP3		"M30_AOLOS_18_MP3"
#define		M30_AOLOS_19_MP3		"M30_AOLOS_19_MP3"
#define		M30_AOLOS_20_MP3		"M30_AOLOS_20_MP3"
#define		M30_CASINOX_01_MP3		"M30_CASINOX_01_MP3"
#define		M30_CASINOX_02_MP3		"M30_CASINOX_02_MP3"
#define		M30_CASINOX_03_MP3		"M30_CASINOX_03_MP3"
#define		M30_CASINOX_04_MP3		"M30_CASINOX_04_MP3"
#define		M30_CASINOX_05_MP3		"M30_CASINOX_05_MP3"
#define		M30_CASINOX_06_MP3		"M30_CASINOX_06_MP3"
#define		M30_CHICKEN_EXPLOSION_01_MP3		"M30_CHICKEN_EXPLOSION_01_MP3"
#define		M30_CHICKEN_EXPLOSION_02_MP3		"M30_CHICKEN_EXPLOSION_02_MP3"
#define		M30_DOPEFISH_01_MP3		"M30_DOPEFISH_01_MP3"
#define		M30_DOPEFISH_02_MP3		"M30_DOPEFISH_02_MP3"
#define		M30_DOPEFISH_03_MP3		"M30_DOPEFISH_03_MP3"
#define		M30_DOPEFISH_04_MP3		"M30_DOPEFISH_04_MP3"
#define		M30_GUY_01_MP3		"M30_GUY_01_MP3"
#define		M30_GUY_02_MP3		"M30_GUY_02_MP3"
#define		M30_JOHN_01_MP3		"M30_JOHN_01_MP3"
#define		M30_JOHN_02_MP3		"M30_JOHN_02_MP3"
#define		M30_JOHN_03_MP3		"M30_JOHN_03_MP3"
#define		M30_JOHN_04_MP3		"M30_JOHN_04_MP3"
#define		M30_JOHN_05_MP3		"M30_JOHN_05_MP3"
#define		M30_LUCAS_01_MP3		"M30_LUCAS_01_MP3"
#define		M30_LUCAS_02_MP3		"M30_LUCAS_02_MP3"
#define		M30_LUCAS_03_MP3		"M30_LUCAS_03_MP3"
#define		M30_LUCAS_04_MP3		"M30_LUCAS_04_MP3"
#define		M30_STEVIE_01_MP3		"M30_STEVIE_01_MP3"
#define		M30_STEVIE_02_MP3		"M30_STEVIE_02_MP3"
#define		M30_STEVIE_03_MP3		"M30_STEVIE_03_MP3"
#define		M30_STEVIE_04_MP3		"M30_STEVIE_04_MP3"
#define		M30_STEVIE_05_MP3		"M30_STEVIE_05_MP3"
#define		M30_STEVIE_06_MP3		"M30_STEVIE_06_MP3"
#define		M30_STEVIE_07_MP3		"M30_STEVIE_07_MP3"
#define		M30_STEVIE_08_MP3		"M30_STEVIE_08_MP3"
#define		M30_STEVIE_09_MP3		"M30_STEVIE_09_MP3"
#define		M30_STEVIE_10_MP3		"M30_STEVIE_10_MP3"
#define		M30_TOM_01_MP3		"M30_TOM_01_MP3"
#define		M30_TOM_02_MP3		"M30_TOM_02_MP3"
#define		M30_TOM_03_MP3		"M30_TOM_03_MP3"
#define		M30_TOM_04_MP3		"M30_TOM_04_MP3"
#define		M30_TOM_05_MP3		"M30_TOM_05_MP3"
#define		M30_TOM_06_MP3		"M30_TOM_06_MP3"
#define		M30_VERILITH_01_MP3		"M30_VERILITH_01_MP3"
#define		M30_VERILITH_02_MP3		"M30_VERILITH_02_MP3"
#define		M30_VERILITH_03_MP3		"M30_VERILITH_03_MP3"
#define		M30_VERILITH_04_MP3		"M30_VERILITH_04_MP3"
#define		M30_VERILITH_05_MP3		"M30_VERILITH_05_MP3"
#define		M30_VERILITH_06_MP3		"M30_VERILITH_06_MP3"
#define		M30_VERILITH_07_MP3		"M30_VERILITH_07_MP3"
#define		OUTRO_DOLLY_01_MP3		"OUTRO_DOLLY_01_MP3"
#define		OUTRO_DOLLY_02_MP3		"OUTRO_DOLLY_02_MP3"
#define		OUTRO_DOLLY_03_MP3		"OUTRO_DOLLY_03_MP3"
#define		OUTRO_DOLLY_04_MP3		"OUTRO_DOLLY_04_MP3"
#define		OUTRO_DOLLY_05_MP3		"OUTRO_DOLLY_05_MP3"
#define		OUTRO_DOLLY_06_MP3		"OUTRO_DOLLY_06_MP3"
#define		OUTRO_DOLLY_07_MP3		"OUTRO_DOLLY_07_MP3"
#define		OUTRO_DOLLY_08_MP3		"OUTRO_DOLLY_08_MP3"
#define		OUTRO_DOLLY_09_MP3		"OUTRO_DOLLY_09_MP3"
#define		OUTRO_DOLLY_10_MP3		"OUTRO_DOLLY_10_MP3"
#define		OUTRO_DOLLY_11_MP3		"OUTRO_DOLLY_11_MP3"
#define		OUTRO_DOLLY_12_MP3		"OUTRO_DOLLY_12_MP3"
#define		OUTRO_DOLLY_13_MP3		"OUTRO_DOLLY_13_MP3"
#define		OUTRO_DOLLY_14_MP3		"OUTRO_DOLLY_14_MP3"
#define		OUTRO_DOLLY_15_MP3		"OUTRO_DOLLY_15_MP3"
#define		OUTRO_DOLLY_16_MP3		"OUTRO_DOLLY_16_MP3"
#define		OUTRO_DOLLY_17_MP3		"OUTRO_DOLLY_17_MP3"
#define		OUTRO_DOLLY_18_MP3		"OUTRO_DOLLY_18_MP3"
#define		OUTRO_DOREK_01_MP3		"OUTRO_DOREK_01_MP3"
#define		OUTRO_DOREK_02_MP3		"OUTRO_DOREK_02_MP3"
#define		OUTRO_DOREK_03_MP3		"OUTRO_DOREK_03_MP3"
#define		OUTRO_DOREK_04_MP3		"OUTRO_DOREK_04_MP3"
#define		OUTRO_DOREK_05_MP3		"OUTRO_DOREK_05_MP3"
#define		OUTRO_DOREK_06_MP3		"OUTRO_DOREK_06_MP3"
#define		OUTRO_GUY_01_MP3		"OUTRO_GUY_01_MP3"
#define		OUTRO_GUY_02_MP3		"OUTRO_GUY_02_MP3"
#define		OUTRO_GUY_03_MP3		"OUTRO_GUY_03_MP3"
#define		OUTRO_GUY_04_MP3		"OUTRO_GUY_04_MP3"
#define		OUTRO_GUY_05_MP3		"OUTRO_GUY_05_MP3"
#define		OUTRO_GUY_06_MP3		"OUTRO_GUY_06_MP3"
#define		OUTRO_JENKINS_01_MP3		"OUTRO_JENKINS_01_MP3"
#define		OUTRO_JENKINS_02_MP3		"OUTRO_JENKINS_02_MP3"
#define		OUTRO_JENKINS_03_MP3		"OUTRO_JENKINS_03_MP3"
#define		OUTRO_JENKINS_04_MP3		"OUTRO_JENKINS_04_MP3"
#define		OUTRO_JENKINS_05_MP3		"OUTRO_JENKINS_05_MP3"
#define		OUTRO_SARGE_01_MP3		"OUTRO_SARGE_01_MP3"
#define		OUTRO_SARGE_02_MP3		"OUTRO_SARGE_02_MP3"
#define		OUTRO_SARGE_03_MP3		"OUTRO_SARGE_03_MP3"
#define		OUTRO_SARGE_04_MP3		"OUTRO_SARGE_04_MP3"
#define		OUTRO_SARGE_05_MP3		"OUTRO_SARGE_05_MP3"
#define		OUTRO_SARGE_06_MP3		"OUTRO_SARGE_06_MP3"
#define		GUY_ENERGY_CELL_MP3		"GUY_ENERGY_CELL_MP3"
#define		GUY_GOT_A_JOB_MP3		"GUY_GOT_A_JOB_MP3"
#define		GUY_COMPLETED_MP3		"GUY_COMPLETED_MP3"
#define		GUY_GOT_SOMETHING_MP3		"GUY_GOT_SOMETHING_MP3"
#define		GUY_WINS_MP3		"GUY_WINS_MP3"
#define		HDB_INTRO_MP3		"HDB_INTRO_MP3"

#define		DEMO_SARGE01_MP3		"DEMO_SARGE01_MP3"
#define		DEMO_SARGE02_MP3		"DEMO_SARGE_02_MP3"
#define		DEMO_SARGE03_MP3		"DEMO_SARGE_03_MP3"
#define		DEMO_SARGE04_MP3		"DEMO_SARGE_04_MP3"
#define		DEMO_SARGE05_MP3		"DEMO_SARGE_05_MP3"
#define		DEMO_SARGE06_MP3		"DEMO_SARGE_06_MP3"
#define		DEMO_GUY_01_MP3			"DEMO_GUY_01_MP3"
#define		DEMO_PILOT_01_MP3		"DEMO_PILOT_01_MP3"
#define		DEMO_SCIENTIST_01_MP3	"DEMO_SCIENTIST_01_MP3"
#define		DEMO_SCIENTIST_02_MP3	"DEMO_SCIENTIST_02_MP3"

enum IconList {
	ICON_GUY_DOWN,
	ICON_GUY_UP,
	ICON_GUY_RIGHT,
	ICON_GUY_LEFT,
	ICON_ENVELOPE_WHITE,
	ICON_ENVELOPE_BLUE,
	ICON_ENVELOPE_RED,
	ICON_ENVELOPE_GREEN,
	ICON_LASER_RIGHT,
	ICON_LASER_DOWN,
	ICON_LASER_LEFT,
	ICON_LASER_UP,
	ICON_DIVERTER_LEFTDOWN,
	ICON_DIVERTER_RIGHTDOWN,
	ICON_DIVERTER_UPRIGHT,
	ICON_DIVERTER_LEFTUP,
	ICON_FOURFIRER_RIGHT,
	ICON_FOURFIRER_DOWN,
	ICON_FOURFIRER_LEFT,
	ICON_FOURFIRER_UP,
	ICON_ARROW_DOWN,
	ICON_ARROW_UP,
	ICON_ARROW_RIGHT,
	ICON_ARROW_LEFT,
	ICON_STOPARROW_DOWN,
	ICON_STOPARROW_UP,
	ICON_STOPARROW_RIGHT,
	ICON_STOPARROW_LEFT,
	ICON_ITEM_CELL,
	ICON_ENVITEM_CRATE,
	ICON_ENVITEM_LIGHTBARREL,
	ICON_ENVITEM_HEAVYBARREL,
	ICON_ENVITEM_BOOMBARREL,
	ICON_ITEM_TRANSCEIVER,
	ICON_E2_ITEM_CLUB,
	ICON_E3_ITEM_ROBOSTUNNER,
	ICON_E2_ITEM_SLUGSLINGER,
	ICON_SCIENTIST_DOWN,
	ICON_SCIENTIST_UP,
	ICON_SCIENTIST_RIGHT,
	ICON_SCIENTIST_LEFT,
	ICON_WORKER_DOWN,
	ICON_WORKER_UP,
	ICON_WORKER_RIGHT,
	ICON_WORKER_LEFT,
	ICON_SHOCKBOT_DOWN,
	ICON_SHOCKBOT_UP,
	ICON_SHOCKBOT_RIGHT,
	ICON_SHOCKBOT_LEFT,
	ICON_RIGHTBOT_DOWN,
	ICON_RIGHTBOT_UP,
	ICON_RIGHTBOT_RIGHT,
	ICON_RIGHTBOT_LEFT,
	ICON_PUSHBOT_DOWN,
	ICON_PUSHBOT_UP,
	ICON_PUSHBOT_RIGHT,
	ICON_PUSHBOT_LEFT,
	ICON_LISTENBOT_DOWN,
	ICON_LISTENBOT_UP,
	ICON_LISTENBOT_RIGHT,
	ICON_LISTENBOT_LEFT,
	ICON_MONKEYSTONE,
	ICON_TELEPORTER1,
	ICON_TELEPORTER2,
	ICON_TELEPORTER3,
	ICON_TELEPORTER4,
	ICON_TELEPORTER5,
	ICON_TELEPORTER6,
	ICON_TELEPORTER7,
	ICON_TELEPORTER8,
	ICON_TELEPORTER9,
	ICON_TELEPORTER10,
	ICON_TELEPORTER11,
	ICON_TELEPORTER12,
	ICON_TELEPORTER13,
	ICON_TELEPORTER14,
	ICON_TELEPORTER15,
	ICON_TELEPORTER16,
	ICON_TELEPORTER17,
	ICON_TELEPORTER18,
	ICON_TELEPORTER19,
	ICON_TELEPORTER20,
	ICON_LEVELEXIT,
	ICON_ACTION1,
	ICON_ACTION2,
	ICON_ACTION3,
	ICON_ACTION4,
	ICON_ACTION5,
	ICON_ACTION6,
	ICON_ACTION7,
	ICON_ACTION8,
	ICON_ACTION9,
	ICON_ACTION10,
	ICON_ACTION11,
	ICON_ACTION12,
	ICON_ACTION13,
	ICON_ACTION14,
	ICON_ACTION15,
	ICON_ACTION16,
	ICON_ACTION17,
	ICON_ACTION18,
	ICON_ACTION19,
	ICON_ACTION20,
	ICON_SPACEDUDE_DOWN,
	ICON_SPACEDUDE_UP,
	ICON_SPACEDUDE_RIGHT,
	ICON_SPACEDUDE_LEFT,
	ICON_SERGEANT_DOWN,
	ICON_SERGEANT_UP,
	ICON_SERGEANT_RIGHT,
	ICON_SERGEANT_LEFT,
	ICON_MAINTBOT_DOWN,
	ICON_MAINTBOT_UP,
	ICON_MAINTBOT_RIGHT,
	ICON_MAINTBOT_LEFT,
	ICON_ACTION_AUTO,
	ICON_GEM_WHITE,
	ICON_GEM_BLUE,
	ICON_GEM_RED,
	ICON_GEM_GREEN,
	ICON_SET_MUSIC,
	ICON_LUA,
	ICON_HERE,
	ICON_VORTEXIAN,
	ICON_CHICKEN_DOWN,
	ICON_CHICKEN_UP,
	ICON_CHICKEN_RIGHT,
	ICON_CHICKEN_LEFT,
	ICON_GOO_CUP,
	ICON_TEACUP,
	ICON_COOKIE,
	ICON_BURGER,
	ICON_PDA,
	ICON_BOOK,
	ICON_CLIPBOARD,
	ICON_NOTE,
	ICON_KEYCARD_WHITE,
	ICON_KEYCARD_BLUE,
	ICON_KEYCARD_RED,
	ICON_KEYCARD_GREEN,
	ICON_KEYCARD_PURPLE,
	ICON_KEYCARD_BLACK,
	ICON_MAGIC_EGG,
	ICON_ICE_BLOCK,
	ICON_CABKEY,
	ICON_DEAD_WORKER,
	ICON_OMNIBOT_DOWN,
	ICON_OMNIBOT_UP,
	ICON_OMNIBOT_RIGHT,
	ICON_OMNIBOT_LEFT,
	ICON_TURNBOT_DOWN,
	ICON_TURNBOT_UP,
	ICON_TURNBOT_RIGHT,
	ICON_TURNBOT_LEFT,
	ICON_DOLLY_DOWN,
	ICON_DOLLY_UP,
	ICON_DOLLY_RIGHT,
	ICON_DOLLY_LEFT,
	ICON_TRIGGER,
	ICON_DOLLY_TOOL1,
	ICON_DOLLY_TOOL2,
	ICON_DOLLY_TOOL3,
	ICON_DOLLY_TOOL4,
	ICON_RAILRIDER_ON_UP,
	ICON_RAILRIDER_ON_DOWN,
	ICON_RAILRIDER_ON_LEFT,
	ICON_RAILRIDER_ON_RIGHT,
	ICON_RAILRIDER_UP,
	ICON_RAILRIDER_DOWN,
	ICON_RAILRIDER_LEFT,
	ICON_RAILRIDER_RIGHT,
	ICON_SODA,
	ICON_ARROW_4WAY,
	ICON_DEADEYE_DOWN,
	ICON_DEADEYE_UP,
	ICON_DEADEYE_RIGHT,
	ICON_DEADEYE_LEFT,
	ICON_MEERKAT_MOUND,
	ICON_FATFROG_DOWN,
	ICON_FATFROG_RIGHT,
	ICON_FATFROG_LEFT,
	ICON_GOODFAIRY_DOWN,
	ICON_GOODFAIRY_UP,
	ICON_GOODFAIRY_RIGHT,
	ICON_GOODFAIRY_LEFT,
	ICON_BADFAIRY_DOWN,
	ICON_BADFAIRY_UP,
	ICON_BADFAIRY_RIGHT,
	ICON_BADFAIRY_LEFT,
	ICON_ACCOUNTANT_DOWN,
	ICON_ACCOUNTANT_UP,
	ICON_ACCOUNTANT_RIGHT,
	ICON_ACCOUNTANT_LEFT,
	ICON_ICEPUFF_DOWN,
	ICON_DRAGON_DOWN,
	ICON_BUZZFLY_DOWN,
	ICON_BUZZFLY_UP,
	ICON_BUZZFLY_RIGHT,
	ICON_BUZZFLY_LEFT,
	ICON_FROG_STATUE,
	ICON_PIZZA_SLICER,
	ICON_FAIRY_SRC,
	ICON_FAIRY_SRC2,
	ICON_FAIRY_SRC3,
	ICON_FAIRY_SRC4,
	ICON_FAIRY_SRC5,
	ICON_FAIRY_DEST,
	ICON_FAIRY_DEST2,
	ICON_FAIRY_DEST3,
	ICON_FAIRY_DEST4,
	ICON_FAIRY_DEST5,
	ICON_QUESTION_MARK,
	ICON_DEBUG_LOGO,
	ICON_TARGET_X,
	ICON_WAYPOINT_SELECT1,
	ICON_WAYPOINT_SELECT2,
	ICON_WAYPOINT_SELECT3,
	ICON_WAYPOINT_SELECT4,
	ICON_WAYPOINT_1,
	ICON_WAYPOINT_2
};

} // End of Namespace

#endif // !HDB_MPC_H
