/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.annotations;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.annotations.AAnnotationContentComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTextField;

public final class AnnotationContentComponentDataValues
extends AAnnotationContentComponent {
    private JTextField m_textfield = new JTextField();

    public AnnotationContentComponentDataValues(ITracePoint2D point) {
        super(point);
        this.m_textfield.setEditable(false);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(8));
        this.add(this.m_textfield);
        this.add(Box.createHorizontalStrut(8));
        this.updateDataValueTextField();
    }

    public Dimension getPreferredSize() {
        Dimension result = this.m_textfield.getPreferredSize();
        result.height += 16;
        result.width += 16;
        return result;
    }

    public void paintAnnotation(Graphics g, Chart2D chart, ITrace2D trace, ITracePoint2D point) {
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.m_textfield != null) {
            this.m_textfield.setBackground(bg);
        }
    }

    private void updateDataValueTextField() {
        ITracePoint2D point = this.getAnnotatedPoint();
        StringBuilder textbuffer = new StringBuilder();
        textbuffer.append("(").append(point.getX()).append(", ").append(point.getY()).append(')');
        String text = textbuffer.toString();
        FontMetrics fmetrics = this.getFontMetrics(this.m_textfield.getFont());
        int width = fmetrics.stringWidth(text);
        int height = fmetrics.getHeight();
        this.m_textfield.setText(textbuffer.toString());
    }
}

