// RUN: %clang --target=riscv32 -### -c %s 2>&1 -march=rvi20u32 \
// RUN:   | FileCheck -check-prefix=RVI20U32 %s
// RVI20U32: "-target-feature" "-a"
// RVI20U32: "-target-feature" "-c"
// RVI20U32: "-target-feature" "-d"
// RVI20U32: "-target-feature" "-f"
// RVI20U32: "-target-feature" "-m"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rvi20u64 \
// RUN:  | FileCheck -check-prefix=RVI20U64 %s
// RVI20U64: "-target-feature" "-a"
// RVI20U64: "-target-feature" "-c"
// RVI20U64: "-target-feature" "-d"
// RVI20U64: "-target-feature" "-f"
// RVI20U64: "-target-feature" "-m"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rva20u64 \
// RUN:   | FileCheck -check-prefix=RVA20U64 %s
// RVA20U64: "-target-feature" "+m"
// RVA20U64: "-target-feature" "+a"
// RVA20U64: "-target-feature" "+f"
// RVA20U64: "-target-feature" "+d"
// RVA20U64: "-target-feature" "+c"
// RVA20U64: "-target-feature" "+ziccamoa"
// RVA20U64: "-target-feature" "+ziccif"
// RVA20U64: "-target-feature" "+zicclsm"
// RVA20U64: "-target-feature" "+ziccrse"
// RVA20U64: "-target-feature" "+zicntr"
// RVA20U64: "-target-feature" "+zicsr"
// RVA20U64: "-target-feature" "+za128rs"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rva20s64 \
// RUN:   | FileCheck -check-prefix=RVA20S64 %s
// RVA20S64: "-target-feature" "+m"
// RVA20S64: "-target-feature" "+a"
// RVA20S64: "-target-feature" "+f"
// RVA20S64: "-target-feature" "+d"
// RVA20S64: "-target-feature" "+c"
// RVA20S64: "-target-feature" "+ziccamoa"
// RVA20S64: "-target-feature" "+ziccif"
// RVA20S64: "-target-feature" "+zicclsm"
// RVA20S64: "-target-feature" "+ziccrse"
// RVA20S64: "-target-feature" "+zicntr"
// RVA20S64: "-target-feature" "+zicsr"
// RVA20S64: "-target-feature" "+zifencei"
// RVA20S64: "-target-feature" "+za128rs"
// RVA20S64: "-target-feature" "+ssccptr"
// RVA20S64: "-target-feature" "+sstvala"
// RVA20S64: "-target-feature" "+sstvecd"
// RVA20S64: "-target-feature" "+svade"
// RVA20S64: "-target-feature" "+svbare"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rva22u64 \
// RUN:   | FileCheck -check-prefix=RVA22U64 %s
// RVA22U64: "-target-feature" "+m"
// RVA22U64: "-target-feature" "+a"
// RVA22U64: "-target-feature" "+f"
// RVA22U64: "-target-feature" "+d"
// RVA22U64: "-target-feature" "+c"
// RVA22U64: "-target-feature" "+zic64b"
// RVA22U64: "-target-feature" "+zicbom"
// RVA22U64: "-target-feature" "+zicbop"
// RVA22U64: "-target-feature" "+zicboz"
// RVA22U64: "-target-feature" "+ziccamoa"
// RVA22U64: "-target-feature" "+ziccif"
// RVA22U64: "-target-feature" "+zicclsm"
// RVA22U64: "-target-feature" "+ziccrse"
// RVA22U64: "-target-feature" "+zicntr"
// RVA22U64: "-target-feature" "+zicsr"
// RVA22U64: "-target-feature" "+zihintpause"
// RVA22U64: "-target-feature" "+zihpm"
// RVA22U64: "-target-feature" "+za64rs"
// RVA22U64: "-target-feature" "+zfhmin"
// RVA22U64: "-target-feature" "+zba"
// RVA22U64: "-target-feature" "+zbb"
// RVA22U64: "-target-feature" "+zbs"
// RVA22U64: "-target-feature" "+zkt"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rva22s64 \
// RUN:   | FileCheck -check-prefix=RVA22S64 %s
// RVA22S64: "-target-feature" "+m"
// RVA22S64: "-target-feature" "+a"
// RVA22S64: "-target-feature" "+f"
// RVA22S64: "-target-feature" "+d"
// RVA22S64: "-target-feature" "+c"
// RVA22S64: "-target-feature" "+zic64b"
// RVA22S64: "-target-feature" "+zicbom"
// RVA22S64: "-target-feature" "+zicbop"
// RVA22S64: "-target-feature" "+zicboz"
// RVA22S64: "-target-feature" "+ziccamoa"
// RVA22S64: "-target-feature" "+ziccif"
// RVA22S64: "-target-feature" "+zicclsm"
// RVA22S64: "-target-feature" "+ziccrse"
// RVA22S64: "-target-feature" "+zicntr"
// RVA22S64: "-target-feature" "+zicsr"
// RVA22S64: "-target-feature" "+zifencei"
// RVA22S64: "-target-feature" "+zihintpause"
// RVA22S64: "-target-feature" "+zihpm"
// RVA22S64: "-target-feature" "+za64rs"
// RVA22S64: "-target-feature" "+zfhmin"
// RVA22S64: "-target-feature" "+zba"
// RVA22S64: "-target-feature" "+zbb"
// RVA22S64: "-target-feature" "+zbs"
// RVA22S64: "-target-feature" "+zkt"
// RVA22S64: "-target-feature" "+ssccptr"
// RVA22S64: "-target-feature" "+sscounterenw"
// RVA22S64: "-target-feature" "+sstvala"
// RVA22S64: "-target-feature" "+sstvecd"
// RVA22S64: "-target-feature" "+svade"
// RVA22S64: "-target-feature" "+svbare"
// RVA22S64: "-target-feature" "+svinval"
// RVA22S64: "-target-feature" "+svpbmt"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rva23u64 -menable-experimental-extensions \
// RUN:   | FileCheck -check-prefix=RVA23U64 %s
// RVA23U64: "-target-feature" "+m"
// RVA23U64: "-target-feature" "+a"
// RVA23U64: "-target-feature" "+f"
// RVA23U64: "-target-feature" "+d"
// RVA23U64: "-target-feature" "+c"
// RVA23U64: "-target-feature" "+v"
// RVA23U64: "-target-feature" "+zic64b"
// RVA23U64: "-target-feature" "+zicbom"
// RVA23U64: "-target-feature" "+zicbop"
// RVA23U64: "-target-feature" "+zicboz"
// RVA23U64: "-target-feature" "+ziccamoa"
// RVA23U64: "-target-feature" "+ziccif"
// RVA23U64: "-target-feature" "+zicclsm"
// RVA23U64: "-target-feature" "+ziccrse"
// RVA23U64: "-target-feature" "+zicntr"
// RVA23U64: "-target-feature" "+zicond"
// RVA23U64: "-target-feature" "+zicsr"
// RVA23U64: "-target-feature" "+zihintntl"
// RVA23U64: "-target-feature" "+zihintpause"
// RVA23U64: "-target-feature" "+zihpm"
// RVA23U64: "-target-feature" "+zimop"
// RVA23U64: "-target-feature" "+za64rs"
// RVA23U64: "-target-feature" "+zawrs"
// RVA23U64: "-target-feature" "+zfa"
// RVA23U64: "-target-feature" "+zfhmin"
// RVA23U64: "-target-feature" "+zcb"
// RVA23U64: "-target-feature" "+zcmop"
// RVA23U64: "-target-feature" "+zba"
// RVA23U64: "-target-feature" "+zbb"
// RVA23U64: "-target-feature" "+zbs"
// RVA23U64: "-target-feature" "+zkt"
// RVA23U64: "-target-feature" "+zvbb"
// RVA23U64: "-target-feature" "+zvfhmin"
// RVA23U64: "-target-feature" "+zvkt"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rva23s64 -menable-experimental-extensions \
// RUN:   | FileCheck -check-prefix=RVA23S64 %s
// RVA23S64: "-target-feature" "+m"
// RVA23S64: "-target-feature" "+a"
// RVA23S64: "-target-feature" "+f"
// RVA23S64: "-target-feature" "+d"
// RVA23S64: "-target-feature" "+c"
// RVA23S64: "-target-feature" "+v"
// RVA23S64: "-target-feature" "+h"
// RVA23S64: "-target-feature" "+zic64b"
// RVA23S64: "-target-feature" "+zicbom"
// RVA23S64: "-target-feature" "+zicbop"
// RVA23S64: "-target-feature" "+zicboz"
// RVA23S64: "-target-feature" "+ziccamoa"
// RVA23S64: "-target-feature" "+ziccif"
// RVA23S64: "-target-feature" "+zicclsm"
// RVA23S64: "-target-feature" "+ziccrse"
// RVA23S64: "-target-feature" "+zicntr"
// RVA23S64: "-target-feature" "+zicond"
// RVA23S64: "-target-feature" "+zicsr"
// RVA23S64: "-target-feature" "+zifencei"
// RVA23S64: "-target-feature" "+zihintntl"
// RVA23S64: "-target-feature" "+zihintpause"
// RVA23S64: "-target-feature" "+zihpm"
// RVA23S64: "-target-feature" "+zimop"
// RVA23S64: "-target-feature" "+za64rs"
// RVA23S64: "-target-feature" "+zawrs"
// RVA23S64: "-target-feature" "+zfa"
// RVA23S64: "-target-feature" "+zfhmin"
// RVA23S64: "-target-feature" "+zcb"
// RVA23S64: "-target-feature" "+zcmop"
// RVA23S64: "-target-feature" "+zba"
// RVA23S64: "-target-feature" "+zbb"
// RVA23S64: "-target-feature" "+zbs"
// RVA23S64: "-target-feature" "+zkt"
// RVA23S64: "-target-feature" "+zvbb"
// RVA23S64: "-target-feature" "+zvfhmin"
// RVA23S64: "-target-feature" "+zvkt"
// RVA23S64: "-target-feature" "+shcounterenw"
// RVA23S64: "-target-feature" "+shgatpa"
// RVA23S64: "-target-feature" "+shtvala"
// RVA23S64: "-target-feature" "+shvsatpa"
// RVA23S64: "-target-feature" "+shvstvala"
// RVA23S64: "-target-feature" "+shvstvecd"
// RVA23S64: "-target-feature" "+ssccptr"
// RVA23S64: "-target-feature" "+sscofpmf"
// RVA23S64: "-target-feature" "+sscounterenw"
// RVA23S64: "-target-feature" "+experimental-ssnpm"
// RVA23S64: "-target-feature" "+ssstateen"
// RVA23S64: "-target-feature" "+sstc"
// RVA23S64: "-target-feature" "+sstvala"
// RVA23S64: "-target-feature" "+sstvecd"
// RVA23S64: "-target-feature" "+ssu64xl"
// RVA23S64: "-target-feature" "+svade"
// RVA23S64: "-target-feature" "+svbare"
// RVA23S64: "-target-feature" "+svinval"
// RVA23S64: "-target-feature" "+svnapot"
// RVA23S64: "-target-feature" "+svpbmt"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rvb23u64 -menable-experimental-extensions \
// RUN:   | FileCheck -check-prefix=RVB23U64 %s
// RVB23U64: "-target-feature" "+m"
// RVB23U64: "-target-feature" "+a"
// RVB23U64: "-target-feature" "+f"
// RVB23U64: "-target-feature" "+d"
// RVB23U64: "-target-feature" "+c"
// RVB23U64: "-target-feature" "+zic64b"
// RVB23U64: "-target-feature" "+zicbom"
// RVB23U64: "-target-feature" "+zicbop"
// RVB23U64: "-target-feature" "+zicboz"
// RVB23U64: "-target-feature" "+ziccamoa"
// RVB23U64: "-target-feature" "+ziccif"
// RVB23U64: "-target-feature" "+zicclsm"
// RVB23U64: "-target-feature" "+ziccrse"
// RVB23U64: "-target-feature" "+zicntr"
// RVB23U64: "-target-feature" "+zicond"
// RVB23U64: "-target-feature" "+zicsr"
// RVB23U64: "-target-feature" "+zihintntl"
// RVB23U64: "-target-feature" "+zihintpause"
// RVB23U64: "-target-feature" "+zihpm"
// RVB23U64: "-target-feature" "+zimop"
// RVB23U64: "-target-feature" "+za64rs"
// RVB23U64: "-target-feature" "+zawrs"
// RVB23U64: "-target-feature" "+zfa"
// RVB23U64: "-target-feature" "+zcb"
// RVB23U64: "-target-feature" "+zcmop"
// RVB23U64: "-target-feature" "+zba"
// RVB23U64: "-target-feature" "+zbb"
// RVB23U64: "-target-feature" "+zbs"
// RVB23U64: "-target-feature" "+zkt"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rvb23s64 -menable-experimental-extensions \
// RUN:   | FileCheck -check-prefix=RVB23S64 %s
// RVB23S64: "-target-feature" "+m"
// RVB23S64: "-target-feature" "+a"
// RVB23S64: "-target-feature" "+f"
// RVB23S64: "-target-feature" "+d"
// RVB23S64: "-target-feature" "+c"
// RVB23S64: "-target-feature" "+zic64b"
// RVB23S64: "-target-feature" "+zicbom"
// RVB23S64: "-target-feature" "+zicbop"
// RVB23S64: "-target-feature" "+zicboz"
// RVB23S64: "-target-feature" "+ziccamoa"
// RVB23S64: "-target-feature" "+ziccif"
// RVB23S64: "-target-feature" "+zicclsm"
// RVB23S64: "-target-feature" "+ziccrse"
// RVB23S64: "-target-feature" "+zicntr"
// RVB23S64: "-target-feature" "+zicond"
// RVB23S64: "-target-feature" "+zicsr"
// RVB23S64: "-target-feature" "+zifencei"
// RVB23S64: "-target-feature" "+zihintntl"
// RVB23S64: "-target-feature" "+zihintpause"
// RVB23S64: "-target-feature" "+zihpm"
// RVB23S64: "-target-feature" "+zimop"
// RVB23S64: "-target-feature" "+za64rs"
// RVB23S64: "-target-feature" "+zawrs"
// RVB23S64: "-target-feature" "+zfa"
// RVB23S64: "-target-feature" "+zcb"
// RVB23S64: "-target-feature" "+zcmop"
// RVB23S64: "-target-feature" "+zba"
// RVB23S64: "-target-feature" "+zbb"
// RVB23S64: "-target-feature" "+zbs"
// RVB23S64: "-target-feature" "+zkt"
// RVB23S64: "-target-feature" "+ssccptr"
// RVB23S64: "-target-feature" "+sscofpmf"
// RVB23S64: "-target-feature" "+sscounterenw"
// RVB23S64: "-target-feature" "+sstc"
// RVB23S64: "-target-feature" "+sstvala"
// RVB23S64: "-target-feature" "+sstvecd"
// RVB23S64: "-target-feature" "+ssu64xl"
// RVB23S64: "-target-feature" "+svade"
// RVB23S64: "-target-feature" "+svbare"
// RVB23S64: "-target-feature" "+svinval"
// RVB23S64: "-target-feature" "+svnapot"
// RVB23S64: "-target-feature" "+svpbmt"

// RUN: %clang --target=riscv32 -### -c %s 2>&1 -march=rvm23u32 -menable-experimental-extensions \
// RUN:   | FileCheck -check-prefix=RVM23U32 %s
// RVM23U32: "-target-feature" "+m"
// RVM23U32: "-target-feature" "+zicbop"
// RVM23U32: "-target-feature" "+zicond"
// RVM23U32: "-target-feature" "+zicsr"
// RVM23U32: "-target-feature" "+zihintntl"
// RVM23U32: "-target-feature" "+zihintpause"
// RVM23U32: "-target-feature" "+zimop"
// RVM23U32: "-target-feature" "+zce"
// RVM23U32: "-target-feature" "+zcmop"
// RVM23U32: "-target-feature" "+zba"
// RVM23U32: "-target-feature" "+zbb"
// RVM23U32: "-target-feature" "+zbs"

// RUN: %clang --target=riscv64 -### -c %s 2>&1 -march=rva22u64_zfa \
// RUN:   | FileCheck -check-prefix=PROFILE-WITH-ADDITIONAL %s
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+m"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+a"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+f"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+d"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+c"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zicbom"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zicbop"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zicboz"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zihintpause"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zfa"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zfhmin"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zba"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zbb"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zbs"
// PROFILE-WITH-ADDITIONAL: "-target-feature" "+zkt"

// RUN: not %clang --target=riscv64 -### -c %s 2>&1 -march=rva19u64_zfa | FileCheck -check-prefix=INVALID-PROFILE %s
// INVALID-PROFILE: error: invalid arch name 'rva19u64_zfa', string must begin with rv32{i,e,g}, rv64{i,e,g}, or a supported profile name

// RUN: not %clang --target=riscv64 -### -c %s 2>&1 -march=rva22u64zfa | FileCheck -check-prefix=INVALID-ADDITIONAL %s
// INVALID-ADDITIONAL: error: invalid arch name 'rva22u64zfa', additional extensions must be after separator '_'

// RUN: not %clang --target=riscv64 -### -c %s 2>&1 -march=rva23u64 | FileCheck -check-prefix=EXPERIMENTAL-NOFLAG %s
// EXPERIMENTAL-NOFLAG: error: invalid arch name 'rva23u64'
// EXPERIMENTAL-NOFLAG: requires '-menable-experimental-extensions' for profile 'rva23u64'
