use super::{
    common::{RustStemmer, StopWordFilter, RegexTrimmer},
    Language,
};
use crate::pipeline::Pipeline;
use rust_stemmers::Algorithm;

#[derive(Clone)]
pub struct Finnish {}

impl Finnish {
    pub fn new() -> Self {
        Self {}
    }
}

impl Language for Finnish {
    fn name(&self) -> String {
        "Finnish".into()
    }
    fn code(&self) -> String {
        "fi".into()
    }

    fn tokenize(&self, text: &str) -> Vec<String> {
        super::tokenize_whitespace(text)
    }

    fn make_pipeline(&self) -> Pipeline {
        Pipeline {
            queue: vec![
                Box::new(RegexTrimmer::new("trimmer-fi", r"\p{Latin}")),
                Box::new(StopWordFilter::new("stopWordFilter-fi", STOP_WORDS)),
                Box::new(RustStemmer::new("stemmer-fi", Algorithm::Finnish)),
            ],
        }
    }
}

const STOP_WORDS: &[&str] = &[
    "",
    "ei",
    "eivät",
    "emme",
    "en",
    "et",
    "ette",
    "että",
    "he",
    "heidän",
    "heidät",
    "heihin",
    "heille",
    "heillä",
    "heiltä",
    "heissä",
    "heistä",
    "heitä",
    "hän",
    "häneen",
    "hänelle",
    "hänellä",
    "häneltä",
    "hänen",
    "hänessä",
    "hänestä",
    "hänet",
    "häntä",
    "itse",
    "ja",
    "johon",
    "joiden",
    "joihin",
    "joiksi",
    "joilla",
    "joille",
    "joilta",
    "joina",
    "joissa",
    "joista",
    "joita",
    "joka",
    "joksi",
    "jolla",
    "jolle",
    "jolta",
    "jona",
    "jonka",
    "jos",
    "jossa",
    "josta",
    "jota",
    "jotka",
    "kanssa",
    "keiden",
    "keihin",
    "keiksi",
    "keille",
    "keillä",
    "keiltä",
    "keinä",
    "keissä",
    "keistä",
    "keitä",
    "keneen",
    "keneksi",
    "kenelle",
    "kenellä",
    "keneltä",
    "kenen",
    "kenenä",
    "kenessä",
    "kenestä",
    "kenet",
    "ketkä",
    "ketkä",
    "ketä",
    "koska",
    "kuin",
    "kuka",
    "kun",
    "me",
    "meidän",
    "meidät",
    "meihin",
    "meille",
    "meillä",
    "meiltä",
    "meissä",
    "meistä",
    "meitä",
    "mihin",
    "miksi",
    "mikä",
    "mille",
    "millä",
    "miltä",
    "minkä",
    "minkä",
    "minua",
    "minulla",
    "minulle",
    "minulta",
    "minun",
    "minussa",
    "minusta",
    "minut",
    "minuun",
    "minä",
    "minä",
    "missä",
    "mistä",
    "mitkä",
    "mitä",
    "mukaan",
    "mutta",
    "ne",
    "niiden",
    "niihin",
    "niiksi",
    "niille",
    "niillä",
    "niiltä",
    "niin",
    "niin",
    "niinä",
    "niissä",
    "niistä",
    "niitä",
    "noiden",
    "noihin",
    "noiksi",
    "noilla",
    "noille",
    "noilta",
    "noin",
    "noina",
    "noissa",
    "noista",
    "noita",
    "nuo",
    "nyt",
    "näiden",
    "näihin",
    "näiksi",
    "näille",
    "näillä",
    "näiltä",
    "näinä",
    "näissä",
    "näistä",
    "näitä",
    "nämä",
    "ole",
    "olemme",
    "olen",
    "olet",
    "olette",
    "oli",
    "olimme",
    "olin",
    "olisi",
    "olisimme",
    "olisin",
    "olisit",
    "olisitte",
    "olisivat",
    "olit",
    "olitte",
    "olivat",
    "olla",
    "olleet",
    "ollut",
    "on",
    "ovat",
    "poikki",
    "se",
    "sekä",
    "sen",
    "siihen",
    "siinä",
    "siitä",
    "siksi",
    "sille",
    "sillä",
    "sillä",
    "siltä",
    "sinua",
    "sinulla",
    "sinulle",
    "sinulta",
    "sinun",
    "sinussa",
    "sinusta",
    "sinut",
    "sinuun",
    "sinä",
    "sinä",
    "sitä",
    "tai",
    "te",
    "teidän",
    "teidät",
    "teihin",
    "teille",
    "teillä",
    "teiltä",
    "teissä",
    "teistä",
    "teitä",
    "tuo",
    "tuohon",
    "tuoksi",
    "tuolla",
    "tuolle",
    "tuolta",
    "tuon",
    "tuona",
    "tuossa",
    "tuosta",
    "tuota",
    "tähän",
    "täksi",
    "tälle",
    "tällä",
    "tältä",
    "tämä",
    "tämän",
    "tänä",
    "tässä",
    "tästä",
    "tätä",
    "vaan",
    "vai",
    "vaikka",
    "yli",
];
