% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_events.R
\name{tween_events}
\alias{tween_events}
\title{Transition in and out of events}
\usage{
tween_events(
  .data,
  ease,
  nframes,
  start,
  end = NULL,
  range = NULL,
  enter = NULL,
  exit = NULL,
  enter_length = 0,
  exit_length = 0
)
}
\arguments{
\item{.data}{A data.frame with components at different stages}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{nframes}{The number of frames to calculate for the tween}

\item{start, end}{The start (and potential end) of the event encoded in the
row, as unquoted expressions. Will be evaluated in the context of \code{.data} so
can refer to columns in it. If \code{end = NULL} the event will be without extend
and only visible in a single frame, unless \code{enter} and/or \code{exit} is given.}

\item{range}{The range of time points to include in the tween. If \code{NULL} it
will use the range of \code{time}}

\item{enter, exit}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}

\item{enter_length, exit_length}{The lenght of the opening and closing
transitions if \code{enter} and/or \code{exit} is given. Measured in the same units as
\code{time}}
}
\value{
A data.frame with the same columns as \code{.data} along with \code{.id} giving
the component id, \code{.phase} giving the state of each component in each frame,
and \code{.frame} giving the frame membership of each row.
}
\description{
This tweening function is a more powerful version of \code{\link[=tween_appear]{tween_appear()}}, with
support for newer features such as enter/exits and tween phase
identification. The tweener treats each row in the data as unique events in
time, and creates frames with the correct events present at any given time.
}
\examples{
d <- data.frame(
  x = runif(20),
  y = runif(20),
  time = runif(20),
  duration = runif(20, max = 0.1)
)
from_left <- function(x) {
  x$x <- -0.5
  x
}
to_right <- function(x) {
  x$x <- 1.5
  x
}

tween_events(d, 'cubic-in-out', 50, start = time, end = time + duration,
             enter = from_left, exit = to_right, enter_length = 0.1,
             exit_length = 0.05)

}
\seealso{
Other data.frame tween: 
\code{\link{tween_along}()},
\code{\link{tween_appear}()},
\code{\link{tween_components}()},
\code{\link{tween_elements}()},
\code{\link{tween_states}()}
}
\concept{data.frame tween}
