context("node_types")

get_type <- function(gr, fn) {
  gr %>% mutate(type = fn) %>% pull(type)
}
test_that("node types return logical", {
  gr <- create_tree(10, 2)
  expect_is(get_type(gr, node_is_center()), 'logical')
  expect_is(get_type(gr, node_is_cut()), 'logical')
  expect_is(get_type(gr, node_is_isolated()), 'logical')
  expect_is(get_type(gr, node_is_leaf()), 'logical')
  expect_is(get_type(gr, node_is_root()), 'logical')
  expect_is(get_type(gr, node_is_simplical()), 'logical')
  expect_is(get_type(gr, node_is_sink()), 'logical')
  expect_is(get_type(gr, node_is_source()), 'logical')
  expect_is(get_type(gr, node_is_universal()), 'logical')
})
test_that("node types return vector of correct length", {
  gr <- create_tree(10, 2)
  expect_length(get_type(gr, node_is_center()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_cut()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_isolated()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_leaf()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_root()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_simplical()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_sink()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_source()), igraph::gorder(gr))
  expect_length(get_type(gr, node_is_universal()), igraph::gorder(gr))
})
test_that("node types require active nodes", {
  gr <- create_tree(10, 2) %>% activate(edges)
  expect_error(get_type(gr, node_is_center()))
  expect_error(get_type(gr, node_is_cut()))
  expect_error(get_type(gr, node_is_isolated()))
  expect_error(get_type(gr, node_is_leaf()))
  expect_error(get_type(gr, node_is_root()))
  expect_error(get_type(gr, node_is_simplical()))
  expect_error(get_type(gr, node_is_sink()))
  expect_error(get_type(gr, node_is_source()))
  expect_error(get_type(gr, node_is_universal()))
})
