% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd2s_and_s2sd.R
\name{Parameter_Conversion}
\alias{Parameter_Conversion}
\alias{sd2s}
\alias{s2sd}
\title{Easy conversion of parameters between stabledist (Nolan 1-parameterization) and stable (Lambert and Lindsey 1999)}
\usage{
sd2s(alpha, beta, gamma, delta, pm = 1)

s2sd(tail, skew, disp, loc, pm = 1)
}
\arguments{
\item{alpha}{the stabledist 'alpha'}

\item{beta}{the stabledist 'beta'}

\item{gamma}{the stabledist 'gamma'}

\item{delta}{the stabledist 'delta'}

\item{pm}{default 1; currently only value supported. the stabledist parameterization 'pm'}

\item{tail}{the stable 'tail' analogous to 'alpha'}

\item{skew}{the stable 'skew' analogous to 'beta'}

\item{disp}{the stable 'disp' analogous to 'gamma'}

\item{loc}{the stable 'loc' analogous to 'delta'}
}
\value{
\code{sd2s} returns stable parameters as put forth in Lambert and Lindsey (1999) and used in this package.
\code{s2sd} returns stabledist parameters (Nolan 1-parameterization).
}
\description{
\code{sd2s} has stabledist parameter (Nolan 1-parameterization) inputs and returns stable parameters as put forth in Lambert and Lindsey (1999) and used in this package.
\code{s2sd} has stable     parameter (Lambert and Lindsey (1999)) inputs and returns stabledist parameters (Nolan 1-parameterization).
See examples and the readme.  There's also more context and references in `?stable::dstable`.
}
\details{
[Swihart 2022 update:] See the examples and README for how to make equivalent calls
to those of 'stabledist' (i.e., Nolan's 1-parameterization 
as detailed in Nolan (2020)) using these functions and this package. 
See github for Lambert and Lindsey 1999 JRSS-C journal article, 
which details the parameterization of the Buck (1995) stable distribution which allowed
a Fourier inversion to arrive at a form of the $g_d$ function as detailed in Nolan (2020),
The Buck (1995) parameterization most closely resembles the Zolotarev B parameterization
outlined in Definition 3.6 on page 93 of Nolan (2020) -- except that Buck (1995) did
not allow the scale parameter to multiply with the location parameter.  
This explains why the `Zolotarev B` entry in Table 3.1 on page 97 of Nolan (2020) has
the location parameter being multiplied by the scale parameter whereas in converting the Lindsey and Lambert (1999)
to Nolan 1-parameterization the location parameter stays the same.
}
\examples{
\dontrun{
q <- -1
# nolan pm=1 parameters:
a <-  1.3
b <-  -0.4
c <-  2
d <-  0.75
s <- sd2s(alpha=a, beta=b, gamma=c, delta=d)
stable::pstable(q, tail = s$tail, skew=s$skew, disp = s$disp, loc  = s$loc)
stabledist::pstable(q, alpha=a, beta=b , gamma=c , delta=d, pm=1)
sd <- s2sd(tail = s$tail, skew=s$skew, disp = s$disp, loc  = s$loc)
stabledist::pstable(q, alpha=sd$alpha, beta=sd$beta , gamma=sd$gamma , delta=sd$delta, pm=1)}
}
\references{
Lambert, P. and Lindsey, J.K. (1999) Analysing financial returns using
regression models based on non-symmetric stable distributions. Applied
Statistics, 48, 409-424.

Nolan, John P. Univariate stable distributions. Berlin/Heidelberg, Germany: Springer, 2020.
}
