% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_parsed_case_internal.R
\name{to_parsed_case_internal}
\alias{to_parsed_case_internal}
\title{Internal parser, which is relevant for preprocessing, parsing and parsing options}
\usage{
to_parsed_case_internal(string, parsing_option = 1L, numerals,
  abbreviations, sep_in)
}
\arguments{
\item{string}{A string.}

\item{parsing_option}{An integer that will determine the parsing option.
\itemize{
 \item{1: \code{RRRStudio -> RRR_Studio}}
 \item{2: \code{RRRStudio -> RRRS_tudio}}
 \item{3: parses like option 1 but suppresses "_" around non alpha-numeric characters. In this way this option suppresses splits and resulting case conversion after these characters.}
 \item{any other integer <= 0: no parsing"}
 }}

\item{numerals}{A character specifying the alignment of numerals (\code{"middle"}, \code{left}, \code{right} or \code{asis}). I.e. \code{numerals = "left"} ensures that no output separator is in front of a digit.}

\item{abbreviations}{A character string specifying abbreviations that should be marked to be recognized by later parsing.}

\item{sep_in}{A character (regular expression) used to specify input separators.}
}
\value{
A character vector separated by underscores, containing the parsed string.
}
\description{
Internal parser, which is relevant for preprocessing, parsing and parsing options
}
\author{
Malte Grosser, \email{malte.grosser@gmail.com}
}
\keyword{utilities}
