% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logmap.R
\name{droplevels.LogMap}
\alias{droplevels.LogMap}
\title{Drop Unused Logical Map Values}
\usage{
\method{droplevels}{LogMap}(x, ...)
}
\arguments{
\item{x}{A \code{LogMap} object}

\item{...}{Ignored}
}
\value{
\code{x} with values not present in any
observation removed
}
\description{
Remove any unused values from a \link[=LogMap]{logical map}
}
\examples{
map <- LogMap(letters[1:10])
map[['obs']] <- c(1, 3, 7)
map[['entry']] <- c(2, 7, 10)

# Remove unused values
map <- droplevels(map)
map
map[[]]

}
\seealso{
Logical map objects, validity, and interaction methods:
\code{\link{LogMap-validity}},
\code{\link{LogMap}},
\code{\link{as.matrix.LogMap}()},
\code{\link{intersect.LogMap}()},
\code{\link{labels.LogMap}()}
}
\concept{logmap}
