% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recreg.R
\name{recreg}
\alias{recreg}
\alias{EventCens}
\title{Recurrent events regression with terminal event}
\usage{
recreg(
  formula,
  data = data,
  cause = 1,
  death.code = c(2),
  cens.code = 1,
  cens.model = ~1,
  weights = NULL,
  offset = NULL,
  Gc = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with 'EventCens' outcome}

\item{data}{data frame}

\item{cause}{of interest}

\item{death.code}{codes for death (terminating event)}

\item{cens.code}{code of censoring (1 default)}

\item{cens.model}{for stratified Cox model without covariates}

\item{weights}{weights for score equations}

\item{offset}{offsets for model}

\item{Gc}{censoring weights for time argument, default is to calculate these with a Kaplan-Meier estimator, should then give G_c(T_i-)}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Fits Ghosh-Lin IPCW cox type model
}
\details{
For Cox type model :
\deqn{
E(dN_1(t)|X) = \mu_0(t)ddtt exp(X^T \beta)
}
by solving Cox IPCW weighted score equations 
\deqn{
 \int (Z - E(t)) w(t) dN_1(t) 
}
where \deqn{w(t) = G(t) (I(T_i \wedge t < C_i)/G_c(T_i \wedge t))} and
\deqn{E(t) = S_1(t)/S_0(t)} and \deqn{S_j(t) = \sum X_i^j w_i(t) \exp(X_i^T \beta)}.


The iid decomposition of the beta's are on the form
\deqn{
\int (Z - E ) w(t) dM_1 + \int q(s)/p(s) dM_c
}
and returned as iid.

Events, deaths and censorings are specified via stop start structure and the EventCens  call, that via a status vector 
and cause (code) and death.code(s) indentifies these, a second censoring indicator specifies where the censorings.  See example.
}
\examples{
## data with no ties
data(base1cumhaz)
data(base4cumhaz)
data(drcumhaz)
Lam1 <- base1cumhaz;  Lam2 <- base4cumhaz;  LamD <- drcumhaz
## simulates recurrent events of types 1 and 2 and with terminal event D and censoring
rr <- simRecurrentII(1000,Lam1,cumhaz2=Lam2,death.cumhaz=LamD,cens=3/5000)
rr <- count.history(rr)
rr$cens <- 0
dsort(rr) <- ~id-start
nid <- max(rr$id)
rr$revnr <- cumsumstrata(rep(1,nrow(rr)),rr$id-1,nid)
dsort(rr) <- ~id+start
rr$x <- rnorm(nid)[rr$id]
rr <- dtransform(rr,cens=1,revnr==1 & death==0)
dcut(rr) <- gx~x

rr <- dtransform(rr,statusG=status)
rr <- dtransform(rr,statusG=0,status==2)
rr <- dtransform(rr,statusG=2,death==1)

ll <- recreg(EventCens(start,stop,statusG,cens)~x+cluster(id),data=rr,cause=1)
summary(ll)

## censoring stratified after quartiles of x
lls <- recreg(EventCens(start, stop, statusG, cens) ~ x+cluster(id), data=rr,
              cause=1, cens.model=~strata(gx))
summary(lls)

}
\author{
Thomas Scheike
}
