% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consecutive_mutate_linter.R
\name{consecutive_mutate_linter}
\alias{consecutive_mutate_linter}
\title{Require consecutive calls to mutate() to be combined when possible}
\usage{
consecutive_mutate_linter(invalid_backends = "dbplyr")
}
\arguments{
\item{invalid_backends}{Character vector of packages providing dplyr backends
which may not be compatible with combining \code{mutate()} calls in all cases.
Defaults to \code{"dbplyr"} since not all SQL backends can handle re-using
a variable defined in the same \code{mutate()} expression.}
}
\description{
\code{dplyr::mutate()} accepts any number of columns, so sequences like
\code{DF \%>\% dplyr::mutate(..1) \%>\% dplyr::mutate(..2)} are redundant --
they can always be expressed with a single call to \code{dplyr::mutate()}.
}
\details{
An exception is for some SQL back-ends, where the translation logic may not be
as sophisticated as that in the default \code{dplyr}, for example in
\code{DF \%>\% mutate(a = a + 1) \%>\% mutate(b = a - 2)}.
}
\examples{
# will produce lints
lint(
  text = "x \%>\% mutate(a = 1) \%>\% mutate(b = 2)",
  linters = consecutive_mutate_linter()
)

# okay
lint(
  text = "x \%>\% mutate(a = 1, b = 2)",
  linters = consecutive_mutate_linter()
)

code <- "library(dbplyr)\nx \%>\% mutate(a = 1) \%>\% mutate(a = a + 1)"
writeLines(code)
lint(
  text = code,
  linters = consecutive_mutate_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
