% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_backend.R
\name{backends}
\alias{backends}
\alias{default_backend}
\title{Select the default backend and default keyring}
\usage{
default_backend(keyring = NULL)
}
\arguments{
\item{keyring}{Character string, the name of the keyring to use,
or \code{NULL} for the default keyring.}
}
\value{
The backend object itself.
}
\description{
The default backend is selected
\enumerate{
\item based on the \code{keyring_backend} option. See \code{\link[base:options]{base::options()}}.
This can be set to a character string, and then the
\emph{backend_}\code{string} class is used to create the default backend.
\item If this is not set, then the \code{R_KEYRING_BACKEND} environment variable
is checked.
\item If this is not set, either, then the backend is selected
automatically, based on the OS:
\enumerate{
\item On Windows, the Windows Credential Store (\code{"wincred"}) is used.
\item On macOS, Keychain services are selected (\code{"macos"}).
\item Linux uses the Secret Service API (\code{"secret_service"}),
and it also checks that the service is available. It is typically
only available on systems with a GUI.
\item If the file backend (\code{"file"}) is available, it is selected.
\item On other operating systems, secrets are stored in environment
variables (\code{"env"}).
}
}
}
\details{
Most backends support multiple keyrings. For these the keyring is
selected from:
\enumerate{
\item the supplied \code{keyring} argument (if not \code{NULL}), or
\item the \code{keyring_keyring} option.
\itemize{
\item You can change this by using \code{options(keyring_keyring = "NEWVALUE")}
}
\item If this is not set, the \code{R_KEYRING_KEYRING} environment variable.
\itemize{
\item Change this value with \code{Sys.setenv(R_KEYRING_KEYRING = "NEWVALUE")},
either in your script or in your \code{.Renviron} file.
See \link[base:Startup]{base::Startup} for information about using \code{.Renviron}
}
\item Finally, if neither of these are set, the OS default keyring is used.
\itemize{
\item Usually the keyring is automatically unlocked when the user logs in.
}
}
}
\seealso{
\link{backend_env}, \link{backend_file}, \link{backend_macos},
\link{backend_secret_service}, \link{backend_wincred}
}
