% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{default_signature}
\alias{default_signature}
\alias{default_signature,git_repository-method}
\title{Get the signature}
\usage{
default_signature(repo)

\S4method{default_signature}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository \code{object} to check signature}
}
\value{
S4 class git_signature
}
\description{
Get the signature according to the repository's configuration
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Get the default signature
default_signature(repo)

## Change user
config(repo, user.name="Bob", user.email="bob@example.org")

## Get the default signature
default_signature(repo)
}
}
\keyword{methods}
