% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdendrogram.R
\name{ggdendrogram}
\alias{ggdendrogram}
\title{Creates dendrogram plot using ggplot.}
\usage{
ggdendrogram(
  data,
  segments = TRUE,
  labels = TRUE,
  leaf_labels = TRUE,
  rotate = FALSE,
  theme_dendro = TRUE,
  ...
)
}
\arguments{
\item{data}{Either a dendro object or an object that can be coerced to class
dendro using the \code{\link[=dendro_data]{dendro_data()}} function, i.e. objects of class
dendrogram, hclust or tree}

\item{segments}{If TRUE, show line segments}

\item{labels}{if TRUE, shows segment labels}

\item{leaf_labels}{if TRUE, shows leaf labels}

\item{rotate}{if TRUE, rotates plot by 90 degrees}

\item{theme_dendro}{if TRUE, applies a blank theme to plot (see
\code{\link[=theme_dendro]{theme_dendro()}})}

\item{...}{other parameters passed to \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}}}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
This is a convenience function
}
\examples{
### Demonstrate ggdendrogram

library(ggplot2)
hc <- hclust(dist(USArrests), "ave")

# Demonstrate plotting directly from object class hclust
p <- ggdendrogram(hc, rotate = FALSE)
print(p)
ggdendrogram(hc, rotate = TRUE)

# demonstrate converting hclust to dendro using dendro_data first
hcdata <- dendro_data(hc)
ggdendrogram(hcdata, rotate = TRUE, size = 2) + 
  labs(title = "Dendrogram in ggplot2")
}
\seealso{
\code{\link[=dendro_data]{dendro_data()}}
}
