% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar_spanning_seq}
\alias{calendar_spanning_seq}
\title{Spanning sequence: calendars}
\usage{
calendar_spanning_seq(x)
}
\arguments{
\item{x}{\verb{[clock_calendar]}

A calendar vector.}
}
\value{
A sequence along \verb{[min(x), max(x)]}.
}
\description{
\code{calendar_spanning_seq()} generates a regular sequence along the span of
\code{x}, i.e. along \verb{[min(x), max(x)]}. The sequence is generated at the
precision of \code{x}.

Importantly, sequences can only be generated if the underlying \code{\link[=seq]{seq()}} method
for the calendar in question supports a \code{from} and \code{to} value at the same
precision as \code{x}. For example, you can't compute a day precision spanning
sequence for a \code{\link[=year_month_day]{year_month_day()}} calendar (you can only compute a year
and month one). To create a day precision sequence, you'd have to convert to
a time-point first. See the individual \code{\link[=seq]{seq()}} method documentation to learn
what precisions are allowed.
}
\details{
Missing values are automatically removed before the sequence is generated.

If you need more precise sequence generation, call \code{\link[=range]{range()}} and \code{\link[=seq]{seq()}}
directly.
}
\examples{
x <- year_month_day(c(2019, 2022, 2020), c(2, 5, 3))
x

# Month precision spanning sequence
calendar_spanning_seq(x)

# Quarter precision:
x <- year_quarter_day(c(2005, 2006, 2003), c(4, 2, 3))
calendar_spanning_seq(x)

# Can't generate sequences if `seq()` doesn't allow the precision
x <- year_month_day(2019, c(1, 2, 1), c(20, 3, 25))
try(calendar_spanning_seq(x))

# Generally this means you need to convert to a time point and use
# `time_point_spanning_seq()` instead
time_point_spanning_seq(as_sys_time(x))
}
