% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_tidiers.R
\name{tidy.varFunc}
\alias{tidy.varFunc}
\alias{tidy.varComb}
\title{Tidy variance structure for the \code{nlme} package.}
\usage{
\method{tidy}{varFunc}(x, ...)

\method{tidy}{varComb}(x, ...)
}
\arguments{
\item{x}{An object of class \code{varFunc}, such as those used as the
\code{weights} argument from the \code{nlme} package}

\item{...}{Ignored}
}
\value{
If the \code{varFunc} is uninitialized or has no parameters, the
  function will return an empty tibble.  Otherwise, it will return a tibble with
  names described in the details section.
}
\description{
Returns a tibble with the following columns:
\describe{
\item{group}{type of varFunc, along with the right hand side of the formula
  in parentheses e.g. \code{"varExp(age | Sex)"}.}
\item{term}{terms included in the formula of the variance model, specifically
  the names of the coefficients.  If the value is fixed, it will be appended
  with \code{" ; fixed"}.}
\item{estimate}{estimated coefficient}
\item{estimated}{This column is only included if some parameters are fixed.
  TRUE if the parameter is estimated and FALSE if the parameter is fixed.}
}
}
\examples{
\dontrun{
if (require("nlme")) {
ChickWeight_arbitrary_group <- datasets::ChickWeight
ChickWeight_arbitrary_group$group_arb_n <-
  1 + (
    as.integer(ChickWeight_arbitrary_group$Chick) >
    median(as.integer(ChickWeight_arbitrary_group$Chick))
  )
ChickWeight_arbitrary_group$group_arb <- c("low", "high")[ChickWeight_arbitrary_group$group_arb_n]

fit_with_fixed <-
  lme(
    weight ~ Diet * Time,
    random = ~Time | Chick,
    data =ChickWeight_arbitrary_group,
    weights=varIdent(fixed=c("low"=5), form=~1|group_arb)
  )
# Show all parameters
tidy(fit_with_fixed)
# Exclude fixed parameters
tidy(fit_with_fixed) \%>\%
  filter(across(any_of("estimated"), ~.x))
}
}
}
