"""
.. codeauthor:: Tsuyoshi Hombashi <tsuyoshi.hombashi@gmail.com>
"""

import typepy.type

from .__version__ import __author__, __copyright__, __email__, __license__, __version__
from ._const import ParamKey, StrictLevel
from ._function import (
    extract_typepy_from_dtype,
    is_empty_sequence,
    is_hex,
    is_not_empty_sequence,
    is_not_null_string,
    is_null_string,
)
from ._typecode import Typecode
from .error import TypeConversionError
from .type import (
    Binary,
    Bool,
    Bytes,
    DateTime,
    Dictionary,
    Infinity,
    Integer,
    IpAddress,
    List,
    Nan,
    NoneType,
    NullString,
    RealNumber,
    String,
)


__all__ = (
    "ParamKey",
    "StrictLevel",
    "Typecode",
    "TypeConversionError",
    "Binary",
    "Bool",
    "Bytes",
    "DateTime",
    "Dictionary",
    "Infinity",
    "Integer",
    "IpAddress",
    "List",
    "Nan",
    "NoneType",
    "NullString",
    "RealNumber",
    "String",
    "extract_typepy_from_dtype",
    "is_empty_sequence",
    "is_hex",
    "is_not_empty_sequence",
    "is_not_null_string",
    "is_null_string",
    "typepy",
)
