#
# PySNMP MIB module ARC-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/ARC-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:06:06 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ResourceId, ) = mibBuilder.importSymbols("ALARM-MIB", "ResourceId")
( ObjectIdentifier, OctetString, Integer, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, ValueRangeConstraint, SingleValueConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "ValueRangeConstraint", "SingleValueConstraint", "ValueSizeConstraint")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( mib_2, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, iso, Counter64, Bits, ModuleIdentity, Unsigned32, Counter32, TimeTicks, NotificationType, MibIdentifier, IpAddress, Gauge32, Integer32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "mib-2", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "Counter64", "Bits", "ModuleIdentity", "Unsigned32", "Counter32", "TimeTicks", "NotificationType", "MibIdentifier", "IpAddress", "Gauge32", "Integer32")
( StorageType, TextualConvention, DisplayString, RowStatus, ) = mibBuilder.importSymbols("SNMPv2-TC", "StorageType", "TextualConvention", "DisplayString", "RowStatus")
arcMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 117)).setRevisions(("2004-09-09 00:00",))
if mibBuilder.loadTexts: arcMibModule.setLastUpdated('200409090000Z')
if mibBuilder.loadTexts: arcMibModule.setOrganization('IETF Distributed Management Working Group')
if mibBuilder.loadTexts: arcMibModule.setContactInfo('WG EMail:  disman@ietf.org\n              Subscribe: disman-request@ietf.org\n              http://www.ietf.org/html.charters/disman-charter.html\n\n        Chair:     Randy Presuhn\n                   E-mail: randy_presuhn@mindspring.com\n\n        Editor:    Hing-Kam Lam\n                   Lucent Technologies, 4C-616\n                   101 Crawfords Corner Road\n\n                   Holmdel, NJ 07733\n                   USA\n                   Tel: +1 732 949 8338\n                   E-mail: hklam@lucent.com')
if mibBuilder.loadTexts: arcMibModule.setDescription('The MIB module describes the objects for controlling a resource\n     in reporting alarm conditions that it detects.\n\n     Copyright (C) The Internet Society (2004).  This version\n     of this MIB module is part of RFC 3878;  see the RFC\n     itself for full legal notices.')
class IANAItuProbableCauseOrZero(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

arcTimeIntervals = MibIdentifier((1, 3, 6, 1, 2, 1, 117, 1))
arcObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 117, 2))
arcTITimeInterval = MibScalar((1, 3, 6, 1, 2, 1, 117, 1, 1), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: arcTITimeInterval.setDescription('This variable indicates the time interval used for the nalmTI\n     state, in units of second.  It is a pre-defined length of time\n     in which the resource will stay in the nalmTI state before\n     transition into the alm state.\n\n     Instances of this object SHOULD persist across agent restarts.')
arcCDTimeInterval = MibScalar((1, 3, 6, 1, 2, 1, 117, 1, 2), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: arcCDTimeInterval.setDescription('This variable indicates the time interval used for the nalmQICD\n     state, in units of second.  It is a pre-defined length of time\n     in which the resource will stay in the nalmQICD state before\n     transition into the alm state after it is problem-free.\n\n     Instances of this object SHOULD persist across agent restarts.')
arcTable = MibTable((1, 3, 6, 1, 2, 1, 117, 2, 1), )
if mibBuilder.loadTexts: arcTable.setDescription("A table of Alarm Reporting Control (ARC) settings on the system.\n\n     Alarm Reporting Control is a feature that provides an automatic\n     in-service provisioning capability.  Alarm reporting is turned\n     off on a per-resource basis for a selective set of potential\n     alarm conditions to allow sufficient time for customer testing\n     and other maintenance activities in an 'alarm free' state.\n     Once a resource is ready for service, alarm reporting is\n     automatically or manually turned on.\n\n     Functional description and requirements of Alarm Reporting\n     Control are defined in ITU-T Recommendation M.3100 Amendment 3\n     [M.3100 Amd3].")
arcEntry = MibTableRow((1, 3, 6, 1, 2, 1, 117, 2, 1, 1), ).setIndexNames((0, "ARC-MIB", "arcIndex"), (0, "ARC-MIB", "arcAlarmType"), (0, "ARC-MIB", "arcNotificationId"))
if mibBuilder.loadTexts: arcEntry.setDescription('A conceptual row that contains information about an ARC setting\n     of a resource in the system.\n\n     Implementation need to be aware that if the total size of\n     arcIndex and arcNotificationId exceeds 114 sub-IDs, then OIDs\n     of column instances in this table will have more than 128\n     sub-IDs and cannot be access using SNMPv1, SNMPv2c, or snmpv3.')
arcIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 117, 2, 1, 1, 1), ResourceId())
if mibBuilder.loadTexts: arcIndex.setDescription("This object uniquely identifies a resource, which is under the\n     arcState's control for the associated arcAlarmType.\n\n     For example, if the resource is an interface, this object will\n     point to an instance of interface, e.g., ifIndex.1.")
arcAlarmType = MibTableColumn((1, 3, 6, 1, 2, 1, 117, 2, 1, 1, 2), IANAItuProbableCauseOrZero())
if mibBuilder.loadTexts: arcAlarmType.setDescription('This object identifies the alarm condition type controlled by the\n     arcState.  It specifies the value 0 or a value of\n     IANAItuProbableCause that is applicable to the resource.\n     IANAItuProbableCause is defined in the IANA-ITU-ALARM-TC\n     module in the Alarm MIB document.\n\n\n     The value of zero (0) implies any probable causes that are\n     applicable to the resource.  Usually, the applicable probable\n     causes of a resource are specified in the resource-specific mib.')
arcNotificationId = MibTableColumn((1, 3, 6, 1, 2, 1, 117, 2, 1, 1, 3), ObjectIdentifier())
if mibBuilder.loadTexts: arcNotificationId.setDescription('This object identifies the type of notification to be suppressed.\n     The notification type identified should be the one normally used\n     by the resource for reporting its alarms.  When the value of 0.0 is\n     specified for this object, it implies all applicable notification\n     types.')
arcState = MibTableColumn((1, 3, 6, 1, 2, 1, 117, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("nalm", 1), ("nalmQI", 2), ("nalmTI", 3), ("nalmQICD", 4),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: arcState.setDescription("Defined in M.3100 Amendment 3 [M.3100 Amd3], there are five\n     ARC states: alm, nalm, nalmQI, nalmQICD, and nalmTI.\n\n        alm:        Alarm reporting is turned on (i.e., is allowed).\n        nalm:       Alarm reporting is turned off (i.e., not allowed).\n        nalmQI:     nalm - Qualified Inhibit. Alarm reporting is\n                    turned off until the managed entity is qualified\n                    problem-free for an optional persistence interval.\n                    Problem-free means that the condition corresponding\n                    to the specified alarm type is cleared.\n        nalmQICD:   nalmQI - Count down.  This is a substate of nalmQI\n                    and performs the persistence timing countdown\n                    function after the managed entity is qualified\n                    problem-free.\n        nalmTI:     nalm - Timed Inhibit.  Alarm reporting is turned\n                    off for a specified time interval.\n\n     alm may transition to nalm, nalmQI or nalmTI by management request.\n\n     nalm may transition to alm, nalmQI or nalmTI by management request.\n\n\n     nalmQI may transition to nalm or alm by management request.\n\n     nalmQI may transition to alm automatically\n             if qualified problem-free (if nalmQICD is not supported) or\n             if the CD timer expired (if nalmQICD is supported)\n\n     nalmTI may transition to alm or nalm by management request.\n\n     nalmTI may transition to alm automatically if the TI timer expired.\n\n     Further details of ARC state transitions are defined in Figure 3\n     of M.3100 Amd3 [M.3100 Amd3].\n\n     According to the requirements in M.3100 Amd3, a resource\n     supporting the ARC feature shall support the alm state and at\n     least one of the nalm, nalmTI, and nalmQI states. The nalmQICD\n     state is an optional substate of nalmQI.\n\n     The arcState object controls the alarm reporting state of a\n     resource. Note that the state alm (alarm reporting is allowed) is\n     not listed in the enumeration of the value of this object. However,\n     this state is implicitly supported by the mib.\n     Once a resource enters the normal reporting mode (i.e., in the alm\n     state) for the specified alarm type, the corresponding\n     row will be automatically deleted from the arc table.\n     Also the manual setting of arcState to alm can be achieved through\n     setting the RowStatus object to 'destroy'.\n\n     The nalamQICD state is a transitional state from nalmQI to alm. It\n     is optional depending on the resource type and the implementation\n     of the resource.  If it is supported, before the state\n     transitions from nalmQI to alm, a count down period is activated\n     for a duration set by the object arcNalmCDTimeInterval.  When the\n     time is up, the arcState transitions to alm.")
arcNalmTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 117, 2, 1, 1, 5), Unsigned32()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: arcNalmTimeRemaining.setDescription('This variable indicates the time remaining in the nalmTI state\n     or the nalmQICD state, in units of second.\n\n     At the moment the resource enters the nalmTI state, this variable\n     will have the initial value equal to the value of\n\n     arcNalmTITimeInterval and then starts decrementing as time goes by.\n\n     Similarly at the moment the resource enters the nalmQICD state,\n     this variable will have the initial value equal to the value of\n     arcNalmCDTimeInterval and then starts decrementing as time goes by.\n\n     This variable is read-create and thus will allow the manager to\n     write (extend or shorten), as needed, the remaining time when the\n     resource is in the nalmTI or nalmQICD state.\n\n     If this variable is supported and the resource is currently not in\n     the nalmTI nor nalmQICD state, the value of this variable shall\n     equal to zero.')
arcRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 117, 2, 1, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: arcRowStatus.setDescription('This columnar object is used for creating and deleting a conceptual\n     row of the arcTable.  It is used to create and delete an arc\n     setting.\n\n     Setting RowStatus to createAndGo or createAndWait implies creating\n     a new ARC setting for the specified resource and alarm type.\n     Setting RowStatus to destroy implies removing the ARC setting and\n     thus has the effect of resuming normal reporting behaviour of the\n     resource for the alarm type.\n\n     Only the objects arcState, arcNalmTimeRemaining, and arcRowStatus\n     can be updated when a row is active. All the objects, except\n     arcNalmTimeRemaining, must be set before the row can be activated.')
arcStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 117, 2, 1, 1, 7), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: arcStorageType.setDescription("The storage type for this conceptual row.\n     Conceptual rows having the value 'permanent' must\n     allow write-access at a minimum to arcState.\n     Note that arcState must allow change by management request.\n     Therefore, no row can be created with 'readOnly'.\n     If a set operation tries to set the value to 'readOnly',\n     then an 'inconsistentValue' error must be returned.")
arcConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 117, 3))
arcCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 117, 3, 1))
arcCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 117, 3, 1, 1)).setObjects(*(("ARC-MIB", "arcSettingGroup"),))
if mibBuilder.loadTexts: arcCompliance.setDescription('The compliance statement for systems supporting\n       the ARC MIB module.')
arcGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 117, 3, 2))
arcSettingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 117, 3, 2, 1)).setObjects(*(("ARC-MIB", "arcState"), ("ARC-MIB", "arcRowStatus"), ("ARC-MIB", "arcStorageType"),))
if mibBuilder.loadTexts: arcSettingGroup.setDescription('A collection of objects applicable to\n      basic ARC setting.')
arcTIGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 117, 3, 2, 2)).setObjects(*(("ARC-MIB", "arcTITimeInterval"), ("ARC-MIB", "arcNalmTimeRemaining"),))
if mibBuilder.loadTexts: arcTIGroup.setDescription('A collection of objects applicable to\n      ARC setting that support the Time Inhibit (TI)\n      function.')
arcQICDGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 117, 3, 2, 3)).setObjects(*(("ARC-MIB", "arcCDTimeInterval"), ("ARC-MIB", "arcNalmTimeRemaining"),))
if mibBuilder.loadTexts: arcQICDGroup.setDescription('A collection of objects applicable to\n     ARC setting that support the Quality Inhibit (QI)\n     Count Down (CD) function.')
mibBuilder.exportSymbols("ARC-MIB", arcGroups=arcGroups, arcSettingGroup=arcSettingGroup, arcNotificationId=arcNotificationId, arcNalmTimeRemaining=arcNalmTimeRemaining, arcState=arcState, arcAlarmType=arcAlarmType, arcTimeIntervals=arcTimeIntervals, arcConformance=arcConformance, arcTable=arcTable, arcTIGroup=arcTIGroup, arcCDTimeInterval=arcCDTimeInterval, IANAItuProbableCauseOrZero=IANAItuProbableCauseOrZero, arcRowStatus=arcRowStatus, arcCompliances=arcCompliances, arcQICDGroup=arcQICDGroup, arcStorageType=arcStorageType, PYSNMP_MODULE_ID=arcMibModule, arcObjects=arcObjects, arcCompliance=arcCompliance, arcIndex=arcIndex, arcTITimeInterval=arcTITimeInterval, arcMibModule=arcMibModule, arcEntry=arcEntry)
