%{
/* Lex analyzer for bison grammar */

#include "commands.tab.h"
/*#define DEBUG*/
#include "macro.h"
#include <string.h>
%}

OWNER "<"[a-zA-Z0-9_.+-]+@[a-zA-Z0-9._-]+">"
VAL   ['`"][a-zA-Z0-9@_+.<>() -]+['`"]
VAR   [a-zA-Z0-9_<>-]+[:]?

%option noyywrap

%%




{OWNER}	{
                DBG("OWNER %s\n",yytext);
                yylval.text=yytext;
                return(OWNERID);
        }


{VAL}	{
                DBG("VAL %s\n",yytext);
                yylval.text=yytext;
                return(VALID);
        }

{VAR}	{
		DBG("VAR %s\n",yytext);
		yylval.text=yytext;
		return(VARID);
	}


"{"	|
"}"	|
"="	{
		yylval.text=yytext;
		return(*yytext);
	 }


"#"[^\n]*	|
"\n"		|
[[:space:]]	;	/* comments 'til EOL and strip all spaces and \n */


"."	{
		DBG("NOTSTR %s\n",yytext);
		yylval.text=yytext;
		return(ERROR);
	}


%%

#include "structs.h"

extern struct wlp_list_t *list;

int parse(FILE *file)
{
	struct wlp_node_t *tmp;
	int count;
	yyin=file;

	DBG("go!\n");
	yyparse();
	DBG("EOF found\n");
}
