/*
 * Copyright © 2022 Soren Stoutner <soren@stoutner.com>.
 *
 * This file is part of Privacy Browser PC <https://www.stoutner.com/privacy-browser-pc>.
 *
 * Privacy Browser PC is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Privacy Browser PC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Privacy Browser PC.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DOMAINSETTINGSDIALOG_H
#define DOMAINSETTINGSDIALOG_H

// Application headers.
#include "helpers/UserAgentHelper.h"

// KDE Frameworks headers.
#include <KLineEdit>

// Qt toolkit headers.
#include <QDialog>
#include <QDoubleSpinBox>
#include <QLabel>
#include <QtSql>

class DomainSettingsDialog : public QDialog
{
    // Include the Q_OBJECT macro.
    Q_OBJECT

public:
    // The primary constructor.
    explicit DomainSettingsDialog(const int &startType = SHOW_ALL_DOMAINS, const QString &domainName = QStringLiteral(""));

    // The public static int constants.
    static const int SHOW_ALL_DOMAINS;
    static const int ADD_DOMAIN;
    static const int EDIT_DOMAIN;

signals:
    void domainSettingsUpdated() const;

private Q_SLOTS:
    // The private slots.
    void apply() const;
    void cancel();
    void customZoomFactorChanged(const double &newValue) const;
    void domStorageChanged(const int &newIndex) const;
    void domainNameChanged(const QString &updatedDomainName) const;
    void domainSelected(const QModelIndex &modelIndex) const;
    void javaScriptChanged(const int &newIndex) const;
    void localStorageChanged(const int &newIndex) const;
    void ok();
    void reset() const;
    void showAddMessageBox();
    void showDeleteMessageBox() const;
    void userAgentChanged(const QString &updatedUserAgent) const;
    void zoomFactorComboBoxChanged(const int &newIndex) const;

private:
    // The private variables.
    QPushButton *applyButtonPointer;
    QDoubleSpinBox *customZoomFactorSpinBoxPointer;
    QPalette defaultPalette;
    QPushButton *deleteDomainButtonPointer;
    QWidget *domStorageWidgetPointer;
    QComboBox *domStorageComboBoxPointer;
    QLabel *domStorageLabelPointer;
    KLineEdit *domainNameLineEditPointer;
    QWidget *domainSettingsWidgetPointer;
    QListView *domainsListViewPointer;
    QSqlTableModel *domainsTableModelPointer;
    QItemSelectionModel *domainsSelectionModelPointer;
    QPalette highlightedPalette;
    QWidget *javaScriptWidgetPointer;
    QComboBox *javaScriptComboBoxPointer;
    QLabel *javaScriptLabelPointer;
    QWidget *localStorageWidgetPointer;
    QComboBox *localStorageComboBoxPointer;
    QLabel *localStorageLabelPointer;
    QPushButton *resetButtonPointer;
    QWidget *userAgentWidgetPointer;
    QComboBox *userAgentComboBoxPointer;
    UserAgentHelper *userAgentHelperPointer;
    QLabel *userAgentLabelPointer;
    QWidget *zoomFactorWidgetPointer;
    QComboBox *zoomFactorComboBoxPointer;

    // The private functions.
    void addDomain(const QString &domainName) const;
    void populateDomStorageLabel() const;
    void populateJavaScriptLabel() const;
    void populateLocalStorageLabel() const;
    void populateUserAgentLabel(const QString &userAgentName) const;
    void updateUi() const;
};
#endif
