/***************************************************************************
 *   Copyright (C) 2008 by Mark Jaroski <mark@geekhive.net>      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

// Here we avoid loading the header multiple times
#ifndef WiFi_Signal_HEADER
#define WiFi_Signal_HEADER
// We need the Plasma Applet headers
#include <KIcon>
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <QTimer>

#define DRAW_LABEL_SIZE_LIMIT 65
 
class QSizeF;
class QTimer;
class KDialog;
 
class Plasma_WiFi_Signal_Strength : public Plasma::Applet
{

    Q_OBJECT
    public:
        // Basic Create/Destroy
        Plasma_WiFi_Signal_Strength(QObject *parent, const QVariantList &args);
        ~Plasma_WiFi_Signal_Strength();

        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
        void init();
        QSizeF contentSizeHint() const;
        Qt::Orientations expandingDirections() const;

    public slots:
        void refresh();
        void collectData();

    private:
        KDialog *m_dialog;
        QTimer *m_timer;
        QColor m_boxColor;
        QColor m_textColor;
        int m_boxAlpha;
        QFont m_font;
        int m_signal_strength;
        void paintLabel(QPainter*, const QRect&, const QString&);
        void paintAntenna(QPainter *p, const QRect &contentsRect);

};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(plasma_applet_wifi_signal, Plasma_WiFi_Signal_Strength)
#endif 
