/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __ARBREIDENTIFIANT__
#define __ARBREIDENTIFIANT__

#include <src/messages/messages/compilateur/global.h>

typedef struct maillonidentifiant MaillonIdentifiant;

typedef MaillonIdentifiant* ArbreIdentifiant;
/* Arbre binaire de recherche comprenant diffrents
 * identifiants dans l'ordre alphabtique, et uniques.
 */

struct maillonidentifiant
{
	ArbreIdentifiant inferieur;
	//arbre des infrieurs.
	Chaine identifiant;
	//un identifiant.
	Chaine detection;
	//chaine de detection
	ArbreIdentifiant superieur;
	//arbre des suprieurs.
};
/* Maillon acceuillant un identifiant de l'arbre.
 */

Resultat arbreidentifiant_initialisation(ArbreIdentifiant *arbreidentifiant);
/* Cre un arbreidentifiant.
 */

Resultat arbreidentifiant_ajout_identifiant(ArbreIdentifiant *arbreidentifiant , Chaine identifiant , Chaine detection);
/* Ajoute un identifiant que s'il ne s'y trouve pas dj.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat arbreidentifiant_vide(ArbreIdentifiant *arbreidentifiant , Booleen *vide);
/* Renvoie VRAI si l'arbre est vide.
 */

Resultat arbreidentifiant_retrait_identifiant(ArbreIdentifiant *arbreidentifiant , Chaine *identifiant , Chaine *detection);
/* Retire le plus petit lment de l'arbre.
 * Renvoie RESULTAT_ERREUR_NONTROUVE si l'arbre est vide.
 */

Resultat arbreidentifiant_copie(ArbreIdentifiant *arbreidentifiant , ArbreIdentifiant *copie);
/* Effectue une copie non intelligente de l'arbre.
 * Il faut liberer la copie avant la copie !
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat arbreidentifiant_destruction(ArbreIdentifiant *arbreidentifiant);
/* Dtruit un arbreidentifiant.
 */

#endif
