/*	Database_test

PIRL CVS ID: Database_test.java,v 1.11 2012/04/16 06:08:57 castalia Exp

Unit tests for the PIRL.Database.Database class.


Copyright (C) 2003-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import PIRL.Database.*;
import PIRL.Configuration.*;

import java.util.Vector;
import java.util.Iterator;


public class Database_test
{
private static String
	CONFIG_FILENAME		= "Database.conf",
	TEST_CATALOG		= "test",
	ALT_TEST_CATALOG	= "TEST_CATALOG",
	TEST_TABLE			= "TEST_TABLE",
	NEW_TEST_TABLE		= "NEW_" + TEST_TABLE;


public static void main (String[] args) 
{
System.out.println
	("*** Database_test ***\n"
	+"    " + Database.ID + "\n");

String
	config_filename = null,
	server_name = null;
boolean
	new_catalog = false,
	keep_tables = false,
	show_SQL = false;

for (int
		count = 0;
		count < args.length;
		count++)
	{
	if (args[count].length () > 1 &&
		args[count].charAt (0) == '-')
		{
		switch (args[count].toUpperCase ().charAt (1))
			{
			case 'C':	//	Catalog create/delete.
				if (args[count].length () > 2 &&
					args[count].toUpperCase ().charAt (2) == 'O')
					{
					//	Config filename.
					if (++count == args.length ||
						args[count].length () == 0 ||
						args[count].charAt (0) == '-')
						{
						System.out.println ("Missing configuration filename");
						Usage ();
						}
					if (config_filename != null)
						{
						System.out.println ("Multiple configuration files -\n"
							+ config_filename + '\n'
							+ "and" + '\n'
							+ args[count]);
						Usage ();
						}
					config_filename = args[count];
					}
				else
					//	Catalog create/delete.
					new_catalog = true;
				break;

			case 'S':
				if (args[count].toUpperCase ().equals ("-SQL"))
					{
					//	SQL statements.
					show_SQL = true;
					break;
					}

				//	Server name.
				if (++count == args.length ||
					args[count].length () == 0 ||
					args[count].charAt (0) == '-')
					{
					System.out.println ("Missing server name");
					Usage ();
					}
				if (server_name != null)
					{
					System.out.println ("Multiple server names -\n"
						+ server_name + '\n'
						+ "and" + '\n'
						+ args[count]);
					Usage ();
					}
				server_name = args[count];
				break;

			case 'K':	//	Keep tables.
				keep_tables = true;
				break;

			default:
				System.out.println ("Unknown option: " + args[count]);
			case 'H':	//	Help.
				Usage ();
			}
		}
	else
		{
		System.out.println ("Unknown command line argument: " + args[count]);
		Usage ();
		}
	}

if (config_filename == null)
	config_filename = CONFIG_FILENAME;

if (new_catalog)
	TEST_CATALOG = ALT_TEST_CATALOG;

try
{
//	Create a new Configuration.
Configuration
	configuration = new Configuration (config_filename),
	config = new Configuration (configuration);
config.Case_Sensitive (false);
config.Set_All ("password", "*****");
System.out.println (config.Description ());
	
//	Create a new Database.
Database
	database = new Database (configuration);
	
//	Connect to it.
System.out.println ("--- database.Connect ();");
database.Connect (server_name);

//	Database description.
System.out.println ("--- database.Description ();");
System.out.println (database.Description () + "\n");

if (show_SQL)
	{
	System.out.println ("--- database.Add_SQL_Listener (listner);");
	database.Add_SQL_Listener (new SQL_Statements ());
	}

System.out.println ("--- database.Catalogs ();");
System.out.println ("    Catalogs: " + database.Catalogs ());

if (new_catalog)
	{
	//	Remove the existing catalog.
	System.out.println ("--- database.Delete (\"" + TEST_CATALOG + "\");");
	database.Delete (TEST_CATALOG);

	//	Create a new catalog.
	System.out.println ("--- database.Create (\"" + TEST_CATALOG + "\");");
	database.Create (TEST_CATALOG);

	System.out.println ("--- database.Catalogs ();");
	System.out.println ("    Catalogs: " + database.Catalogs ());
	}

//	Set the default catalog and table in the configuration.
System.out.println ("--- Default " + Database.CATALOG
	+ " set to \"" + TEST_CATALOG + "\" in the Database Configuration.");
database.Data_Port ().Configuration ().Set
	(Database.CATALOG, TEST_CATALOG);
System.out.println ("--- Default " + Database.TABLE
	+ " set to \"" + TEST_TABLE + "\" in the Database Configuration.");
database.Data_Port ().Configuration ().Set
	(Database.TABLE, TEST_TABLE);

//	Remove the existing tables.
System.out.println ("--- database.Delete (\"" + TEST_TABLE
	+ "\", (Vector)null);");
try {database.Delete (TEST_TABLE, (Vector)null);}
catch (Database_Exception exception)
	{
	System.out.println ("    Delete failed (table does not exist?)");
	}
System.out.println ("--- database.Delete (\"" + NEW_TEST_TABLE
	+ "\", (Vector)null);");
try {database.Delete (NEW_TEST_TABLE, (Vector)null);}
catch (Database_Exception exception)
	{
	System.out.println ("    Delete failed (table does not exist?)");
	}

//	Create a new table.
Vector
	fields = new Vector (),
	types = new Vector ();
fields.add ("ID");
types.add ("SERIAL"
	+ " Not NULL"
	+ " Primary Key");
fields.add ("Name");
types.add ("VARCHAR(64)");
fields.add ("Value");
types.add ("FLOAT");
System.out.println ("--- database.Create (\""
	+ TEST_TABLE + "\", \"" + fields + "\", \"" + types + "\");");
database.Create (TEST_TABLE, fields, types);
System.out.println ("    Catalogs: " + database.Catalogs ());
System.out.println ("    Tables in \"" + TEST_CATALOG + "\": "
	+ database.Tables (TEST_CATALOG));

//	Insert data into the table.
Vector 
	insert_fields = new Vector (fields);
//	Don't include the auto-increment field.
insert_fields.remove (0);
Vector
	values = new Vector (insert_fields.size ());
values.add ("");
values.add ("");
for (int count = 0;
	     count < 10;
		 count++)
	{
	values.set (0, "Name_" + count);
	values.set (1, new Float ((float)count + ((float)count / 10) + .01));
	System.out.println ("--- database.Insert (\""
		+ TEST_TABLE + "\", \"" + insert_fields + "\", \"" + values + "\");");
	database.Insert (TEST_TABLE, insert_fields, values);
	}

//	Describe the table contents.
System.out.println ("--- database.Contents (\""
	+ TEST_CATALOG + "\", \"" + TEST_TABLE + "\");");
System.out.println (database.Contents (TEST_CATALOG, TEST_TABLE));

System.out.println ("--- database.Keys (\"" + TEST_TABLE + "\");");
System.out.println (database.Keys (TEST_TABLE));

//	Select the entire table.
System.out.println ("--- database.Select ();");
Print_Table (database.Select ());

//	Rename the table.
System.out.println ("--- database.Rename (\""
	+ TEST_TABLE + "\", \"" + NEW_TEST_TABLE + "\");");
database.Rename (TEST_TABLE, NEW_TEST_TABLE);
System.out.println ("    Tables in \"" + TEST_CATALOG + "\": "
	+ database.Tables (TEST_CATALOG));

//	Recreate the original table.
System.out.println ("--- database.Create (\""
	+ TEST_TABLE + "\", \"" + fields + "\", \"" + types + "\");");
database.Create (TEST_TABLE, fields, types);
System.out.println ("    Tables in \"" + TEST_CATALOG + "\": "
	+ database.Tables (TEST_CATALOG));

//	Copy the data.
System.out.println ("--- database.Insert (\""
	+ TEST_TABLE + "\", database.Select (\"" + NEW_TEST_TABLE + "\"));");
System.out.println ("    "
	+ database.Insert (TEST_TABLE, database.Select (NEW_TEST_TABLE))
	+ " records inserted.");

//	Select the entire table.
System.out.println ("--- database.Select ();");
Print_Table (database.Select ());

//	Delete a selected record.
System.out.println ("--- database.Delete (\""
	+ TEST_TABLE + "\", \"Name='Name_6'\");");
System.out.println ("    "
	+ database.Delete (TEST_TABLE, "Name='Name_6'")
	+ " record deleted.");
Print_Table (database.Select ());

//	Add new fields.
fields.clear ();
types.clear ();
fields.add ("Switch");
types.add ("VARCHAR(20) DEFAULT 'OFF' Not NULL");
fields.add ("Last");
types.add ("TIMESTAMP");
System.out.println ("--- database.Create (\""
	+ TEST_TABLE + "\", \"" + fields + "\", \"" + types + "\");");
database.Create (TEST_TABLE, fields, types);
Print_Table (database.Select ());

//	Update selected records.
fields.clear ();
values.clear ();
fields.add ("Name");
values.add ("MOD");
fields.add ("Value");
values.add ("3.1459");
System.out.println ("--- database.Update (\""
	+ TEST_TABLE + "\", \"" + fields + "\", \"" + values
	+ "\", \"ID>4 AND ID<8\");");
System.out.println ("    "
	+ database.Update (TEST_TABLE, fields, values, "ID>4 AND ID<8")
	+ " records updated.");
Print_Table (database.Select ());

//	Delete a field.
fields.clear ();
fields.add ("Switch");
System.out.println ("--- database.Delete (\""
	+ TEST_TABLE + "\", \"" + fields + "\");");
database.Delete (TEST_TABLE, fields);
Print_Table (database.Select ());

if (! keep_tables)
	{
	//	Delete the tables.
	System.out.println ("--- database.Delete (\""
		+ TEST_TABLE + "\", (Vector)null);");
	database.Delete (TEST_TABLE, (Vector)null);
	System.out.println ("--- database.Delete (\"" + NEW_TEST_TABLE 
		+ "\", (Vector)null);");
	database.Delete (NEW_TEST_TABLE, (Vector)null);
	System.out.println ("    Tables in \"" + TEST_CATALOG + "\": "
		+ database.Tables (TEST_CATALOG));

	if (new_catalog)
		{
		//	Delete the catalog.
		System.out.println ("--- database.Delete (\""
			+ TEST_CATALOG + "\");");
		database.Delete (TEST_CATALOG);
		System.out.println ("    Catalogs: " + database.Catalogs ());
		}
	}

//	Disconnect.
System.out.println ("--- database.Disconnect ();");
database.Disconnect ();
}

catch (Exception exception)
	{
	System.out.println (exception.getMessage () + "\n");
	System.exit (2);
	}

System.exit (0);
}


public static void Print_Table
	(
	Vector	table
	)
{
Iterator
	table_list = table.iterator ();
while (table_list.hasNext ())
	System.out.println (table_list.next ());
System.out.println ();
}


public static class SQL_Statements
	implements SQL_Listener
{
public void SQL_Statement
	(
	String	SQL
	)
{System.out.println (SQL);}
}


public static void Usage ()
{
System.out.println
	("Usage: Database_test [<options>]\n"
	+"  Options -\n"
	+"  -Catalog\n"
	+"    Create and delete a \"" + ALT_TEST_CATALOG + "\" catalog.\n"
	+"    Default: Use an existing \"" + TEST_CATALOG + "\" catalog.\n"
	+"  -Keep\n"
	+"    Default: Delete the \"" + TEST_TABLE
			+ "\" and \"" + NEW_TEST_TABLE + "\" tables after use.\n"
	+"  -COnfig_file <filename>\n"
	+"    Default: " + CONFIG_FILENAME + '\n'
	+"  -Server <name>\n"
	+"    Default: First Server in the config file.\n"
	+"  -Help\n");
System.exit (1);
}


}
