/*	Sources_Table_Model

PIRL CVS ID: Sources_Table_Model.java,v 1.4 2012/04/16 06:04:10 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Conductor;

import	javax.swing.table.DefaultTableModel;
import	java.util.Vector;


/**	A <i>Sources_Table_Model<i> contains a table of Conductor Source records.
<p>
	@author		Bradford Castalia, UA/PIRL
	@version	1.4
*/
public class Sources_Table_Model
	extends DefaultTableModel
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Conductor..Sources_Table_Model (1.4 2012/04/16 06:04:10)";


public boolean
	Editable		= false;

public int
	Current_Row		= -1;


private static final String
	NL				= System.getProperty ("line.separator");

/*==============================================================================
	Constructors
*/
public Sources_Table_Model ()
{}


public Sources_Table_Model
	(
	String[][]	records,
	String[]	field_names
	)
{super (records, field_names);}


public Sources_Table_Model
	(
	String[]	field_names
	)
{super (field_names, 0);}


public Sources_Table_Model
	(
	Vector		records,
	Vector		field_names
	)
{super (records, field_names);}


public Sources_Table_Model
	(
	Vector		field_names
	)
{super (field_names, 0);}

/*==============================================================================
	TableModel
*/
public Class getColumnClass
	(
	int		column
	)
{
if (column >= 0 &&
	column < getColumnCount ())
	return String.class;
return Object.class;
}


public Object getValueAt
	(
	int		row,
	int		column
	)
{
if (row < 0 ||
	row >= getRowCount () ||
	column < 0 ||
	column >= getColumnCount ())
	return null;
return ((Vector)dataVector.get (row)).get (column);
}


public boolean isCellEditable
	(
	int		row,
	int		column
	)
{return Editable;}

/*==============================================================================
	Accessors
*/
public Vector Record
	(
	int		row
	)
{
if (row >= 0 &&
	row < getRowCount ())
	return (Vector)dataVector.get (row);
return null;
}


public Sources_Table_Model Record
	(
	int		row,
	Vector	record
	)
{
if (record == null)
	return this;
if (row < 0 ||
	row > getRowCount ())
	throw new ArrayIndexOutOfBoundsException (ID + NL
		+ "Unable to set the record at row " + row + '.' + NL
		+ "The valid row range is 0 - " + getRowCount () + " inclusive.");
if (record.size () != getColumnCount ())
	throw new ArrayIndexOutOfBoundsException (ID + NL
		+ "Unable to set the record at row " + row + '.' + NL
		+ "The " + record.size () + " element record size does not match the "
			+ getColumnCount () + " column table size.");

if (row == getRowCount ())
	addRow (record);
else
	{
	dataVector.set (row, record);
	fireTableRowsUpdated (row, row);
	}
return this;
}


}
