<?php

abstract class PhutilMarkupEngine extends Phobject {

  /**
   * Set a configuration parameter which the engine can read to customize how
   * the text is marked up. This is a generic interface; consult the
   * documentation for specific rules and blocks for what options are available
   * for configuration.
   *
   * @param   string  Key to set in the configuration dictionary.
   * @param   string  Value to set.
   * @return  this
   */
  abstract public function setConfig($key, $value);

  /**
   * After text has been marked up with @{method:markupText}, you can retrieve
   * any metadata the markup process generated by calling this method. This is
   * a generic interface that allows rules to export extra information about
   * text; consult the documentation for specific rules and blocks to see what
   * metadata may be available in your configuration.
   *
   * @param   string  Key to retrieve from metadata.
   * @param   mixed   Default value to return if the key is not available.
   * @return  mixed   Metadata property, or default value.
   */
  abstract public function getTextMetadata($key, $default = null);

  abstract public function markupText($text);

}
