/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtBaseVarMetaData.h>
#include <DataNode.h>
#include <ImproperUseException.h>

// ****************************************************************************
// Method: avtBaseVarMetaData::avtBaseVarMetaData
//
// Purpose: 
//   Init utility for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtBaseVarMetaData::Init()
{
    name = "scalar";
    meshName = "mesh";
    validVariable = true;
    hideFromGUI = false;

    avtBaseVarMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtBaseVarMetaData::avtBaseVarMetaData
//
// Purpose: 
//   Copy utility for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtBaseVarMetaData::Copy(const avtBaseVarMetaData &obj)
{
    name = obj.name;
    originalName = obj.originalName;
    meshName = obj.meshName;
    validVariable = obj.validVariable;
    hideFromGUI = obj.hideFromGUI;

    avtBaseVarMetaData::SelectAll();
}

// Type map format string
const char *avtBaseVarMetaData::TypeMapFormatString = AVTBASEVARMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtBaseVarMetaData::TmfsStruct = {AVTBASEVARMETADATA_TMFS};


// ****************************************************************************
// Method: avtBaseVarMetaData::avtBaseVarMetaData
//
// Purpose: 
//   Default constructor for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtBaseVarMetaData::avtBaseVarMetaData() : 
    AttributeSubject(avtBaseVarMetaData::TypeMapFormatString)
{
    avtBaseVarMetaData::Init();
}

// ****************************************************************************
// Method: avtBaseVarMetaData::avtBaseVarMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtBaseVarMetaData::avtBaseVarMetaData(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    avtBaseVarMetaData::Init();
}

// ****************************************************************************
// Method: avtBaseVarMetaData::avtBaseVarMetaData
//
// Purpose: 
//   Copy constructor for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtBaseVarMetaData::avtBaseVarMetaData(const avtBaseVarMetaData &obj) : 
    AttributeSubject(avtBaseVarMetaData::TypeMapFormatString)
{
    avtBaseVarMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtBaseVarMetaData::avtBaseVarMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtBaseVarMetaData::avtBaseVarMetaData(const avtBaseVarMetaData &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    avtBaseVarMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtBaseVarMetaData::~avtBaseVarMetaData
//
// Purpose: 
//   Destructor for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtBaseVarMetaData::~avtBaseVarMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtBaseVarMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtBaseVarMetaData& 
avtBaseVarMetaData::operator = (const avtBaseVarMetaData &obj)
{
    if (this == &obj) return *this;

    avtBaseVarMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtBaseVarMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtBaseVarMetaData::operator == (const avtBaseVarMetaData &obj) const
{
    // Create the return value
    return ((name == obj.name) &&
            (originalName == obj.originalName) &&
            (meshName == obj.meshName) &&
            (validVariable == obj.validVariable) &&
            (hideFromGUI == obj.hideFromGUI));
}

// ****************************************************************************
// Method: avtBaseVarMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtBaseVarMetaData::operator != (const avtBaseVarMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtBaseVarMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtBaseVarMetaData::TypeName() const
{
    return "avtBaseVarMetaData";
}

// ****************************************************************************
// Method: avtBaseVarMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtBaseVarMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtBaseVarMetaData *tmp = (const avtBaseVarMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtBaseVarMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtBaseVarMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtBaseVarMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtBaseVarMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtBaseVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtBaseVarMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtBaseVarMetaData(*this);
    else
        retval = new avtBaseVarMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtBaseVarMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtBaseVarMetaData::SelectAll()
{
    Select(ID_name,          (void *)&name);
    Select(ID_originalName,  (void *)&originalName);
    Select(ID_meshName,      (void *)&meshName);
    Select(ID_validVariable, (void *)&validVariable);
    Select(ID_hideFromGUI,   (void *)&hideFromGUI);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtBaseVarMetaData::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtBaseVarMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_name:          return "name";
    case ID_originalName:  return "originalName";
    case ID_meshName:      return "meshName";
    case ID_validVariable: return "validVariable";
    case ID_hideFromGUI:   return "hideFromGUI";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtBaseVarMetaData::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
avtBaseVarMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_name:          return FieldType_string;
    case ID_originalName:  return FieldType_string;
    case ID_meshName:      return FieldType_string;
    case ID_validVariable: return FieldType_bool;
    case ID_hideFromGUI:   return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: avtBaseVarMetaData::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtBaseVarMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_name:          return "string";
    case ID_originalName:  return "string";
    case ID_meshName:      return "string";
    case ID_validVariable: return "bool";
    case ID_hideFromGUI:   return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtBaseVarMetaData::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtBaseVarMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtBaseVarMetaData &obj = *((const avtBaseVarMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_name:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case ID_originalName:
        {  // new scope
        retval = (originalName == obj.originalName);
        }
        break;
    case ID_meshName:
        {  // new scope
        retval = (meshName == obj.meshName);
        }
        break;
    case ID_validVariable:
        {  // new scope
        retval = (validVariable == obj.validVariable);
        }
        break;
    case ID_hideFromGUI:
        {  // new scope
        retval = (hideFromGUI == obj.hideFromGUI);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtBaseVarMetaData constructor
//
//  Arguments:
//      n           The name of the variable.
//      mn          The name of the mesh the var is defined on.
//      c           The centering of the variable.
//
//  Programmer: Hank Childs
//  Creation:   August 25, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Initialized validVariable.
//
//    Brad Whitlock, Tue Jul 20 13:44:42 PST 2004
//    Added units.
//
//    Kathleen Bonnell, Thu Jul 22 12:10:19 PDT 2004 
//    Initialized treatAsASCII.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Jeremy Meredith, Fri Aug 25 17:16:38 EDT 2006
//    Added enumerated scalars.
//
//    Mark C. Miller, Wed Mar 26 10:11:46 PDT 2008
//    Added initialization for other enumerated scalar options
//    and hideFromGUI.
//
//    Mark C. Miller, Thu Sep 10 09:24:46 PDT 2009
//    Re-designed to serve as base class.
// ****************************************************************************

avtBaseVarMetaData::avtBaseVarMetaData(private_tmfs_t tmfs, std::string n,
    std::string mn) : AttributeSubject(tmfs.tmfs)
{
    avtBaseVarMetaData::Init();
    name = n;
    originalName = n;
    meshName = mn;
}

// ****************************************************************************
//  Method: avtBaseVarMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    August 28, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Print out validVariable.
//
//    Kathleen Bonnell, Thu Jul 22 12:10:19 PDT 2004 
//    Print out treatAsASCII.
//
//    Brad Whitlock, Tue Jul 20 13:47:04 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Jeremy Meredith, Fri Aug 25 17:16:38 EDT 2006
//    Added enumerated scalars.
//
//    Mark C. Miller, Thu Sep 10 09:24:46 PDT 2009
//    Re-designed to serve as base class.
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}

void
avtBaseVarMetaData::Print(ostream &out, int indent) const
{

    Indent(out, indent);
    out << "Name = \"" << name << "\"" << endl;
    if (name != originalName)
    {
        Indent(out, indent);
        out << "Original Name = \"" << originalName << "\"" << endl;
    }

    Indent(out, indent);
    out << "Mesh is = \"" << meshName << "\"" << endl;

    if (!validVariable)
    {
        Indent(out, indent);
        out << "THIS IS NOT A VALID VARIABLE." << endl;
    }

    if (hideFromGUI)
    {
        Indent(out, indent);
        out << "THIS VARIABLE IS TO BE HIDDEN FROM THE GUI." << endl;
    }
}

