///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_BOOLEAN_CONTROLLER_UI_H
#define __OVITO_BOOLEAN_CONTROLLER_UI_H

#include <core/Core.h>
#include "ParameterUI.h"

namespace Core {

/******************************************************************************
* Allows the user to edit a boolean parameter in the properties panel.
******************************************************************************/
class CORE_DLLEXPORT BooleanControllerUI : public ReferenceParameterUI
{
public:

	/// Constructor.
	BooleanControllerUI(PropertiesEditor* parentEditor, const PropertyFieldDescriptor& refField);
	/// Destructor, that releases all GUI controls.
	virtual ~BooleanControllerUI();
    
	/// This returns the checkbox managed by this parameter UI.
	QCheckBox* checkBox() const { return _checkBox; }

	/// This method is called when parameter object has been assigned to the reference field of the editable object 
	/// this parameter UI is bound to. It is also called when the editable object itself has
	/// been replaced in the editor. This implementation of the method automatically
	/// disables the UI widgets when the reference field of the edited object does not contain a
	/// controller.
	virtual void resetUI();
	
	/// This method updates the displayed value of the parameter UI.
	virtual void updateUI();	

	/// Sets the enabled state of the UI.
	virtual void setEnabled(bool enabled);

	/// Sets the tooltip text for the check box.
	void setToolTip(const QString& text) const { if(checkBox()) checkBox()->setToolTip(text); }

	/// Sets the What's This helper text for the check box.
	void setWhatsThis(const QString& text) const { if(checkBox()) checkBox()->setWhatsThis(text); }
	
public:
	
	Q_PROPERTY(QCheckBox checkBox READ checkBox)			
	
public Q_SLOTS:
	
	/// Takes the value entered by the user and stores it in the parameter object
	/// this parameter UI is bound to. This method must be implemented by derived classes.
	void updateParameterValue();

protected:

	/// The checkbox control of the UI component.
	QPointer<QCheckBox> _checkBox;

private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(BooleanControllerUI)
};

};

#endif // __OVITO_BOOLEAN_CONTROLLER_UI_H
