#
# This script was written by Xue Yong Zhi <xueyong@udel.edu>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11429);
 script_bugtraq_id(4028, 4316, 4675, 4827, 668);
 script_cve_id("CAN-1999-1484", "CAN-2002-0228", "CAN-2002-0472");  
 
 script_version("$Revision: 8292 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 name = "Windows Messenger is installed";

 script_name(name);
 
 desc = "
The remote host is using Windows Messenger - an instant messaging software, 
which may not be suitable for a business environment. 

Solution : Uninstall this software
Risk factor : Low";



 script_description(desc);
 
 summary = "Determines if Windows Messenger is installed";

 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2003 Xue Yong Zhi");
 family = "Windows";
 script_family(family);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");


rootfile = registry_get_sz(key:"SOFTWARE\Microsoft\MessengerService", item:"InstallationDirectory");
if(rootfile)
{
 security_note(port:get_kb_item("SMB/transport"));
}

