###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_js_info_disc_vuln_win.nasl 876 2009-01-27 16:30:33Z jan $
#
# Firefox Information Disclosure Vulnerability Jan09 (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900448);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-5913");
  script_bugtraq_id(33276);
  script_name("Firefox Information Disclosure Vulnerability Jan09 (Win)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to information disclosure vulnerability.

  Vulnerability Insight:
  The Web Browser fails to properly enforce the same-origin policy, which leads
  to cross-domain information disclosure.

  Impact: Successful exploitation will let the attacker execute arbitrary
  codes in the context of the web browser and can obtain sensitive information
  of the remote user through the web browser.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Firefox version from 2.0 to 3.0.5 on Windows.

  Fix: Upgrade to Mozilla Firefox version 3.6.3 or later
  For updates refer, http://www.getfirefox.com

  References:
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5913
  http://www.trusteer.com/files/In-session-phishing-advisory-2.pdf

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:N/AC:H/Au:SI/C:N/I:P/A:N)
    CVSS Temporal Score : 1.8
  Risk factor : Low";

  script_description(desc);
  script_summary("Check for the version of Mozilla Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

firefoxVer = get_kb_item("Firefox/Win/Ver");
if(!firefoxVer){
  exit(0);
}

# Grep for firefox version from 2.0 to 3.0.5.
if(version_in_range(version:firefoxVer, test_version:"2.0",
                                        test_version2:"3.0.5")){
  security_warning(0);
}
