# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:036 (python)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63373);
 script_cve_id("CVE-2007-4965", "CVE-2008-1679", "CVE-2008-4864", "CVE-2008-5031", "CVE-2008-2315");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Mandrake Security Advisory MDVSA-2009:036 (python)";
 script_name(name);

 desc = "The remote host is missing an update to python
announced via advisory MDVSA-2009:036.

Multiple integer overflows in imageop.c in the imageop module in
Python 1.5.2 through 2.5.1 allow context-dependent attackers to
break out of the Python VM and execute arbitrary code via large
integer values in certain arguments to the crop function, leading to
a buffer overflow, a different vulnerability than CVE-2007-4965 and
CVE-2008-1679. (CVE-2008-4864)

Multiple integer overflows in Python 2.5.2 and earlier allow
context-dependent attackers to have an unknown impact via vectors
related to the (1) stringobject, (2) unicodeobject, (3) bufferobject,
(4) longobject, (5) tupleobject, (6) stropmodule, (7) gcmodule, and
(8) mmapmodule modules. NOTE: The expandtabs integer overflows in
stringobject and unicodeobject in 2.5.2 are covered by CVE-2008-5031.

Multiple integer overflows in Python 2.2.3 through 2.5.1, and 2.6,
allow context-dependent attackers to have an unknown impact via
a large integer value in the tabsize argument to the expandtabs
method, as implemented by (1) the string_expandtabs function in
Objects/stringobject.c and (2) the unicode_expandtabs function in
Objects/unicodeobject.c. NOTE: this vulnerability reportedly exists
because of an incomplete fix for CVE-2008-2315. (CVE-2008-5031)

The updated Python packages have been patched to correct these issues.

Affected: Corporate 3.0, Multi Network Firewall 2.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:036

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:036 (python)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libpython2.3", rpm:"libpython2.3~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpython2.3-devel", rpm:"libpython2.3-devel~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python", rpm:"python~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-docs", rpm:"python-docs~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64python2.3", rpm:"lib64python2.3~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64python2.3-devel", rpm:"lib64python2.3-devel~2.3.7~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpython2.3", rpm:"libpython2.3~2.3.7~0.2.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpython2.3-devel", rpm:"libpython2.3-devel~2.3.7~0.2.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python", rpm:"python~2.3.7~0.2.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.3.7~0.2.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-docs", rpm:"python-docs~2.3.7~0.2.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.3.7~0.2.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
