###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_yahoo_msg_detect.nasl 6032 2009-12-05 13:01:29Z dec $
#
# Yahoo! Messenger Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801149);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Yahoo! Messenger Version Detection");
  desc = "
  Overview: This script detects the installed version of Yahoo! Messenger
  and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Yahoo! Messenger");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  return exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

path = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Yahoo! Messenger";
ymsgName = registry_get_sz(key:path, item:"DisplayName");

if("Yahoo! Messenger" >< ymsgName)
{
  ymsgVer = registry_get_sz(key:"SOFTWARE\yahoo\pager", item:"ProductVersion");
  if(isnull(ymsgVer))
  {
    ymsgPath = registry_get_sz(key:path, item:"DisplayIcon");
    ymsgPath = ymsgPath - ",-0";

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ymsgPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:ymsgPath);
    ymsgVer = GetVer(share:share, file:file);
  }

  if(ymsgVer){
    set_kb_item(name:"YahooMessenger/Ver", value:ymsgVer);
    security_note(data:"Yahoo! Messenger Version " + ymsgVer +
             " running at location " + ymsgPath + " was detected on the host");
  }
}
