# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 248-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53323);
 script_bugtraq_id(6690, 6689);
 script_cve_id("CVE-2003-0057");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 248-1 (hypermail)";
 script_name(name);

 desc = "The remote host is missing an update to hypermail
announced via advisory DSA 248-1.

Ulf Harnhammar discovered two problems in hypermail, a program to
create HTML archives of mailing lists.

An attacker could craft a long filename for an attachment that would
overflow two buffers when a certain option for interactive use was
given, opening the possibility to inject arbitrary code.  This code
would then be executed under the user id hypermail runs as, mostly as
a local user.  Automatic and silent use of hypermail does not seem to
be affected.

The CGI program mail, which is not installed by the Debian package,
does a reverse look-up of the user's IP number and copies the
resulting hostname into a fixed-size buffer.  A specially crafted DNS
reply could overflow this buffer, opening the program to an exploit.

For the stable distribution (woody) this problem has been fixed in
version 2.1.3-2.0.

For the old stable distribution (potato) this problem has been fixed
in version 2.0b25-1.1.

For the unstable distribution (sid) this problem has been fixed
in version 2.1.6-1.

We recommend that you upgrade your hypermail packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20248-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 248-1 (hypermail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hypermail", ver:"2.0b25-1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hypermail", ver:"2.1.3-2.0", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
