###############################################################################
# OpenVAS Vulnerability Test
# $Id: cutenews_detect.nasl 7198 2010-04-01 09:23:35Z chandra $
#
# CuteNews Detection
#
# Authors:
# Michael Meyer
#
# Updated to detect UTF-8 CuteNews
#  - By Antu Sanadi <santu@secpod.com> On 2009-12-05 #5990
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  This host is running CuteNews, a powerful and easy to use news
  management system that uses flat files to store its database

 See also:
  http://cutephp.com/cutenews/

 Risk factor : None";

if (description)
{
 script_id(100105);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("CuteNews Detection");

 script_description(desc);
 script_summary("Checks for the presence of CuteNews");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/cutenews","/utf-8", "/news", "/", cgi_dirs());

foreach dir (dirs)
{
  url = string(dir, "/index.php");
  req = http_get(item:url, port:port);
  buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if( buf == NULL )continue;
  if(egrep(pattern: "Powered by <a [^>]+>CuteNews", string: buf, icase: TRUE) ||
    egrep(pattern: "Powered by <a [^>]+>UTF-8 CuteNews", string: buf, icase: TRUE))
  {

    if(strlen(dir)>0) {
      install=dir;
     }
     else {
        install=string("/");
     }

     vers = string("unknown");

     ### try to get version
     if(version = eregmatch(string: buf, pattern: "Powered by <a [^>]+>CuteNews v*([0-9.]+)</a>",icase:TRUE))
     {
       if ( !isnull(version[1])) {
         vers=version[1];
       }

       set_kb_item(name: string("www/", port, "/cutenews"), value: string(vers," under ",install));
     }

     else if("<title>UTF-8 CuteNews</title>" >< buf)
     {
       version = eregmatch(string: buf, pattern: "UTF-8 CuteNews (([0-9.]+)([a-z]+)?)", icase:TRUE);
       if(!isnull(version[1])) {
         vers=version[1];
       }

       set_kb_item(name: string("www/", port, "/UTF-8/cutenews"), value: string(vers," under ",install));
     }

     info = string("None\n\nCuteNews Version '");
     info += string(vers);
     info += string("' was detected on the remote host in the following directory(s):\n\n");
     info += string(install, "\n");

     desc = ereg_replace(string:desc, pattern:"None$", replace:info);
     if(report_verbosity > 0) {
         security_note(port:port,data:desc);
     }
   }
}
