ad_page_contract {
    Invoke a callback.

    @author Lars Pind (lars@collaboraid.biz)
    @creation-date 11 September 2003
    @cvs-id $Id: version-callback-invoke.tcl,v 1.5.2.2 2015/09/10 08:21:03 gustafn Exp $
} {
    version_id:naturalnum,notnull    
    type:notnull
}

db_1row package_version_info "select pretty_name, version_name from apm_package_version_info where version_id = :version_id"

set return_url [export_vars -base version-callbacks { version_id }]

# Set default values for type and proc name
set proc_value [apm_get_callback_proc -type $type -version_id $version_id]
set page_title "Invoke Tcl Callback"


set context [list \
                 [list "." "Package Manager"] \
                 [list [export_vars -base "version-view" { version_id }] "$pretty_name $version_name"] \
                 [list $return_url "Tcl Callbacks"] $page_title]

if { [catch $proc_value result] } {
    ns_log Error "Error invoking callback $proc_value: $result\n$::errorInfo"
}



# Local variables:
#    mode: tcl
#    tcl-indent-level: 4
#    indent-tabs-mode: nil
# End:
