/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <stdint.h>

#include "odil/registry.h"

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"
#include "odil/VR.h"
#include "odil/UIDsDictionary.h"

namespace odil
{

namespace registry
{

struct RawElementsDictionaryEntry
{
    uint16_t group;
    uint16_t element;
    char const * name;
    char const * keyword;
    char const * vr;
    char const * vm;
};

ElementsDictionary create_public_dictionary()
{

    RawElementsDictionaryEntry raw_entries[] = {
        { 0x0000, 0x0000,
          "Command Group Length", "CommandGroupLength",  "UL", "1" },
        { 0x0000, 0x0002,
          "Affected SOP Class UID", "AffectedSOPClassUID",  "UI", "1" },
        { 0x0000, 0x0003,
          "Requested SOP Class UID", "RequestedSOPClassUID",  "UI", "1" },
        { 0x0000, 0x0100,
          "Command Field", "CommandField",  "US", "1" },
        { 0x0000, 0x0110,
          "Message ID", "MessageID",  "US", "1" },
        { 0x0000, 0x0120,
          "Message ID Being Responded To", "MessageIDBeingRespondedTo",  "US", "1" },
        { 0x0000, 0x0600,
          "Move Destination", "MoveDestination",  "AE", "1" },
        { 0x0000, 0x0700,
          "Priority", "Priority",  "US", "1" },
        { 0x0000, 0x0800,
          "Command Data Set Type", "CommandDataSetType",  "US", "1" },
        { 0x0000, 0x0900,
          "Status", "Status",  "US", "1" },
        { 0x0000, 0x0901,
          "Offending Element", "OffendingElement",  "AT", "1-n" },
        { 0x0000, 0x0902,
          "Error Comment", "ErrorComment",  "LO", "1" },
        { 0x0000, 0x0903,
          "Error ID", "ErrorID",  "US", "1" },
        { 0x0000, 0x1000,
          "Affected SOP Instance UID", "AffectedSOPInstanceUID",  "UI", "1" },
        { 0x0000, 0x1001,
          "Requested SOP Instance UID", "RequestedSOPInstanceUID",  "UI", "1" },
        { 0x0000, 0x1002,
          "Event Type ID", "EventTypeID",  "US", "1" },
        { 0x0000, 0x1005,
          "Attribute Identifier List", "AttributeIdentifierList",  "AT", "1-n" },
        { 0x0000, 0x1008,
          "Action Type ID", "ActionTypeID",  "US", "1" },
        { 0x0000, 0x1020,
          "Number of Remaining Sub-operations", "NumberOfRemainingSuboperations",  "US", "1" },
        { 0x0000, 0x1021,
          "Number of Completed Sub-operations", "NumberOfCompletedSuboperations",  "US", "1" },
        { 0x0000, 0x1022,
          "Number of Failed Sub-operations", "NumberOfFailedSuboperations",  "US", "1" },
        { 0x0000, 0x1023,
          "Number of Warning Sub-operations", "NumberOfWarningSuboperations",  "US", "1" },
        { 0x0000, 0x1030,
          "Move Originator Application Entity Title", "MoveOriginatorApplicationEntityTitle",  "AE", "1" },
        { 0x0000, 0x1031,
          "Move Originator Message ID", "MoveOriginatorMessageID",  "US", "1" },
        { 0x0002, 0x0000,
          "File Meta Information Group Length", "FileMetaInformationGroupLength",  "UL", "1" },
        { 0x0002, 0x0001,
          "File Meta Information Version", "FileMetaInformationVersion",  "OB", "1" },
        { 0x0002, 0x0002,
          "Media Storage SOP Class UID", "MediaStorageSOPClassUID",  "UI", "1" },
        { 0x0002, 0x0003,
          "Media Storage SOP Instance UID", "MediaStorageSOPInstanceUID",  "UI", "1" },
        { 0x0002, 0x0010,
          "Transfer Syntax UID", "TransferSyntaxUID",  "UI", "1" },
        { 0x0002, 0x0012,
          "Implementation Class UID", "ImplementationClassUID",  "UI", "1" },
        { 0x0002, 0x0013,
          "Implementation Version Name", "ImplementationVersionName",  "SH", "1" },
        { 0x0002, 0x0016,
          "Source Application Entity Title", "SourceApplicationEntityTitle",  "AE", "1" },
        { 0x0002, 0x0017,
          "Sending Application Entity Title", "SendingApplicationEntityTitle",  "AE", "1" },
        { 0x0002, 0x0018,
          "Receiving Application Entity Title", "ReceivingApplicationEntityTitle",  "AE", "1" },
        { 0x0002, 0x0100,
          "Private Information Creator UID", "PrivateInformationCreatorUID",  "UI", "1" },
        { 0x0002, 0x0102,
          "Private Information", "PrivateInformation",  "OB", "1" },
        { 0x0004, 0x1130,
          "File-set ID", "FileSetID",  "CS", "1" },
        { 0x0004, 0x1141,
          "File-set Descriptor File ID", "FileSetDescriptorFileID",  "CS", "1-8" },
        { 0x0004, 0x1142,
          "Specific Character Set of File-set Descriptor File", "SpecificCharacterSetOfFileSetDescriptorFile",  "CS", "1" },
        { 0x0004, 0x1200,
          "Offset of the First Directory Record of the Root Directory Entity", "OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity",  "UL", "1" },
        { 0x0004, 0x1202,
          "Offset of the Last Directory Record of the Root Directory Entity", "OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity",  "UL", "1" },
        { 0x0004, 0x1212,
          "File-set Consistency Flag", "FileSetConsistencyFlag",  "US", "1" },
        { 0x0004, 0x1220,
          "Directory Record Sequence", "DirectoryRecordSequence",  "SQ", "1" },
        { 0x0004, 0x1400,
          "Offset of the Next Directory Record", "OffsetOfTheNextDirectoryRecord",  "UL", "1" },
        { 0x0004, 0x1410,
          "Record In-use Flag", "RecordInUseFlag",  "US", "1" },
        { 0x0004, 0x1420,
          "Offset of Referenced Lower-Level Directory Entity", "OffsetOfReferencedLowerLevelDirectoryEntity",  "UL", "1" },
        { 0x0004, 0x1430,
          "Directory Record Type", "DirectoryRecordType",  "CS", "1" },
        { 0x0004, 0x1432,
          "Private Record UID", "PrivateRecordUID",  "UI", "1" },
        { 0x0004, 0x1500,
          "Referenced File ID", "ReferencedFileID",  "CS", "1-8" },
        { 0x0004, 0x1504,
          "MRDR Directory Record Offset", "MRDRDirectoryRecordOffset",  "UL", "1" },
        { 0x0004, 0x1510,
          "Referenced SOP Class UID in File", "ReferencedSOPClassUIDInFile",  "UI", "1" },
        { 0x0004, 0x1511,
          "Referenced SOP Instance UID in File", "ReferencedSOPInstanceUIDInFile",  "UI", "1" },
        { 0x0004, 0x1512,
          "Referenced Transfer Syntax UID in File", "ReferencedTransferSyntaxUIDInFile",  "UI", "1" },
        { 0x0004, 0x151a,
          "Referenced Related General SOP Class UID in File", "ReferencedRelatedGeneralSOPClassUIDInFile",  "UI", "1-n" },
        { 0x0004, 0x1600,
          "Number of References", "NumberOfReferences",  "UL", "1" },
        { 0x0008, 0x0001,
          "Length to End", "LengthToEnd",  "UL", "1" },
        { 0x0008, 0x0005,
          "Specific Character Set", "SpecificCharacterSet",  "CS", "1-n" },
        { 0x0008, 0x0006,
          "Language Code Sequence", "LanguageCodeSequence",  "SQ", "1" },
        { 0x0008, 0x0008,
          "Image Type", "ImageType",  "CS", "2-n" },
        { 0x0008, 0x0010,
          "Recognition Code", "RecognitionCode",  "SH", "1" },
        { 0x0008, 0x0012,
          "Instance Creation Date", "InstanceCreationDate",  "DA", "1" },
        { 0x0008, 0x0013,
          "Instance Creation Time", "InstanceCreationTime",  "TM", "1" },
        { 0x0008, 0x0014,
          "Instance Creator UID", "InstanceCreatorUID",  "UI", "1" },
        { 0x0008, 0x0015,
          "Instance Coercion DateTime", "InstanceCoercionDateTime",  "DT", "1" },
        { 0x0008, 0x0016,
          "SOP Class UID", "SOPClassUID",  "UI", "1" },
        { 0x0008, 0x0018,
          "SOP Instance UID", "SOPInstanceUID",  "UI", "1" },
        { 0x0008, 0x001a,
          "Related General SOP Class UID", "RelatedGeneralSOPClassUID",  "UI", "1-n" },
        { 0x0008, 0x001b,
          "Original Specialized SOP Class UID", "OriginalSpecializedSOPClassUID",  "UI", "1" },
        { 0x0008, 0x0020,
          "Study Date", "StudyDate",  "DA", "1" },
        { 0x0008, 0x0021,
          "Series Date", "SeriesDate",  "DA", "1" },
        { 0x0008, 0x0022,
          "Acquisition Date", "AcquisitionDate",  "DA", "1" },
        { 0x0008, 0x0023,
          "Content Date", "ContentDate",  "DA", "1" },
        { 0x0008, 0x0024,
          "Overlay Date", "OverlayDate",  "DA", "1" },
        { 0x0008, 0x0025,
          "Curve Date", "CurveDate",  "DA", "1" },
        { 0x0008, 0x002a,
          "Acquisition DateTime", "AcquisitionDateTime",  "DT", "1" },
        { 0x0008, 0x0030,
          "Study Time", "StudyTime",  "TM", "1" },
        { 0x0008, 0x0031,
          "Series Time", "SeriesTime",  "TM", "1" },
        { 0x0008, 0x0032,
          "Acquisition Time", "AcquisitionTime",  "TM", "1" },
        { 0x0008, 0x0033,
          "Content Time", "ContentTime",  "TM", "1" },
        { 0x0008, 0x0034,
          "Overlay Time", "OverlayTime",  "TM", "1" },
        { 0x0008, 0x0035,
          "Curve Time", "CurveTime",  "TM", "1" },
        { 0x0008, 0x0040,
          "Data Set Type", "DataSetType",  "US", "1" },
        { 0x0008, 0x0041,
          "Data Set Subtype", "DataSetSubtype",  "LO", "1" },
        { 0x0008, 0x0042,
          "Nuclear Medicine Series Type", "NuclearMedicineSeriesType",  "CS", "1" },
        { 0x0008, 0x0050,
          "Accession Number", "AccessionNumber",  "SH", "1" },
        { 0x0008, 0x0051,
          "Issuer of Accession Number Sequence", "IssuerOfAccessionNumberSequence",  "SQ", "1" },
        { 0x0008, 0x0052,
          "Query/Retrieve Level", "QueryRetrieveLevel",  "CS", "1" },
        { 0x0008, 0x0053,
          "Query/Retrieve View", "QueryRetrieveView",  "CS", "1" },
        { 0x0008, 0x0054,
          "Retrieve AE Title", "RetrieveAETitle",  "AE", "1-n" },
        { 0x0008, 0x0056,
          "Instance Availability", "InstanceAvailability",  "CS", "1" },
        { 0x0008, 0x0058,
          "Failed SOP Instance UID List", "FailedSOPInstanceUIDList",  "UI", "1-n" },
        { 0x0008, 0x0060,
          "Modality", "Modality",  "CS", "1" },
        { 0x0008, 0x0061,
          "Modalities in Study", "ModalitiesInStudy",  "CS", "1-n" },
        { 0x0008, 0x0062,
          "SOP Classes in Study", "SOPClassesInStudy",  "UI", "1-n" },
        { 0x0008, 0x0064,
          "Conversion Type", "ConversionType",  "CS", "1" },
        { 0x0008, 0x0068,
          "Presentation Intent Type", "PresentationIntentType",  "CS", "1" },
        { 0x0008, 0x0070,
          "Manufacturer", "Manufacturer",  "LO", "1" },
        { 0x0008, 0x0080,
          "Institution Name", "InstitutionName",  "LO", "1" },
        { 0x0008, 0x0081,
          "Institution Address", "InstitutionAddress",  "ST", "1" },
        { 0x0008, 0x0082,
          "Institution Code Sequence", "InstitutionCodeSequence",  "SQ", "1" },
        { 0x0008, 0x0090,
          "Referring Physician's Name", "ReferringPhysicianName",  "PN", "1" },
        { 0x0008, 0x0092,
          "Referring Physician's Address", "ReferringPhysicianAddress",  "ST", "1" },
        { 0x0008, 0x0094,
          "Referring Physician's Telephone Numbers", "ReferringPhysicianTelephoneNumbers",  "SH", "1-n" },
        { 0x0008, 0x0096,
          "Referring Physician Identification Sequence", "ReferringPhysicianIdentificationSequence",  "SQ", "1" },
        { 0x0008, 0x009c,
          "Consulting Physician's Name", "ConsultingPhysicianName",  "PN", "1-n" },
        { 0x0008, 0x009d,
          "Consulting Physician Identification Sequence", "ConsultingPhysicianIdentificationSequence",  "SQ", "1" },
        { 0x0008, 0x0100,
          "Code Value", "CodeValue",  "SH", "1" },
        { 0x0008, 0x0101,
          "Extended Code Value", "ExtendedCodeValue",  "LO", "1" },
        { 0x0008, 0x0102,
          "Coding Scheme Designator", "CodingSchemeDesignator",  "SH", "1" },
        { 0x0008, 0x0103,
          "Coding Scheme Version", "CodingSchemeVersion",  "SH", "1" },
        { 0x0008, 0x0104,
          "Code Meaning", "CodeMeaning",  "LO", "1" },
        { 0x0008, 0x0105,
          "Mapping Resource", "MappingResource",  "CS", "1" },
        { 0x0008, 0x0106,
          "Context Group Version", "ContextGroupVersion",  "DT", "1" },
        { 0x0008, 0x0107,
          "Context Group Local Version", "ContextGroupLocalVersion",  "DT", "1" },
        { 0x0008, 0x0108,
          "Extended Code Meaning", "ExtendedCodeMeaning",  "LT", "1" },
        { 0x0008, 0x010b,
          "Context Group Extension Flag", "ContextGroupExtensionFlag",  "CS", "1" },
        { 0x0008, 0x010c,
          "Coding Scheme UID", "CodingSchemeUID",  "UI", "1" },
        { 0x0008, 0x010d,
          "Context Group Extension Creator UID", "ContextGroupExtensionCreatorUID",  "UI", "1" },
        { 0x0008, 0x010f,
          "Context Identifier", "ContextIdentifier",  "CS", "1" },
        { 0x0008, 0x0110,
          "Coding Scheme Identification Sequence", "CodingSchemeIdentificationSequence",  "SQ", "1" },
        { 0x0008, 0x0112,
          "Coding Scheme Registry", "CodingSchemeRegistry",  "LO", "1" },
        { 0x0008, 0x0114,
          "Coding Scheme External ID", "CodingSchemeExternalID",  "ST", "1" },
        { 0x0008, 0x0115,
          "Coding Scheme Name", "CodingSchemeName",  "ST", "1" },
        { 0x0008, 0x0116,
          "Coding Scheme Responsible Organization", "CodingSchemeResponsibleOrganization",  "ST", "1" },
        { 0x0008, 0x0117,
          "Context UID", "ContextUID",  "UI", "1" },
        { 0x0008, 0x0118,
          "Mapping Resource UID", "MappingResourceUID",  "UI", "1" },
        { 0x0008, 0x0119,
          "Long Code Value", "LongCodeValue",  "UC", "1" },
        { 0x0008, 0x0120,
          "URN Code Value", "URNCodeValue",  "UR", "1" },
        { 0x0008, 0x0121,
          "Equivalent Code Sequence", "EquivalentCodeSequence",  "SQ", "1" },
        { 0x0008, 0x0201,
          "Timezone Offset From UTC", "TimezoneOffsetFromUTC",  "SH", "1" },
        { 0x0008, 0x0300,
          "Private Data Element Characteristics Sequence", "PrivateDataElementCharacteristicsSequence",  "SQ", "1" },
        { 0x0008, 0x0301,
          "Private Group Reference", "PrivateGroupReference",  "US", "1" },
        { 0x0008, 0x0302,
          "Private Creator Reference", "PrivateCreatorReference",  "LO", "1" },
        { 0x0008, 0x0303,
          "Block Identifying Information Status", "BlockIdentifyingInformationStatus",  "CS", "1" },
        { 0x0008, 0x0304,
          "Nonidentifying Private Elements", "NonidentifyingPrivateElements",  "US", "1-n" },
        { 0x0008, 0x0306,
          "Identifying Private Elements", "IdentifyingPrivateElements",  "US", "1-n" },
        { 0x0008, 0x0305,
          "Deidentification Action Sequence", "DeidentificationActionSequence",  "SQ", "1" },
        { 0x0008, 0x0307,
          "Deidentification Action", "DeidentificationAction",  "CS", "1" },
        { 0x0008, 0x1000,
          "Network ID", "NetworkID",  "AE", "1" },
        { 0x0008, 0x1010,
          "Station Name", "StationName",  "SH", "1" },
        { 0x0008, 0x1030,
          "Study Description", "StudyDescription",  "LO", "1" },
        { 0x0008, 0x1032,
          "Procedure Code Sequence", "ProcedureCodeSequence",  "SQ", "1" },
        { 0x0008, 0x103e,
          "Series Description", "SeriesDescription",  "LO", "1" },
        { 0x0008, 0x103f,
          "Series Description Code Sequence", "SeriesDescriptionCodeSequence",  "SQ", "1" },
        { 0x0008, 0x1040,
          "Institutional Department Name", "InstitutionalDepartmentName",  "LO", "1" },
        { 0x0008, 0x1048,
          "Physician(s) of Record", "PhysiciansOfRecord",  "PN", "1-n" },
        { 0x0008, 0x1049,
          "Physician(s) of Record Identification Sequence", "PhysiciansOfRecordIdentificationSequence",  "SQ", "1" },
        { 0x0008, 0x1050,
          "Performing Physician's Name", "PerformingPhysicianName",  "PN", "1-n" },
        { 0x0008, 0x1052,
          "Performing Physician Identification Sequence", "PerformingPhysicianIdentificationSequence",  "SQ", "1" },
        { 0x0008, 0x1060,
          "Name of Physician(s) Reading Study", "NameOfPhysiciansReadingStudy",  "PN", "1-n" },
        { 0x0008, 0x1062,
          "Physician(s) Reading Study Identification Sequence", "PhysiciansReadingStudyIdentificationSequence",  "SQ", "1" },
        { 0x0008, 0x1070,
          "Operators' Name", "OperatorsName",  "PN", "1-n" },
        { 0x0008, 0x1072,
          "Operator Identification Sequence", "OperatorIdentificationSequence",  "SQ", "1" },
        { 0x0008, 0x1080,
          "Admitting Diagnoses Description", "AdmittingDiagnosesDescription",  "LO", "1-n" },
        { 0x0008, 0x1084,
          "Admitting Diagnoses Code Sequence", "AdmittingDiagnosesCodeSequence",  "SQ", "1" },
        { 0x0008, 0x1090,
          "Manufacturer's Model Name", "ManufacturerModelName",  "LO", "1" },
        { 0x0008, 0x1100,
          "Referenced Results Sequence", "ReferencedResultsSequence",  "SQ", "1" },
        { 0x0008, 0x1110,
          "Referenced Study Sequence", "ReferencedStudySequence",  "SQ", "1" },
        { 0x0008, 0x1111,
          "Referenced Performed Procedure Step Sequence", "ReferencedPerformedProcedureStepSequence",  "SQ", "1" },
        { 0x0008, 0x1115,
          "Referenced Series Sequence", "ReferencedSeriesSequence",  "SQ", "1" },
        { 0x0008, 0x1120,
          "Referenced Patient Sequence", "ReferencedPatientSequence",  "SQ", "1" },
        { 0x0008, 0x1125,
          "Referenced Visit Sequence", "ReferencedVisitSequence",  "SQ", "1" },
        { 0x0008, 0x1130,
          "Referenced Overlay Sequence", "ReferencedOverlaySequence",  "SQ", "1" },
        { 0x0008, 0x1134,
          "Referenced Stereometric Instance Sequence", "ReferencedStereometricInstanceSequence",  "SQ", "1" },
        { 0x0008, 0x113a,
          "Referenced Waveform Sequence", "ReferencedWaveformSequence",  "SQ", "1" },
        { 0x0008, 0x1140,
          "Referenced Image Sequence", "ReferencedImageSequence",  "SQ", "1" },
        { 0x0008, 0x1145,
          "Referenced Curve Sequence", "ReferencedCurveSequence",  "SQ", "1" },
        { 0x0008, 0x114a,
          "Referenced Instance Sequence", "ReferencedInstanceSequence",  "SQ", "1" },
        { 0x0008, 0x114b,
          "Referenced Real World Value Mapping Instance Sequence", "ReferencedRealWorldValueMappingInstanceSequence",  "SQ", "1" },
        { 0x0008, 0x1150,
          "Referenced SOP Class UID", "ReferencedSOPClassUID",  "UI", "1" },
        { 0x0008, 0x1155,
          "Referenced SOP Instance UID", "ReferencedSOPInstanceUID",  "UI", "1" },
        { 0x0008, 0x115a,
          "SOP Classes Supported", "SOPClassesSupported",  "UI", "1-n" },
        { 0x0008, 0x1160,
          "Referenced Frame Number", "ReferencedFrameNumber",  "IS", "1-n" },
        { 0x0008, 0x1161,
          "Simple Frame List", "SimpleFrameList",  "UL", "1-n" },
        { 0x0008, 0x1162,
          "Calculated Frame List", "CalculatedFrameList",  "UL", "3-3n" },
        { 0x0008, 0x1163,
          "Time Range", "TimeRange",  "FD", "2" },
        { 0x0008, 0x1164,
          "Frame Extraction Sequence", "FrameExtractionSequence",  "SQ", "1" },
        { 0x0008, 0x1167,
          "Multi-frame Source SOP Instance UID", "MultiFrameSourceSOPInstanceUID",  "UI", "1" },
        { 0x0008, 0x1190,
          "Retrieve URL", "RetrieveURL",  "UR", "1" },
        { 0x0008, 0x1195,
          "Transaction UID", "TransactionUID",  "UI", "1" },
        { 0x0008, 0x1196,
          "Warning Reason", "WarningReason",  "US", "1" },
        { 0x0008, 0x1197,
          "Failure Reason", "FailureReason",  "US", "1" },
        { 0x0008, 0x1198,
          "Failed SOP Sequence", "FailedSOPSequence",  "SQ", "1" },
        { 0x0008, 0x1199,
          "Referenced SOP Sequence", "ReferencedSOPSequence",  "SQ", "1" },
        { 0x0008, 0x1200,
          "Studies Containing Other Referenced Instances Sequence", "StudiesContainingOtherReferencedInstancesSequence",  "SQ", "1" },
        { 0x0008, 0x1250,
          "Related Series Sequence", "RelatedSeriesSequence",  "SQ", "1" },
        { 0x0008, 0x2110,
          "Lossy Image Compression (Retired)", "LossyImageCompressionRetired",  "CS", "1" },
        { 0x0008, 0x2111,
          "Derivation Description", "DerivationDescription",  "ST", "1" },
        { 0x0008, 0x2112,
          "Source Image Sequence", "SourceImageSequence",  "SQ", "1" },
        { 0x0008, 0x2120,
          "Stage Name", "StageName",  "SH", "1" },
        { 0x0008, 0x2122,
          "Stage Number", "StageNumber",  "IS", "1" },
        { 0x0008, 0x2124,
          "Number of Stages", "NumberOfStages",  "IS", "1" },
        { 0x0008, 0x2127,
          "View Name", "ViewName",  "SH", "1" },
        { 0x0008, 0x2128,
          "View Number", "ViewNumber",  "IS", "1" },
        { 0x0008, 0x2129,
          "Number of Event Timers", "NumberOfEventTimers",  "IS", "1" },
        { 0x0008, 0x212a,
          "Number of Views in Stage", "NumberOfViewsInStage",  "IS", "1" },
        { 0x0008, 0x2130,
          "Event Elapsed Time(s)", "EventElapsedTimes",  "DS", "1-n" },
        { 0x0008, 0x2132,
          "Event Timer Name(s)", "EventTimerNames",  "LO", "1-n" },
        { 0x0008, 0x2133,
          "Event Timer Sequence", "EventTimerSequence",  "SQ", "1" },
        { 0x0008, 0x2134,
          "Event Time Offset", "EventTimeOffset",  "FD", "1" },
        { 0x0008, 0x2135,
          "Event Code Sequence", "EventCodeSequence",  "SQ", "1" },
        { 0x0008, 0x2142,
          "Start Trim", "StartTrim",  "IS", "1" },
        { 0x0008, 0x2143,
          "Stop Trim", "StopTrim",  "IS", "1" },
        { 0x0008, 0x2144,
          "Recommended Display Frame Rate", "RecommendedDisplayFrameRate",  "IS", "1" },
        { 0x0008, 0x2200,
          "Transducer Position", "TransducerPosition",  "CS", "1" },
        { 0x0008, 0x2204,
          "Transducer Orientation", "TransducerOrientation",  "CS", "1" },
        { 0x0008, 0x2208,
          "Anatomic Structure", "AnatomicStructure",  "CS", "1" },
        { 0x0008, 0x2218,
          "Anatomic Region Sequence", "AnatomicRegionSequence",  "SQ", "1" },
        { 0x0008, 0x2220,
          "Anatomic Region Modifier Sequence", "AnatomicRegionModifierSequence",  "SQ", "1" },
        { 0x0008, 0x2228,
          "Primary Anatomic Structure Sequence", "PrimaryAnatomicStructureSequence",  "SQ", "1" },
        { 0x0008, 0x2229,
          "Anatomic Structure, Space or Region Sequence", "AnatomicStructureSpaceOrRegionSequence",  "SQ", "1" },
        { 0x0008, 0x2230,
          "Primary Anatomic Structure Modifier Sequence", "PrimaryAnatomicStructureModifierSequence",  "SQ", "1" },
        { 0x0008, 0x2240,
          "Transducer Position Sequence", "TransducerPositionSequence",  "SQ", "1" },
        { 0x0008, 0x2242,
          "Transducer Position Modifier Sequence", "TransducerPositionModifierSequence",  "SQ", "1" },
        { 0x0008, 0x2244,
          "Transducer Orientation Sequence", "TransducerOrientationSequence",  "SQ", "1" },
        { 0x0008, 0x2246,
          "Transducer Orientation Modifier Sequence", "TransducerOrientationModifierSequence",  "SQ", "1" },
        { 0x0008, 0x2251,
          "Anatomic Structure Space Or Region Code Sequence (Trial)", "AnatomicStructureSpaceOrRegionCodeSequenceTrial",  "SQ", "1" },
        { 0x0008, 0x2253,
          "Anatomic Portal Of Entrance Code Sequence (Trial)", "AnatomicPortalOfEntranceCodeSequenceTrial",  "SQ", "1" },
        { 0x0008, 0x2255,
          "Anatomic Approach Direction Code Sequence (Trial)", "AnatomicApproachDirectionCodeSequenceTrial",  "SQ", "1" },
        { 0x0008, 0x2256,
          "Anatomic Perspective Description (Trial)", "AnatomicPerspectiveDescriptionTrial",  "ST", "1" },
        { 0x0008, 0x2257,
          "Anatomic Perspective Code Sequence (Trial)", "AnatomicPerspectiveCodeSequenceTrial",  "SQ", "1" },
        { 0x0008, 0x2258,
          "Anatomic Location Of Examining Instrument Description (Trial)", "AnatomicLocationOfExaminingInstrumentDescriptionTrial",  "ST", "1" },
        { 0x0008, 0x2259,
          "Anatomic Location Of Examining Instrument Code Sequence (Trial)", "AnatomicLocationOfExaminingInstrumentCodeSequenceTrial",  "SQ", "1" },
        { 0x0008, 0x225a,
          "Anatomic Structure Space Or Region Modifier Code Sequence (Trial)", "AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0008, 0x225c,
          "On Axis Background Anatomic Structure Code Sequence (Trial)", "OnAxisBackgroundAnatomicStructureCodeSequenceTrial",  "SQ", "1" },
        { 0x0008, 0x3001,
          "Alternate Representation Sequence", "AlternateRepresentationSequence",  "SQ", "1" },
        { 0x0008, 0x3010,
          "Irradiation Event UID", "IrradiationEventUID",  "UI", "1-n" },
        { 0x0008, 0x3011,
          "Source Irradiation Event Sequence", "SourceIrradiationEventSequence",  "SQ", "1" },
        { 0x0008, 0x3012,
          "Radiopharmaceutical Administration Event UID", "RadiopharmaceuticalAdministrationEventUID",  "UI", "1" },
        { 0x0008, 0x4000,
          "Identifying Comments", "IdentifyingComments",  "LT", "1" },
        { 0x0008, 0x9007,
          "Frame Type", "FrameType",  "CS", "4" },
        { 0x0008, 0x9092,
          "Referenced Image Evidence Sequence", "ReferencedImageEvidenceSequence",  "SQ", "1" },
        { 0x0008, 0x9121,
          "Referenced Raw Data Sequence", "ReferencedRawDataSequence",  "SQ", "1" },
        { 0x0008, 0x9123,
          "Creator-Version UID", "CreatorVersionUID",  "UI", "1" },
        { 0x0008, 0x9124,
          "Derivation Image Sequence", "DerivationImageSequence",  "SQ", "1" },
        { 0x0008, 0x9154,
          "Source Image Evidence Sequence", "SourceImageEvidenceSequence",  "SQ", "1" },
        { 0x0008, 0x9205,
          "Pixel Presentation", "PixelPresentation",  "CS", "1" },
        { 0x0008, 0x9206,
          "Volumetric Properties", "VolumetricProperties",  "CS", "1" },
        { 0x0008, 0x9207,
          "Volume Based Calculation Technique", "VolumeBasedCalculationTechnique",  "CS", "1" },
        { 0x0008, 0x9208,
          "Complex Image Component", "ComplexImageComponent",  "CS", "1" },
        { 0x0008, 0x9209,
          "Acquisition Contrast", "AcquisitionContrast",  "CS", "1" },
        { 0x0008, 0x9215,
          "Derivation Code Sequence", "DerivationCodeSequence",  "SQ", "1" },
        { 0x0008, 0x9237,
          "Referenced Presentation State Sequence", "ReferencedPresentationStateSequence",  "SQ", "1" },
        { 0x0008, 0x9410,
          "Referenced Other Plane Sequence", "ReferencedOtherPlaneSequence",  "SQ", "1" },
        { 0x0008, 0x9458,
          "Frame Display Sequence", "FrameDisplaySequence",  "SQ", "1" },
        { 0x0008, 0x9459,
          "Recommended Display Frame Rate in Float", "RecommendedDisplayFrameRateInFloat",  "FL", "1" },
        { 0x0008, 0x9460,
          "Skip Frame Range Flag", "SkipFrameRangeFlag",  "CS", "1" },
        { 0x0010, 0x0010,
          "Patient's Name", "PatientName",  "PN", "1" },
        { 0x0010, 0x0020,
          "Patient ID", "PatientID",  "LO", "1" },
        { 0x0010, 0x0021,
          "Issuer of Patient ID", "IssuerOfPatientID",  "LO", "1" },
        { 0x0010, 0x0022,
          "Type of Patient ID", "TypeOfPatientID",  "CS", "1" },
        { 0x0010, 0x0024,
          "Issuer of Patient ID Qualifiers Sequence", "IssuerOfPatientIDQualifiersSequence",  "SQ", "1" },
        { 0x0010, 0x0030,
          "Patient's Birth Date", "PatientBirthDate",  "DA", "1" },
        { 0x0010, 0x0032,
          "Patient's Birth Time", "PatientBirthTime",  "TM", "1" },
        { 0x0010, 0x0040,
          "Patient's Sex", "PatientSex",  "CS", "1" },
        { 0x0010, 0x0050,
          "Patient's Insurance Plan Code Sequence", "PatientInsurancePlanCodeSequence",  "SQ", "1" },
        { 0x0010, 0x0101,
          "Patient's Primary Language Code Sequence", "PatientPrimaryLanguageCodeSequence",  "SQ", "1" },
        { 0x0010, 0x0102,
          "Patient's Primary Language Modifier Code Sequence", "PatientPrimaryLanguageModifierCodeSequence",  "SQ", "1" },
        { 0x0010, 0x0200,
          "Quality Control Subject", "QualityControlSubject",  "CS", "1" },
        { 0x0010, 0x0201,
          "Quality Control Subject Type Code Sequence", "QualityControlSubjectTypeCodeSequence",  "SQ", "1" },
        { 0x0010, 0x1000,
          "Other Patient IDs", "OtherPatientIDs",  "LO", "1-n" },
        { 0x0010, 0x1001,
          "Other Patient Names", "OtherPatientNames",  "PN", "1-n" },
        { 0x0010, 0x1002,
          "Other Patient IDs Sequence", "OtherPatientIDsSequence",  "SQ", "1" },
        { 0x0010, 0x1005,
          "Patient's Birth Name", "PatientBirthName",  "PN", "1" },
        { 0x0010, 0x1010,
          "Patient's Age", "PatientAge",  "AS", "1" },
        { 0x0010, 0x1020,
          "Patient's Size", "PatientSize",  "DS", "1" },
        { 0x0010, 0x1021,
          "Patient's Size Code Sequence", "PatientSizeCodeSequence",  "SQ", "1" },
        { 0x0010, 0x1030,
          "Patient's Weight", "PatientWeight",  "DS", "1" },
        { 0x0010, 0x1040,
          "Patient's Address", "PatientAddress",  "LO", "1" },
        { 0x0010, 0x1050,
          "Insurance Plan Identification", "InsurancePlanIdentification",  "LO", "1-n" },
        { 0x0010, 0x1060,
          "Patient's Mother's Birth Name", "PatientMotherBirthName",  "PN", "1" },
        { 0x0010, 0x1080,
          "Military Rank", "MilitaryRank",  "LO", "1" },
        { 0x0010, 0x1081,
          "Branch of Service", "BranchOfService",  "LO", "1" },
        { 0x0010, 0x1090,
          "Medical Record Locator", "MedicalRecordLocator",  "LO", "1" },
        { 0x0010, 0x1100,
          "Referenced Patient Photo Sequence", "ReferencedPatientPhotoSequence",  "SQ", "1" },
        { 0x0010, 0x2000,
          "Medical Alerts", "MedicalAlerts",  "LO", "1-n" },
        { 0x0010, 0x2110,
          "Allergies", "Allergies",  "LO", "1-n" },
        { 0x0010, 0x2150,
          "Country of Residence", "CountryOfResidence",  "LO", "1" },
        { 0x0010, 0x2152,
          "Region of Residence", "RegionOfResidence",  "LO", "1" },
        { 0x0010, 0x2154,
          "Patient's Telephone Numbers", "PatientTelephoneNumbers",  "SH", "1-n" },
        { 0x0010, 0x2155,
          "Patient's Telecom Information", "PatientTelecomInformation",  "LT", "1" },
        { 0x0010, 0x2160,
          "Ethnic Group", "EthnicGroup",  "SH", "1" },
        { 0x0010, 0x2180,
          "Occupation", "Occupation",  "SH", "1" },
        { 0x0010, 0x21a0,
          "Smoking Status", "SmokingStatus",  "CS", "1" },
        { 0x0010, 0x21b0,
          "Additional Patient History", "AdditionalPatientHistory",  "LT", "1" },
        { 0x0010, 0x21c0,
          "Pregnancy Status", "PregnancyStatus",  "US", "1" },
        { 0x0010, 0x21d0,
          "Last Menstrual Date", "LastMenstrualDate",  "DA", "1" },
        { 0x0010, 0x21f0,
          "Patient's Religious Preference", "PatientReligiousPreference",  "LO", "1" },
        { 0x0010, 0x2201,
          "Patient Species Description", "PatientSpeciesDescription",  "LO", "1" },
        { 0x0010, 0x2202,
          "Patient Species Code Sequence", "PatientSpeciesCodeSequence",  "SQ", "1" },
        { 0x0010, 0x2203,
          "Patient's Sex Neutered", "PatientSexNeutered",  "CS", "1" },
        { 0x0010, 0x2210,
          "Anatomical Orientation Type", "AnatomicalOrientationType",  "CS", "1" },
        { 0x0010, 0x2292,
          "Patient Breed Description", "PatientBreedDescription",  "LO", "1" },
        { 0x0010, 0x2293,
          "Patient Breed Code Sequence", "PatientBreedCodeSequence",  "SQ", "1" },
        { 0x0010, 0x2294,
          "Breed Registration Sequence", "BreedRegistrationSequence",  "SQ", "1" },
        { 0x0010, 0x2295,
          "Breed Registration Number", "BreedRegistrationNumber",  "LO", "1" },
        { 0x0010, 0x2296,
          "Breed Registry Code Sequence", "BreedRegistryCodeSequence",  "SQ", "1" },
        { 0x0010, 0x2297,
          "Responsible Person", "ResponsiblePerson",  "PN", "1" },
        { 0x0010, 0x2298,
          "Responsible Person Role", "ResponsiblePersonRole",  "CS", "1" },
        { 0x0010, 0x2299,
          "Responsible Organization", "ResponsibleOrganization",  "LO", "1" },
        { 0x0010, 0x4000,
          "Patient Comments", "PatientComments",  "LT", "1" },
        { 0x0010, 0x9431,
          "Examined Body Thickness", "ExaminedBodyThickness",  "FL", "1" },
        { 0x0012, 0x0010,
          "Clinical Trial Sponsor Name", "ClinicalTrialSponsorName",  "LO", "1" },
        { 0x0012, 0x0020,
          "Clinical Trial Protocol ID", "ClinicalTrialProtocolID",  "LO", "1" },
        { 0x0012, 0x0021,
          "Clinical Trial Protocol Name", "ClinicalTrialProtocolName",  "LO", "1" },
        { 0x0012, 0x0030,
          "Clinical Trial Site ID", "ClinicalTrialSiteID",  "LO", "1" },
        { 0x0012, 0x0031,
          "Clinical Trial Site Name", "ClinicalTrialSiteName",  "LO", "1" },
        { 0x0012, 0x0040,
          "Clinical Trial Subject ID", "ClinicalTrialSubjectID",  "LO", "1" },
        { 0x0012, 0x0042,
          "Clinical Trial Subject Reading ID", "ClinicalTrialSubjectReadingID",  "LO", "1" },
        { 0x0012, 0x0050,
          "Clinical Trial Time Point ID", "ClinicalTrialTimePointID",  "LO", "1" },
        { 0x0012, 0x0051,
          "Clinical Trial Time Point Description", "ClinicalTrialTimePointDescription",  "ST", "1" },
        { 0x0012, 0x0060,
          "Clinical Trial Coordinating Center Name", "ClinicalTrialCoordinatingCenterName",  "LO", "1" },
        { 0x0012, 0x0062,
          "Patient Identity Removed", "PatientIdentityRemoved",  "CS", "1" },
        { 0x0012, 0x0063,
          "De-identification Method", "DeidentificationMethod",  "LO", "1-n" },
        { 0x0012, 0x0064,
          "De-identification Method Code Sequence", "DeidentificationMethodCodeSequence",  "SQ", "1" },
        { 0x0012, 0x0071,
          "Clinical Trial Series ID", "ClinicalTrialSeriesID",  "LO", "1" },
        { 0x0012, 0x0072,
          "Clinical Trial Series Description", "ClinicalTrialSeriesDescription",  "LO", "1" },
        { 0x0012, 0x0081,
          "Clinical Trial Protocol Ethics Committee Name", "ClinicalTrialProtocolEthicsCommitteeName",  "LO", "1" },
        { 0x0012, 0x0082,
          "Clinical Trial Protocol Ethics Committee Approval Number", "ClinicalTrialProtocolEthicsCommitteeApprovalNumber",  "LO", "1" },
        { 0x0012, 0x0083,
          "Consent for Clinical Trial Use Sequence", "ConsentForClinicalTrialUseSequence",  "SQ", "1" },
        { 0x0012, 0x0084,
          "Distribution Type", "DistributionType",  "CS", "1" },
        { 0x0012, 0x0085,
          "Consent for Distribution Flag", "ConsentForDistributionFlag",  "CS", "1" },
        { 0x0014, 0x0023,
          "CAD File Format", "CADFileFormat",  "ST", "1-n" },
        { 0x0014, 0x0024,
          "Component Reference System", "ComponentReferenceSystem",  "ST", "1-n" },
        { 0x0014, 0x0025,
          "Component Manufacturing Procedure", "ComponentManufacturingProcedure",  "ST", "1-n" },
        { 0x0014, 0x0028,
          "Component Manufacturer", "ComponentManufacturer",  "ST", "1-n" },
        { 0x0014, 0x0030,
          "Material Thickness", "MaterialThickness",  "DS", "1-n" },
        { 0x0014, 0x0032,
          "Material Pipe Diameter", "MaterialPipeDiameter",  "DS", "1-n" },
        { 0x0014, 0x0034,
          "Material Isolation Diameter", "MaterialIsolationDiameter",  "DS", "1-n" },
        { 0x0014, 0x0042,
          "Material Grade", "MaterialGrade",  "ST", "1-n" },
        { 0x0014, 0x0044,
          "Material Properties Description", "MaterialPropertiesDescription",  "ST", "1-n" },
        { 0x0014, 0x0045,
          "Material Properties File Format (Retired)", "MaterialPropertiesFileFormatRetired",  "ST", "1-n" },
        { 0x0014, 0x0046,
          "Material Notes", "MaterialNotes",  "LT", "1" },
        { 0x0014, 0x0050,
          "Component Shape", "ComponentShape",  "CS", "1" },
        { 0x0014, 0x0052,
          "Curvature Type", "CurvatureType",  "CS", "1" },
        { 0x0014, 0x0054,
          "Outer Diameter", "OuterDiameter",  "DS", "1" },
        { 0x0014, 0x0056,
          "Inner Diameter", "InnerDiameter",  "DS", "1" },
        { 0x0014, 0x1010,
          "Actual Environmental Conditions", "ActualEnvironmentalConditions",  "ST", "1" },
        { 0x0014, 0x1020,
          "Expiry Date", "ExpiryDate",  "DA", "1" },
        { 0x0014, 0x1040,
          "Environmental Conditions", "EnvironmentalConditions",  "ST", "1" },
        { 0x0014, 0x2002,
          "Evaluator Sequence", "EvaluatorSequence",  "SQ", "1" },
        { 0x0014, 0x2004,
          "Evaluator Number", "EvaluatorNumber",  "IS", "1" },
        { 0x0014, 0x2006,
          "Evaluator Name", "EvaluatorName",  "PN", "1" },
        { 0x0014, 0x2008,
          "Evaluation Attempt", "EvaluationAttempt",  "IS", "1" },
        { 0x0014, 0x2012,
          "Indication Sequence", "IndicationSequence",  "SQ", "1" },
        { 0x0014, 0x2014,
          "Indication Number", "IndicationNumber",  "IS", "1" },
        { 0x0014, 0x2016,
          "Indication Label", "IndicationLabel",  "SH", "1" },
        { 0x0014, 0x2018,
          "Indication Description", "IndicationDescription",  "ST", "1" },
        { 0x0014, 0x201a,
          "Indication Type", "IndicationType",  "CS", "1-n" },
        { 0x0014, 0x201c,
          "Indication Disposition", "IndicationDisposition",  "CS", "1" },
        { 0x0014, 0x201e,
          "Indication ROI Sequence", "IndicationROISequence",  "SQ", "1" },
        { 0x0014, 0x2030,
          "Indication Physical Property Sequence", "IndicationPhysicalPropertySequence",  "SQ", "1" },
        { 0x0014, 0x2032,
          "Property Label", "PropertyLabel",  "SH", "1" },
        { 0x0014, 0x2202,
          "Coordinate System Number of Axes", "CoordinateSystemNumberOfAxes",  "IS", "1" },
        { 0x0014, 0x2204,
          "Coordinate System Axes Sequence", "CoordinateSystemAxesSequence",  "SQ", "1" },
        { 0x0014, 0x2206,
          "Coordinate System Axis Description", "CoordinateSystemAxisDescription",  "ST", "1" },
        { 0x0014, 0x2208,
          "Coordinate System Data Set Mapping", "CoordinateSystemDataSetMapping",  "CS", "1" },
        { 0x0014, 0x220a,
          "Coordinate System Axis Number", "CoordinateSystemAxisNumber",  "IS", "1" },
        { 0x0014, 0x220c,
          "Coordinate System Axis Type", "CoordinateSystemAxisType",  "CS", "1" },
        { 0x0014, 0x220e,
          "Coordinate System Axis Units", "CoordinateSystemAxisUnits",  "CS", "1" },
        { 0x0014, 0x2210,
          "Coordinate System Axis Values", "CoordinateSystemAxisValues",  "OB", "1" },
        { 0x0014, 0x2220,
          "Coordinate System Transform Sequence", "CoordinateSystemTransformSequence",  "SQ", "1" },
        { 0x0014, 0x2222,
          "Transform Description", "TransformDescription",  "ST", "1" },
        { 0x0014, 0x2224,
          "Transform Number of Axes", "TransformNumberOfAxes",  "IS", "1" },
        { 0x0014, 0x2226,
          "Transform Order of Axes", "TransformOrderOfAxes",  "IS", "1-n" },
        { 0x0014, 0x2228,
          "Transformed Axis Units", "TransformedAxisUnits",  "CS", "1" },
        { 0x0014, 0x222a,
          "Coordinate System Transform Rotation and Scale Matrix", "CoordinateSystemTransformRotationAndScaleMatrix",  "DS", "1-n" },
        { 0x0014, 0x222c,
          "Coordinate System Transform Translation Matrix", "CoordinateSystemTransformTranslationMatrix",  "DS", "1-n" },
        { 0x0014, 0x3011,
          "Internal Detector Frame Time", "InternalDetectorFrameTime",  "DS", "1" },
        { 0x0014, 0x3012,
          "Number of Frames Integrated", "NumberOfFramesIntegrated",  "DS", "1" },
        { 0x0014, 0x3020,
          "Detector Temperature Sequence", "DetectorTemperatureSequence",  "SQ", "1" },
        { 0x0014, 0x3022,
          "Sensor Name", "SensorName",  "ST", "1" },
        { 0x0014, 0x3024,
          "Horizontal Offset of Sensor", "HorizontalOffsetOfSensor",  "DS", "1" },
        { 0x0014, 0x3026,
          "Vertical Offset of Sensor", "VerticalOffsetOfSensor",  "DS", "1" },
        { 0x0014, 0x3028,
          "Sensor Temperature", "SensorTemperature",  "DS", "1" },
        { 0x0014, 0x3040,
          "Dark Current Sequence", "DarkCurrentSequence",  "SQ", "1" },
        { 0x0014, 0x3050,
          "Dark Current Counts", "DarkCurrentCounts",  "OB or OW", "1" },
        { 0x0014, 0x3060,
          "Gain Correction Reference Sequence", "GainCorrectionReferenceSequence",  "SQ", "1" },
        { 0x0014, 0x3070,
          "Air Counts", "AirCounts",  "OB or OW", "1" },
        { 0x0014, 0x3071,
          "KV Used in Gain Calibration", "KVUsedInGainCalibration",  "DS", "1" },
        { 0x0014, 0x3072,
          "MA Used in Gain Calibration", "MAUsedInGainCalibration",  "DS", "1" },
        { 0x0014, 0x3073,
          "Number of Frames Used for Integration", "NumberOfFramesUsedForIntegration",  "DS", "1" },
        { 0x0014, 0x3074,
          "Filter Material Used in Gain Calibration", "FilterMaterialUsedInGainCalibration",  "LO", "1" },
        { 0x0014, 0x3075,
          "Filter Thickness Used in Gain Calibration", "FilterThicknessUsedInGainCalibration",  "DS", "1" },
        { 0x0014, 0x3076,
          "Date of Gain Calibration", "DateOfGainCalibration",  "DA", "1" },
        { 0x0014, 0x3077,
          "Time of Gain Calibration", "TimeOfGainCalibration",  "TM", "1" },
        { 0x0014, 0x3080,
          "Bad Pixel Image", "BadPixelImage",  "OB", "1" },
        { 0x0014, 0x3099,
          "Calibration Notes", "CalibrationNotes",  "LT", "1" },
        { 0x0014, 0x4002,
          "Pulser Equipment Sequence", "PulserEquipmentSequence",  "SQ", "1" },
        { 0x0014, 0x4004,
          "Pulser Type", "PulserType",  "CS", "1" },
        { 0x0014, 0x4006,
          "Pulser Notes", "PulserNotes",  "LT", "1" },
        { 0x0014, 0x4008,
          "Receiver Equipment Sequence", "ReceiverEquipmentSequence",  "SQ", "1" },
        { 0x0014, 0x400a,
          "Amplifier Type", "AmplifierType",  "CS", "1" },
        { 0x0014, 0x400c,
          "Receiver Notes", "ReceiverNotes",  "LT", "1" },
        { 0x0014, 0x400e,
          "Pre-Amplifier Equipment Sequence", "PreAmplifierEquipmentSequence",  "SQ", "1" },
        { 0x0014, 0x400f,
          "Pre-Amplifier Notes", "PreAmplifierNotes",  "LT", "1" },
        { 0x0014, 0x4010,
          "Transmit Transducer Sequence", "TransmitTransducerSequence",  "SQ", "1" },
        { 0x0014, 0x4011,
          "Receive Transducer Sequence", "ReceiveTransducerSequence",  "SQ", "1" },
        { 0x0014, 0x4012,
          "Number of Elements", "NumberOfElements",  "US", "1" },
        { 0x0014, 0x4013,
          "Element Shape", "ElementShape",  "CS", "1" },
        { 0x0014, 0x4014,
          "Element Dimension A", "ElementDimensionA",  "DS", "1" },
        { 0x0014, 0x4015,
          "Element Dimension B", "ElementDimensionB",  "DS", "1" },
        { 0x0014, 0x4016,
          "Element Pitch A", "ElementPitchA",  "DS", "1" },
        { 0x0014, 0x4017,
          "Measured Beam Dimension A", "MeasuredBeamDimensionA",  "DS", "1" },
        { 0x0014, 0x4018,
          "Measured Beam Dimension B", "MeasuredBeamDimensionB",  "DS", "1" },
        { 0x0014, 0x4019,
          "Location of Measured Beam Diameter", "LocationOfMeasuredBeamDiameter",  "DS", "1" },
        { 0x0014, 0x401a,
          "Nominal Frequency", "NominalFrequency",  "DS", "1" },
        { 0x0014, 0x401b,
          "Measured Center Frequency", "MeasuredCenterFrequency",  "DS", "1" },
        { 0x0014, 0x401c,
          "Measured Bandwidth", "MeasuredBandwidth",  "DS", "1" },
        { 0x0014, 0x401d,
          "Element Pitch B", "ElementPitchB",  "DS", "1" },
        { 0x0014, 0x4020,
          "Pulser Settings Sequence", "PulserSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4022,
          "Pulse Width", "PulseWidth",  "DS", "1" },
        { 0x0014, 0x4024,
          "Excitation Frequency", "ExcitationFrequency",  "DS", "1" },
        { 0x0014, 0x4026,
          "Modulation Type", "ModulationType",  "CS", "1" },
        { 0x0014, 0x4028,
          "Damping", "Damping",  "DS", "1" },
        { 0x0014, 0x4030,
          "Receiver Settings Sequence", "ReceiverSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4031,
          "Acquired Soundpath Length", "AcquiredSoundpathLength",  "DS", "1" },
        { 0x0014, 0x4032,
          "Acquisition Compression Type", "AcquisitionCompressionType",  "CS", "1" },
        { 0x0014, 0x4033,
          "Acquisition Sample Size", "AcquisitionSampleSize",  "IS", "1" },
        { 0x0014, 0x4034,
          "Rectifier Smoothing", "RectifierSmoothing",  "DS", "1" },
        { 0x0014, 0x4035,
          "DAC Sequence", "DACSequence",  "SQ", "1" },
        { 0x0014, 0x4036,
          "DAC Type", "DACType",  "CS", "1" },
        { 0x0014, 0x4038,
          "DAC Gain Points", "DACGainPoints",  "DS", "1-n" },
        { 0x0014, 0x403a,
          "DAC Time Points", "DACTimePoints",  "DS", "1-n" },
        { 0x0014, 0x403c,
          "DAC Amplitude", "DACAmplitude",  "DS", "1-n" },
        { 0x0014, 0x4040,
          "Pre-Amplifier Settings Sequence", "PreAmplifierSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4050,
          "Transmit Transducer Settings Sequence", "TransmitTransducerSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4051,
          "Receive Transducer Settings Sequence", "ReceiveTransducerSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4052,
          "Incident Angle", "IncidentAngle",  "DS", "1" },
        { 0x0014, 0x4054,
          "Coupling Technique", "CouplingTechnique",  "ST", "1" },
        { 0x0014, 0x4056,
          "Coupling Medium", "CouplingMedium",  "ST", "1" },
        { 0x0014, 0x4057,
          "Coupling Velocity", "CouplingVelocity",  "DS", "1" },
        { 0x0014, 0x4058,
          "Probe Center Location X", "ProbeCenterLocationX",  "DS", "1" },
        { 0x0014, 0x4059,
          "Probe Center Location Z", "ProbeCenterLocationZ",  "DS", "1" },
        { 0x0014, 0x405a,
          "Sound Path Length", "SoundPathLength",  "DS", "1" },
        { 0x0014, 0x405c,
          "Delay Law Identifier", "DelayLawIdentifier",  "ST", "1" },
        { 0x0014, 0x4060,
          "Gate Settings Sequence", "GateSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4062,
          "Gate Threshold", "GateThreshold",  "DS", "1" },
        { 0x0014, 0x4064,
          "Velocity of Sound", "VelocityOfSound",  "DS", "1" },
        { 0x0014, 0x4070,
          "Calibration Settings Sequence", "CalibrationSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4072,
          "Calibration Procedure", "CalibrationProcedure",  "ST", "1" },
        { 0x0014, 0x4074,
          "Procedure Version", "ProcedureVersion",  "SH", "1" },
        { 0x0014, 0x4076,
          "Procedure Creation Date", "ProcedureCreationDate",  "DA", "1" },
        { 0x0014, 0x4078,
          "Procedure Expiration Date", "ProcedureExpirationDate",  "DA", "1" },
        { 0x0014, 0x407a,
          "Procedure Last Modified Date", "ProcedureLastModifiedDate",  "DA", "1" },
        { 0x0014, 0x407c,
          "Calibration Time", "CalibrationTime",  "TM", "1-n" },
        { 0x0014, 0x407e,
          "Calibration Date", "CalibrationDate",  "DA", "1-n" },
        { 0x0014, 0x4080,
          "Probe Drive Equipment Sequence", "ProbeDriveEquipmentSequence",  "SQ", "1" },
        { 0x0014, 0x4081,
          "Drive Type", "DriveType",  "CS", "1" },
        { 0x0014, 0x4082,
          "Probe Drive Notes", "ProbeDriveNotes",  "LT", "1" },
        { 0x0014, 0x4083,
          "Drive Probe Sequence", "DriveProbeSequence",  "SQ", "1" },
        { 0x0014, 0x4084,
          "Probe Inductance", "ProbeInductance",  "DS", "1" },
        { 0x0014, 0x4085,
          "Probe Resistance", "ProbeResistance",  "DS", "1" },
        { 0x0014, 0x4086,
          "Receive Probe Sequence", "ReceiveProbeSequence",  "SQ", "1" },
        { 0x0014, 0x4087,
          "Probe Drive Settings Sequence", "ProbeDriveSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4088,
          "Bridge Resistors", "BridgeResistors",  "DS", "1" },
        { 0x0014, 0x4089,
          "Probe Orientation Angle", "ProbeOrientationAngle",  "DS", "1" },
        { 0x0014, 0x408b,
          "User Selected Gain Y", "UserSelectedGainY",  "DS", "1" },
        { 0x0014, 0x408c,
          "User Selected Phase", "UserSelectedPhase",  "DS", "1" },
        { 0x0014, 0x408d,
          "User Selected Offset X", "UserSelectedOffsetX",  "DS", "1" },
        { 0x0014, 0x408e,
          "User Selected Offset Y", "UserSelectedOffsetY",  "DS", "1" },
        { 0x0014, 0x4091,
          "Channel Settings Sequence", "ChannelSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x4092,
          "Channel Threshold", "ChannelThreshold",  "DS", "1" },
        { 0x0014, 0x409a,
          "Scanner Settings Sequence", "ScannerSettingsSequence",  "SQ", "1" },
        { 0x0014, 0x409b,
          "Scan Procedure", "ScanProcedure",  "ST", "1" },
        { 0x0014, 0x409c,
          "Translation Rate X", "TranslationRateX",  "DS", "1" },
        { 0x0014, 0x409d,
          "Translation Rate Y", "TranslationRateY",  "DS", "1" },
        { 0x0014, 0x409f,
          "Channel Overlap", "ChannelOverlap",  "DS", "1" },
        { 0x0014, 0x40a0,
          "Image Quality Indicator Type", "ImageQualityIndicatorType",  "LO", "1" },
        { 0x0014, 0x40a1,
          "Image Quality Indicator Material", "ImageQualityIndicatorMaterial",  "LO", "1" },
        { 0x0014, 0x40a2,
          "Image Quality Indicator Size", "ImageQualityIndicatorSize",  "LO", "1" },
        { 0x0014, 0x5002,
          "LINAC Energy", "LINACEnergy",  "IS", "1" },
        { 0x0014, 0x5004,
          "LINAC Output", "LINACOutput",  "IS", "1" },
        { 0x0014, 0x5100,
          "Active Aperture", "ActiveAperture",  "US", "1" },
        { 0x0014, 0x5101,
          "Total Aperture", "TotalAperture",  "DS", "1" },
        { 0x0014, 0x5102,
          "Aperture Elevation", "ApertureElevation",  "DS", "1" },
        { 0x0014, 0x5103,
          "Main Lobe Angle", "MainLobeAngle",  "DS", "1" },
        { 0x0014, 0x5104,
          "Main Roof Angle", "MainRoofAngle",  "DS", "1" },
        { 0x0014, 0x5105,
          "Connector Type", "ConnectorType",  "CS", "1" },
        { 0x0014, 0x5106,
          "Wedge Model Number", "WedgeModelNumber",  "SH", "1" },
        { 0x0014, 0x5107,
          "Wedge Angle Float", "WedgeAngleFloat",  "DS", "1" },
        { 0x0014, 0x5108,
          "Wedge Roof Angle", "WedgeRoofAngle",  "DS", "1" },
        { 0x0014, 0x5109,
          "Wedge Element 1 Position", "WedgeElement1Position",  "CS", "1" },
        { 0x0014, 0x510a,
          "Wedge Material Velocity", "WedgeMaterialVelocity",  "DS", "1" },
        { 0x0014, 0x510b,
          "Wedge Material", "WedgeMaterial",  "SH", "1" },
        { 0x0014, 0x510c,
          "Wedge Offset Z", "WedgeOffsetZ",  "DS", "1" },
        { 0x0014, 0x510d,
          "Wedge Origin Offset X", "WedgeOriginOffsetX",  "DS", "1" },
        { 0x0014, 0x510e,
          "Wedge Time Delay", "WedgeTimeDelay",  "DS", "1" },
        { 0x0014, 0x510f,
          "Wedge Name", "WedgeName",  "SH", "1" },
        { 0x0014, 0x5110,
          "Wedge Manufacturer Name", "WedgeManufacturerName",  "SH", "1" },
        { 0x0014, 0x5111,
          "Wedge Description", "WedgeDescription",  "LO", "1" },
        { 0x0014, 0x5112,
          "Nominal Beam Angle", "NominalBeamAngle",  "DS", "1" },
        { 0x0014, 0x5113,
          "Wedge Offset X", "WedgeOffsetX",  "DS", "1" },
        { 0x0014, 0x5114,
          "Wedge Offset Y", "WedgeOffsetY",  "DS", "1" },
        { 0x0014, 0x5115,
          "Wedge Total Length", "WedgeTotalLength",  "DS", "1" },
        { 0x0014, 0x5116,
          "Wedge In Contact Length", "WedgeInContactLength",  "DS", "1" },
        { 0x0014, 0x5117,
          "Wedge Front Gap", "WedgeFrontGap",  "DS", "1" },
        { 0x0014, 0x5118,
          "Wedge Total Height", "WedgeTotalHeight",  "DS", "1" },
        { 0x0014, 0x5119,
          "Wedge Front Height", "WedgeFrontHeight",  "DS", "1" },
        { 0x0014, 0x511a,
          "Wedge Rear Height", "WedgeRearHeight",  "DS", "1" },
        { 0x0014, 0x511b,
          "Wedge Total Width", "WedgeTotalWidth",  "DS", "1" },
        { 0x0014, 0x511c,
          "Wedge In Contact Width", "WedgeInContactWidth",  "DS", "1" },
        { 0x0014, 0x511d,
          "Wedge Chamfer Height", "WedgeChamferHeight",  "DS", "1" },
        { 0x0014, 0x511e,
          "Wedge Curve", "WedgeCurve",  "CS", "1" },
        { 0x0014, 0x511f,
          "Radius Along the Wedge", "RadiusAlongWedge",  "DS", "1" },
        { 0x0018, 0x0010,
          "Contrast/Bolus Agent", "ContrastBolusAgent",  "LO", "1" },
        { 0x0018, 0x0012,
          "Contrast/Bolus Agent Sequence", "ContrastBolusAgentSequence",  "SQ", "1" },
        { 0x0018, 0x0013,
          "Contrast/Bolus T1 Relaxivity", "ContrastBolusT1Relaxivity",  "FL", "1" },
        { 0x0018, 0x0014,
          "Contrast/Bolus Administration Route Sequence", "ContrastBolusAdministrationRouteSequence",  "SQ", "1" },
        { 0x0018, 0x0015,
          "Body Part Examined", "BodyPartExamined",  "CS", "1" },
        { 0x0018, 0x0020,
          "Scanning Sequence", "ScanningSequence",  "CS", "1-n" },
        { 0x0018, 0x0021,
          "Sequence Variant", "SequenceVariant",  "CS", "1-n" },
        { 0x0018, 0x0022,
          "Scan Options", "ScanOptions",  "CS", "1-n" },
        { 0x0018, 0x0023,
          "MR Acquisition Type", "MRAcquisitionType",  "CS", "1" },
        { 0x0018, 0x0024,
          "Sequence Name", "SequenceName",  "SH", "1" },
        { 0x0018, 0x0025,
          "Angio Flag", "AngioFlag",  "CS", "1" },
        { 0x0018, 0x0026,
          "Intervention Drug Information Sequence", "InterventionDrugInformationSequence",  "SQ", "1" },
        { 0x0018, 0x0027,
          "Intervention Drug Stop Time", "InterventionDrugStopTime",  "TM", "1" },
        { 0x0018, 0x0028,
          "Intervention Drug Dose", "InterventionDrugDose",  "DS", "1" },
        { 0x0018, 0x0029,
          "Intervention Drug Code Sequence", "InterventionDrugCodeSequence",  "SQ", "1" },
        { 0x0018, 0x002a,
          "Additional Drug Sequence", "AdditionalDrugSequence",  "SQ", "1" },
        { 0x0018, 0x0030,
          "Radionuclide", "Radionuclide",  "LO", "1-n" },
        { 0x0018, 0x0031,
          "Radiopharmaceutical", "Radiopharmaceutical",  "LO", "1" },
        { 0x0018, 0x0032,
          "Energy Window Centerline", "EnergyWindowCenterline",  "DS", "1" },
        { 0x0018, 0x0033,
          "Energy Window Total Width", "EnergyWindowTotalWidth",  "DS", "1-n" },
        { 0x0018, 0x0034,
          "Intervention Drug Name", "InterventionDrugName",  "LO", "1" },
        { 0x0018, 0x0035,
          "Intervention Drug Start Time", "InterventionDrugStartTime",  "TM", "1" },
        { 0x0018, 0x0036,
          "Intervention Sequence", "InterventionSequence",  "SQ", "1" },
        { 0x0018, 0x0037,
          "Therapy Type", "TherapyType",  "CS", "1" },
        { 0x0018, 0x0038,
          "Intervention Status", "InterventionStatus",  "CS", "1" },
        { 0x0018, 0x0039,
          "Therapy Description", "TherapyDescription",  "CS", "1" },
        { 0x0018, 0x003a,
          "Intervention Description", "InterventionDescription",  "ST", "1" },
        { 0x0018, 0x0040,
          "Cine Rate", "CineRate",  "IS", "1" },
        { 0x0018, 0x0042,
          "Initial Cine Run State", "InitialCineRunState",  "CS", "1" },
        { 0x0018, 0x0050,
          "Slice Thickness", "SliceThickness",  "DS", "1" },
        { 0x0018, 0x0060,
          "KVP", "KVP",  "DS", "1" },
        { 0x0018, 0x0070,
          "Counts Accumulated", "CountsAccumulated",  "IS", "1" },
        { 0x0018, 0x0071,
          "Acquisition Termination Condition", "AcquisitionTerminationCondition",  "CS", "1" },
        { 0x0018, 0x0072,
          "Effective Duration", "EffectiveDuration",  "DS", "1" },
        { 0x0018, 0x0073,
          "Acquisition Start Condition", "AcquisitionStartCondition",  "CS", "1" },
        { 0x0018, 0x0074,
          "Acquisition Start Condition Data", "AcquisitionStartConditionData",  "IS", "1" },
        { 0x0018, 0x0075,
          "Acquisition Termination Condition Data", "AcquisitionTerminationConditionData",  "IS", "1" },
        { 0x0018, 0x0080,
          "Repetition Time", "RepetitionTime",  "DS", "1" },
        { 0x0018, 0x0081,
          "Echo Time", "EchoTime",  "DS", "1" },
        { 0x0018, 0x0082,
          "Inversion Time", "InversionTime",  "DS", "1" },
        { 0x0018, 0x0083,
          "Number of Averages", "NumberOfAverages",  "DS", "1" },
        { 0x0018, 0x0084,
          "Imaging Frequency", "ImagingFrequency",  "DS", "1" },
        { 0x0018, 0x0085,
          "Imaged Nucleus", "ImagedNucleus",  "SH", "1" },
        { 0x0018, 0x0086,
          "Echo Number(s)", "EchoNumbers",  "IS", "1-n" },
        { 0x0018, 0x0087,
          "Magnetic Field Strength", "MagneticFieldStrength",  "DS", "1" },
        { 0x0018, 0x0088,
          "Spacing Between Slices", "SpacingBetweenSlices",  "DS", "1" },
        { 0x0018, 0x0089,
          "Number of Phase Encoding Steps", "NumberOfPhaseEncodingSteps",  "IS", "1" },
        { 0x0018, 0x0090,
          "Data Collection Diameter", "DataCollectionDiameter",  "DS", "1" },
        { 0x0018, 0x0091,
          "Echo Train Length", "EchoTrainLength",  "IS", "1" },
        { 0x0018, 0x0093,
          "Percent Sampling", "PercentSampling",  "DS", "1" },
        { 0x0018, 0x0094,
          "Percent Phase Field of View", "PercentPhaseFieldOfView",  "DS", "1" },
        { 0x0018, 0x0095,
          "Pixel Bandwidth", "PixelBandwidth",  "DS", "1" },
        { 0x0018, 0x1000,
          "Device Serial Number", "DeviceSerialNumber",  "LO", "1" },
        { 0x0018, 0x1002,
          "Device UID", "DeviceUID",  "UI", "1" },
        { 0x0018, 0x1003,
          "Device ID", "DeviceID",  "LO", "1" },
        { 0x0018, 0x1004,
          "Plate ID", "PlateID",  "LO", "1" },
        { 0x0018, 0x1005,
          "Generator ID", "GeneratorID",  "LO", "1" },
        { 0x0018, 0x1006,
          "Grid ID", "GridID",  "LO", "1" },
        { 0x0018, 0x1007,
          "Cassette ID", "CassetteID",  "LO", "1" },
        { 0x0018, 0x1008,
          "Gantry ID", "GantryID",  "LO", "1" },
        { 0x0018, 0x1010,
          "Secondary Capture Device ID", "SecondaryCaptureDeviceID",  "LO", "1" },
        { 0x0018, 0x1011,
          "Hardcopy Creation Device ID", "HardcopyCreationDeviceID",  "LO", "1" },
        { 0x0018, 0x1012,
          "Date of Secondary Capture", "DateOfSecondaryCapture",  "DA", "1" },
        { 0x0018, 0x1014,
          "Time of Secondary Capture", "TimeOfSecondaryCapture",  "TM", "1" },
        { 0x0018, 0x1016,
          "Secondary Capture Device Manufacturer", "SecondaryCaptureDeviceManufacturer",  "LO", "1" },
        { 0x0018, 0x1017,
          "Hardcopy Device Manufacturer", "HardcopyDeviceManufacturer",  "LO", "1" },
        { 0x0018, 0x1018,
          "Secondary Capture Device Manufacturer's Model Name", "SecondaryCaptureDeviceManufacturerModelName",  "LO", "1" },
        { 0x0018, 0x1019,
          "Secondary Capture Device Software Versions", "SecondaryCaptureDeviceSoftwareVersions",  "LO", "1-n" },
        { 0x0018, 0x101a,
          "Hardcopy Device Software Version", "HardcopyDeviceSoftwareVersion",  "LO", "1-n" },
        { 0x0018, 0x101b,
          "Hardcopy Device Manufacturer's Model Name", "HardcopyDeviceManufacturerModelName",  "LO", "1" },
        { 0x0018, 0x1020,
          "Software Version(s)", "SoftwareVersions",  "LO", "1-n" },
        { 0x0018, 0x1022,
          "Video Image Format Acquired", "VideoImageFormatAcquired",  "SH", "1" },
        { 0x0018, 0x1023,
          "Digital Image Format Acquired", "DigitalImageFormatAcquired",  "LO", "1" },
        { 0x0018, 0x1030,
          "Protocol Name", "ProtocolName",  "LO", "1" },
        { 0x0018, 0x1040,
          "Contrast/Bolus Route", "ContrastBolusRoute",  "LO", "1" },
        { 0x0018, 0x1041,
          "Contrast/Bolus Volume", "ContrastBolusVolume",  "DS", "1" },
        { 0x0018, 0x1042,
          "Contrast/Bolus Start Time", "ContrastBolusStartTime",  "TM", "1" },
        { 0x0018, 0x1043,
          "Contrast/Bolus Stop Time", "ContrastBolusStopTime",  "TM", "1" },
        { 0x0018, 0x1044,
          "Contrast/Bolus Total Dose", "ContrastBolusTotalDose",  "DS", "1" },
        { 0x0018, 0x1045,
          "Syringe Counts", "SyringeCounts",  "IS", "1" },
        { 0x0018, 0x1046,
          "Contrast Flow Rate", "ContrastFlowRate",  "DS", "1-n" },
        { 0x0018, 0x1047,
          "Contrast Flow Duration", "ContrastFlowDuration",  "DS", "1-n" },
        { 0x0018, 0x1048,
          "Contrast/Bolus Ingredient", "ContrastBolusIngredient",  "CS", "1" },
        { 0x0018, 0x1049,
          "Contrast/Bolus Ingredient Concentration", "ContrastBolusIngredientConcentration",  "DS", "1" },
        { 0x0018, 0x1050,
          "Spatial Resolution", "SpatialResolution",  "DS", "1" },
        { 0x0018, 0x1060,
          "Trigger Time", "TriggerTime",  "DS", "1" },
        { 0x0018, 0x1061,
          "Trigger Source or Type", "TriggerSourceOrType",  "LO", "1" },
        { 0x0018, 0x1062,
          "Nominal Interval", "NominalInterval",  "IS", "1" },
        { 0x0018, 0x1063,
          "Frame Time", "FrameTime",  "DS", "1" },
        { 0x0018, 0x1064,
          "Cardiac Framing Type", "CardiacFramingType",  "LO", "1" },
        { 0x0018, 0x1065,
          "Frame Time Vector", "FrameTimeVector",  "DS", "1-n" },
        { 0x0018, 0x1066,
          "Frame Delay", "FrameDelay",  "DS", "1" },
        { 0x0018, 0x1067,
          "Image Trigger Delay", "ImageTriggerDelay",  "DS", "1" },
        { 0x0018, 0x1068,
          "Multiplex Group Time Offset", "MultiplexGroupTimeOffset",  "DS", "1" },
        { 0x0018, 0x1069,
          "Trigger Time Offset", "TriggerTimeOffset",  "DS", "1" },
        { 0x0018, 0x106a,
          "Synchronization Trigger", "SynchronizationTrigger",  "CS", "1" },
        { 0x0018, 0x106c,
          "Synchronization Channel", "SynchronizationChannel",  "US", "2" },
        { 0x0018, 0x106e,
          "Trigger Sample Position", "TriggerSamplePosition",  "UL", "1" },
        { 0x0018, 0x1070,
          "Radiopharmaceutical Route", "RadiopharmaceuticalRoute",  "LO", "1" },
        { 0x0018, 0x1071,
          "Radiopharmaceutical Volume", "RadiopharmaceuticalVolume",  "DS", "1" },
        { 0x0018, 0x1072,
          "Radiopharmaceutical Start Time", "RadiopharmaceuticalStartTime",  "TM", "1" },
        { 0x0018, 0x1073,
          "Radiopharmaceutical Stop Time", "RadiopharmaceuticalStopTime",  "TM", "1" },
        { 0x0018, 0x1074,
          "Radionuclide Total Dose", "RadionuclideTotalDose",  "DS", "1" },
        { 0x0018, 0x1075,
          "Radionuclide Half Life", "RadionuclideHalfLife",  "DS", "1" },
        { 0x0018, 0x1076,
          "Radionuclide Positron Fraction", "RadionuclidePositronFraction",  "DS", "1" },
        { 0x0018, 0x1077,
          "Radiopharmaceutical Specific Activity", "RadiopharmaceuticalSpecificActivity",  "DS", "1" },
        { 0x0018, 0x1078,
          "Radiopharmaceutical Start DateTime", "RadiopharmaceuticalStartDateTime",  "DT", "1" },
        { 0x0018, 0x1079,
          "Radiopharmaceutical Stop DateTime", "RadiopharmaceuticalStopDateTime",  "DT", "1" },
        { 0x0018, 0x1080,
          "Beat Rejection Flag", "BeatRejectionFlag",  "CS", "1" },
        { 0x0018, 0x1081,
          "Low R-R Value", "LowRRValue",  "IS", "1" },
        { 0x0018, 0x1082,
          "High R-R Value", "HighRRValue",  "IS", "1" },
        { 0x0018, 0x1083,
          "Intervals Acquired", "IntervalsAcquired",  "IS", "1" },
        { 0x0018, 0x1084,
          "Intervals Rejected", "IntervalsRejected",  "IS", "1" },
        { 0x0018, 0x1085,
          "PVC Rejection", "PVCRejection",  "LO", "1" },
        { 0x0018, 0x1086,
          "Skip Beats", "SkipBeats",  "IS", "1" },
        { 0x0018, 0x1088,
          "Heart Rate", "HeartRate",  "IS", "1" },
        { 0x0018, 0x1090,
          "Cardiac Number of Images", "CardiacNumberOfImages",  "IS", "1" },
        { 0x0018, 0x1094,
          "Trigger Window", "TriggerWindow",  "IS", "1" },
        { 0x0018, 0x1100,
          "Reconstruction Diameter", "ReconstructionDiameter",  "DS", "1" },
        { 0x0018, 0x1110,
          "Distance Source to Detector", "DistanceSourceToDetector",  "DS", "1" },
        { 0x0018, 0x1111,
          "Distance Source to Patient", "DistanceSourceToPatient",  "DS", "1" },
        { 0x0018, 0x1114,
          "Estimated Radiographic Magnification Factor", "EstimatedRadiographicMagnificationFactor",  "DS", "1" },
        { 0x0018, 0x1120,
          "Gantry/Detector Tilt", "GantryDetectorTilt",  "DS", "1" },
        { 0x0018, 0x1121,
          "Gantry/Detector Slew", "GantryDetectorSlew",  "DS", "1" },
        { 0x0018, 0x1130,
          "Table Height", "TableHeight",  "DS", "1" },
        { 0x0018, 0x1131,
          "Table Traverse", "TableTraverse",  "DS", "1" },
        { 0x0018, 0x1134,
          "Table Motion", "TableMotion",  "CS", "1" },
        { 0x0018, 0x1135,
          "Table Vertical Increment", "TableVerticalIncrement",  "DS", "1-n" },
        { 0x0018, 0x1136,
          "Table Lateral Increment", "TableLateralIncrement",  "DS", "1-n" },
        { 0x0018, 0x1137,
          "Table Longitudinal Increment", "TableLongitudinalIncrement",  "DS", "1-n" },
        { 0x0018, 0x1138,
          "Table Angle", "TableAngle",  "DS", "1" },
        { 0x0018, 0x113a,
          "Table Type", "TableType",  "CS", "1" },
        { 0x0018, 0x1140,
          "Rotation Direction", "RotationDirection",  "CS", "1" },
        { 0x0018, 0x1141,
          "Angular Position", "AngularPosition",  "DS", "1" },
        { 0x0018, 0x1142,
          "Radial Position", "RadialPosition",  "DS", "1-n" },
        { 0x0018, 0x1143,
          "Scan Arc", "ScanArc",  "DS", "1" },
        { 0x0018, 0x1144,
          "Angular Step", "AngularStep",  "DS", "1" },
        { 0x0018, 0x1145,
          "Center of Rotation Offset", "CenterOfRotationOffset",  "DS", "1" },
        { 0x0018, 0x1146,
          "Rotation Offset", "RotationOffset",  "DS", "1-n" },
        { 0x0018, 0x1147,
          "Field of View Shape", "FieldOfViewShape",  "CS", "1" },
        { 0x0018, 0x1149,
          "Field of View Dimension(s)", "FieldOfViewDimensions",  "IS", "1-2" },
        { 0x0018, 0x1150,
          "Exposure Time", "ExposureTime",  "IS", "1" },
        { 0x0018, 0x1151,
          "X-Ray Tube Current", "XRayTubeCurrent",  "IS", "1" },
        { 0x0018, 0x1152,
          "Exposure", "Exposure",  "IS", "1" },
        { 0x0018, 0x1153,
          "Exposure in uAs", "ExposureInuAs",  "IS", "1" },
        { 0x0018, 0x1154,
          "Average Pulse Width", "AveragePulseWidth",  "DS", "1" },
        { 0x0018, 0x1155,
          "Radiation Setting", "RadiationSetting",  "CS", "1" },
        { 0x0018, 0x1156,
          "Rectification Type", "RectificationType",  "CS", "1" },
        { 0x0018, 0x115a,
          "Radiation Mode", "RadiationMode",  "CS", "1" },
        { 0x0018, 0x115e,
          "Image and Fluoroscopy Area Dose Product", "ImageAndFluoroscopyAreaDoseProduct",  "DS", "1" },
        { 0x0018, 0x1160,
          "Filter Type", "FilterType",  "SH", "1" },
        { 0x0018, 0x1161,
          "Type of Filters", "TypeOfFilters",  "LO", "1-n" },
        { 0x0018, 0x1162,
          "Intensifier Size", "IntensifierSize",  "DS", "1" },
        { 0x0018, 0x1164,
          "Imager Pixel Spacing", "ImagerPixelSpacing",  "DS", "2" },
        { 0x0018, 0x1166,
          "Grid", "Grid",  "CS", "1-n" },
        { 0x0018, 0x1170,
          "Generator Power", "GeneratorPower",  "IS", "1" },
        { 0x0018, 0x1180,
          "Collimator/grid Name", "CollimatorGridName",  "SH", "1" },
        { 0x0018, 0x1181,
          "Collimator Type", "CollimatorType",  "CS", "1" },
        { 0x0018, 0x1182,
          "Focal Distance", "FocalDistance",  "IS", "1-2" },
        { 0x0018, 0x1183,
          "X Focus Center", "XFocusCenter",  "DS", "1-2" },
        { 0x0018, 0x1184,
          "Y Focus Center", "YFocusCenter",  "DS", "1-2" },
        { 0x0018, 0x1190,
          "Focal Spot(s)", "FocalSpots",  "DS", "1-n" },
        { 0x0018, 0x1191,
          "Anode Target Material", "AnodeTargetMaterial",  "CS", "1" },
        { 0x0018, 0x11a0,
          "Body Part Thickness", "BodyPartThickness",  "DS", "1" },
        { 0x0018, 0x11a2,
          "Compression Force", "CompressionForce",  "DS", "1" },
        { 0x0018, 0x11a4,
          "Paddle Description", "PaddleDescription",  "LO", "1" },
        { 0x0018, 0x1200,
          "Date of Last Calibration", "DateOfLastCalibration",  "DA", "1-n" },
        { 0x0018, 0x1201,
          "Time of Last Calibration", "TimeOfLastCalibration",  "TM", "1-n" },
        { 0x0018, 0x1202,
          "DateTime of Last Calibration", "DateTimeOfLastCalibration",  "DT", "1" },
        { 0x0018, 0x1210,
          "Convolution Kernel", "ConvolutionKernel",  "SH", "1-n" },
        { 0x0018, 0x1240,
          "Upper/Lower Pixel Values", "UpperLowerPixelValues",  "IS", "1-n" },
        { 0x0018, 0x1242,
          "Actual Frame Duration", "ActualFrameDuration",  "IS", "1" },
        { 0x0018, 0x1243,
          "Count Rate", "CountRate",  "IS", "1" },
        { 0x0018, 0x1244,
          "Preferred Playback Sequencing", "PreferredPlaybackSequencing",  "US", "1" },
        { 0x0018, 0x1250,
          "Receive Coil Name", "ReceiveCoilName",  "SH", "1" },
        { 0x0018, 0x1251,
          "Transmit Coil Name", "TransmitCoilName",  "SH", "1" },
        { 0x0018, 0x1260,
          "Plate Type", "PlateType",  "SH", "1" },
        { 0x0018, 0x1261,
          "Phosphor Type", "PhosphorType",  "LO", "1" },
        { 0x0018, 0x1300,
          "Scan Velocity", "ScanVelocity",  "DS", "1" },
        { 0x0018, 0x1301,
          "Whole Body Technique", "WholeBodyTechnique",  "CS", "1-n" },
        { 0x0018, 0x1302,
          "Scan Length", "ScanLength",  "IS", "1" },
        { 0x0018, 0x1310,
          "Acquisition Matrix", "AcquisitionMatrix",  "US", "4" },
        { 0x0018, 0x1312,
          "In-plane Phase Encoding Direction", "InPlanePhaseEncodingDirection",  "CS", "1" },
        { 0x0018, 0x1314,
          "Flip Angle", "FlipAngle",  "DS", "1" },
        { 0x0018, 0x1315,
          "Variable Flip Angle Flag", "VariableFlipAngleFlag",  "CS", "1" },
        { 0x0018, 0x1316,
          "SAR", "SAR",  "DS", "1" },
        { 0x0018, 0x1318,
          "dB/dt", "dBdt",  "DS", "1" },
        { 0x0018, 0x1400,
          "Acquisition Device Processing Description", "AcquisitionDeviceProcessingDescription",  "LO", "1" },
        { 0x0018, 0x1401,
          "Acquisition Device Processing Code", "AcquisitionDeviceProcessingCode",  "LO", "1" },
        { 0x0018, 0x1402,
          "Cassette Orientation", "CassetteOrientation",  "CS", "1" },
        { 0x0018, 0x1403,
          "Cassette Size", "CassetteSize",  "CS", "1" },
        { 0x0018, 0x1404,
          "Exposures on Plate", "ExposuresOnPlate",  "US", "1" },
        { 0x0018, 0x1405,
          "Relative X-Ray Exposure", "RelativeXRayExposure",  "IS", "1" },
        { 0x0018, 0x1411,
          "Exposure Index", "ExposureIndex",  "DS", "1" },
        { 0x0018, 0x1412,
          "Target Exposure Index", "TargetExposureIndex",  "DS", "1" },
        { 0x0018, 0x1413,
          "Deviation Index", "DeviationIndex",  "DS", "1" },
        { 0x0018, 0x1450,
          "Column Angulation", "ColumnAngulation",  "DS", "1" },
        { 0x0018, 0x1460,
          "Tomo Layer Height", "TomoLayerHeight",  "DS", "1" },
        { 0x0018, 0x1470,
          "Tomo Angle", "TomoAngle",  "DS", "1" },
        { 0x0018, 0x1480,
          "Tomo Time", "TomoTime",  "DS", "1" },
        { 0x0018, 0x1490,
          "Tomo Type", "TomoType",  "CS", "1" },
        { 0x0018, 0x1491,
          "Tomo Class", "TomoClass",  "CS", "1" },
        { 0x0018, 0x1495,
          "Number of Tomosynthesis Source Images", "NumberOfTomosynthesisSourceImages",  "IS", "1" },
        { 0x0018, 0x1500,
          "Positioner Motion", "PositionerMotion",  "CS", "1" },
        { 0x0018, 0x1508,
          "Positioner Type", "PositionerType",  "CS", "1" },
        { 0x0018, 0x1510,
          "Positioner Primary Angle", "PositionerPrimaryAngle",  "DS", "1" },
        { 0x0018, 0x1511,
          "Positioner Secondary Angle", "PositionerSecondaryAngle",  "DS", "1" },
        { 0x0018, 0x1520,
          "Positioner Primary Angle Increment", "PositionerPrimaryAngleIncrement",  "DS", "1-n" },
        { 0x0018, 0x1521,
          "Positioner Secondary Angle Increment", "PositionerSecondaryAngleIncrement",  "DS", "1-n" },
        { 0x0018, 0x1530,
          "Detector Primary Angle", "DetectorPrimaryAngle",  "DS", "1" },
        { 0x0018, 0x1531,
          "Detector Secondary Angle", "DetectorSecondaryAngle",  "DS", "1" },
        { 0x0018, 0x1600,
          "Shutter Shape", "ShutterShape",  "CS", "1-3" },
        { 0x0018, 0x1602,
          "Shutter Left Vertical Edge", "ShutterLeftVerticalEdge",  "IS", "1" },
        { 0x0018, 0x1604,
          "Shutter Right Vertical Edge", "ShutterRightVerticalEdge",  "IS", "1" },
        { 0x0018, 0x1606,
          "Shutter Upper Horizontal Edge", "ShutterUpperHorizontalEdge",  "IS", "1" },
        { 0x0018, 0x1608,
          "Shutter Lower Horizontal Edge", "ShutterLowerHorizontalEdge",  "IS", "1" },
        { 0x0018, 0x1610,
          "Center of Circular Shutter", "CenterOfCircularShutter",  "IS", "2" },
        { 0x0018, 0x1612,
          "Radius of Circular Shutter", "RadiusOfCircularShutter",  "IS", "1" },
        { 0x0018, 0x1620,
          "Vertices of the Polygonal Shutter", "VerticesOfThePolygonalShutter",  "IS", "2-2n" },
        { 0x0018, 0x1622,
          "Shutter Presentation Value", "ShutterPresentationValue",  "US", "1" },
        { 0x0018, 0x1623,
          "Shutter Overlay Group", "ShutterOverlayGroup",  "US", "1" },
        { 0x0018, 0x1624,
          "Shutter Presentation Color CIELab Value", "ShutterPresentationColorCIELabValue",  "US", "3" },
        { 0x0018, 0x1700,
          "Collimator Shape", "CollimatorShape",  "CS", "1-3" },
        { 0x0018, 0x1702,
          "Collimator Left Vertical Edge", "CollimatorLeftVerticalEdge",  "IS", "1" },
        { 0x0018, 0x1704,
          "Collimator Right Vertical Edge", "CollimatorRightVerticalEdge",  "IS", "1" },
        { 0x0018, 0x1706,
          "Collimator Upper Horizontal Edge", "CollimatorUpperHorizontalEdge",  "IS", "1" },
        { 0x0018, 0x1708,
          "Collimator Lower Horizontal Edge", "CollimatorLowerHorizontalEdge",  "IS", "1" },
        { 0x0018, 0x1710,
          "Center of Circular Collimator", "CenterOfCircularCollimator",  "IS", "2" },
        { 0x0018, 0x1712,
          "Radius of Circular Collimator", "RadiusOfCircularCollimator",  "IS", "1" },
        { 0x0018, 0x1720,
          "Vertices of the Polygonal Collimator", "VerticesOfThePolygonalCollimator",  "IS", "2-2n" },
        { 0x0018, 0x1800,
          "Acquisition Time Synchronized", "AcquisitionTimeSynchronized",  "CS", "1" },
        { 0x0018, 0x1801,
          "Time Source", "TimeSource",  "SH", "1" },
        { 0x0018, 0x1802,
          "Time Distribution Protocol", "TimeDistributionProtocol",  "CS", "1" },
        { 0x0018, 0x1803,
          "NTP Source Address", "NTPSourceAddress",  "LO", "1" },
        { 0x0018, 0x2001,
          "Page Number Vector", "PageNumberVector",  "IS", "1-n" },
        { 0x0018, 0x2002,
          "Frame Label Vector", "FrameLabelVector",  "SH", "1-n" },
        { 0x0018, 0x2003,
          "Frame Primary Angle Vector", "FramePrimaryAngleVector",  "DS", "1-n" },
        { 0x0018, 0x2004,
          "Frame Secondary Angle Vector", "FrameSecondaryAngleVector",  "DS", "1-n" },
        { 0x0018, 0x2005,
          "Slice Location Vector", "SliceLocationVector",  "DS", "1-n" },
        { 0x0018, 0x2006,
          "Display Window Label Vector", "DisplayWindowLabelVector",  "SH", "1-n" },
        { 0x0018, 0x2010,
          "Nominal Scanned Pixel Spacing", "NominalScannedPixelSpacing",  "DS", "2" },
        { 0x0018, 0x2020,
          "Digitizing Device Transport Direction", "DigitizingDeviceTransportDirection",  "CS", "1" },
        { 0x0018, 0x2030,
          "Rotation of Scanned Film", "RotationOfScannedFilm",  "DS", "1" },
        { 0x0018, 0x2041,
          "Biopsy Target Sequence", "BiopsyTargetSequence",  "SQ", "1" },
        { 0x0018, 0x2042,
          "Target UID", "TargetUID",  "UI", "1" },
        { 0x0018, 0x2043,
          "Localizing Cursor Position", "LocalizingCursorPosition",  "FL", "2" },
        { 0x0018, 0x2044,
          "Calculated Target Position", "CalculatedTargetPosition",  "FL", "3" },
        { 0x0018, 0x2045,
          "Target Label", "TargetLabel",  "SH", "1" },
        { 0x0018, 0x2046,
          "Displayed Z Value", "DisplayedZValue",  "FL", "1" },
        { 0x0018, 0x3100,
          "IVUS Acquisition", "IVUSAcquisition",  "CS", "1" },
        { 0x0018, 0x3101,
          "IVUS Pullback Rate", "IVUSPullbackRate",  "DS", "1" },
        { 0x0018, 0x3102,
          "IVUS Gated Rate", "IVUSGatedRate",  "DS", "1" },
        { 0x0018, 0x3103,
          "IVUS Pullback Start Frame Number", "IVUSPullbackStartFrameNumber",  "IS", "1" },
        { 0x0018, 0x3104,
          "IVUS Pullback Stop Frame Number", "IVUSPullbackStopFrameNumber",  "IS", "1" },
        { 0x0018, 0x3105,
          "Lesion Number", "LesionNumber",  "IS", "1-n" },
        { 0x0018, 0x4000,
          "Acquisition Comments", "AcquisitionComments",  "LT", "1" },
        { 0x0018, 0x5000,
          "Output Power", "OutputPower",  "SH", "1-n" },
        { 0x0018, 0x5010,
          "Transducer Data", "TransducerData",  "LO", "1-n" },
        { 0x0018, 0x5012,
          "Focus Depth", "FocusDepth",  "DS", "1" },
        { 0x0018, 0x5020,
          "Processing Function", "ProcessingFunction",  "LO", "1" },
        { 0x0018, 0x5021,
          "Postprocessing Function", "PostprocessingFunction",  "LO", "1" },
        { 0x0018, 0x5022,
          "Mechanical Index", "MechanicalIndex",  "DS", "1" },
        { 0x0018, 0x5024,
          "Bone Thermal Index", "BoneThermalIndex",  "DS", "1" },
        { 0x0018, 0x5026,
          "Cranial Thermal Index", "CranialThermalIndex",  "DS", "1" },
        { 0x0018, 0x5027,
          "Soft Tissue Thermal Index", "SoftTissueThermalIndex",  "DS", "1" },
        { 0x0018, 0x5028,
          "Soft Tissue-focus Thermal Index", "SoftTissueFocusThermalIndex",  "DS", "1" },
        { 0x0018, 0x5029,
          "Soft Tissue-surface Thermal Index", "SoftTissueSurfaceThermalIndex",  "DS", "1" },
        { 0x0018, 0x5030,
          "Dynamic Range", "DynamicRange",  "DS", "1" },
        { 0x0018, 0x5040,
          "Total Gain", "TotalGain",  "DS", "1" },
        { 0x0018, 0x5050,
          "Depth of Scan Field", "DepthOfScanField",  "IS", "1" },
        { 0x0018, 0x5100,
          "Patient Position", "PatientPosition",  "CS", "1" },
        { 0x0018, 0x5101,
          "View Position", "ViewPosition",  "CS", "1" },
        { 0x0018, 0x5104,
          "Projection Eponymous Name Code Sequence", "ProjectionEponymousNameCodeSequence",  "SQ", "1" },
        { 0x0018, 0x5210,
          "Image Transformation Matrix", "ImageTransformationMatrix",  "DS", "6" },
        { 0x0018, 0x5212,
          "Image Translation Vector", "ImageTranslationVector",  "DS", "3" },
        { 0x0018, 0x6000,
          "Sensitivity", "Sensitivity",  "DS", "1" },
        { 0x0018, 0x6011,
          "Sequence of Ultrasound Regions", "SequenceOfUltrasoundRegions",  "SQ", "1" },
        { 0x0018, 0x6012,
          "Region Spatial Format", "RegionSpatialFormat",  "US", "1" },
        { 0x0018, 0x6014,
          "Region Data Type", "RegionDataType",  "US", "1" },
        { 0x0018, 0x6016,
          "Region Flags", "RegionFlags",  "UL", "1" },
        { 0x0018, 0x6018,
          "Region Location Min X0", "RegionLocationMinX0",  "UL", "1" },
        { 0x0018, 0x601a,
          "Region Location Min Y0", "RegionLocationMinY0",  "UL", "1" },
        { 0x0018, 0x601c,
          "Region Location Max X1", "RegionLocationMaxX1",  "UL", "1" },
        { 0x0018, 0x601e,
          "Region Location Max Y1", "RegionLocationMaxY1",  "UL", "1" },
        { 0x0018, 0x6020,
          "Reference Pixel X0", "ReferencePixelX0",  "SL", "1" },
        { 0x0018, 0x6022,
          "Reference Pixel Y0", "ReferencePixelY0",  "SL", "1" },
        { 0x0018, 0x6024,
          "Physical Units X Direction", "PhysicalUnitsXDirection",  "US", "1" },
        { 0x0018, 0x6026,
          "Physical Units Y Direction", "PhysicalUnitsYDirection",  "US", "1" },
        { 0x0018, 0x6028,
          "Reference Pixel Physical Value X", "ReferencePixelPhysicalValueX",  "FD", "1" },
        { 0x0018, 0x602a,
          "Reference Pixel Physical Value Y", "ReferencePixelPhysicalValueY",  "FD", "1" },
        { 0x0018, 0x602c,
          "Physical Delta X", "PhysicalDeltaX",  "FD", "1" },
        { 0x0018, 0x602e,
          "Physical Delta Y", "PhysicalDeltaY",  "FD", "1" },
        { 0x0018, 0x6030,
          "Transducer Frequency", "TransducerFrequency",  "UL", "1" },
        { 0x0018, 0x6031,
          "Transducer Type", "TransducerType",  "CS", "1" },
        { 0x0018, 0x6032,
          "Pulse Repetition Frequency", "PulseRepetitionFrequency",  "UL", "1" },
        { 0x0018, 0x6034,
          "Doppler Correction Angle", "DopplerCorrectionAngle",  "FD", "1" },
        { 0x0018, 0x6036,
          "Steering Angle", "SteeringAngle",  "FD", "1" },
        { 0x0018, 0x6038,
          "Doppler Sample Volume X Position (Retired)", "DopplerSampleVolumeXPositionRetired",  "UL", "1" },
        { 0x0018, 0x6039,
          "Doppler Sample Volume X Position", "DopplerSampleVolumeXPosition",  "SL", "1" },
        { 0x0018, 0x603a,
          "Doppler Sample Volume Y Position (Retired)", "DopplerSampleVolumeYPositionRetired",  "UL", "1" },
        { 0x0018, 0x603b,
          "Doppler Sample Volume Y Position", "DopplerSampleVolumeYPosition",  "SL", "1" },
        { 0x0018, 0x603c,
          "TM-Line Position X0 (Retired)", "TMLinePositionX0Retired",  "UL", "1" },
        { 0x0018, 0x603d,
          "TM-Line Position X0", "TMLinePositionX0",  "SL", "1" },
        { 0x0018, 0x603e,
          "TM-Line Position Y0 (Retired)", "TMLinePositionY0Retired",  "UL", "1" },
        { 0x0018, 0x603f,
          "TM-Line Position Y0", "TMLinePositionY0",  "SL", "1" },
        { 0x0018, 0x6040,
          "TM-Line Position X1 (Retired)", "TMLinePositionX1Retired",  "UL", "1" },
        { 0x0018, 0x6041,
          "TM-Line Position X1", "TMLinePositionX1",  "SL", "1" },
        { 0x0018, 0x6042,
          "TM-Line Position Y1 (Retired)", "TMLinePositionY1Retired",  "UL", "1" },
        { 0x0018, 0x6043,
          "TM-Line Position Y1", "TMLinePositionY1",  "SL", "1" },
        { 0x0018, 0x6044,
          "Pixel Component Organization", "PixelComponentOrganization",  "US", "1" },
        { 0x0018, 0x6046,
          "Pixel Component Mask", "PixelComponentMask",  "UL", "1" },
        { 0x0018, 0x6048,
          "Pixel Component Range Start", "PixelComponentRangeStart",  "UL", "1" },
        { 0x0018, 0x604a,
          "Pixel Component Range Stop", "PixelComponentRangeStop",  "UL", "1" },
        { 0x0018, 0x604c,
          "Pixel Component Physical Units", "PixelComponentPhysicalUnits",  "US", "1" },
        { 0x0018, 0x604e,
          "Pixel Component Data Type", "PixelComponentDataType",  "US", "1" },
        { 0x0018, 0x6050,
          "Number of Table Break Points", "NumberOfTableBreakPoints",  "UL", "1" },
        { 0x0018, 0x6052,
          "Table of X Break Points", "TableOfXBreakPoints",  "UL", "1-n" },
        { 0x0018, 0x6054,
          "Table of Y Break Points", "TableOfYBreakPoints",  "FD", "1-n" },
        { 0x0018, 0x6056,
          "Number of Table Entries", "NumberOfTableEntries",  "UL", "1" },
        { 0x0018, 0x6058,
          "Table of Pixel Values", "TableOfPixelValues",  "UL", "1-n" },
        { 0x0018, 0x605a,
          "Table of Parameter Values", "TableOfParameterValues",  "FL", "1-n" },
        { 0x0018, 0x6060,
          "R Wave Time Vector", "RWaveTimeVector",  "FL", "1-n" },
        { 0x0018, 0x7000,
          "Detector Conditions Nominal Flag", "DetectorConditionsNominalFlag",  "CS", "1" },
        { 0x0018, 0x7001,
          "Detector Temperature", "DetectorTemperature",  "DS", "1" },
        { 0x0018, 0x7004,
          "Detector Type", "DetectorType",  "CS", "1" },
        { 0x0018, 0x7005,
          "Detector Configuration", "DetectorConfiguration",  "CS", "1" },
        { 0x0018, 0x7006,
          "Detector Description", "DetectorDescription",  "LT", "1" },
        { 0x0018, 0x7008,
          "Detector Mode", "DetectorMode",  "LT", "1" },
        { 0x0018, 0x700a,
          "Detector ID", "DetectorID",  "SH", "1" },
        { 0x0018, 0x700c,
          "Date of Last Detector Calibration", "DateOfLastDetectorCalibration",  "DA", "1" },
        { 0x0018, 0x700e,
          "Time of Last Detector Calibration", "TimeOfLastDetectorCalibration",  "TM", "1" },
        { 0x0018, 0x7010,
          "Exposures on Detector Since Last Calibration", "ExposuresOnDetectorSinceLastCalibration",  "IS", "1" },
        { 0x0018, 0x7011,
          "Exposures on Detector Since Manufactured", "ExposuresOnDetectorSinceManufactured",  "IS", "1" },
        { 0x0018, 0x7012,
          "Detector Time Since Last Exposure", "DetectorTimeSinceLastExposure",  "DS", "1" },
        { 0x0018, 0x7014,
          "Detector Active Time", "DetectorActiveTime",  "DS", "1" },
        { 0x0018, 0x7016,
          "Detector Activation Offset From Exposure", "DetectorActivationOffsetFromExposure",  "DS", "1" },
        { 0x0018, 0x701a,
          "Detector Binning", "DetectorBinning",  "DS", "2" },
        { 0x0018, 0x7020,
          "Detector Element Physical Size", "DetectorElementPhysicalSize",  "DS", "2" },
        { 0x0018, 0x7022,
          "Detector Element Spacing", "DetectorElementSpacing",  "DS", "2" },
        { 0x0018, 0x7024,
          "Detector Active Shape", "DetectorActiveShape",  "CS", "1" },
        { 0x0018, 0x7026,
          "Detector Active Dimension(s)", "DetectorActiveDimensions",  "DS", "1-2" },
        { 0x0018, 0x7028,
          "Detector Active Origin", "DetectorActiveOrigin",  "DS", "2" },
        { 0x0018, 0x702a,
          "Detector Manufacturer Name", "DetectorManufacturerName",  "LO", "1" },
        { 0x0018, 0x702b,
          "Detector Manufacturer's Model Name", "DetectorManufacturerModelName",  "LO", "1" },
        { 0x0018, 0x7030,
          "Field of View Origin", "FieldOfViewOrigin",  "DS", "2" },
        { 0x0018, 0x7032,
          "Field of View Rotation", "FieldOfViewRotation",  "DS", "1" },
        { 0x0018, 0x7034,
          "Field of View Horizontal Flip", "FieldOfViewHorizontalFlip",  "CS", "1" },
        { 0x0018, 0x7036,
          "Pixel Data Area Origin Relative To FOV", "PixelDataAreaOriginRelativeToFOV",  "FL", "2" },
        { 0x0018, 0x7038,
          "Pixel Data Area Rotation Angle Relative To FOV", "PixelDataAreaRotationAngleRelativeToFOV",  "FL", "1" },
        { 0x0018, 0x7040,
          "Grid Absorbing Material", "GridAbsorbingMaterial",  "LT", "1" },
        { 0x0018, 0x7041,
          "Grid Spacing Material", "GridSpacingMaterial",  "LT", "1" },
        { 0x0018, 0x7042,
          "Grid Thickness", "GridThickness",  "DS", "1" },
        { 0x0018, 0x7044,
          "Grid Pitch", "GridPitch",  "DS", "1" },
        { 0x0018, 0x7046,
          "Grid Aspect Ratio", "GridAspectRatio",  "IS", "2" },
        { 0x0018, 0x7048,
          "Grid Period", "GridPeriod",  "DS", "1" },
        { 0x0018, 0x704c,
          "Grid Focal Distance", "GridFocalDistance",  "DS", "1" },
        { 0x0018, 0x7050,
          "Filter Material", "FilterMaterial",  "CS", "1-n" },
        { 0x0018, 0x7052,
          "Filter Thickness Minimum", "FilterThicknessMinimum",  "DS", "1-n" },
        { 0x0018, 0x7054,
          "Filter Thickness Maximum", "FilterThicknessMaximum",  "DS", "1-n" },
        { 0x0018, 0x7056,
          "Filter Beam Path Length Minimum", "FilterBeamPathLengthMinimum",  "FL", "1-n" },
        { 0x0018, 0x7058,
          "Filter Beam Path Length Maximum", "FilterBeamPathLengthMaximum",  "FL", "1-n" },
        { 0x0018, 0x7060,
          "Exposure Control Mode", "ExposureControlMode",  "CS", "1" },
        { 0x0018, 0x7062,
          "Exposure Control Mode Description", "ExposureControlModeDescription",  "LT", "1" },
        { 0x0018, 0x7064,
          "Exposure Status", "ExposureStatus",  "CS", "1" },
        { 0x0018, 0x7065,
          "Phototimer Setting", "PhototimerSetting",  "DS", "1" },
        { 0x0018, 0x8150,
          "Exposure Time in uS", "ExposureTimeInuS",  "DS", "1" },
        { 0x0018, 0x8151,
          "X-Ray Tube Current in uA", "XRayTubeCurrentInuA",  "DS", "1" },
        { 0x0018, 0x9004,
          "Content Qualification", "ContentQualification",  "CS", "1" },
        { 0x0018, 0x9005,
          "Pulse Sequence Name", "PulseSequenceName",  "SH", "1" },
        { 0x0018, 0x9006,
          "MR Imaging Modifier Sequence", "MRImagingModifierSequence",  "SQ", "1" },
        { 0x0018, 0x9008,
          "Echo Pulse Sequence", "EchoPulseSequence",  "CS", "1" },
        { 0x0018, 0x9009,
          "Inversion Recovery", "InversionRecovery",  "CS", "1" },
        { 0x0018, 0x9010,
          "Flow Compensation", "FlowCompensation",  "CS", "1" },
        { 0x0018, 0x9011,
          "Multiple Spin Echo", "MultipleSpinEcho",  "CS", "1" },
        { 0x0018, 0x9012,
          "Multi-planar Excitation", "MultiPlanarExcitation",  "CS", "1" },
        { 0x0018, 0x9014,
          "Phase Contrast", "PhaseContrast",  "CS", "1" },
        { 0x0018, 0x9015,
          "Time of Flight Contrast", "TimeOfFlightContrast",  "CS", "1" },
        { 0x0018, 0x9016,
          "Spoiling", "Spoiling",  "CS", "1" },
        { 0x0018, 0x9017,
          "Steady State Pulse Sequence", "SteadyStatePulseSequence",  "CS", "1" },
        { 0x0018, 0x9018,
          "Echo Planar Pulse Sequence", "EchoPlanarPulseSequence",  "CS", "1" },
        { 0x0018, 0x9019,
          "Tag Angle First Axis", "TagAngleFirstAxis",  "FD", "1" },
        { 0x0018, 0x9020,
          "Magnetization Transfer", "MagnetizationTransfer",  "CS", "1" },
        { 0x0018, 0x9021,
          "T2 Preparation", "T2Preparation",  "CS", "1" },
        { 0x0018, 0x9022,
          "Blood Signal Nulling", "BloodSignalNulling",  "CS", "1" },
        { 0x0018, 0x9024,
          "Saturation Recovery", "SaturationRecovery",  "CS", "1" },
        { 0x0018, 0x9025,
          "Spectrally Selected Suppression", "SpectrallySelectedSuppression",  "CS", "1" },
        { 0x0018, 0x9026,
          "Spectrally Selected Excitation", "SpectrallySelectedExcitation",  "CS", "1" },
        { 0x0018, 0x9027,
          "Spatial Pre-saturation", "SpatialPresaturation",  "CS", "1" },
        { 0x0018, 0x9028,
          "Tagging", "Tagging",  "CS", "1" },
        { 0x0018, 0x9029,
          "Oversampling Phase", "OversamplingPhase",  "CS", "1" },
        { 0x0018, 0x9030,
          "Tag Spacing First Dimension", "TagSpacingFirstDimension",  "FD", "1" },
        { 0x0018, 0x9032,
          "Geometry of k-Space Traversal", "GeometryOfKSpaceTraversal",  "CS", "1" },
        { 0x0018, 0x9033,
          "Segmented k-Space Traversal", "SegmentedKSpaceTraversal",  "CS", "1" },
        { 0x0018, 0x9034,
          "Rectilinear Phase Encode Reordering", "RectilinearPhaseEncodeReordering",  "CS", "1" },
        { 0x0018, 0x9035,
          "Tag Thickness", "TagThickness",  "FD", "1" },
        { 0x0018, 0x9036,
          "Partial Fourier Direction", "PartialFourierDirection",  "CS", "1" },
        { 0x0018, 0x9037,
          "Cardiac Synchronization Technique", "CardiacSynchronizationTechnique",  "CS", "1" },
        { 0x0018, 0x9041,
          "Receive Coil Manufacturer Name", "ReceiveCoilManufacturerName",  "LO", "1" },
        { 0x0018, 0x9042,
          "MR Receive Coil Sequence", "MRReceiveCoilSequence",  "SQ", "1" },
        { 0x0018, 0x9043,
          "Receive Coil Type", "ReceiveCoilType",  "CS", "1" },
        { 0x0018, 0x9044,
          "Quadrature Receive Coil", "QuadratureReceiveCoil",  "CS", "1" },
        { 0x0018, 0x9045,
          "Multi-Coil Definition Sequence", "MultiCoilDefinitionSequence",  "SQ", "1" },
        { 0x0018, 0x9046,
          "Multi-Coil Configuration", "MultiCoilConfiguration",  "LO", "1" },
        { 0x0018, 0x9047,
          "Multi-Coil Element Name", "MultiCoilElementName",  "SH", "1" },
        { 0x0018, 0x9048,
          "Multi-Coil Element Used", "MultiCoilElementUsed",  "CS", "1" },
        { 0x0018, 0x9049,
          "MR Transmit Coil Sequence", "MRTransmitCoilSequence",  "SQ", "1" },
        { 0x0018, 0x9050,
          "Transmit Coil Manufacturer Name", "TransmitCoilManufacturerName",  "LO", "1" },
        { 0x0018, 0x9051,
          "Transmit Coil Type", "TransmitCoilType",  "CS", "1" },
        { 0x0018, 0x9052,
          "Spectral Width", "SpectralWidth",  "FD", "1-2" },
        { 0x0018, 0x9053,
          "Chemical Shift Reference", "ChemicalShiftReference",  "FD", "1-2" },
        { 0x0018, 0x9054,
          "Volume Localization Technique", "VolumeLocalizationTechnique",  "CS", "1" },
        { 0x0018, 0x9058,
          "MR Acquisition Frequency Encoding Steps", "MRAcquisitionFrequencyEncodingSteps",  "US", "1" },
        { 0x0018, 0x9059,
          "De-coupling", "Decoupling",  "CS", "1" },
        { 0x0018, 0x9060,
          "De-coupled Nucleus", "DecoupledNucleus",  "CS", "1-2" },
        { 0x0018, 0x9061,
          "De-coupling Frequency", "DecouplingFrequency",  "FD", "1-2" },
        { 0x0018, 0x9062,
          "De-coupling Method", "DecouplingMethod",  "CS", "1" },
        { 0x0018, 0x9063,
          "De-coupling Chemical Shift Reference", "DecouplingChemicalShiftReference",  "FD", "1-2" },
        { 0x0018, 0x9064,
          "k-space Filtering", "KSpaceFiltering",  "CS", "1" },
        { 0x0018, 0x9065,
          "Time Domain Filtering", "TimeDomainFiltering",  "CS", "1-2" },
        { 0x0018, 0x9066,
          "Number of Zero Fills", "NumberOfZeroFills",  "US", "1-2" },
        { 0x0018, 0x9067,
          "Baseline Correction", "BaselineCorrection",  "CS", "1" },
        { 0x0018, 0x9069,
          "Parallel Reduction Factor In-plane", "ParallelReductionFactorInPlane",  "FD", "1" },
        { 0x0018, 0x9070,
          "Cardiac R-R Interval Specified", "CardiacRRIntervalSpecified",  "FD", "1" },
        { 0x0018, 0x9073,
          "Acquisition Duration", "AcquisitionDuration",  "FD", "1" },
        { 0x0018, 0x9074,
          "Frame Acquisition DateTime", "FrameAcquisitionDateTime",  "DT", "1" },
        { 0x0018, 0x9075,
          "Diffusion Directionality", "DiffusionDirectionality",  "CS", "1" },
        { 0x0018, 0x9076,
          "Diffusion Gradient Direction Sequence", "DiffusionGradientDirectionSequence",  "SQ", "1" },
        { 0x0018, 0x9077,
          "Parallel Acquisition", "ParallelAcquisition",  "CS", "1" },
        { 0x0018, 0x9078,
          "Parallel Acquisition Technique", "ParallelAcquisitionTechnique",  "CS", "1" },
        { 0x0018, 0x9079,
          "Inversion Times", "InversionTimes",  "FD", "1-n" },
        { 0x0018, 0x9080,
          "Metabolite Map Description", "MetaboliteMapDescription",  "ST", "1" },
        { 0x0018, 0x9081,
          "Partial Fourier", "PartialFourier",  "CS", "1" },
        { 0x0018, 0x9082,
          "Effective Echo Time", "EffectiveEchoTime",  "FD", "1" },
        { 0x0018, 0x9083,
          "Metabolite Map Code Sequence", "MetaboliteMapCodeSequence",  "SQ", "1" },
        { 0x0018, 0x9084,
          "Chemical Shift Sequence", "ChemicalShiftSequence",  "SQ", "1" },
        { 0x0018, 0x9085,
          "Cardiac Signal Source", "CardiacSignalSource",  "CS", "1" },
        { 0x0018, 0x9087,
          "Diffusion b-value", "DiffusionBValue",  "FD", "1" },
        { 0x0018, 0x9089,
          "Diffusion Gradient Orientation", "DiffusionGradientOrientation",  "FD", "3" },
        { 0x0018, 0x9090,
          "Velocity Encoding Direction", "VelocityEncodingDirection",  "FD", "3" },
        { 0x0018, 0x9091,
          "Velocity Encoding Minimum Value", "VelocityEncodingMinimumValue",  "FD", "1" },
        { 0x0018, 0x9092,
          "Velocity Encoding Acquisition Sequence", "VelocityEncodingAcquisitionSequence",  "SQ", "1" },
        { 0x0018, 0x9093,
          "Number of k-Space Trajectories", "NumberOfKSpaceTrajectories",  "US", "1" },
        { 0x0018, 0x9094,
          "Coverage of k-Space", "CoverageOfKSpace",  "CS", "1" },
        { 0x0018, 0x9095,
          "Spectroscopy Acquisition Phase Rows", "SpectroscopyAcquisitionPhaseRows",  "UL", "1" },
        { 0x0018, 0x9096,
          "Parallel Reduction Factor In-plane (Retired)", "ParallelReductionFactorInPlaneRetired",  "FD", "1" },
        { 0x0018, 0x9098,
          "Transmitter Frequency", "TransmitterFrequency",  "FD", "1-2" },
        { 0x0018, 0x9100,
          "Resonant Nucleus", "ResonantNucleus",  "CS", "1-2" },
        { 0x0018, 0x9101,
          "Frequency Correction", "FrequencyCorrection",  "CS", "1" },
        { 0x0018, 0x9103,
          "MR Spectroscopy FOV/Geometry Sequence", "MRSpectroscopyFOVGeometrySequence",  "SQ", "1" },
        { 0x0018, 0x9104,
          "Slab Thickness", "SlabThickness",  "FD", "1" },
        { 0x0018, 0x9105,
          "Slab Orientation", "SlabOrientation",  "FD", "3" },
        { 0x0018, 0x9106,
          "Mid Slab Position", "MidSlabPosition",  "FD", "3" },
        { 0x0018, 0x9107,
          "MR Spatial Saturation Sequence", "MRSpatialSaturationSequence",  "SQ", "1" },
        { 0x0018, 0x9112,
          "MR Timing and Related Parameters Sequence", "MRTimingAndRelatedParametersSequence",  "SQ", "1" },
        { 0x0018, 0x9114,
          "MR Echo Sequence", "MREchoSequence",  "SQ", "1" },
        { 0x0018, 0x9115,
          "MR Modifier Sequence", "MRModifierSequence",  "SQ", "1" },
        { 0x0018, 0x9117,
          "MR Diffusion Sequence", "MRDiffusionSequence",  "SQ", "1" },
        { 0x0018, 0x9118,
          "Cardiac Synchronization Sequence", "CardiacSynchronizationSequence",  "SQ", "1" },
        { 0x0018, 0x9119,
          "MR Averages Sequence", "MRAveragesSequence",  "SQ", "1" },
        { 0x0018, 0x9125,
          "MR FOV/Geometry Sequence", "MRFOVGeometrySequence",  "SQ", "1" },
        { 0x0018, 0x9126,
          "Volume Localization Sequence", "VolumeLocalizationSequence",  "SQ", "1" },
        { 0x0018, 0x9127,
          "Spectroscopy Acquisition Data Columns", "SpectroscopyAcquisitionDataColumns",  "UL", "1" },
        { 0x0018, 0x9147,
          "Diffusion Anisotropy Type", "DiffusionAnisotropyType",  "CS", "1" },
        { 0x0018, 0x9151,
          "Frame Reference DateTime", "FrameReferenceDateTime",  "DT", "1" },
        { 0x0018, 0x9152,
          "MR Metabolite Map Sequence", "MRMetaboliteMapSequence",  "SQ", "1" },
        { 0x0018, 0x9155,
          "Parallel Reduction Factor out-of-plane", "ParallelReductionFactorOutOfPlane",  "FD", "1" },
        { 0x0018, 0x9159,
          "Spectroscopy Acquisition Out-of-plane Phase Steps", "SpectroscopyAcquisitionOutOfPlanePhaseSteps",  "UL", "1" },
        { 0x0018, 0x9166,
          "Bulk Motion Status", "BulkMotionStatus",  "CS", "1" },
        { 0x0018, 0x9168,
          "Parallel Reduction Factor Second In-plane", "ParallelReductionFactorSecondInPlane",  "FD", "1" },
        { 0x0018, 0x9169,
          "Cardiac Beat Rejection Technique", "CardiacBeatRejectionTechnique",  "CS", "1" },
        { 0x0018, 0x9170,
          "Respiratory Motion Compensation Technique", "RespiratoryMotionCompensationTechnique",  "CS", "1" },
        { 0x0018, 0x9171,
          "Respiratory Signal Source", "RespiratorySignalSource",  "CS", "1" },
        { 0x0018, 0x9172,
          "Bulk Motion Compensation Technique", "BulkMotionCompensationTechnique",  "CS", "1" },
        { 0x0018, 0x9173,
          "Bulk Motion Signal Source", "BulkMotionSignalSource",  "CS", "1" },
        { 0x0018, 0x9174,
          "Applicable Safety Standard Agency", "ApplicableSafetyStandardAgency",  "CS", "1" },
        { 0x0018, 0x9175,
          "Applicable Safety Standard Description", "ApplicableSafetyStandardDescription",  "LO", "1" },
        { 0x0018, 0x9176,
          "Operating Mode Sequence", "OperatingModeSequence",  "SQ", "1" },
        { 0x0018, 0x9177,
          "Operating Mode Type", "OperatingModeType",  "CS", "1" },
        { 0x0018, 0x9178,
          "Operating Mode", "OperatingMode",  "CS", "1" },
        { 0x0018, 0x9179,
          "Specific Absorption Rate Definition", "SpecificAbsorptionRateDefinition",  "CS", "1" },
        { 0x0018, 0x9180,
          "Gradient Output Type", "GradientOutputType",  "CS", "1" },
        { 0x0018, 0x9181,
          "Specific Absorption Rate Value", "SpecificAbsorptionRateValue",  "FD", "1" },
        { 0x0018, 0x9182,
          "Gradient Output", "GradientOutput",  "FD", "1" },
        { 0x0018, 0x9183,
          "Flow Compensation Direction", "FlowCompensationDirection",  "CS", "1" },
        { 0x0018, 0x9184,
          "Tagging Delay", "TaggingDelay",  "FD", "1" },
        { 0x0018, 0x9185,
          "Respiratory Motion Compensation Technique Description", "RespiratoryMotionCompensationTechniqueDescription",  "ST", "1" },
        { 0x0018, 0x9186,
          "Respiratory Signal Source ID", "RespiratorySignalSourceID",  "SH", "1" },
        { 0x0018, 0x9195,
          "Chemical Shift Minimum Integration Limit in Hz", "ChemicalShiftMinimumIntegrationLimitInHz",  "FD", "1" },
        { 0x0018, 0x9196,
          "Chemical Shift Maximum Integration Limit in Hz", "ChemicalShiftMaximumIntegrationLimitInHz",  "FD", "1" },
        { 0x0018, 0x9197,
          "MR Velocity Encoding Sequence", "MRVelocityEncodingSequence",  "SQ", "1" },
        { 0x0018, 0x9198,
          "First Order Phase Correction", "FirstOrderPhaseCorrection",  "CS", "1" },
        { 0x0018, 0x9199,
          "Water Referenced Phase Correction", "WaterReferencedPhaseCorrection",  "CS", "1" },
        { 0x0018, 0x9200,
          "MR Spectroscopy Acquisition Type", "MRSpectroscopyAcquisitionType",  "CS", "1" },
        { 0x0018, 0x9214,
          "Respiratory Cycle Position", "RespiratoryCyclePosition",  "CS", "1" },
        { 0x0018, 0x9217,
          "Velocity Encoding Maximum Value", "VelocityEncodingMaximumValue",  "FD", "1" },
        { 0x0018, 0x9218,
          "Tag Spacing Second Dimension", "TagSpacingSecondDimension",  "FD", "1" },
        { 0x0018, 0x9219,
          "Tag Angle Second Axis", "TagAngleSecondAxis",  "SS", "1" },
        { 0x0018, 0x9220,
          "Frame Acquisition Duration", "FrameAcquisitionDuration",  "FD", "1" },
        { 0x0018, 0x9226,
          "MR Image Frame Type Sequence", "MRImageFrameTypeSequence",  "SQ", "1" },
        { 0x0018, 0x9227,
          "MR Spectroscopy Frame Type Sequence", "MRSpectroscopyFrameTypeSequence",  "SQ", "1" },
        { 0x0018, 0x9231,
          "MR Acquisition Phase Encoding Steps in-plane", "MRAcquisitionPhaseEncodingStepsInPlane",  "US", "1" },
        { 0x0018, 0x9232,
          "MR Acquisition Phase Encoding Steps out-of-plane", "MRAcquisitionPhaseEncodingStepsOutOfPlane",  "US", "1" },
        { 0x0018, 0x9234,
          "Spectroscopy Acquisition Phase Columns", "SpectroscopyAcquisitionPhaseColumns",  "UL", "1" },
        { 0x0018, 0x9236,
          "Cardiac Cycle Position", "CardiacCyclePosition",  "CS", "1" },
        { 0x0018, 0x9239,
          "Specific Absorption Rate Sequence", "SpecificAbsorptionRateSequence",  "SQ", "1" },
        { 0x0018, 0x9240,
          "RF Echo Train Length", "RFEchoTrainLength",  "US", "1" },
        { 0x0018, 0x9241,
          "Gradient Echo Train Length", "GradientEchoTrainLength",  "US", "1" },
        { 0x0018, 0x9250,
          "Arterial Spin Labeling Contrast", "ArterialSpinLabelingContrast",  "CS", "1" },
        { 0x0018, 0x9251,
          "MR Arterial Spin Labeling Sequence", "MRArterialSpinLabelingSequence",  "SQ", "1" },
        { 0x0018, 0x9252,
          "ASL Technique Description", "ASLTechniqueDescription",  "LO", "1" },
        { 0x0018, 0x9253,
          "ASL Slab Number", "ASLSlabNumber",  "US", "1" },
        { 0x0018, 0x9254,
          "ASL Slab Thickness", "ASLSlabThickness",  "FD", "1" },
        { 0x0018, 0x9255,
          "ASL Slab Orientation", "ASLSlabOrientation",  "FD", "3" },
        { 0x0018, 0x9256,
          "ASL Mid Slab Position", "ASLMidSlabPosition",  "FD", "3" },
        { 0x0018, 0x9257,
          "ASL Context", "ASLContext",  "CS", "1" },
        { 0x0018, 0x9258,
          "ASL Pulse Train Duration", "ASLPulseTrainDuration",  "UL", "1" },
        { 0x0018, 0x9259,
          "ASL Crusher Flag", "ASLCrusherFlag",  "CS", "1" },
        { 0x0018, 0x925a,
          "ASL Crusher Flow Limit", "ASLCrusherFlowLimit",  "FD", "1" },
        { 0x0018, 0x925b,
          "ASL Crusher Description", "ASLCrusherDescription",  "LO", "1" },
        { 0x0018, 0x925c,
          "ASL Bolus Cut-off Flag", "ASLBolusCutoffFlag",  "CS", "1" },
        { 0x0018, 0x925d,
          "ASL Bolus Cut-off Timing Sequence", "ASLBolusCutoffTimingSequence",  "SQ", "1" },
        { 0x0018, 0x925e,
          "ASL Bolus Cut-off Technique", "ASLBolusCutoffTechnique",  "LO", "1" },
        { 0x0018, 0x925f,
          "ASL Bolus Cut-off Delay Time", "ASLBolusCutoffDelayTime",  "UL", "1" },
        { 0x0018, 0x9260,
          "ASL Slab Sequence", "ASLSlabSequence",  "SQ", "1" },
        { 0x0018, 0x9295,
          "Chemical Shift Minimum Integration Limit in ppm", "ChemicalShiftMinimumIntegrationLimitInppm",  "FD", "1" },
        { 0x0018, 0x9296,
          "Chemical Shift Maximum Integration Limit in ppm", "ChemicalShiftMaximumIntegrationLimitInppm",  "FD", "1" },
        { 0x0018, 0x9297,
          "Water Reference Acquisition", "WaterReferenceAcquisition",  "CS", "1" },
        { 0x0018, 0x9298,
          "Echo Peak Position", "EchoPeakPosition",  "IS", "1" },
        { 0x0018, 0x9301,
          "CT Acquisition Type Sequence", "CTAcquisitionTypeSequence",  "SQ", "1" },
        { 0x0018, 0x9302,
          "Acquisition Type", "AcquisitionType",  "CS", "1" },
        { 0x0018, 0x9303,
          "Tube Angle", "TubeAngle",  "FD", "1" },
        { 0x0018, 0x9304,
          "CT Acquisition Details Sequence", "CTAcquisitionDetailsSequence",  "SQ", "1" },
        { 0x0018, 0x9305,
          "Revolution Time", "RevolutionTime",  "FD", "1" },
        { 0x0018, 0x9306,
          "Single Collimation Width", "SingleCollimationWidth",  "FD", "1" },
        { 0x0018, 0x9307,
          "Total Collimation Width", "TotalCollimationWidth",  "FD", "1" },
        { 0x0018, 0x9308,
          "CT Table Dynamics Sequence", "CTTableDynamicsSequence",  "SQ", "1" },
        { 0x0018, 0x9309,
          "Table Speed", "TableSpeed",  "FD", "1" },
        { 0x0018, 0x9310,
          "Table Feed per Rotation", "TableFeedPerRotation",  "FD", "1" },
        { 0x0018, 0x9311,
          "Spiral Pitch Factor", "SpiralPitchFactor",  "FD", "1" },
        { 0x0018, 0x9312,
          "CT Geometry Sequence", "CTGeometrySequence",  "SQ", "1" },
        { 0x0018, 0x9313,
          "Data Collection Center (Patient)", "DataCollectionCenterPatient",  "FD", "3" },
        { 0x0018, 0x9314,
          "CT Reconstruction Sequence", "CTReconstructionSequence",  "SQ", "1" },
        { 0x0018, 0x9315,
          "Reconstruction Algorithm", "ReconstructionAlgorithm",  "CS", "1" },
        { 0x0018, 0x9316,
          "Convolution Kernel Group", "ConvolutionKernelGroup",  "CS", "1" },
        { 0x0018, 0x9317,
          "Reconstruction Field of View", "ReconstructionFieldOfView",  "FD", "2" },
        { 0x0018, 0x9318,
          "Reconstruction Target Center (Patient)", "ReconstructionTargetCenterPatient",  "FD", "3" },
        { 0x0018, 0x9319,
          "Reconstruction Angle", "ReconstructionAngle",  "FD", "1" },
        { 0x0018, 0x9320,
          "Image Filter", "ImageFilter",  "SH", "1" },
        { 0x0018, 0x9321,
          "CT Exposure Sequence", "CTExposureSequence",  "SQ", "1" },
        { 0x0018, 0x9322,
          "Reconstruction Pixel Spacing", "ReconstructionPixelSpacing",  "FD", "2" },
        { 0x0018, 0x9323,
          "Exposure Modulation Type", "ExposureModulationType",  "CS", "1" },
        { 0x0018, 0x9324,
          "Estimated Dose Saving", "EstimatedDoseSaving",  "FD", "1" },
        { 0x0018, 0x9325,
          "CT X-Ray Details Sequence", "CTXRayDetailsSequence",  "SQ", "1" },
        { 0x0018, 0x9326,
          "CT Position Sequence", "CTPositionSequence",  "SQ", "1" },
        { 0x0018, 0x9327,
          "Table Position", "TablePosition",  "FD", "1" },
        { 0x0018, 0x9328,
          "Exposure Time in ms", "ExposureTimeInms",  "FD", "1" },
        { 0x0018, 0x9329,
          "CT Image Frame Type Sequence", "CTImageFrameTypeSequence",  "SQ", "1" },
        { 0x0018, 0x9330,
          "X-Ray Tube Current in mA", "XRayTubeCurrentInmA",  "FD", "1" },
        { 0x0018, 0x9332,
          "Exposure in mAs", "ExposureInmAs",  "FD", "1" },
        { 0x0018, 0x9333,
          "Constant Volume Flag", "ConstantVolumeFlag",  "CS", "1" },
        { 0x0018, 0x9334,
          "Fluoroscopy Flag", "FluoroscopyFlag",  "CS", "1" },
        { 0x0018, 0x9335,
          "Distance Source to Data Collection Center", "DistanceSourceToDataCollectionCenter",  "FD", "1" },
        { 0x0018, 0x9337,
          "Contrast/Bolus Agent Number", "ContrastBolusAgentNumber",  "US", "1" },
        { 0x0018, 0x9338,
          "Contrast/Bolus Ingredient Code Sequence", "ContrastBolusIngredientCodeSequence",  "SQ", "1" },
        { 0x0018, 0x9340,
          "Contrast Administration Profile Sequence", "ContrastAdministrationProfileSequence",  "SQ", "1" },
        { 0x0018, 0x9341,
          "Contrast/Bolus Usage Sequence", "ContrastBolusUsageSequence",  "SQ", "1" },
        { 0x0018, 0x9342,
          "Contrast/Bolus Agent Administered", "ContrastBolusAgentAdministered",  "CS", "1" },
        { 0x0018, 0x9343,
          "Contrast/Bolus Agent Detected", "ContrastBolusAgentDetected",  "CS", "1" },
        { 0x0018, 0x9344,
          "Contrast/Bolus Agent Phase", "ContrastBolusAgentPhase",  "CS", "1" },
        { 0x0018, 0x9345,
          "CTDIvol", "CTDIvol",  "FD", "1" },
        { 0x0018, 0x9346,
          "CTDI Phantom Type Code Sequence", "CTDIPhantomTypeCodeSequence",  "SQ", "1" },
        { 0x0018, 0x9351,
          "Calcium Scoring Mass Factor Patient", "CalciumScoringMassFactorPatient",  "FL", "1" },
        { 0x0018, 0x9352,
          "Calcium Scoring Mass Factor Device", "CalciumScoringMassFactorDevice",  "FL", "3" },
        { 0x0018, 0x9353,
          "Energy Weighting Factor", "EnergyWeightingFactor",  "FL", "1" },
        { 0x0018, 0x9360,
          "CT Additional X-Ray Source Sequence", "CTAdditionalXRaySourceSequence",  "SQ", "1" },
        { 0x0018, 0x9401,
          "Projection Pixel Calibration Sequence", "ProjectionPixelCalibrationSequence",  "SQ", "1" },
        { 0x0018, 0x9402,
          "Distance Source to Isocenter", "DistanceSourceToIsocenter",  "FL", "1" },
        { 0x0018, 0x9403,
          "Distance Object to Table Top", "DistanceObjectToTableTop",  "FL", "1" },
        { 0x0018, 0x9404,
          "Object Pixel Spacing in Center of Beam", "ObjectPixelSpacingInCenterOfBeam",  "FL", "2" },
        { 0x0018, 0x9405,
          "Positioner Position Sequence", "PositionerPositionSequence",  "SQ", "1" },
        { 0x0018, 0x9406,
          "Table Position Sequence", "TablePositionSequence",  "SQ", "1" },
        { 0x0018, 0x9407,
          "Collimator Shape Sequence", "CollimatorShapeSequence",  "SQ", "1" },
        { 0x0018, 0x9410,
          "Planes in Acquisition", "PlanesInAcquisition",  "CS", "1" },
        { 0x0018, 0x9412,
          "XA/XRF Frame Characteristics Sequence", "XAXRFFrameCharacteristicsSequence",  "SQ", "1" },
        { 0x0018, 0x9417,
          "Frame Acquisition Sequence", "FrameAcquisitionSequence",  "SQ", "1" },
        { 0x0018, 0x9420,
          "X-Ray Receptor Type", "XRayReceptorType",  "CS", "1" },
        { 0x0018, 0x9423,
          "Acquisition Protocol Name", "AcquisitionProtocolName",  "LO", "1" },
        { 0x0018, 0x9424,
          "Acquisition Protocol Description", "AcquisitionProtocolDescription",  "LT", "1" },
        { 0x0018, 0x9425,
          "Contrast/Bolus Ingredient Opaque", "ContrastBolusIngredientOpaque",  "CS", "1" },
        { 0x0018, 0x9426,
          "Distance Receptor Plane to Detector Housing", "DistanceReceptorPlaneToDetectorHousing",  "FL", "1" },
        { 0x0018, 0x9427,
          "Intensifier Active Shape", "IntensifierActiveShape",  "CS", "1" },
        { 0x0018, 0x9428,
          "Intensifier Active Dimension(s)", "IntensifierActiveDimensions",  "FL", "1-2" },
        { 0x0018, 0x9429,
          "Physical Detector Size", "PhysicalDetectorSize",  "FL", "2" },
        { 0x0018, 0x9430,
          "Position of Isocenter Projection", "PositionOfIsocenterProjection",  "FL", "2" },
        { 0x0018, 0x9432,
          "Field of View Sequence", "FieldOfViewSequence",  "SQ", "1" },
        { 0x0018, 0x9433,
          "Field of View Description", "FieldOfViewDescription",  "LO", "1" },
        { 0x0018, 0x9434,
          "Exposure Control Sensing Regions Sequence", "ExposureControlSensingRegionsSequence",  "SQ", "1" },
        { 0x0018, 0x9435,
          "Exposure Control Sensing Region Shape", "ExposureControlSensingRegionShape",  "CS", "1" },
        { 0x0018, 0x9436,
          "Exposure Control Sensing Region Left Vertical Edge", "ExposureControlSensingRegionLeftVerticalEdge",  "SS", "1" },
        { 0x0018, 0x9437,
          "Exposure Control Sensing Region Right Vertical Edge", "ExposureControlSensingRegionRightVerticalEdge",  "SS", "1" },
        { 0x0018, 0x9438,
          "Exposure Control Sensing Region Upper Horizontal Edge", "ExposureControlSensingRegionUpperHorizontalEdge",  "SS", "1" },
        { 0x0018, 0x9439,
          "Exposure Control Sensing Region Lower Horizontal Edge", "ExposureControlSensingRegionLowerHorizontalEdge",  "SS", "1" },
        { 0x0018, 0x9440,
          "Center of Circular Exposure Control Sensing Region", "CenterOfCircularExposureControlSensingRegion",  "SS", "2" },
        { 0x0018, 0x9441,
          "Radius of Circular Exposure Control Sensing Region", "RadiusOfCircularExposureControlSensingRegion",  "US", "1" },
        { 0x0018, 0x9442,
          "Vertices of the Polygonal Exposure Control Sensing Region", "VerticesOfThePolygonalExposureControlSensingRegion",  "SS", "2-n" },
        { 0x0018, 0x9447,
          "Column Angulation (Patient)", "ColumnAngulationPatient",  "FL", "1" },
        { 0x0018, 0x9449,
          "Beam Angle", "BeamAngle",  "FL", "1" },
        { 0x0018, 0x9451,
          "Frame Detector Parameters Sequence", "FrameDetectorParametersSequence",  "SQ", "1" },
        { 0x0018, 0x9452,
          "Calculated Anatomy Thickness", "CalculatedAnatomyThickness",  "FL", "1" },
        { 0x0018, 0x9455,
          "Calibration Sequence", "CalibrationSequence",  "SQ", "1" },
        { 0x0018, 0x9456,
          "Object Thickness Sequence", "ObjectThicknessSequence",  "SQ", "1" },
        { 0x0018, 0x9457,
          "Plane Identification", "PlaneIdentification",  "CS", "1" },
        { 0x0018, 0x9461,
          "Field of View Dimension(s) in Float", "FieldOfViewDimensionsInFloat",  "FL", "1-2" },
        { 0x0018, 0x9462,
          "Isocenter Reference System Sequence", "IsocenterReferenceSystemSequence",  "SQ", "1" },
        { 0x0018, 0x9463,
          "Positioner Isocenter Primary Angle", "PositionerIsocenterPrimaryAngle",  "FL", "1" },
        { 0x0018, 0x9464,
          "Positioner Isocenter Secondary Angle", "PositionerIsocenterSecondaryAngle",  "FL", "1" },
        { 0x0018, 0x9465,
          "Positioner Isocenter Detector Rotation Angle", "PositionerIsocenterDetectorRotationAngle",  "FL", "1" },
        { 0x0018, 0x9466,
          "Table X Position to Isocenter", "TableXPositionToIsocenter",  "FL", "1" },
        { 0x0018, 0x9467,
          "Table Y Position to Isocenter", "TableYPositionToIsocenter",  "FL", "1" },
        { 0x0018, 0x9468,
          "Table Z Position to Isocenter", "TableZPositionToIsocenter",  "FL", "1" },
        { 0x0018, 0x9469,
          "Table Horizontal Rotation Angle", "TableHorizontalRotationAngle",  "FL", "1" },
        { 0x0018, 0x9470,
          "Table Head Tilt Angle", "TableHeadTiltAngle",  "FL", "1" },
        { 0x0018, 0x9471,
          "Table Cradle Tilt Angle", "TableCradleTiltAngle",  "FL", "1" },
        { 0x0018, 0x9472,
          "Frame Display Shutter Sequence", "FrameDisplayShutterSequence",  "SQ", "1" },
        { 0x0018, 0x9473,
          "Acquired Image Area Dose Product", "AcquiredImageAreaDoseProduct",  "FL", "1" },
        { 0x0018, 0x9474,
          "C-arm Positioner Tabletop Relationship", "CArmPositionerTabletopRelationship",  "CS", "1" },
        { 0x0018, 0x9476,
          "X-Ray Geometry Sequence", "XRayGeometrySequence",  "SQ", "1" },
        { 0x0018, 0x9477,
          "Irradiation Event Identification Sequence", "IrradiationEventIdentificationSequence",  "SQ", "1" },
        { 0x0018, 0x9504,
          "X-Ray 3D Frame Type Sequence", "XRay3DFrameTypeSequence",  "SQ", "1" },
        { 0x0018, 0x9506,
          "Contributing Sources Sequence", "ContributingSourcesSequence",  "SQ", "1" },
        { 0x0018, 0x9507,
          "X-Ray 3D Acquisition Sequence", "XRay3DAcquisitionSequence",  "SQ", "1" },
        { 0x0018, 0x9508,
          "Primary Positioner Scan Arc", "PrimaryPositionerScanArc",  "FL", "1" },
        { 0x0018, 0x9509,
          "Secondary Positioner Scan Arc", "SecondaryPositionerScanArc",  "FL", "1" },
        { 0x0018, 0x9510,
          "Primary Positioner Scan Start Angle", "PrimaryPositionerScanStartAngle",  "FL", "1" },
        { 0x0018, 0x9511,
          "Secondary Positioner Scan Start Angle", "SecondaryPositionerScanStartAngle",  "FL", "1" },
        { 0x0018, 0x9514,
          "Primary Positioner Increment", "PrimaryPositionerIncrement",  "FL", "1" },
        { 0x0018, 0x9515,
          "Secondary Positioner Increment", "SecondaryPositionerIncrement",  "FL", "1" },
        { 0x0018, 0x9516,
          "Start Acquisition DateTime", "StartAcquisitionDateTime",  "DT", "1" },
        { 0x0018, 0x9517,
          "End Acquisition DateTime", "EndAcquisitionDateTime",  "DT", "1" },
        { 0x0018, 0x9518,
          "Primary Positioner Increment Sign", "PrimaryPositionerIncrementSign",  "SS", "1" },
        { 0x0018, 0x9519,
          "Secondary Positioner Increment Sign", "SecondaryPositionerIncrementSign",  "SS", "1" },
        { 0x0018, 0x9524,
          "Application Name", "ApplicationName",  "LO", "1" },
        { 0x0018, 0x9525,
          "Application Version", "ApplicationVersion",  "LO", "1" },
        { 0x0018, 0x9526,
          "Application Manufacturer", "ApplicationManufacturer",  "LO", "1" },
        { 0x0018, 0x9527,
          "Algorithm Type", "AlgorithmType",  "CS", "1" },
        { 0x0018, 0x9528,
          "Algorithm Description", "AlgorithmDescription",  "LO", "1" },
        { 0x0018, 0x9530,
          "X-Ray 3D Reconstruction Sequence", "XRay3DReconstructionSequence",  "SQ", "1" },
        { 0x0018, 0x9531,
          "Reconstruction Description", "ReconstructionDescription",  "LO", "1" },
        { 0x0018, 0x9538,
          "Per Projection Acquisition Sequence", "PerProjectionAcquisitionSequence",  "SQ", "1" },
        { 0x0018, 0x9541,
          "Detector Position Sequence", "DetectorPositionSequence",  "SQ", "1" },
        { 0x0018, 0x9542,
          "X-Ray Acquisition Dose Sequence", "XRayAcquisitionDoseSequence",  "SQ", "1" },
        { 0x0018, 0x9543,
          "X-Ray Source Isocenter Primary Angle", "XRaySourceIsocenterPrimaryAngle",  "FD", "1" },
        { 0x0018, 0x9544,
          "X-Ray Source Isocenter Secondary Angle", "XRaySourceIsocenterSecondaryAngle",  "FD", "1" },
        { 0x0018, 0x9545,
          "Breast Support Isocenter Primary Angle", "BreastSupportIsocenterPrimaryAngle",  "FD", "1" },
        { 0x0018, 0x9546,
          "Breast Support Isocenter Secondary Angle", "BreastSupportIsocenterSecondaryAngle",  "FD", "1" },
        { 0x0018, 0x9547,
          "Breast Support X Position to Isocenter", "BreastSupportXPositionToIsocenter",  "FD", "1" },
        { 0x0018, 0x9548,
          "Breast Support Y Position to Isocenter", "BreastSupportYPositionToIsocenter",  "FD", "1" },
        { 0x0018, 0x9549,
          "Breast Support Z Position to Isocenter", "BreastSupportZPositionToIsocenter",  "FD", "1" },
        { 0x0018, 0x9550,
          "Detector Isocenter Primary Angle", "DetectorIsocenterPrimaryAngle",  "FD", "1" },
        { 0x0018, 0x9551,
          "Detector Isocenter Secondary Angle", "DetectorIsocenterSecondaryAngle",  "FD", "1" },
        { 0x0018, 0x9552,
          "Detector X Position to Isocenter", "DetectorXPositionToIsocenter",  "FD", "1" },
        { 0x0018, 0x9553,
          "Detector Y Position to Isocenter", "DetectorYPositionToIsocenter",  "FD", "1" },
        { 0x0018, 0x9554,
          "Detector Z Position to Isocenter", "DetectorZPositionToIsocenter",  "FD", "1" },
        { 0x0018, 0x9555,
          "X-Ray Grid Sequence", "XRayGridSequence",  "SQ", "1" },
        { 0x0018, 0x9556,
          "X-Ray Filter Sequence", "XRayFilterSequence",  "SQ", "1" },
        { 0x0018, 0x9557,
          "Detector Active Area TLHC Position", "DetectorActiveAreaTLHCPosition",  "FD", "3" },
        { 0x0018, 0x9558,
          "Detector Active Area Orientation", "DetectorActiveAreaOrientation",  "FD", "6" },
        { 0x0018, 0x9559,
          "Positioner Primary Angle Direction", "PositionerPrimaryAngleDirection",  "CS", "1" },
        { 0x0018, 0x9601,
          "Diffusion b-matrix Sequence", "DiffusionBMatrixSequence",  "SQ", "1" },
        { 0x0018, 0x9602,
          "Diffusion b-value XX", "DiffusionBValueXX",  "FD", "1" },
        { 0x0018, 0x9603,
          "Diffusion b-value XY", "DiffusionBValueXY",  "FD", "1" },
        { 0x0018, 0x9604,
          "Diffusion b-value XZ", "DiffusionBValueXZ",  "FD", "1" },
        { 0x0018, 0x9605,
          "Diffusion b-value YY", "DiffusionBValueYY",  "FD", "1" },
        { 0x0018, 0x9606,
          "Diffusion b-value YZ", "DiffusionBValueYZ",  "FD", "1" },
        { 0x0018, 0x9607,
          "Diffusion b-value ZZ", "DiffusionBValueZZ",  "FD", "1" },
        { 0x0018, 0x9701,
          "Decay Correction DateTime", "DecayCorrectionDateTime",  "DT", "1" },
        { 0x0018, 0x9715,
          "Start Density Threshold", "StartDensityThreshold",  "FD", "1" },
        { 0x0018, 0x9716,
          "Start Relative Density Difference Threshold", "StartRelativeDensityDifferenceThreshold",  "FD", "1" },
        { 0x0018, 0x9717,
          "Start Cardiac Trigger Count Threshold", "StartCardiacTriggerCountThreshold",  "FD", "1" },
        { 0x0018, 0x9718,
          "Start Respiratory Trigger Count Threshold", "StartRespiratoryTriggerCountThreshold",  "FD", "1" },
        { 0x0018, 0x9719,
          "Termination Counts Threshold", "TerminationCountsThreshold",  "FD", "1" },
        { 0x0018, 0x9720,
          "Termination Density Threshold", "TerminationDensityThreshold",  "FD", "1" },
        { 0x0018, 0x9721,
          "Termination Relative Density Threshold", "TerminationRelativeDensityThreshold",  "FD", "1" },
        { 0x0018, 0x9722,
          "Termination Time Threshold", "TerminationTimeThreshold",  "FD", "1" },
        { 0x0018, 0x9723,
          "Termination Cardiac Trigger Count Threshold", "TerminationCardiacTriggerCountThreshold",  "FD", "1" },
        { 0x0018, 0x9724,
          "Termination Respiratory Trigger Count Threshold", "TerminationRespiratoryTriggerCountThreshold",  "FD", "1" },
        { 0x0018, 0x9725,
          "Detector Geometry", "DetectorGeometry",  "CS", "1" },
        { 0x0018, 0x9726,
          "Transverse Detector Separation", "TransverseDetectorSeparation",  "FD", "1" },
        { 0x0018, 0x9727,
          "Axial Detector Dimension", "AxialDetectorDimension",  "FD", "1" },
        { 0x0018, 0x9729,
          "Radiopharmaceutical Agent Number", "RadiopharmaceuticalAgentNumber",  "US", "1" },
        { 0x0018, 0x9732,
          "PET Frame Acquisition Sequence", "PETFrameAcquisitionSequence",  "SQ", "1" },
        { 0x0018, 0x9733,
          "PET Detector Motion Details Sequence", "PETDetectorMotionDetailsSequence",  "SQ", "1" },
        { 0x0018, 0x9734,
          "PET Table Dynamics Sequence", "PETTableDynamicsSequence",  "SQ", "1" },
        { 0x0018, 0x9735,
          "PET Position Sequence", "PETPositionSequence",  "SQ", "1" },
        { 0x0018, 0x9736,
          "PET Frame Correction Factors Sequence", "PETFrameCorrectionFactorsSequence",  "SQ", "1" },
        { 0x0018, 0x9737,
          "Radiopharmaceutical Usage Sequence", "RadiopharmaceuticalUsageSequence",  "SQ", "1" },
        { 0x0018, 0x9738,
          "Attenuation Correction Source", "AttenuationCorrectionSource",  "CS", "1" },
        { 0x0018, 0x9739,
          "Number of Iterations", "NumberOfIterations",  "US", "1" },
        { 0x0018, 0x9740,
          "Number of Subsets", "NumberOfSubsets",  "US", "1" },
        { 0x0018, 0x9749,
          "PET Reconstruction Sequence", "PETReconstructionSequence",  "SQ", "1" },
        { 0x0018, 0x9751,
          "PET Frame Type Sequence", "PETFrameTypeSequence",  "SQ", "1" },
        { 0x0018, 0x9755,
          "Time of Flight Information Used", "TimeOfFlightInformationUsed",  "CS", "1" },
        { 0x0018, 0x9756,
          "Reconstruction Type", "ReconstructionType",  "CS", "1" },
        { 0x0018, 0x9758,
          "Decay Corrected", "DecayCorrected",  "CS", "1" },
        { 0x0018, 0x9759,
          "Attenuation Corrected", "AttenuationCorrected",  "CS", "1" },
        { 0x0018, 0x9760,
          "Scatter Corrected", "ScatterCorrected",  "CS", "1" },
        { 0x0018, 0x9761,
          "Dead Time Corrected", "DeadTimeCorrected",  "CS", "1" },
        { 0x0018, 0x9762,
          "Gantry Motion Corrected", "GantryMotionCorrected",  "CS", "1" },
        { 0x0018, 0x9763,
          "Patient Motion Corrected", "PatientMotionCorrected",  "CS", "1" },
        { 0x0018, 0x9764,
          "Count Loss Normalization Corrected", "CountLossNormalizationCorrected",  "CS", "1" },
        { 0x0018, 0x9765,
          "Randoms Corrected", "RandomsCorrected",  "CS", "1" },
        { 0x0018, 0x9766,
          "Non-uniform Radial Sampling Corrected", "NonUniformRadialSamplingCorrected",  "CS", "1" },
        { 0x0018, 0x9767,
          "Sensitivity Calibrated", "SensitivityCalibrated",  "CS", "1" },
        { 0x0018, 0x9768,
          "Detector Normalization Correction", "DetectorNormalizationCorrection",  "CS", "1" },
        { 0x0018, 0x9769,
          "Iterative Reconstruction Method", "IterativeReconstructionMethod",  "CS", "1" },
        { 0x0018, 0x9770,
          "Attenuation Correction Temporal Relationship", "AttenuationCorrectionTemporalRelationship",  "CS", "1" },
        { 0x0018, 0x9771,
          "Patient Physiological State Sequence", "PatientPhysiologicalStateSequence",  "SQ", "1" },
        { 0x0018, 0x9772,
          "Patient Physiological State Code Sequence", "PatientPhysiologicalStateCodeSequence",  "SQ", "1" },
        { 0x0018, 0x9801,
          "Depth(s) of Focus", "DepthsOfFocus",  "FD", "1-n" },
        { 0x0018, 0x9803,
          "Excluded Intervals Sequence", "ExcludedIntervalsSequence",  "SQ", "1" },
        { 0x0018, 0x9804,
          "Exclusion Start DateTime", "ExclusionStartDateTime",  "DT", "1" },
        { 0x0018, 0x9805,
          "Exclusion Duration", "ExclusionDuration",  "FD", "1" },
        { 0x0018, 0x9806,
          "US Image Description Sequence", "USImageDescriptionSequence",  "SQ", "1" },
        { 0x0018, 0x9807,
          "Image Data Type Sequence", "ImageDataTypeSequence",  "SQ", "1" },
        { 0x0018, 0x9808,
          "Data Type", "DataType",  "CS", "1" },
        { 0x0018, 0x9809,
          "Transducer Scan Pattern Code Sequence", "TransducerScanPatternCodeSequence",  "SQ", "1" },
        { 0x0018, 0x980b,
          "Aliased Data Type", "AliasedDataType",  "CS", "1" },
        { 0x0018, 0x980c,
          "Position Measuring Device Used", "PositionMeasuringDeviceUsed",  "CS", "1" },
        { 0x0018, 0x980d,
          "Transducer Geometry Code Sequence", "TransducerGeometryCodeSequence",  "SQ", "1" },
        { 0x0018, 0x980e,
          "Transducer Beam Steering Code Sequence", "TransducerBeamSteeringCodeSequence",  "SQ", "1" },
        { 0x0018, 0x980f,
          "Transducer Application Code Sequence", "TransducerApplicationCodeSequence",  "SQ", "1" },
        { 0x0018, 0x9810,
          "Zero Velocity Pixel Value", "ZeroVelocityPixelValue",  "US or SS", "1" },
        { 0x0018, 0xa001,
          "Contributing Equipment Sequence", "ContributingEquipmentSequence",  "SQ", "1" },
        { 0x0018, 0xa002,
          "Contribution DateTime", "ContributionDateTime",  "DT", "1" },
        { 0x0018, 0xa003,
          "Contribution Description", "ContributionDescription",  "ST", "1" },
        { 0x0020, 0x000d,
          "Study Instance UID", "StudyInstanceUID",  "UI", "1" },
        { 0x0020, 0x000e,
          "Series Instance UID", "SeriesInstanceUID",  "UI", "1" },
        { 0x0020, 0x0010,
          "Study ID", "StudyID",  "SH", "1" },
        { 0x0020, 0x0011,
          "Series Number", "SeriesNumber",  "IS", "1" },
        { 0x0020, 0x0012,
          "Acquisition Number", "AcquisitionNumber",  "IS", "1" },
        { 0x0020, 0x0013,
          "Instance Number", "InstanceNumber",  "IS", "1" },
        { 0x0020, 0x0014,
          "Isotope Number", "IsotopeNumber",  "IS", "1" },
        { 0x0020, 0x0015,
          "Phase Number", "PhaseNumber",  "IS", "1" },
        { 0x0020, 0x0016,
          "Interval Number", "IntervalNumber",  "IS", "1" },
        { 0x0020, 0x0017,
          "Time Slot Number", "TimeSlotNumber",  "IS", "1" },
        { 0x0020, 0x0018,
          "Angle Number", "AngleNumber",  "IS", "1" },
        { 0x0020, 0x0019,
          "Item Number", "ItemNumber",  "IS", "1" },
        { 0x0020, 0x0020,
          "Patient Orientation", "PatientOrientation",  "CS", "2" },
        { 0x0020, 0x0022,
          "Overlay Number", "OverlayNumber",  "IS", "1" },
        { 0x0020, 0x0024,
          "Curve Number", "CurveNumber",  "IS", "1" },
        { 0x0020, 0x0026,
          "LUT Number", "LUTNumber",  "IS", "1" },
        { 0x0020, 0x0030,
          "Image Position", "ImagePosition",  "DS", "3" },
        { 0x0020, 0x0032,
          "Image Position (Patient)", "ImagePositionPatient",  "DS", "3" },
        { 0x0020, 0x0035,
          "Image Orientation", "ImageOrientation",  "DS", "6" },
        { 0x0020, 0x0037,
          "Image Orientation (Patient)", "ImageOrientationPatient",  "DS", "6" },
        { 0x0020, 0x0050,
          "Location", "Location",  "DS", "1" },
        { 0x0020, 0x0052,
          "Frame of Reference UID", "FrameOfReferenceUID",  "UI", "1" },
        { 0x0020, 0x0060,
          "Laterality", "Laterality",  "CS", "1" },
        { 0x0020, 0x0062,
          "Image Laterality", "ImageLaterality",  "CS", "1" },
        { 0x0020, 0x0070,
          "Image Geometry Type", "ImageGeometryType",  "LO", "1" },
        { 0x0020, 0x0080,
          "Masking Image", "MaskingImage",  "CS", "1-n" },
        { 0x0020, 0x00aa,
          "Report Number", "ReportNumber",  "IS", "1" },
        { 0x0020, 0x0100,
          "Temporal Position Identifier", "TemporalPositionIdentifier",  "IS", "1" },
        { 0x0020, 0x0105,
          "Number of Temporal Positions", "NumberOfTemporalPositions",  "IS", "1" },
        { 0x0020, 0x0110,
          "Temporal Resolution", "TemporalResolution",  "DS", "1" },
        { 0x0020, 0x0200,
          "Synchronization Frame of Reference UID", "SynchronizationFrameOfReferenceUID",  "UI", "1" },
        { 0x0020, 0x0242,
          "SOP Instance UID of Concatenation Source", "SOPInstanceUIDOfConcatenationSource",  "UI", "1" },
        { 0x0020, 0x1000,
          "Series in Study", "SeriesInStudy",  "IS", "1" },
        { 0x0020, 0x1001,
          "Acquisitions in Series", "AcquisitionsInSeries",  "IS", "1" },
        { 0x0020, 0x1002,
          "Images in Acquisition", "ImagesInAcquisition",  "IS", "1" },
        { 0x0020, 0x1003,
          "Images in Series", "ImagesInSeries",  "IS", "1" },
        { 0x0020, 0x1004,
          "Acquisitions in Study", "AcquisitionsInStudy",  "IS", "1" },
        { 0x0020, 0x1005,
          "Images in Study", "ImagesInStudy",  "IS", "1" },
        { 0x0020, 0x1020,
          "Reference", "Reference",  "LO", "1-n" },
        { 0x0020, 0x1040,
          "Position Reference Indicator", "PositionReferenceIndicator",  "LO", "1" },
        { 0x0020, 0x1041,
          "Slice Location", "SliceLocation",  "DS", "1" },
        { 0x0020, 0x1070,
          "Other Study Numbers", "OtherStudyNumbers",  "IS", "1-n" },
        { 0x0020, 0x1200,
          "Number of Patient Related Studies", "NumberOfPatientRelatedStudies",  "IS", "1" },
        { 0x0020, 0x1202,
          "Number of Patient Related Series", "NumberOfPatientRelatedSeries",  "IS", "1" },
        { 0x0020, 0x1204,
          "Number of Patient Related Instances", "NumberOfPatientRelatedInstances",  "IS", "1" },
        { 0x0020, 0x1206,
          "Number of Study Related Series", "NumberOfStudyRelatedSeries",  "IS", "1" },
        { 0x0020, 0x1208,
          "Number of Study Related Instances", "NumberOfStudyRelatedInstances",  "IS", "1" },
        { 0x0020, 0x1209,
          "Number of Series Related Instances", "NumberOfSeriesRelatedInstances",  "IS", "1" },
        { 0x0020, 0x3401,
          "Modifying Device ID", "ModifyingDeviceID",  "CS", "1" },
        { 0x0020, 0x3402,
          "Modified Image ID", "ModifiedImageID",  "CS", "1" },
        { 0x0020, 0x3403,
          "Modified Image Date", "ModifiedImageDate",  "DA", "1" },
        { 0x0020, 0x3404,
          "Modifying Device Manufacturer", "ModifyingDeviceManufacturer",  "LO", "1" },
        { 0x0020, 0x3405,
          "Modified Image Time", "ModifiedImageTime",  "TM", "1" },
        { 0x0020, 0x3406,
          "Modified Image Description", "ModifiedImageDescription",  "LO", "1" },
        { 0x0020, 0x4000,
          "Image Comments", "ImageComments",  "LT", "1" },
        { 0x0020, 0x5000,
          "Original Image Identification", "OriginalImageIdentification",  "AT", "1-n" },
        { 0x0020, 0x5002,
          "Original Image Identification Nomenclature", "OriginalImageIdentificationNomenclature",  "LO", "1-n" },
        { 0x0020, 0x9056,
          "Stack ID", "StackID",  "SH", "1" },
        { 0x0020, 0x9057,
          "In-Stack Position Number", "InStackPositionNumber",  "UL", "1" },
        { 0x0020, 0x9071,
          "Frame Anatomy Sequence", "FrameAnatomySequence",  "SQ", "1" },
        { 0x0020, 0x9072,
          "Frame Laterality", "FrameLaterality",  "CS", "1" },
        { 0x0020, 0x9111,
          "Frame Content Sequence", "FrameContentSequence",  "SQ", "1" },
        { 0x0020, 0x9113,
          "Plane Position Sequence", "PlanePositionSequence",  "SQ", "1" },
        { 0x0020, 0x9116,
          "Plane Orientation Sequence", "PlaneOrientationSequence",  "SQ", "1" },
        { 0x0020, 0x9128,
          "Temporal Position Index", "TemporalPositionIndex",  "UL", "1" },
        { 0x0020, 0x9153,
          "Nominal Cardiac Trigger Delay Time", "NominalCardiacTriggerDelayTime",  "FD", "1" },
        { 0x0020, 0x9154,
          "Nominal Cardiac Trigger Time Prior To R-Peak", "NominalCardiacTriggerTimePriorToRPeak",  "FL", "1" },
        { 0x0020, 0x9155,
          "Actual Cardiac Trigger Time Prior To R-Peak", "ActualCardiacTriggerTimePriorToRPeak",  "FL", "1" },
        { 0x0020, 0x9156,
          "Frame Acquisition Number", "FrameAcquisitionNumber",  "US", "1" },
        { 0x0020, 0x9157,
          "Dimension Index Values", "DimensionIndexValues",  "UL", "1-n" },
        { 0x0020, 0x9158,
          "Frame Comments", "FrameComments",  "LT", "1" },
        { 0x0020, 0x9161,
          "Concatenation UID", "ConcatenationUID",  "UI", "1" },
        { 0x0020, 0x9162,
          "In-concatenation Number", "InConcatenationNumber",  "US", "1" },
        { 0x0020, 0x9163,
          "In-concatenation Total Number", "InConcatenationTotalNumber",  "US", "1" },
        { 0x0020, 0x9164,
          "Dimension Organization UID", "DimensionOrganizationUID",  "UI", "1" },
        { 0x0020, 0x9165,
          "Dimension Index Pointer", "DimensionIndexPointer",  "AT", "1" },
        { 0x0020, 0x9167,
          "Functional Group Pointer", "FunctionalGroupPointer",  "AT", "1" },
        { 0x0020, 0x9170,
          "Unassigned Shared Converted Attributes Sequence", "UnassignedSharedConvertedAttributesSequence",  "SQ", "1" },
        { 0x0020, 0x9171,
          "Unassigned Per-Frame Converted Attributes Sequence", "UnassignedPerFrameConvertedAttributesSequence",  "SQ", "1" },
        { 0x0020, 0x9172,
          "Conversion Source Attributes Sequence", "ConversionSourceAttributesSequence",  "SQ", "1" },
        { 0x0020, 0x9213,
          "Dimension Index Private Creator", "DimensionIndexPrivateCreator",  "LO", "1" },
        { 0x0020, 0x9221,
          "Dimension Organization Sequence", "DimensionOrganizationSequence",  "SQ", "1" },
        { 0x0020, 0x9222,
          "Dimension Index Sequence", "DimensionIndexSequence",  "SQ", "1" },
        { 0x0020, 0x9228,
          "Concatenation Frame Offset Number", "ConcatenationFrameOffsetNumber",  "UL", "1" },
        { 0x0020, 0x9238,
          "Functional Group Private Creator", "FunctionalGroupPrivateCreator",  "LO", "1" },
        { 0x0020, 0x9241,
          "Nominal Percentage of Cardiac Phase", "NominalPercentageOfCardiacPhase",  "FL", "1" },
        { 0x0020, 0x9245,
          "Nominal Percentage of Respiratory Phase", "NominalPercentageOfRespiratoryPhase",  "FL", "1" },
        { 0x0020, 0x9246,
          "Starting Respiratory Amplitude", "StartingRespiratoryAmplitude",  "FL", "1" },
        { 0x0020, 0x9247,
          "Starting Respiratory Phase", "StartingRespiratoryPhase",  "CS", "1" },
        { 0x0020, 0x9248,
          "Ending Respiratory Amplitude", "EndingRespiratoryAmplitude",  "FL", "1" },
        { 0x0020, 0x9249,
          "Ending Respiratory Phase", "EndingRespiratoryPhase",  "CS", "1" },
        { 0x0020, 0x9250,
          "Respiratory Trigger Type", "RespiratoryTriggerType",  "CS", "1" },
        { 0x0020, 0x9251,
          "R-R Interval Time Nominal", "RRIntervalTimeNominal",  "FD", "1" },
        { 0x0020, 0x9252,
          "Actual Cardiac Trigger Delay Time", "ActualCardiacTriggerDelayTime",  "FD", "1" },
        { 0x0020, 0x9253,
          "Respiratory Synchronization Sequence", "RespiratorySynchronizationSequence",  "SQ", "1" },
        { 0x0020, 0x9254,
          "Respiratory Interval Time", "RespiratoryIntervalTime",  "FD", "1" },
        { 0x0020, 0x9255,
          "Nominal Respiratory Trigger Delay Time", "NominalRespiratoryTriggerDelayTime",  "FD", "1" },
        { 0x0020, 0x9256,
          "Respiratory Trigger Delay Threshold", "RespiratoryTriggerDelayThreshold",  "FD", "1" },
        { 0x0020, 0x9257,
          "Actual Respiratory Trigger Delay Time", "ActualRespiratoryTriggerDelayTime",  "FD", "1" },
        { 0x0020, 0x9301,
          "Image Position (Volume)", "ImagePositionVolume",  "FD", "3" },
        { 0x0020, 0x9302,
          "Image Orientation (Volume)", "ImageOrientationVolume",  "FD", "6" },
        { 0x0020, 0x9307,
          "Ultrasound Acquisition Geometry", "UltrasoundAcquisitionGeometry",  "CS", "1" },
        { 0x0020, 0x9308,
          "Apex Position", "ApexPosition",  "FD", "3" },
        { 0x0020, 0x9309,
          "Volume to Transducer Mapping Matrix", "VolumeToTransducerMappingMatrix",  "FD", "16" },
        { 0x0020, 0x930a,
          "Volume to Table Mapping Matrix", "VolumeToTableMappingMatrix",  "FD", "16" },
        { 0x0020, 0x930b,
          "Volume to Transducer Relationship", "VolumeToTransducerRelationship",  "CS", "1" },
        { 0x0020, 0x930c,
          "Patient Frame of Reference Source", "PatientFrameOfReferenceSource",  "CS", "1" },
        { 0x0020, 0x930d,
          "Temporal Position Time Offset", "TemporalPositionTimeOffset",  "FD", "1" },
        { 0x0020, 0x930e,
          "Plane Position (Volume) Sequence", "PlanePositionVolumeSequence",  "SQ", "1" },
        { 0x0020, 0x930f,
          "Plane Orientation (Volume) Sequence", "PlaneOrientationVolumeSequence",  "SQ", "1" },
        { 0x0020, 0x9310,
          "Temporal Position Sequence", "TemporalPositionSequence",  "SQ", "1" },
        { 0x0020, 0x9311,
          "Dimension Organization Type", "DimensionOrganizationType",  "CS", "1" },
        { 0x0020, 0x9312,
          "Volume Frame of Reference UID", "VolumeFrameOfReferenceUID",  "UI", "1" },
        { 0x0020, 0x9313,
          "Table Frame of Reference UID", "TableFrameOfReferenceUID",  "UI", "1" },
        { 0x0020, 0x9421,
          "Dimension Description Label", "DimensionDescriptionLabel",  "LO", "1" },
        { 0x0020, 0x9450,
          "Patient Orientation in Frame Sequence", "PatientOrientationInFrameSequence",  "SQ", "1" },
        { 0x0020, 0x9453,
          "Frame Label", "FrameLabel",  "LO", "1" },
        { 0x0020, 0x9518,
          "Acquisition Index", "AcquisitionIndex",  "US", "1-n" },
        { 0x0020, 0x9529,
          "Contributing SOP Instances Reference Sequence", "ContributingSOPInstancesReferenceSequence",  "SQ", "1" },
        { 0x0020, 0x9536,
          "Reconstruction Index", "ReconstructionIndex",  "US", "1" },
        { 0x0022, 0x0001,
          "Light Path Filter Pass-Through Wavelength", "LightPathFilterPassThroughWavelength",  "US", "1" },
        { 0x0022, 0x0002,
          "Light Path Filter Pass Band", "LightPathFilterPassBand",  "US", "2" },
        { 0x0022, 0x0003,
          "Image Path Filter Pass-Through Wavelength", "ImagePathFilterPassThroughWavelength",  "US", "1" },
        { 0x0022, 0x0004,
          "Image Path Filter Pass Band", "ImagePathFilterPassBand",  "US", "2" },
        { 0x0022, 0x0005,
          "Patient Eye Movement Commanded", "PatientEyeMovementCommanded",  "CS", "1" },
        { 0x0022, 0x0006,
          "Patient Eye Movement Command Code Sequence", "PatientEyeMovementCommandCodeSequence",  "SQ", "1" },
        { 0x0022, 0x0007,
          "Spherical Lens Power", "SphericalLensPower",  "FL", "1" },
        { 0x0022, 0x0008,
          "Cylinder Lens Power", "CylinderLensPower",  "FL", "1" },
        { 0x0022, 0x0009,
          "Cylinder Axis", "CylinderAxis",  "FL", "1" },
        { 0x0022, 0x000a,
          "Emmetropic Magnification", "EmmetropicMagnification",  "FL", "1" },
        { 0x0022, 0x000b,
          "Intra Ocular Pressure", "IntraOcularPressure",  "FL", "1" },
        { 0x0022, 0x000c,
          "Horizontal Field of View", "HorizontalFieldOfView",  "FL", "1" },
        { 0x0022, 0x000d,
          "Pupil Dilated", "PupilDilated",  "CS", "1" },
        { 0x0022, 0x000e,
          "Degree of Dilation", "DegreeOfDilation",  "FL", "1" },
        { 0x0022, 0x0010,
          "Stereo Baseline Angle", "StereoBaselineAngle",  "FL", "1" },
        { 0x0022, 0x0011,
          "Stereo Baseline Displacement", "StereoBaselineDisplacement",  "FL", "1" },
        { 0x0022, 0x0012,
          "Stereo Horizontal Pixel Offset", "StereoHorizontalPixelOffset",  "FL", "1" },
        { 0x0022, 0x0013,
          "Stereo Vertical Pixel Offset", "StereoVerticalPixelOffset",  "FL", "1" },
        { 0x0022, 0x0014,
          "Stereo Rotation", "StereoRotation",  "FL", "1" },
        { 0x0022, 0x0015,
          "Acquisition Device Type Code Sequence", "AcquisitionDeviceTypeCodeSequence",  "SQ", "1" },
        { 0x0022, 0x0016,
          "Illumination Type Code Sequence", "IlluminationTypeCodeSequence",  "SQ", "1" },
        { 0x0022, 0x0017,
          "Light Path Filter Type Stack Code Sequence", "LightPathFilterTypeStackCodeSequence",  "SQ", "1" },
        { 0x0022, 0x0018,
          "Image Path Filter Type Stack Code Sequence", "ImagePathFilterTypeStackCodeSequence",  "SQ", "1" },
        { 0x0022, 0x0019,
          "Lenses Code Sequence", "LensesCodeSequence",  "SQ", "1" },
        { 0x0022, 0x001a,
          "Channel Description Code Sequence", "ChannelDescriptionCodeSequence",  "SQ", "1" },
        { 0x0022, 0x001b,
          "Refractive State Sequence", "RefractiveStateSequence",  "SQ", "1" },
        { 0x0022, 0x001c,
          "Mydriatic Agent Code Sequence", "MydriaticAgentCodeSequence",  "SQ", "1" },
        { 0x0022, 0x001d,
          "Relative Image Position Code Sequence", "RelativeImagePositionCodeSequence",  "SQ", "1" },
        { 0x0022, 0x001e,
          "Camera Angle of View", "CameraAngleOfView",  "FL", "1" },
        { 0x0022, 0x0020,
          "Stereo Pairs Sequence", "StereoPairsSequence",  "SQ", "1" },
        { 0x0022, 0x0021,
          "Left Image Sequence", "LeftImageSequence",  "SQ", "1" },
        { 0x0022, 0x0022,
          "Right Image Sequence", "RightImageSequence",  "SQ", "1" },
        { 0x0022, 0x0028,
          "Stereo Pairs Present", "StereoPairsPresent",  "CS", "1" },
        { 0x0022, 0x0030,
          "Axial Length of the Eye", "AxialLengthOfTheEye",  "FL", "1" },
        { 0x0022, 0x0031,
          "Ophthalmic Frame Location Sequence", "OphthalmicFrameLocationSequence",  "SQ", "1" },
        { 0x0022, 0x0032,
          "Reference Coordinates", "ReferenceCoordinates",  "FL", "2-2n" },
        { 0x0022, 0x0035,
          "Depth Spatial Resolution", "DepthSpatialResolution",  "FL", "1" },
        { 0x0022, 0x0036,
          "Maximum Depth Distortion", "MaximumDepthDistortion",  "FL", "1" },
        { 0x0022, 0x0037,
          "Along-scan Spatial Resolution", "AlongScanSpatialResolution",  "FL", "1" },
        { 0x0022, 0x0038,
          "Maximum Along-scan Distortion", "MaximumAlongScanDistortion",  "FL", "1" },
        { 0x0022, 0x0039,
          "Ophthalmic Image Orientation", "OphthalmicImageOrientation",  "CS", "1" },
        { 0x0022, 0x0041,
          "Depth of Transverse Image", "DepthOfTransverseImage",  "FL", "1" },
        { 0x0022, 0x0042,
          "Mydriatic Agent Concentration Units Sequence", "MydriaticAgentConcentrationUnitsSequence",  "SQ", "1" },
        { 0x0022, 0x0048,
          "Across-scan Spatial Resolution", "AcrossScanSpatialResolution",  "FL", "1" },
        { 0x0022, 0x0049,
          "Maximum Across-scan Distortion", "MaximumAcrossScanDistortion",  "FL", "1" },
        { 0x0022, 0x004e,
          "Mydriatic Agent Concentration", "MydriaticAgentConcentration",  "DS", "1" },
        { 0x0022, 0x0055,
          "Illumination Wave Length", "IlluminationWaveLength",  "FL", "1" },
        { 0x0022, 0x0056,
          "Illumination Power", "IlluminationPower",  "FL", "1" },
        { 0x0022, 0x0057,
          "Illumination Bandwidth", "IlluminationBandwidth",  "FL", "1" },
        { 0x0022, 0x0058,
          "Mydriatic Agent Sequence", "MydriaticAgentSequence",  "SQ", "1" },
        { 0x0022, 0x1007,
          "Ophthalmic Axial Measurements Right Eye Sequence", "OphthalmicAxialMeasurementsRightEyeSequence",  "SQ", "1" },
        { 0x0022, 0x1008,
          "Ophthalmic Axial Measurements Left Eye Sequence", "OphthalmicAxialMeasurementsLeftEyeSequence",  "SQ", "1" },
        { 0x0022, 0x1009,
          "Ophthalmic Axial Measurements Device Type", "OphthalmicAxialMeasurementsDeviceType",  "CS", "1" },
        { 0x0022, 0x1010,
          "Ophthalmic Axial Length Measurements Type", "OphthalmicAxialLengthMeasurementsType",  "CS", "1" },
        { 0x0022, 0x1012,
          "Ophthalmic Axial Length Sequence", "OphthalmicAxialLengthSequence",  "SQ", "1" },
        { 0x0022, 0x1019,
          "Ophthalmic Axial Length", "OphthalmicAxialLength",  "FL", "1" },
        { 0x0022, 0x1024,
          "Lens Status Code Sequence", "LensStatusCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1025,
          "Vitreous Status Code Sequence", "VitreousStatusCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1028,
          "IOL Formula Code Sequence", "IOLFormulaCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1029,
          "IOL Formula Detail", "IOLFormulaDetail",  "LO", "1" },
        { 0x0022, 0x1033,
          "Keratometer Index", "KeratometerIndex",  "FL", "1" },
        { 0x0022, 0x1035,
          "Source of Ophthalmic Axial Length Code Sequence", "SourceOfOphthalmicAxialLengthCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1037,
          "Target Refraction", "TargetRefraction",  "FL", "1" },
        { 0x0022, 0x1039,
          "Refractive Procedure Occurred", "RefractiveProcedureOccurred",  "CS", "1" },
        { 0x0022, 0x1040,
          "Refractive Surgery Type Code Sequence", "RefractiveSurgeryTypeCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1044,
          "Ophthalmic Ultrasound Method Code Sequence", "OphthalmicUltrasoundMethodCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1050,
          "Ophthalmic Axial Length Measurements Sequence", "OphthalmicAxialLengthMeasurementsSequence",  "SQ", "1" },
        { 0x0022, 0x1053,
          "IOL Power", "IOLPower",  "FL", "1" },
        { 0x0022, 0x1054,
          "Predicted Refractive Error", "PredictedRefractiveError",  "FL", "1" },
        { 0x0022, 0x1059,
          "Ophthalmic Axial Length Velocity", "OphthalmicAxialLengthVelocity",  "FL", "1" },
        { 0x0022, 0x1065,
          "Lens Status Description", "LensStatusDescription",  "LO", "1" },
        { 0x0022, 0x1066,
          "Vitreous Status Description", "VitreousStatusDescription",  "LO", "1" },
        { 0x0022, 0x1090,
          "IOL Power Sequence", "IOLPowerSequence",  "SQ", "1" },
        { 0x0022, 0x1092,
          "Lens Constant Sequence", "LensConstantSequence",  "SQ", "1" },
        { 0x0022, 0x1093,
          "IOL Manufacturer", "IOLManufacturer",  "LO", "1" },
        { 0x0022, 0x1094,
          "Lens Constant Description", "LensConstantDescription",  "LO", "1" },
        { 0x0022, 0x1095,
          "Implant Name", "ImplantName",  "LO", "1" },
        { 0x0022, 0x1096,
          "Keratometry Measurement Type Code Sequence", "KeratometryMeasurementTypeCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1097,
          "Implant Part Number", "ImplantPartNumber",  "LO", "1" },
        { 0x0022, 0x1100,
          "Referenced Ophthalmic Axial Measurements Sequence", "ReferencedOphthalmicAxialMeasurementsSequence",  "SQ", "1" },
        { 0x0022, 0x1101,
          "Ophthalmic Axial Length Measurements Segment Name Code Sequence", "OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1103,
          "Refractive Error Before Refractive Surgery Code Sequence", "RefractiveErrorBeforeRefractiveSurgeryCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1121,
          "IOL Power For Exact Emmetropia", "IOLPowerForExactEmmetropia",  "FL", "1" },
        { 0x0022, 0x1122,
          "IOL Power For Exact Target Refraction", "IOLPowerForExactTargetRefraction",  "FL", "1" },
        { 0x0022, 0x1125,
          "Anterior Chamber Depth Definition Code Sequence", "AnteriorChamberDepthDefinitionCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1127,
          "Lens Thickness Sequence", "LensThicknessSequence",  "SQ", "1" },
        { 0x0022, 0x1128,
          "Anterior Chamber Depth Sequence", "AnteriorChamberDepthSequence",  "SQ", "1" },
        { 0x0022, 0x1130,
          "Lens Thickness", "LensThickness",  "FL", "1" },
        { 0x0022, 0x1131,
          "Anterior Chamber Depth", "AnteriorChamberDepth",  "FL", "1" },
        { 0x0022, 0x1132,
          "Source of Lens Thickness Data Code Sequence", "SourceOfLensThicknessDataCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1133,
          "Source of Anterior Chamber Depth Data Code Sequence", "SourceOfAnteriorChamberDepthDataCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1134,
          "Source of Refractive Measurements Sequence", "SourceOfRefractiveMeasurementsSequence",  "SQ", "1" },
        { 0x0022, 0x1135,
          "Source of Refractive Measurements Code Sequence", "SourceOfRefractiveMeasurementsCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1140,
          "Ophthalmic Axial Length Measurement Modified", "OphthalmicAxialLengthMeasurementModified",  "CS", "1" },
        { 0x0022, 0x1150,
          "Ophthalmic Axial Length Data Source Code Sequence", "OphthalmicAxialLengthDataSourceCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1153,
          "Ophthalmic Axial Length Acquisition Method Code Sequence", "OphthalmicAxialLengthAcquisitionMethodCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1155,
          "Signal to Noise Ratio", "SignalToNoiseRatio",  "FL", "1" },
        { 0x0022, 0x1159,
          "Ophthalmic Axial Length Data Source Description", "OphthalmicAxialLengthDataSourceDescription",  "LO", "1" },
        { 0x0022, 0x1210,
          "Ophthalmic Axial Length Measurements Total Length Sequence", "OphthalmicAxialLengthMeasurementsTotalLengthSequence",  "SQ", "1" },
        { 0x0022, 0x1211,
          "Ophthalmic Axial Length Measurements Segmental Length Sequence", "OphthalmicAxialLengthMeasurementsSegmentalLengthSequence",  "SQ", "1" },
        { 0x0022, 0x1212,
          "Ophthalmic Axial Length Measurements Length Summation Sequence", "OphthalmicAxialLengthMeasurementsLengthSummationSequence",  "SQ", "1" },
        { 0x0022, 0x1220,
          "Ultrasound Ophthalmic Axial Length Measurements Sequence", "UltrasoundOphthalmicAxialLengthMeasurementsSequence",  "SQ", "1" },
        { 0x0022, 0x1225,
          "Optical Ophthalmic Axial Length Measurements Sequence", "OpticalOphthalmicAxialLengthMeasurementsSequence",  "SQ", "1" },
        { 0x0022, 0x1230,
          "Ultrasound Selected Ophthalmic Axial Length Sequence", "UltrasoundSelectedOphthalmicAxialLengthSequence",  "SQ", "1" },
        { 0x0022, 0x1250,
          "Ophthalmic Axial Length Selection Method Code Sequence", "OphthalmicAxialLengthSelectionMethodCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1255,
          "Optical Selected Ophthalmic Axial Length Sequence", "OpticalSelectedOphthalmicAxialLengthSequence",  "SQ", "1" },
        { 0x0022, 0x1257,
          "Selected Segmental Ophthalmic Axial Length Sequence", "SelectedSegmentalOphthalmicAxialLengthSequence",  "SQ", "1" },
        { 0x0022, 0x1260,
          "Selected Total Ophthalmic Axial Length Sequence", "SelectedTotalOphthalmicAxialLengthSequence",  "SQ", "1" },
        { 0x0022, 0x1262,
          "Ophthalmic Axial Length Quality Metric Sequence", "OphthalmicAxialLengthQualityMetricSequence",  "SQ", "1" },
        { 0x0022, 0x1265,
          "Ophthalmic Axial Length Quality Metric Type Code Sequence", "OphthalmicAxialLengthQualityMetricTypeCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1273,
          "Ophthalmic Axial Length Quality Metric Type Description", "OphthalmicAxialLengthQualityMetricTypeDescription",  "LO", "1" },
        { 0x0022, 0x1300,
          "Intraocular Lens Calculations Right Eye Sequence", "IntraocularLensCalculationsRightEyeSequence",  "SQ", "1" },
        { 0x0022, 0x1310,
          "Intraocular Lens Calculations Left Eye Sequence", "IntraocularLensCalculationsLeftEyeSequence",  "SQ", "1" },
        { 0x0022, 0x1330,
          "Referenced Ophthalmic Axial Length Measurement QC Image Sequence", "ReferencedOphthalmicAxialLengthMeasurementQCImageSequence",  "SQ", "1" },
        { 0x0022, 0x1415,
          "Ophthalmic Mapping Device Type", "OphthalmicMappingDeviceType",  "CS", "1" },
        { 0x0022, 0x1420,
          "Acquisition Method Code Sequence", "AcquisitionMethodCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1423,
          "Acquisition Method Algorithm Sequence", "AcquisitionMethodAlgorithmSequence",  "SQ", "1" },
        { 0x0022, 0x1436,
          "Ophthalmic Thickness Map Type Code Sequence", "OphthalmicThicknessMapTypeCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1443,
          "Ophthalmic Thickness Mapping Normals Sequence", "OphthalmicThicknessMappingNormalsSequence",  "SQ", "1" },
        { 0x0022, 0x1445,
          "Retinal Thickness Definition Code Sequence", "RetinalThicknessDefinitionCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1450,
          "Pixel Value Mapping to Coded Concept Sequence", "PixelValueMappingToCodedConceptSequence",  "SQ", "1" },
        { 0x0022, 0x1452,
          "Mapped Pixel Value", "MappedPixelValue",  "US or SS", "1" },
        { 0x0022, 0x1454,
          "Pixel Value Mapping Explanation", "PixelValueMappingExplanation",  "LO", "1" },
        { 0x0022, 0x1458,
          "Ophthalmic Thickness Map Quality Threshold Sequence", "OphthalmicThicknessMapQualityThresholdSequence",  "SQ", "1" },
        { 0x0022, 0x1460,
          "Ophthalmic Thickness Map Threshold Quality Rating", "OphthalmicThicknessMapThresholdQualityRating",  "FL", "1" },
        { 0x0022, 0x1463,
          "Anatomic Structure Reference Point", "AnatomicStructureReferencePoint",  "FL", "2" },
        { 0x0022, 0x1465,
          "Registration to Localizer Sequence", "RegistrationToLocalizerSequence",  "SQ", "1" },
        { 0x0022, 0x1466,
          "Registered Localizer Units", "RegisteredLocalizerUnits",  "CS", "1" },
        { 0x0022, 0x1467,
          "Registered Localizer Top Left Hand Corner", "RegisteredLocalizerTopLeftHandCorner",  "FL", "2" },
        { 0x0022, 0x1468,
          "Registered Localizer Bottom Right Hand Corner", "RegisteredLocalizerBottomRightHandCorner",  "FL", "2" },
        { 0x0022, 0x1470,
          "Ophthalmic Thickness Map Quality Rating Sequence", "OphthalmicThicknessMapQualityRatingSequence",  "SQ", "1" },
        { 0x0022, 0x1472,
          "Relevant OPT Attributes Sequence", "RelevantOPTAttributesSequence",  "SQ", "1" },
        { 0x0022, 0x1512,
          "Transformation Method Code Sequence", "TransformationMethodCodeSequence",  "SQ", "1" },
        { 0x0022, 0x1513,
          "Transformation Algorithm Sequence", "TransformationAlgorithmSequence",  "SQ", "1" },
        { 0x0022, 0x1515,
          "Ophthalmic Axial Length Method", "OphthalmicAxialLengthMethod",  "CS", "1" },
        { 0x0022, 0x1517,
          "Ophthalmic FOV", "OphthalmicFOV",  "FL", "1" },
        { 0x0022, 0x1518,
          "Two Dimensional to Three Dimensional Map Sequence", "TwoDimensionalToThreeDimensionalMapSequence",  "SQ", "1" },
        { 0x0022, 0x1525,
          "Wide Field Ophthalmic Photography Quality Rating Sequence", "WideFieldOphthalmicPhotographyQualityRatingSequence",  "SQ", "1" },
        { 0x0022, 0x1526,
          "Wide Field Ophthalmic Photography Quality Threshold Sequence", "WideFieldOphthalmicPhotographyQualityThresholdSequence",  "SQ", "1" },
        { 0x0022, 0x1527,
          "Wide Field Ophthalmic Photography  Threshold Quality Rating", "WideFieldOphthalmicPhotographyThresholdQualityRating",  "FL", "1" },
        { 0x0022, 0x1528,
          "X Coordinates Center Pixel View Angle", "XCoordinatesCenterPixelViewAngle",  "FL", "1" },
        { 0x0022, 0x1529,
          "Y Coordinates Center Pixel View Angle", "YCoordinatesCenterPixelViewAngle",  "FL", "1" },
        { 0x0022, 0x1530,
          "Number of Map Points", "NumberOfMapPoints",  "UL", "1" },
        { 0x0022, 0x1531,
          "Two Dimensional to Three Dimensional Map Data", "TwoDimensionalToThreeDimensionalMapData",  "OF", "1" },
        { 0x0024, 0x0010,
          "Visual Field Horizontal Extent", "VisualFieldHorizontalExtent",  "FL", "1" },
        { 0x0024, 0x0011,
          "Visual Field Vertical Extent", "VisualFieldVerticalExtent",  "FL", "1" },
        { 0x0024, 0x0012,
          "Visual Field Shape", "VisualFieldShape",  "CS", "1" },
        { 0x0024, 0x0016,
          "Screening Test Mode Code Sequence", "ScreeningTestModeCodeSequence",  "SQ", "1" },
        { 0x0024, 0x0018,
          "Maximum Stimulus Luminance", "MaximumStimulusLuminance",  "FL", "1" },
        { 0x0024, 0x0020,
          "Background Luminance", "BackgroundLuminance",  "FL", "1" },
        { 0x0024, 0x0021,
          "Stimulus Color Code Sequence", "StimulusColorCodeSequence",  "SQ", "1" },
        { 0x0024, 0x0024,
          "Background Illumination Color Code Sequence", "BackgroundIlluminationColorCodeSequence",  "SQ", "1" },
        { 0x0024, 0x0025,
          "Stimulus Area", "StimulusArea",  "FL", "1" },
        { 0x0024, 0x0028,
          "Stimulus Presentation Time", "StimulusPresentationTime",  "FL", "1" },
        { 0x0024, 0x0032,
          "Fixation Sequence", "FixationSequence",  "SQ", "1" },
        { 0x0024, 0x0033,
          "Fixation Monitoring Code Sequence", "FixationMonitoringCodeSequence",  "SQ", "1" },
        { 0x0024, 0x0034,
          "Visual Field Catch Trial Sequence", "VisualFieldCatchTrialSequence",  "SQ", "1" },
        { 0x0024, 0x0035,
          "Fixation Checked Quantity", "FixationCheckedQuantity",  "US", "1" },
        { 0x0024, 0x0036,
          "Patient Not Properly Fixated Quantity", "PatientNotProperlyFixatedQuantity",  "US", "1" },
        { 0x0024, 0x0037,
          "Presented Visual Stimuli Data Flag", "PresentedVisualStimuliDataFlag",  "CS", "1" },
        { 0x0024, 0x0038,
          "Number of Visual Stimuli", "NumberOfVisualStimuli",  "US", "1" },
        { 0x0024, 0x0039,
          "Excessive Fixation Losses Data Flag", "ExcessiveFixationLossesDataFlag",  "CS", "1" },
        { 0x0024, 0x0040,
          "Excessive Fixation Losses", "ExcessiveFixationLosses",  "CS", "1" },
        { 0x0024, 0x0042,
          "Stimuli Retesting Quantity", "StimuliRetestingQuantity",  "US", "1" },
        { 0x0024, 0x0044,
          "Comments on Patient's Performance of Visual Field", "CommentsOnPatientPerformanceOfVisualField",  "LT", "1" },
        { 0x0024, 0x0045,
          "False Negatives Estimate Flag", "FalseNegativesEstimateFlag",  "CS", "1" },
        { 0x0024, 0x0046,
          "False Negatives Estimate", "FalseNegativesEstimate",  "FL", "1" },
        { 0x0024, 0x0048,
          "Negative Catch Trials Quantity", "NegativeCatchTrialsQuantity",  "US", "1" },
        { 0x0024, 0x0050,
          "False Negatives Quantity", "FalseNegativesQuantity",  "US", "1" },
        { 0x0024, 0x0051,
          "Excessive False Negatives Data Flag", "ExcessiveFalseNegativesDataFlag",  "CS", "1" },
        { 0x0024, 0x0052,
          "Excessive False Negatives", "ExcessiveFalseNegatives",  "CS", "1" },
        { 0x0024, 0x0053,
          "False Positives Estimate Flag", "FalsePositivesEstimateFlag",  "CS", "1" },
        { 0x0024, 0x0054,
          "False Positives Estimate", "FalsePositivesEstimate",  "FL", "1" },
        { 0x0024, 0x0055,
          "Catch Trials Data Flag", "CatchTrialsDataFlag",  "CS", "1" },
        { 0x0024, 0x0056,
          "Positive Catch Trials Quantity", "PositiveCatchTrialsQuantity",  "US", "1" },
        { 0x0024, 0x0057,
          "Test Point Normals Data Flag", "TestPointNormalsDataFlag",  "CS", "1" },
        { 0x0024, 0x0058,
          "Test Point Normals Sequence", "TestPointNormalsSequence",  "SQ", "1" },
        { 0x0024, 0x0059,
          "Global Deviation Probability Normals Flag", "GlobalDeviationProbabilityNormalsFlag",  "CS", "1" },
        { 0x0024, 0x0060,
          "False Positives Quantity", "FalsePositivesQuantity",  "US", "1" },
        { 0x0024, 0x0061,
          "Excessive False Positives Data Flag", "ExcessiveFalsePositivesDataFlag",  "CS", "1" },
        { 0x0024, 0x0062,
          "Excessive False Positives", "ExcessiveFalsePositives",  "CS", "1" },
        { 0x0024, 0x0063,
          "Visual Field Test Normals Flag", "VisualFieldTestNormalsFlag",  "CS", "1" },
        { 0x0024, 0x0064,
          "Results Normals Sequence", "ResultsNormalsSequence",  "SQ", "1" },
        { 0x0024, 0x0065,
          "Age Corrected Sensitivity Deviation Algorithm Sequence", "AgeCorrectedSensitivityDeviationAlgorithmSequence",  "SQ", "1" },
        { 0x0024, 0x0066,
          "Global Deviation From Normal", "GlobalDeviationFromNormal",  "FL", "1" },
        { 0x0024, 0x0067,
          "Generalized Defect Sensitivity Deviation Algorithm Sequence", "GeneralizedDefectSensitivityDeviationAlgorithmSequence",  "SQ", "1" },
        { 0x0024, 0x0068,
          "Localized Deviation From Normal", "LocalizedDeviationFromNormal",  "FL", "1" },
        { 0x0024, 0x0069,
          "Patient Reliability Indicator", "PatientReliabilityIndicator",  "LO", "1" },
        { 0x0024, 0x0070,
          "Visual Field Mean Sensitivity", "VisualFieldMeanSensitivity",  "FL", "1" },
        { 0x0024, 0x0071,
          "Global Deviation Probability", "GlobalDeviationProbability",  "FL", "1" },
        { 0x0024, 0x0072,
          "Local Deviation Probability Normals Flag", "LocalDeviationProbabilityNormalsFlag",  "CS", "1" },
        { 0x0024, 0x0073,
          "Localized Deviation Probability", "LocalizedDeviationProbability",  "FL", "1" },
        { 0x0024, 0x0074,
          "Short Term Fluctuation Calculated", "ShortTermFluctuationCalculated",  "CS", "1" },
        { 0x0024, 0x0075,
          "Short Term Fluctuation", "ShortTermFluctuation",  "FL", "1" },
        { 0x0024, 0x0076,
          "Short Term Fluctuation Probability Calculated", "ShortTermFluctuationProbabilityCalculated",  "CS", "1" },
        { 0x0024, 0x0077,
          "Short Term Fluctuation Probability", "ShortTermFluctuationProbability",  "FL", "1" },
        { 0x0024, 0x0078,
          "Corrected Localized Deviation From Normal Calculated", "CorrectedLocalizedDeviationFromNormalCalculated",  "CS", "1" },
        { 0x0024, 0x0079,
          "Corrected Localized Deviation From Normal", "CorrectedLocalizedDeviationFromNormal",  "FL", "1" },
        { 0x0024, 0x0080,
          "Corrected Localized Deviation From Normal Probability Calculated", "CorrectedLocalizedDeviationFromNormalProbabilityCalculated",  "CS", "1" },
        { 0x0024, 0x0081,
          "Corrected Localized Deviation From Normal Probability", "CorrectedLocalizedDeviationFromNormalProbability",  "FL", "1" },
        { 0x0024, 0x0083,
          "Global Deviation Probability Sequence", "GlobalDeviationProbabilitySequence",  "SQ", "1" },
        { 0x0024, 0x0085,
          "Localized Deviation Probability Sequence", "LocalizedDeviationProbabilitySequence",  "SQ", "1" },
        { 0x0024, 0x0086,
          "Foveal Sensitivity Measured", "FovealSensitivityMeasured",  "CS", "1" },
        { 0x0024, 0x0087,
          "Foveal Sensitivity", "FovealSensitivity",  "FL", "1" },
        { 0x0024, 0x0088,
          "Visual Field Test Duration", "VisualFieldTestDuration",  "FL", "1" },
        { 0x0024, 0x0089,
          "Visual Field Test Point Sequence", "VisualFieldTestPointSequence",  "SQ", "1" },
        { 0x0024, 0x0090,
          "Visual Field Test Point X-Coordinate", "VisualFieldTestPointXCoordinate",  "FL", "1" },
        { 0x0024, 0x0091,
          "Visual Field Test Point Y-Coordinate", "VisualFieldTestPointYCoordinate",  "FL", "1" },
        { 0x0024, 0x0092,
          "Age Corrected Sensitivity Deviation Value", "AgeCorrectedSensitivityDeviationValue",  "FL", "1" },
        { 0x0024, 0x0093,
          "Stimulus Results", "StimulusResults",  "CS", "1" },
        { 0x0024, 0x0094,
          "Sensitivity Value", "SensitivityValue",  "FL", "1" },
        { 0x0024, 0x0095,
          "Retest Stimulus Seen", "RetestStimulusSeen",  "CS", "1" },
        { 0x0024, 0x0096,
          "Retest Sensitivity Value", "RetestSensitivityValue",  "FL", "1" },
        { 0x0024, 0x0097,
          "Visual Field Test Point Normals Sequence", "VisualFieldTestPointNormalsSequence",  "SQ", "1" },
        { 0x0024, 0x0098,
          "Quantified Defect", "QuantifiedDefect",  "FL", "1" },
        { 0x0024, 0x0100,
          "Age Corrected Sensitivity Deviation Probability Value", "AgeCorrectedSensitivityDeviationProbabilityValue",  "FL", "1" },
        { 0x0024, 0x0102,
          "Generalized Defect Corrected Sensitivity Deviation Flag", "GeneralizedDefectCorrectedSensitivityDeviationFlag",  "CS", "1" },
        { 0x0024, 0x0103,
          "Generalized Defect Corrected Sensitivity Deviation Value", "GeneralizedDefectCorrectedSensitivityDeviationValue",  "FL", "1" },
        { 0x0024, 0x0104,
          "Generalized Defect Corrected Sensitivity Deviation Probability Value", "GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue",  "FL", "1" },
        { 0x0024, 0x0105,
          "Minimum Sensitivity Value", "MinimumSensitivityValue",  "FL", "1" },
        { 0x0024, 0x0106,
          "Blind Spot Localized", "BlindSpotLocalized",  "CS", "1" },
        { 0x0024, 0x0107,
          "Blind Spot X-Coordinate", "BlindSpotXCoordinate",  "FL", "1" },
        { 0x0024, 0x0108,
          "Blind Spot Y-Coordinate", "BlindSpotYCoordinate",  "FL", "1" },
        { 0x0024, 0x0110,
          "Visual Acuity Measurement Sequence", "VisualAcuityMeasurementSequence",  "SQ", "1" },
        { 0x0024, 0x0112,
          "Refractive Parameters Used on Patient Sequence", "RefractiveParametersUsedOnPatientSequence",  "SQ", "1" },
        { 0x0024, 0x0113,
          "Measurement Laterality", "MeasurementLaterality",  "CS", "1" },
        { 0x0024, 0x0114,
          "Ophthalmic Patient Clinical Information Left Eye Sequence", "OphthalmicPatientClinicalInformationLeftEyeSequence",  "SQ", "1" },
        { 0x0024, 0x0115,
          "Ophthalmic Patient Clinical Information Right Eye Sequence", "OphthalmicPatientClinicalInformationRightEyeSequence",  "SQ", "1" },
        { 0x0024, 0x0117,
          "Foveal Point Normative Data Flag", "FovealPointNormativeDataFlag",  "CS", "1" },
        { 0x0024, 0x0118,
          "Foveal Point Probability Value", "FovealPointProbabilityValue",  "FL", "1" },
        { 0x0024, 0x0120,
          "Screening Baseline Measured", "ScreeningBaselineMeasured",  "CS", "1" },
        { 0x0024, 0x0122,
          "Screening Baseline Measured Sequence", "ScreeningBaselineMeasuredSequence",  "SQ", "1" },
        { 0x0024, 0x0124,
          "Screening Baseline Type", "ScreeningBaselineType",  "CS", "1" },
        { 0x0024, 0x0126,
          "Screening Baseline Value", "ScreeningBaselineValue",  "FL", "1" },
        { 0x0024, 0x0202,
          "Algorithm Source", "AlgorithmSource",  "LO", "1" },
        { 0x0024, 0x0306,
          "Data Set Name", "DataSetName",  "LO", "1" },
        { 0x0024, 0x0307,
          "Data Set Version", "DataSetVersion",  "LO", "1" },
        { 0x0024, 0x0308,
          "Data Set Source", "DataSetSource",  "LO", "1" },
        { 0x0024, 0x0309,
          "Data Set Description", "DataSetDescription",  "LO", "1" },
        { 0x0024, 0x0317,
          "Visual Field Test Reliability Global Index Sequence", "VisualFieldTestReliabilityGlobalIndexSequence",  "SQ", "1" },
        { 0x0024, 0x0320,
          "Visual Field Global Results Index Sequence", "VisualFieldGlobalResultsIndexSequence",  "SQ", "1" },
        { 0x0024, 0x0325,
          "Data Observation Sequence", "DataObservationSequence",  "SQ", "1" },
        { 0x0024, 0x0338,
          "Index Normals Flag", "IndexNormalsFlag",  "CS", "1" },
        { 0x0024, 0x0341,
          "Index Probability", "IndexProbability",  "FL", "1" },
        { 0x0024, 0x0344,
          "Index Probability Sequence", "IndexProbabilitySequence",  "SQ", "1" },
        { 0x0028, 0x0002,
          "Samples per Pixel", "SamplesPerPixel",  "US", "1" },
        { 0x0028, 0x0003,
          "Samples per Pixel Used", "SamplesPerPixelUsed",  "US", "1" },
        { 0x0028, 0x0004,
          "Photometric Interpretation", "PhotometricInterpretation",  "CS", "1" },
        { 0x0028, 0x0005,
          "Image Dimensions", "ImageDimensions",  "US", "1" },
        { 0x0028, 0x0006,
          "Planar Configuration", "PlanarConfiguration",  "US", "1" },
        { 0x0028, 0x0008,
          "Number of Frames", "NumberOfFrames",  "IS", "1" },
        { 0x0028, 0x0009,
          "Frame Increment Pointer", "FrameIncrementPointer",  "AT", "1-n" },
        { 0x0028, 0x000a,
          "Frame Dimension Pointer", "FrameDimensionPointer",  "AT", "1-n" },
        { 0x0028, 0x0010,
          "Rows", "Rows",  "US", "1" },
        { 0x0028, 0x0011,
          "Columns", "Columns",  "US", "1" },
        { 0x0028, 0x0012,
          "Planes", "Planes",  "US", "1" },
        { 0x0028, 0x0014,
          "Ultrasound Color Data Present", "UltrasoundColorDataPresent",  "US", "1" },
        { 0x0028, 0x0030,
          "Pixel Spacing", "PixelSpacing",  "DS", "2" },
        { 0x0028, 0x0031,
          "Zoom Factor", "ZoomFactor",  "DS", "2" },
        { 0x0028, 0x0032,
          "Zoom Center", "ZoomCenter",  "DS", "2" },
        { 0x0028, 0x0034,
          "Pixel Aspect Ratio", "PixelAspectRatio",  "IS", "2" },
        { 0x0028, 0x0040,
          "Image Format", "ImageFormat",  "CS", "1" },
        { 0x0028, 0x0050,
          "Manipulated Image", "ManipulatedImage",  "LO", "1-n" },
        { 0x0028, 0x0051,
          "Corrected Image", "CorrectedImage",  "CS", "1-n" },
        { 0x0028, 0x005f,
          "Compression Recognition Code", "CompressionRecognitionCode",  "LO", "1" },
        { 0x0028, 0x0060,
          "Compression Code", "CompressionCode",  "CS", "1" },
        { 0x0028, 0x0061,
          "Compression Originator", "CompressionOriginator",  "SH", "1" },
        { 0x0028, 0x0062,
          "Compression Label", "CompressionLabel",  "LO", "1" },
        { 0x0028, 0x0063,
          "Compression Description", "CompressionDescription",  "SH", "1" },
        { 0x0028, 0x0065,
          "Compression Sequence", "CompressionSequence",  "CS", "1-n" },
        { 0x0028, 0x0066,
          "Compression Step Pointers", "CompressionStepPointers",  "AT", "1-n" },
        { 0x0028, 0x0068,
          "Repeat Interval", "RepeatInterval",  "US", "1" },
        { 0x0028, 0x0069,
          "Bits Grouped", "BitsGrouped",  "US", "1" },
        { 0x0028, 0x0070,
          "Perimeter Table", "PerimeterTable",  "US", "1-n" },
        { 0x0028, 0x0071,
          "Perimeter Value", "PerimeterValue",  "US or SS", "1" },
        { 0x0028, 0x0080,
          "Predictor Rows", "PredictorRows",  "US", "1" },
        { 0x0028, 0x0081,
          "Predictor Columns", "PredictorColumns",  "US", "1" },
        { 0x0028, 0x0082,
          "Predictor Constants", "PredictorConstants",  "US", "1-n" },
        { 0x0028, 0x0090,
          "Blocked Pixels", "BlockedPixels",  "CS", "1" },
        { 0x0028, 0x0091,
          "Block Rows", "BlockRows",  "US", "1" },
        { 0x0028, 0x0092,
          "Block Columns", "BlockColumns",  "US", "1" },
        { 0x0028, 0x0093,
          "Row Overlap", "RowOverlap",  "US", "1" },
        { 0x0028, 0x0094,
          "Column Overlap", "ColumnOverlap",  "US", "1" },
        { 0x0028, 0x0100,
          "Bits Allocated", "BitsAllocated",  "US", "1" },
        { 0x0028, 0x0101,
          "Bits Stored", "BitsStored",  "US", "1" },
        { 0x0028, 0x0102,
          "High Bit", "HighBit",  "US", "1" },
        { 0x0028, 0x0103,
          "Pixel Representation", "PixelRepresentation",  "US", "1" },
        { 0x0028, 0x0104,
          "Smallest Valid Pixel Value", "SmallestValidPixelValue",  "US or SS", "1" },
        { 0x0028, 0x0105,
          "Largest Valid Pixel Value", "LargestValidPixelValue",  "US or SS", "1" },
        { 0x0028, 0x0106,
          "Smallest Image Pixel Value", "SmallestImagePixelValue",  "US or SS", "1" },
        { 0x0028, 0x0107,
          "Largest Image Pixel Value", "LargestImagePixelValue",  "US or SS", "1" },
        { 0x0028, 0x0108,
          "Smallest Pixel Value in Series", "SmallestPixelValueInSeries",  "US or SS", "1" },
        { 0x0028, 0x0109,
          "Largest Pixel Value in Series", "LargestPixelValueInSeries",  "US or SS", "1" },
        { 0x0028, 0x0110,
          "Smallest Image Pixel Value in Plane", "SmallestImagePixelValueInPlane",  "US or SS", "1" },
        { 0x0028, 0x0111,
          "Largest Image Pixel Value in Plane", "LargestImagePixelValueInPlane",  "US or SS", "1" },
        { 0x0028, 0x0120,
          "Pixel Padding Value", "PixelPaddingValue",  "US or SS", "1" },
        { 0x0028, 0x0121,
          "Pixel Padding Range Limit", "PixelPaddingRangeLimit",  "US or SS", "1" },
        { 0x0028, 0x0122,
          "Float Pixel Padding Value", "FloatPixelPaddingValue",  "FL", "1" },
        { 0x0028, 0x0123,
          "Double Float Pixel Padding Value", "DoubleFloatPixelPaddingValue",  "FD", "1" },
        { 0x0028, 0x0124,
          "Float Pixel Padding Range Limit", "FloatPixelPaddingRangeLimit",  "FL", "1" },
        { 0x0028, 0x0125,
          "Double Float Pixel Padding Range Limit", "DoubleFloatPixelPaddingRangeLimit",  "FD", "1" },
        { 0x0028, 0x0200,
          "Image Location", "ImageLocation",  "US", "1" },
        { 0x0028, 0x0300,
          "Quality Control Image", "QualityControlImage",  "CS", "1" },
        { 0x0028, 0x0301,
          "Burned In Annotation", "BurnedInAnnotation",  "CS", "1" },
        { 0x0028, 0x0302,
          "Recognizable Visual Features", "RecognizableVisualFeatures",  "CS", "1" },
        { 0x0028, 0x0303,
          "Longitudinal Temporal Information Modified", "LongitudinalTemporalInformationModified",  "CS", "1" },
        { 0x0028, 0x0304,
          "Referenced Color Palette Instance UID", "ReferencedColorPaletteInstanceUID",  "UI", "1" },
        { 0x0028, 0x0400,
          "Transform Label", "TransformLabel",  "LO", "1" },
        { 0x0028, 0x0401,
          "Transform Version Number", "TransformVersionNumber",  "LO", "1" },
        { 0x0028, 0x0402,
          "Number of Transform Steps", "NumberOfTransformSteps",  "US", "1" },
        { 0x0028, 0x0403,
          "Sequence of Compressed Data", "SequenceOfCompressedData",  "LO", "1-n" },
        { 0x0028, 0x0404,
          "Details of Coefficients", "DetailsOfCoefficients",  "AT", "1-n" },
        { 0x0028, 0x0700,
          "DCT Label", "DCTLabel",  "LO", "1" },
        { 0x0028, 0x0701,
          "Data Block Description", "DataBlockDescription",  "CS", "1-n" },
        { 0x0028, 0x0702,
          "Data Block", "DataBlock",  "AT", "1-n" },
        { 0x0028, 0x0710,
          "Normalization Factor Format", "NormalizationFactorFormat",  "US", "1" },
        { 0x0028, 0x0720,
          "Zonal Map Number Format", "ZonalMapNumberFormat",  "US", "1" },
        { 0x0028, 0x0721,
          "Zonal Map Location", "ZonalMapLocation",  "AT", "1-n" },
        { 0x0028, 0x0722,
          "Zonal Map Format", "ZonalMapFormat",  "US", "1" },
        { 0x0028, 0x0730,
          "Adaptive Map Format", "AdaptiveMapFormat",  "US", "1" },
        { 0x0028, 0x0740,
          "Code Number Format", "CodeNumberFormat",  "US", "1" },
        { 0x0028, 0x0a02,
          "Pixel Spacing Calibration Type", "PixelSpacingCalibrationType",  "CS", "1" },
        { 0x0028, 0x0a04,
          "Pixel Spacing Calibration Description", "PixelSpacingCalibrationDescription",  "LO", "1" },
        { 0x0028, 0x1040,
          "Pixel Intensity Relationship", "PixelIntensityRelationship",  "CS", "1" },
        { 0x0028, 0x1041,
          "Pixel Intensity Relationship Sign", "PixelIntensityRelationshipSign",  "SS", "1" },
        { 0x0028, 0x1050,
          "Window Center", "WindowCenter",  "DS", "1-n" },
        { 0x0028, 0x1051,
          "Window Width", "WindowWidth",  "DS", "1-n" },
        { 0x0028, 0x1052,
          "Rescale Intercept", "RescaleIntercept",  "DS", "1" },
        { 0x0028, 0x1053,
          "Rescale Slope", "RescaleSlope",  "DS", "1" },
        { 0x0028, 0x1054,
          "Rescale Type", "RescaleType",  "LO", "1" },
        { 0x0028, 0x1055,
          "Window Center & Width Explanation", "WindowCenterWidthExplanation",  "LO", "1-n" },
        { 0x0028, 0x1056,
          "VOI LUT Function", "VOILUTFunction",  "CS", "1" },
        { 0x0028, 0x1080,
          "Gray Scale", "GrayScale",  "CS", "1" },
        { 0x0028, 0x1090,
          "Recommended Viewing Mode", "RecommendedViewingMode",  "CS", "1" },
        { 0x0028, 0x1100,
          "Gray Lookup Table Descriptor", "GrayLookupTableDescriptor",  "US or SS", "3" },
        { 0x0028, 0x1101,
          "Red Palette Color Lookup Table Descriptor", "RedPaletteColorLookupTableDescriptor",  "US or SS", "3" },
        { 0x0028, 0x1102,
          "Green Palette Color Lookup Table Descriptor", "GreenPaletteColorLookupTableDescriptor",  "US or SS", "3" },
        { 0x0028, 0x1103,
          "Blue Palette Color Lookup Table Descriptor", "BluePaletteColorLookupTableDescriptor",  "US or SS", "3" },
        { 0x0028, 0x1104,
          "Alpha Palette Color Lookup Table Descriptor", "AlphaPaletteColorLookupTableDescriptor",  "US", "3" },
        { 0x0028, 0x1111,
          "Large Red Palette Color Lookup Table Descriptor", "LargeRedPaletteColorLookupTableDescriptor",  "US or SS", "4" },
        { 0x0028, 0x1112,
          "Large Green Palette Color Lookup Table Descriptor", "LargeGreenPaletteColorLookupTableDescriptor",  "US or SS", "4" },
        { 0x0028, 0x1113,
          "Large Blue Palette Color Lookup Table Descriptor", "LargeBluePaletteColorLookupTableDescriptor",  "US or SS", "4" },
        { 0x0028, 0x1199,
          "Palette Color Lookup Table UID", "PaletteColorLookupTableUID",  "UI", "1" },
        { 0x0028, 0x1200,
          "Gray Lookup Table Data", "GrayLookupTableData",  "US or SS or OW", "1-n or 1" },
        { 0x0028, 0x1201,
          "Red Palette Color Lookup Table Data", "RedPaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1202,
          "Green Palette Color Lookup Table Data", "GreenPaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1203,
          "Blue Palette Color Lookup Table Data", "BluePaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1204,
          "Alpha Palette Color Lookup Table Data", "AlphaPaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1211,
          "Large Red Palette Color Lookup Table Data", "LargeRedPaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1212,
          "Large Green Palette Color Lookup Table Data", "LargeGreenPaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1213,
          "Large Blue Palette Color Lookup Table Data", "LargeBluePaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1214,
          "Large Palette Color Lookup Table UID", "LargePaletteColorLookupTableUID",  "UI", "1" },
        { 0x0028, 0x1221,
          "Segmented Red Palette Color Lookup Table Data", "SegmentedRedPaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1222,
          "Segmented Green Palette Color Lookup Table Data", "SegmentedGreenPaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1223,
          "Segmented Blue Palette Color Lookup Table Data", "SegmentedBluePaletteColorLookupTableData",  "OW", "1" },
        { 0x0028, 0x1300,
          "Breast Implant Present", "BreastImplantPresent",  "CS", "1" },
        { 0x0028, 0x1350,
          "Partial View", "PartialView",  "CS", "1" },
        { 0x0028, 0x1351,
          "Partial View Description", "PartialViewDescription",  "ST", "1" },
        { 0x0028, 0x1352,
          "Partial View Code Sequence", "PartialViewCodeSequence",  "SQ", "1" },
        { 0x0028, 0x135a,
          "Spatial Locations Preserved", "SpatialLocationsPreserved",  "CS", "1" },
        { 0x0028, 0x1401,
          "Data Frame Assignment Sequence", "DataFrameAssignmentSequence",  "SQ", "1" },
        { 0x0028, 0x1402,
          "Data Path Assignment", "DataPathAssignment",  "CS", "1" },
        { 0x0028, 0x1403,
          "Bits Mapped to Color Lookup Table", "BitsMappedToColorLookupTable",  "US", "1" },
        { 0x0028, 0x1404,
          "Blending LUT 1 Sequence", "BlendingLUT1Sequence",  "SQ", "1" },
        { 0x0028, 0x1405,
          "Blending LUT 1 Transfer Function", "BlendingLUT1TransferFunction",  "CS", "1" },
        { 0x0028, 0x1406,
          "Blending Weight Constant", "BlendingWeightConstant",  "FD", "1" },
        { 0x0028, 0x1407,
          "Blending Lookup Table Descriptor", "BlendingLookupTableDescriptor",  "US", "3" },
        { 0x0028, 0x1408,
          "Blending Lookup Table Data", "BlendingLookupTableData",  "OW", "1" },
        { 0x0028, 0x140b,
          "Enhanced Palette Color Lookup Table Sequence", "EnhancedPaletteColorLookupTableSequence",  "SQ", "1" },
        { 0x0028, 0x140c,
          "Blending LUT 2 Sequence", "BlendingLUT2Sequence",  "SQ", "1" },
        { 0x0028, 0x140d,
          "Blending LUT 2 Transfer Function", "BlendingLUT2TransferFunction",  "CS", "1" },
        { 0x0028, 0x140e,
          "Data Path ID", "DataPathID",  "CS", "1" },
        { 0x0028, 0x140f,
          "RGB LUT Transfer Function", "RGBLUTTransferFunction",  "CS", "1" },
        { 0x0028, 0x1410,
          "Alpha LUT Transfer Function", "AlphaLUTTransferFunction",  "CS", "1" },
        { 0x0028, 0x2000,
          "ICC Profile", "ICCProfile",  "OB", "1" },
        { 0x0028, 0x2110,
          "Lossy Image Compression", "LossyImageCompression",  "CS", "1" },
        { 0x0028, 0x2112,
          "Lossy Image Compression Ratio", "LossyImageCompressionRatio",  "DS", "1-n" },
        { 0x0028, 0x2114,
          "Lossy Image Compression Method", "LossyImageCompressionMethod",  "CS", "1-n" },
        { 0x0028, 0x3000,
          "Modality LUT Sequence", "ModalityLUTSequence",  "SQ", "1" },
        { 0x0028, 0x3002,
          "LUT Descriptor", "LUTDescriptor",  "US or SS", "3" },
        { 0x0028, 0x3003,
          "LUT Explanation", "LUTExplanation",  "LO", "1" },
        { 0x0028, 0x3004,
          "Modality LUT Type", "ModalityLUTType",  "LO", "1" },
        { 0x0028, 0x3006,
          "LUT Data", "LUTData",  "US or OW", "1-n or 1" },
        { 0x0028, 0x3010,
          "VOI LUT Sequence", "VOILUTSequence",  "SQ", "1" },
        { 0x0028, 0x3110,
          "Softcopy VOI LUT Sequence", "SoftcopyVOILUTSequence",  "SQ", "1" },
        { 0x0028, 0x4000,
          "Image Presentation Comments", "ImagePresentationComments",  "LT", "1" },
        { 0x0028, 0x5000,
          "Bi-Plane Acquisition Sequence", "BiPlaneAcquisitionSequence",  "SQ", "1" },
        { 0x0028, 0x6010,
          "Representative Frame Number", "RepresentativeFrameNumber",  "US", "1" },
        { 0x0028, 0x6020,
          "Frame Numbers of Interest (FOI)", "FrameNumbersOfInterest",  "US", "1-n" },
        { 0x0028, 0x6022,
          "Frame of Interest Description", "FrameOfInterestDescription",  "LO", "1-n" },
        { 0x0028, 0x6023,
          "Frame of Interest Type", "FrameOfInterestType",  "CS", "1-n" },
        { 0x0028, 0x6030,
          "Mask Pointer(s)", "MaskPointers",  "US", "1-n" },
        { 0x0028, 0x6040,
          "R Wave Pointer", "RWavePointer",  "US", "1-n" },
        { 0x0028, 0x6100,
          "Mask Subtraction Sequence", "MaskSubtractionSequence",  "SQ", "1" },
        { 0x0028, 0x6101,
          "Mask Operation", "MaskOperation",  "CS", "1" },
        { 0x0028, 0x6102,
          "Applicable Frame Range", "ApplicableFrameRange",  "US", "2-2n" },
        { 0x0028, 0x6110,
          "Mask Frame Numbers", "MaskFrameNumbers",  "US", "1-n" },
        { 0x0028, 0x6112,
          "Contrast Frame Averaging", "ContrastFrameAveraging",  "US", "1" },
        { 0x0028, 0x6114,
          "Mask Sub-pixel Shift", "MaskSubPixelShift",  "FL", "2" },
        { 0x0028, 0x6120,
          "TID Offset", "TIDOffset",  "SS", "1" },
        { 0x0028, 0x6190,
          "Mask Operation Explanation", "MaskOperationExplanation",  "ST", "1" },
        { 0x0028, 0x7000,
          "Equipment Administrator Sequence", "EquipmentAdministratorSequence",  "SQ", "1" },
        { 0x0028, 0x7001,
          "Number of Display Subsystems", "NumberOfDisplaySubsystems",  "US", "1" },
        { 0x0028, 0x7002,
          "Current Configuration ID", "CurrentConfigurationID",  "US", "1" },
        { 0x0028, 0x7003,
          "Display Subsystem ID", "DisplaySubsystemID",  "US", "1" },
        { 0x0028, 0x7004,
          "Display Subsystem Name", "DisplaySubsystemName",  "SH", "1" },
        { 0x0028, 0x7005,
          "Display Subsystem Description", "DisplaySubsystemDescription",  "LO", "1" },
        { 0x0028, 0x7006,
          "System Status", "SystemStatus",  "CS", "1" },
        { 0x0028, 0x7007,
          "System Status Comment", "SystemStatusComment",  "LO", "1" },
        { 0x0028, 0x7008,
          "Target Luminance Characteristics Sequence", "TargetLuminanceCharacteristicsSequence",  "SQ", "1" },
        { 0x0028, 0x7009,
          "Luminance Characteristics ID", "LuminanceCharacteristicsID",  "US", "1" },
        { 0x0028, 0x700a,
          "Display Subsystem Configuration Sequence", "DisplaySubsystemConfigurationSequence",  "SQ", "1" },
        { 0x0028, 0x700b,
          "Configuration ID", "ConfigurationID",  "US", "1" },
        { 0x0028, 0x700c,
          "Configuration Name", "ConfigurationName",  "SH", "1" },
        { 0x0028, 0x700d,
          "Configuration Description", "ConfigurationDescription",  "LO", "1" },
        { 0x0028, 0x700e,
          "Referenced Target Luminance Characteristics ID", "ReferencedTargetLuminanceCharacteristicsID",  "US", "1" },
        { 0x0028, 0x700f,
          "QA Results Sequence", "QAResultsSequence",  "SQ", "1" },
        { 0x0028, 0x7010,
          "Display Subsystem QA Results Sequence", "DisplaySubsystemQAResultsSequence",  "SQ", "1" },
        { 0x0028, 0x7011,
          "Configuration QA Results Sequence", "ConfigurationQAResultsSequence",  "SQ", "1" },
        { 0x0028, 0x7012,
          "Measurement Equipment Sequence", "MeasurementEquipmentSequence",  "SQ", "1" },
        { 0x0028, 0x7013,
          "Measurement Functions", "MeasurementFunctions",  "CS", "1-n" },
        { 0x0028, 0x7014,
          "Measurement Equipment Type", "MeasurementEquipmentType",  "CS", "1" },
        { 0x0028, 0x7015,
          "Visual Evaluation Result Sequence", "VisualEvaluationResultSequence",  "SQ", "1" },
        { 0x0028, 0x7016,
          "Display Calibration Result Sequence", "DisplayCalibrationResultSequence",  "SQ", "1" },
        { 0x0028, 0x7017,
          "DDL Value", "DDLValue",  "US", "1" },
        { 0x0028, 0x7018,
          "CIExy White Point", "CIExyWhitePoint",  "FL", "2" },
        { 0x0028, 0x7019,
          "Display Function Type", "DisplayFunctionType",  "CS", "1" },
        { 0x0028, 0x701a,
          "Gamma Value", "GammaValue",  "FL", "1" },
        { 0x0028, 0x701b,
          "Number of Luminance Points", "NumberOfLuminancePoints",  "US", "1" },
        { 0x0028, 0x701c,
          "Luminance Response Sequence", "LuminanceResponseSequence",  "SQ", "1" },
        { 0x0028, 0x701d,
          "Target Minimum Luminance", "TargetMinimumLuminance",  "FL", "1" },
        { 0x0028, 0x701e,
          "Target Maximum Luminance", "TargetMaximumLuminance",  "FL", "1" },
        { 0x0028, 0x701f,
          "Luminance Value", "LuminanceValue",  "FL", "1" },
        { 0x0028, 0x7020,
          "Luminance Response Description", "LuminanceResponseDescription",  "LO", "1" },
        { 0x0028, 0x7021,
          "White Point Flag", "WhitePointFlag",  "CS", "1" },
        { 0x0028, 0x7022,
          "Display Device Type Code Sequence", "DisplayDeviceTypeCodeSequence",  "SQ", "1" },
        { 0x0028, 0x7023,
          "Display Subsystem Sequence", "DisplaySubsystemSequence",  "SQ", "1" },
        { 0x0028, 0x7024,
          "Luminance Result Sequence", "LuminanceResultSequence",  "SQ", "1" },
        { 0x0028, 0x7025,
          "Ambient Light Value Source", "AmbientLightValueSource",  "CS", "1" },
        { 0x0028, 0x7026,
          "Measured Characteristics", "MeasuredCharacteristics",  "CS", "1-n" },
        { 0x0028, 0x7027,
          "Luminance Uniformity Result Sequence", "LuminanceUniformityResultSequence",  "SQ", "1" },
        { 0x0028, 0x7028,
          "Visual Evaluation Test Sequence", "VisualEvaluationTestSequence",  "SQ", "1" },
        { 0x0028, 0x7029,
          "Test Result", "TestResult",  "CS", "1" },
        { 0x0028, 0x702a,
          "Test Result Comment", "TestResultComment",  "LO", "1" },
        { 0x0028, 0x702b,
          "Test Image Validation", "TestImageValidation",  "CS", "1" },
        { 0x0028, 0x702c,
          "Test Pattern Code Sequence", "TestPatternCodeSequence",  "SQ", "1" },
        { 0x0028, 0x702d,
          "Measurement Pattern Code Sequence", "MeasurementPatternCodeSequence",  "SQ", "1" },
        { 0x0028, 0x702e,
          "Visual Evaluation Method Code Sequence", "VisualEvaluationMethodCodeSequence",  "SQ", "1" },
        { 0x0028, 0x7fe0,
          "Pixel Data Provider URL", "PixelDataProviderURL",  "UR", "1" },
        { 0x0028, 0x9001,
          "Data Point Rows", "DataPointRows",  "UL", "1" },
        { 0x0028, 0x9002,
          "Data Point Columns", "DataPointColumns",  "UL", "1" },
        { 0x0028, 0x9003,
          "Signal Domain Columns", "SignalDomainColumns",  "CS", "1" },
        { 0x0028, 0x9099,
          "Largest Monochrome Pixel Value", "LargestMonochromePixelValue",  "US", "1" },
        { 0x0028, 0x9108,
          "Data Representation", "DataRepresentation",  "CS", "1" },
        { 0x0028, 0x9110,
          "Pixel Measures Sequence", "PixelMeasuresSequence",  "SQ", "1" },
        { 0x0028, 0x9132,
          "Frame VOI LUT Sequence", "FrameVOILUTSequence",  "SQ", "1" },
        { 0x0028, 0x9145,
          "Pixel Value Transformation Sequence", "PixelValueTransformationSequence",  "SQ", "1" },
        { 0x0028, 0x9235,
          "Signal Domain Rows", "SignalDomainRows",  "CS", "1" },
        { 0x0028, 0x9411,
          "Display Filter Percentage", "DisplayFilterPercentage",  "FL", "1" },
        { 0x0028, 0x9415,
          "Frame Pixel Shift Sequence", "FramePixelShiftSequence",  "SQ", "1" },
        { 0x0028, 0x9416,
          "Subtraction Item ID", "SubtractionItemID",  "US", "1" },
        { 0x0028, 0x9422,
          "Pixel Intensity Relationship LUT Sequence", "PixelIntensityRelationshipLUTSequence",  "SQ", "1" },
        { 0x0028, 0x9443,
          "Frame Pixel Data Properties Sequence", "FramePixelDataPropertiesSequence",  "SQ", "1" },
        { 0x0028, 0x9444,
          "Geometrical Properties", "GeometricalProperties",  "CS", "1" },
        { 0x0028, 0x9445,
          "Geometric Maximum Distortion", "GeometricMaximumDistortion",  "FL", "1" },
        { 0x0028, 0x9446,
          "Image Processing Applied", "ImageProcessingApplied",  "CS", "1-n" },
        { 0x0028, 0x9454,
          "Mask Selection Mode", "MaskSelectionMode",  "CS", "1" },
        { 0x0028, 0x9474,
          "LUT Function", "LUTFunction",  "CS", "1" },
        { 0x0028, 0x9478,
          "Mask Visibility Percentage", "MaskVisibilityPercentage",  "FL", "1" },
        { 0x0028, 0x9501,
          "Pixel Shift Sequence", "PixelShiftSequence",  "SQ", "1" },
        { 0x0028, 0x9502,
          "Region Pixel Shift Sequence", "RegionPixelShiftSequence",  "SQ", "1" },
        { 0x0028, 0x9503,
          "Vertices of the Region", "VerticesOfTheRegion",  "SS", "2-2n" },
        { 0x0028, 0x9505,
          "Multi-frame Presentation Sequence", "MultiFramePresentationSequence",  "SQ", "1" },
        { 0x0028, 0x9506,
          "Pixel Shift Frame Range", "PixelShiftFrameRange",  "US", "2-2n" },
        { 0x0028, 0x9507,
          "LUT Frame Range", "LUTFrameRange",  "US", "2-2n" },
        { 0x0028, 0x9520,
          "Image to Equipment Mapping Matrix", "ImageToEquipmentMappingMatrix",  "DS", "16" },
        { 0x0028, 0x9537,
          "Equipment Coordinate System Identification", "EquipmentCoordinateSystemIdentification",  "CS", "1" },
        { 0x0032, 0x000a,
          "Study Status ID", "StudyStatusID",  "CS", "1" },
        { 0x0032, 0x000c,
          "Study Priority ID", "StudyPriorityID",  "CS", "1" },
        { 0x0032, 0x0012,
          "Study ID Issuer", "StudyIDIssuer",  "LO", "1" },
        { 0x0032, 0x0032,
          "Study Verified Date", "StudyVerifiedDate",  "DA", "1" },
        { 0x0032, 0x0033,
          "Study Verified Time", "StudyVerifiedTime",  "TM", "1" },
        { 0x0032, 0x0034,
          "Study Read Date", "StudyReadDate",  "DA", "1" },
        { 0x0032, 0x0035,
          "Study Read Time", "StudyReadTime",  "TM", "1" },
        { 0x0032, 0x1000,
          "Scheduled Study Start Date", "ScheduledStudyStartDate",  "DA", "1" },
        { 0x0032, 0x1001,
          "Scheduled Study Start Time", "ScheduledStudyStartTime",  "TM", "1" },
        { 0x0032, 0x1010,
          "Scheduled Study Stop Date", "ScheduledStudyStopDate",  "DA", "1" },
        { 0x0032, 0x1011,
          "Scheduled Study Stop Time", "ScheduledStudyStopTime",  "TM", "1" },
        { 0x0032, 0x1020,
          "Scheduled Study Location", "ScheduledStudyLocation",  "LO", "1" },
        { 0x0032, 0x1021,
          "Scheduled Study Location AE Title", "ScheduledStudyLocationAETitle",  "AE", "1-n" },
        { 0x0032, 0x1030,
          "Reason for Study", "ReasonForStudy",  "LO", "1" },
        { 0x0032, 0x1031,
          "Requesting Physician Identification Sequence", "RequestingPhysicianIdentificationSequence",  "SQ", "1" },
        { 0x0032, 0x1032,
          "Requesting Physician", "RequestingPhysician",  "PN", "1" },
        { 0x0032, 0x1033,
          "Requesting Service", "RequestingService",  "LO", "1" },
        { 0x0032, 0x1034,
          "Requesting Service Code Sequence", "RequestingServiceCodeSequence",  "SQ", "1" },
        { 0x0032, 0x1040,
          "Study Arrival Date", "StudyArrivalDate",  "DA", "1" },
        { 0x0032, 0x1041,
          "Study Arrival Time", "StudyArrivalTime",  "TM", "1" },
        { 0x0032, 0x1050,
          "Study Completion Date", "StudyCompletionDate",  "DA", "1" },
        { 0x0032, 0x1051,
          "Study Completion Time", "StudyCompletionTime",  "TM", "1" },
        { 0x0032, 0x1055,
          "Study Component Status ID", "StudyComponentStatusID",  "CS", "1" },
        { 0x0032, 0x1060,
          "Requested Procedure Description", "RequestedProcedureDescription",  "LO", "1" },
        { 0x0032, 0x1064,
          "Requested Procedure Code Sequence", "RequestedProcedureCodeSequence",  "SQ", "1" },
        { 0x0032, 0x1070,
          "Requested Contrast Agent", "RequestedContrastAgent",  "LO", "1" },
        { 0x0032, 0x4000,
          "Study Comments", "StudyComments",  "LT", "1" },
        { 0x0038, 0x0004,
          "Referenced Patient Alias Sequence", "ReferencedPatientAliasSequence",  "SQ", "1" },
        { 0x0038, 0x0008,
          "Visit Status ID", "VisitStatusID",  "CS", "1" },
        { 0x0038, 0x0010,
          "Admission ID", "AdmissionID",  "LO", "1" },
        { 0x0038, 0x0011,
          "Issuer of Admission ID", "IssuerOfAdmissionID",  "LO", "1" },
        { 0x0038, 0x0014,
          "Issuer of Admission ID Sequence", "IssuerOfAdmissionIDSequence",  "SQ", "1" },
        { 0x0038, 0x0016,
          "Route of Admissions", "RouteOfAdmissions",  "LO", "1" },
        { 0x0038, 0x001a,
          "Scheduled Admission Date", "ScheduledAdmissionDate",  "DA", "1" },
        { 0x0038, 0x001b,
          "Scheduled Admission Time", "ScheduledAdmissionTime",  "TM", "1" },
        { 0x0038, 0x001c,
          "Scheduled Discharge Date", "ScheduledDischargeDate",  "DA", "1" },
        { 0x0038, 0x001d,
          "Scheduled Discharge Time", "ScheduledDischargeTime",  "TM", "1" },
        { 0x0038, 0x001e,
          "Scheduled Patient Institution Residence", "ScheduledPatientInstitutionResidence",  "LO", "1" },
        { 0x0038, 0x0020,
          "Admitting Date", "AdmittingDate",  "DA", "1" },
        { 0x0038, 0x0021,
          "Admitting Time", "AdmittingTime",  "TM", "1" },
        { 0x0038, 0x0030,
          "Discharge Date", "DischargeDate",  "DA", "1" },
        { 0x0038, 0x0032,
          "Discharge Time", "DischargeTime",  "TM", "1" },
        { 0x0038, 0x0040,
          "Discharge Diagnosis Description", "DischargeDiagnosisDescription",  "LO", "1" },
        { 0x0038, 0x0044,
          "Discharge Diagnosis Code Sequence", "DischargeDiagnosisCodeSequence",  "SQ", "1" },
        { 0x0038, 0x0050,
          "Special Needs", "SpecialNeeds",  "LO", "1" },
        { 0x0038, 0x0060,
          "Service Episode ID", "ServiceEpisodeID",  "LO", "1" },
        { 0x0038, 0x0061,
          "Issuer of Service Episode ID", "IssuerOfServiceEpisodeID",  "LO", "1" },
        { 0x0038, 0x0062,
          "Service Episode Description", "ServiceEpisodeDescription",  "LO", "1" },
        { 0x0038, 0x0064,
          "Issuer of Service Episode ID Sequence", "IssuerOfServiceEpisodeIDSequence",  "SQ", "1" },
        { 0x0038, 0x0100,
          "Pertinent Documents Sequence", "PertinentDocumentsSequence",  "SQ", "1" },
        { 0x0038, 0x0101,
          "Pertinent Resources Sequence", "PertinentResourcesSequence",  "SQ", "1" },
        { 0x0038, 0x0102,
          "Resource Description", "ResourceDescription",  "LO", "1" },
        { 0x0038, 0x0300,
          "Current Patient Location", "CurrentPatientLocation",  "LO", "1" },
        { 0x0038, 0x0400,
          "Patient's Institution Residence", "PatientInstitutionResidence",  "LO", "1" },
        { 0x0038, 0x0500,
          "Patient State", "PatientState",  "LO", "1" },
        { 0x0038, 0x0502,
          "Patient Clinical Trial Participation Sequence", "PatientClinicalTrialParticipationSequence",  "SQ", "1" },
        { 0x0038, 0x4000,
          "Visit Comments", "VisitComments",  "LT", "1" },
        { 0x003a, 0x0004,
          "Waveform Originality", "WaveformOriginality",  "CS", "1" },
        { 0x003a, 0x0005,
          "Number of Waveform Channels", "NumberOfWaveformChannels",  "US", "1" },
        { 0x003a, 0x0010,
          "Number of Waveform Samples", "NumberOfWaveformSamples",  "UL", "1" },
        { 0x003a, 0x001a,
          "Sampling Frequency", "SamplingFrequency",  "DS", "1" },
        { 0x003a, 0x0020,
          "Multiplex Group Label", "MultiplexGroupLabel",  "SH", "1" },
        { 0x003a, 0x0200,
          "Channel Definition Sequence", "ChannelDefinitionSequence",  "SQ", "1" },
        { 0x003a, 0x0202,
          "Waveform Channel Number", "WaveformChannelNumber",  "IS", "1" },
        { 0x003a, 0x0203,
          "Channel Label", "ChannelLabel",  "SH", "1" },
        { 0x003a, 0x0205,
          "Channel Status", "ChannelStatus",  "CS", "1-n" },
        { 0x003a, 0x0208,
          "Channel Source Sequence", "ChannelSourceSequence",  "SQ", "1" },
        { 0x003a, 0x0209,
          "Channel Source Modifiers Sequence", "ChannelSourceModifiersSequence",  "SQ", "1" },
        { 0x003a, 0x020a,
          "Source Waveform Sequence", "SourceWaveformSequence",  "SQ", "1" },
        { 0x003a, 0x020c,
          "Channel Derivation Description", "ChannelDerivationDescription",  "LO", "1" },
        { 0x003a, 0x0210,
          "Channel Sensitivity", "ChannelSensitivity",  "DS", "1" },
        { 0x003a, 0x0211,
          "Channel Sensitivity Units Sequence", "ChannelSensitivityUnitsSequence",  "SQ", "1" },
        { 0x003a, 0x0212,
          "Channel Sensitivity Correction Factor", "ChannelSensitivityCorrectionFactor",  "DS", "1" },
        { 0x003a, 0x0213,
          "Channel Baseline", "ChannelBaseline",  "DS", "1" },
        { 0x003a, 0x0214,
          "Channel Time Skew", "ChannelTimeSkew",  "DS", "1" },
        { 0x003a, 0x0215,
          "Channel Sample Skew", "ChannelSampleSkew",  "DS", "1" },
        { 0x003a, 0x0218,
          "Channel Offset", "ChannelOffset",  "DS", "1" },
        { 0x003a, 0x021a,
          "Waveform Bits Stored", "WaveformBitsStored",  "US", "1" },
        { 0x003a, 0x0220,
          "Filter Low Frequency", "FilterLowFrequency",  "DS", "1" },
        { 0x003a, 0x0221,
          "Filter High Frequency", "FilterHighFrequency",  "DS", "1" },
        { 0x003a, 0x0222,
          "Notch Filter Frequency", "NotchFilterFrequency",  "DS", "1" },
        { 0x003a, 0x0223,
          "Notch Filter Bandwidth", "NotchFilterBandwidth",  "DS", "1" },
        { 0x003a, 0x0230,
          "Waveform Data Display Scale", "WaveformDataDisplayScale",  "FL", "1" },
        { 0x003a, 0x0231,
          "Waveform Display Background CIELab Value", "WaveformDisplayBackgroundCIELabValue",  "US", "3" },
        { 0x003a, 0x0240,
          "Waveform Presentation Group Sequence", "WaveformPresentationGroupSequence",  "SQ", "1" },
        { 0x003a, 0x0241,
          "Presentation Group Number", "PresentationGroupNumber",  "US", "1" },
        { 0x003a, 0x0242,
          "Channel Display Sequence", "ChannelDisplaySequence",  "SQ", "1" },
        { 0x003a, 0x0244,
          "Channel Recommended Display CIELab Value", "ChannelRecommendedDisplayCIELabValue",  "US", "3" },
        { 0x003a, 0x0245,
          "Channel Position", "ChannelPosition",  "FL", "1" },
        { 0x003a, 0x0246,
          "Display Shading Flag", "DisplayShadingFlag",  "CS", "1" },
        { 0x003a, 0x0247,
          "Fractional Channel Display Scale", "FractionalChannelDisplayScale",  "FL", "1" },
        { 0x003a, 0x0248,
          "Absolute Channel Display Scale", "AbsoluteChannelDisplayScale",  "FL", "1" },
        { 0x003a, 0x0300,
          "Multiplexed Audio Channels Description Code Sequence", "MultiplexedAudioChannelsDescriptionCodeSequence",  "SQ", "1" },
        { 0x003a, 0x0301,
          "Channel Identification Code", "ChannelIdentificationCode",  "IS", "1" },
        { 0x003a, 0x0302,
          "Channel Mode", "ChannelMode",  "CS", "1" },
        { 0x0040, 0x0001,
          "Scheduled Station AE Title", "ScheduledStationAETitle",  "AE", "1-n" },
        { 0x0040, 0x0002,
          "Scheduled Procedure Step Start Date", "ScheduledProcedureStepStartDate",  "DA", "1" },
        { 0x0040, 0x0003,
          "Scheduled Procedure Step Start Time", "ScheduledProcedureStepStartTime",  "TM", "1" },
        { 0x0040, 0x0004,
          "Scheduled Procedure Step End Date", "ScheduledProcedureStepEndDate",  "DA", "1" },
        { 0x0040, 0x0005,
          "Scheduled Procedure Step End Time", "ScheduledProcedureStepEndTime",  "TM", "1" },
        { 0x0040, 0x0006,
          "Scheduled Performing Physician's Name", "ScheduledPerformingPhysicianName",  "PN", "1" },
        { 0x0040, 0x0007,
          "Scheduled Procedure Step Description", "ScheduledProcedureStepDescription",  "LO", "1" },
        { 0x0040, 0x0008,
          "Scheduled Protocol Code Sequence", "ScheduledProtocolCodeSequence",  "SQ", "1" },
        { 0x0040, 0x0009,
          "Scheduled Procedure Step ID", "ScheduledProcedureStepID",  "SH", "1" },
        { 0x0040, 0x000a,
          "Stage Code Sequence", "StageCodeSequence",  "SQ", "1" },
        { 0x0040, 0x000b,
          "Scheduled Performing Physician Identification Sequence", "ScheduledPerformingPhysicianIdentificationSequence",  "SQ", "1" },
        { 0x0040, 0x0010,
          "Scheduled Station Name", "ScheduledStationName",  "SH", "1-n" },
        { 0x0040, 0x0011,
          "Scheduled Procedure Step Location", "ScheduledProcedureStepLocation",  "SH", "1" },
        { 0x0040, 0x0012,
          "Pre-Medication", "PreMedication",  "LO", "1" },
        { 0x0040, 0x0020,
          "Scheduled Procedure Step Status", "ScheduledProcedureStepStatus",  "CS", "1" },
        { 0x0040, 0x0026,
          "Order Placer Identifier Sequence", "OrderPlacerIdentifierSequence",  "SQ", "1" },
        { 0x0040, 0x0027,
          "Order Filler Identifier Sequence", "OrderFillerIdentifierSequence",  "SQ", "1" },
        { 0x0040, 0x0031,
          "Local Namespace Entity ID", "LocalNamespaceEntityID",  "UT", "1" },
        { 0x0040, 0x0032,
          "Universal Entity ID", "UniversalEntityID",  "UT", "1" },
        { 0x0040, 0x0033,
          "Universal Entity ID Type", "UniversalEntityIDType",  "CS", "1" },
        { 0x0040, 0x0035,
          "Identifier Type Code", "IdentifierTypeCode",  "CS", "1" },
        { 0x0040, 0x0036,
          "Assigning Facility Sequence", "AssigningFacilitySequence",  "SQ", "1" },
        { 0x0040, 0x0039,
          "Assigning Jurisdiction Code Sequence", "AssigningJurisdictionCodeSequence",  "SQ", "1" },
        { 0x0040, 0x003a,
          "Assigning Agency or Department Code Sequence", "AssigningAgencyOrDepartmentCodeSequence",  "SQ", "1" },
        { 0x0040, 0x0100,
          "Scheduled Procedure Step Sequence", "ScheduledProcedureStepSequence",  "SQ", "1" },
        { 0x0040, 0x0220,
          "Referenced Non-Image Composite SOP Instance Sequence", "ReferencedNonImageCompositeSOPInstanceSequence",  "SQ", "1" },
        { 0x0040, 0x0241,
          "Performed Station AE Title", "PerformedStationAETitle",  "AE", "1" },
        { 0x0040, 0x0242,
          "Performed Station Name", "PerformedStationName",  "SH", "1" },
        { 0x0040, 0x0243,
          "Performed Location", "PerformedLocation",  "SH", "1" },
        { 0x0040, 0x0244,
          "Performed Procedure Step Start Date", "PerformedProcedureStepStartDate",  "DA", "1" },
        { 0x0040, 0x0245,
          "Performed Procedure Step Start Time", "PerformedProcedureStepStartTime",  "TM", "1" },
        { 0x0040, 0x0250,
          "Performed Procedure Step End Date", "PerformedProcedureStepEndDate",  "DA", "1" },
        { 0x0040, 0x0251,
          "Performed Procedure Step End Time", "PerformedProcedureStepEndTime",  "TM", "1" },
        { 0x0040, 0x0252,
          "Performed Procedure Step Status", "PerformedProcedureStepStatus",  "CS", "1" },
        { 0x0040, 0x0253,
          "Performed Procedure Step ID", "PerformedProcedureStepID",  "SH", "1" },
        { 0x0040, 0x0254,
          "Performed Procedure Step Description", "PerformedProcedureStepDescription",  "LO", "1" },
        { 0x0040, 0x0255,
          "Performed Procedure Type Description", "PerformedProcedureTypeDescription",  "LO", "1" },
        { 0x0040, 0x0260,
          "Performed Protocol Code Sequence", "PerformedProtocolCodeSequence",  "SQ", "1" },
        { 0x0040, 0x0261,
          "Performed Protocol Type", "PerformedProtocolType",  "CS", "1" },
        { 0x0040, 0x0270,
          "Scheduled Step Attributes Sequence", "ScheduledStepAttributesSequence",  "SQ", "1" },
        { 0x0040, 0x0275,
          "Request Attributes Sequence", "RequestAttributesSequence",  "SQ", "1" },
        { 0x0040, 0x0280,
          "Comments on the Performed Procedure Step", "CommentsOnThePerformedProcedureStep",  "ST", "1" },
        { 0x0040, 0x0281,
          "Performed Procedure Step Discontinuation Reason Code Sequence", "PerformedProcedureStepDiscontinuationReasonCodeSequence",  "SQ", "1" },
        { 0x0040, 0x0293,
          "Quantity Sequence", "QuantitySequence",  "SQ", "1" },
        { 0x0040, 0x0294,
          "Quantity", "Quantity",  "DS", "1" },
        { 0x0040, 0x0295,
          "Measuring Units Sequence", "MeasuringUnitsSequence",  "SQ", "1" },
        { 0x0040, 0x0296,
          "Billing Item Sequence", "BillingItemSequence",  "SQ", "1" },
        { 0x0040, 0x0300,
          "Total Time of Fluoroscopy", "TotalTimeOfFluoroscopy",  "US", "1" },
        { 0x0040, 0x0301,
          "Total Number of Exposures", "TotalNumberOfExposures",  "US", "1" },
        { 0x0040, 0x0302,
          "Entrance Dose", "EntranceDose",  "US", "1" },
        { 0x0040, 0x0303,
          "Exposed Area", "ExposedArea",  "US", "1-2" },
        { 0x0040, 0x0306,
          "Distance Source to Entrance", "DistanceSourceToEntrance",  "DS", "1" },
        { 0x0040, 0x0307,
          "Distance Source to Support", "DistanceSourceToSupport",  "DS", "1" },
        { 0x0040, 0x030e,
          "Exposure Dose Sequence", "ExposureDoseSequence",  "SQ", "1" },
        { 0x0040, 0x0310,
          "Comments on Radiation Dose", "CommentsOnRadiationDose",  "ST", "1" },
        { 0x0040, 0x0312,
          "X-Ray Output", "XRayOutput",  "DS", "1" },
        { 0x0040, 0x0314,
          "Half Value Layer", "HalfValueLayer",  "DS", "1" },
        { 0x0040, 0x0316,
          "Organ Dose", "OrganDose",  "DS", "1" },
        { 0x0040, 0x0318,
          "Organ Exposed", "OrganExposed",  "CS", "1" },
        { 0x0040, 0x0320,
          "Billing Procedure Step Sequence", "BillingProcedureStepSequence",  "SQ", "1" },
        { 0x0040, 0x0321,
          "Film Consumption Sequence", "FilmConsumptionSequence",  "SQ", "1" },
        { 0x0040, 0x0324,
          "Billing Supplies and Devices Sequence", "BillingSuppliesAndDevicesSequence",  "SQ", "1" },
        { 0x0040, 0x0330,
          "Referenced Procedure Step Sequence", "ReferencedProcedureStepSequence",  "SQ", "1" },
        { 0x0040, 0x0340,
          "Performed Series Sequence", "PerformedSeriesSequence",  "SQ", "1" },
        { 0x0040, 0x0400,
          "Comments on the Scheduled Procedure Step", "CommentsOnTheScheduledProcedureStep",  "LT", "1" },
        { 0x0040, 0x0440,
          "Protocol Context Sequence", "ProtocolContextSequence",  "SQ", "1" },
        { 0x0040, 0x0441,
          "Content Item Modifier Sequence", "ContentItemModifierSequence",  "SQ", "1" },
        { 0x0040, 0x0500,
          "Scheduled Specimen Sequence", "ScheduledSpecimenSequence",  "SQ", "1" },
        { 0x0040, 0x050a,
          "Specimen Accession Number", "SpecimenAccessionNumber",  "LO", "1" },
        { 0x0040, 0x0512,
          "Container Identifier", "ContainerIdentifier",  "LO", "1" },
        { 0x0040, 0x0513,
          "Issuer of the Container Identifier Sequence", "IssuerOfTheContainerIdentifierSequence",  "SQ", "1" },
        { 0x0040, 0x0515,
          "Alternate Container Identifier Sequence", "AlternateContainerIdentifierSequence",  "SQ", "1" },
        { 0x0040, 0x0518,
          "Container Type Code Sequence", "ContainerTypeCodeSequence",  "SQ", "1" },
        { 0x0040, 0x051a,
          "Container Description", "ContainerDescription",  "LO", "1" },
        { 0x0040, 0x0520,
          "Container Component Sequence", "ContainerComponentSequence",  "SQ", "1" },
        { 0x0040, 0x0550,
          "Specimen Sequence", "SpecimenSequence",  "SQ", "1" },
        { 0x0040, 0x0551,
          "Specimen Identifier", "SpecimenIdentifier",  "LO", "1" },
        { 0x0040, 0x0552,
          "Specimen Description Sequence (Trial)", "SpecimenDescriptionSequenceTrial",  "SQ", "1" },
        { 0x0040, 0x0553,
          "Specimen Description (Trial)", "SpecimenDescriptionTrial",  "ST", "1" },
        { 0x0040, 0x0554,
          "Specimen UID", "SpecimenUID",  "UI", "1" },
        { 0x0040, 0x0555,
          "Acquisition Context Sequence", "AcquisitionContextSequence",  "SQ", "1" },
        { 0x0040, 0x0556,
          "Acquisition Context Description", "AcquisitionContextDescription",  "ST", "1" },
        { 0x0040, 0x059a,
          "Specimen Type Code Sequence", "SpecimenTypeCodeSequence",  "SQ", "1" },
        { 0x0040, 0x0560,
          "Specimen Description Sequence", "SpecimenDescriptionSequence",  "SQ", "1" },
        { 0x0040, 0x0562,
          "Issuer of the Specimen Identifier Sequence", "IssuerOfTheSpecimenIdentifierSequence",  "SQ", "1" },
        { 0x0040, 0x0600,
          "Specimen Short Description", "SpecimenShortDescription",  "LO", "1" },
        { 0x0040, 0x0602,
          "Specimen Detailed Description", "SpecimenDetailedDescription",  "UT", "1" },
        { 0x0040, 0x0610,
          "Specimen Preparation Sequence", "SpecimenPreparationSequence",  "SQ", "1" },
        { 0x0040, 0x0612,
          "Specimen Preparation Step Content Item Sequence", "SpecimenPreparationStepContentItemSequence",  "SQ", "1" },
        { 0x0040, 0x0620,
          "Specimen Localization Content Item Sequence", "SpecimenLocalizationContentItemSequence",  "SQ", "1" },
        { 0x0040, 0x06fa,
          "Slide Identifier", "SlideIdentifier",  "LO", "1" },
        { 0x0040, 0x071a,
          "Image Center Point Coordinates Sequence", "ImageCenterPointCoordinatesSequence",  "SQ", "1" },
        { 0x0040, 0x072a,
          "X Offset in Slide Coordinate System", "XOffsetInSlideCoordinateSystem",  "DS", "1" },
        { 0x0040, 0x073a,
          "Y Offset in Slide Coordinate System", "YOffsetInSlideCoordinateSystem",  "DS", "1" },
        { 0x0040, 0x074a,
          "Z Offset in Slide Coordinate System", "ZOffsetInSlideCoordinateSystem",  "DS", "1" },
        { 0x0040, 0x08d8,
          "Pixel Spacing Sequence", "PixelSpacingSequence",  "SQ", "1" },
        { 0x0040, 0x08da,
          "Coordinate System Axis Code Sequence", "CoordinateSystemAxisCodeSequence",  "SQ", "1" },
        { 0x0040, 0x08ea,
          "Measurement Units Code Sequence", "MeasurementUnitsCodeSequence",  "SQ", "1" },
        { 0x0040, 0x09f8,
          "Vital Stain Code Sequence (Trial)", "VitalStainCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0x1001,
          "Requested Procedure ID", "RequestedProcedureID",  "SH", "1" },
        { 0x0040, 0x1002,
          "Reason for the Requested Procedure", "ReasonForTheRequestedProcedure",  "LO", "1" },
        { 0x0040, 0x1003,
          "Requested Procedure Priority", "RequestedProcedurePriority",  "SH", "1" },
        { 0x0040, 0x1004,
          "Patient Transport Arrangements", "PatientTransportArrangements",  "LO", "1" },
        { 0x0040, 0x1005,
          "Requested Procedure Location", "RequestedProcedureLocation",  "LO", "1" },
        { 0x0040, 0x1006,
          "Placer Order Number / Procedure", "PlacerOrderNumberProcedure",  "SH", "1" },
        { 0x0040, 0x1007,
          "Filler Order Number / Procedure", "FillerOrderNumberProcedure",  "SH", "1" },
        { 0x0040, 0x1008,
          "Confidentiality Code", "ConfidentialityCode",  "LO", "1" },
        { 0x0040, 0x1009,
          "Reporting Priority", "ReportingPriority",  "SH", "1" },
        { 0x0040, 0x100a,
          "Reason for Requested Procedure Code Sequence", "ReasonForRequestedProcedureCodeSequence",  "SQ", "1" },
        { 0x0040, 0x1010,
          "Names of Intended Recipients of Results", "NamesOfIntendedRecipientsOfResults",  "PN", "1-n" },
        { 0x0040, 0x1011,
          "Intended Recipients of Results Identification Sequence", "IntendedRecipientsOfResultsIdentificationSequence",  "SQ", "1" },
        { 0x0040, 0x1012,
          "Reason For Performed Procedure Code Sequence", "ReasonForPerformedProcedureCodeSequence",  "SQ", "1" },
        { 0x0040, 0x1060,
          "Requested Procedure Description (Trial)", "RequestedProcedureDescriptionTrial",  "LO", "1" },
        { 0x0040, 0x1101,
          "Person Identification Code Sequence", "PersonIdentificationCodeSequence",  "SQ", "1" },
        { 0x0040, 0x1102,
          "Person's Address", "PersonAddress",  "ST", "1" },
        { 0x0040, 0x1103,
          "Person's Telephone Numbers", "PersonTelephoneNumbers",  "LO", "1-n" },
        { 0x0040, 0x1104,
          "Person's Telecom Information", "PersonTelecomInformation",  "LT", "1" },
        { 0x0040, 0x1400,
          "Requested Procedure Comments", "RequestedProcedureComments",  "LT", "1" },
        { 0x0040, 0x2001,
          "Reason for the Imaging Service Request", "ReasonForTheImagingServiceRequest",  "LO", "1" },
        { 0x0040, 0x2004,
          "Issue Date of Imaging Service Request", "IssueDateOfImagingServiceRequest",  "DA", "1" },
        { 0x0040, 0x2005,
          "Issue Time of Imaging Service Request", "IssueTimeOfImagingServiceRequest",  "TM", "1" },
        { 0x0040, 0x2006,
          "Placer Order Number / Imaging Service Request (Retired)", "PlacerOrderNumberImagingServiceRequestRetired",  "SH", "1" },
        { 0x0040, 0x2007,
          "Filler Order Number / Imaging Service Request (Retired)", "FillerOrderNumberImagingServiceRequestRetired",  "SH", "1" },
        { 0x0040, 0x2008,
          "Order Entered By", "OrderEnteredBy",  "PN", "1" },
        { 0x0040, 0x2009,
          "Order Enterer's Location", "OrderEntererLocation",  "SH", "1" },
        { 0x0040, 0x2010,
          "Order Callback Phone Number", "OrderCallbackPhoneNumber",  "SH", "1" },
        { 0x0040, 0x2011,
          "Order Callback Telecom Information", "OrderCallbackTelecomInformation",  "LT", "1" },
        { 0x0040, 0x2016,
          "Placer Order Number / Imaging Service Request", "PlacerOrderNumberImagingServiceRequest",  "LO", "1" },
        { 0x0040, 0x2017,
          "Filler Order Number / Imaging Service Request", "FillerOrderNumberImagingServiceRequest",  "LO", "1" },
        { 0x0040, 0x2400,
          "Imaging Service Request Comments", "ImagingServiceRequestComments",  "LT", "1" },
        { 0x0040, 0x3001,
          "Confidentiality Constraint on Patient Data Description", "ConfidentialityConstraintOnPatientDataDescription",  "LO", "1" },
        { 0x0040, 0x4001,
          "General Purpose Scheduled Procedure Step Status", "GeneralPurposeScheduledProcedureStepStatus",  "CS", "1" },
        { 0x0040, 0x4002,
          "General Purpose Performed Procedure Step Status", "GeneralPurposePerformedProcedureStepStatus",  "CS", "1" },
        { 0x0040, 0x4003,
          "General Purpose Scheduled Procedure Step Priority", "GeneralPurposeScheduledProcedureStepPriority",  "CS", "1" },
        { 0x0040, 0x4004,
          "Scheduled Processing Applications Code Sequence", "ScheduledProcessingApplicationsCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4005,
          "Scheduled Procedure Step Start DateTime", "ScheduledProcedureStepStartDateTime",  "DT", "1" },
        { 0x0040, 0x4006,
          "Multiple Copies Flag", "MultipleCopiesFlag",  "CS", "1" },
        { 0x0040, 0x4007,
          "Performed Processing Applications Code Sequence", "PerformedProcessingApplicationsCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4009,
          "Human Performer Code Sequence", "HumanPerformerCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4010,
          "Scheduled Procedure Step Modification DateTime", "ScheduledProcedureStepModificationDateTime",  "DT", "1" },
        { 0x0040, 0x4011,
          "Expected Completion DateTime", "ExpectedCompletionDateTime",  "DT", "1" },
        { 0x0040, 0x4015,
          "Resulting General Purpose Performed Procedure Steps Sequence", "ResultingGeneralPurposePerformedProcedureStepsSequence",  "SQ", "1" },
        { 0x0040, 0x4016,
          "Referenced General Purpose Scheduled Procedure Step Sequence", "ReferencedGeneralPurposeScheduledProcedureStepSequence",  "SQ", "1" },
        { 0x0040, 0x4018,
          "Scheduled Workitem Code Sequence", "ScheduledWorkitemCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4019,
          "Performed Workitem Code Sequence", "PerformedWorkitemCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4020,
          "Input Availability Flag", "InputAvailabilityFlag",  "CS", "1" },
        { 0x0040, 0x4021,
          "Input Information Sequence", "InputInformationSequence",  "SQ", "1" },
        { 0x0040, 0x4022,
          "Relevant Information Sequence", "RelevantInformationSequence",  "SQ", "1" },
        { 0x0040, 0x4023,
          "Referenced General Purpose Scheduled Procedure Step Transaction UID", "ReferencedGeneralPurposeScheduledProcedureStepTransactionUID",  "UI", "1" },
        { 0x0040, 0x4025,
          "Scheduled Station Name Code Sequence", "ScheduledStationNameCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4026,
          "Scheduled Station Class Code Sequence", "ScheduledStationClassCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4027,
          "Scheduled Station Geographic Location Code Sequence", "ScheduledStationGeographicLocationCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4028,
          "Performed Station Name Code Sequence", "PerformedStationNameCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4029,
          "Performed Station Class Code Sequence", "PerformedStationClassCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4030,
          "Performed Station Geographic Location Code Sequence", "PerformedStationGeographicLocationCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4031,
          "Requested Subsequent Workitem Code Sequence", "RequestedSubsequentWorkitemCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4032,
          "Non-DICOM Output Code Sequence", "NonDICOMOutputCodeSequence",  "SQ", "1" },
        { 0x0040, 0x4033,
          "Output Information Sequence", "OutputInformationSequence",  "SQ", "1" },
        { 0x0040, 0x4034,
          "Scheduled Human Performers Sequence", "ScheduledHumanPerformersSequence",  "SQ", "1" },
        { 0x0040, 0x4035,
          "Actual Human Performers Sequence", "ActualHumanPerformersSequence",  "SQ", "1" },
        { 0x0040, 0x4036,
          "Human Performer's Organization", "HumanPerformerOrganization",  "LO", "1" },
        { 0x0040, 0x4037,
          "Human Performer's Name", "HumanPerformerName",  "PN", "1" },
        { 0x0040, 0x4040,
          "Raw Data Handling", "RawDataHandling",  "CS", "1" },
        { 0x0040, 0x4041,
          "Input Readiness State", "InputReadinessState",  "CS", "1" },
        { 0x0040, 0x4050,
          "Performed Procedure Step Start DateTime", "PerformedProcedureStepStartDateTime",  "DT", "1" },
        { 0x0040, 0x4051,
          "Performed Procedure Step End DateTime", "PerformedProcedureStepEndDateTime",  "DT", "1" },
        { 0x0040, 0x4052,
          "Procedure Step Cancellation DateTime", "ProcedureStepCancellationDateTime",  "DT", "1" },
        { 0x0040, 0x8302,
          "Entrance Dose in mGy", "EntranceDoseInmGy",  "DS", "1" },
        { 0x0040, 0x9092,
          "Parametric Map Frame Type Sequence", "ParametricMapFrameTypeSequence",  "SQ", "1" },
        { 0x0040, 0x9094,
          "Referenced Image Real World Value Mapping Sequence", "ReferencedImageRealWorldValueMappingSequence",  "SQ", "1" },
        { 0x0040, 0x9096,
          "Real World Value Mapping Sequence", "RealWorldValueMappingSequence",  "SQ", "1" },
        { 0x0040, 0x9098,
          "Pixel Value Mapping Code Sequence", "PixelValueMappingCodeSequence",  "SQ", "1" },
        { 0x0040, 0x9210,
          "LUT Label", "LUTLabel",  "SH", "1" },
        { 0x0040, 0x9211,
          "Real World Value Last Value Mapped", "RealWorldValueLastValueMapped",  "US or SS", "1" },
        { 0x0040, 0x9212,
          "Real World Value LUT Data", "RealWorldValueLUTData",  "FD", "1-n" },
        { 0x0040, 0x9216,
          "Real World Value First Value Mapped", "RealWorldValueFirstValueMapped",  "US or SS", "1" },
        { 0x0040, 0x9220,
          "Quantity Definition Sequence", "QuantityDefinitionSequence",  "SQ", "1" },
        { 0x0040, 0x9224,
          "Real World Value Intercept", "RealWorldValueIntercept",  "FD", "1" },
        { 0x0040, 0x9225,
          "Real World Value Slope", "RealWorldValueSlope",  "FD", "1" },
        { 0x0040, 0xa007,
          "Findings Flag (Trial)", "FindingsFlagTrial",  "CS", "1" },
        { 0x0040, 0xa010,
          "Relationship Type", "RelationshipType",  "CS", "1" },
        { 0x0040, 0xa020,
          "Findings Sequence (Trial)", "FindingsSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa021,
          "Findings Group UID (Trial)", "FindingsGroupUIDTrial",  "UI", "1" },
        { 0x0040, 0xa022,
          "Referenced Findings Group UID (Trial)", "ReferencedFindingsGroupUIDTrial",  "UI", "1" },
        { 0x0040, 0xa023,
          "Findings Group Recording Date (Trial)", "FindingsGroupRecordingDateTrial",  "DA", "1" },
        { 0x0040, 0xa024,
          "Findings Group Recording Time (Trial)", "FindingsGroupRecordingTimeTrial",  "TM", "1" },
        { 0x0040, 0xa026,
          "Findings Source Category Code Sequence (Trial)", "FindingsSourceCategoryCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa027,
          "Verifying Organization", "VerifyingOrganization",  "LO", "1" },
        { 0x0040, 0xa028,
          "Documenting Organization Identifier Code Sequence (Trial)", "DocumentingOrganizationIdentifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa030,
          "Verification DateTime", "VerificationDateTime",  "DT", "1" },
        { 0x0040, 0xa032,
          "Observation DateTime", "ObservationDateTime",  "DT", "1" },
        { 0x0040, 0xa040,
          "Value Type", "ValueType",  "CS", "1" },
        { 0x0040, 0xa043,
          "Concept Name Code Sequence", "ConceptNameCodeSequence",  "SQ", "1" },
        { 0x0040, 0xa047,
          "Measurement Precision Description (Trial)", "MeasurementPrecisionDescriptionTrial",  "LO", "1" },
        { 0x0040, 0xa050,
          "Continuity Of Content", "ContinuityOfContent",  "CS", "1" },
        { 0x0040, 0xa057,
          "Urgency or Priority Alerts (Trial)", "UrgencyOrPriorityAlertsTrial",  "CS", "1-n" },
        { 0x0040, 0xa060,
          "Sequencing Indicator (Trial)", "SequencingIndicatorTrial",  "LO", "1" },
        { 0x0040, 0xa066,
          "Document Identifier Code Sequence (Trial)", "DocumentIdentifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa067,
          "Document Author (Trial)", "DocumentAuthorTrial",  "PN", "1" },
        { 0x0040, 0xa068,
          "Document Author Identifier Code Sequence (Trial)", "DocumentAuthorIdentifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa070,
          "Identifier Code Sequence (Trial)", "IdentifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa073,
          "Verifying Observer Sequence", "VerifyingObserverSequence",  "SQ", "1" },
        { 0x0040, 0xa074,
          "Object Binary Identifier (Trial)", "ObjectBinaryIdentifierTrial",  "OB", "1" },
        { 0x0040, 0xa075,
          "Verifying Observer Name", "VerifyingObserverName",  "PN", "1" },
        { 0x0040, 0xa076,
          "Documenting Observer Identifier Code Sequence (Trial)", "DocumentingObserverIdentifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa078,
          "Author Observer Sequence", "AuthorObserverSequence",  "SQ", "1" },
        { 0x0040, 0xa07a,
          "Participant Sequence", "ParticipantSequence",  "SQ", "1" },
        { 0x0040, 0xa07c,
          "Custodial Organization Sequence", "CustodialOrganizationSequence",  "SQ", "1" },
        { 0x0040, 0xa080,
          "Participation Type", "ParticipationType",  "CS", "1" },
        { 0x0040, 0xa082,
          "Participation DateTime", "ParticipationDateTime",  "DT", "1" },
        { 0x0040, 0xa084,
          "Observer Type", "ObserverType",  "CS", "1" },
        { 0x0040, 0xa085,
          "Procedure Identifier Code Sequence (Trial)", "ProcedureIdentifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa088,
          "Verifying Observer Identification Code Sequence", "VerifyingObserverIdentificationCodeSequence",  "SQ", "1" },
        { 0x0040, 0xa089,
          "Object Directory Binary Identifier (Trial)", "ObjectDirectoryBinaryIdentifierTrial",  "OB", "1" },
        { 0x0040, 0xa090,
          "Equivalent CDA Document Sequence", "EquivalentCDADocumentSequence",  "SQ", "1" },
        { 0x0040, 0xa0b0,
          "Referenced Waveform Channels", "ReferencedWaveformChannels",  "US", "2-2n" },
        { 0x0040, 0xa110,
          "Date of Document or Verbal Transaction (Trial)", "DateOfDocumentOrVerbalTransactionTrial",  "DA", "1" },
        { 0x0040, 0xa112,
          "Time of Document Creation or Verbal Transaction (Trial)", "TimeOfDocumentCreationOrVerbalTransactionTrial",  "TM", "1" },
        { 0x0040, 0xa120,
          "DateTime", "DateTime",  "DT", "1" },
        { 0x0040, 0xa121,
          "Date", "Date",  "DA", "1" },
        { 0x0040, 0xa122,
          "Time", "Time",  "TM", "1" },
        { 0x0040, 0xa123,
          "Person Name", "PersonName",  "PN", "1" },
        { 0x0040, 0xa124,
          "UID", "UID",  "UI", "1" },
        { 0x0040, 0xa125,
          "Report Status ID (Trial)", "ReportStatusIDTrial",  "CS", "2" },
        { 0x0040, 0xa130,
          "Temporal Range Type", "TemporalRangeType",  "CS", "1" },
        { 0x0040, 0xa132,
          "Referenced Sample Positions", "ReferencedSamplePositions",  "UL", "1-n" },
        { 0x0040, 0xa136,
          "Referenced Frame Numbers", "ReferencedFrameNumbers",  "US", "1-n" },
        { 0x0040, 0xa138,
          "Referenced Time Offsets", "ReferencedTimeOffsets",  "DS", "1-n" },
        { 0x0040, 0xa13a,
          "Referenced DateTime", "ReferencedDateTime",  "DT", "1-n" },
        { 0x0040, 0xa160,
          "Text Value", "TextValue",  "UT", "1" },
        { 0x0040, 0xa161,
          "Floating Point Value", "FloatingPointValue",  "FD", "1-n" },
        { 0x0040, 0xa162,
          "Rational Numerator Value", "RationalNumeratorValue",  "SL", "1-n" },
        { 0x0040, 0xa163,
          "Rational Denominator Value", "RationalDenominatorValue",  "UL", "1-n" },
        { 0x0040, 0xa167,
          "Observation Category Code Sequence (Trial)", "ObservationCategoryCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa168,
          "Concept Code Sequence", "ConceptCodeSequence",  "SQ", "1" },
        { 0x0040, 0xa16a,
          "Bibliographic Citation (Trial)", "BibliographicCitationTrial",  "ST", "1" },
        { 0x0040, 0xa170,
          "Purpose of Reference Code Sequence", "PurposeOfReferenceCodeSequence",  "SQ", "1" },
        { 0x0040, 0xa171,
          "Observation UID", "ObservationUID",  "UI", "1" },
        { 0x0040, 0xa172,
          "Referenced Observation UID (Trial)", "ReferencedObservationUIDTrial",  "UI", "1" },
        { 0x0040, 0xa173,
          "Referenced Observation Class (Trial)", "ReferencedObservationClassTrial",  "CS", "1" },
        { 0x0040, 0xa174,
          "Referenced Object Observation Class (Trial)", "ReferencedObjectObservationClassTrial",  "CS", "1" },
        { 0x0040, 0xa180,
          "Annotation Group Number", "AnnotationGroupNumber",  "US", "1" },
        { 0x0040, 0xa192,
          "Observation Date (Trial)", "ObservationDateTrial",  "DA", "1" },
        { 0x0040, 0xa193,
          "Observation Time (Trial)", "ObservationTimeTrial",  "TM", "1" },
        { 0x0040, 0xa194,
          "Measurement Automation (Trial)", "MeasurementAutomationTrial",  "CS", "1" },
        { 0x0040, 0xa195,
          "Modifier Code Sequence", "ModifierCodeSequence",  "SQ", "1" },
        { 0x0040, 0xa224,
          "Identification Description (Trial)", "IdentificationDescriptionTrial",  "ST", "1" },
        { 0x0040, 0xa290,
          "Coordinates Set Geometric Type (Trial)", "CoordinatesSetGeometricTypeTrial",  "CS", "1" },
        { 0x0040, 0xa296,
          "Algorithm Code Sequence (Trial)", "AlgorithmCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa297,
          "Algorithm Description (Trial)", "AlgorithmDescriptionTrial",  "ST", "1" },
        { 0x0040, 0xa29a,
          "Pixel Coordinates Set (Trial)", "PixelCoordinatesSetTrial",  "SL", "2-2n" },
        { 0x0040, 0xa300,
          "Measured Value Sequence", "MeasuredValueSequence",  "SQ", "1" },
        { 0x0040, 0xa301,
          "Numeric Value Qualifier Code Sequence", "NumericValueQualifierCodeSequence",  "SQ", "1" },
        { 0x0040, 0xa307,
          "Current Observer (Trial)", "CurrentObserverTrial",  "PN", "1" },
        { 0x0040, 0xa30a,
          "Numeric Value", "NumericValue",  "DS", "1-n" },
        { 0x0040, 0xa313,
          "Referenced Accession Sequence (Trial)", "ReferencedAccessionSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa33a,
          "Report Status Comment (Trial)", "ReportStatusCommentTrial",  "ST", "1" },
        { 0x0040, 0xa340,
          "Procedure Context Sequence (Trial)", "ProcedureContextSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa352,
          "Verbal Source (Trial)", "VerbalSourceTrial",  "PN", "1" },
        { 0x0040, 0xa353,
          "Address (Trial)", "AddressTrial",  "ST", "1" },
        { 0x0040, 0xa354,
          "Telephone Number (Trial)", "TelephoneNumberTrial",  "LO", "1" },
        { 0x0040, 0xa358,
          "Verbal Source Identifier Code Sequence (Trial)", "VerbalSourceIdentifierCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa360,
          "Predecessor Documents Sequence", "PredecessorDocumentsSequence",  "SQ", "1" },
        { 0x0040, 0xa370,
          "Referenced Request Sequence", "ReferencedRequestSequence",  "SQ", "1" },
        { 0x0040, 0xa372,
          "Performed Procedure Code Sequence", "PerformedProcedureCodeSequence",  "SQ", "1" },
        { 0x0040, 0xa375,
          "Current Requested Procedure Evidence Sequence", "CurrentRequestedProcedureEvidenceSequence",  "SQ", "1" },
        { 0x0040, 0xa380,
          "Report Detail Sequence (Trial)", "ReportDetailSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa385,
          "Pertinent Other Evidence Sequence", "PertinentOtherEvidenceSequence",  "SQ", "1" },
        { 0x0040, 0xa390,
          "HL7 Structured Document Reference Sequence", "HL7StructuredDocumentReferenceSequence",  "SQ", "1" },
        { 0x0040, 0xa402,
          "Observation Subject UID (Trial)", "ObservationSubjectUIDTrial",  "UI", "1" },
        { 0x0040, 0xa403,
          "Observation Subject Class (Trial)", "ObservationSubjectClassTrial",  "CS", "1" },
        { 0x0040, 0xa404,
          "Observation Subject Type Code Sequence (Trial)", "ObservationSubjectTypeCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa491,
          "Completion Flag", "CompletionFlag",  "CS", "1" },
        { 0x0040, 0xa492,
          "Completion Flag Description", "CompletionFlagDescription",  "LO", "1" },
        { 0x0040, 0xa493,
          "Verification Flag", "VerificationFlag",  "CS", "1" },
        { 0x0040, 0xa494,
          "Archive Requested", "ArchiveRequested",  "CS", "1" },
        { 0x0040, 0xa496,
          "Preliminary Flag", "PreliminaryFlag",  "CS", "1" },
        { 0x0040, 0xa504,
          "Content Template Sequence", "ContentTemplateSequence",  "SQ", "1" },
        { 0x0040, 0xa525,
          "Identical Documents Sequence", "IdenticalDocumentsSequence",  "SQ", "1" },
        { 0x0040, 0xa600,
          "Observation Subject Context Flag (Trial)", "ObservationSubjectContextFlagTrial",  "CS", "1" },
        { 0x0040, 0xa601,
          "Observer Context Flag (Trial)", "ObserverContextFlagTrial",  "CS", "1" },
        { 0x0040, 0xa603,
          "Procedure Context Flag (Trial)", "ProcedureContextFlagTrial",  "CS", "1" },
        { 0x0040, 0xa730,
          "Content Sequence", "ContentSequence",  "SQ", "1" },
        { 0x0040, 0xa731,
          "Relationship Sequence (Trial)", "RelationshipSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa732,
          "Relationship Type Code Sequence (Trial)", "RelationshipTypeCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa744,
          "Language Code Sequence (Trial)", "LanguageCodeSequenceTrial",  "SQ", "1" },
        { 0x0040, 0xa992,
          "Uniform Resource Locator (Trial)", "UniformResourceLocatorTrial",  "ST", "1" },
        { 0x0040, 0xb020,
          "Waveform Annotation Sequence", "WaveformAnnotationSequence",  "SQ", "1" },
        { 0x0040, 0xdb00,
          "Template Identifier", "TemplateIdentifier",  "CS", "1" },
        { 0x0040, 0xdb06,
          "Template Version", "TemplateVersion",  "DT", "1" },
        { 0x0040, 0xdb07,
          "Template Local Version", "TemplateLocalVersion",  "DT", "1" },
        { 0x0040, 0xdb0b,
          "Template Extension Flag", "TemplateExtensionFlag",  "CS", "1" },
        { 0x0040, 0xdb0c,
          "Template Extension Organization UID", "TemplateExtensionOrganizationUID",  "UI", "1" },
        { 0x0040, 0xdb0d,
          "Template Extension Creator UID", "TemplateExtensionCreatorUID",  "UI", "1" },
        { 0x0040, 0xdb73,
          "Referenced Content Item Identifier", "ReferencedContentItemIdentifier",  "UL", "1-n" },
        { 0x0040, 0xe001,
          "HL7 Instance Identifier", "HL7InstanceIdentifier",  "ST", "1" },
        { 0x0040, 0xe004,
          "HL7 Document Effective Time", "HL7DocumentEffectiveTime",  "DT", "1" },
        { 0x0040, 0xe006,
          "HL7 Document Type Code Sequence", "HL7DocumentTypeCodeSequence",  "SQ", "1" },
        { 0x0040, 0xe008,
          "Document Class Code Sequence", "DocumentClassCodeSequence",  "SQ", "1" },
        { 0x0040, 0xe010,
          "Retrieve URI", "RetrieveURI",  "UR", "1" },
        { 0x0040, 0xe011,
          "Retrieve Location UID", "RetrieveLocationUID",  "UI", "1" },
        { 0x0040, 0xe020,
          "Type of Instances", "TypeOfInstances",  "CS", "1" },
        { 0x0040, 0xe021,
          "DICOM Retrieval Sequence", "DICOMRetrievalSequence",  "SQ", "1" },
        { 0x0040, 0xe022,
          "DICOM Media Retrieval Sequence", "DICOMMediaRetrievalSequence",  "SQ", "1" },
        { 0x0040, 0xe023,
          "WADO Retrieval Sequence", "WADORetrievalSequence",  "SQ", "1" },
        { 0x0040, 0xe024,
          "XDS Retrieval Sequence", "XDSRetrievalSequence",  "SQ", "1" },
        { 0x0040, 0xe025,
          "WADO-RS Retrieval Sequence", "WADORSRetrievalSequence",  "SQ", "1" },
        { 0x0040, 0xe030,
          "Repository Unique ID", "RepositoryUniqueID",  "UI", "1" },
        { 0x0040, 0xe031,
          "Home Community ID", "HomeCommunityID",  "UI", "1" },
        { 0x0042, 0x0010,
          "Document Title", "DocumentTitle",  "ST", "1" },
        { 0x0042, 0x0011,
          "Encapsulated Document", "EncapsulatedDocument",  "OB", "1" },
        { 0x0042, 0x0012,
          "MIME Type of Encapsulated Document", "MIMETypeOfEncapsulatedDocument",  "LO", "1" },
        { 0x0042, 0x0013,
          "Source Instance Sequence", "SourceInstanceSequence",  "SQ", "1" },
        { 0x0042, 0x0014,
          "List of MIME Types", "ListOfMIMETypes",  "LO", "1-n" },
        { 0x0044, 0x0001,
          "Product Package Identifier", "ProductPackageIdentifier",  "ST", "1" },
        { 0x0044, 0x0002,
          "Substance Administration Approval", "SubstanceAdministrationApproval",  "CS", "1" },
        { 0x0044, 0x0003,
          "Approval Status Further Description", "ApprovalStatusFurtherDescription",  "LT", "1" },
        { 0x0044, 0x0004,
          "Approval Status DateTime", "ApprovalStatusDateTime",  "DT", "1" },
        { 0x0044, 0x0007,
          "Product Type Code Sequence", "ProductTypeCodeSequence",  "SQ", "1" },
        { 0x0044, 0x0008,
          "Product Name", "ProductName",  "LO", "1-n" },
        { 0x0044, 0x0009,
          "Product Description", "ProductDescription",  "LT", "1" },
        { 0x0044, 0x000a,
          "Product Lot Identifier", "ProductLotIdentifier",  "LO", "1" },
        { 0x0044, 0x000b,
          "Product Expiration DateTime", "ProductExpirationDateTime",  "DT", "1" },
        { 0x0044, 0x0010,
          "Substance Administration DateTime", "SubstanceAdministrationDateTime",  "DT", "1" },
        { 0x0044, 0x0011,
          "Substance Administration Notes", "SubstanceAdministrationNotes",  "LO", "1" },
        { 0x0044, 0x0012,
          "Substance Administration Device ID", "SubstanceAdministrationDeviceID",  "LO", "1" },
        { 0x0044, 0x0013,
          "Product Parameter Sequence", "ProductParameterSequence",  "SQ", "1" },
        { 0x0044, 0x0019,
          "Substance Administration Parameter Sequence", "SubstanceAdministrationParameterSequence",  "SQ", "1" },
        { 0x0046, 0x0012,
          "Lens Description", "LensDescription",  "LO", "1" },
        { 0x0046, 0x0014,
          "Right Lens Sequence", "RightLensSequence",  "SQ", "1" },
        { 0x0046, 0x0015,
          "Left Lens Sequence", "LeftLensSequence",  "SQ", "1" },
        { 0x0046, 0x0016,
          "Unspecified Laterality Lens Sequence", "UnspecifiedLateralityLensSequence",  "SQ", "1" },
        { 0x0046, 0x0018,
          "Cylinder Sequence", "CylinderSequence",  "SQ", "1" },
        { 0x0046, 0x0028,
          "Prism Sequence", "PrismSequence",  "SQ", "1" },
        { 0x0046, 0x0030,
          "Horizontal Prism Power", "HorizontalPrismPower",  "FD", "1" },
        { 0x0046, 0x0032,
          "Horizontal Prism Base", "HorizontalPrismBase",  "CS", "1" },
        { 0x0046, 0x0034,
          "Vertical Prism Power", "VerticalPrismPower",  "FD", "1" },
        { 0x0046, 0x0036,
          "Vertical Prism Base", "VerticalPrismBase",  "CS", "1" },
        { 0x0046, 0x0038,
          "Lens Segment Type", "LensSegmentType",  "CS", "1" },
        { 0x0046, 0x0040,
          "Optical Transmittance", "OpticalTransmittance",  "FD", "1" },
        { 0x0046, 0x0042,
          "Channel Width", "ChannelWidth",  "FD", "1" },
        { 0x0046, 0x0044,
          "Pupil Size", "PupilSize",  "FD", "1" },
        { 0x0046, 0x0046,
          "Corneal Size", "CornealSize",  "FD", "1" },
        { 0x0046, 0x0050,
          "Autorefraction Right Eye Sequence", "AutorefractionRightEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0052,
          "Autorefraction Left Eye Sequence", "AutorefractionLeftEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0060,
          "Distance Pupillary Distance", "DistancePupillaryDistance",  "FD", "1" },
        { 0x0046, 0x0062,
          "Near Pupillary Distance", "NearPupillaryDistance",  "FD", "1" },
        { 0x0046, 0x0063,
          "Intermediate Pupillary Distance", "IntermediatePupillaryDistance",  "FD", "1" },
        { 0x0046, 0x0064,
          "Other Pupillary Distance", "OtherPupillaryDistance",  "FD", "1" },
        { 0x0046, 0x0070,
          "Keratometry Right Eye Sequence", "KeratometryRightEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0071,
          "Keratometry Left Eye Sequence", "KeratometryLeftEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0074,
          "Steep Keratometric Axis Sequence", "SteepKeratometricAxisSequence",  "SQ", "1" },
        { 0x0046, 0x0075,
          "Radius of Curvature", "RadiusOfCurvature",  "FD", "1" },
        { 0x0046, 0x0076,
          "Keratometric Power", "KeratometricPower",  "FD", "1" },
        { 0x0046, 0x0077,
          "Keratometric Axis", "KeratometricAxis",  "FD", "1" },
        { 0x0046, 0x0080,
          "Flat Keratometric Axis Sequence", "FlatKeratometricAxisSequence",  "SQ", "1" },
        { 0x0046, 0x0092,
          "Background Color", "BackgroundColor",  "CS", "1" },
        { 0x0046, 0x0094,
          "Optotype", "Optotype",  "CS", "1" },
        { 0x0046, 0x0095,
          "Optotype Presentation", "OptotypePresentation",  "CS", "1" },
        { 0x0046, 0x0097,
          "Subjective Refraction Right Eye Sequence", "SubjectiveRefractionRightEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0098,
          "Subjective Refraction Left Eye Sequence", "SubjectiveRefractionLeftEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0100,
          "Add Near Sequence", "AddNearSequence",  "SQ", "1" },
        { 0x0046, 0x0101,
          "Add Intermediate Sequence", "AddIntermediateSequence",  "SQ", "1" },
        { 0x0046, 0x0102,
          "Add Other Sequence", "AddOtherSequence",  "SQ", "1" },
        { 0x0046, 0x0104,
          "Add Power", "AddPower",  "FD", "1" },
        { 0x0046, 0x0106,
          "Viewing Distance", "ViewingDistance",  "FD", "1" },
        { 0x0046, 0x0121,
          "Visual Acuity Type Code Sequence", "VisualAcuityTypeCodeSequence",  "SQ", "1" },
        { 0x0046, 0x0122,
          "Visual Acuity Right Eye Sequence", "VisualAcuityRightEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0123,
          "Visual Acuity Left Eye Sequence", "VisualAcuityLeftEyeSequence",  "SQ", "1" },
        { 0x0046, 0x0124,
          "Visual Acuity Both Eyes Open Sequence", "VisualAcuityBothEyesOpenSequence",  "SQ", "1" },
        { 0x0046, 0x0125,
          "Viewing Distance Type", "ViewingDistanceType",  "CS", "1" },
        { 0x0046, 0x0135,
          "Visual Acuity Modifiers", "VisualAcuityModifiers",  "SS", "2" },
        { 0x0046, 0x0137,
          "Decimal Visual Acuity", "DecimalVisualAcuity",  "FD", "1" },
        { 0x0046, 0x0139,
          "Optotype Detailed Definition", "OptotypeDetailedDefinition",  "LO", "1" },
        { 0x0046, 0x0145,
          "Referenced Refractive Measurements Sequence", "ReferencedRefractiveMeasurementsSequence",  "SQ", "1" },
        { 0x0046, 0x0146,
          "Sphere Power", "SpherePower",  "FD", "1" },
        { 0x0046, 0x0147,
          "Cylinder Power", "CylinderPower",  "FD", "1" },
        { 0x0046, 0x0201,
          "Corneal Topography Surface", "CornealTopographySurface",  "CS", "1" },
        { 0x0046, 0x0202,
          "Corneal Vertex Location", "CornealVertexLocation",  "FL", "2" },
        { 0x0046, 0x0203,
          "Pupil Centroid X-Coordinate", "PupilCentroidXCoordinate",  "FL", "1" },
        { 0x0046, 0x0204,
          "Pupil Centroid Y-Coordinate", "PupilCentroidYCoordinate",  "FL", "1" },
        { 0x0046, 0x0205,
          "Equivalent Pupil Radius", "EquivalentPupilRadius",  "FL", "1" },
        { 0x0046, 0x0207,
          "Corneal Topography Map Type Code Sequence", "CornealTopographyMapTypeCodeSequence",  "SQ", "1" },
        { 0x0046, 0x0208,
          "Vertices of the Outline of Pupil", "VerticesOfTheOutlineOfPupil",  "IS", "2-2n" },
        { 0x0046, 0x0210,
          "Corneal Topography Mapping Normals Sequence", "CornealTopographyMappingNormalsSequence",  "SQ", "1" },
        { 0x0046, 0x0211,
          "Maximum Corneal Curvature Sequence", "MaximumCornealCurvatureSequence",  "SQ", "1" },
        { 0x0046, 0x0212,
          "Maximum Corneal Curvature", "MaximumCornealCurvature",  "FL", "1" },
        { 0x0046, 0x0213,
          "Maximum Corneal Curvature Location", "MaximumCornealCurvatureLocation",  "FL", "2" },
        { 0x0046, 0x0215,
          "Minimum Keratometric Sequence", "MinimumKeratometricSequence",  "SQ", "1" },
        { 0x0046, 0x0218,
          "Simulated Keratometric Cylinder Sequence", "SimulatedKeratometricCylinderSequence",  "SQ", "1" },
        { 0x0046, 0x0220,
          "Average Corneal Power", "AverageCornealPower",  "FL", "1" },
        { 0x0046, 0x0224,
          "Corneal I-S Value", "CornealISValue",  "FL", "1" },
        { 0x0046, 0x0227,
          "Analyzed Area", "AnalyzedArea",  "FL", "1" },
        { 0x0046, 0x0230,
          "Surface Regularity Index", "SurfaceRegularityIndex",  "FL", "1" },
        { 0x0046, 0x0232,
          "Surface Asymmetry Index", "SurfaceAsymmetryIndex",  "FL", "1" },
        { 0x0046, 0x0234,
          "Corneal Eccentricity Index", "CornealEccentricityIndex",  "FL", "1" },
        { 0x0046, 0x0236,
          "Keratoconus Prediction Index", "KeratoconusPredictionIndex",  "FL", "1" },
        { 0x0046, 0x0238,
          "Decimal Potential Visual Acuity", "DecimalPotentialVisualAcuity",  "FL", "1" },
        { 0x0046, 0x0242,
          "Corneal Topography Map Quality Evaluation", "CornealTopographyMapQualityEvaluation",  "CS", "1" },
        { 0x0046, 0x0244,
          "Source Image Corneal Processed Data Sequence", "SourceImageCornealProcessedDataSequence",  "SQ", "1" },
        { 0x0046, 0x0247,
          "Corneal Point Location", "CornealPointLocation",  "FL", "3" },
        { 0x0046, 0x0248,
          "Corneal Point Estimated", "CornealPointEstimated",  "CS", "1" },
        { 0x0046, 0x0249,
          "Axial Power", "AxialPower",  "FL", "1" },
        { 0x0046, 0x0250,
          "Tangential Power", "TangentialPower",  "FL", "1" },
        { 0x0046, 0x0251,
          "Refractive Power", "RefractivePower",  "FL", "1" },
        { 0x0046, 0x0252,
          "Relative Elevation", "RelativeElevation",  "FL", "1" },
        { 0x0046, 0x0253,
          "Corneal Wavefront", "CornealWavefront",  "FL", "1" },
        { 0x0048, 0x0001,
          "Imaged Volume Width", "ImagedVolumeWidth",  "FL", "1" },
        { 0x0048, 0x0002,
          "Imaged Volume Height", "ImagedVolumeHeight",  "FL", "1" },
        { 0x0048, 0x0003,
          "Imaged Volume Depth", "ImagedVolumeDepth",  "FL", "1" },
        { 0x0048, 0x0006,
          "Total Pixel Matrix Columns", "TotalPixelMatrixColumns",  "UL", "1" },
        { 0x0048, 0x0007,
          "Total Pixel Matrix Rows", "TotalPixelMatrixRows",  "UL", "1" },
        { 0x0048, 0x0008,
          "Total Pixel Matrix Origin Sequence", "TotalPixelMatrixOriginSequence",  "SQ", "1" },
        { 0x0048, 0x0010,
          "Specimen Label in Image", "SpecimenLabelInImage",  "CS", "1" },
        { 0x0048, 0x0011,
          "Focus Method", "FocusMethod",  "CS", "1" },
        { 0x0048, 0x0012,
          "Extended Depth of Field", "ExtendedDepthOfField",  "CS", "1" },
        { 0x0048, 0x0013,
          "Number of Focal Planes", "NumberOfFocalPlanes",  "US", "1" },
        { 0x0048, 0x0014,
          "Distance Between Focal Planes", "DistanceBetweenFocalPlanes",  "FL", "1" },
        { 0x0048, 0x0015,
          "Recommended Absent Pixel CIELab Value", "RecommendedAbsentPixelCIELabValue",  "US", "3" },
        { 0x0048, 0x0100,
          "Illuminator Type Code Sequence", "IlluminatorTypeCodeSequence",  "SQ", "1" },
        { 0x0048, 0x0102,
          "Image Orientation (Slide)", "ImageOrientationSlide",  "DS", "6" },
        { 0x0048, 0x0105,
          "Optical Path Sequence", "OpticalPathSequence",  "SQ", "1" },
        { 0x0048, 0x0106,
          "Optical Path Identifier", "OpticalPathIdentifier",  "SH", "1" },
        { 0x0048, 0x0107,
          "Optical Path Description", "OpticalPathDescription",  "ST", "1" },
        { 0x0048, 0x0108,
          "Illumination Color Code Sequence", "IlluminationColorCodeSequence",  "SQ", "1" },
        { 0x0048, 0x0110,
          "Specimen Reference Sequence", "SpecimenReferenceSequence",  "SQ", "1" },
        { 0x0048, 0x0111,
          "Condenser Lens Power", "CondenserLensPower",  "DS", "1" },
        { 0x0048, 0x0112,
          "Objective Lens Power", "ObjectiveLensPower",  "DS", "1" },
        { 0x0048, 0x0113,
          "Objective Lens Numerical Aperture", "ObjectiveLensNumericalAperture",  "DS", "1" },
        { 0x0048, 0x0120,
          "Palette Color Lookup Table Sequence", "PaletteColorLookupTableSequence",  "SQ", "1" },
        { 0x0048, 0x0200,
          "Referenced Image Navigation Sequence", "ReferencedImageNavigationSequence",  "SQ", "1" },
        { 0x0048, 0x0201,
          "Top Left Hand Corner of Localizer Area", "TopLeftHandCornerOfLocalizerArea",  "US", "2" },
        { 0x0048, 0x0202,
          "Bottom Right Hand Corner of Localizer Area", "BottomRightHandCornerOfLocalizerArea",  "US", "2" },
        { 0x0048, 0x0207,
          "Optical Path Identification Sequence", "OpticalPathIdentificationSequence",  "SQ", "1" },
        { 0x0048, 0x021a,
          "Plane Position (Slide) Sequence", "PlanePositionSlideSequence",  "SQ", "1" },
        { 0x0048, 0x021e,
          "Column Position In Total Image Pixel Matrix", "ColumnPositionInTotalImagePixelMatrix",  "SL", "1" },
        { 0x0048, 0x021f,
          "Row Position In Total Image Pixel Matrix", "RowPositionInTotalImagePixelMatrix",  "SL", "1" },
        { 0x0048, 0x0301,
          "Pixel Origin Interpretation", "PixelOriginInterpretation",  "CS", "1" },
        { 0x0050, 0x0004,
          "Calibration Image", "CalibrationImage",  "CS", "1" },
        { 0x0050, 0x0010,
          "Device Sequence", "DeviceSequence",  "SQ", "1" },
        { 0x0050, 0x0012,
          "Container Component Type Code Sequence", "ContainerComponentTypeCodeSequence",  "SQ", "1" },
        { 0x0050, 0x0013,
          "Container Component Thickness", "ContainerComponentThickness",  "FD", "1" },
        { 0x0050, 0x0014,
          "Device Length", "DeviceLength",  "DS", "1" },
        { 0x0050, 0x0015,
          "Container Component Width", "ContainerComponentWidth",  "FD", "1" },
        { 0x0050, 0x0016,
          "Device Diameter", "DeviceDiameter",  "DS", "1" },
        { 0x0050, 0x0017,
          "Device Diameter Units", "DeviceDiameterUnits",  "CS", "1" },
        { 0x0050, 0x0018,
          "Device Volume", "DeviceVolume",  "DS", "1" },
        { 0x0050, 0x0019,
          "Inter-Marker Distance", "InterMarkerDistance",  "DS", "1" },
        { 0x0050, 0x001a,
          "Container Component Material", "ContainerComponentMaterial",  "CS", "1" },
        { 0x0050, 0x001b,
          "Container Component ID", "ContainerComponentID",  "LO", "1" },
        { 0x0050, 0x001c,
          "Container Component Length", "ContainerComponentLength",  "FD", "1" },
        { 0x0050, 0x001d,
          "Container Component Diameter", "ContainerComponentDiameter",  "FD", "1" },
        { 0x0050, 0x001e,
          "Container Component Description", "ContainerComponentDescription",  "LO", "1" },
        { 0x0050, 0x0020,
          "Device Description", "DeviceDescription",  "LO", "1" },
        { 0x0052, 0x0001,
          "Contrast/Bolus Ingredient Percent by Volume", "ContrastBolusIngredientPercentByVolume",  "FL", "1" },
        { 0x0052, 0x0002,
          "OCT Focal Distance", "OCTFocalDistance",  "FD", "1" },
        { 0x0052, 0x0003,
          "Beam Spot Size", "BeamSpotSize",  "FD", "1" },
        { 0x0052, 0x0004,
          "Effective Refractive Index", "EffectiveRefractiveIndex",  "FD", "1" },
        { 0x0052, 0x0006,
          "OCT Acquisition Domain", "OCTAcquisitionDomain",  "CS", "1" },
        { 0x0052, 0x0007,
          "OCT Optical Center Wavelength", "OCTOpticalCenterWavelength",  "FD", "1" },
        { 0x0052, 0x0008,
          "Axial Resolution", "AxialResolution",  "FD", "1" },
        { 0x0052, 0x0009,
          "Ranging Depth", "RangingDepth",  "FD", "1" },
        { 0x0052, 0x0011,
          "A-line Rate", "ALineRate",  "FD", "1" },
        { 0x0052, 0x0012,
          "A-lines Per Frame", "ALinesPerFrame",  "US", "1" },
        { 0x0052, 0x0013,
          "Catheter Rotational Rate", "CatheterRotationalRate",  "FD", "1" },
        { 0x0052, 0x0014,
          "A-line Pixel Spacing", "ALinePixelSpacing",  "FD", "1" },
        { 0x0052, 0x0016,
          "Mode of Percutaneous Access Sequence", "ModeOfPercutaneousAccessSequence",  "SQ", "1" },
        { 0x0052, 0x0025,
          "Intravascular OCT Frame Type Sequence", "IntravascularOCTFrameTypeSequence",  "SQ", "1" },
        { 0x0052, 0x0026,
          "OCT Z Offset Applied", "OCTZOffsetApplied",  "CS", "1" },
        { 0x0052, 0x0027,
          "Intravascular Frame Content Sequence", "IntravascularFrameContentSequence",  "SQ", "1" },
        { 0x0052, 0x0028,
          "Intravascular Longitudinal Distance", "IntravascularLongitudinalDistance",  "FD", "1" },
        { 0x0052, 0x0029,
          "Intravascular OCT Frame Content Sequence", "IntravascularOCTFrameContentSequence",  "SQ", "1" },
        { 0x0052, 0x0030,
          "OCT Z Offset Correction", "OCTZOffsetCorrection",  "SS", "1" },
        { 0x0052, 0x0031,
          "Catheter Direction of Rotation", "CatheterDirectionOfRotation",  "CS", "1" },
        { 0x0052, 0x0033,
          "Seam Line Location", "SeamLineLocation",  "FD", "1" },
        { 0x0052, 0x0034,
          "First A-line Location", "FirstALineLocation",  "FD", "1" },
        { 0x0052, 0x0036,
          "Seam Line Index", "SeamLineIndex",  "US", "1" },
        { 0x0052, 0x0038,
          "Number of Padded A-lines", "NumberOfPaddedALines",  "US", "1" },
        { 0x0052, 0x0039,
          "Interpolation Type", "InterpolationType",  "CS", "1" },
        { 0x0052, 0x003a,
          "Refractive Index Applied", "RefractiveIndexApplied",  "CS", "1" },
        { 0x0054, 0x0010,
          "Energy Window Vector", "EnergyWindowVector",  "US", "1-n" },
        { 0x0054, 0x0011,
          "Number of Energy Windows", "NumberOfEnergyWindows",  "US", "1" },
        { 0x0054, 0x0012,
          "Energy Window Information Sequence", "EnergyWindowInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0013,
          "Energy Window Range Sequence", "EnergyWindowRangeSequence",  "SQ", "1" },
        { 0x0054, 0x0014,
          "Energy Window Lower Limit", "EnergyWindowLowerLimit",  "DS", "1" },
        { 0x0054, 0x0015,
          "Energy Window Upper Limit", "EnergyWindowUpperLimit",  "DS", "1" },
        { 0x0054, 0x0016,
          "Radiopharmaceutical Information Sequence", "RadiopharmaceuticalInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0017,
          "Residual Syringe Counts", "ResidualSyringeCounts",  "IS", "1" },
        { 0x0054, 0x0018,
          "Energy Window Name", "EnergyWindowName",  "SH", "1" },
        { 0x0054, 0x0020,
          "Detector Vector", "DetectorVector",  "US", "1-n" },
        { 0x0054, 0x0021,
          "Number of Detectors", "NumberOfDetectors",  "US", "1" },
        { 0x0054, 0x0022,
          "Detector Information Sequence", "DetectorInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0030,
          "Phase Vector", "PhaseVector",  "US", "1-n" },
        { 0x0054, 0x0031,
          "Number of Phases", "NumberOfPhases",  "US", "1" },
        { 0x0054, 0x0032,
          "Phase Information Sequence", "PhaseInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0033,
          "Number of Frames in Phase", "NumberOfFramesInPhase",  "US", "1" },
        { 0x0054, 0x0036,
          "Phase Delay", "PhaseDelay",  "IS", "1" },
        { 0x0054, 0x0038,
          "Pause Between Frames", "PauseBetweenFrames",  "IS", "1" },
        { 0x0054, 0x0039,
          "Phase Description", "PhaseDescription",  "CS", "1" },
        { 0x0054, 0x0050,
          "Rotation Vector", "RotationVector",  "US", "1-n" },
        { 0x0054, 0x0051,
          "Number of Rotations", "NumberOfRotations",  "US", "1" },
        { 0x0054, 0x0052,
          "Rotation Information Sequence", "RotationInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0053,
          "Number of Frames in Rotation", "NumberOfFramesInRotation",  "US", "1" },
        { 0x0054, 0x0060,
          "R-R Interval Vector", "RRIntervalVector",  "US", "1-n" },
        { 0x0054, 0x0061,
          "Number of R-R Intervals", "NumberOfRRIntervals",  "US", "1" },
        { 0x0054, 0x0062,
          "Gated Information Sequence", "GatedInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0063,
          "Data Information Sequence", "DataInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0070,
          "Time Slot Vector", "TimeSlotVector",  "US", "1-n" },
        { 0x0054, 0x0071,
          "Number of Time Slots", "NumberOfTimeSlots",  "US", "1" },
        { 0x0054, 0x0072,
          "Time Slot Information Sequence", "TimeSlotInformationSequence",  "SQ", "1" },
        { 0x0054, 0x0073,
          "Time Slot Time", "TimeSlotTime",  "DS", "1" },
        { 0x0054, 0x0080,
          "Slice Vector", "SliceVector",  "US", "1-n" },
        { 0x0054, 0x0081,
          "Number of Slices", "NumberOfSlices",  "US", "1" },
        { 0x0054, 0x0090,
          "Angular View Vector", "AngularViewVector",  "US", "1-n" },
        { 0x0054, 0x0100,
          "Time Slice Vector", "TimeSliceVector",  "US", "1-n" },
        { 0x0054, 0x0101,
          "Number of Time Slices", "NumberOfTimeSlices",  "US", "1" },
        { 0x0054, 0x0200,
          "Start Angle", "StartAngle",  "DS", "1" },
        { 0x0054, 0x0202,
          "Type of Detector Motion", "TypeOfDetectorMotion",  "CS", "1" },
        { 0x0054, 0x0210,
          "Trigger Vector", "TriggerVector",  "IS", "1-n" },
        { 0x0054, 0x0211,
          "Number of Triggers in Phase", "NumberOfTriggersInPhase",  "US", "1" },
        { 0x0054, 0x0220,
          "View Code Sequence", "ViewCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0222,
          "View Modifier Code Sequence", "ViewModifierCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0300,
          "Radionuclide Code Sequence", "RadionuclideCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0302,
          "Administration Route Code Sequence", "AdministrationRouteCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0304,
          "Radiopharmaceutical Code Sequence", "RadiopharmaceuticalCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0306,
          "Calibration Data Sequence", "CalibrationDataSequence",  "SQ", "1" },
        { 0x0054, 0x0308,
          "Energy Window Number", "EnergyWindowNumber",  "US", "1" },
        { 0x0054, 0x0400,
          "Image ID", "ImageID",  "SH", "1" },
        { 0x0054, 0x0410,
          "Patient Orientation Code Sequence", "PatientOrientationCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0412,
          "Patient Orientation Modifier Code Sequence", "PatientOrientationModifierCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0414,
          "Patient Gantry Relationship Code Sequence", "PatientGantryRelationshipCodeSequence",  "SQ", "1" },
        { 0x0054, 0x0500,
          "Slice Progression Direction", "SliceProgressionDirection",  "CS", "1" },
        { 0x0054, 0x0501,
          "Scan Progression Direction", "ScanProgressionDirection",  "CS", "1" },
        { 0x0054, 0x1000,
          "Series Type", "SeriesType",  "CS", "2" },
        { 0x0054, 0x1001,
          "Units", "Units",  "CS", "1" },
        { 0x0054, 0x1002,
          "Counts Source", "CountsSource",  "CS", "1" },
        { 0x0054, 0x1004,
          "Reprojection Method", "ReprojectionMethod",  "CS", "1" },
        { 0x0054, 0x1006,
          "SUV Type", "SUVType",  "CS", "1" },
        { 0x0054, 0x1100,
          "Randoms Correction Method", "RandomsCorrectionMethod",  "CS", "1" },
        { 0x0054, 0x1101,
          "Attenuation Correction Method", "AttenuationCorrectionMethod",  "LO", "1" },
        { 0x0054, 0x1102,
          "Decay Correction", "DecayCorrection",  "CS", "1" },
        { 0x0054, 0x1103,
          "Reconstruction Method", "ReconstructionMethod",  "LO", "1" },
        { 0x0054, 0x1104,
          "Detector Lines of Response Used", "DetectorLinesOfResponseUsed",  "LO", "1" },
        { 0x0054, 0x1105,
          "Scatter Correction Method", "ScatterCorrectionMethod",  "LO", "1" },
        { 0x0054, 0x1200,
          "Axial Acceptance", "AxialAcceptance",  "DS", "1" },
        { 0x0054, 0x1201,
          "Axial Mash", "AxialMash",  "IS", "2" },
        { 0x0054, 0x1202,
          "Transverse Mash", "TransverseMash",  "IS", "1" },
        { 0x0054, 0x1203,
          "Detector Element Size", "DetectorElementSize",  "DS", "2" },
        { 0x0054, 0x1210,
          "Coincidence Window Width", "CoincidenceWindowWidth",  "DS", "1" },
        { 0x0054, 0x1220,
          "Secondary Counts Type", "SecondaryCountsType",  "CS", "1-n" },
        { 0x0054, 0x1300,
          "Frame Reference Time", "FrameReferenceTime",  "DS", "1" },
        { 0x0054, 0x1310,
          "Primary (Prompts) Counts Accumulated", "PrimaryPromptsCountsAccumulated",  "IS", "1" },
        { 0x0054, 0x1311,
          "Secondary Counts Accumulated", "SecondaryCountsAccumulated",  "IS", "1-n" },
        { 0x0054, 0x1320,
          "Slice Sensitivity Factor", "SliceSensitivityFactor",  "DS", "1" },
        { 0x0054, 0x1321,
          "Decay Factor", "DecayFactor",  "DS", "1" },
        { 0x0054, 0x1322,
          "Dose Calibration Factor", "DoseCalibrationFactor",  "DS", "1" },
        { 0x0054, 0x1323,
          "Scatter Fraction Factor", "ScatterFractionFactor",  "DS", "1" },
        { 0x0054, 0x1324,
          "Dead Time Factor", "DeadTimeFactor",  "DS", "1" },
        { 0x0054, 0x1330,
          "Image Index", "ImageIndex",  "US", "1" },
        { 0x0054, 0x1400,
          "Counts Included", "CountsIncluded",  "CS", "1-n" },
        { 0x0054, 0x1401,
          "Dead Time Correction Flag", "DeadTimeCorrectionFlag",  "CS", "1" },
        { 0x0060, 0x3000,
          "Histogram Sequence", "HistogramSequence",  "SQ", "1" },
        { 0x0060, 0x3002,
          "Histogram Number of Bins", "HistogramNumberOfBins",  "US", "1" },
        { 0x0060, 0x3004,
          "Histogram First Bin Value", "HistogramFirstBinValue",  "US or SS", "1" },
        { 0x0060, 0x3006,
          "Histogram Last Bin Value", "HistogramLastBinValue",  "US or SS", "1" },
        { 0x0060, 0x3008,
          "Histogram Bin Width", "HistogramBinWidth",  "US", "1" },
        { 0x0060, 0x3010,
          "Histogram Explanation", "HistogramExplanation",  "LO", "1" },
        { 0x0060, 0x3020,
          "Histogram Data", "HistogramData",  "UL", "1-n" },
        { 0x0062, 0x0001,
          "Segmentation Type", "SegmentationType",  "CS", "1" },
        { 0x0062, 0x0002,
          "Segment Sequence", "SegmentSequence",  "SQ", "1" },
        { 0x0062, 0x0003,
          "Segmented Property Category Code Sequence", "SegmentedPropertyCategoryCodeSequence",  "SQ", "1" },
        { 0x0062, 0x0004,
          "Segment Number", "SegmentNumber",  "US", "1" },
        { 0x0062, 0x0005,
          "Segment Label", "SegmentLabel",  "LO", "1" },
        { 0x0062, 0x0006,
          "Segment Description", "SegmentDescription",  "ST", "1" },
        { 0x0062, 0x0008,
          "Segment Algorithm Type", "SegmentAlgorithmType",  "CS", "1" },
        { 0x0062, 0x0009,
          "Segment Algorithm Name", "SegmentAlgorithmName",  "LO", "1" },
        { 0x0062, 0x000a,
          "Segment Identification Sequence", "SegmentIdentificationSequence",  "SQ", "1" },
        { 0x0062, 0x000b,
          "Referenced Segment Number", "ReferencedSegmentNumber",  "US", "1-n" },
        { 0x0062, 0x000c,
          "Recommended Display Grayscale Value", "RecommendedDisplayGrayscaleValue",  "US", "1" },
        { 0x0062, 0x000d,
          "Recommended Display CIELab Value", "RecommendedDisplayCIELabValue",  "US", "3" },
        { 0x0062, 0x000e,
          "Maximum Fractional Value", "MaximumFractionalValue",  "US", "1" },
        { 0x0062, 0x000f,
          "Segmented Property Type Code Sequence", "SegmentedPropertyTypeCodeSequence",  "SQ", "1" },
        { 0x0062, 0x0010,
          "Segmentation Fractional Type", "SegmentationFractionalType",  "CS", "1" },
        { 0x0062, 0x0011,
          "Segmented Property Type Modifier Code Sequence", "SegmentedPropertyTypeModifierCodeSequence",  "SQ", "1" },
        { 0x0062, 0x0012,
          "Used Segments Sequence", "UsedSegmentsSequence",  "SQ", "1" },
        { 0x0064, 0x0002,
          "Deformable Registration Sequence", "DeformableRegistrationSequence",  "SQ", "1" },
        { 0x0064, 0x0003,
          "Source Frame of Reference UID", "SourceFrameOfReferenceUID",  "UI", "1" },
        { 0x0064, 0x0005,
          "Deformable Registration Grid Sequence", "DeformableRegistrationGridSequence",  "SQ", "1" },
        { 0x0064, 0x0007,
          "Grid Dimensions", "GridDimensions",  "UL", "3" },
        { 0x0064, 0x0008,
          "Grid Resolution", "GridResolution",  "FD", "3" },
        { 0x0064, 0x0009,
          "Vector Grid Data", "VectorGridData",  "OF", "1" },
        { 0x0064, 0x000f,
          "Pre Deformation Matrix Registration Sequence", "PreDeformationMatrixRegistrationSequence",  "SQ", "1" },
        { 0x0064, 0x0010,
          "Post Deformation Matrix Registration Sequence", "PostDeformationMatrixRegistrationSequence",  "SQ", "1" },
        { 0x0066, 0x0001,
          "Number of Surfaces", "NumberOfSurfaces",  "UL", "1" },
        { 0x0066, 0x0002,
          "Surface Sequence", "SurfaceSequence",  "SQ", "1" },
        { 0x0066, 0x0003,
          "Surface Number", "SurfaceNumber",  "UL", "1" },
        { 0x0066, 0x0004,
          "Surface Comments", "SurfaceComments",  "LT", "1" },
        { 0x0066, 0x0009,
          "Surface Processing", "SurfaceProcessing",  "CS", "1" },
        { 0x0066, 0x000a,
          "Surface Processing Ratio", "SurfaceProcessingRatio",  "FL", "1" },
        { 0x0066, 0x000b,
          "Surface Processing Description", "SurfaceProcessingDescription",  "LO", "1" },
        { 0x0066, 0x000c,
          "Recommended Presentation Opacity", "RecommendedPresentationOpacity",  "FL", "1" },
        { 0x0066, 0x000d,
          "Recommended Presentation Type", "RecommendedPresentationType",  "CS", "1" },
        { 0x0066, 0x000e,
          "Finite Volume", "FiniteVolume",  "CS", "1" },
        { 0x0066, 0x0010,
          "Manifold", "Manifold",  "CS", "1" },
        { 0x0066, 0x0011,
          "Surface Points Sequence", "SurfacePointsSequence",  "SQ", "1" },
        { 0x0066, 0x0012,
          "Surface Points Normals Sequence", "SurfacePointsNormalsSequence",  "SQ", "1" },
        { 0x0066, 0x0013,
          "Surface Mesh Primitives Sequence", "SurfaceMeshPrimitivesSequence",  "SQ", "1" },
        { 0x0066, 0x0015,
          "Number of Surface Points", "NumberOfSurfacePoints",  "UL", "1" },
        { 0x0066, 0x0016,
          "Point Coordinates Data", "PointCoordinatesData",  "OF", "1" },
        { 0x0066, 0x0017,
          "Point Position Accuracy", "PointPositionAccuracy",  "FL", "3" },
        { 0x0066, 0x0018,
          "Mean Point Distance", "MeanPointDistance",  "FL", "1" },
        { 0x0066, 0x0019,
          "Maximum Point Distance", "MaximumPointDistance",  "FL", "1" },
        { 0x0066, 0x001a,
          "Points Bounding Box Coordinates", "PointsBoundingBoxCoordinates",  "FL", "6" },
        { 0x0066, 0x001b,
          "Axis of Rotation", "AxisOfRotation",  "FL", "3" },
        { 0x0066, 0x001c,
          "Center of Rotation", "CenterOfRotation",  "FL", "3" },
        { 0x0066, 0x001e,
          "Number of Vectors", "NumberOfVectors",  "UL", "1" },
        { 0x0066, 0x001f,
          "Vector Dimensionality", "VectorDimensionality",  "US", "1" },
        { 0x0066, 0x0020,
          "Vector Accuracy", "VectorAccuracy",  "FL", "1-n" },
        { 0x0066, 0x0021,
          "Vector Coordinate Data", "VectorCoordinateData",  "OF", "1" },
        { 0x0066, 0x0023,
          "Triangle Point Index List", "TrianglePointIndexList",  "OW", "1" },
        { 0x0066, 0x0024,
          "Edge Point Index List", "EdgePointIndexList",  "OW", "1" },
        { 0x0066, 0x0025,
          "Vertex Point Index List", "VertexPointIndexList",  "OW", "1" },
        { 0x0066, 0x0026,
          "Triangle Strip Sequence", "TriangleStripSequence",  "SQ", "1" },
        { 0x0066, 0x0027,
          "Triangle Fan Sequence", "TriangleFanSequence",  "SQ", "1" },
        { 0x0066, 0x0028,
          "Line Sequence", "LineSequence",  "SQ", "1" },
        { 0x0066, 0x0029,
          "Primitive Point Index List", "PrimitivePointIndexList",  "OW", "1" },
        { 0x0066, 0x002a,
          "Surface Count", "SurfaceCount",  "UL", "1" },
        { 0x0066, 0x002b,
          "Referenced Surface Sequence", "ReferencedSurfaceSequence",  "SQ", "1" },
        { 0x0066, 0x002c,
          "Referenced Surface Number", "ReferencedSurfaceNumber",  "UL", "1" },
        { 0x0066, 0x002d,
          "Segment Surface Generation Algorithm Identification Sequence", "SegmentSurfaceGenerationAlgorithmIdentificationSequence",  "SQ", "1" },
        { 0x0066, 0x002e,
          "Segment Surface Source Instance Sequence", "SegmentSurfaceSourceInstanceSequence",  "SQ", "1" },
        { 0x0066, 0x002f,
          "Algorithm Family Code Sequence", "AlgorithmFamilyCodeSequence",  "SQ", "1" },
        { 0x0066, 0x0030,
          "Algorithm Name Code Sequence", "AlgorithmNameCodeSequence",  "SQ", "1" },
        { 0x0066, 0x0031,
          "Algorithm Version", "AlgorithmVersion",  "LO", "1" },
        { 0x0066, 0x0032,
          "Algorithm Parameters", "AlgorithmParameters",  "LT", "1" },
        { 0x0066, 0x0034,
          "Facet Sequence", "FacetSequence",  "SQ", "1" },
        { 0x0066, 0x0035,
          "Surface Processing Algorithm Identification Sequence", "SurfaceProcessingAlgorithmIdentificationSequence",  "SQ", "1" },
        { 0x0066, 0x0036,
          "Algorithm Name", "AlgorithmName",  "LO", "1" },
        { 0x0066, 0x0037,
          "Recommended Point Radius", "RecommendedPointRadius",  "FL", "1" },
        { 0x0066, 0x0038,
          "Recommended Line Thickness", "RecommendedLineThickness",  "FL", "1" },
        { 0x0066, 0x0040,
          "Long Primitive Point Index List", "LongPrimitivePointIndexList",  "UL", "1-n" },
        { 0x0066, 0x0041,
          "Long Triangle Point Index List", "LongTrianglePointIndexList",  "UL", "3-3n" },
        { 0x0066, 0x0042,
          "Long Edge Point Index List", "LongEdgePointIndexList",  "UL", "2-2n" },
        { 0x0066, 0x0043,
          "Long Vertex Point Index List", "LongVertexPointIndexList",  "UL", "1-n" },
        { 0x0068, 0x6210,
          "Implant Size", "ImplantSize",  "LO", "1" },
        { 0x0068, 0x6221,
          "Implant Template Version", "ImplantTemplateVersion",  "LO", "1" },
        { 0x0068, 0x6222,
          "Replaced Implant Template Sequence", "ReplacedImplantTemplateSequence",  "SQ", "1" },
        { 0x0068, 0x6223,
          "Implant Type", "ImplantType",  "CS", "1" },
        { 0x0068, 0x6224,
          "Derivation Implant Template Sequence", "DerivationImplantTemplateSequence",  "SQ", "1" },
        { 0x0068, 0x6225,
          "Original Implant Template Sequence", "OriginalImplantTemplateSequence",  "SQ", "1" },
        { 0x0068, 0x6226,
          "Effective DateTime", "EffectiveDateTime",  "DT", "1" },
        { 0x0068, 0x6230,
          "Implant Target Anatomy Sequence", "ImplantTargetAnatomySequence",  "SQ", "1" },
        { 0x0068, 0x6260,
          "Information From Manufacturer Sequence", "InformationFromManufacturerSequence",  "SQ", "1" },
        { 0x0068, 0x6265,
          "Notification From Manufacturer Sequence", "NotificationFromManufacturerSequence",  "SQ", "1" },
        { 0x0068, 0x6270,
          "Information Issue DateTime", "InformationIssueDateTime",  "DT", "1" },
        { 0x0068, 0x6280,
          "Information Summary", "InformationSummary",  "ST", "1" },
        { 0x0068, 0x62a0,
          "Implant Regulatory Disapproval Code Sequence", "ImplantRegulatoryDisapprovalCodeSequence",  "SQ", "1" },
        { 0x0068, 0x62a5,
          "Overall Template Spatial Tolerance", "OverallTemplateSpatialTolerance",  "FD", "1" },
        { 0x0068, 0x62c0,
          "HPGL Document Sequence", "HPGLDocumentSequence",  "SQ", "1" },
        { 0x0068, 0x62d0,
          "HPGL Document ID", "HPGLDocumentID",  "US", "1" },
        { 0x0068, 0x62d5,
          "HPGL Document Label", "HPGLDocumentLabel",  "LO", "1" },
        { 0x0068, 0x62e0,
          "View Orientation Code Sequence", "ViewOrientationCodeSequence",  "SQ", "1" },
        { 0x0068, 0x62f0,
          "View Orientation Modifier", "ViewOrientationModifier",  "FD", "9" },
        { 0x0068, 0x62f2,
          "HPGL Document Scaling", "HPGLDocumentScaling",  "FD", "1" },
        { 0x0068, 0x6300,
          "HPGL Document", "HPGLDocument",  "OB", "1" },
        { 0x0068, 0x6310,
          "HPGL Contour Pen Number", "HPGLContourPenNumber",  "US", "1" },
        { 0x0068, 0x6320,
          "HPGL Pen Sequence", "HPGLPenSequence",  "SQ", "1" },
        { 0x0068, 0x6330,
          "HPGL Pen Number", "HPGLPenNumber",  "US", "1" },
        { 0x0068, 0x6340,
          "HPGL Pen Label", "HPGLPenLabel",  "LO", "1" },
        { 0x0068, 0x6345,
          "HPGL Pen Description", "HPGLPenDescription",  "ST", "1" },
        { 0x0068, 0x6346,
          "Recommended Rotation Point", "RecommendedRotationPoint",  "FD", "2" },
        { 0x0068, 0x6347,
          "Bounding Rectangle", "BoundingRectangle",  "FD", "4" },
        { 0x0068, 0x6350,
          "Implant Template 3D Model Surface Number", "ImplantTemplate3DModelSurfaceNumber",  "US", "1-n" },
        { 0x0068, 0x6360,
          "Surface Model Description Sequence", "SurfaceModelDescriptionSequence",  "SQ", "1" },
        { 0x0068, 0x6380,
          "Surface Model Label", "SurfaceModelLabel",  "LO", "1" },
        { 0x0068, 0x6390,
          "Surface Model Scaling Factor", "SurfaceModelScalingFactor",  "FD", "1" },
        { 0x0068, 0x63a0,
          "Materials Code Sequence", "MaterialsCodeSequence",  "SQ", "1" },
        { 0x0068, 0x63a4,
          "Coating Materials Code Sequence", "CoatingMaterialsCodeSequence",  "SQ", "1" },
        { 0x0068, 0x63a8,
          "Implant Type Code Sequence", "ImplantTypeCodeSequence",  "SQ", "1" },
        { 0x0068, 0x63ac,
          "Fixation Method Code Sequence", "FixationMethodCodeSequence",  "SQ", "1" },
        { 0x0068, 0x63b0,
          "Mating Feature Sets Sequence", "MatingFeatureSetsSequence",  "SQ", "1" },
        { 0x0068, 0x63c0,
          "Mating Feature Set ID", "MatingFeatureSetID",  "US", "1" },
        { 0x0068, 0x63d0,
          "Mating Feature Set Label", "MatingFeatureSetLabel",  "LO", "1" },
        { 0x0068, 0x63e0,
          "Mating Feature Sequence", "MatingFeatureSequence",  "SQ", "1" },
        { 0x0068, 0x63f0,
          "Mating Feature ID", "MatingFeatureID",  "US", "1" },
        { 0x0068, 0x6400,
          "Mating Feature Degree of Freedom Sequence", "MatingFeatureDegreeOfFreedomSequence",  "SQ", "1" },
        { 0x0068, 0x6410,
          "Degree of Freedom ID", "DegreeOfFreedomID",  "US", "1" },
        { 0x0068, 0x6420,
          "Degree of Freedom Type", "DegreeOfFreedomType",  "CS", "1" },
        { 0x0068, 0x6430,
          "2D Mating Feature Coordinates Sequence", "TwoDMatingFeatureCoordinatesSequence",  "SQ", "1" },
        { 0x0068, 0x6440,
          "Referenced HPGL Document ID", "ReferencedHPGLDocumentID",  "US", "1" },
        { 0x0068, 0x6450,
          "2D Mating Point", "TwoDMatingPoint",  "FD", "2" },
        { 0x0068, 0x6460,
          "2D Mating Axes", "TwoDMatingAxes",  "FD", "4" },
        { 0x0068, 0x6470,
          "2D Degree of Freedom Sequence", "TwoDDegreeOfFreedomSequence",  "SQ", "1" },
        { 0x0068, 0x6490,
          "3D Degree of Freedom Axis", "ThreeDDegreeOfFreedomAxis",  "FD", "3" },
        { 0x0068, 0x64a0,
          "Range of Freedom", "RangeOfFreedom",  "FD", "2" },
        { 0x0068, 0x64c0,
          "3D Mating Point", "ThreeDMatingPoint",  "FD", "3" },
        { 0x0068, 0x64d0,
          "3D Mating Axes", "ThreeDMatingAxes",  "FD", "9" },
        { 0x0068, 0x64f0,
          "2D Degree of Freedom Axis", "TwoDDegreeOfFreedomAxis",  "FD", "3" },
        { 0x0068, 0x6500,
          "Planning Landmark Point Sequence", "PlanningLandmarkPointSequence",  "SQ", "1" },
        { 0x0068, 0x6510,
          "Planning Landmark Line Sequence", "PlanningLandmarkLineSequence",  "SQ", "1" },
        { 0x0068, 0x6520,
          "Planning Landmark Plane Sequence", "PlanningLandmarkPlaneSequence",  "SQ", "1" },
        { 0x0068, 0x6530,
          "Planning Landmark ID", "PlanningLandmarkID",  "US", "1" },
        { 0x0068, 0x6540,
          "Planning Landmark Description", "PlanningLandmarkDescription",  "LO", "1" },
        { 0x0068, 0x6545,
          "Planning Landmark Identification Code Sequence", "PlanningLandmarkIdentificationCodeSequence",  "SQ", "1" },
        { 0x0068, 0x6550,
          "2D Point Coordinates Sequence", "TwoDPointCoordinatesSequence",  "SQ", "1" },
        { 0x0068, 0x6560,
          "2D Point Coordinates", "TwoDPointCoordinates",  "FD", "2" },
        { 0x0068, 0x6590,
          "3D Point Coordinates", "ThreeDPointCoordinates",  "FD", "3" },
        { 0x0068, 0x65a0,
          "2D Line Coordinates Sequence", "TwoDLineCoordinatesSequence",  "SQ", "1" },
        { 0x0068, 0x65b0,
          "2D Line Coordinates", "TwoDLineCoordinates",  "FD", "4" },
        { 0x0068, 0x65d0,
          "3D Line Coordinates", "ThreeDLineCoordinates",  "FD", "6" },
        { 0x0068, 0x65e0,
          "2D Plane Coordinates Sequence", "TwoDPlaneCoordinatesSequence",  "SQ", "1" },
        { 0x0068, 0x65f0,
          "2D Plane Intersection", "TwoDPlaneIntersection",  "FD", "4" },
        { 0x0068, 0x6610,
          "3D Plane Origin", "ThreeDPlaneOrigin",  "FD", "3" },
        { 0x0068, 0x6620,
          "3D Plane Normal", "ThreeDPlaneNormal",  "FD", "3" },
        { 0x0070, 0x0001,
          "Graphic Annotation Sequence", "GraphicAnnotationSequence",  "SQ", "1" },
        { 0x0070, 0x0002,
          "Graphic Layer", "GraphicLayer",  "CS", "1" },
        { 0x0070, 0x0003,
          "Bounding Box Annotation Units", "BoundingBoxAnnotationUnits",  "CS", "1" },
        { 0x0070, 0x0004,
          "Anchor Point Annotation Units", "AnchorPointAnnotationUnits",  "CS", "1" },
        { 0x0070, 0x0005,
          "Graphic Annotation Units", "GraphicAnnotationUnits",  "CS", "1" },
        { 0x0070, 0x0006,
          "Unformatted Text Value", "UnformattedTextValue",  "ST", "1" },
        { 0x0070, 0x0008,
          "Text Object Sequence", "TextObjectSequence",  "SQ", "1" },
        { 0x0070, 0x0009,
          "Graphic Object Sequence", "GraphicObjectSequence",  "SQ", "1" },
        { 0x0070, 0x0010,
          "Bounding Box Top Left Hand Corner", "BoundingBoxTopLeftHandCorner",  "FL", "2" },
        { 0x0070, 0x0011,
          "Bounding Box Bottom Right Hand Corner", "BoundingBoxBottomRightHandCorner",  "FL", "2" },
        { 0x0070, 0x0012,
          "Bounding Box Text Horizontal Justification", "BoundingBoxTextHorizontalJustification",  "CS", "1" },
        { 0x0070, 0x0014,
          "Anchor Point", "AnchorPoint",  "FL", "2" },
        { 0x0070, 0x0015,
          "Anchor Point Visibility", "AnchorPointVisibility",  "CS", "1" },
        { 0x0070, 0x0020,
          "Graphic Dimensions", "GraphicDimensions",  "US", "1" },
        { 0x0070, 0x0021,
          "Number of Graphic Points", "NumberOfGraphicPoints",  "US", "1" },
        { 0x0070, 0x0022,
          "Graphic Data", "GraphicData",  "FL", "2-n" },
        { 0x0070, 0x0023,
          "Graphic Type", "GraphicType",  "CS", "1" },
        { 0x0070, 0x0024,
          "Graphic Filled", "GraphicFilled",  "CS", "1" },
        { 0x0070, 0x0040,
          "Image Rotation (Retired)", "ImageRotationRetired",  "IS", "1" },
        { 0x0070, 0x0041,
          "Image Horizontal Flip", "ImageHorizontalFlip",  "CS", "1" },
        { 0x0070, 0x0042,
          "Image Rotation", "ImageRotation",  "US", "1" },
        { 0x0070, 0x0050,
          "Displayed Area Top Left Hand Corner (Trial)", "DisplayedAreaTopLeftHandCornerTrial",  "US", "2" },
        { 0x0070, 0x0051,
          "Displayed Area Bottom Right Hand Corner (Trial)", "DisplayedAreaBottomRightHandCornerTrial",  "US", "2" },
        { 0x0070, 0x0052,
          "Displayed Area Top Left Hand Corner", "DisplayedAreaTopLeftHandCorner",  "SL", "2" },
        { 0x0070, 0x0053,
          "Displayed Area Bottom Right Hand Corner", "DisplayedAreaBottomRightHandCorner",  "SL", "2" },
        { 0x0070, 0x005a,
          "Displayed Area Selection Sequence", "DisplayedAreaSelectionSequence",  "SQ", "1" },
        { 0x0070, 0x0060,
          "Graphic Layer Sequence", "GraphicLayerSequence",  "SQ", "1" },
        { 0x0070, 0x0062,
          "Graphic Layer Order", "GraphicLayerOrder",  "IS", "1" },
        { 0x0070, 0x0066,
          "Graphic Layer Recommended Display Grayscale Value", "GraphicLayerRecommendedDisplayGrayscaleValue",  "US", "1" },
        { 0x0070, 0x0067,
          "Graphic Layer Recommended Display RGB Value", "GraphicLayerRecommendedDisplayRGBValue",  "US", "3" },
        { 0x0070, 0x0068,
          "Graphic Layer Description", "GraphicLayerDescription",  "LO", "1" },
        { 0x0070, 0x0080,
          "Content Label", "ContentLabel",  "CS", "1" },
        { 0x0070, 0x0081,
          "Content Description", "ContentDescription",  "LO", "1" },
        { 0x0070, 0x0082,
          "Presentation Creation Date", "PresentationCreationDate",  "DA", "1" },
        { 0x0070, 0x0083,
          "Presentation Creation Time", "PresentationCreationTime",  "TM", "1" },
        { 0x0070, 0x0084,
          "Content Creator's Name", "ContentCreatorName",  "PN", "1" },
        { 0x0070, 0x0086,
          "Content Creator's Identification Code Sequence", "ContentCreatorIdentificationCodeSequence",  "SQ", "1" },
        { 0x0070, 0x0087,
          "Alternate Content Description Sequence", "AlternateContentDescriptionSequence",  "SQ", "1" },
        { 0x0070, 0x0100,
          "Presentation Size Mode", "PresentationSizeMode",  "CS", "1" },
        { 0x0070, 0x0101,
          "Presentation Pixel Spacing", "PresentationPixelSpacing",  "DS", "2" },
        { 0x0070, 0x0102,
          "Presentation Pixel Aspect Ratio", "PresentationPixelAspectRatio",  "IS", "2" },
        { 0x0070, 0x0103,
          "Presentation Pixel Magnification Ratio", "PresentationPixelMagnificationRatio",  "FL", "1" },
        { 0x0070, 0x0207,
          "Graphic Group Label", "GraphicGroupLabel",  "LO", "1" },
        { 0x0070, 0x0208,
          "Graphic Group Description", "GraphicGroupDescription",  "ST", "1" },
        { 0x0070, 0x0209,
          "Compound Graphic Sequence", "CompoundGraphicSequence",  "SQ", "1" },
        { 0x0070, 0x0226,
          "Compound Graphic Instance ID", "CompoundGraphicInstanceID",  "UL", "1" },
        { 0x0070, 0x0227,
          "Font Name", "FontName",  "LO", "1" },
        { 0x0070, 0x0228,
          "Font Name Type", "FontNameType",  "CS", "1" },
        { 0x0070, 0x0229,
          "CSS Font Name", "CSSFontName",  "LO", "1" },
        { 0x0070, 0x0230,
          "Rotation Angle", "RotationAngle",  "FD", "1" },
        { 0x0070, 0x0231,
          "Text Style Sequence", "TextStyleSequence",  "SQ", "1" },
        { 0x0070, 0x0232,
          "Line Style Sequence", "LineStyleSequence",  "SQ", "1" },
        { 0x0070, 0x0233,
          "Fill Style Sequence", "FillStyleSequence",  "SQ", "1" },
        { 0x0070, 0x0234,
          "Graphic Group Sequence", "GraphicGroupSequence",  "SQ", "1" },
        { 0x0070, 0x0241,
          "Text Color CIELab Value", "TextColorCIELabValue",  "US", "3" },
        { 0x0070, 0x0242,
          "Horizontal Alignment", "HorizontalAlignment",  "CS", "1" },
        { 0x0070, 0x0243,
          "Vertical Alignment", "VerticalAlignment",  "CS", "1" },
        { 0x0070, 0x0244,
          "Shadow Style", "ShadowStyle",  "CS", "1" },
        { 0x0070, 0x0245,
          "Shadow Offset X", "ShadowOffsetX",  "FL", "1" },
        { 0x0070, 0x0246,
          "Shadow Offset Y", "ShadowOffsetY",  "FL", "1" },
        { 0x0070, 0x0247,
          "Shadow Color CIELab Value", "ShadowColorCIELabValue",  "US", "3" },
        { 0x0070, 0x0248,
          "Underlined", "Underlined",  "CS", "1" },
        { 0x0070, 0x0249,
          "Bold", "Bold",  "CS", "1" },
        { 0x0070, 0x0250,
          "Italic", "Italic",  "CS", "1" },
        { 0x0070, 0x0251,
          "Pattern On Color CIELab Value", "PatternOnColorCIELabValue",  "US", "3" },
        { 0x0070, 0x0252,
          "Pattern Off Color CIELab Value", "PatternOffColorCIELabValue",  "US", "3" },
        { 0x0070, 0x0253,
          "Line Thickness", "LineThickness",  "FL", "1" },
        { 0x0070, 0x0254,
          "Line Dashing Style", "LineDashingStyle",  "CS", "1" },
        { 0x0070, 0x0255,
          "Line Pattern", "LinePattern",  "UL", "1" },
        { 0x0070, 0x0256,
          "Fill Pattern", "FillPattern",  "OB", "1" },
        { 0x0070, 0x0257,
          "Fill Mode", "FillMode",  "CS", "1" },
        { 0x0070, 0x0258,
          "Shadow Opacity", "ShadowOpacity",  "FL", "1" },
        { 0x0070, 0x0261,
          "Gap Length", "GapLength",  "FL", "1" },
        { 0x0070, 0x0262,
          "Diameter of Visibility", "DiameterOfVisibility",  "FL", "1" },
        { 0x0070, 0x0273,
          "Rotation Point", "RotationPoint",  "FL", "2" },
        { 0x0070, 0x0274,
          "Tick Alignment", "TickAlignment",  "CS", "1" },
        { 0x0070, 0x0278,
          "Show Tick Label", "ShowTickLabel",  "CS", "1" },
        { 0x0070, 0x0279,
          "Tick Label Alignment", "TickLabelAlignment",  "CS", "1" },
        { 0x0070, 0x0282,
          "Compound Graphic Units", "CompoundGraphicUnits",  "CS", "1" },
        { 0x0070, 0x0284,
          "Pattern On Opacity", "PatternOnOpacity",  "FL", "1" },
        { 0x0070, 0x0285,
          "Pattern Off Opacity", "PatternOffOpacity",  "FL", "1" },
        { 0x0070, 0x0287,
          "Major Ticks Sequence", "MajorTicksSequence",  "SQ", "1" },
        { 0x0070, 0x0288,
          "Tick Position", "TickPosition",  "FL", "1" },
        { 0x0070, 0x0289,
          "Tick Label", "TickLabel",  "SH", "1" },
        { 0x0070, 0x0294,
          "Compound Graphic Type", "CompoundGraphicType",  "CS", "1" },
        { 0x0070, 0x0295,
          "Graphic Group ID", "GraphicGroupID",  "UL", "1" },
        { 0x0070, 0x0306,
          "Shape Type", "ShapeType",  "CS", "1" },
        { 0x0070, 0x0308,
          "Registration Sequence", "RegistrationSequence",  "SQ", "1" },
        { 0x0070, 0x0309,
          "Matrix Registration Sequence", "MatrixRegistrationSequence",  "SQ", "1" },
        { 0x0070, 0x030a,
          "Matrix Sequence", "MatrixSequence",  "SQ", "1" },
        { 0x0070, 0x030c,
          "Frame of Reference Transformation Matrix Type", "FrameOfReferenceTransformationMatrixType",  "CS", "1" },
        { 0x0070, 0x030d,
          "Registration Type Code Sequence", "RegistrationTypeCodeSequence",  "SQ", "1" },
        { 0x0070, 0x030f,
          "Fiducial Description", "FiducialDescription",  "ST", "1" },
        { 0x0070, 0x0310,
          "Fiducial Identifier", "FiducialIdentifier",  "SH", "1" },
        { 0x0070, 0x0311,
          "Fiducial Identifier Code Sequence", "FiducialIdentifierCodeSequence",  "SQ", "1" },
        { 0x0070, 0x0312,
          "Contour Uncertainty Radius", "ContourUncertaintyRadius",  "FD", "1" },
        { 0x0070, 0x0314,
          "Used Fiducials Sequence", "UsedFiducialsSequence",  "SQ", "1" },
        { 0x0070, 0x0318,
          "Graphic Coordinates Data Sequence", "GraphicCoordinatesDataSequence",  "SQ", "1" },
        { 0x0070, 0x031a,
          "Fiducial UID", "FiducialUID",  "UI", "1" },
        { 0x0070, 0x031c,
          "Fiducial Set Sequence", "FiducialSetSequence",  "SQ", "1" },
        { 0x0070, 0x031e,
          "Fiducial Sequence", "FiducialSequence",  "SQ", "1" },
        { 0x0070, 0x0401,
          "Graphic Layer Recommended Display CIELab Value", "GraphicLayerRecommendedDisplayCIELabValue",  "US", "3" },
        { 0x0070, 0x0402,
          "Blending Sequence", "BlendingSequence",  "SQ", "1" },
        { 0x0070, 0x0403,
          "Relative Opacity", "RelativeOpacity",  "FL", "1" },
        { 0x0070, 0x0404,
          "Referenced Spatial Registration Sequence", "ReferencedSpatialRegistrationSequence",  "SQ", "1" },
        { 0x0070, 0x0405,
          "Blending Position", "BlendingPosition",  "CS", "1" },
        { 0x0072, 0x0002,
          "Hanging Protocol Name", "HangingProtocolName",  "SH", "1" },
        { 0x0072, 0x0004,
          "Hanging Protocol Description", "HangingProtocolDescription",  "LO", "1" },
        { 0x0072, 0x0006,
          "Hanging Protocol Level", "HangingProtocolLevel",  "CS", "1" },
        { 0x0072, 0x0008,
          "Hanging Protocol Creator", "HangingProtocolCreator",  "LO", "1" },
        { 0x0072, 0x000a,
          "Hanging Protocol Creation DateTime", "HangingProtocolCreationDateTime",  "DT", "1" },
        { 0x0072, 0x000c,
          "Hanging Protocol Definition Sequence", "HangingProtocolDefinitionSequence",  "SQ", "1" },
        { 0x0072, 0x000e,
          "Hanging Protocol User Identification Code Sequence", "HangingProtocolUserIdentificationCodeSequence",  "SQ", "1" },
        { 0x0072, 0x0010,
          "Hanging Protocol User Group Name", "HangingProtocolUserGroupName",  "LO", "1" },
        { 0x0072, 0x0012,
          "Source Hanging Protocol Sequence", "SourceHangingProtocolSequence",  "SQ", "1" },
        { 0x0072, 0x0014,
          "Number of Priors Referenced", "NumberOfPriorsReferenced",  "US", "1" },
        { 0x0072, 0x0020,
          "Image Sets Sequence", "ImageSetsSequence",  "SQ", "1" },
        { 0x0072, 0x0022,
          "Image Set Selector Sequence", "ImageSetSelectorSequence",  "SQ", "1" },
        { 0x0072, 0x0024,
          "Image Set Selector Usage Flag", "ImageSetSelectorUsageFlag",  "CS", "1" },
        { 0x0072, 0x0026,
          "Selector Attribute", "SelectorAttribute",  "AT", "1" },
        { 0x0072, 0x0028,
          "Selector Value Number", "SelectorValueNumber",  "US", "1" },
        { 0x0072, 0x0030,
          "Time Based Image Sets Sequence", "TimeBasedImageSetsSequence",  "SQ", "1" },
        { 0x0072, 0x0032,
          "Image Set Number", "ImageSetNumber",  "US", "1" },
        { 0x0072, 0x0034,
          "Image Set Selector Category", "ImageSetSelectorCategory",  "CS", "1" },
        { 0x0072, 0x0038,
          "Relative Time", "RelativeTime",  "US", "2" },
        { 0x0072, 0x003a,
          "Relative Time Units", "RelativeTimeUnits",  "CS", "1" },
        { 0x0072, 0x003c,
          "Abstract Prior Value", "AbstractPriorValue",  "SS", "2" },
        { 0x0072, 0x003e,
          "Abstract Prior Code Sequence", "AbstractPriorCodeSequence",  "SQ", "1" },
        { 0x0072, 0x0040,
          "Image Set Label", "ImageSetLabel",  "LO", "1" },
        { 0x0072, 0x0050,
          "Selector Attribute VR", "SelectorAttributeVR",  "CS", "1" },
        { 0x0072, 0x0052,
          "Selector Sequence Pointer", "SelectorSequencePointer",  "AT", "1-n" },
        { 0x0072, 0x0054,
          "Selector Sequence Pointer Private Creator", "SelectorSequencePointerPrivateCreator",  "LO", "1-n" },
        { 0x0072, 0x0056,
          "Selector Attribute Private Creator", "SelectorAttributePrivateCreator",  "LO", "1" },
        { 0x0072, 0x0060,
          "Selector AT Value", "SelectorATValue",  "AT", "1-n" },
        { 0x0072, 0x0062,
          "Selector CS Value", "SelectorCSValue",  "CS", "1-n" },
        { 0x0072, 0x0064,
          "Selector IS Value", "SelectorISValue",  "IS", "1-n" },
        { 0x0072, 0x0066,
          "Selector LO Value", "SelectorLOValue",  "LO", "1-n" },
        { 0x0072, 0x0068,
          "Selector LT Value", "SelectorLTValue",  "LT", "1" },
        { 0x0072, 0x006a,
          "Selector PN Value", "SelectorPNValue",  "PN", "1-n" },
        { 0x0072, 0x006c,
          "Selector SH Value", "SelectorSHValue",  "SH", "1-n" },
        { 0x0072, 0x006e,
          "Selector ST Value", "SelectorSTValue",  "ST", "1" },
        { 0x0072, 0x0070,
          "Selector UT Value", "SelectorUTValue",  "UT", "1" },
        { 0x0072, 0x0072,
          "Selector DS Value", "SelectorDSValue",  "DS", "1-n" },
        { 0x0072, 0x0074,
          "Selector FD Value", "SelectorFDValue",  "FD", "1-n" },
        { 0x0072, 0x0076,
          "Selector FL Value", "SelectorFLValue",  "FL", "1-n" },
        { 0x0072, 0x0078,
          "Selector UL Value", "SelectorULValue",  "UL", "1-n" },
        { 0x0072, 0x007a,
          "Selector US Value", "SelectorUSValue",  "US", "1-n" },
        { 0x0072, 0x007c,
          "Selector SL Value", "SelectorSLValue",  "SL", "1-n" },
        { 0x0072, 0x007e,
          "Selector SS Value", "SelectorSSValue",  "SS", "1-n" },
        { 0x0072, 0x007f,
          "Selector UI Value", "SelectorUIValue",  "UI", "1-n" },
        { 0x0072, 0x0080,
          "Selector Code Sequence Value", "SelectorCodeSequenceValue",  "SQ", "1" },
        { 0x0072, 0x0100,
          "Number of Screens", "NumberOfScreens",  "US", "1" },
        { 0x0072, 0x0102,
          "Nominal Screen Definition Sequence", "NominalScreenDefinitionSequence",  "SQ", "1" },
        { 0x0072, 0x0104,
          "Number of Vertical Pixels", "NumberOfVerticalPixels",  "US", "1" },
        { 0x0072, 0x0106,
          "Number of Horizontal Pixels", "NumberOfHorizontalPixels",  "US", "1" },
        { 0x0072, 0x0108,
          "Display Environment Spatial Position", "DisplayEnvironmentSpatialPosition",  "FD", "4" },
        { 0x0072, 0x010a,
          "Screen Minimum Grayscale Bit Depth", "ScreenMinimumGrayscaleBitDepth",  "US", "1" },
        { 0x0072, 0x010c,
          "Screen Minimum Color Bit Depth", "ScreenMinimumColorBitDepth",  "US", "1" },
        { 0x0072, 0x010e,
          "Application Maximum Repaint Time", "ApplicationMaximumRepaintTime",  "US", "1" },
        { 0x0072, 0x0200,
          "Display Sets Sequence", "DisplaySetsSequence",  "SQ", "1" },
        { 0x0072, 0x0202,
          "Display Set Number", "DisplaySetNumber",  "US", "1" },
        { 0x0072, 0x0203,
          "Display Set Label", "DisplaySetLabel",  "LO", "1" },
        { 0x0072, 0x0204,
          "Display Set Presentation Group", "DisplaySetPresentationGroup",  "US", "1" },
        { 0x0072, 0x0206,
          "Display Set Presentation Group Description", "DisplaySetPresentationGroupDescription",  "LO", "1" },
        { 0x0072, 0x0208,
          "Partial Data Display Handling", "PartialDataDisplayHandling",  "CS", "1" },
        { 0x0072, 0x0210,
          "Synchronized Scrolling Sequence", "SynchronizedScrollingSequence",  "SQ", "1" },
        { 0x0072, 0x0212,
          "Display Set Scrolling Group", "DisplaySetScrollingGroup",  "US", "2-n" },
        { 0x0072, 0x0214,
          "Navigation Indicator Sequence", "NavigationIndicatorSequence",  "SQ", "1" },
        { 0x0072, 0x0216,
          "Navigation Display Set", "NavigationDisplaySet",  "US", "1" },
        { 0x0072, 0x0218,
          "Reference Display Sets", "ReferenceDisplaySets",  "US", "1-n" },
        { 0x0072, 0x0300,
          "Image Boxes Sequence", "ImageBoxesSequence",  "SQ", "1" },
        { 0x0072, 0x0302,
          "Image Box Number", "ImageBoxNumber",  "US", "1" },
        { 0x0072, 0x0304,
          "Image Box Layout Type", "ImageBoxLayoutType",  "CS", "1" },
        { 0x0072, 0x0306,
          "Image Box Tile Horizontal Dimension", "ImageBoxTileHorizontalDimension",  "US", "1" },
        { 0x0072, 0x0308,
          "Image Box Tile Vertical Dimension", "ImageBoxTileVerticalDimension",  "US", "1" },
        { 0x0072, 0x0310,
          "Image Box Scroll Direction", "ImageBoxScrollDirection",  "CS", "1" },
        { 0x0072, 0x0312,
          "Image Box Small Scroll Type", "ImageBoxSmallScrollType",  "CS", "1" },
        { 0x0072, 0x0314,
          "Image Box Small Scroll Amount", "ImageBoxSmallScrollAmount",  "US", "1" },
        { 0x0072, 0x0316,
          "Image Box Large Scroll Type", "ImageBoxLargeScrollType",  "CS", "1" },
        { 0x0072, 0x0318,
          "Image Box Large Scroll Amount", "ImageBoxLargeScrollAmount",  "US", "1" },
        { 0x0072, 0x0320,
          "Image Box Overlap Priority", "ImageBoxOverlapPriority",  "US", "1" },
        { 0x0072, 0x0330,
          "Cine Relative to Real-Time", "CineRelativeToRealTime",  "FD", "1" },
        { 0x0072, 0x0400,
          "Filter Operations Sequence", "FilterOperationsSequence",  "SQ", "1" },
        { 0x0072, 0x0402,
          "Filter-by Category", "FilterByCategory",  "CS", "1" },
        { 0x0072, 0x0404,
          "Filter-by Attribute Presence", "FilterByAttributePresence",  "CS", "1" },
        { 0x0072, 0x0406,
          "Filter-by Operator", "FilterByOperator",  "CS", "1" },
        { 0x0072, 0x0420,
          "Structured Display Background CIELab Value", "StructuredDisplayBackgroundCIELabValue",  "US", "3" },
        { 0x0072, 0x0421,
          "Empty Image Box CIELab Value", "EmptyImageBoxCIELabValue",  "US", "3" },
        { 0x0072, 0x0422,
          "Structured Display Image Box Sequence", "StructuredDisplayImageBoxSequence",  "SQ", "1" },
        { 0x0072, 0x0424,
          "Structured Display Text Box Sequence", "StructuredDisplayTextBoxSequence",  "SQ", "1" },
        { 0x0072, 0x0427,
          "Referenced First Frame Sequence", "ReferencedFirstFrameSequence",  "SQ", "1" },
        { 0x0072, 0x0430,
          "Image Box Synchronization Sequence", "ImageBoxSynchronizationSequence",  "SQ", "1" },
        { 0x0072, 0x0432,
          "Synchronized Image Box List", "SynchronizedImageBoxList",  "US", "2-n" },
        { 0x0072, 0x0434,
          "Type of Synchronization", "TypeOfSynchronization",  "CS", "1" },
        { 0x0072, 0x0500,
          "Blending Operation Type", "BlendingOperationType",  "CS", "1" },
        { 0x0072, 0x0510,
          "Reformatting Operation Type", "ReformattingOperationType",  "CS", "1" },
        { 0x0072, 0x0512,
          "Reformatting Thickness", "ReformattingThickness",  "FD", "1" },
        { 0x0072, 0x0514,
          "Reformatting Interval", "ReformattingInterval",  "FD", "1" },
        { 0x0072, 0x0516,
          "Reformatting Operation Initial View Direction", "ReformattingOperationInitialViewDirection",  "CS", "1" },
        { 0x0072, 0x0520,
          "3D Rendering Type", "ThreeDRenderingType",  "CS", "1-n" },
        { 0x0072, 0x0600,
          "Sorting Operations Sequence", "SortingOperationsSequence",  "SQ", "1" },
        { 0x0072, 0x0602,
          "Sort-by Category", "SortByCategory",  "CS", "1" },
        { 0x0072, 0x0604,
          "Sorting Direction", "SortingDirection",  "CS", "1" },
        { 0x0072, 0x0700,
          "Display Set Patient Orientation", "DisplaySetPatientOrientation",  "CS", "2" },
        { 0x0072, 0x0702,
          "VOI Type", "VOIType",  "CS", "1" },
        { 0x0072, 0x0704,
          "Pseudo-Color Type", "PseudoColorType",  "CS", "1" },
        { 0x0072, 0x0705,
          "Pseudo-Color Palette Instance Reference Sequence", "PseudoColorPaletteInstanceReferenceSequence",  "SQ", "1" },
        { 0x0072, 0x0706,
          "Show Grayscale Inverted", "ShowGrayscaleInverted",  "CS", "1" },
        { 0x0072, 0x0710,
          "Show Image True Size Flag", "ShowImageTrueSizeFlag",  "CS", "1" },
        { 0x0072, 0x0712,
          "Show Graphic Annotation Flag", "ShowGraphicAnnotationFlag",  "CS", "1" },
        { 0x0072, 0x0714,
          "Show Patient Demographics Flag", "ShowPatientDemographicsFlag",  "CS", "1" },
        { 0x0072, 0x0716,
          "Show Acquisition Techniques Flag", "ShowAcquisitionTechniquesFlag",  "CS", "1" },
        { 0x0072, 0x0717,
          "Display Set Horizontal Justification", "DisplaySetHorizontalJustification",  "CS", "1" },
        { 0x0072, 0x0718,
          "Display Set Vertical Justification", "DisplaySetVerticalJustification",  "CS", "1" },
        { 0x0074, 0x0120,
          "Continuation Start Meterset", "ContinuationStartMeterset",  "FD", "1" },
        { 0x0074, 0x0121,
          "Continuation End Meterset", "ContinuationEndMeterset",  "FD", "1" },
        { 0x0074, 0x1000,
          "Procedure Step State", "ProcedureStepState",  "CS", "1" },
        { 0x0074, 0x1002,
          "Procedure Step Progress Information Sequence", "ProcedureStepProgressInformationSequence",  "SQ", "1" },
        { 0x0074, 0x1004,
          "Procedure Step Progress", "ProcedureStepProgress",  "DS", "1" },
        { 0x0074, 0x1006,
          "Procedure Step Progress Description", "ProcedureStepProgressDescription",  "ST", "1" },
        { 0x0074, 0x1008,
          "Procedure Step Communications URI Sequence", "ProcedureStepCommunicationsURISequence",  "SQ", "1" },
        { 0x0074, 0x100a,
          "Contact URI", "ContactURI",  "UR", "1" },
        { 0x0074, 0x100c,
          "Contact Display Name", "ContactDisplayName",  "LO", "1" },
        { 0x0074, 0x100e,
          "Procedure Step Discontinuation Reason Code Sequence", "ProcedureStepDiscontinuationReasonCodeSequence",  "SQ", "1" },
        { 0x0074, 0x1020,
          "Beam Task Sequence", "BeamTaskSequence",  "SQ", "1" },
        { 0x0074, 0x1022,
          "Beam Task Type", "BeamTaskType",  "CS", "1" },
        { 0x0074, 0x1024,
          "Beam Order Index (Trial)", "BeamOrderIndexTrial",  "IS", "1" },
        { 0x0074, 0x1025,
          "Autosequence Flag", "AutosequenceFlag",  "CS", "1" },
        { 0x0074, 0x1026,
          "Table Top Vertical Adjusted Position", "TableTopVerticalAdjustedPosition",  "FD", "1" },
        { 0x0074, 0x1027,
          "Table Top Longitudinal Adjusted Position", "TableTopLongitudinalAdjustedPosition",  "FD", "1" },
        { 0x0074, 0x1028,
          "Table Top Lateral Adjusted Position", "TableTopLateralAdjustedPosition",  "FD", "1" },
        { 0x0074, 0x102a,
          "Patient Support Adjusted Angle", "PatientSupportAdjustedAngle",  "FD", "1" },
        { 0x0074, 0x102b,
          "Table Top Eccentric Adjusted Angle", "TableTopEccentricAdjustedAngle",  "FD", "1" },
        { 0x0074, 0x102c,
          "Table Top Pitch Adjusted Angle", "TableTopPitchAdjustedAngle",  "FD", "1" },
        { 0x0074, 0x102d,
          "Table Top Roll Adjusted Angle", "TableTopRollAdjustedAngle",  "FD", "1" },
        { 0x0074, 0x1030,
          "Delivery Verification Image Sequence", "DeliveryVerificationImageSequence",  "SQ", "1" },
        { 0x0074, 0x1032,
          "Verification Image Timing", "VerificationImageTiming",  "CS", "1" },
        { 0x0074, 0x1034,
          "Double Exposure Flag", "DoubleExposureFlag",  "CS", "1" },
        { 0x0074, 0x1036,
          "Double Exposure Ordering", "DoubleExposureOrdering",  "CS", "1" },
        { 0x0074, 0x1038,
          "Double Exposure Meterset (Trial)", "DoubleExposureMetersetTrial",  "DS", "1" },
        { 0x0074, 0x103a,
          "Double Exposure Field Delta (Trial)", "DoubleExposureFieldDeltaTrial",  "DS", "4" },
        { 0x0074, 0x1040,
          "Related Reference RT Image Sequence", "RelatedReferenceRTImageSequence",  "SQ", "1" },
        { 0x0074, 0x1042,
          "General Machine Verification Sequence", "GeneralMachineVerificationSequence",  "SQ", "1" },
        { 0x0074, 0x1044,
          "Conventional Machine Verification Sequence", "ConventionalMachineVerificationSequence",  "SQ", "1" },
        { 0x0074, 0x1046,
          "Ion Machine Verification Sequence", "IonMachineVerificationSequence",  "SQ", "1" },
        { 0x0074, 0x1048,
          "Failed Attributes Sequence", "FailedAttributesSequence",  "SQ", "1" },
        { 0x0074, 0x104a,
          "Overridden Attributes Sequence", "OverriddenAttributesSequence",  "SQ", "1" },
        { 0x0074, 0x104c,
          "Conventional Control Point Verification Sequence", "ConventionalControlPointVerificationSequence",  "SQ", "1" },
        { 0x0074, 0x104e,
          "Ion Control Point Verification Sequence", "IonControlPointVerificationSequence",  "SQ", "1" },
        { 0x0074, 0x1050,
          "Attribute Occurrence Sequence", "AttributeOccurrenceSequence",  "SQ", "1" },
        { 0x0074, 0x1052,
          "Attribute Occurrence Pointer", "AttributeOccurrencePointer",  "AT", "1" },
        { 0x0074, 0x1054,
          "Attribute Item Selector", "AttributeItemSelector",  "UL", "1" },
        { 0x0074, 0x1056,
          "Attribute Occurrence Private Creator", "AttributeOccurrencePrivateCreator",  "LO", "1" },
        { 0x0074, 0x1057,
          "Selector Sequence Pointer Items", "SelectorSequencePointerItems",  "IS", "1-n" },
        { 0x0074, 0x1200,
          "Scheduled Procedure Step Priority", "ScheduledProcedureStepPriority",  "CS", "1" },
        { 0x0074, 0x1202,
          "Worklist Label", "WorklistLabel",  "LO", "1" },
        { 0x0074, 0x1204,
          "Procedure Step Label", "ProcedureStepLabel",  "LO", "1" },
        { 0x0074, 0x1210,
          "Scheduled Processing Parameters Sequence", "ScheduledProcessingParametersSequence",  "SQ", "1" },
        { 0x0074, 0x1212,
          "Performed Processing Parameters Sequence", "PerformedProcessingParametersSequence",  "SQ", "1" },
        { 0x0074, 0x1216,
          "Unified Procedure Step Performed Procedure Sequence", "UnifiedProcedureStepPerformedProcedureSequence",  "SQ", "1" },
        { 0x0074, 0x1220,
          "Related Procedure Step Sequence", "RelatedProcedureStepSequence",  "SQ", "1" },
        { 0x0074, 0x1222,
          "Procedure Step Relationship Type", "ProcedureStepRelationshipType",  "LO", "1" },
        { 0x0074, 0x1224,
          "Replaced Procedure Step Sequence", "ReplacedProcedureStepSequence",  "SQ", "1" },
        { 0x0074, 0x1230,
          "Deletion Lock", "DeletionLock",  "LO", "1" },
        { 0x0074, 0x1234,
          "Receiving AE", "ReceivingAE",  "AE", "1" },
        { 0x0074, 0x1236,
          "Requesting AE", "RequestingAE",  "AE", "1" },
        { 0x0074, 0x1238,
          "Reason for Cancellation", "ReasonForCancellation",  "LT", "1" },
        { 0x0074, 0x1242,
          "SCP Status", "SCPStatus",  "CS", "1" },
        { 0x0074, 0x1244,
          "Subscription List Status", "SubscriptionListStatus",  "CS", "1" },
        { 0x0074, 0x1246,
          "Unified Procedure Step List Status", "UnifiedProcedureStepListStatus",  "CS", "1" },
        { 0x0074, 0x1324,
          "Beam Order Index", "BeamOrderIndex",  "UL", "1" },
        { 0x0074, 0x1338,
          "Double Exposure Meterset", "DoubleExposureMeterset",  "FD", "1" },
        { 0x0074, 0x133a,
          "Double Exposure Field Delta", "DoubleExposureFieldDelta",  "FD", "4" },
        { 0x0076, 0x0001,
          "Implant Assembly Template Name", "ImplantAssemblyTemplateName",  "LO", "1" },
        { 0x0076, 0x0003,
          "Implant Assembly Template Issuer", "ImplantAssemblyTemplateIssuer",  "LO", "1" },
        { 0x0076, 0x0006,
          "Implant Assembly Template Version", "ImplantAssemblyTemplateVersion",  "LO", "1" },
        { 0x0076, 0x0008,
          "Replaced Implant Assembly Template Sequence", "ReplacedImplantAssemblyTemplateSequence",  "SQ", "1" },
        { 0x0076, 0x000a,
          "Implant Assembly Template Type", "ImplantAssemblyTemplateType",  "CS", "1" },
        { 0x0076, 0x000c,
          "Original Implant Assembly Template Sequence", "OriginalImplantAssemblyTemplateSequence",  "SQ", "1" },
        { 0x0076, 0x000e,
          "Derivation Implant Assembly Template Sequence", "DerivationImplantAssemblyTemplateSequence",  "SQ", "1" },
        { 0x0076, 0x0010,
          "Implant Assembly Template Target Anatomy Sequence", "ImplantAssemblyTemplateTargetAnatomySequence",  "SQ", "1" },
        { 0x0076, 0x0020,
          "Procedure Type Code Sequence", "ProcedureTypeCodeSequence",  "SQ", "1" },
        { 0x0076, 0x0030,
          "Surgical Technique", "SurgicalTechnique",  "LO", "1" },
        { 0x0076, 0x0032,
          "Component Types Sequence", "ComponentTypesSequence",  "SQ", "1" },
        { 0x0076, 0x0034,
          "Component Type Code Sequence", "ComponentTypeCodeSequence",  "CS", "1" },
        { 0x0076, 0x0036,
          "Exclusive Component Type", "ExclusiveComponentType",  "CS", "1" },
        { 0x0076, 0x0038,
          "Mandatory Component Type", "MandatoryComponentType",  "CS", "1" },
        { 0x0076, 0x0040,
          "Component Sequence", "ComponentSequence",  "SQ", "1" },
        { 0x0076, 0x0055,
          "Component ID", "ComponentID",  "US", "1" },
        { 0x0076, 0x0060,
          "Component Assembly Sequence", "ComponentAssemblySequence",  "SQ", "1" },
        { 0x0076, 0x0070,
          "Component 1 Referenced ID", "Component1ReferencedID",  "US", "1" },
        { 0x0076, 0x0080,
          "Component 1 Referenced Mating Feature Set ID", "Component1ReferencedMatingFeatureSetID",  "US", "1" },
        { 0x0076, 0x0090,
          "Component 1 Referenced Mating Feature ID", "Component1ReferencedMatingFeatureID",  "US", "1" },
        { 0x0076, 0x00a0,
          "Component 2 Referenced ID", "Component2ReferencedID",  "US", "1" },
        { 0x0076, 0x00b0,
          "Component 2 Referenced Mating Feature Set ID", "Component2ReferencedMatingFeatureSetID",  "US", "1" },
        { 0x0076, 0x00c0,
          "Component 2 Referenced Mating Feature ID", "Component2ReferencedMatingFeatureID",  "US", "1" },
        { 0x0078, 0x0001,
          "Implant Template Group Name", "ImplantTemplateGroupName",  "LO", "1" },
        { 0x0078, 0x0010,
          "Implant Template Group Description", "ImplantTemplateGroupDescription",  "ST", "1" },
        { 0x0078, 0x0020,
          "Implant Template Group Issuer", "ImplantTemplateGroupIssuer",  "LO", "1" },
        { 0x0078, 0x0024,
          "Implant Template Group Version", "ImplantTemplateGroupVersion",  "LO", "1" },
        { 0x0078, 0x0026,
          "Replaced Implant Template Group Sequence", "ReplacedImplantTemplateGroupSequence",  "SQ", "1" },
        { 0x0078, 0x0028,
          "Implant Template Group Target Anatomy Sequence", "ImplantTemplateGroupTargetAnatomySequence",  "SQ", "1" },
        { 0x0078, 0x002a,
          "Implant Template Group Members Sequence", "ImplantTemplateGroupMembersSequence",  "SQ", "1" },
        { 0x0078, 0x002e,
          "Implant Template Group Member ID", "ImplantTemplateGroupMemberID",  "US", "1" },
        { 0x0078, 0x0050,
          "3D Implant Template Group Member Matching Point", "ThreeDImplantTemplateGroupMemberMatchingPoint",  "FD", "3" },
        { 0x0078, 0x0060,
          "3D Implant Template Group Member Matching Axes", "ThreeDImplantTemplateGroupMemberMatchingAxes",  "FD", "9" },
        { 0x0078, 0x0070,
          "Implant Template Group Member Matching 2D Coordinates Sequence", "ImplantTemplateGroupMemberMatching2DCoordinatesSequence",  "SQ", "1" },
        { 0x0078, 0x0090,
          "2D Implant Template Group Member Matching Point", "TwoDImplantTemplateGroupMemberMatchingPoint",  "FD", "2" },
        { 0x0078, 0x00a0,
          "2D Implant Template Group Member Matching Axes", "TwoDImplantTemplateGroupMemberMatchingAxes",  "FD", "4" },
        { 0x0078, 0x00b0,
          "Implant Template Group Variation Dimension Sequence", "ImplantTemplateGroupVariationDimensionSequence",  "SQ", "1" },
        { 0x0078, 0x00b2,
          "Implant Template Group Variation Dimension Name", "ImplantTemplateGroupVariationDimensionName",  "LO", "1" },
        { 0x0078, 0x00b4,
          "Implant Template Group Variation Dimension Rank Sequence", "ImplantTemplateGroupVariationDimensionRankSequence",  "SQ", "1" },
        { 0x0078, 0x00b6,
          "Referenced Implant Template Group Member ID", "ReferencedImplantTemplateGroupMemberID",  "US", "1" },
        { 0x0078, 0x00b8,
          "Implant Template Group Variation Dimension Rank", "ImplantTemplateGroupVariationDimensionRank",  "US", "1" },
        { 0x0080, 0x0001,
          "Surface Scan Acquisition Type Code Sequence", "SurfaceScanAcquisitionTypeCodeSequence",  "SQ", "1" },
        { 0x0080, 0x0002,
          "Surface Scan Mode Code Sequence", "SurfaceScanModeCodeSequence",  "SQ", "1" },
        { 0x0080, 0x0003,
          "Registration Method Code Sequence", "RegistrationMethodCodeSequence",  "SQ", "1" },
        { 0x0080, 0x0004,
          "Shot Duration Time", "ShotDurationTime",  "FD", "1" },
        { 0x0080, 0x0005,
          "Shot Offset Time", "ShotOffsetTime",  "FD", "1" },
        { 0x0080, 0x0006,
          "Surface Point Presentation Value Data", "SurfacePointPresentationValueData",  "US", "1-n" },
        { 0x0080, 0x0007,
          "Surface Point Color CIELab Value Data", "SurfacePointColorCIELabValueData",  "US", "3-3n" },
        { 0x0080, 0x0008,
          "UV Mapping Sequence", "UVMappingSequence",  "SQ", "1" },
        { 0x0080, 0x0009,
          "Texture Label", "TextureLabel",  "SH", "1" },
        { 0x0080, 0x0010,
          "U Value Data", "UValueData",  "OF", "1-n" },
        { 0x0080, 0x0011,
          "V Value Data", "VValueData",  "OF", "1-n" },
        { 0x0080, 0x0012,
          "Referenced Texture Sequence", "ReferencedTextureSequence",  "SQ", "1" },
        { 0x0080, 0x0013,
          "Referenced Surface Data Sequence", "ReferencedSurfaceDataSequence",  "SQ", "1" },
        { 0x0088, 0x0130,
          "Storage Media File-set ID", "StorageMediaFileSetID",  "SH", "1" },
        { 0x0088, 0x0140,
          "Storage Media File-set UID", "StorageMediaFileSetUID",  "UI", "1" },
        { 0x0088, 0x0200,
          "Icon Image Sequence", "IconImageSequence",  "SQ", "1" },
        { 0x0088, 0x0904,
          "Topic Title", "TopicTitle",  "LO", "1" },
        { 0x0088, 0x0906,
          "Topic Subject", "TopicSubject",  "ST", "1" },
        { 0x0088, 0x0910,
          "Topic Author", "TopicAuthor",  "LO", "1" },
        { 0x0088, 0x0912,
          "Topic Keywords", "TopicKeywords",  "LO", "1-32" },
        { 0x0100, 0x0410,
          "SOP Instance Status", "SOPInstanceStatus",  "CS", "1" },
        { 0x0100, 0x0420,
          "SOP Authorization DateTime", "SOPAuthorizationDateTime",  "DT", "1" },
        { 0x0100, 0x0424,
          "SOP Authorization Comment", "SOPAuthorizationComment",  "LT", "1" },
        { 0x0100, 0x0426,
          "Authorization Equipment Certification Number", "AuthorizationEquipmentCertificationNumber",  "LO", "1" },
        { 0x0400, 0x0005,
          "MAC ID Number", "MACIDNumber",  "US", "1" },
        { 0x0400, 0x0010,
          "MAC Calculation Transfer Syntax UID", "MACCalculationTransferSyntaxUID",  "UI", "1" },
        { 0x0400, 0x0015,
          "MAC Algorithm", "MACAlgorithm",  "CS", "1" },
        { 0x0400, 0x0020,
          "Data Elements Signed", "DataElementsSigned",  "AT", "1-n" },
        { 0x0400, 0x0100,
          "Digital Signature UID", "DigitalSignatureUID",  "UI", "1" },
        { 0x0400, 0x0105,
          "Digital Signature DateTime", "DigitalSignatureDateTime",  "DT", "1" },
        { 0x0400, 0x0110,
          "Certificate Type", "CertificateType",  "CS", "1" },
        { 0x0400, 0x0115,
          "Certificate of Signer", "CertificateOfSigner",  "OB", "1" },
        { 0x0400, 0x0120,
          "Signature", "Signature",  "OB", "1" },
        { 0x0400, 0x0305,
          "Certified Timestamp Type", "CertifiedTimestampType",  "CS", "1" },
        { 0x0400, 0x0310,
          "Certified Timestamp", "CertifiedTimestamp",  "OB", "1" },
        { 0x0400, 0x0401,
          "Digital Signature Purpose Code Sequence", "DigitalSignaturePurposeCodeSequence",  "SQ", "1" },
        { 0x0400, 0x0402,
          "Referenced Digital Signature Sequence", "ReferencedDigitalSignatureSequence",  "SQ", "1" },
        { 0x0400, 0x0403,
          "Referenced SOP Instance MAC Sequence", "ReferencedSOPInstanceMACSequence",  "SQ", "1" },
        { 0x0400, 0x0404,
          "MAC", "MAC",  "OB", "1" },
        { 0x0400, 0x0500,
          "Encrypted Attributes Sequence", "EncryptedAttributesSequence",  "SQ", "1" },
        { 0x0400, 0x0510,
          "Encrypted Content Transfer Syntax UID", "EncryptedContentTransferSyntaxUID",  "UI", "1" },
        { 0x0400, 0x0520,
          "Encrypted Content", "EncryptedContent",  "OB", "1" },
        { 0x0400, 0x0550,
          "Modified Attributes Sequence", "ModifiedAttributesSequence",  "SQ", "1" },
        { 0x0400, 0x0561,
          "Original Attributes Sequence", "OriginalAttributesSequence",  "SQ", "1" },
        { 0x0400, 0x0562,
          "Attribute Modification DateTime", "AttributeModificationDateTime",  "DT", "1" },
        { 0x0400, 0x0563,
          "Modifying System", "ModifyingSystem",  "LO", "1" },
        { 0x0400, 0x0564,
          "Source of Previous Values", "SourceOfPreviousValues",  "LO", "1" },
        { 0x0400, 0x0565,
          "Reason for the Attribute Modification", "ReasonForTheAttributeModification",  "CS", "1" },
        { 0x2000, 0x0010,
          "Number of Copies", "NumberOfCopies",  "IS", "1" },
        { 0x2000, 0x001e,
          "Printer Configuration Sequence", "PrinterConfigurationSequence",  "SQ", "1" },
        { 0x2000, 0x0020,
          "Print Priority", "PrintPriority",  "CS", "1" },
        { 0x2000, 0x0030,
          "Medium Type", "MediumType",  "CS", "1" },
        { 0x2000, 0x0040,
          "Film Destination", "FilmDestination",  "CS", "1" },
        { 0x2000, 0x0050,
          "Film Session Label", "FilmSessionLabel",  "LO", "1" },
        { 0x2000, 0x0060,
          "Memory Allocation", "MemoryAllocation",  "IS", "1" },
        { 0x2000, 0x0061,
          "Maximum Memory Allocation", "MaximumMemoryAllocation",  "IS", "1" },
        { 0x2000, 0x0062,
          "Color Image Printing Flag", "ColorImagePrintingFlag",  "CS", "1" },
        { 0x2000, 0x0063,
          "Collation Flag", "CollationFlag",  "CS", "1" },
        { 0x2000, 0x0065,
          "Annotation Flag", "AnnotationFlag",  "CS", "1" },
        { 0x2000, 0x0067,
          "Image Overlay Flag", "ImageOverlayFlag",  "CS", "1" },
        { 0x2000, 0x0069,
          "Presentation LUT Flag", "PresentationLUTFlag",  "CS", "1" },
        { 0x2000, 0x006a,
          "Image Box Presentation LUT Flag", "ImageBoxPresentationLUTFlag",  "CS", "1" },
        { 0x2000, 0x00a0,
          "Memory Bit Depth", "MemoryBitDepth",  "US", "1" },
        { 0x2000, 0x00a1,
          "Printing Bit Depth", "PrintingBitDepth",  "US", "1" },
        { 0x2000, 0x00a2,
          "Media Installed Sequence", "MediaInstalledSequence",  "SQ", "1" },
        { 0x2000, 0x00a4,
          "Other Media Available Sequence", "OtherMediaAvailableSequence",  "SQ", "1" },
        { 0x2000, 0x00a8,
          "Supported Image Display Formats Sequence", "SupportedImageDisplayFormatsSequence",  "SQ", "1" },
        { 0x2000, 0x0500,
          "Referenced Film Box Sequence", "ReferencedFilmBoxSequence",  "SQ", "1" },
        { 0x2000, 0x0510,
          "Referenced Stored Print Sequence", "ReferencedStoredPrintSequence",  "SQ", "1" },
        { 0x2010, 0x0010,
          "Image Display Format", "ImageDisplayFormat",  "ST", "1" },
        { 0x2010, 0x0030,
          "Annotation Display Format ID", "AnnotationDisplayFormatID",  "CS", "1" },
        { 0x2010, 0x0040,
          "Film Orientation", "FilmOrientation",  "CS", "1" },
        { 0x2010, 0x0050,
          "Film Size ID", "FilmSizeID",  "CS", "1" },
        { 0x2010, 0x0052,
          "Printer Resolution ID", "PrinterResolutionID",  "CS", "1" },
        { 0x2010, 0x0054,
          "Default Printer Resolution ID", "DefaultPrinterResolutionID",  "CS", "1" },
        { 0x2010, 0x0060,
          "Magnification Type", "MagnificationType",  "CS", "1" },
        { 0x2010, 0x0080,
          "Smoothing Type", "SmoothingType",  "CS", "1" },
        { 0x2010, 0x00a6,
          "Default Magnification Type", "DefaultMagnificationType",  "CS", "1" },
        { 0x2010, 0x00a7,
          "Other Magnification Types Available", "OtherMagnificationTypesAvailable",  "CS", "1-n" },
        { 0x2010, 0x00a8,
          "Default Smoothing Type", "DefaultSmoothingType",  "CS", "1" },
        { 0x2010, 0x00a9,
          "Other Smoothing Types Available", "OtherSmoothingTypesAvailable",  "CS", "1-n" },
        { 0x2010, 0x0100,
          "Border Density", "BorderDensity",  "CS", "1" },
        { 0x2010, 0x0110,
          "Empty Image Density", "EmptyImageDensity",  "CS", "1" },
        { 0x2010, 0x0120,
          "Min Density", "MinDensity",  "US", "1" },
        { 0x2010, 0x0130,
          "Max Density", "MaxDensity",  "US", "1" },
        { 0x2010, 0x0140,
          "Trim", "Trim",  "CS", "1" },
        { 0x2010, 0x0150,
          "Configuration Information", "ConfigurationInformation",  "ST", "1" },
        { 0x2010, 0x0152,
          "Configuration Information Description", "ConfigurationInformationDescription",  "LT", "1" },
        { 0x2010, 0x0154,
          "Maximum Collated Films", "MaximumCollatedFilms",  "IS", "1" },
        { 0x2010, 0x015e,
          "Illumination", "Illumination",  "US", "1" },
        { 0x2010, 0x0160,
          "Reflected Ambient Light", "ReflectedAmbientLight",  "US", "1" },
        { 0x2010, 0x0376,
          "Printer Pixel Spacing", "PrinterPixelSpacing",  "DS", "2" },
        { 0x2010, 0x0500,
          "Referenced Film Session Sequence", "ReferencedFilmSessionSequence",  "SQ", "1" },
        { 0x2010, 0x0510,
          "Referenced Image Box Sequence", "ReferencedImageBoxSequence",  "SQ", "1" },
        { 0x2010, 0x0520,
          "Referenced Basic Annotation Box Sequence", "ReferencedBasicAnnotationBoxSequence",  "SQ", "1" },
        { 0x2020, 0x0010,
          "Image Box Position", "ImageBoxPosition",  "US", "1" },
        { 0x2020, 0x0020,
          "Polarity", "Polarity",  "CS", "1" },
        { 0x2020, 0x0030,
          "Requested Image Size", "RequestedImageSize",  "DS", "1" },
        { 0x2020, 0x0040,
          "Requested Decimate/Crop Behavior", "RequestedDecimateCropBehavior",  "CS", "1" },
        { 0x2020, 0x0050,
          "Requested Resolution ID", "RequestedResolutionID",  "CS", "1" },
        { 0x2020, 0x00a0,
          "Requested Image Size Flag", "RequestedImageSizeFlag",  "CS", "1" },
        { 0x2020, 0x00a2,
          "Decimate/Crop Result", "DecimateCropResult",  "CS", "1" },
        { 0x2020, 0x0110,
          "Basic Grayscale Image Sequence", "BasicGrayscaleImageSequence",  "SQ", "1" },
        { 0x2020, 0x0111,
          "Basic Color Image Sequence", "BasicColorImageSequence",  "SQ", "1" },
        { 0x2020, 0x0130,
          "Referenced Image Overlay Box Sequence", "ReferencedImageOverlayBoxSequence",  "SQ", "1" },
        { 0x2020, 0x0140,
          "Referenced VOI LUT Box Sequence", "ReferencedVOILUTBoxSequence",  "SQ", "1" },
        { 0x2030, 0x0010,
          "Annotation Position", "AnnotationPosition",  "US", "1" },
        { 0x2030, 0x0020,
          "Text String", "TextString",  "LO", "1" },
        { 0x2040, 0x0010,
          "Referenced Overlay Plane Sequence", "ReferencedOverlayPlaneSequence",  "SQ", "1" },
        { 0x2040, 0x0011,
          "Referenced Overlay Plane Groups", "ReferencedOverlayPlaneGroups",  "US", "1-99" },
        { 0x2040, 0x0020,
          "Overlay Pixel Data Sequence", "OverlayPixelDataSequence",  "SQ", "1" },
        { 0x2040, 0x0060,
          "Overlay Magnification Type", "OverlayMagnificationType",  "CS", "1" },
        { 0x2040, 0x0070,
          "Overlay Smoothing Type", "OverlaySmoothingType",  "CS", "1" },
        { 0x2040, 0x0072,
          "Overlay or Image Magnification", "OverlayOrImageMagnification",  "CS", "1" },
        { 0x2040, 0x0074,
          "Magnify to Number of Columns", "MagnifyToNumberOfColumns",  "US", "1" },
        { 0x2040, 0x0080,
          "Overlay Foreground Density", "OverlayForegroundDensity",  "CS", "1" },
        { 0x2040, 0x0082,
          "Overlay Background Density", "OverlayBackgroundDensity",  "CS", "1" },
        { 0x2040, 0x0090,
          "Overlay Mode", "OverlayMode",  "CS", "1" },
        { 0x2040, 0x0100,
          "Threshold Density", "ThresholdDensity",  "CS", "1" },
        { 0x2040, 0x0500,
          "Referenced Image Box Sequence (Retired)", "ReferencedImageBoxSequenceRetired",  "SQ", "1" },
        { 0x2050, 0x0010,
          "Presentation LUT Sequence", "PresentationLUTSequence",  "SQ", "1" },
        { 0x2050, 0x0020,
          "Presentation LUT Shape", "PresentationLUTShape",  "CS", "1" },
        { 0x2050, 0x0500,
          "Referenced Presentation LUT Sequence", "ReferencedPresentationLUTSequence",  "SQ", "1" },
        { 0x2100, 0x0010,
          "Print Job ID", "PrintJobID",  "SH", "1" },
        { 0x2100, 0x0020,
          "Execution Status", "ExecutionStatus",  "CS", "1" },
        { 0x2100, 0x0030,
          "Execution Status Info", "ExecutionStatusInfo",  "CS", "1" },
        { 0x2100, 0x0040,
          "Creation Date", "CreationDate",  "DA", "1" },
        { 0x2100, 0x0050,
          "Creation Time", "CreationTime",  "TM", "1" },
        { 0x2100, 0x0070,
          "Originator", "Originator",  "AE", "1" },
        { 0x2100, 0x0140,
          "Destination AE", "DestinationAE",  "AE", "1" },
        { 0x2100, 0x0160,
          "Owner ID", "OwnerID",  "SH", "1" },
        { 0x2100, 0x0170,
          "Number of Films", "NumberOfFilms",  "IS", "1" },
        { 0x2100, 0x0500,
          "Referenced Print Job Sequence (Pull Stored Print)", "ReferencedPrintJobSequencePullStoredPrint",  "SQ", "1" },
        { 0x2110, 0x0010,
          "Printer Status", "PrinterStatus",  "CS", "1" },
        { 0x2110, 0x0020,
          "Printer Status Info", "PrinterStatusInfo",  "CS", "1" },
        { 0x2110, 0x0030,
          "Printer Name", "PrinterName",  "LO", "1" },
        { 0x2110, 0x0099,
          "Print Queue ID", "PrintQueueID",  "SH", "1" },
        { 0x2120, 0x0010,
          "Queue Status", "QueueStatus",  "CS", "1" },
        { 0x2120, 0x0050,
          "Print Job Description Sequence", "PrintJobDescriptionSequence",  "SQ", "1" },
        { 0x2120, 0x0070,
          "Referenced Print Job Sequence", "ReferencedPrintJobSequence",  "SQ", "1" },
        { 0x2130, 0x0010,
          "Print Management Capabilities Sequence", "PrintManagementCapabilitiesSequence",  "SQ", "1" },
        { 0x2130, 0x0015,
          "Printer Characteristics Sequence", "PrinterCharacteristicsSequence",  "SQ", "1" },
        { 0x2130, 0x0030,
          "Film Box Content Sequence", "FilmBoxContentSequence",  "SQ", "1" },
        { 0x2130, 0x0040,
          "Image Box Content Sequence", "ImageBoxContentSequence",  "SQ", "1" },
        { 0x2130, 0x0050,
          "Annotation Content Sequence", "AnnotationContentSequence",  "SQ", "1" },
        { 0x2130, 0x0060,
          "Image Overlay Box Content Sequence", "ImageOverlayBoxContentSequence",  "SQ", "1" },
        { 0x2130, 0x0080,
          "Presentation LUT Content Sequence", "PresentationLUTContentSequence",  "SQ", "1" },
        { 0x2130, 0x00a0,
          "Proposed Study Sequence", "ProposedStudySequence",  "SQ", "1" },
        { 0x2130, 0x00c0,
          "Original Image Sequence", "OriginalImageSequence",  "SQ", "1" },
        { 0x2200, 0x0001,
          "Label Using Information Extracted From Instances", "LabelUsingInformationExtractedFromInstances",  "CS", "1" },
        { 0x2200, 0x0002,
          "Label Text", "LabelText",  "UT", "1" },
        { 0x2200, 0x0003,
          "Label Style Selection", "LabelStyleSelection",  "CS", "1" },
        { 0x2200, 0x0004,
          "Media Disposition", "MediaDisposition",  "LT", "1" },
        { 0x2200, 0x0005,
          "Barcode Value", "BarcodeValue",  "LT", "1" },
        { 0x2200, 0x0006,
          "Barcode Symbology", "BarcodeSymbology",  "CS", "1" },
        { 0x2200, 0x0007,
          "Allow Media Splitting", "AllowMediaSplitting",  "CS", "1" },
        { 0x2200, 0x0008,
          "Include Non-DICOM Objects", "IncludeNonDICOMObjects",  "CS", "1" },
        { 0x2200, 0x0009,
          "Include Display Application", "IncludeDisplayApplication",  "CS", "1" },
        { 0x2200, 0x000a,
          "Preserve Composite Instances After Media Creation", "PreserveCompositeInstancesAfterMediaCreation",  "CS", "1" },
        { 0x2200, 0x000b,
          "Total Number of Pieces of Media Created", "TotalNumberOfPiecesOfMediaCreated",  "US", "1" },
        { 0x2200, 0x000c,
          "Requested Media Application Profile", "RequestedMediaApplicationProfile",  "LO", "1" },
        { 0x2200, 0x000d,
          "Referenced Storage Media Sequence", "ReferencedStorageMediaSequence",  "SQ", "1" },
        { 0x2200, 0x000e,
          "Failure Attributes", "FailureAttributes",  "AT", "1-n" },
        { 0x2200, 0x000f,
          "Allow Lossy Compression", "AllowLossyCompression",  "CS", "1" },
        { 0x2200, 0x0020,
          "Request Priority", "RequestPriority",  "CS", "1" },
        { 0x3002, 0x0002,
          "RT Image Label", "RTImageLabel",  "SH", "1" },
        { 0x3002, 0x0003,
          "RT Image Name", "RTImageName",  "LO", "1" },
        { 0x3002, 0x0004,
          "RT Image Description", "RTImageDescription",  "ST", "1" },
        { 0x3002, 0x000a,
          "Reported Values Origin", "ReportedValuesOrigin",  "CS", "1" },
        { 0x3002, 0x000c,
          "RT Image Plane", "RTImagePlane",  "CS", "1" },
        { 0x3002, 0x000d,
          "X-Ray Image Receptor Translation", "XRayImageReceptorTranslation",  "DS", "3" },
        { 0x3002, 0x000e,
          "X-Ray Image Receptor Angle", "XRayImageReceptorAngle",  "DS", "1" },
        { 0x3002, 0x0010,
          "RT Image Orientation", "RTImageOrientation",  "DS", "6" },
        { 0x3002, 0x0011,
          "Image Plane Pixel Spacing", "ImagePlanePixelSpacing",  "DS", "2" },
        { 0x3002, 0x0012,
          "RT Image Position", "RTImagePosition",  "DS", "2" },
        { 0x3002, 0x0020,
          "Radiation Machine Name", "RadiationMachineName",  "SH", "1" },
        { 0x3002, 0x0022,
          "Radiation Machine SAD", "RadiationMachineSAD",  "DS", "1" },
        { 0x3002, 0x0024,
          "Radiation Machine SSD", "RadiationMachineSSD",  "DS", "1" },
        { 0x3002, 0x0026,
          "RT Image SID", "RTImageSID",  "DS", "1" },
        { 0x3002, 0x0028,
          "Source to Reference Object Distance", "SourceToReferenceObjectDistance",  "DS", "1" },
        { 0x3002, 0x0029,
          "Fraction Number", "FractionNumber",  "IS", "1" },
        { 0x3002, 0x0030,
          "Exposure Sequence", "ExposureSequence",  "SQ", "1" },
        { 0x3002, 0x0032,
          "Meterset Exposure", "MetersetExposure",  "DS", "1" },
        { 0x3002, 0x0034,
          "Diaphragm Position", "DiaphragmPosition",  "DS", "4" },
        { 0x3002, 0x0040,
          "Fluence Map Sequence", "FluenceMapSequence",  "SQ", "1" },
        { 0x3002, 0x0041,
          "Fluence Data Source", "FluenceDataSource",  "CS", "1" },
        { 0x3002, 0x0042,
          "Fluence Data Scale", "FluenceDataScale",  "DS", "1" },
        { 0x3002, 0x0050,
          "Primary Fluence Mode Sequence", "PrimaryFluenceModeSequence",  "SQ", "1" },
        { 0x3002, 0x0051,
          "Fluence Mode", "FluenceMode",  "CS", "1" },
        { 0x3002, 0x0052,
          "Fluence Mode ID", "FluenceModeID",  "SH", "1" },
        { 0x3004, 0x0001,
          "DVH Type", "DVHType",  "CS", "1" },
        { 0x3004, 0x0002,
          "Dose Units", "DoseUnits",  "CS", "1" },
        { 0x3004, 0x0004,
          "Dose Type", "DoseType",  "CS", "1" },
        { 0x3004, 0x0005,
          "Spatial Transform of Dose", "SpatialTransformOfDose",  "CS", "1" },
        { 0x3004, 0x0006,
          "Dose Comment", "DoseComment",  "LO", "1" },
        { 0x3004, 0x0008,
          "Normalization Point", "NormalizationPoint",  "DS", "3" },
        { 0x3004, 0x000a,
          "Dose Summation Type", "DoseSummationType",  "CS", "1" },
        { 0x3004, 0x000c,
          "Grid Frame Offset Vector", "GridFrameOffsetVector",  "DS", "2-n" },
        { 0x3004, 0x000e,
          "Dose Grid Scaling", "DoseGridScaling",  "DS", "1" },
        { 0x3004, 0x0010,
          "RT Dose ROI Sequence", "RTDoseROISequence",  "SQ", "1" },
        { 0x3004, 0x0012,
          "Dose Value", "DoseValue",  "DS", "1" },
        { 0x3004, 0x0014,
          "Tissue Heterogeneity Correction", "TissueHeterogeneityCorrection",  "CS", "1-3" },
        { 0x3004, 0x0040,
          "DVH Normalization Point", "DVHNormalizationPoint",  "DS", "3" },
        { 0x3004, 0x0042,
          "DVH Normalization Dose Value", "DVHNormalizationDoseValue",  "DS", "1" },
        { 0x3004, 0x0050,
          "DVH Sequence", "DVHSequence",  "SQ", "1" },
        { 0x3004, 0x0052,
          "DVH Dose Scaling", "DVHDoseScaling",  "DS", "1" },
        { 0x3004, 0x0054,
          "DVH Volume Units", "DVHVolumeUnits",  "CS", "1" },
        { 0x3004, 0x0056,
          "DVH Number of Bins", "DVHNumberOfBins",  "IS", "1" },
        { 0x3004, 0x0058,
          "DVH Data", "DVHData",  "DS", "2-2n" },
        { 0x3004, 0x0060,
          "DVH Referenced ROI Sequence", "DVHReferencedROISequence",  "SQ", "1" },
        { 0x3004, 0x0062,
          "DVH ROI Contribution Type", "DVHROIContributionType",  "CS", "1" },
        { 0x3004, 0x0070,
          "DVH Minimum Dose", "DVHMinimumDose",  "DS", "1" },
        { 0x3004, 0x0072,
          "DVH Maximum Dose", "DVHMaximumDose",  "DS", "1" },
        { 0x3004, 0x0074,
          "DVH Mean Dose", "DVHMeanDose",  "DS", "1" },
        { 0x3006, 0x0002,
          "Structure Set Label", "StructureSetLabel",  "SH", "1" },
        { 0x3006, 0x0004,
          "Structure Set Name", "StructureSetName",  "LO", "1" },
        { 0x3006, 0x0006,
          "Structure Set Description", "StructureSetDescription",  "ST", "1" },
        { 0x3006, 0x0008,
          "Structure Set Date", "StructureSetDate",  "DA", "1" },
        { 0x3006, 0x0009,
          "Structure Set Time", "StructureSetTime",  "TM", "1" },
        { 0x3006, 0x0010,
          "Referenced Frame of Reference Sequence", "ReferencedFrameOfReferenceSequence",  "SQ", "1" },
        { 0x3006, 0x0012,
          "RT Referenced Study Sequence", "RTReferencedStudySequence",  "SQ", "1" },
        { 0x3006, 0x0014,
          "RT Referenced Series Sequence", "RTReferencedSeriesSequence",  "SQ", "1" },
        { 0x3006, 0x0016,
          "Contour Image Sequence", "ContourImageSequence",  "SQ", "1" },
        { 0x3006, 0x0018,
          "Predecessor Structure Set Sequence", "PredecessorStructureSetSequence",  "SQ", "1" },
        { 0x3006, 0x0020,
          "Structure Set ROI Sequence", "StructureSetROISequence",  "SQ", "1" },
        { 0x3006, 0x0022,
          "ROI Number", "ROINumber",  "IS", "1" },
        { 0x3006, 0x0024,
          "Referenced Frame of Reference UID", "ReferencedFrameOfReferenceUID",  "UI", "1" },
        { 0x3006, 0x0026,
          "ROI Name", "ROIName",  "LO", "1" },
        { 0x3006, 0x0028,
          "ROI Description", "ROIDescription",  "ST", "1" },
        { 0x3006, 0x002a,
          "ROI Display Color", "ROIDisplayColor",  "IS", "3" },
        { 0x3006, 0x002c,
          "ROI Volume", "ROIVolume",  "DS", "1" },
        { 0x3006, 0x0030,
          "RT Related ROI Sequence", "RTRelatedROISequence",  "SQ", "1" },
        { 0x3006, 0x0033,
          "RT ROI Relationship", "RTROIRelationship",  "CS", "1" },
        { 0x3006, 0x0036,
          "ROI Generation Algorithm", "ROIGenerationAlgorithm",  "CS", "1" },
        { 0x3006, 0x0038,
          "ROI Generation Description", "ROIGenerationDescription",  "LO", "1" },
        { 0x3006, 0x0039,
          "ROI Contour Sequence", "ROIContourSequence",  "SQ", "1" },
        { 0x3006, 0x0040,
          "Contour Sequence", "ContourSequence",  "SQ", "1" },
        { 0x3006, 0x0042,
          "Contour Geometric Type", "ContourGeometricType",  "CS", "1" },
        { 0x3006, 0x0044,
          "Contour Slab Thickness", "ContourSlabThickness",  "DS", "1" },
        { 0x3006, 0x0045,
          "Contour Offset Vector", "ContourOffsetVector",  "DS", "3" },
        { 0x3006, 0x0046,
          "Number of Contour Points", "NumberOfContourPoints",  "IS", "1" },
        { 0x3006, 0x0048,
          "Contour Number", "ContourNumber",  "IS", "1" },
        { 0x3006, 0x0049,
          "Attached Contours", "AttachedContours",  "IS", "1-n" },
        { 0x3006, 0x0050,
          "Contour Data", "ContourData",  "DS", "3-3n" },
        { 0x3006, 0x0080,
          "RT ROI Observations Sequence", "RTROIObservationsSequence",  "SQ", "1" },
        { 0x3006, 0x0082,
          "Observation Number", "ObservationNumber",  "IS", "1" },
        { 0x3006, 0x0084,
          "Referenced ROI Number", "ReferencedROINumber",  "IS", "1" },
        { 0x3006, 0x0085,
          "ROI Observation Label", "ROIObservationLabel",  "SH", "1" },
        { 0x3006, 0x0086,
          "RT ROI Identification Code Sequence", "RTROIIdentificationCodeSequence",  "SQ", "1" },
        { 0x3006, 0x0088,
          "ROI Observation Description", "ROIObservationDescription",  "ST", "1" },
        { 0x3006, 0x00a0,
          "Related RT ROI Observations Sequence", "RelatedRTROIObservationsSequence",  "SQ", "1" },
        { 0x3006, 0x00a4,
          "RT ROI Interpreted Type", "RTROIInterpretedType",  "CS", "1" },
        { 0x3006, 0x00a6,
          "ROI Interpreter", "ROIInterpreter",  "PN", "1" },
        { 0x3006, 0x00b0,
          "ROI Physical Properties Sequence", "ROIPhysicalPropertiesSequence",  "SQ", "1" },
        { 0x3006, 0x00b2,
          "ROI Physical Property", "ROIPhysicalProperty",  "CS", "1" },
        { 0x3006, 0x00b4,
          "ROI Physical Property Value", "ROIPhysicalPropertyValue",  "DS", "1" },
        { 0x3006, 0x00b6,
          "ROI Elemental Composition Sequence", "ROIElementalCompositionSequence",  "SQ", "1" },
        { 0x3006, 0x00b7,
          "ROI Elemental Composition Atomic Number", "ROIElementalCompositionAtomicNumber",  "US", "1" },
        { 0x3006, 0x00b8,
          "ROI Elemental Composition Atomic Mass Fraction", "ROIElementalCompositionAtomicMassFraction",  "FL", "1" },
        { 0x3006, 0x00b9,
          "Additional RT ROI Identification Code Sequence", "AdditionalRTROIIdentificationCodeSequence",  "SQ", "1" },
        { 0x3006, 0x00c0,
          "Frame of Reference Relationship Sequence", "FrameOfReferenceRelationshipSequence",  "SQ", "1" },
        { 0x3006, 0x00c2,
          "Related Frame of Reference UID", "RelatedFrameOfReferenceUID",  "UI", "1" },
        { 0x3006, 0x00c4,
          "Frame of Reference Transformation Type", "FrameOfReferenceTransformationType",  "CS", "1" },
        { 0x3006, 0x00c6,
          "Frame of Reference Transformation Matrix", "FrameOfReferenceTransformationMatrix",  "DS", "16" },
        { 0x3006, 0x00c8,
          "Frame of Reference Transformation Comment", "FrameOfReferenceTransformationComment",  "LO", "1" },
        { 0x3008, 0x0010,
          "Measured Dose Reference Sequence", "MeasuredDoseReferenceSequence",  "SQ", "1" },
        { 0x3008, 0x0012,
          "Measured Dose Description", "MeasuredDoseDescription",  "ST", "1" },
        { 0x3008, 0x0014,
          "Measured Dose Type", "MeasuredDoseType",  "CS", "1" },
        { 0x3008, 0x0016,
          "Measured Dose Value", "MeasuredDoseValue",  "DS", "1" },
        { 0x3008, 0x0020,
          "Treatment Session Beam Sequence", "TreatmentSessionBeamSequence",  "SQ", "1" },
        { 0x3008, 0x0021,
          "Treatment Session Ion Beam Sequence", "TreatmentSessionIonBeamSequence",  "SQ", "1" },
        { 0x3008, 0x0022,
          "Current Fraction Number", "CurrentFractionNumber",  "IS", "1" },
        { 0x3008, 0x0024,
          "Treatment Control Point Date", "TreatmentControlPointDate",  "DA", "1" },
        { 0x3008, 0x0025,
          "Treatment Control Point Time", "TreatmentControlPointTime",  "TM", "1" },
        { 0x3008, 0x002a,
          "Treatment Termination Status", "TreatmentTerminationStatus",  "CS", "1" },
        { 0x3008, 0x002b,
          "Treatment Termination Code", "TreatmentTerminationCode",  "SH", "1" },
        { 0x3008, 0x002c,
          "Treatment Verification Status", "TreatmentVerificationStatus",  "CS", "1" },
        { 0x3008, 0x0030,
          "Referenced Treatment Record Sequence", "ReferencedTreatmentRecordSequence",  "SQ", "1" },
        { 0x3008, 0x0032,
          "Specified Primary Meterset", "SpecifiedPrimaryMeterset",  "DS", "1" },
        { 0x3008, 0x0033,
          "Specified Secondary Meterset", "SpecifiedSecondaryMeterset",  "DS", "1" },
        { 0x3008, 0x0036,
          "Delivered Primary Meterset", "DeliveredPrimaryMeterset",  "DS", "1" },
        { 0x3008, 0x0037,
          "Delivered Secondary Meterset", "DeliveredSecondaryMeterset",  "DS", "1" },
        { 0x3008, 0x003a,
          "Specified Treatment Time", "SpecifiedTreatmentTime",  "DS", "1" },
        { 0x3008, 0x003b,
          "Delivered Treatment Time", "DeliveredTreatmentTime",  "DS", "1" },
        { 0x3008, 0x0040,
          "Control Point Delivery Sequence", "ControlPointDeliverySequence",  "SQ", "1" },
        { 0x3008, 0x0041,
          "Ion Control Point Delivery Sequence", "IonControlPointDeliverySequence",  "SQ", "1" },
        { 0x3008, 0x0042,
          "Specified Meterset", "SpecifiedMeterset",  "DS", "1" },
        { 0x3008, 0x0044,
          "Delivered Meterset", "DeliveredMeterset",  "DS", "1" },
        { 0x3008, 0x0045,
          "Meterset Rate Set", "MetersetRateSet",  "FL", "1" },
        { 0x3008, 0x0046,
          "Meterset Rate Delivered", "MetersetRateDelivered",  "FL", "1" },
        { 0x3008, 0x0047,
          "Scan Spot Metersets Delivered", "ScanSpotMetersetsDelivered",  "FL", "1-n" },
        { 0x3008, 0x0048,
          "Dose Rate Delivered", "DoseRateDelivered",  "DS", "1" },
        { 0x3008, 0x0050,
          "Treatment Summary Calculated Dose Reference Sequence", "TreatmentSummaryCalculatedDoseReferenceSequence",  "SQ", "1" },
        { 0x3008, 0x0052,
          "Cumulative Dose to Dose Reference", "CumulativeDoseToDoseReference",  "DS", "1" },
        { 0x3008, 0x0054,
          "First Treatment Date", "FirstTreatmentDate",  "DA", "1" },
        { 0x3008, 0x0056,
          "Most Recent Treatment Date", "MostRecentTreatmentDate",  "DA", "1" },
        { 0x3008, 0x005a,
          "Number of Fractions Delivered", "NumberOfFractionsDelivered",  "IS", "1" },
        { 0x3008, 0x0060,
          "Override Sequence", "OverrideSequence",  "SQ", "1" },
        { 0x3008, 0x0061,
          "Parameter Sequence Pointer", "ParameterSequencePointer",  "AT", "1" },
        { 0x3008, 0x0062,
          "Override Parameter Pointer", "OverrideParameterPointer",  "AT", "1" },
        { 0x3008, 0x0063,
          "Parameter Item Index", "ParameterItemIndex",  "IS", "1" },
        { 0x3008, 0x0064,
          "Measured Dose Reference Number", "MeasuredDoseReferenceNumber",  "IS", "1" },
        { 0x3008, 0x0065,
          "Parameter Pointer", "ParameterPointer",  "AT", "1" },
        { 0x3008, 0x0066,
          "Override Reason", "OverrideReason",  "ST", "1" },
        { 0x3008, 0x0068,
          "Corrected Parameter Sequence", "CorrectedParameterSequence",  "SQ", "1" },
        { 0x3008, 0x006a,
          "Correction Value", "CorrectionValue",  "FL", "1" },
        { 0x3008, 0x0070,
          "Calculated Dose Reference Sequence", "CalculatedDoseReferenceSequence",  "SQ", "1" },
        { 0x3008, 0x0072,
          "Calculated Dose Reference Number", "CalculatedDoseReferenceNumber",  "IS", "1" },
        { 0x3008, 0x0074,
          "Calculated Dose Reference Description", "CalculatedDoseReferenceDescription",  "ST", "1" },
        { 0x3008, 0x0076,
          "Calculated Dose Reference Dose Value", "CalculatedDoseReferenceDoseValue",  "DS", "1" },
        { 0x3008, 0x0078,
          "Start Meterset", "StartMeterset",  "DS", "1" },
        { 0x3008, 0x007a,
          "End Meterset", "EndMeterset",  "DS", "1" },
        { 0x3008, 0x0080,
          "Referenced Measured Dose Reference Sequence", "ReferencedMeasuredDoseReferenceSequence",  "SQ", "1" },
        { 0x3008, 0x0082,
          "Referenced Measured Dose Reference Number", "ReferencedMeasuredDoseReferenceNumber",  "IS", "1" },
        { 0x3008, 0x0090,
          "Referenced Calculated Dose Reference Sequence", "ReferencedCalculatedDoseReferenceSequence",  "SQ", "1" },
        { 0x3008, 0x0092,
          "Referenced Calculated Dose Reference Number", "ReferencedCalculatedDoseReferenceNumber",  "IS", "1" },
        { 0x3008, 0x00a0,
          "Beam Limiting Device Leaf Pairs Sequence", "BeamLimitingDeviceLeafPairsSequence",  "SQ", "1" },
        { 0x3008, 0x00b0,
          "Recorded Wedge Sequence", "RecordedWedgeSequence",  "SQ", "1" },
        { 0x3008, 0x00c0,
          "Recorded Compensator Sequence", "RecordedCompensatorSequence",  "SQ", "1" },
        { 0x3008, 0x00d0,
          "Recorded Block Sequence", "RecordedBlockSequence",  "SQ", "1" },
        { 0x3008, 0x00e0,
          "Treatment Summary Measured Dose Reference Sequence", "TreatmentSummaryMeasuredDoseReferenceSequence",  "SQ", "1" },
        { 0x3008, 0x00f0,
          "Recorded Snout Sequence", "RecordedSnoutSequence",  "SQ", "1" },
        { 0x3008, 0x00f2,
          "Recorded Range Shifter Sequence", "RecordedRangeShifterSequence",  "SQ", "1" },
        { 0x3008, 0x00f4,
          "Recorded Lateral Spreading Device Sequence", "RecordedLateralSpreadingDeviceSequence",  "SQ", "1" },
        { 0x3008, 0x00f6,
          "Recorded Range Modulator Sequence", "RecordedRangeModulatorSequence",  "SQ", "1" },
        { 0x3008, 0x0100,
          "Recorded Source Sequence", "RecordedSourceSequence",  "SQ", "1" },
        { 0x3008, 0x0105,
          "Source Serial Number", "SourceSerialNumber",  "LO", "1" },
        { 0x3008, 0x0110,
          "Treatment Session Application Setup Sequence", "TreatmentSessionApplicationSetupSequence",  "SQ", "1" },
        { 0x3008, 0x0116,
          "Application Setup Check", "ApplicationSetupCheck",  "CS", "1" },
        { 0x3008, 0x0120,
          "Recorded Brachy Accessory Device Sequence", "RecordedBrachyAccessoryDeviceSequence",  "SQ", "1" },
        { 0x3008, 0x0122,
          "Referenced Brachy Accessory Device Number", "ReferencedBrachyAccessoryDeviceNumber",  "IS", "1" },
        { 0x3008, 0x0130,
          "Recorded Channel Sequence", "RecordedChannelSequence",  "SQ", "1" },
        { 0x3008, 0x0132,
          "Specified Channel Total Time", "SpecifiedChannelTotalTime",  "DS", "1" },
        { 0x3008, 0x0134,
          "Delivered Channel Total Time", "DeliveredChannelTotalTime",  "DS", "1" },
        { 0x3008, 0x0136,
          "Specified Number of Pulses", "SpecifiedNumberOfPulses",  "IS", "1" },
        { 0x3008, 0x0138,
          "Delivered Number of Pulses", "DeliveredNumberOfPulses",  "IS", "1" },
        { 0x3008, 0x013a,
          "Specified Pulse Repetition Interval", "SpecifiedPulseRepetitionInterval",  "DS", "1" },
        { 0x3008, 0x013c,
          "Delivered Pulse Repetition Interval", "DeliveredPulseRepetitionInterval",  "DS", "1" },
        { 0x3008, 0x0140,
          "Recorded Source Applicator Sequence", "RecordedSourceApplicatorSequence",  "SQ", "1" },
        { 0x3008, 0x0142,
          "Referenced Source Applicator Number", "ReferencedSourceApplicatorNumber",  "IS", "1" },
        { 0x3008, 0x0150,
          "Recorded Channel Shield Sequence", "RecordedChannelShieldSequence",  "SQ", "1" },
        { 0x3008, 0x0152,
          "Referenced Channel Shield Number", "ReferencedChannelShieldNumber",  "IS", "1" },
        { 0x3008, 0x0160,
          "Brachy Control Point Delivered Sequence", "BrachyControlPointDeliveredSequence",  "SQ", "1" },
        { 0x3008, 0x0162,
          "Safe Position Exit Date", "SafePositionExitDate",  "DA", "1" },
        { 0x3008, 0x0164,
          "Safe Position Exit Time", "SafePositionExitTime",  "TM", "1" },
        { 0x3008, 0x0166,
          "Safe Position Return Date", "SafePositionReturnDate",  "DA", "1" },
        { 0x3008, 0x0168,
          "Safe Position Return Time", "SafePositionReturnTime",  "TM", "1" },
        { 0x3008, 0x0171,
          "Pulse Specific Brachy Control Point Delivered Sequence", "PulseSpecificBrachyControlPointDeliveredSequence",  "SQ", "1" },
        { 0x3008, 0x0172,
          "Pulse Number", "PulseNumber",  "US", "1" },
        { 0x3008, 0x0173,
          "Brachy Pulse Control Point Delivered Sequence", "BrachyPulseControlPointDeliveredSequence",  "SQ", "1" },
        { 0x3008, 0x0200,
          "Current Treatment Status", "CurrentTreatmentStatus",  "CS", "1" },
        { 0x3008, 0x0202,
          "Treatment Status Comment", "TreatmentStatusComment",  "ST", "1" },
        { 0x3008, 0x0220,
          "Fraction Group Summary Sequence", "FractionGroupSummarySequence",  "SQ", "1" },
        { 0x3008, 0x0223,
          "Referenced Fraction Number", "ReferencedFractionNumber",  "IS", "1" },
        { 0x3008, 0x0224,
          "Fraction Group Type", "FractionGroupType",  "CS", "1" },
        { 0x3008, 0x0230,
          "Beam Stopper Position", "BeamStopperPosition",  "CS", "1" },
        { 0x3008, 0x0240,
          "Fraction Status Summary Sequence", "FractionStatusSummarySequence",  "SQ", "1" },
        { 0x3008, 0x0250,
          "Treatment Date", "TreatmentDate",  "DA", "1" },
        { 0x3008, 0x0251,
          "Treatment Time", "TreatmentTime",  "TM", "1" },
        { 0x300a, 0x0002,
          "RT Plan Label", "RTPlanLabel",  "SH", "1" },
        { 0x300a, 0x0003,
          "RT Plan Name", "RTPlanName",  "LO", "1" },
        { 0x300a, 0x0004,
          "RT Plan Description", "RTPlanDescription",  "ST", "1" },
        { 0x300a, 0x0006,
          "RT Plan Date", "RTPlanDate",  "DA", "1" },
        { 0x300a, 0x0007,
          "RT Plan Time", "RTPlanTime",  "TM", "1" },
        { 0x300a, 0x0009,
          "Treatment Protocols", "TreatmentProtocols",  "LO", "1-n" },
        { 0x300a, 0x000a,
          "Plan Intent", "PlanIntent",  "CS", "1" },
        { 0x300a, 0x000b,
          "Treatment Sites", "TreatmentSites",  "LO", "1-n" },
        { 0x300a, 0x000c,
          "RT Plan Geometry", "RTPlanGeometry",  "CS", "1" },
        { 0x300a, 0x000e,
          "Prescription Description", "PrescriptionDescription",  "ST", "1" },
        { 0x300a, 0x0010,
          "Dose Reference Sequence", "DoseReferenceSequence",  "SQ", "1" },
        { 0x300a, 0x0012,
          "Dose Reference Number", "DoseReferenceNumber",  "IS", "1" },
        { 0x300a, 0x0013,
          "Dose Reference UID", "DoseReferenceUID",  "UI", "1" },
        { 0x300a, 0x0014,
          "Dose Reference Structure Type", "DoseReferenceStructureType",  "CS", "1" },
        { 0x300a, 0x0015,
          "Nominal Beam Energy Unit", "NominalBeamEnergyUnit",  "CS", "1" },
        { 0x300a, 0x0016,
          "Dose Reference Description", "DoseReferenceDescription",  "LO", "1" },
        { 0x300a, 0x0018,
          "Dose Reference Point Coordinates", "DoseReferencePointCoordinates",  "DS", "3" },
        { 0x300a, 0x001a,
          "Nominal Prior Dose", "NominalPriorDose",  "DS", "1" },
        { 0x300a, 0x0020,
          "Dose Reference Type", "DoseReferenceType",  "CS", "1" },
        { 0x300a, 0x0021,
          "Constraint Weight", "ConstraintWeight",  "DS", "1" },
        { 0x300a, 0x0022,
          "Delivery Warning Dose", "DeliveryWarningDose",  "DS", "1" },
        { 0x300a, 0x0023,
          "Delivery Maximum Dose", "DeliveryMaximumDose",  "DS", "1" },
        { 0x300a, 0x0025,
          "Target Minimum Dose", "TargetMinimumDose",  "DS", "1" },
        { 0x300a, 0x0026,
          "Target Prescription Dose", "TargetPrescriptionDose",  "DS", "1" },
        { 0x300a, 0x0027,
          "Target Maximum Dose", "TargetMaximumDose",  "DS", "1" },
        { 0x300a, 0x0028,
          "Target Underdose Volume Fraction", "TargetUnderdoseVolumeFraction",  "DS", "1" },
        { 0x300a, 0x002a,
          "Organ at Risk Full-volume Dose", "OrganAtRiskFullVolumeDose",  "DS", "1" },
        { 0x300a, 0x002b,
          "Organ at Risk Limit Dose", "OrganAtRiskLimitDose",  "DS", "1" },
        { 0x300a, 0x002c,
          "Organ at Risk Maximum Dose", "OrganAtRiskMaximumDose",  "DS", "1" },
        { 0x300a, 0x002d,
          "Organ at Risk Overdose Volume Fraction", "OrganAtRiskOverdoseVolumeFraction",  "DS", "1" },
        { 0x300a, 0x0040,
          "Tolerance Table Sequence", "ToleranceTableSequence",  "SQ", "1" },
        { 0x300a, 0x0042,
          "Tolerance Table Number", "ToleranceTableNumber",  "IS", "1" },
        { 0x300a, 0x0043,
          "Tolerance Table Label", "ToleranceTableLabel",  "SH", "1" },
        { 0x300a, 0x0044,
          "Gantry Angle Tolerance", "GantryAngleTolerance",  "DS", "1" },
        { 0x300a, 0x0046,
          "Beam Limiting Device Angle Tolerance", "BeamLimitingDeviceAngleTolerance",  "DS", "1" },
        { 0x300a, 0x0048,
          "Beam Limiting Device Tolerance Sequence", "BeamLimitingDeviceToleranceSequence",  "SQ", "1" },
        { 0x300a, 0x004a,
          "Beam Limiting Device Position Tolerance", "BeamLimitingDevicePositionTolerance",  "DS", "1" },
        { 0x300a, 0x004b,
          "Snout Position Tolerance", "SnoutPositionTolerance",  "FL", "1" },
        { 0x300a, 0x004c,
          "Patient Support Angle Tolerance", "PatientSupportAngleTolerance",  "DS", "1" },
        { 0x300a, 0x004e,
          "Table Top Eccentric Angle Tolerance", "TableTopEccentricAngleTolerance",  "DS", "1" },
        { 0x300a, 0x004f,
          "Table Top Pitch Angle Tolerance", "TableTopPitchAngleTolerance",  "FL", "1" },
        { 0x300a, 0x0050,
          "Table Top Roll Angle Tolerance", "TableTopRollAngleTolerance",  "FL", "1" },
        { 0x300a, 0x0051,
          "Table Top Vertical Position Tolerance", "TableTopVerticalPositionTolerance",  "DS", "1" },
        { 0x300a, 0x0052,
          "Table Top Longitudinal Position Tolerance", "TableTopLongitudinalPositionTolerance",  "DS", "1" },
        { 0x300a, 0x0053,
          "Table Top Lateral Position Tolerance", "TableTopLateralPositionTolerance",  "DS", "1" },
        { 0x300a, 0x0055,
          "RT Plan Relationship", "RTPlanRelationship",  "CS", "1" },
        { 0x300a, 0x0070,
          "Fraction Group Sequence", "FractionGroupSequence",  "SQ", "1" },
        { 0x300a, 0x0071,
          "Fraction Group Number", "FractionGroupNumber",  "IS", "1" },
        { 0x300a, 0x0072,
          "Fraction Group Description", "FractionGroupDescription",  "LO", "1" },
        { 0x300a, 0x0078,
          "Number of Fractions Planned", "NumberOfFractionsPlanned",  "IS", "1" },
        { 0x300a, 0x0079,
          "Number of Fraction Pattern Digits Per Day", "NumberOfFractionPatternDigitsPerDay",  "IS", "1" },
        { 0x300a, 0x007a,
          "Repeat Fraction Cycle Length", "RepeatFractionCycleLength",  "IS", "1" },
        { 0x300a, 0x007b,
          "Fraction Pattern", "FractionPattern",  "LT", "1" },
        { 0x300a, 0x0080,
          "Number of Beams", "NumberOfBeams",  "IS", "1" },
        { 0x300a, 0x0082,
          "Beam Dose Specification Point", "BeamDoseSpecificationPoint",  "DS", "3" },
        { 0x300a, 0x0084,
          "Beam Dose", "BeamDose",  "DS", "1" },
        { 0x300a, 0x0086,
          "Beam Meterset", "BeamMeterset",  "DS", "1" },
        { 0x300a, 0x0088,
          "Beam Dose Point Depth", "BeamDosePointDepth",  "FL", "1" },
        { 0x300a, 0x0089,
          "Beam Dose Point Equivalent Depth", "BeamDosePointEquivalentDepth",  "FL", "1" },
        { 0x300a, 0x008a,
          "Beam Dose Point SSD", "BeamDosePointSSD",  "FL", "1" },
        { 0x300a, 0x008b,
          "Beam Dose Meaning", "BeamDoseMeaning",  "CS", "1" },
        { 0x300a, 0x008c,
          "Beam Dose Verification Control Point Sequence", "BeamDoseVerificationControlPointSequence",  "SQ", "1" },
        { 0x300a, 0x008d,
          "Average Beam Dose Point Depth", "AverageBeamDosePointDepth",  "FL", "1" },
        { 0x300a, 0x008e,
          "Average Beam Dose Point Equivalent Depth", "AverageBeamDosePointEquivalentDepth",  "FL", "1" },
        { 0x300a, 0x008f,
          "Average Beam Dose Point SSD", "AverageBeamDosePointSSD",  "FL", "1" },
        { 0x300a, 0x00a0,
          "Number of Brachy Application Setups", "NumberOfBrachyApplicationSetups",  "IS", "1" },
        { 0x300a, 0x00a2,
          "Brachy Application Setup Dose Specification Point", "BrachyApplicationSetupDoseSpecificationPoint",  "DS", "3" },
        { 0x300a, 0x00a4,
          "Brachy Application Setup Dose", "BrachyApplicationSetupDose",  "DS", "1" },
        { 0x300a, 0x00b0,
          "Beam Sequence", "BeamSequence",  "SQ", "1" },
        { 0x300a, 0x00b2,
          "Treatment Machine Name", "TreatmentMachineName",  "SH", "1" },
        { 0x300a, 0x00b3,
          "Primary Dosimeter Unit", "PrimaryDosimeterUnit",  "CS", "1" },
        { 0x300a, 0x00b4,
          "Source-Axis Distance", "SourceAxisDistance",  "DS", "1" },
        { 0x300a, 0x00b6,
          "Beam Limiting Device Sequence", "BeamLimitingDeviceSequence",  "SQ", "1" },
        { 0x300a, 0x00b8,
          "RT Beam Limiting Device Type", "RTBeamLimitingDeviceType",  "CS", "1" },
        { 0x300a, 0x00ba,
          "Source to Beam Limiting Device Distance", "SourceToBeamLimitingDeviceDistance",  "DS", "1" },
        { 0x300a, 0x00bb,
          "Isocenter to Beam Limiting Device Distance", "IsocenterToBeamLimitingDeviceDistance",  "FL", "1" },
        { 0x300a, 0x00bc,
          "Number of Leaf/Jaw Pairs", "NumberOfLeafJawPairs",  "IS", "1" },
        { 0x300a, 0x00be,
          "Leaf Position Boundaries", "LeafPositionBoundaries",  "DS", "3-n" },
        { 0x300a, 0x00c0,
          "Beam Number", "BeamNumber",  "IS", "1" },
        { 0x300a, 0x00c2,
          "Beam Name", "BeamName",  "LO", "1" },
        { 0x300a, 0x00c3,
          "Beam Description", "BeamDescription",  "ST", "1" },
        { 0x300a, 0x00c4,
          "Beam Type", "BeamType",  "CS", "1" },
        { 0x300a, 0x00c5,
          "Beam Delivery Duration Limit", "BeamDeliveryDurationLimit",  "FD", "1" },
        { 0x300a, 0x00c6,
          "Radiation Type", "RadiationType",  "CS", "1" },
        { 0x300a, 0x00c7,
          "High-Dose Technique Type", "HighDoseTechniqueType",  "CS", "1" },
        { 0x300a, 0x00c8,
          "Reference Image Number", "ReferenceImageNumber",  "IS", "1" },
        { 0x300a, 0x00ca,
          "Planned Verification Image Sequence", "PlannedVerificationImageSequence",  "SQ", "1" },
        { 0x300a, 0x00cc,
          "Imaging Device-Specific Acquisition Parameters", "ImagingDeviceSpecificAcquisitionParameters",  "LO", "1-n" },
        { 0x300a, 0x00ce,
          "Treatment Delivery Type", "TreatmentDeliveryType",  "CS", "1" },
        { 0x300a, 0x00d0,
          "Number of Wedges", "NumberOfWedges",  "IS", "1" },
        { 0x300a, 0x00d1,
          "Wedge Sequence", "WedgeSequence",  "SQ", "1" },
        { 0x300a, 0x00d2,
          "Wedge Number", "WedgeNumber",  "IS", "1" },
        { 0x300a, 0x00d3,
          "Wedge Type", "WedgeType",  "CS", "1" },
        { 0x300a, 0x00d4,
          "Wedge ID", "WedgeID",  "SH", "1" },
        { 0x300a, 0x00d5,
          "Wedge Angle", "WedgeAngle",  "IS", "1" },
        { 0x300a, 0x00d6,
          "Wedge Factor", "WedgeFactor",  "DS", "1" },
        { 0x300a, 0x00d7,
          "Total Wedge Tray Water-Equivalent Thickness", "TotalWedgeTrayWaterEquivalentThickness",  "FL", "1" },
        { 0x300a, 0x00d8,
          "Wedge Orientation", "WedgeOrientation",  "DS", "1" },
        { 0x300a, 0x00d9,
          "Isocenter to Wedge Tray Distance", "IsocenterToWedgeTrayDistance",  "FL", "1" },
        { 0x300a, 0x00da,
          "Source to Wedge Tray Distance", "SourceToWedgeTrayDistance",  "DS", "1" },
        { 0x300a, 0x00db,
          "Wedge Thin Edge Position", "WedgeThinEdgePosition",  "FL", "1" },
        { 0x300a, 0x00dc,
          "Bolus ID", "BolusID",  "SH", "1" },
        { 0x300a, 0x00dd,
          "Bolus Description", "BolusDescription",  "ST", "1" },
        { 0x300a, 0x00de,
          "Effective Wedge Angle", "EffectiveWedgeAngle",  "DS", "1" },
        { 0x300a, 0x00e0,
          "Number of Compensators", "NumberOfCompensators",  "IS", "1" },
        { 0x300a, 0x00e1,
          "Material ID", "MaterialID",  "SH", "1" },
        { 0x300a, 0x00e2,
          "Total Compensator Tray Factor", "TotalCompensatorTrayFactor",  "DS", "1" },
        { 0x300a, 0x00e3,
          "Compensator Sequence", "CompensatorSequence",  "SQ", "1" },
        { 0x300a, 0x00e4,
          "Compensator Number", "CompensatorNumber",  "IS", "1" },
        { 0x300a, 0x00e5,
          "Compensator ID", "CompensatorID",  "SH", "1" },
        { 0x300a, 0x00e6,
          "Source to Compensator Tray Distance", "SourceToCompensatorTrayDistance",  "DS", "1" },
        { 0x300a, 0x00e7,
          "Compensator Rows", "CompensatorRows",  "IS", "1" },
        { 0x300a, 0x00e8,
          "Compensator Columns", "CompensatorColumns",  "IS", "1" },
        { 0x300a, 0x00e9,
          "Compensator Pixel Spacing", "CompensatorPixelSpacing",  "DS", "2" },
        { 0x300a, 0x00ea,
          "Compensator Position", "CompensatorPosition",  "DS", "2" },
        { 0x300a, 0x00eb,
          "Compensator Transmission Data", "CompensatorTransmissionData",  "DS", "1-n" },
        { 0x300a, 0x00ec,
          "Compensator Thickness Data", "CompensatorThicknessData",  "DS", "1-n" },
        { 0x300a, 0x00ed,
          "Number of Boli", "NumberOfBoli",  "IS", "1" },
        { 0x300a, 0x00ee,
          "Compensator Type", "CompensatorType",  "CS", "1" },
        { 0x300a, 0x00ef,
          "Compensator Tray ID", "CompensatorTrayID",  "SH", "1" },
        { 0x300a, 0x00f0,
          "Number of Blocks", "NumberOfBlocks",  "IS", "1" },
        { 0x300a, 0x00f2,
          "Total Block Tray Factor", "TotalBlockTrayFactor",  "DS", "1" },
        { 0x300a, 0x00f3,
          "Total Block Tray Water-Equivalent Thickness", "TotalBlockTrayWaterEquivalentThickness",  "FL", "1" },
        { 0x300a, 0x00f4,
          "Block Sequence", "BlockSequence",  "SQ", "1" },
        { 0x300a, 0x00f5,
          "Block Tray ID", "BlockTrayID",  "SH", "1" },
        { 0x300a, 0x00f6,
          "Source to Block Tray Distance", "SourceToBlockTrayDistance",  "DS", "1" },
        { 0x300a, 0x00f7,
          "Isocenter to Block Tray Distance", "IsocenterToBlockTrayDistance",  "FL", "1" },
        { 0x300a, 0x00f8,
          "Block Type", "BlockType",  "CS", "1" },
        { 0x300a, 0x00f9,
          "Accessory Code", "AccessoryCode",  "LO", "1" },
        { 0x300a, 0x00fa,
          "Block Divergence", "BlockDivergence",  "CS", "1" },
        { 0x300a, 0x00fb,
          "Block Mounting Position", "BlockMountingPosition",  "CS", "1" },
        { 0x300a, 0x00fc,
          "Block Number", "BlockNumber",  "IS", "1" },
        { 0x300a, 0x00fe,
          "Block Name", "BlockName",  "LO", "1" },
        { 0x300a, 0x0100,
          "Block Thickness", "BlockThickness",  "DS", "1" },
        { 0x300a, 0x0102,
          "Block Transmission", "BlockTransmission",  "DS", "1" },
        { 0x300a, 0x0104,
          "Block Number of Points", "BlockNumberOfPoints",  "IS", "1" },
        { 0x300a, 0x0106,
          "Block Data", "BlockData",  "DS", "2-2n" },
        { 0x300a, 0x0107,
          "Applicator Sequence", "ApplicatorSequence",  "SQ", "1" },
        { 0x300a, 0x0108,
          "Applicator ID", "ApplicatorID",  "SH", "1" },
        { 0x300a, 0x0109,
          "Applicator Type", "ApplicatorType",  "CS", "1" },
        { 0x300a, 0x010a,
          "Applicator Description", "ApplicatorDescription",  "LO", "1" },
        { 0x300a, 0x010c,
          "Cumulative Dose Reference Coefficient", "CumulativeDoseReferenceCoefficient",  "DS", "1" },
        { 0x300a, 0x010e,
          "Final Cumulative Meterset Weight", "FinalCumulativeMetersetWeight",  "DS", "1" },
        { 0x300a, 0x0110,
          "Number of Control Points", "NumberOfControlPoints",  "IS", "1" },
        { 0x300a, 0x0111,
          "Control Point Sequence", "ControlPointSequence",  "SQ", "1" },
        { 0x300a, 0x0112,
          "Control Point Index", "ControlPointIndex",  "IS", "1" },
        { 0x300a, 0x0114,
          "Nominal Beam Energy", "NominalBeamEnergy",  "DS", "1" },
        { 0x300a, 0x0115,
          "Dose Rate Set", "DoseRateSet",  "DS", "1" },
        { 0x300a, 0x0116,
          "Wedge Position Sequence", "WedgePositionSequence",  "SQ", "1" },
        { 0x300a, 0x0118,
          "Wedge Position", "WedgePosition",  "CS", "1" },
        { 0x300a, 0x011a,
          "Beam Limiting Device Position Sequence", "BeamLimitingDevicePositionSequence",  "SQ", "1" },
        { 0x300a, 0x011c,
          "Leaf/Jaw Positions", "LeafJawPositions",  "DS", "2-2n" },
        { 0x300a, 0x011e,
          "Gantry Angle", "GantryAngle",  "DS", "1" },
        { 0x300a, 0x011f,
          "Gantry Rotation Direction", "GantryRotationDirection",  "CS", "1" },
        { 0x300a, 0x0120,
          "Beam Limiting Device Angle", "BeamLimitingDeviceAngle",  "DS", "1" },
        { 0x300a, 0x0121,
          "Beam Limiting Device Rotation Direction", "BeamLimitingDeviceRotationDirection",  "CS", "1" },
        { 0x300a, 0x0122,
          "Patient Support Angle", "PatientSupportAngle",  "DS", "1" },
        { 0x300a, 0x0123,
          "Patient Support Rotation Direction", "PatientSupportRotationDirection",  "CS", "1" },
        { 0x300a, 0x0124,
          "Table Top Eccentric Axis Distance", "TableTopEccentricAxisDistance",  "DS", "1" },
        { 0x300a, 0x0125,
          "Table Top Eccentric Angle", "TableTopEccentricAngle",  "DS", "1" },
        { 0x300a, 0x0126,
          "Table Top Eccentric Rotation Direction", "TableTopEccentricRotationDirection",  "CS", "1" },
        { 0x300a, 0x0128,
          "Table Top Vertical Position", "TableTopVerticalPosition",  "DS", "1" },
        { 0x300a, 0x0129,
          "Table Top Longitudinal Position", "TableTopLongitudinalPosition",  "DS", "1" },
        { 0x300a, 0x012a,
          "Table Top Lateral Position", "TableTopLateralPosition",  "DS", "1" },
        { 0x300a, 0x012c,
          "Isocenter Position", "IsocenterPosition",  "DS", "3" },
        { 0x300a, 0x012e,
          "Surface Entry Point", "SurfaceEntryPoint",  "DS", "3" },
        { 0x300a, 0x0130,
          "Source to Surface Distance", "SourceToSurfaceDistance",  "DS", "1" },
        { 0x300a, 0x0131,
          "Average Beam Dose Point Source to External Contour Surface Distance", "AverageBeamDosePointSourceToExternalContourSurfaceDistance",  "FL", "1" },
        { 0x300a, 0x0132,
          "Source to External Contour Distance", "SourceToExternalContourDistance",  "FL", "1" },
        { 0x300a, 0x0133,
          "External Contour Entry Point", "ExternalContourEntryPoint",  "FL", "3" },
        { 0x300a, 0x0134,
          "Cumulative Meterset Weight", "CumulativeMetersetWeight",  "DS", "1" },
        { 0x300a, 0x0140,
          "Table Top Pitch Angle", "TableTopPitchAngle",  "FL", "1" },
        { 0x300a, 0x0142,
          "Table Top Pitch Rotation Direction", "TableTopPitchRotationDirection",  "CS", "1" },
        { 0x300a, 0x0144,
          "Table Top Roll Angle", "TableTopRollAngle",  "FL", "1" },
        { 0x300a, 0x0146,
          "Table Top Roll Rotation Direction", "TableTopRollRotationDirection",  "CS", "1" },
        { 0x300a, 0x0148,
          "Head Fixation Angle", "HeadFixationAngle",  "FL", "1" },
        { 0x300a, 0x014a,
          "Gantry Pitch Angle", "GantryPitchAngle",  "FL", "1" },
        { 0x300a, 0x014c,
          "Gantry Pitch Rotation Direction", "GantryPitchRotationDirection",  "CS", "1" },
        { 0x300a, 0x014e,
          "Gantry Pitch Angle Tolerance", "GantryPitchAngleTolerance",  "FL", "1" },
        { 0x300a, 0x0180,
          "Patient Setup Sequence", "PatientSetupSequence",  "SQ", "1" },
        { 0x300a, 0x0182,
          "Patient Setup Number", "PatientSetupNumber",  "IS", "1" },
        { 0x300a, 0x0183,
          "Patient Setup Label", "PatientSetupLabel",  "LO", "1" },
        { 0x300a, 0x0184,
          "Patient Additional Position", "PatientAdditionalPosition",  "LO", "1" },
        { 0x300a, 0x0190,
          "Fixation Device Sequence", "FixationDeviceSequence",  "SQ", "1" },
        { 0x300a, 0x0192,
          "Fixation Device Type", "FixationDeviceType",  "CS", "1" },
        { 0x300a, 0x0194,
          "Fixation Device Label", "FixationDeviceLabel",  "SH", "1" },
        { 0x300a, 0x0196,
          "Fixation Device Description", "FixationDeviceDescription",  "ST", "1" },
        { 0x300a, 0x0198,
          "Fixation Device Position", "FixationDevicePosition",  "SH", "1" },
        { 0x300a, 0x0199,
          "Fixation Device Pitch Angle", "FixationDevicePitchAngle",  "FL", "1" },
        { 0x300a, 0x019a,
          "Fixation Device Roll Angle", "FixationDeviceRollAngle",  "FL", "1" },
        { 0x300a, 0x01a0,
          "Shielding Device Sequence", "ShieldingDeviceSequence",  "SQ", "1" },
        { 0x300a, 0x01a2,
          "Shielding Device Type", "ShieldingDeviceType",  "CS", "1" },
        { 0x300a, 0x01a4,
          "Shielding Device Label", "ShieldingDeviceLabel",  "SH", "1" },
        { 0x300a, 0x01a6,
          "Shielding Device Description", "ShieldingDeviceDescription",  "ST", "1" },
        { 0x300a, 0x01a8,
          "Shielding Device Position", "ShieldingDevicePosition",  "SH", "1" },
        { 0x300a, 0x01b0,
          "Setup Technique", "SetupTechnique",  "CS", "1" },
        { 0x300a, 0x01b2,
          "Setup Technique Description", "SetupTechniqueDescription",  "ST", "1" },
        { 0x300a, 0x01b4,
          "Setup Device Sequence", "SetupDeviceSequence",  "SQ", "1" },
        { 0x300a, 0x01b6,
          "Setup Device Type", "SetupDeviceType",  "CS", "1" },
        { 0x300a, 0x01b8,
          "Setup Device Label", "SetupDeviceLabel",  "SH", "1" },
        { 0x300a, 0x01ba,
          "Setup Device Description", "SetupDeviceDescription",  "ST", "1" },
        { 0x300a, 0x01bc,
          "Setup Device Parameter", "SetupDeviceParameter",  "DS", "1" },
        { 0x300a, 0x01d0,
          "Setup Reference Description", "SetupReferenceDescription",  "ST", "1" },
        { 0x300a, 0x01d2,
          "Table Top Vertical Setup Displacement", "TableTopVerticalSetupDisplacement",  "DS", "1" },
        { 0x300a, 0x01d4,
          "Table Top Longitudinal Setup Displacement", "TableTopLongitudinalSetupDisplacement",  "DS", "1" },
        { 0x300a, 0x01d6,
          "Table Top Lateral Setup Displacement", "TableTopLateralSetupDisplacement",  "DS", "1" },
        { 0x300a, 0x0200,
          "Brachy Treatment Technique", "BrachyTreatmentTechnique",  "CS", "1" },
        { 0x300a, 0x0202,
          "Brachy Treatment Type", "BrachyTreatmentType",  "CS", "1" },
        { 0x300a, 0x0206,
          "Treatment Machine Sequence", "TreatmentMachineSequence",  "SQ", "1" },
        { 0x300a, 0x0210,
          "Source Sequence", "SourceSequence",  "SQ", "1" },
        { 0x300a, 0x0212,
          "Source Number", "SourceNumber",  "IS", "1" },
        { 0x300a, 0x0214,
          "Source Type", "SourceType",  "CS", "1" },
        { 0x300a, 0x0216,
          "Source Manufacturer", "SourceManufacturer",  "LO", "1" },
        { 0x300a, 0x0218,
          "Active Source Diameter", "ActiveSourceDiameter",  "DS", "1" },
        { 0x300a, 0x021a,
          "Active Source Length", "ActiveSourceLength",  "DS", "1" },
        { 0x300a, 0x021b,
          "Source Model ID", "SourceModelID",  "SH", "1" },
        { 0x300a, 0x021c,
          "Source Description", "SourceDescription",  "LO", "1" },
        { 0x300a, 0x0222,
          "Source Encapsulation Nominal Thickness", "SourceEncapsulationNominalThickness",  "DS", "1" },
        { 0x300a, 0x0224,
          "Source Encapsulation Nominal Transmission", "SourceEncapsulationNominalTransmission",  "DS", "1" },
        { 0x300a, 0x0226,
          "Source Isotope Name", "SourceIsotopeName",  "LO", "1" },
        { 0x300a, 0x0228,
          "Source Isotope Half Life", "SourceIsotopeHalfLife",  "DS", "1" },
        { 0x300a, 0x0229,
          "Source Strength Units", "SourceStrengthUnits",  "CS", "1" },
        { 0x300a, 0x022a,
          "Reference Air Kerma Rate", "ReferenceAirKermaRate",  "DS", "1" },
        { 0x300a, 0x022b,
          "Source Strength", "SourceStrength",  "DS", "1" },
        { 0x300a, 0x022c,
          "Source Strength Reference Date", "SourceStrengthReferenceDate",  "DA", "1" },
        { 0x300a, 0x022e,
          "Source Strength Reference Time", "SourceStrengthReferenceTime",  "TM", "1" },
        { 0x300a, 0x0230,
          "Application Setup Sequence", "ApplicationSetupSequence",  "SQ", "1" },
        { 0x300a, 0x0232,
          "Application Setup Type", "ApplicationSetupType",  "CS", "1" },
        { 0x300a, 0x0234,
          "Application Setup Number", "ApplicationSetupNumber",  "IS", "1" },
        { 0x300a, 0x0236,
          "Application Setup Name", "ApplicationSetupName",  "LO", "1" },
        { 0x300a, 0x0238,
          "Application Setup Manufacturer", "ApplicationSetupManufacturer",  "LO", "1" },
        { 0x300a, 0x0240,
          "Template Number", "TemplateNumber",  "IS", "1" },
        { 0x300a, 0x0242,
          "Template Type", "TemplateType",  "SH", "1" },
        { 0x300a, 0x0244,
          "Template Name", "TemplateName",  "LO", "1" },
        { 0x300a, 0x0250,
          "Total Reference Air Kerma", "TotalReferenceAirKerma",  "DS", "1" },
        { 0x300a, 0x0260,
          "Brachy Accessory Device Sequence", "BrachyAccessoryDeviceSequence",  "SQ", "1" },
        { 0x300a, 0x0262,
          "Brachy Accessory Device Number", "BrachyAccessoryDeviceNumber",  "IS", "1" },
        { 0x300a, 0x0263,
          "Brachy Accessory Device ID", "BrachyAccessoryDeviceID",  "SH", "1" },
        { 0x300a, 0x0264,
          "Brachy Accessory Device Type", "BrachyAccessoryDeviceType",  "CS", "1" },
        { 0x300a, 0x0266,
          "Brachy Accessory Device Name", "BrachyAccessoryDeviceName",  "LO", "1" },
        { 0x300a, 0x026a,
          "Brachy Accessory Device Nominal Thickness", "BrachyAccessoryDeviceNominalThickness",  "DS", "1" },
        { 0x300a, 0x026c,
          "Brachy Accessory Device Nominal Transmission", "BrachyAccessoryDeviceNominalTransmission",  "DS", "1" },
        { 0x300a, 0x0280,
          "Channel Sequence", "ChannelSequence",  "SQ", "1" },
        { 0x300a, 0x0282,
          "Channel Number", "ChannelNumber",  "IS", "1" },
        { 0x300a, 0x0284,
          "Channel Length", "ChannelLength",  "DS", "1" },
        { 0x300a, 0x0286,
          "Channel Total Time", "ChannelTotalTime",  "DS", "1" },
        { 0x300a, 0x0288,
          "Source Movement Type", "SourceMovementType",  "CS", "1" },
        { 0x300a, 0x028a,
          "Number of Pulses", "NumberOfPulses",  "IS", "1" },
        { 0x300a, 0x028c,
          "Pulse Repetition Interval", "PulseRepetitionInterval",  "DS", "1" },
        { 0x300a, 0x0290,
          "Source Applicator Number", "SourceApplicatorNumber",  "IS", "1" },
        { 0x300a, 0x0291,
          "Source Applicator ID", "SourceApplicatorID",  "SH", "1" },
        { 0x300a, 0x0292,
          "Source Applicator Type", "SourceApplicatorType",  "CS", "1" },
        { 0x300a, 0x0294,
          "Source Applicator Name", "SourceApplicatorName",  "LO", "1" },
        { 0x300a, 0x0296,
          "Source Applicator Length", "SourceApplicatorLength",  "DS", "1" },
        { 0x300a, 0x0298,
          "Source Applicator Manufacturer", "SourceApplicatorManufacturer",  "LO", "1" },
        { 0x300a, 0x029c,
          "Source Applicator Wall Nominal Thickness", "SourceApplicatorWallNominalThickness",  "DS", "1" },
        { 0x300a, 0x029e,
          "Source Applicator Wall Nominal Transmission", "SourceApplicatorWallNominalTransmission",  "DS", "1" },
        { 0x300a, 0x02a0,
          "Source Applicator Step Size", "SourceApplicatorStepSize",  "DS", "1" },
        { 0x300a, 0x02a2,
          "Transfer Tube Number", "TransferTubeNumber",  "IS", "1" },
        { 0x300a, 0x02a4,
          "Transfer Tube Length", "TransferTubeLength",  "DS", "1" },
        { 0x300a, 0x02b0,
          "Channel Shield Sequence", "ChannelShieldSequence",  "SQ", "1" },
        { 0x300a, 0x02b2,
          "Channel Shield Number", "ChannelShieldNumber",  "IS", "1" },
        { 0x300a, 0x02b3,
          "Channel Shield ID", "ChannelShieldID",  "SH", "1" },
        { 0x300a, 0x02b4,
          "Channel Shield Name", "ChannelShieldName",  "LO", "1" },
        { 0x300a, 0x02b8,
          "Channel Shield Nominal Thickness", "ChannelShieldNominalThickness",  "DS", "1" },
        { 0x300a, 0x02ba,
          "Channel Shield Nominal Transmission", "ChannelShieldNominalTransmission",  "DS", "1" },
        { 0x300a, 0x02c8,
          "Final Cumulative Time Weight", "FinalCumulativeTimeWeight",  "DS", "1" },
        { 0x300a, 0x02d0,
          "Brachy Control Point Sequence", "BrachyControlPointSequence",  "SQ", "1" },
        { 0x300a, 0x02d2,
          "Control Point Relative Position", "ControlPointRelativePosition",  "DS", "1" },
        { 0x300a, 0x02d4,
          "Control Point 3D Position", "ControlPoint3DPosition",  "DS", "3" },
        { 0x300a, 0x02d6,
          "Cumulative Time Weight", "CumulativeTimeWeight",  "DS", "1" },
        { 0x300a, 0x02e0,
          "Compensator Divergence", "CompensatorDivergence",  "CS", "1" },
        { 0x300a, 0x02e1,
          "Compensator Mounting Position", "CompensatorMountingPosition",  "CS", "1" },
        { 0x300a, 0x02e2,
          "Source to Compensator Distance", "SourceToCompensatorDistance",  "DS", "1-n" },
        { 0x300a, 0x02e3,
          "Total Compensator Tray Water-Equivalent Thickness", "TotalCompensatorTrayWaterEquivalentThickness",  "FL", "1" },
        { 0x300a, 0x02e4,
          "Isocenter to Compensator Tray Distance", "IsocenterToCompensatorTrayDistance",  "FL", "1" },
        { 0x300a, 0x02e5,
          "Compensator Column Offset", "CompensatorColumnOffset",  "FL", "1" },
        { 0x300a, 0x02e6,
          "Isocenter to Compensator Distances", "IsocenterToCompensatorDistances",  "FL", "1-n" },
        { 0x300a, 0x02e7,
          "Compensator Relative Stopping Power Ratio", "CompensatorRelativeStoppingPowerRatio",  "FL", "1" },
        { 0x300a, 0x02e8,
          "Compensator Milling Tool Diameter", "CompensatorMillingToolDiameter",  "FL", "1" },
        { 0x300a, 0x02ea,
          "Ion Range Compensator Sequence", "IonRangeCompensatorSequence",  "SQ", "1" },
        { 0x300a, 0x02eb,
          "Compensator Description", "CompensatorDescription",  "LT", "1" },
        { 0x300a, 0x0302,
          "Radiation Mass Number", "RadiationMassNumber",  "IS", "1" },
        { 0x300a, 0x0304,
          "Radiation Atomic Number", "RadiationAtomicNumber",  "IS", "1" },
        { 0x300a, 0x0306,
          "Radiation Charge State", "RadiationChargeState",  "SS", "1" },
        { 0x300a, 0x0308,
          "Scan Mode", "ScanMode",  "CS", "1" },
        { 0x300a, 0x030a,
          "Virtual Source-Axis Distances", "VirtualSourceAxisDistances",  "FL", "2" },
        { 0x300a, 0x030c,
          "Snout Sequence", "SnoutSequence",  "SQ", "1" },
        { 0x300a, 0x030d,
          "Snout Position", "SnoutPosition",  "FL", "1" },
        { 0x300a, 0x030f,
          "Snout ID", "SnoutID",  "SH", "1" },
        { 0x300a, 0x0312,
          "Number of Range Shifters", "NumberOfRangeShifters",  "IS", "1" },
        { 0x300a, 0x0314,
          "Range Shifter Sequence", "RangeShifterSequence",  "SQ", "1" },
        { 0x300a, 0x0316,
          "Range Shifter Number", "RangeShifterNumber",  "IS", "1" },
        { 0x300a, 0x0318,
          "Range Shifter ID", "RangeShifterID",  "SH", "1" },
        { 0x300a, 0x0320,
          "Range Shifter Type", "RangeShifterType",  "CS", "1" },
        { 0x300a, 0x0322,
          "Range Shifter Description", "RangeShifterDescription",  "LO", "1" },
        { 0x300a, 0x0330,
          "Number of Lateral Spreading Devices", "NumberOfLateralSpreadingDevices",  "IS", "1" },
        { 0x300a, 0x0332,
          "Lateral Spreading Device Sequence", "LateralSpreadingDeviceSequence",  "SQ", "1" },
        { 0x300a, 0x0334,
          "Lateral Spreading Device Number", "LateralSpreadingDeviceNumber",  "IS", "1" },
        { 0x300a, 0x0336,
          "Lateral Spreading Device ID", "LateralSpreadingDeviceID",  "SH", "1" },
        { 0x300a, 0x0338,
          "Lateral Spreading Device Type", "LateralSpreadingDeviceType",  "CS", "1" },
        { 0x300a, 0x033a,
          "Lateral Spreading Device Description", "LateralSpreadingDeviceDescription",  "LO", "1" },
        { 0x300a, 0x033c,
          "Lateral Spreading Device Water Equivalent Thickness", "LateralSpreadingDeviceWaterEquivalentThickness",  "FL", "1" },
        { 0x300a, 0x0340,
          "Number of Range Modulators", "NumberOfRangeModulators",  "IS", "1" },
        { 0x300a, 0x0342,
          "Range Modulator Sequence", "RangeModulatorSequence",  "SQ", "1" },
        { 0x300a, 0x0344,
          "Range Modulator Number", "RangeModulatorNumber",  "IS", "1" },
        { 0x300a, 0x0346,
          "Range Modulator ID", "RangeModulatorID",  "SH", "1" },
        { 0x300a, 0x0348,
          "Range Modulator Type", "RangeModulatorType",  "CS", "1" },
        { 0x300a, 0x034a,
          "Range Modulator Description", "RangeModulatorDescription",  "LO", "1" },
        { 0x300a, 0x034c,
          "Beam Current Modulation ID", "BeamCurrentModulationID",  "SH", "1" },
        { 0x300a, 0x0350,
          "Patient Support Type", "PatientSupportType",  "CS", "1" },
        { 0x300a, 0x0352,
          "Patient Support ID", "PatientSupportID",  "SH", "1" },
        { 0x300a, 0x0354,
          "Patient Support Accessory Code", "PatientSupportAccessoryCode",  "LO", "1" },
        { 0x300a, 0x0356,
          "Fixation Light Azimuthal Angle", "FixationLightAzimuthalAngle",  "FL", "1" },
        { 0x300a, 0x0358,
          "Fixation Light Polar Angle", "FixationLightPolarAngle",  "FL", "1" },
        { 0x300a, 0x035a,
          "Meterset Rate", "MetersetRate",  "FL", "1" },
        { 0x300a, 0x0360,
          "Range Shifter Settings Sequence", "RangeShifterSettingsSequence",  "SQ", "1" },
        { 0x300a, 0x0362,
          "Range Shifter Setting", "RangeShifterSetting",  "LO", "1" },
        { 0x300a, 0x0364,
          "Isocenter to Range Shifter Distance", "IsocenterToRangeShifterDistance",  "FL", "1" },
        { 0x300a, 0x0366,
          "Range Shifter Water Equivalent Thickness", "RangeShifterWaterEquivalentThickness",  "FL", "1" },
        { 0x300a, 0x0370,
          "Lateral Spreading Device Settings Sequence", "LateralSpreadingDeviceSettingsSequence",  "SQ", "1" },
        { 0x300a, 0x0372,
          "Lateral Spreading Device Setting", "LateralSpreadingDeviceSetting",  "LO", "1" },
        { 0x300a, 0x0374,
          "Isocenter to Lateral Spreading Device Distance", "IsocenterToLateralSpreadingDeviceDistance",  "FL", "1" },
        { 0x300a, 0x0380,
          "Range Modulator Settings Sequence", "RangeModulatorSettingsSequence",  "SQ", "1" },
        { 0x300a, 0x0382,
          "Range Modulator Gating Start Value", "RangeModulatorGatingStartValue",  "FL", "1" },
        { 0x300a, 0x0384,
          "Range Modulator Gating Stop Value", "RangeModulatorGatingStopValue",  "FL", "1" },
        { 0x300a, 0x0386,
          "Range Modulator Gating Start Water Equivalent Thickness", "RangeModulatorGatingStartWaterEquivalentThickness",  "FL", "1" },
        { 0x300a, 0x0388,
          "Range Modulator Gating Stop Water Equivalent Thickness", "RangeModulatorGatingStopWaterEquivalentThickness",  "FL", "1" },
        { 0x300a, 0x038a,
          "Isocenter to Range Modulator Distance", "IsocenterToRangeModulatorDistance",  "FL", "1" },
        { 0x300a, 0x0390,
          "Scan Spot Tune ID", "ScanSpotTuneID",  "SH", "1" },
        { 0x300a, 0x0392,
          "Number of Scan Spot Positions", "NumberOfScanSpotPositions",  "IS", "1" },
        { 0x300a, 0x0394,
          "Scan Spot Position Map", "ScanSpotPositionMap",  "FL", "1-n" },
        { 0x300a, 0x0396,
          "Scan Spot Meterset Weights", "ScanSpotMetersetWeights",  "FL", "1-n" },
        { 0x300a, 0x0398,
          "Scanning Spot Size", "ScanningSpotSize",  "FL", "2" },
        { 0x300a, 0x039a,
          "Number of Paintings", "NumberOfPaintings",  "IS", "1" },
        { 0x300a, 0x03a0,
          "Ion Tolerance Table Sequence", "IonToleranceTableSequence",  "SQ", "1" },
        { 0x300a, 0x03a2,
          "Ion Beam Sequence", "IonBeamSequence",  "SQ", "1" },
        { 0x300a, 0x03a4,
          "Ion Beam Limiting Device Sequence", "IonBeamLimitingDeviceSequence",  "SQ", "1" },
        { 0x300a, 0x03a6,
          "Ion Block Sequence", "IonBlockSequence",  "SQ", "1" },
        { 0x300a, 0x03a8,
          "Ion Control Point Sequence", "IonControlPointSequence",  "SQ", "1" },
        { 0x300a, 0x03aa,
          "Ion Wedge Sequence", "IonWedgeSequence",  "SQ", "1" },
        { 0x300a, 0x03ac,
          "Ion Wedge Position Sequence", "IonWedgePositionSequence",  "SQ", "1" },
        { 0x300a, 0x0401,
          "Referenced Setup Image Sequence", "ReferencedSetupImageSequence",  "SQ", "1" },
        { 0x300a, 0x0402,
          "Setup Image Comment", "SetupImageComment",  "ST", "1" },
        { 0x300a, 0x0410,
          "Motion Synchronization Sequence", "MotionSynchronizationSequence",  "SQ", "1" },
        { 0x300a, 0x0412,
          "Control Point Orientation", "ControlPointOrientation",  "FL", "3" },
        { 0x300a, 0x0420,
          "General Accessory Sequence", "GeneralAccessorySequence",  "SQ", "1" },
        { 0x300a, 0x0421,
          "General Accessory ID", "GeneralAccessoryID",  "SH", "1" },
        { 0x300a, 0x0422,
          "General Accessory Description", "GeneralAccessoryDescription",  "ST", "1" },
        { 0x300a, 0x0423,
          "General Accessory Type", "GeneralAccessoryType",  "CS", "1" },
        { 0x300a, 0x0424,
          "General Accessory Number", "GeneralAccessoryNumber",  "IS", "1" },
        { 0x300a, 0x0425,
          "Source to General Accessory Distance", "SourceToGeneralAccessoryDistance",  "FL", "1" },
        { 0x300a, 0x0431,
          "Applicator Geometry Sequence", "ApplicatorGeometrySequence",  "SQ", "1" },
        { 0x300a, 0x0432,
          "Applicator Aperture Shape", "ApplicatorApertureShape",  "CS", "1" },
        { 0x300a, 0x0433,
          "Applicator Opening", "ApplicatorOpening",  "FL", "1" },
        { 0x300a, 0x0434,
          "Applicator Opening X", "ApplicatorOpeningX",  "FL", "1" },
        { 0x300a, 0x0435,
          "Applicator Opening Y", "ApplicatorOpeningY",  "FL", "1" },
        { 0x300a, 0x0436,
          "Source to Applicator Mounting Position Distance", "SourceToApplicatorMountingPositionDistance",  "FL", "1" },
        { 0x300a, 0x0440,
          "Number of Block Slab Items", "NumberOfBlockSlabItems",  "IS", "1" },
        { 0x300a, 0x0441,
          "Block Slab Sequence", "BlockSlabSequence",  "SQ", "1" },
        { 0x300a, 0x0442,
          "Block Slab Thickness", "BlockSlabThickness",  "DS", "1" },
        { 0x300a, 0x0443,
          "Block Slab Number", "BlockSlabNumber",  "US", "1" },
        { 0x300a, 0x0450,
          "Device Motion Control Sequence", "DeviceMotionControlSequence",  "SQ", "1" },
        { 0x300a, 0x0451,
          "Device Motion Execution Mode", "DeviceMotionExecutionMode",  "CS", "1" },
        { 0x300a, 0x0452,
          "Device Motion Observation Mode", "DeviceMotionObservationMode",  "CS", "1" },
        { 0x300a, 0x0453,
          "Device Motion Parameter Code Sequence", "DeviceMotionParameterCodeSequence",  "SQ", "1" },
        { 0x300c, 0x0002,
          "Referenced RT Plan Sequence", "ReferencedRTPlanSequence",  "SQ", "1" },
        { 0x300c, 0x0004,
          "Referenced Beam Sequence", "ReferencedBeamSequence",  "SQ", "1" },
        { 0x300c, 0x0006,
          "Referenced Beam Number", "ReferencedBeamNumber",  "IS", "1" },
        { 0x300c, 0x0007,
          "Referenced Reference Image Number", "ReferencedReferenceImageNumber",  "IS", "1" },
        { 0x300c, 0x0008,
          "Start Cumulative Meterset Weight", "StartCumulativeMetersetWeight",  "DS", "1" },
        { 0x300c, 0x0009,
          "End Cumulative Meterset Weight", "EndCumulativeMetersetWeight",  "DS", "1" },
        { 0x300c, 0x000a,
          "Referenced Brachy Application Setup Sequence", "ReferencedBrachyApplicationSetupSequence",  "SQ", "1" },
        { 0x300c, 0x000c,
          "Referenced Brachy Application Setup Number", "ReferencedBrachyApplicationSetupNumber",  "IS", "1" },
        { 0x300c, 0x000e,
          "Referenced Source Number", "ReferencedSourceNumber",  "IS", "1" },
        { 0x300c, 0x0020,
          "Referenced Fraction Group Sequence", "ReferencedFractionGroupSequence",  "SQ", "1" },
        { 0x300c, 0x0022,
          "Referenced Fraction Group Number", "ReferencedFractionGroupNumber",  "IS", "1" },
        { 0x300c, 0x0040,
          "Referenced Verification Image Sequence", "ReferencedVerificationImageSequence",  "SQ", "1" },
        { 0x300c, 0x0042,
          "Referenced Reference Image Sequence", "ReferencedReferenceImageSequence",  "SQ", "1" },
        { 0x300c, 0x0050,
          "Referenced Dose Reference Sequence", "ReferencedDoseReferenceSequence",  "SQ", "1" },
        { 0x300c, 0x0051,
          "Referenced Dose Reference Number", "ReferencedDoseReferenceNumber",  "IS", "1" },
        { 0x300c, 0x0055,
          "Brachy Referenced Dose Reference Sequence", "BrachyReferencedDoseReferenceSequence",  "SQ", "1" },
        { 0x300c, 0x0060,
          "Referenced Structure Set Sequence", "ReferencedStructureSetSequence",  "SQ", "1" },
        { 0x300c, 0x006a,
          "Referenced Patient Setup Number", "ReferencedPatientSetupNumber",  "IS", "1" },
        { 0x300c, 0x0080,
          "Referenced Dose Sequence", "ReferencedDoseSequence",  "SQ", "1" },
        { 0x300c, 0x00a0,
          "Referenced Tolerance Table Number", "ReferencedToleranceTableNumber",  "IS", "1" },
        { 0x300c, 0x00b0,
          "Referenced Bolus Sequence", "ReferencedBolusSequence",  "SQ", "1" },
        { 0x300c, 0x00c0,
          "Referenced Wedge Number", "ReferencedWedgeNumber",  "IS", "1" },
        { 0x300c, 0x00d0,
          "Referenced Compensator Number", "ReferencedCompensatorNumber",  "IS", "1" },
        { 0x300c, 0x00e0,
          "Referenced Block Number", "ReferencedBlockNumber",  "IS", "1" },
        { 0x300c, 0x00f0,
          "Referenced Control Point Index", "ReferencedControlPointIndex",  "IS", "1" },
        { 0x300c, 0x00f2,
          "Referenced Control Point Sequence", "ReferencedControlPointSequence",  "SQ", "1" },
        { 0x300c, 0x00f4,
          "Referenced Start Control Point Index", "ReferencedStartControlPointIndex",  "IS", "1" },
        { 0x300c, 0x00f6,
          "Referenced Stop Control Point Index", "ReferencedStopControlPointIndex",  "IS", "1" },
        { 0x300c, 0x0100,
          "Referenced Range Shifter Number", "ReferencedRangeShifterNumber",  "IS", "1" },
        { 0x300c, 0x0102,
          "Referenced Lateral Spreading Device Number", "ReferencedLateralSpreadingDeviceNumber",  "IS", "1" },
        { 0x300c, 0x0104,
          "Referenced Range Modulator Number", "ReferencedRangeModulatorNumber",  "IS", "1" },
        { 0x300c, 0x0111,
          "Omitted Beam Task Sequence", "OmittedBeamTaskSequence",  "SQ", "1" },
        { 0x300c, 0x0112,
          "Reason for Omission", "ReasonForOmission",  "CS", "1" },
        { 0x300c, 0x0113,
          "Reason for Omission Description", "ReasonForOmissionDescription",  "LO", "1" },
        { 0x300e, 0x0002,
          "Approval Status", "ApprovalStatus",  "CS", "1" },
        { 0x300e, 0x0004,
          "Review Date", "ReviewDate",  "DA", "1" },
        { 0x300e, 0x0005,
          "Review Time", "ReviewTime",  "TM", "1" },
        { 0x300e, 0x0008,
          "Reviewer Name", "ReviewerName",  "PN", "1" },
        { 0x4000, 0x0010,
          "Arbitrary", "Arbitrary",  "LT", "1" },
        { 0x4000, 0x4000,
          "Text Comments", "TextComments",  "LT", "1" },
        { 0x4008, 0x0040,
          "Results ID", "ResultsID",  "SH", "1" },
        { 0x4008, 0x0042,
          "Results ID Issuer", "ResultsIDIssuer",  "LO", "1" },
        { 0x4008, 0x0050,
          "Referenced Interpretation Sequence", "ReferencedInterpretationSequence",  "SQ", "1" },
        { 0x4008, 0x00ff,
          "Report Production Status (Trial)", "ReportProductionStatusTrial",  "CS", "1" },
        { 0x4008, 0x0100,
          "Interpretation Recorded Date", "InterpretationRecordedDate",  "DA", "1" },
        { 0x4008, 0x0101,
          "Interpretation Recorded Time", "InterpretationRecordedTime",  "TM", "1" },
        { 0x4008, 0x0102,
          "Interpretation Recorder", "InterpretationRecorder",  "PN", "1" },
        { 0x4008, 0x0103,
          "Reference to Recorded Sound", "ReferenceToRecordedSound",  "LO", "1" },
        { 0x4008, 0x0108,
          "Interpretation Transcription Date", "InterpretationTranscriptionDate",  "DA", "1" },
        { 0x4008, 0x0109,
          "Interpretation Transcription Time", "InterpretationTranscriptionTime",  "TM", "1" },
        { 0x4008, 0x010a,
          "Interpretation Transcriber", "InterpretationTranscriber",  "PN", "1" },
        { 0x4008, 0x010b,
          "Interpretation Text", "InterpretationText",  "ST", "1" },
        { 0x4008, 0x010c,
          "Interpretation Author", "InterpretationAuthor",  "PN", "1" },
        { 0x4008, 0x0111,
          "Interpretation Approver Sequence", "InterpretationApproverSequence",  "SQ", "1" },
        { 0x4008, 0x0112,
          "Interpretation Approval Date", "InterpretationApprovalDate",  "DA", "1" },
        { 0x4008, 0x0113,
          "Interpretation Approval Time", "InterpretationApprovalTime",  "TM", "1" },
        { 0x4008, 0x0114,
          "Physician Approving Interpretation", "PhysicianApprovingInterpretation",  "PN", "1" },
        { 0x4008, 0x0115,
          "Interpretation Diagnosis Description", "InterpretationDiagnosisDescription",  "LT", "1" },
        { 0x4008, 0x0117,
          "Interpretation Diagnosis Code Sequence", "InterpretationDiagnosisCodeSequence",  "SQ", "1" },
        { 0x4008, 0x0118,
          "Results Distribution List Sequence", "ResultsDistributionListSequence",  "SQ", "1" },
        { 0x4008, 0x0119,
          "Distribution Name", "DistributionName",  "PN", "1" },
        { 0x4008, 0x011a,
          "Distribution Address", "DistributionAddress",  "LO", "1" },
        { 0x4008, 0x0200,
          "Interpretation ID", "InterpretationID",  "SH", "1" },
        { 0x4008, 0x0202,
          "Interpretation ID Issuer", "InterpretationIDIssuer",  "LO", "1" },
        { 0x4008, 0x0210,
          "Interpretation Type ID", "InterpretationTypeID",  "CS", "1" },
        { 0x4008, 0x0212,
          "Interpretation Status ID", "InterpretationStatusID",  "CS", "1" },
        { 0x4008, 0x0300,
          "Impressions", "Impressions",  "ST", "1" },
        { 0x4008, 0x4000,
          "Results Comments", "ResultsComments",  "ST", "1" },
        { 0x4010, 0x0001,
          "Low Energy Detectors", "LowEnergyDetectors",  "CS", "1" },
        { 0x4010, 0x0002,
          "High Energy Detectors", "HighEnergyDetectors",  "CS", "1" },
        { 0x4010, 0x0004,
          "Detector Geometry Sequence", "DetectorGeometrySequence",  "SQ", "1" },
        { 0x4010, 0x1001,
          "Threat ROI Voxel Sequence", "ThreatROIVoxelSequence",  "SQ", "1" },
        { 0x4010, 0x1004,
          "Threat ROI Base", "ThreatROIBase",  "FL", "3" },
        { 0x4010, 0x1005,
          "Threat ROI Extents", "ThreatROIExtents",  "FL", "3" },
        { 0x4010, 0x1006,
          "Threat ROI Bitmap", "ThreatROIBitmap",  "OB", "1" },
        { 0x4010, 0x1007,
          "Route Segment ID", "RouteSegmentID",  "SH", "1" },
        { 0x4010, 0x1008,
          "Gantry Type", "GantryType",  "CS", "1" },
        { 0x4010, 0x1009,
          "OOI Owner Type", "OOIOwnerType",  "CS", "1" },
        { 0x4010, 0x100a,
          "Route Segment Sequence", "RouteSegmentSequence",  "SQ", "1" },
        { 0x4010, 0x1010,
          "Potential Threat Object ID", "PotentialThreatObjectID",  "US", "1" },
        { 0x4010, 0x1011,
          "Threat Sequence", "ThreatSequence",  "SQ", "1" },
        { 0x4010, 0x1012,
          "Threat Category", "ThreatCategory",  "CS", "1" },
        { 0x4010, 0x1013,
          "Threat Category Description", "ThreatCategoryDescription",  "LT", "1" },
        { 0x4010, 0x1014,
          "ATD Ability Assessment", "ATDAbilityAssessment",  "CS", "1" },
        { 0x4010, 0x1015,
          "ATD Assessment Flag", "ATDAssessmentFlag",  "CS", "1" },
        { 0x4010, 0x1016,
          "ATD Assessment Probability", "ATDAssessmentProbability",  "FL", "1" },
        { 0x4010, 0x1017,
          "Mass", "Mass",  "FL", "1" },
        { 0x4010, 0x1018,
          "Density", "Density",  "FL", "1" },
        { 0x4010, 0x1019,
          "Z Effective", "ZEffective",  "FL", "1" },
        { 0x4010, 0x101a,
          "Boarding Pass ID", "BoardingPassID",  "SH", "1" },
        { 0x4010, 0x101b,
          "Center of Mass", "CenterOfMass",  "FL", "3" },
        { 0x4010, 0x101c,
          "Center of PTO", "CenterOfPTO",  "FL", "3" },
        { 0x4010, 0x101d,
          "Bounding Polygon", "BoundingPolygon",  "FL", "6-n" },
        { 0x4010, 0x101e,
          "Route Segment Start Location ID", "RouteSegmentStartLocationID",  "SH", "1" },
        { 0x4010, 0x101f,
          "Route Segment End Location ID", "RouteSegmentEndLocationID",  "SH", "1" },
        { 0x4010, 0x1020,
          "Route Segment Location ID Type", "RouteSegmentLocationIDType",  "CS", "1" },
        { 0x4010, 0x1021,
          "Abort Reason", "AbortReason",  "CS", "1-n" },
        { 0x4010, 0x1023,
          "Volume of PTO", "VolumeOfPTO",  "FL", "1" },
        { 0x4010, 0x1024,
          "Abort Flag", "AbortFlag",  "CS", "1" },
        { 0x4010, 0x1025,
          "Route Segment Start Time", "RouteSegmentStartTime",  "DT", "1" },
        { 0x4010, 0x1026,
          "Route Segment End Time", "RouteSegmentEndTime",  "DT", "1" },
        { 0x4010, 0x1027,
          "TDR Type", "TDRType",  "CS", "1" },
        { 0x4010, 0x1028,
          "International Route Segment", "InternationalRouteSegment",  "CS", "1" },
        { 0x4010, 0x1029,
          "Threat Detection Algorithm and Version", "ThreatDetectionAlgorithmandVersion",  "LO", "1-n" },
        { 0x4010, 0x102a,
          "Assigned Location", "AssignedLocation",  "SH", "1" },
        { 0x4010, 0x102b,
          "Alarm Decision Time", "AlarmDecisionTime",  "DT", "1" },
        { 0x4010, 0x1031,
          "Alarm Decision", "AlarmDecision",  "CS", "1" },
        { 0x4010, 0x1033,
          "Number of Total Objects", "NumberOfTotalObjects",  "US", "1" },
        { 0x4010, 0x1034,
          "Number of Alarm Objects", "NumberOfAlarmObjects",  "US", "1" },
        { 0x4010, 0x1037,
          "PTO Representation Sequence", "PTORepresentationSequence",  "SQ", "1" },
        { 0x4010, 0x1038,
          "ATD Assessment Sequence", "ATDAssessmentSequence",  "SQ", "1" },
        { 0x4010, 0x1039,
          "TIP Type", "TIPType",  "CS", "1" },
        { 0x4010, 0x103a,
          "DICOS Version", "DICOSVersion",  "CS", "1" },
        { 0x4010, 0x1041,
          "OOI Owner Creation Time", "OOIOwnerCreationTime",  "DT", "1" },
        { 0x4010, 0x1042,
          "OOI Type", "OOIType",  "CS", "1" },
        { 0x4010, 0x1043,
          "OOI Size", "OOISize",  "FL", "3" },
        { 0x4010, 0x1044,
          "Acquisition Status", "AcquisitionStatus",  "CS", "1" },
        { 0x4010, 0x1045,
          "Basis Materials Code Sequence", "BasisMaterialsCodeSequence",  "SQ", "1" },
        { 0x4010, 0x1046,
          "Phantom Type", "PhantomType",  "CS", "1" },
        { 0x4010, 0x1047,
          "OOI Owner Sequence", "OOIOwnerSequence",  "SQ", "1" },
        { 0x4010, 0x1048,
          "Scan Type", "ScanType",  "CS", "1" },
        { 0x4010, 0x1051,
          "Itinerary ID", "ItineraryID",  "LO", "1" },
        { 0x4010, 0x1052,
          "Itinerary ID Type", "ItineraryIDType",  "SH", "1" },
        { 0x4010, 0x1053,
          "Itinerary ID Assigning Authority", "ItineraryIDAssigningAuthority",  "LO", "1" },
        { 0x4010, 0x1054,
          "Route ID", "RouteID",  "SH", "1" },
        { 0x4010, 0x1055,
          "Route ID Assigning Authority", "RouteIDAssigningAuthority",  "SH", "1" },
        { 0x4010, 0x1056,
          "Inbound Arrival Type", "InboundArrivalType",  "CS", "1" },
        { 0x4010, 0x1058,
          "Carrier ID", "CarrierID",  "SH", "1" },
        { 0x4010, 0x1059,
          "Carrier ID Assigning Authority", "CarrierIDAssigningAuthority",  "CS", "1" },
        { 0x4010, 0x1060,
          "Source Orientation", "SourceOrientation",  "FL", "3" },
        { 0x4010, 0x1061,
          "Source Position", "SourcePosition",  "FL", "3" },
        { 0x4010, 0x1062,
          "Belt Height", "BeltHeight",  "FL", "1" },
        { 0x4010, 0x1064,
          "Algorithm Routing Code Sequence", "AlgorithmRoutingCodeSequence",  "SQ", "1" },
        { 0x4010, 0x1067,
          "Transport Classification", "TransportClassification",  "CS", "1" },
        { 0x4010, 0x1068,
          "OOI Type Descriptor", "OOITypeDescriptor",  "LT", "1" },
        { 0x4010, 0x1069,
          "Total Processing Time", "TotalProcessingTime",  "FL", "1" },
        { 0x4010, 0x106c,
          "Detector Calibration Data", "DetectorCalibrationData",  "OB", "1" },
        { 0x4010, 0x106d,
          "Additional Screening Performed", "AdditionalScreeningPerformed",  "CS", "1" },
        { 0x4010, 0x106e,
          "Additional Inspection Selection Criteria", "AdditionalInspectionSelectionCriteria",  "CS", "1" },
        { 0x4010, 0x106f,
          "Additional Inspection Method Sequence", "AdditionalInspectionMethodSequence",  "SQ", "1" },
        { 0x4010, 0x1070,
          "AIT Device Type", "AITDeviceType",  "CS", "1" },
        { 0x4010, 0x1071,
          "QR Measurements Sequence", "QRMeasurementsSequence",  "SQ", "1" },
        { 0x4010, 0x1072,
          "Target Material Sequence", "TargetMaterialSequence",  "SQ", "1" },
        { 0x4010, 0x1073,
          "SNR Threshold", "SNRThreshold",  "FD", "1" },
        { 0x4010, 0x1075,
          "Image Scale Representation", "ImageScaleRepresentation",  "DS", "1" },
        { 0x4010, 0x1076,
          "Referenced PTO Sequence", "ReferencedPTOSequence",  "SQ", "1" },
        { 0x4010, 0x1077,
          "Referenced TDR Instance Sequence", "ReferencedTDRInstanceSequence",  "SQ", "1" },
        { 0x4010, 0x1078,
          "PTO Location Description", "PTOLocationDescription",  "ST", "1" },
        { 0x4010, 0x1079,
          "Anomaly Locator Indicator Sequence", "AnomalyLocatorIndicatorSequence",  "SQ", "1" },
        { 0x4010, 0x107a,
          "Anomaly Locator Indicator", "AnomalyLocatorIndicator",  "FL", "3" },
        { 0x4010, 0x107b,
          "PTO Region Sequence", "PTORegionSequence",  "SQ", "1" },
        { 0x4010, 0x107c,
          "Inspection Selection Criteria", "InspectionSelectionCriteria",  "CS", "1" },
        { 0x4010, 0x107d,
          "Secondary Inspection Method Sequence", "SecondaryInspectionMethodSequence",  "SQ", "1" },
        { 0x4010, 0x107e,
          "PRCS to RCS Orientation", "PRCSToRCSOrientation",  "DS", "6" },
        { 0x4ffe, 0x0001,
          "MAC Parameters Sequence", "MACParametersSequence",  "SQ", "1" },
        { 0x5200, 0x9229,
          "Shared Functional Groups Sequence", "SharedFunctionalGroupsSequence",  "SQ", "1" },
        { 0x5200, 0x9230,
          "Per-frame Functional Groups Sequence", "PerFrameFunctionalGroupsSequence",  "SQ", "1" },
        { 0x5400, 0x0100,
          "Waveform Sequence", "WaveformSequence",  "SQ", "1" },
        { 0x5400, 0x0110,
          "Channel Minimum Value", "ChannelMinimumValue",  "OB or OW", "1" },
        { 0x5400, 0x0112,
          "Channel Maximum Value", "ChannelMaximumValue",  "OB or OW", "1" },
        { 0x5400, 0x1004,
          "Waveform Bits Allocated", "WaveformBitsAllocated",  "US", "1" },
        { 0x5400, 0x1006,
          "Waveform Sample Interpretation", "WaveformSampleInterpretation",  "CS", "1" },
        { 0x5400, 0x100a,
          "Waveform Padding Value", "WaveformPaddingValue",  "OB or OW", "1" },
        { 0x5400, 0x1010,
          "Waveform Data", "WaveformData",  "OB or OW", "1" },
        { 0x5600, 0x0010,
          "First Order Phase Correction Angle", "FirstOrderPhaseCorrectionAngle",  "OF", "1" },
        { 0x5600, 0x0020,
          "Spectroscopy Data", "SpectroscopyData",  "OF", "1" },
        { 0x7fe0, 0x0008,
          "Float Pixel Data", "FloatPixelData",  "OF", "1" },
        { 0x7fe0, 0x0009,
          "Double Float Pixel Data", "DoubleFloatPixelData",  "OD", "1" },
        { 0x7fe0, 0x0010,
          "Pixel Data", "PixelData",  "OB or OW", "1" },
        { 0x7fe0, 0x0020,
          "Coefficients SDVN", "CoefficientsSDVN",  "OW", "1" },
        { 0x7fe0, 0x0030,
          "Coefficients SDHN", "CoefficientsSDHN",  "OW", "1" },
        { 0x7fe0, 0x0040,
          "Coefficients SDDN", "CoefficientsSDDN",  "OW", "1" },
        { 0xfffa, 0xfffa,
          "Digital Signatures Sequence", "DigitalSignaturesSequence",  "SQ", "1" },
        { 0xfffc, 0xfffc,
          "Data Set Trailing Padding", "DataSetTrailingPadding",  "OB", "1" },
        { 0xfffe, 0xe000,
          "Item", "Item",  "See Note ", "1" },
        { 0xfffe, 0xe00d,
          "Item Delimitation Item", "ItemDelimitationItem",  "See Note ", "1" },
        { 0xfffe, 0xe0dd,
          "Sequence Delimitation Item", "SequenceDelimitationItem",  "See Note ", "1" },
    };

    ElementsDictionary public_dictionary;
    
    unsigned long const count = sizeof(raw_entries)/sizeof(RawElementsDictionaryEntry);
    for(unsigned long i=0; i<count; ++i)
    {
        RawElementsDictionaryEntry const & raw_entry = raw_entries[i];
        Tag const tag(raw_entry.group, raw_entry.element);
        ElementsDictionaryEntry const entry(
            raw_entry.name, raw_entry.keyword, raw_entry.vr, raw_entry.vm);
        public_dictionary.insert(std::pair<Tag, ElementsDictionaryEntry>(tag, entry));
    }

    return public_dictionary;
}

struct RawUIDsDictionaryEntry
{
    char const * uid;
    char const * name;
    char const * keyword;
    char const * type;
};

UIDsDictionary create_uids_dictionary()
{

    RawUIDsDictionaryEntry raw_entries[] = {
        { "1.2.840.10008.1.1", "Verification SOP Class", "VerificationSOPClass",  "SOP Class" },
        { "1.2.840.10008.1.2", "Implicit VR Little Endian: Default Transfer Syntax for DICOM", "ImplicitVRLittleEndian",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.1", "Explicit VR Little Endian", "ExplicitVRLittleEndian",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.1.99", "Deflated Explicit VR Little Endian", "DeflatedExplicitVRLittleEndian",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.2", "Explicit VR Big Endian (Retired)", "ExplicitVRBigEndian_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.50", "JPEG Baseline (Process 1): Default Transfer Syntax for Lossy JPEG 8 Bit Image Compression", "JPEGBaselineProcess1",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.51", "JPEG Extended (Process 2 & 4): Default Transfer Syntax for Lossy JPEG 12 Bit Image Compression (Process 4 only)", "JPEGExtendedProcess24",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.52", "JPEG Extended (Process 3 & 5) (Retired)", "JPEGExtendedProcess35_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.53", "JPEG Spectral Selection, Non-Hierarchical (Process 6 & 8) (Retired)", "JPEGSpectralSelectionNonHierarchicalProcess68_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.54", "JPEG Spectral Selection, Non-Hierarchical (Process 7 & 9) (Retired)", "JPEGSpectralSelectionNonHierarchicalProcess79_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.55", "JPEG Full Progression, Non-Hierarchical (Process 10 & 12) (Retired)", "JPEGFullProgressionNonHierarchicalProcess1012_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.56", "JPEG Full Progression, Non-Hierarchical (Process 11 & 13) (Retired)", "JPEGFullProgressionNonHierarchicalProcess1113_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.57", "JPEG Lossless, Non-Hierarchical (Process 14)", "JPEGLosslessNonHierarchicalProcess14",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.58", "JPEG Lossless, Non-Hierarchical (Process 15) (Retired)", "JPEGLosslessNonHierarchicalProcess15_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.59", "JPEG Extended, Hierarchical (Process 16 & 18) (Retired)", "JPEGExtendedHierarchicalProcess1618_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.60", "JPEG Extended, Hierarchical (Process 17 & 19) (Retired)", "JPEGExtendedHierarchicalProcess1719_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.61", "JPEG Spectral Selection, Hierarchical (Process 20 & 22) (Retired)", "JPEGSpectralSelectionHierarchicalProcess2022_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.62", "JPEG Spectral Selection, Hierarchical (Process 21 & 23) (Retired)", "JPEGSpectralSelectionHierarchicalProcess2123_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.63", "JPEG Full Progression, Hierarchical (Process 24 & 26) (Retired)", "JPEGFullProgressionHierarchicalProcess2426_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.64", "JPEG Full Progression, Hierarchical (Process 25 & 27) (Retired)", "JPEGFullProgressionHierarchicalProcess2527_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.65", "JPEG Lossless, Hierarchical (Process 28) (Retired)", "JPEGLosslessHierarchicalProcess28_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.66", "JPEG Lossless, Hierarchical (Process 29) (Retired)", "JPEGLosslessHierarchicalProcess29_Retired",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.70", "JPEG Lossless, Non-Hierarchical, First-Order Prediction (Process 14 [Selection Value 1]): Default Transfer Syntax for Lossless JPEG Image Compression", "JPEGLosslessNonHierarchicalFirstOrderPredictionProcess14SelectionValue1",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.80", "JPEG-LS Lossless Image Compression", "JPEGLSLosslessImageCompression",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.81", "JPEG-LS Lossy (Near-Lossless) Image Compression", "JPEGLSLossyNearLosslessImageCompression",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.90", "JPEG 2000 Image Compression (Lossless Only)", "JPEG2000ImageCompressionLosslessOnly",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.91", "JPEG 2000 Image Compression", "JPEG2000ImageCompression",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.92", "JPEG 2000 Part 2 Multi-component Image Compression (Lossless Only)", "JPEG2000Part2MulticomponentImageCompressionLosslessOnly",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.93", "JPEG 2000 Part 2 Multi-component Image Compression", "JPEG2000Part2MulticomponentImageCompression",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.94", "JPIP Referenced", "JPIPReferenced",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.95", "JPIP Referenced Deflate", "JPIPReferencedDeflate",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.100", "MPEG2 Main Profile @ Main Level", "MPEG2MainProfileMainLevel",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.101", "MPEG2 Main Profile @ High Level", "MPEG2MainProfileHighLevel",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.102", "MPEG-4 AVC/H.264 High Profile / Level 4.1", "MPEG4AVCH264HighProfileLevel41",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.103", "MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1", "MPEG4AVCH264BDcompatibleHighProfileLevel41",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.104", "MPEG-4 AVC/H.264 High Profile / Level 4.2 For 2D Video", "MPEG4AVCH264HighProfileLevel42For2DVideo",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.105", "MPEG-4 AVC/H.264 High Profile / Level 4.2 For 3D Video", "MPEG4AVCH264HighProfileLevel42For3DVideo",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.4.106", "MPEG-4 AVC/H.264 Stereo High Profile / Level 4.2", "MPEG4AVCH264StereoHighProfileLevel42",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.5", "RLE Lossless", "RLELossless",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.6.1", "RFC 2557 MIME encapsulation", "RFC2557MIMEencapsulation",  "Transfer Syntax" },
        { "1.2.840.10008.1.2.6.2", "XML Encoding", "XMLEncoding",  "Transfer Syntax" },
        { "1.2.840.10008.1.3.10", "Media Storage Directory Storage", "MediaStorageDirectoryStorage",  "SOP Class" },
        { "1.2.840.10008.1.4.1.1", "Talairach Brain Atlas Frame of Reference", "TalairachBrainAtlasFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.2", "SPM2 T1 Frame of Reference", "SPM2T1FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.3", "SPM2 T2 Frame of Reference", "SPM2T2FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.4", "SPM2 PD Frame of Reference", "SPM2PDFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.5", "SPM2 EPI Frame of Reference", "SPM2EPIFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.6", "SPM2 FIL T1 Frame of Reference", "SPM2FILT1FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.7", "SPM2 PET Frame of Reference", "SPM2PETFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.8", "SPM2 TRANSM Frame of Reference", "SPM2TRANSMFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.9", "SPM2 SPECT Frame of Reference", "SPM2SPECTFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.10", "SPM2 GRAY Frame of Reference", "SPM2GRAYFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.11", "SPM2 WHITE Frame of Reference", "SPM2WHITEFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.12", "SPM2 CSF Frame of Reference", "SPM2CSFFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.13", "SPM2 BRAINMASK Frame of Reference", "SPM2BRAINMASKFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.14", "SPM2 AVG305T1 Frame of Reference", "SPM2AVG305T1FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.15", "SPM2 AVG152T1 Frame of Reference", "SPM2AVG152T1FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.16", "SPM2 AVG152T2 Frame of Reference", "SPM2AVG152T2FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.17", "SPM2 AVG152PD Frame of Reference", "SPM2AVG152PDFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.1.18", "SPM2 SINGLESUBJT1 Frame of Reference", "SPM2SINGLESUBJT1FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.2.1", "ICBM 452 T1 Frame of Reference", "ICBM452T1FrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.4.2.2", "ICBM Single Subject MRI Frame of Reference", "ICBMSingleSubjectMRIFrameofReference",  "Well-known frame of reference" },
        { "1.2.840.10008.1.5.1", "Hot Iron Color Palette SOP Instance", "HotIronColorPaletteSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.1.5.2", "PET Color Palette SOP Instance", "PETColorPaletteSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.1.5.3", "Hot Metal Blue Color Palette SOP Instance", "HotMetalBlueColorPaletteSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.1.5.4", "PET 20 Step Color Palette SOP Instance", "PET20StepColorPaletteSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.1.9", "Basic Study Content Notification SOP Class (Retired)", "BasicStudyContentNotificationSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.1.20.1", "Storage Commitment Push Model SOP Class", "StorageCommitmentPushModelSOPClass",  "SOP Class" },
        { "1.2.840.10008.1.20.1.1", "Storage Commitment Push Model SOP Instance", "StorageCommitmentPushModelSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.1.20.2", "Storage Commitment Pull Model SOP Class (Retired)", "StorageCommitmentPullModelSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.1.20.2.1", "Storage Commitment Pull Model SOP Instance (Retired)", "StorageCommitmentPullModelSOPInstance_Retired",  "Well-known SOP Instance" },
        { "1.2.840.10008.1.40", "Procedural Event Logging SOP Class", "ProceduralEventLoggingSOPClass",  "SOP Class" },
        { "1.2.840.10008.1.40.1", "Procedural Event Logging SOP Instance", "ProceduralEventLoggingSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.1.42", "Substance Administration Logging SOP Class", "SubstanceAdministrationLoggingSOPClass",  "SOP Class" },
        { "1.2.840.10008.1.42.1", "Substance Administration Logging SOP Instance", "SubstanceAdministrationLoggingSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.2.6.1", "DICOM UID Registry", "DICOMUIDRegistry",  "DICOM UIDs as a Coding Scheme" },
        { "1.2.840.10008.2.16.4", "DICOM Controlled Terminology", "DICOMControlledTerminology",  "Coding Scheme" },
        { "1.2.840.10008.3.1.1.1", "DICOM Application Context Name", "DICOMApplicationContextName",  "Application Context Name" },
        { "1.2.840.10008.3.1.2.1.1", "Detached Patient Management SOP Class (Retired)", "DetachedPatientManagementSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.3.1.2.1.4", "Detached Patient Management Meta SOP Class (Retired)", "DetachedPatientManagementMetaSOPClass_Retired",  "Meta SOP Class" },
        { "1.2.840.10008.3.1.2.2.1", "Detached Visit Management SOP Class (Retired)", "DetachedVisitManagementSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.3.1.2.3.1", "Detached Study Management SOP Class (Retired)", "DetachedStudyManagementSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.3.1.2.3.2", "Study Component Management SOP Class (Retired)", "StudyComponentManagementSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.3.1.2.3.3", "Modality Performed Procedure Step SOP Class", "ModalityPerformedProcedureStepSOPClass",  "SOP Class" },
        { "1.2.840.10008.3.1.2.3.4", "Modality Performed Procedure Step Retrieve SOP Class", "ModalityPerformedProcedureStepRetrieveSOPClass",  "SOP Class" },
        { "1.2.840.10008.3.1.2.3.5", "Modality Performed Procedure Step Notification SOP Class", "ModalityPerformedProcedureStepNotificationSOPClass",  "SOP Class" },
        { "1.2.840.10008.3.1.2.5.1", "Detached Results Management SOP Class (Retired)", "DetachedResultsManagementSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.3.1.2.5.4", "Detached Results Management Meta SOP Class (Retired)", "DetachedResultsManagementMetaSOPClass_Retired",  "Meta SOP Class" },
        { "1.2.840.10008.3.1.2.5.5", "Detached Study Management Meta SOP Class (Retired)", "DetachedStudyManagementMetaSOPClass_Retired",  "Meta SOP Class" },
        { "1.2.840.10008.3.1.2.6.1", "Detached Interpretation Management SOP Class (Retired)", "DetachedInterpretationManagementSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.4.2", "Storage Service Class", "StorageServiceClass",  "Service Class" },
        { "1.2.840.10008.5.1.1.1", "Basic Film Session SOP Class", "BasicFilmSessionSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.2", "Basic Film Box SOP Class", "BasicFilmBoxSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.4", "Basic Grayscale Image Box SOP Class", "BasicGrayscaleImageBoxSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.4.1", "Basic Color Image Box SOP Class", "BasicColorImageBoxSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.4.2", "Referenced Image Box SOP Class (Retired)", "ReferencedImageBoxSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.9", "Basic Grayscale Print Management Meta SOP Class", "BasicGrayscalePrintManagementMetaSOPClass",  "Meta SOP Class" },
        { "1.2.840.10008.5.1.1.9.1", "Referenced Grayscale Print Management Meta SOP Class (Retired)", "ReferencedGrayscalePrintManagementMetaSOPClass_Retired",  "Meta SOP Class" },
        { "1.2.840.10008.5.1.1.14", "Print Job SOP Class", "PrintJobSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.15", "Basic Annotation Box SOP Class", "BasicAnnotationBoxSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.16", "Printer SOP Class", "PrinterSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.16.376", "Printer Configuration Retrieval SOP Class", "PrinterConfigurationRetrievalSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.17", "Printer SOP Instance", "PrinterSOPInstance",  "Well-known Printer SOP Instance" },
        { "1.2.840.10008.5.1.1.17.376", "Printer Configuration Retrieval SOP Instance", "PrinterConfigurationRetrievalSOPInstance",  "Well-known Printer SOP Instance" },
        { "1.2.840.10008.5.1.1.18", "Basic Color Print Management Meta SOP Class", "BasicColorPrintManagementMetaSOPClass",  "Meta SOP Class" },
        { "1.2.840.10008.5.1.1.18.1", "Referenced Color Print Management Meta SOP Class (Retired)", "ReferencedColorPrintManagementMetaSOPClass_Retired",  "Meta SOP Class" },
        { "1.2.840.10008.5.1.1.22", "VOI LUT Box SOP Class", "VOILUTBoxSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.23", "Presentation LUT SOP Class", "PresentationLUTSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.24", "Image Overlay Box SOP Class (Retired)", "ImageOverlayBoxSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.24.1", "Basic Print Image Overlay Box SOP Class (Retired)", "BasicPrintImageOverlayBoxSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.25", "Print Queue SOP Instance (Retired)", "PrintQueueSOPInstance_Retired",  "Well-known Print Queue SOP Instance" },
        { "1.2.840.10008.5.1.1.26", "Print Queue Management SOP Class (Retired)", "PrintQueueManagementSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.27", "Stored Print Storage SOP Class (Retired)", "StoredPrintStorageSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.29", "Hardcopy Grayscale Image Storage SOP Class (Retired)", "HardcopyGrayscaleImageStorageSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.30", "Hardcopy Color Image Storage SOP Class (Retired)", "HardcopyColorImageStorageSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.31", "Pull Print Request SOP Class (Retired)", "PullPrintRequestSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.1.32", "Pull Stored Print Management Meta SOP Class (Retired)", "PullStoredPrintManagementMetaSOPClass_Retired",  "Meta SOP Class" },
        { "1.2.840.10008.5.1.1.33", "Media Creation Management SOP Class UID", "MediaCreationManagementSOPClassUID",  "SOP Class" },
        { "1.2.840.10008.5.1.1.40", "Display System SOP Class", "DisplaySystemSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.1.40.1", "Display System SOP Instance", "DisplaySystemSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.5.1.4.1.1.1", "Computed Radiography Image Storage", "ComputedRadiographyImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.1.1", "Digital X-Ray Image Storage - For Presentation", "DigitalXRayImageStorageForPresentation",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.1.1.1", "Digital X-Ray Image Storage - For Processing", "DigitalXRayImageStorageForProcessing",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.1.2", "Digital Mammography X-Ray Image Storage - For Presentation", "DigitalMammographyXRayImageStorageForPresentation",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.1.2.1", "Digital Mammography X-Ray Image Storage - For Processing", "DigitalMammographyXRayImageStorageForProcessing",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.1.3", "Digital Intra-Oral X-Ray Image Storage - For Presentation", "DigitalIntraOralXRayImageStorageForPresentation",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.1.3.1", "Digital Intra-Oral X-Ray Image Storage - For Processing", "DigitalIntraOralXRayImageStorageForProcessing",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.2", "CT Image Storage", "CTImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.2.1", "Enhanced CT Image Storage", "EnhancedCTImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.2.2", "Legacy Converted Enhanced CT Image Storage", "LegacyConvertedEnhancedCTImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.3", "Ultrasound Multi-frame Image Storage (Retired)", "UltrasoundMultiframeImageStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.3.1", "Ultrasound Multi-frame Image Storage", "UltrasoundMultiframeImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.4", "MR Image Storage", "MRImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.4.1", "Enhanced MR Image Storage", "EnhancedMRImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.4.2", "MR Spectroscopy Storage", "MRSpectroscopyStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.4.3", "Enhanced MR Color Image Storage", "EnhancedMRColorImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.4.4", "Legacy Converted Enhanced MR Image Storage", "LegacyConvertedEnhancedMRImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.5", "Nuclear Medicine Image Storage (Retired)", "NuclearMedicineImageStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.6", "Ultrasound Image Storage (Retired)", "UltrasoundImageStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.6.1", "Ultrasound Image Storage", "UltrasoundImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.6.2", "Enhanced US Volume Storage", "EnhancedUSVolumeStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.7", "Secondary Capture Image Storage", "SecondaryCaptureImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.7.1", "Multi-frame Single Bit Secondary Capture Image Storage", "MultiframeSingleBitSecondaryCaptureImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.7.2", "Multi-frame Grayscale Byte Secondary Capture Image Storage", "MultiframeGrayscaleByteSecondaryCaptureImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.7.3", "Multi-frame Grayscale Word Secondary Capture Image Storage", "MultiframeGrayscaleWordSecondaryCaptureImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.7.4", "Multi-frame True Color Secondary Capture Image Storage", "MultiframeTrueColorSecondaryCaptureImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.8", "Standalone Overlay Storage (Retired)", "StandaloneOverlayStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9", "Standalone Curve Storage (Retired)", "StandaloneCurveStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.1", "Waveform Storage - Trial (Retired)", "WaveformStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.1.1", "12-lead ECG Waveform Storage", "TwelveleadECGWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.1.2", "General ECG Waveform Storage", "GeneralECGWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.1.3", "Ambulatory ECG Waveform Storage", "AmbulatoryECGWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.2.1", "Hemodynamic Waveform Storage", "HemodynamicWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.3.1", "Cardiac Electrophysiology Waveform Storage", "CardiacElectrophysiologyWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.4.1", "Basic Voice Audio Waveform Storage", "BasicVoiceAudioWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.4.2", "General Audio Waveform Storage", "GeneralAudioWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.5.1", "Arterial Pulse Waveform Storage", "ArterialPulseWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.9.6.1", "Respiratory Waveform Storage", "RespiratoryWaveformStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.10", "Standalone Modality LUT Storage (Retired)", "StandaloneModalityLUTStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.11", "Standalone VOI LUT Storage (Retired)", "StandaloneVOILUTStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.11.1", "Grayscale Softcopy Presentation State Storage SOP Class", "GrayscaleSoftcopyPresentationStateStorageSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.11.2", "Color Softcopy Presentation State Storage SOP Class", "ColorSoftcopyPresentationStateStorageSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.11.3", "Pseudo-Color Softcopy Presentation State Storage SOP Class", "PseudoColorSoftcopyPresentationStateStorageSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.11.4", "Blending Softcopy Presentation State Storage SOP Class", "BlendingSoftcopyPresentationStateStorageSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.11.5", "XA/XRF Grayscale Softcopy Presentation State Storage", "XAXRFGrayscaleSoftcopyPresentationStateStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.12.1", "X-Ray Angiographic Image Storage", "XRayAngiographicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.12.1.1", "Enhanced XA Image Storage", "EnhancedXAImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.12.2", "X-Ray Radiofluoroscopic Image Storage", "XRayRadiofluoroscopicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.12.2.1", "Enhanced XRF Image Storage", "EnhancedXRFImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.12.3", "X-Ray Angiographic Bi-Plane Image Storage (Retired)", "XRayAngiographicBiPlaneImageStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.13.1.1", "X-Ray 3D Angiographic Image Storage", "XRay3DAngiographicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.13.1.2", "X-Ray 3D Craniofacial Image Storage", "XRay3DCraniofacialImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.13.1.3", "Breast Tomosynthesis Image Storage", "BreastTomosynthesisImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.13.1.4", "Breast Projection X-Ray Image Storage - For Presentation", "BreastProjectionXRayImageStorageForPresentation",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.13.1.5", "Breast Projection X-Ray Image Storage - For Processing", "BreastProjectionXRayImageStorageForProcessing",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.14.1", "Intravascular Optical Coherence Tomography Image Storage - For Presentation", "IntravascularOpticalCoherenceTomographyImageStorageForPresentation",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.14.2", "Intravascular Optical Coherence Tomography Image Storage - For Processing", "IntravascularOpticalCoherenceTomographyImageStorageForProcessing",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.20", "Nuclear Medicine Image Storage", "NuclearMedicineImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.30", "Parametric Map Storage", "ParametricMapStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.66", "Raw Data Storage", "RawDataStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.66.1", "Spatial Registration Storage", "SpatialRegistrationStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.66.2", "Spatial Fiducials Storage", "SpatialFiducialsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.66.3", "Deformable Spatial Registration Storage", "DeformableSpatialRegistrationStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.66.4", "Segmentation Storage", "SegmentationStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.66.5", "Surface Segmentation Storage", "SurfaceSegmentationStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.67", "Real World Value Mapping Storage", "RealWorldValueMappingStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.68.1", "Surface Scan Mesh Storage", "SurfaceScanMeshStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.68.2", "Surface Scan Point Cloud Storage", "SurfaceScanPointCloudStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1", "VL Image Storage - Trial (Retired)", "VLImageStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.2", "VL Multi-frame Image Storage - Trial (Retired)", "VLMultiframeImageStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.1", "VL Endoscopic Image Storage", "VLEndoscopicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.1.1", "Video Endoscopic Image Storage", "VideoEndoscopicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.2", "VL Microscopic Image Storage", "VLMicroscopicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.2.1", "Video Microscopic Image Storage", "VideoMicroscopicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.3", "VL Slide-Coordinates Microscopic Image Storage", "VLSlideCoordinatesMicroscopicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.4", "VL Photographic Image Storage", "VLPhotographicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.4.1", "Video Photographic Image Storage", "VideoPhotographicImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.5.1", "Ophthalmic Photography 8 Bit Image Storage", "OphthalmicPhotography8BitImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.5.2", "Ophthalmic Photography 16 Bit Image Storage", "OphthalmicPhotography16BitImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.5.3", "Stereometric Relationship Storage", "StereometricRelationshipStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.5.4", "Ophthalmic Tomography Image Storage", "OphthalmicTomographyImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.5.5", "Wide Field Ophthalmic Photography Stereographic Projection Image Storage", "WideFieldOphthalmicPhotographyStereographicProjectionImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.5.6", "Wide Field Ophthalmic Photography 3D Coordinates Image Storage", "WideFieldOphthalmicPhotography3DCoordinatesImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.77.1.6", "VL Whole Slide Microscopy Image Storage", "VLWholeSlideMicroscopyImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.1", "Lensometry Measurements Storage", "LensometryMeasurementsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.2", "Autorefraction Measurements Storage", "AutorefractionMeasurementsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.3", "Keratometry Measurements Storage", "KeratometryMeasurementsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.4", "Subjective Refraction Measurements Storage", "SubjectiveRefractionMeasurementsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.5", "Visual Acuity Measurements Storage", "VisualAcuityMeasurementsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.6", "Spectacle Prescription Report Storage", "SpectaclePrescriptionReportStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.7", "Ophthalmic Axial Measurements Storage", "OphthalmicAxialMeasurementsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.78.8", "Intraocular Lens Calculations Storage", "IntraocularLensCalculationsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.79.1", "Macular Grid Thickness and Volume Report Storage", "MacularGridThicknessandVolumeReportStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.80.1", "Ophthalmic Visual Field Static Perimetry Measurements Storage", "OphthalmicVisualFieldStaticPerimetryMeasurementsStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.81.1", "Ophthalmic Thickness Map Storage", "OphthalmicThicknessMapStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.82.1", "Corneal Topography Map Storage", "CornealTopographyMapStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.1", "Text SR Storage - Trial (Retired)", "TextSRStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.2", "Audio SR Storage - Trial (Retired)", "AudioSRStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.3", "Detail SR Storage - Trial (Retired)", "DetailSRStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.4", "Comprehensive SR Storage - Trial (Retired)", "ComprehensiveSRStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.11", "Basic Text SR Storage", "BasicTextSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.22", "Enhanced SR Storage", "EnhancedSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.33", "Comprehensive SR Storage", "ComprehensiveSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.34", "Comprehensive 3D SR Storage", "Comprehensive3DSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.35", "Extensible SR Storage", "ExtensibleSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.40", "Procedure Log Storage", "ProcedureLogStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.50", "Mammography CAD SR Storage", "MammographyCADSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.59", "Key Object Selection Document Storage", "KeyObjectSelectionDocumentStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.65", "Chest CAD SR Storage", "ChestCADSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.67", "X-Ray Radiation Dose SR Storage", "XRayRadiationDoseSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.68", "Radiopharmaceutical Radiation Dose SR Storage", "RadiopharmaceuticalRadiationDoseSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.69", "Colon CAD SR Storage", "ColonCADSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.88.70", "Implantation Plan SR Storage", "ImplantationPlanSRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.104.1", "Encapsulated PDF Storage", "EncapsulatedPDFStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.104.2", "Encapsulated CDA Storage", "EncapsulatedCDAStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.128", "Positron Emission Tomography Image Storage", "PositronEmissionTomographyImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.128.1", "Legacy Converted Enhanced PET Image Storage", "LegacyConvertedEnhancedPETImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.129", "Standalone PET Curve Storage (Retired)", "StandalonePETCurveStorage_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.130", "Enhanced PET Image Storage", "EnhancedPETImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.131", "Basic Structured Display Storage", "BasicStructuredDisplayStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.1", "RT Image Storage", "RTImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.2", "RT Dose Storage", "RTDoseStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.3", "RT Structure Set Storage", "RTStructureSetStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.4", "RT Beams Treatment Record Storage", "RTBeamsTreatmentRecordStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.5", "RT Plan Storage", "RTPlanStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.6", "RT Brachy Treatment Record Storage", "RTBrachyTreatmentRecordStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.7", "RT Treatment Summary Record Storage", "RTTreatmentSummaryRecordStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.8", "RT Ion Plan Storage", "RTIonPlanStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.481.9", "RT Ion Beams Treatment Record Storage", "RTIonBeamsTreatmentRecordStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.501.1", "DICOS CT Image Storage", "DICOSCTImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.501.2.1", "DICOS Digital X-Ray Image Storage - For Presentation", "DICOSDigitalXRayImageStorageForPresentation",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.501.2.2", "DICOS Digital X-Ray Image Storage - For Processing", "DICOSDigitalXRayImageStorageForProcessing",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.501.3", "DICOS Threat Detection Report Storage", "DICOSThreatDetectionReportStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.501.4", "DICOS 2D AIT Storage", "DICOS2DAITStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.501.5", "DICOS 3D AIT Storage", "DICOS3DAITStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.501.6", "DICOS Quadrupole Resonance (QR) Storage", "DICOSQuadrupoleResonanceQRStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.601.1", "Eddy Current Image Storage", "EddyCurrentImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.1.601.2", "Eddy Current Multi-frame Image Storage", "EddyCurrentMultiframeImageStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.1.1", "Patient Root Query/Retrieve Information Model - FIND", "PatientRootQueryRetrieveInformationModelFIND",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.1.2", "Patient Root Query/Retrieve Information Model - MOVE", "PatientRootQueryRetrieveInformationModelMOVE",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.1.3", "Patient Root Query/Retrieve Information Model - GET", "PatientRootQueryRetrieveInformationModelGET",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.2.1", "Study Root Query/Retrieve Information Model - FIND", "StudyRootQueryRetrieveInformationModelFIND",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.2.2", "Study Root Query/Retrieve Information Model - MOVE", "StudyRootQueryRetrieveInformationModelMOVE",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.2.3", "Study Root Query/Retrieve Information Model - GET", "StudyRootQueryRetrieveInformationModelGET",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.3.1", "Patient/Study Only Query/Retrieve Information Model - FIND (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelFIND_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.3.2", "Patient/Study Only Query/Retrieve Information Model - MOVE (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelMOVE_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.3.3", "Patient/Study Only Query/Retrieve Information Model - GET (Retired)", "PatientStudyOnlyQueryRetrieveInformationModelGET_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.4.2", "Composite Instance Root Retrieve - MOVE", "CompositeInstanceRootRetrieveMOVE",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.4.3", "Composite Instance Root Retrieve - GET", "CompositeInstanceRootRetrieveGET",  "SOP Class" },
        { "1.2.840.10008.5.1.4.1.2.5.3", "Composite Instance Retrieve Without Bulk Data - GET", "CompositeInstanceRetrieveWithoutBulkDataGET",  "SOP Class" },
        { "1.2.840.10008.5.1.4.31", "Modality Worklist Information Model - FIND", "ModalityWorklistInformationModelFIND",  "SOP Class" },
        { "1.2.840.10008.5.1.4.32", "General Purpose Worklist Management Meta SOP Class (Retired)", "GeneralPurposeWorklistManagementMetaSOPClass_Retired",  "Meta SOP Class" },
        { "1.2.840.10008.5.1.4.32.1", "General Purpose Worklist Information Model - FIND (Retired)", "GeneralPurposeWorklistInformationModelFIND_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.32.2", "General Purpose Scheduled Procedure Step SOP Class (Retired)", "GeneralPurposeScheduledProcedureStepSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.32.3", "General Purpose Performed Procedure Step SOP Class (Retired)", "GeneralPurposePerformedProcedureStepSOPClass_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.33", "Instance Availability Notification SOP Class", "InstanceAvailabilityNotificationSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.1", "RT Beams Delivery Instruction Storage - Trial (Retired)", "RTBeamsDeliveryInstructionStorageTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.2", "RT Conventional Machine Verification - Trial (Retired)", "RTConventionalMachineVerificationTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.3", "RT Ion Machine Verification - Trial (Retired)", "RTIonMachineVerificationTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.4", "Unified Worklist and Procedure Step Service Class - Trial (Retired)", "UnifiedWorklistandProcedureStepServiceClassTrial_Retired",  "Service Class" },
        { "1.2.840.10008.5.1.4.34.4.1", "Unified Procedure Step - Push SOP Class - Trial (Retired)", "UnifiedProcedureStepPushSOPClassTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.4.2", "Unified Procedure Step - Watch SOP Class - Trial (Retired)", "UnifiedProcedureStepWatchSOPClassTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.4.3", "Unified Procedure Step - Pull SOP Class - Trial (Retired)", "UnifiedProcedureStepPullSOPClassTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.4.4", "Unified Procedure Step - Event SOP Class - Trial (Retired)", "UnifiedProcedureStepEventSOPClassTrial_Retired",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.5", "UPS Global Subscription SOP Instance", "UPSGlobalSubscriptionSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.5.1.4.34.5.1", "UPS Filtered Global Subscription SOP Instance", "UPSFilteredGlobalSubscriptionSOPInstance",  "Well-known SOP Instance" },
        { "1.2.840.10008.5.1.4.34.6", "Unified Worklist and Procedure Step Service Class", "UnifiedWorklistandProcedureStepServiceClass",  "Service Class" },
        { "1.2.840.10008.5.1.4.34.6.1", "Unified Procedure Step - Push SOP Class", "UnifiedProcedureStepPushSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.6.2", "Unified Procedure Step - Watch SOP Class", "UnifiedProcedureStepWatchSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.6.3", "Unified Procedure Step - Pull SOP Class", "UnifiedProcedureStepPullSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.6.4", "Unified Procedure Step - Event SOP Class", "UnifiedProcedureStepEventSOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.7", "RT Beams Delivery Instruction Storage", "RTBeamsDeliveryInstructionStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.8", "RT Conventional Machine Verification", "RTConventionalMachineVerification",  "SOP Class" },
        { "1.2.840.10008.5.1.4.34.9", "RT Ion Machine Verification", "RTIonMachineVerification",  "SOP Class" },
        { "1.2.840.10008.5.1.4.37.1", "General Relevant Patient Information Query", "GeneralRelevantPatientInformationQuery",  "SOP Class" },
        { "1.2.840.10008.5.1.4.37.2", "Breast Imaging Relevant Patient Information Query", "BreastImagingRelevantPatientInformationQuery",  "SOP Class" },
        { "1.2.840.10008.5.1.4.37.3", "Cardiac Relevant Patient Information Query", "CardiacRelevantPatientInformationQuery",  "SOP Class" },
        { "1.2.840.10008.5.1.4.38.1", "Hanging Protocol Storage", "HangingProtocolStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.38.2", "Hanging Protocol Information Model - FIND", "HangingProtocolInformationModelFIND",  "SOP Class" },
        { "1.2.840.10008.5.1.4.38.3", "Hanging Protocol Information Model - MOVE", "HangingProtocolInformationModelMOVE",  "SOP Class" },
        { "1.2.840.10008.5.1.4.38.4", "Hanging Protocol Information Model - GET", "HangingProtocolInformationModelGET",  "SOP Class" },
        { "1.2.840.10008.5.1.4.39.1", "Color Palette Storage", "ColorPaletteStorage",  "Transfer" },
        { "1.2.840.10008.5.1.4.39.2", "Color Palette Information Model - FIND", "ColorPaletteInformationModelFIND",  "Query/Retrieve" },
        { "1.2.840.10008.5.1.4.39.3", "Color Palette Information Model - MOVE", "ColorPaletteInformationModelMOVE",  "Query/Retrieve" },
        { "1.2.840.10008.5.1.4.39.4", "Color Palette Information Model - GET", "ColorPaletteInformationModelGET",  "Query/Retrieve" },
        { "1.2.840.10008.5.1.4.41", "Product Characteristics Query SOP Class", "ProductCharacteristicsQuerySOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.42", "Substance Approval Query SOP Class", "SubstanceApprovalQuerySOPClass",  "SOP Class" },
        { "1.2.840.10008.5.1.4.43.1", "Generic Implant Template Storage", "GenericImplantTemplateStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.43.2", "Generic Implant Template Information Model - FIND", "GenericImplantTemplateInformationModelFIND",  "SOP Class" },
        { "1.2.840.10008.5.1.4.43.3", "Generic Implant Template Information Model - MOVE", "GenericImplantTemplateInformationModelMOVE",  "SOP Class" },
        { "1.2.840.10008.5.1.4.43.4", "Generic Implant Template Information Model - GET", "GenericImplantTemplateInformationModelGET",  "SOP Class" },
        { "1.2.840.10008.5.1.4.44.1", "Implant Assembly Template Storage", "ImplantAssemblyTemplateStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.44.2", "Implant Assembly Template Information Model - FIND", "ImplantAssemblyTemplateInformationModelFIND",  "SOP Class" },
        { "1.2.840.10008.5.1.4.44.3", "Implant Assembly Template Information Model - MOVE", "ImplantAssemblyTemplateInformationModelMOVE",  "SOP Class" },
        { "1.2.840.10008.5.1.4.44.4", "Implant Assembly Template Information Model - GET", "ImplantAssemblyTemplateInformationModelGET",  "SOP Class" },
        { "1.2.840.10008.5.1.4.45.1", "Implant Template Group Storage", "ImplantTemplateGroupStorage",  "SOP Class" },
        { "1.2.840.10008.5.1.4.45.2", "Implant Template Group Information Model - FIND", "ImplantTemplateGroupInformationModelFIND",  "SOP Class" },
        { "1.2.840.10008.5.1.4.45.3", "Implant Template Group Information Model - MOVE", "ImplantTemplateGroupInformationModelMOVE",  "SOP Class" },
        { "1.2.840.10008.5.1.4.45.4", "Implant Template Group Information Model - GET", "ImplantTemplateGroupInformationModelGET",  "SOP Class" },
        { "1.2.840.10008.7.1.1", "Native DICOM Model", "NativeDICOMModel",  "Application Hosting Model" },
        { "1.2.840.10008.7.1.2", "Abstract Multi-Dimensional Image Model", "AbstractMultiDimensionalImageModel",  "Application Hosting Model" },
        { "1.2.840.10008.8.1.1", "DICOM Content Mapping Resource", "DICOMContentMappingResource",  "Mapping Resource" },
        { "1.2.840.10008.15.0.3.1", "dicomDeviceName", "dicomDeviceName",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.2", "dicomDescription", "dicomDescription",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.3", "dicomManufacturer", "dicomManufacturer",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.4", "dicomManufacturerModelName", "dicomManufacturerModelName",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.5", "dicomSoftwareVersion", "dicomSoftwareVersion",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.6", "dicomVendorData", "dicomVendorData",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.7", "dicomAETitle", "dicomAETitle",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.8", "dicomNetworkConnectionReference", "dicomNetworkConnectionReference",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.9", "dicomApplicationCluster", "dicomApplicationCluster",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.10", "dicomAssociationInitiator", "dicomAssociationInitiator",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.11", "dicomAssociationAcceptor", "dicomAssociationAcceptor",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.12", "dicomHostname", "dicomHostname",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.13", "dicomPort", "dicomPort",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.14", "dicomSOPClass", "dicomSOPClass",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.15", "dicomTransferRole", "dicomTransferRole",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.16", "dicomTransferSyntax", "dicomTransferSyntax",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.17", "dicomPrimaryDeviceType", "dicomPrimaryDeviceType",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.18", "dicomRelatedDeviceReference", "dicomRelatedDeviceReference",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.19", "dicomPreferredCalledAETitle", "dicomPreferredCalledAETitle",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.20", "dicomTLSCyphersuite", "dicomTLSCyphersuite",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.21", "dicomAuthorizedNodeCertificateReference", "dicomAuthorizedNodeCertificateReference",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.22", "dicomThisNodeCertificateReference", "dicomThisNodeCertificateReference",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.23", "dicomInstalled", "dicomInstalled",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.24", "dicomStationName", "dicomStationName",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.25", "dicomDeviceSerialNumber", "dicomDeviceSerialNumber",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.26", "dicomInstitutionName", "dicomInstitutionName",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.27", "dicomInstitutionAddress", "dicomInstitutionAddress",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.28", "dicomInstitutionDepartmentName", "dicomInstitutionDepartmentName",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.29", "dicomIssuerOfPatientID", "dicomIssuerOfPatientID",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.30", "dicomPreferredCallingAETitle", "dicomPreferredCallingAETitle",  "LDAP OID" },
        { "1.2.840.10008.15.0.3.31", "dicomSupportedCharacterSet", "dicomSupportedCharacterSet",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.1", "dicomConfigurationRoot", "dicomConfigurationRoot",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.2", "dicomDevicesRoot", "dicomDevicesRoot",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.3", "dicomUniqueAETitlesRegistryRoot", "dicomUniqueAETitlesRegistryRoot",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.4", "dicomDevice", "dicomDevice",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.5", "dicomNetworkAE", "dicomNetworkAE",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.6", "dicomNetworkConnection", "dicomNetworkConnection",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.7", "dicomUniqueAETitle", "dicomUniqueAETitle",  "LDAP OID" },
        { "1.2.840.10008.15.0.4.8", "dicomTransferCapability", "dicomTransferCapability",  "LDAP OID" },
        { "1.2.840.10008.15.1.1", "Universal Coordinated Time", "UniversalCoordinatedTime",  "Synchronization Frame of Reference" },
    };

    UIDsDictionary uids_dictionary;
    
    unsigned long const count = sizeof(raw_entries)/sizeof(RawUIDsDictionaryEntry);
    for(unsigned long i=0; i<count; ++i)
    {
        RawUIDsDictionaryEntry const & raw_entry = raw_entries[i];
        UIDsDictionaryEntry const entry(
            raw_entry.name, raw_entry.keyword, raw_entry.type);
        uids_dictionary.insert(std::pair<std::string, UIDsDictionaryEntry>(raw_entry.uid, entry));
    }

    return uids_dictionary;
}

}

}

odil::ElementsDictionary odil::registry::public_dictionary=odil::registry::create_public_dictionary();
odil::UIDsDictionary odil::registry::uids_dictionary=odil::registry::create_uids_dictionary();