// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Standard_Type_HeaderFile
#define _Standard_Type_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Standard_Type.hxx>

#include <Standard_CString.hxx>
#include <Standard_Integer.hxx>
#include <Standard_KindOfType.hxx>
#include <Standard_Address.hxx>
#include <Standard_Transient.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_OStream.hxx>
class Standard_TypeMismatch;
class Standard_NoSuchObject;
class Standard_OutOfRange;
class Standard_AncestorIterator;



//! The class <Type> provides services to find out information
//! about a type defined in CDL.
//!
//! Note that multiple inheritance is not supported by the moment;
//! the array of ancestors accepted by constructors is assumed to
//! represent hierarchy of ancestors up to the root.
//! However, only first element is actually used by SubType method,
//! higher level ancestors are requested recursively.
//!
//! Warning:
//! The information given by <Type> is about the type from which
//! it is created and not about the <Type> itself.
class Standard_Type : public Standard_Transient
{

public:

  

  //! Returns the type name of <me>.
  Standard_EXPORT   Standard_CString Name()  const;
  

  //! Returns the size of <me> in bytes.
  Standard_EXPORT   Standard_Integer Size()  const;
  

  //! The constructor for a imported type.
  Standard_EXPORT Standard_Type(const Standard_CString aName, const Standard_Integer aSize);
  

  //! The constructor for a primitive.
  Standard_EXPORT Standard_Type(const Standard_CString aName, const Standard_Integer aSize, const Standard_Integer aNumberOfParent, const Standard_Address aAncestors);
  

  //! The constructor for an enumeration.
  Standard_EXPORT Standard_Type(const Standard_CString aName, const Standard_Integer aSize, const Standard_Integer aNumberOfElement, const Standard_Integer aNumberOfParent, const Standard_Address anAncestors, const Standard_Address aElements);
  

  //! The constructor for a class.
  Standard_EXPORT Standard_Type(const Standard_CString aName, const Standard_Integer aSize, const Standard_Integer aNumberOfParent, const Standard_Address anAncestors, const Standard_Address aFields);
  

  //! Returns "True", if <me> is the same as <aOther>,
  //! or inherits from <aOther>.
  //! Note that multiple inheritance is not supported.
  Standard_EXPORT   Standard_Boolean SubType (const Handle(Standard_Type)& aOther)  const;
  

  //! Returns "True", if <me> or one of its ancestors has the name
  //! equal to theName.
  //! Note that multiple inheritance is not supported.
  Standard_EXPORT   Standard_Boolean SubType (const Standard_CString theName)  const;
  

  //! Returns "True", if the type is imported.
  Standard_EXPORT   Standard_Boolean IsImported()  const;
  

  //! Returns "True", if the type is a primitive.
  Standard_EXPORT   Standard_Boolean IsPrimitive()  const;
  

  //! Returns "True", if the type is an "Enumeration".
  Standard_EXPORT   Standard_Boolean IsEnumeration()  const;
  

  //! Returns "True", if the type is a "Class".
  Standard_EXPORT   Standard_Boolean IsClass()  const;
  

  //! Returns the number of direct parents of the class.
  Standard_EXPORT   Standard_Integer NumberOfParent()  const;
  

  //! Returns the number of ancestors of the class.
  Standard_EXPORT   Standard_Integer NumberOfAncestor()  const;
  

  //! Prints on the stream <s> the name of Type.
  //! Warning:
  //! The operator "OStream& operator<< (Standard_OStream&,
  //! Handle(Standard_Type)&)"
  //! is implemented. (This operator uses the method Print)
  Standard_EXPORT   void Print (Standard_OStream& s)  const;
Standard_EXPORT     void operator<<(Standard_OStream& s) const  {  Print(s); }  


friend class Standard_AncestorIterator;


  DEFINE_STANDARD_RTTI(Standard_Type)

protected:




private: 

  

  //! Returns the address of the ancestors array. It can be used only by
  //! AncestorIterator.
  Standard_EXPORT   Standard_Address Ancestors()  const;
  

  //! Just for inline.
      void InLineDummy()  const;

  Standard_CString myName;
  Standard_Integer mySize;
  Standard_KindOfType myKind;
  Standard_Integer myNumberOfParent;
  Standard_Integer myNumberOfAncestor;
  Standard_Address myAncestors;


};


#include <Standard_Type.lxx>





#endif // _Standard_Type_HeaderFile
