// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Visual3d_ViewMapping_HeaderFile
#define _Visual3d_ViewMapping_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Visual3d_TypeOfProjection_HeaderFile
#include <Visual3d_TypeOfProjection.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray2OfReal_HeaderFile
#include <Handle_TColStd_HArray2OfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TColStd_HArray2OfReal;
class Visual3d_ViewMappingDefinitionError;
class Visual3d_View;


//! This class allows the definition of a projection and <br>
//!	    a system of coordinates called NPC. <br>
//!	    (Normalized Projection Coordinates). <br>
//!	    The projection can be parallel or perspective. <br>
//!  References: The definitions are Phigs oriented. <br>
//!  Keywords: View, Mapping, Window, View Plane, Front Plane, <br>
//!    BackPlane, Projection Type, Reset, Projection <br>
//! Summary of 3D View Mapping                   -- <br>
//! The view mapping transformation  defines the -- <br>
//! window-to-viewport mapping of View Reference -- <br>
//! Coordinates (VRC)  to Normalized  Projection -- <br>
//! Coordinates (NPC).                           -- <br>
//! CAS.CADE supports two kinds of projection :  -- <br>
//! 	Parallel :                              -- <br>
//!	The Projection Reference Point (PRP)    -- <br>
//!	determines the direction of projection. -- <br>
//! 	Perspective :                           -- <br>
//!	The projector lines converge at the     -- <br>
//!	Projection Reference Point (PRP).       -- <br>
//! To define a  view mapping transformation you -- <br>
//! must define :                                -- <br>
//!	The Projection Type                     -- <br>
//!	The Projection Reference Point (PRP)    -- <br>
//!	The Distance from Back Plane (BPD)      -- <br>
//!	The Distance from Front Plane (FPD)     -- <br>
//!	The Distance from View Plane (VPD)      -- <br>
//!	The Window in the View Plane.           -- <br>
class Visual3d_ViewMapping  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates a projection. <br>
//! <br>
//!	TypeOfProjection		= TOP_PARALLEL <br>
//!	PRP : Projection Reference Point= (0.5, 0.5, 2.0) <br>
//!	BPD : Distance from Back Plane	= 0.0 <br>
//!	FPD : Distance from Front Plane	= 1.0 <br>
//!	VPD : Distance from View Plane	= 1.0 <br>
//!	WUmin	= 0.0 <br>
//!	WUmax	= 1.0 <br>
//!	WVmin	= 0.0 <br>
//!	WVmax	= 1.0 <br>
  Standard_EXPORT   Visual3d_ViewMapping();
  //! Creates a projection. <br>
//! <br>
//!	TypeOfProjection : TOP_PERSPECTIVE <br>
//!			   TOP_PARALLEL <br>
//!	PRP : Projection Reference Point with respect to <br>
//!	      coordinate system VRC, defined by the <br>
//!	      class ViewOrientation. <br>
//!	BPD : Distance from Back Plane. <br>
//!	FPD : Distance from Front Plane. <br>
//!	VPD : Distance from View Plane. <br>
//!	These three values are with respect to VRP, according to <br>
//!	the N axis of the VRC coordinate system, defined by the class <br>
//!	ViewOrientation. <br>
//!	WUmin,WUmax,WVmin,WVmax : Visible part of the plane of <br>
//!	projection defined with respect to the UV axes of coordinate <br>
//!	system VRC. <br>
//!	   That's what allows modification of the zoom/panning. <br>
//!	The mapping of the visible part of the plane of projection <br>
//!	on the screen is done in the window. <br>
//!	   That's why multiple views on the same window is not allowed. <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if the specified window is invalid. <br>
//!	    if <PRP> is between the front and back planes. <br>
//!	    if <PRP> is positioned on the view plane. <br>
//!	    if the back plane is in front of the front plane. <br>
  Standard_EXPORT   Visual3d_ViewMapping(const Visual3d_TypeOfProjection AType,const Graphic3d_Vertex& PRP,const Standard_Real BPD,const Standard_Real FPD,const Standard_Real VPD,const Standard_Real WUmin,const Standard_Real WVmin,const Standard_Real WUmax,const Standard_Real WVmax);
  //! Modifies the back clipping plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is between the front and back planes. <br>
//!	    if <PRP> is positioned on the view plane. <br>
//!	    if the back plane is in front of the front plane. <br>
  Standard_EXPORT     void SetBackPlaneDistance(const Standard_Real BPD) ;
  //! Modifies the front clipping plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is between the front and back planes. <br>
//!	    if <PRP> is positioned on the view plane. <br>
//!	    if the back plane is in front of the front plane. <br>
  Standard_EXPORT     void SetFrontPlaneDistance(const Standard_Real FPD) ;
  //! Modifies the type of projection. <br>
//! <br>
//!	    TypeOfProjection : TOP_PERSPECTIVE <br>
//!			       TOP_PARALLEL <br>
//! <br>
  Standard_EXPORT     void SetProjection(const Visual3d_TypeOfProjection AType) ;
  //! Modifies the PRP. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is between the front and back planes. <br>
//!	    if <PRP> is positioned on the view plane. <br>
  Standard_EXPORT     void SetProjectionReferencePoint(const Graphic3d_Vertex& PRP) ;
  //! Modifies the distance of the view plane of projection. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is positioned on the view plane. <br>
  Standard_EXPORT     void SetViewPlaneDistance(const Standard_Real VPD) ;
  //! Modifies the visible part of the projection plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError if the <br>
//!	    specified window is invalid. <br>
  Standard_EXPORT     void SetWindowLimit(const Standard_Real Umin,const Standard_Real Vmin,const Standard_Real Umax,const Standard_Real Vmax) ;
  //! Sets custom PROJECTION matrix for the OpenGl context <br>
  Standard_EXPORT     void SetCustomProjectionMatrix(const Handle(TColStd_HArray2OfReal)& Mat) ;
  //! Returns the distance from the back clipping plane <br>
//! of this view mapping. <br>
  Standard_EXPORT     Standard_Real BackPlaneDistance() const;
  //! Returns the distance from the front clipping plane <br>
//! of this view mapping. <br>
  Standard_EXPORT     Standard_Real FrontPlaneDistance() const;
  //! Returns the type of projection. <br>
  Standard_EXPORT     Visual3d_TypeOfProjection Projection() const;
  //! Returns the PRP. <br>
  Standard_EXPORT     Graphic3d_Vertex ProjectionReferencePoint() const;
  //! Returns the distance from the projection plane. <br>
  Standard_EXPORT     Standard_Real ViewPlaneDistance() const;
  //! Returns the visible part of the projection plane. <br>
  Standard_EXPORT     void WindowLimit(Standard_Real& Umin,Standard_Real& Vmin,Standard_Real& Umax,Standard_Real& Vmax) const;
  //! Returns whether the custom PROJECTION matrix is used. <br>
  Standard_EXPORT     Standard_Boolean IsCustomMatrix() const;


friend class Visual3d_View;



protected:





private:

  //! Copies the content of <Other> into <me>. <br>
  Standard_EXPORT     void Assign(const Visual3d_ViewMapping& Other) ;


Graphic3d_Vertex MyReferencePoint;
Visual3d_TypeOfProjection MyProjectionType;
Standard_Real MyBackPlaneDistance;
Standard_Real MyFrontPlaneDistance;
Standard_Real MyViewPlaneDistance;
Standard_Real MyWindowLimits[4];
Handle_TColStd_HArray2OfReal MyProjectionMatrix;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
