// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2d_Circle_HeaderFile
#define _Geom2d_Circle_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom2d_Circle_HeaderFile
#include <Handle_Geom2d_Circle.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Geom2d_Conic_HeaderFile
#include <Geom2d_Conic.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class Standard_ConstructionError;
class Standard_RangeError;
class gp_Circ2d;
class gp_Ax2d;
class gp_Ax22d;
class gp_Pnt2d;
class gp_Vec2d;
class gp_Trsf2d;
class Geom2d_Geometry;


//! Describes a circle in the plane (2D space). <br>
//! A circle is defined by its radius and, as with any conic <br>
//! curve, is positioned in the plane with a coordinate <br>
//! system (gp_Ax22d object) where the origin is the <br>
//! center of the circle. <br>
//! The coordinate system is the local coordinate <br>
//! system of the circle. <br>
//! The orientation (direct or indirect) of the local <br>
//! coordinate system gives an explicit orientation to the <br>
//! circle, determining the direction in which the <br>
//! parameter increases along the circle. <br>
//! The Geom2d_Circle circle is parameterized by an angle: <br>
//! P(U) = O + R*Cos(U)*XDir + R*Sin(U)*YDir <br>
//! where: <br>
//! - P is the point of parameter U, <br>
//! - O, XDir and YDir are respectively the origin, "X <br>
//!   Direction" and "Y Direction" of its local coordinate system, <br>
//! - R is the radius of the circle. <br>
//! The "X Axis" of the local coordinate system therefore <br>
//! defines the origin of the parameter of the circle. The <br>
//! parameter is the angle with this "X Direction". <br>
//! A circle is a closed and periodic curve. The period is <br>
//! 2.*Pi and the parameter range is [ 0,2.*Pi [. <br>
//! See Also <br>
//! GCE2d_MakeCircle which provides functions for <br>
//! more complex circle constructions <br>
//! gp_Ax22d and  gp_Circ2d for an equivalent, non-parameterized data structure. <br>
class Geom2d_Circle : public Geom2d_Conic {

public:

  //!  Constructs a circle by conversion of the gp_Circ2d circle C. <br>
  Standard_EXPORT   Geom2d_Circle(const gp_Circ2d& C);
  //! Constructs a circle of radius Radius, whose center is the origin of axis <br>
//!   A; A is the "X Axis" of the local coordinate system <br>
//!   of the circle; this coordinate system is direct if <br>
//!   Sense is true (default value) or indirect if Sense is false. <br>
//! Note: It is possible to create a circle where Radius is equal to 0.0. <br>
//! Exceptions Standard_ConstructionError if Radius is negative. <br>
  Standard_EXPORT   Geom2d_Circle(const gp_Ax2d& A,const Standard_Real Radius,const Standard_Boolean Sense = Standard_True);
  //! Constructs a circle <br>
//! of radius Radius, where the coordinate system A <br>
//!   locates the circle and defines its orientation in the plane such that: <br>
//!   - the center of the circle is the origin of A, <br>
//!   - the orientation (direct or indirect) of A gives the <br>
//!    orientation of the circle. <br>
  Standard_EXPORT   Geom2d_Circle(const gp_Ax22d& A,const Standard_Real Radius);
  
//!  Converts the gp_Circ2d circle C into this circle. <br>
  Standard_EXPORT     void SetCirc2d(const gp_Circ2d& C) ;
  
  Standard_EXPORT     void SetRadius(const Standard_Real R) ;
  
//!  Returns the non persistent circle from gp with the same <br>
//!  geometric properties as <me>. <br>
  Standard_EXPORT     gp_Circ2d Circ2d() const;
  //! Returns the radius of this circle. <br>
  Standard_EXPORT     Standard_Real Radius() const;
  //! Computes the parameter on the reversed circle for <br>
//! the point of parameter U on this circle. <br>
//! For a circle, the returned value is: 2.*Pi - U. <br>
  Standard_EXPORT     Standard_Real ReversedParameter(const Standard_Real U) const;
  //!  Returns 0., which is the eccentricity of any circle. <br>
  Standard_EXPORT     Standard_Real Eccentricity() const;
  //! Returns 0.0 <br>
  Standard_EXPORT     Standard_Real FirstParameter() const;
  //! Returns 2*PI. <br>
  Standard_EXPORT     Standard_Real LastParameter() const;
  //! returns True. <br>
  Standard_EXPORT     Standard_Boolean IsClosed() const;
  //! returns True. The period of a circle is 2.*Pi. <br>
  Standard_EXPORT     Standard_Boolean IsPeriodic() const;
  //! Returns in P the point of parameter U. <br>
//!  P = C + R * Cos (U) * XDir + R * Sin (U) * YDir <br>
//!  where C is the center of the circle , XDir the XDirection and <br>
//!  YDir the YDirection of the circle's local coordinate system. <br>
  Standard_EXPORT     void D0(const Standard_Real U,gp_Pnt2d& P) const;
  
//!  Returns the point P of parameter U and the first derivative V1. <br>
  Standard_EXPORT     void D1(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1) const;
  
//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. <br>
  Standard_EXPORT     void D2(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2) const;
  
//!  Returns the point P of parameter u, the first second and third <br>
//!  derivatives V1 V2 and V3. <br>
  Standard_EXPORT     void D3(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2,gp_Vec2d& V3) const;
  //! For the point of parameter U of this circle, computes <br>
//! the vector corresponding to the Nth derivative. <br>
//! Exceptions: Standard_RangeError if N is less than 1. <br>
  Standard_EXPORT     gp_Vec2d DN(const Standard_Real U,const Standard_Integer N) const;
  //! Applies the transformation T to this circle. <br>
  Standard_EXPORT     void Transform(const gp_Trsf2d& T) ;
  //! Creates a new object which is a copy of this circle. <br>
  Standard_EXPORT     Handle_Geom2d_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom2d_Circle)

protected:




private: 


Standard_Real radius;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
