This tests the dune-project -> opam file generation with different kinds of
constraints.

  $ cat > dune-project << EOF
  > (lang dune 2.1)
  > (generate_opam_files)
  > (package
  >  (name p)
  >  (depends
  >   ; unary ops
  >   (p_eq (= v))
  >   (p_lt (< v))
  >   (p_gt (> v))
  >   (p_ge (>= v))
  >   (p_le (<= v))
  >   (p_ne (<> v))
  >   ; binary ops
  >   (p_bin (<> :os win32))
  >   ; and
  >   (p_and2 (and :a :b))
  >   (p_and1 (and :a))
  >   (p_and3 (and :a :b :c))
  >   ; or
  >   (p_or2 (or :a :b))
  >   (p_or1 (or :a))
  >   (p_or3 (or :a :b :c))
  >   ; mixed operations
  >   (p_and_in_or (or :a (and :b :c)))
  >   (p_or_in_and (and :a (or :b :c)))
  >   ))
  > EOF

  $ dune build

  $ cat p.opam
  # This file is generated by dune, edit dune-project instead
  opam-version: "2.0"
  depends: [
    "dune" {>= "2.1"}
    "p_eq" {= "v"}
    "p_lt" {< "v"}
    "p_gt" {> "v"}
    "p_ge" {>= "v"}
    "p_le" {<= "v"}
    "p_ne" {!= "v"}
    "p_bin" {os != "win32"}
    "p_and2" {a & b}
    "p_and1" {a}
    "p_and3" {a & b & c}
    "p_or2" {a | b}
    "p_or1" {a}
    "p_or3" {a | b | c}
    "p_and_in_or" {a | b & c}
    "p_or_in_and" {a & (b | c)}
  ]
  build: [
    ["dune" "subst"] {pinned}
    [
      "dune"
      "build"
      "-p"
      name
      "-j"
      jobs
      "@install"
      "@runtest" {with-test}
      "@doc" {with-doc}
    ]
  ]
